/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties.constraints;

import net.sourceforge.pmd.properties.constraints.ConstraintFactory;
import net.sourceforge.pmd.properties.constraints.PropertyConstraint;

public final class NumericConstraints {
    private NumericConstraints() {
    }

    public static <N extends Number> PropertyConstraint<N> inRange(final N minInclusive, final N maxInclusive) {
        return ConstraintFactory.fromPredicate(new ConstraintFactory.Predicate<N>(){

            @Override
            public boolean test(N t) {
                return ((Comparable)((Object)minInclusive)).compareTo(t) <= 0 && ((Comparable)((Object)maxInclusive)).compareTo(t) >= 0;
            }
        }, "Should be between " + minInclusive + " and " + maxInclusive);
    }

    public static <N extends Number> PropertyConstraint<N> positive() {
        return ConstraintFactory.fromPredicate(new ConstraintFactory.Predicate<N>(){

            @Override
            public boolean test(N t) {
                return ((Number)t).intValue() > 0;
            }
        }, "Should be positive");
    }
}

