/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.semantic.ast.member.Method;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexParserVisitor;
import net.sourceforge.pmd.lang.apex.ast.ApexQualifiableNode;
import net.sourceforge.pmd.lang.apex.ast.ApexQualifiedName;
import net.sourceforge.pmd.lang.apex.ast.CanSuppressWarnings;
import net.sourceforge.pmd.lang.apex.metrics.signature.ApexOperationSignature;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.SignedNode;

public class ASTMethod
extends AbstractApexNode<Method>
implements ApexQualifiableNode,
SignedNode<ASTMethod>,
CanSuppressWarnings {
    @Deprecated
    @InternalApi
    public ASTMethod(Method method) {
        super(method);
    }

    @Override
    public Object jjtAccept(ApexParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getImage() {
        return ((Method)this.node).getMethodInfo().getName();
    }

    public String getCanonicalName() {
        return ((Method)this.node).getMethodInfo().getCanonicalName();
    }

    @Override
    public int getBeginLine() {
        if (!this.hasRealLoc()) {
            for (int i = this.getParent().getNumChildren() - 1; i >= 0; --i) {
                Node sibling = this.getParent().getChild(i);
                if (!sibling.hasRealLoc()) continue;
                return sibling.getEndLine();
            }
        }
        return super.getBeginLine();
    }

    @Override
    public int getBeginColumn() {
        if (!this.hasRealLoc()) {
            for (int i = this.getParent().getNumChildren() - 1; i >= 0; --i) {
                Node sibling = this.getParent().getChild(i);
                if (!sibling.hasRealLoc()) continue;
                return sibling.getEndColumn();
            }
        }
        return super.getBeginColumn();
    }

    @Override
    public int getEndLine() {
        if (!this.hasRealLoc()) {
            return this.getBeginLine();
        }
        ASTBlockStatement block = (ASTBlockStatement)this.getFirstChildOfType(ASTBlockStatement.class);
        if (block != null) {
            return block.getEndLine();
        }
        return super.getEndLine();
    }

    @Override
    public int getEndColumn() {
        if (!this.hasRealLoc()) {
            return this.getBeginColumn();
        }
        ASTBlockStatement block = (ASTBlockStatement)this.getFirstChildOfType(ASTBlockStatement.class);
        if (block != null) {
            return block.getEndColumn();
        }
        return super.getEndColumn();
    }

    @Override
    public ApexQualifiedName getQualifiedName() {
        return ApexQualifiedName.ofMethod(this);
    }

    public ApexOperationSignature getSignature() {
        return ApexOperationSignature.of(this);
    }

    @Override
    public boolean hasSuppressWarningsAnnotationFor(Rule rule) {
        for (ASTModifierNode modifier : this.findChildrenOfType(ASTModifierNode.class)) {
            for (ASTAnnotation a : modifier.findChildrenOfType(ASTAnnotation.class)) {
                if (!a.suppresses(rule)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConstructor() {
        return ((Method)this.node).getMethodInfo().isConstructor();
    }

    public ASTModifierNode getModifiers() {
        return (ASTModifierNode)this.getFirstChildOfType(ASTModifierNode.class);
    }

    public String getReturnType() {
        return ((Method)this.node).getMethodInfo().getEmitSignature().getReturnType().getApexName();
    }

    public int getArity() {
        return ((Method)this.node).getMethodInfo().getParameterTypes().size();
    }
}

