/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractInefficientZeroCheck;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinition;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.CollectionUtil;

public class UseCollectionIsEmptyRule
extends AbstractInefficientZeroCheck {
    @Override
    public boolean appliesToClassName(String name) {
        return CollectionUtil.isCollectionType((String)name, (boolean)true);
    }

    @Override
    public boolean isTargetMethod(JavaNameOccurrence occ) {
        return occ.getNameForWhichThisIsAQualifier() != null && occ.getLocation().getImage().endsWith(".size");
    }

    @Override
    public Map<String, List<String>> getComparisonTargets() {
        List<String> zeroAndOne = Arrays.asList("0", "1");
        List<String> zero = Collections.singletonList("0");
        HashMap<String, List<String>> rules = new HashMap<String, List<String>>();
        rules.put("<", zeroAndOne);
        rules.put(">", zero);
        rules.put("==", zero);
        rules.put("!=", zero);
        rules.put(">=", zeroAndOne);
        rules.put("<=", zero);
        return rules;
    }

    @Override
    public Object visit(ASTPrimarySuffix node, Object data) {
        if (this.isSizeMethodCall(node) && this.isCalledOnCollection(node)) {
            JavaNode expr = ((JavaNode)node.getParent()).getParent();
            this.checkNodeAndReport(data, (Node)node, (Node)expr);
        }
        return data;
    }

    private boolean isSizeMethodCall(ASTPrimarySuffix primarySuffix) {
        String calledMethodName = primarySuffix.getImage();
        return calledMethodName != null && "size".equals(calledMethodName);
    }

    private boolean isCalledOnCollection(ASTPrimarySuffix primarySuffix) {
        JavaTypeDefinition calledOnType = this.getTypeOfVariable(primarySuffix);
        if (calledOnType == null) {
            calledOnType = this.getTypeOfMethodCall(primarySuffix);
        }
        return calledOnType != null && CollectionUtil.isCollectionType(calledOnType.getType(), (boolean)true);
    }

    private JavaTypeDefinition getTypeOfVariable(ASTPrimarySuffix primarySuffix) {
        ASTPrimaryExpression primaryExpression = (ASTPrimaryExpression)primarySuffix.getFirstParentOfType(ASTPrimaryExpression.class);
        ASTPrimaryPrefix varPrefix = (ASTPrimaryPrefix)primaryExpression.getFirstChildOfType(ASTPrimaryPrefix.class);
        if (this.prefixWithNoModifiers(varPrefix)) {
            return varPrefix.getTypeDefinition();
        }
        String varName = this.getVariableNameBySuffix(primaryExpression);
        return varName != null ? this.getTypeOfVariableByName(varName, primaryExpression) : null;
    }

    private boolean prefixWithNoModifiers(ASTPrimaryPrefix primaryPrefix) {
        return !primaryPrefix.usesSuperModifier() && !primaryPrefix.usesThisModifier();
    }

    private String getVariableNameBySuffix(ASTPrimaryExpression primaryExpression) {
        ASTPrimarySuffix varSuffix = (ASTPrimarySuffix)primaryExpression.getFirstChildOfType(ASTPrimarySuffix.class);
        return varSuffix.getImage();
    }

    private JavaTypeDefinition getTypeOfVariableByName(String varName, ASTPrimaryExpression expr) {
        Node classOrEnumBody = (Node)expr.getFirstParentOfType(ASTClassOrInterfaceBody.class);
        if (classOrEnumBody == null) {
            classOrEnumBody = (Node)expr.getFirstParentOfType(ASTEnumBody.class);
        }
        List varDeclarators = classOrEnumBody.findDescendantsOfType(ASTVariableDeclarator.class);
        for (ASTVariableDeclarator varDeclarator : varDeclarators) {
            if (!varDeclarator.getName().equals(varName)) continue;
            return varDeclarator.getVariableId().getTypeNode().getTypeDefinition();
        }
        return null;
    }

    private JavaTypeDefinition getTypeOfMethodCall(ASTPrimarySuffix node) {
        JavaTypeDefinition type = null;
        ASTName methodName = (ASTName)((ASTPrimaryPrefix)((JavaNode)node.getParent()).getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstChildOfType(ASTName.class);
        if (methodName != null) {
            ClassScope classScope = (ClassScope)node.getScope().getEnclosingScope(ClassScope.class);
            Map<MethodNameDeclaration, List<NameOccurrence>> methods = classScope.getMethodDeclarations();
            for (Map.Entry<MethodNameDeclaration, List<NameOccurrence>> e : methods.entrySet()) {
                if (!e.getKey().getName().equals(methodName.getImage())) continue;
                type = ((ASTType)((ASTResultType)((ASTMethodDeclaration)e.getKey().getNode().getFirstParentOfType(ASTMethodDeclaration.class)).getFirstChildOfType(ASTResultType.class)).getFirstDescendantOfType(ASTType.class)).getTypeDefinition();
                break;
            }
        }
        return type;
    }
}

