/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.AbstractAccumulatingRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import org.apache.commons.lang3.mutable.MutableInt;

public class SummaryHTMLRenderer
extends AbstractAccumulatingRenderer {
    public static final String NAME = "summaryhtml";

    public SummaryHTMLRenderer() {
        super(NAME, "Summary HTML format.");
        this.definePropertyDescriptor(HTMLRenderer.LINK_PREFIX);
        this.definePropertyDescriptor(HTMLRenderer.LINE_PREFIX);
        this.definePropertyDescriptor(HTMLRenderer.HTML_EXTENSION);
    }

    @Override
    public String defaultFileExtension() {
        return "html";
    }

    @Override
    public void end() throws IOException {
        this.writer.write("<html><head><title>PMD</title></head><body>" + PMD.EOL);
        this.renderSummary();
        this.writer.write("<center><h2>Detail</h2></center>");
        this.writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL);
        HTMLRenderer htmlRenderer = new HTMLRenderer();
        htmlRenderer.setProperty(HTMLRenderer.LINK_PREFIX, this.getProperty(HTMLRenderer.LINK_PREFIX));
        htmlRenderer.setProperty(HTMLRenderer.LINE_PREFIX, this.getProperty(HTMLRenderer.LINE_PREFIX));
        htmlRenderer.setProperty(HTMLRenderer.HTML_EXTENSION, this.getProperty(HTMLRenderer.HTML_EXTENSION));
        htmlRenderer.setShowSuppressedViolations(this.showSuppressedViolations);
        htmlRenderer.setUseShortNames(this.inputPathPrefixes);
        htmlRenderer.renderBody(this.writer, this.report);
        this.writer.write("</tr></table></body></html>" + PMD.EOL);
    }

    public void renderSummary() throws IOException {
        this.writer.write("<center><h2>Summary</h2></center>" + PMD.EOL);
        this.writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\">" + PMD.EOL);
        this.writer.write("<tr><th>Rule name</th><th>Number of violations</th></tr>" + PMD.EOL);
        Map<String, MutableInt> summary = SummaryHTMLRenderer.getSummary(this.report);
        for (Map.Entry<String, MutableInt> entry : summary.entrySet()) {
            String ruleName = entry.getKey();
            this.writer.write("<tr><td>");
            this.writer.write(ruleName);
            this.writer.write("</td><td align=center>");
            this.writer.write(String.valueOf(entry.getValue().intValue()));
            this.writer.write("</td></tr>" + PMD.EOL);
        }
        this.writer.write("</table>" + PMD.EOL);
    }

    private static Map<String, MutableInt> getSummary(Report report) {
        HashMap<String, MutableInt> summary = new HashMap<String, MutableInt>();
        for (RuleViolation rv : report.getViolations()) {
            String name = rv.getRule().getName();
            MutableInt count = (MutableInt)summary.get(name);
            if (count == null) {
                count = new MutableInt(0);
                summary.put(name, count);
            }
            count.increment();
        }
        return summary;
    }
}

