/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.sosl;

import apex.jorje.data.soql.ColonExpr;
import apex.jorje.data.sosl.DivisionValue;
import apex.jorje.data.sosl.WithDivisionClause;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.soql.ColonExprPrinter;

public class WithDivisionPrinter
implements Printer<WithDivisionClause> {
    private static final Printer<WithDivisionClause> INSTANCE = new WithDivisionPrinter(ColonExprPrinter.get());
    private final Printer<ColonExpr> colonExprPrinter;

    private WithDivisionPrinter(Printer<ColonExpr> colonExprPrinter) {
        this.colonExprPrinter = colonExprPrinter;
    }

    public static Printer<WithDivisionClause> get() {
        return INSTANCE;
    }

    @Override
    public String print(WithDivisionClause x, final PrintContext ctx) {
        return "WITH DIVISION = " + x.value.match(new DivisionValue.MatchBlock<String>(){

            @Override
            public String _case(DivisionValue.DivisionLiteral x) {
                return "'" + x.literal + "'";
            }

            @Override
            public String _case(DivisionValue.DivisionExpr x) {
                return WithDivisionPrinter.this.colonExprPrinter.print(x.expr, ctx);
            }
        });
    }
}

