/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.common.base.WeakStringInterner;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public final class TypeEraser {
    private TypeEraser() {
    }

    public static String eraseBytecodeName(TypeInfo type) {
        String rootBytecodeName = GenericTypeInfoUtil.getRootType(type).getBytecodeName();
        if (!CollectionTypeInfoUtil.isMapOrCollection(type)) {
            return rootBytecodeName;
        }
        if (type == TypeInfos.LIST || type == TypeInfos.SET || type == TypeInfos.MAP) {
            return rootBytecodeName;
        }
        ArrayList<String> builder = new ArrayList<String>(type.getTypeArguments().size());
        boolean hasErased = false;
        for (TypeInfo typeArgument : type.getTypeArguments()) {
            String erasedBytecodeName = TypeEraser.eraseBytecodeName(typeArgument);
            hasErased |= erasedBytecodeName != typeArgument.getBytecodeName() || typeArgument.getClass() == ArgumentTypeInfo.class;
            builder.add(erasedBytecodeName);
        }
        return hasErased ? TypeNameUtil.createBytecodeName(rootBytecodeName, builder) : type.getBytecodeName();
    }

    public static String eraseBytecodeNameWithNullCheck(TypeInfo type) {
        if (type == null) {
            return "";
        }
        return TypeEraser.eraseBytecodeName(type);
    }

    public static String[] eraseBytecodeNames(Collection<TypeInfo> types) {
        return (String[])types.stream().map(TypeEraser::eraseBytecodeName).sorted().toArray(String[]::new);
    }

    public static String eraseTypeSignature(TypeInfo type) {
        if (!CollectionTypeInfoUtil.isMapOrCollection(type)) {
            return GenericTypeInfoUtil.getRootType(type).getTypeSignature();
        }
        return TypeNameUtil.createTypeSignature(TypeEraser.eraseBytecodeName(type));
    }

    public static TypeInfo eraseType(SymbolResolver symbols, TypeInfo type) {
        if (!CollectionTypeInfoUtil.isMapOrCollection(type)) {
            return GenericTypeInfoUtil.getRootType(type);
        }
        ArrayList<TypeInfo> typeArguments = new ArrayList<TypeInfo>(type.getTypeArguments().size());
        boolean hasErased = false;
        for (TypeInfo typeArgument : type.getTypeArguments()) {
            TypeInfo erasedType = TypeEraser.eraseType(symbols, typeArgument);
            hasErased |= erasedType != typeArgument;
            typeArguments.add(erasedType);
        }
        if (!hasErased) {
            return type;
        }
        TypeInfo rootType = GenericTypeInfoUtil.getRootType(type);
        return symbols == null ? GenericTypeInfoFactory.create(rootType, typeArguments) : GenericTypeInfoFactory.create(symbols, rootType, typeArguments);
    }

    public static String eraseSignature(Signature signature) {
        String returnTypeSignature = TypeEraser.eraseTypeSignature(signature.getReturnType());
        String erasedSignature = signature.getParameterTypes().stream().map(TypeEraser::eraseTypeSignature).collect(Collectors.joining("", "(", ")" + returnTypeSignature));
        return WeakStringInterner.get().intern(erasedSignature);
    }
}

