/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.TypeInfo;

public class FieldContext {
    private FieldInfo declaration;
    private FieldInfo assignment;

    public boolean isIllegalForwardReference(TypeInfo definingType, MethodInfo method, FieldInfo field, VariableVisitor.Context context) {
        if (this.declaration == field) {
            return false;
        }
        if (definingType != field.getDefiningType()) {
            return false;
        }
        if (context.previous != IdentifierContext.NONE || context.referenceType == ReferenceType.METHOD) {
            return false;
        }
        if (this.assignment == field) {
            return true;
        }
        boolean isInitialization = MethodUtil.isInitializationBlock(method) || method.isStaticInitialization() || MethodUtil.isTriggerInvoke(method) || MethodUtil.isAnonymousExecute(method);
        return isInitialization && Locations.lessThan(context.loc, field.getLoc());
    }

    public void setDeclaration(FieldInfo declaration) {
        this.declaration = declaration;
    }

    public void setAssignment(FieldInfo assignment) {
        this.assignment = assignment;
    }

    public void clear() {
        this.declaration = null;
        this.assignment = null;
    }
}

