/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.hover;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.hover.HoverProvider;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.services.DocumentationService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.visitors.ReferenceSourceVisitor;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Optional;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardHoverProvider
implements HoverProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardHoverProvider.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final DocumentationService documentation;

    @Inject
    public StandardHoverProvider(ApexCompilerService compilerService, ApexDocumentService documentService, DocumentationService documentation) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.documentation = documentation;
    }

    @Override
    public Hover provideHover(TextDocumentPositionParams params) {
        URI docUri = URI.create(params.getTextDocument().getUri());
        Optional<Document> optDoc = this.documentService.retrieve(docUri);
        Hover hover = new Hover();
        hover.setContents(ImmutableList.of(Either.forLeft((Object)"")));
        optDoc.ifPresent(doc -> {
            try {
                ReferenceSourceVisitor visitor = new ReferenceSourceVisitor(Locations.getOffset(doc, params.getPosition()));
                this.compilerService.compile((Document)doc, visitor);
                Optional<Either<TypeInfo, Member>> refSymbol = visitor.getSymbol();
                if (!refSymbol.isPresent()) {
                    return;
                }
                hover.setContents(this.documentation.getDocumentation(refSymbol.get(), true));
            }
            catch (BadLocationException exception) {
                logger.error("Encountered a bad location while providing hover", (Throwable)exception);
            }
        });
        return hover;
    }
}

