/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.cache.AbstractAnalysisCache;
import net.sourceforge.pmd.cache.AnalysisResult;
import net.sourceforge.pmd.cache.CachedRuleViolation;

@Deprecated
@InternalApi
public class FileAnalysisCache
extends AbstractAnalysisCache {
    private final File cacheFile;

    public FileAnalysisCache(File cache) {
        this.cacheFile = cache;
        this.loadFromFile(cache);
    }

    private void loadFromFile(File cacheFile) {
        if (this.cacheExists()) {
            try (DataInputStream inputStream = new DataInputStream(new BufferedInputStream(Files.newInputStream(cacheFile.toPath(), new OpenOption[0])));){
                String cacheVersion = inputStream.readUTF();
                if (PMDVersion.VERSION.equals(cacheVersion)) {
                    this.rulesetChecksum = inputStream.readLong();
                    this.auxClassPathChecksum = inputStream.readLong();
                    this.executionClassPathChecksum = inputStream.readLong();
                    while (inputStream.available() > 0) {
                        String fileName = inputStream.readUTF();
                        long checksum = inputStream.readLong();
                        int countViolations = inputStream.readInt();
                        ArrayList<RuleViolation> violations = new ArrayList<RuleViolation>(countViolations);
                        for (int i = 0; i < countViolations; ++i) {
                            violations.add(CachedRuleViolation.loadFromStream(inputStream, fileName, this.ruleMapper));
                        }
                        this.fileResultsCache.put(fileName, new AnalysisResult(checksum, violations));
                    }
                    LOG.info("Analysis cache loaded");
                } else {
                    LOG.info("Analysis cache invalidated, PMD version changed.");
                }
            }
            catch (EOFException e) {
                LOG.warning("Cache file " + cacheFile.getPath() + " is malformed, will not be used for current analysis");
            }
            catch (IOException e) {
                LOG.severe("Could not load analysis cache from file. " + e.getMessage());
            }
        } else if (cacheFile.isDirectory()) {
            LOG.severe("The configured cache location must be the path to a file, but is a directory.");
        }
    }

    @Override
    public void persist() {
        File parentFile;
        boolean cacheFileShouldBeCreated;
        if (this.cacheFile.isDirectory()) {
            LOG.severe("Cannot persist the cache, the given path points to a directory.");
            return;
        }
        boolean bl = cacheFileShouldBeCreated = !this.cacheFile.exists();
        if (cacheFileShouldBeCreated && (parentFile = this.cacheFile.getAbsoluteFile().getParentFile()) != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        try (DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(this.cacheFile.toPath(), new OpenOption[0])));){
            outputStream.writeUTF(this.pmdVersion);
            outputStream.writeLong(this.rulesetChecksum);
            outputStream.writeLong(this.auxClassPathChecksum);
            outputStream.writeLong(this.executionClassPathChecksum);
            for (Map.Entry resultEntry : this.updatedResultsCache.entrySet()) {
                List<RuleViolation> violations = ((AnalysisResult)resultEntry.getValue()).getViolations();
                outputStream.writeUTF((String)resultEntry.getKey());
                outputStream.writeLong(((AnalysisResult)resultEntry.getValue()).getFileChecksum());
                outputStream.writeInt(violations.size());
                for (RuleViolation rv : violations) {
                    CachedRuleViolation.storeToStream(outputStream, rv);
                }
            }
            if (cacheFileShouldBeCreated) {
                LOG.info("Analysis cache created");
            } else {
                LOG.info("Analysis cache updated");
            }
        }
        catch (IOException e) {
            LOG.severe("Could not persist analysis cache to file. " + e.getMessage());
        }
    }

    @Override
    protected boolean cacheExists() {
        return this.cacheFile.exists() && this.cacheFile.isFile() && this.cacheFile.length() > 0L;
    }
}

