
/*
 +------------------------------------------------------------------------+
 | Phalcon Framework                                                      |
 +------------------------------------------------------------------------+
 | Copyright (c) 2011-2017 Phalcon Team (https://phalconphp.com)          |
 +------------------------------------------------------------------------+
 | This source file is subject to the New BSD License that is bundled     |
 | with this package in the file LICENSE.txt.                             |
 |                                                                        |
 | If you did not receive a copy of the license and are unable to         |
 | obtain it through the world-wide-web, please send an email             |
 | to license@phalconphp.com so we can send you a copy immediately.       |
 +------------------------------------------------------------------------+
 | Authors: Andres Gutierrez <andres@phalconphp.com>                      |
 |          Eduar Carvajal <eduar@phalconphp.com>                         |
 +------------------------------------------------------------------------+
 */

namespace Phalcon\Mvc\Model;

use Phalcon\Mvc\Model\Message;

/**
 * Phalcon\Mvc\Model\Validator
 *
 * This is a base class for Phalcon\Mvc\Model validators
 *
 * This class is only for backward compatibility reasons to use with Phalcon\Mvc\Collection.
 * Otherwise please use the validators provided by Phalcon\Validation.
 *
 * @deprecated 3.1.0
 * @see Phalcon\Validation\Validator
 */
abstract class Validator implements ValidatorInterface
{

	protected _options;

	protected _messages = [];

	/**
	 * Phalcon\Mvc\Model\Validator constructor
	 */
	deprecated public function __construct(array! options)
	{
		let this->_options = options;
	}

	/**
	 * Appends a message to the validator
	 *
	 * @param string message
	 * @param string|array field
	 * @param string type
	 */
	protected function appendMessage(string! message, field = null, type = null)
	{
		if !type {
			let type = str_replace("Validator", "", get_class(this));
		}
		let this->_messages[] = new Message(message, field, type);
	}

	/**
	 * Returns messages generated by the validator
	 */
	public function getMessages() -> array
	{
		return this->_messages;
	}

	/**
	 * Returns all the options from the validator
	 *
	 * @return array
	 */
	public function getOptions()
	{
		return this->_options;
	}

	/**
	 * Returns an option
	 */
	public function getOption(string! option, var defaultValue = "") -> var
	{
		var options, value;
		let options = this->_options;
		if fetch value, options[option] {
			return value;
		}
		return defaultValue;
	}

	/**
	 * Check whether an option has been defined in the validator options
	 */
	public function isSetOption(string! option) -> boolean
	{
		return isset this->_options[option];
	}
}
