/* Generated by re2c 0.13.6 on Wed Jun 10 18:00:58 2015 */
// 1 "scanner.re"

/*
  +------------------------------------------------------------------------+
  | Phalcon Framework													   |
  +------------------------------------------------------------------------+
  | Copyright (c) 2011-2015 Phalcon Team (http://www.phalconphp.com)	   |
  +------------------------------------------------------------------------+
  | This source file is subject to the New BSD License that is bundled	   |
  | with this package in the file docs/LICENSE.txt.					       |
  |																		   |
  | If you did not receive a copy of the license and are unable to		   |
  | obtain it through the world-wide-web, please send an email			   |
  | to license@phalconphp.com so we can send you a copy immediately.	   |
  +------------------------------------------------------------------------+
  | Authors: Andres Gutierrez <andres@phalconphp.com>					   |
  |		  Eduar Carvajal <eduar@phalconphp.com>						       |
  +------------------------------------------------------------------------+
*/

#include "php_phalcon.h"
#include "scanner.h"

#define VVCTYPE unsigned char
#define VVCURSOR (s->start)
#define VVLIMIT (s->end)
#define VVMARKER q

void phvolt_rtrim(phvolt_scanner_token *token) {

	char *cursor, *removed_str;
	int i;
	char ch;

	if (token->len > 0) {

		cursor = token->value;
		cursor += (token->len - 1);
		for (i = token->len; i > 0; i--) {
			ch = (*cursor);
			if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ' || ch == '\v') {
				cursor--;
				continue;
			}
			break;
		}

		if (i >= 0) {
			removed_str = emalloc(i + 1);
			memcpy(removed_str, token->value, i);
			removed_str[i] = '\0';

			efree(token->value);
			token->value = removed_str;
			token->len = i;
		}
	}

}

void phvolt_ltrim(phvolt_scanner_token *token) {

	char *cursor, *removed_str;
	int i;

	if (token->len > 0) {

		cursor = token->value;
		for (i = 0; i < token->len; i++) {
			char ch = (*cursor);
			if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ' || ch == '\v') {
				cursor++;
				continue;
			}
			break;
		}

		if (i >= 0) {
			removed_str = emalloc(token->len - i + 1);
			memcpy(removed_str, token->value + i, token->len - i);
			removed_str[token->len - i] = '\0';

			efree(token->value);
			token->value = removed_str;
			token->len = token->len - i;
		}
	}

}

int phvolt_get_token(phvolt_scanner_state *s, phvolt_scanner_token *token) {

	unsigned char next, double_next;
	char *q = VVCURSOR, *start = VVCURSOR;
	int status = PHVOLT_SCANNER_RETCODE_IMPOSSIBLE;

	while (PHVOLT_SCANNER_RETCODE_IMPOSSIBLE == status) {

		if (s->mode == PHVOLT_MODE_RAW || s->mode == PHVOLT_MODE_COMMENT) {

			next = '\0';
			double_next = '\0';

			if (*VVCURSOR == '\n') {
				s->active_line++;
			}

			if (*VVCURSOR != '\0') {
				next = *(VVCURSOR + 1);
				if (next != '\0') {
					double_next = *(VVCURSOR + 2);
				}
			}

			if (*VVCURSOR == '\0' || (*VVCURSOR == '{' && (next == '%' || next == '{' || next == '#'))) {

				if (next != '#') {

					s->mode = PHVOLT_MODE_CODE;

					if (s->raw_buffer_cursor > 0) {

						token->opcode = PHVOLT_T_RAW_FRAGMENT;
						token->value = emalloc(sizeof(char) * s->raw_buffer_cursor + 1);
						memcpy(token->value, s->raw_buffer, s->raw_buffer_cursor);
						token->value[s->raw_buffer_cursor] = 0;
						token->len = s->raw_buffer_cursor;

						if (s->whitespace_control == 1) {
							phvolt_ltrim(token);
							s->whitespace_control = 0;
						}

						if (double_next == '-') {
							phvolt_rtrim(token);
						}

						s->raw_buffer_cursor = 0;
						q = VVCURSOR;
					} else {
						token->opcode = PHVOLT_T_IGNORE;
					}

				} else {

					while ((next = *(++VVCURSOR))) {
						if (next == '#' && *(VVCURSOR + 1) == '}') {
							VVCURSOR+=2;
							token->opcode = PHVOLT_T_IGNORE;
							return 0;
						} else {
							if (next == '\n') {
								s->active_line++;
							}
						}
					}

					return PHVOLT_SCANNER_RETCODE_EOF;
				}

				return 0;

			} else {

				if (s->raw_buffer_cursor == s->raw_buffer_size) {
					s->raw_buffer_size += PHVOLT_RAW_BUFFER_SIZE;
					s->raw_buffer = erealloc(s->raw_buffer, s->raw_buffer_size);
				}

				memcpy(s->raw_buffer+s->raw_buffer_cursor, VVCURSOR, 1);
				s->raw_buffer_cursor++;

				++VVCURSOR;
			}

		} else {

		
// 181 "scanner.c"
		{
			VVCTYPE vvch;
			unsigned int vvaccept = 0;

			vvch = *VVCURSOR;
			switch (vvch) {
			case 0x00:	goto vv71;
			case '\t':
			case '\r':
			case ' ':	goto vv67;
			case '\n':	goto vv69;
			case '!':	goto vv59;
			case '"':	goto vv28;
			case '%':	goto vv22;
			case '\'':	goto vv30;
			case '(':	goto vv45;
			case ')':	goto vv47;
			case '*':	goto vv35;
			case '+':	goto vv33;
			case ',':	goto vv43;
			case '-':	goto vv24;
			case '.':	goto vv41;
			case '/':	goto vv37;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv2;
			case ':':	goto vv63;
			case '<':	goto vv53;
			case '=':	goto vv55;
			case '>':	goto vv57;
			case '?':	goto vv65;
			case 'A':
			case 'a':	goto vv12;
			case 'B':
			case 'b':	goto vv14;
			case 'C':
			case 'c':	goto vv16;
			case 'D':
			case 'd':	goto vv19;
			case 'E':
			case 'e':	goto vv7;
			case 'F':
			case 'f':	goto vv8;
			case 'G':
			case 'H':
			case 'J':
			case 'K':
			case 'L':
			case 'P':
			case 'Q':
			case 'U':
			case 'V':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'g':
			case 'h':
			case 'j':
			case 'k':
			case 'l':
			case 'p':
			case 'q':
			case 'u':
			case 'v':
			case 'x':
			case 'y':
			case 'z':	goto vv32;
			case 'I':	goto vv4;
			case 'M':
			case 'm':	goto vv15;
			case 'N':
			case 'n':	goto vv10;
			case 'O':
			case 'o':	goto vv13;
			case 'R':
			case 'r':	goto vv18;
			case 'S':
			case 's':	goto vv9;
			case 'T':
			case 't':	goto vv11;
			case 'W':
			case 'w':	goto vv17;
			case '[':	goto vv49;
			case '\\':	goto vv31;
			case ']':	goto vv51;
			case 'i':	goto vv6;
			case '{':	goto vv20;
			case '|':	goto vv61;
			case '}':	goto vv26;
			case '~':	goto vv39;
			default:	goto vv73;
			}
vv2:
			vvaccept = 0;
			vvch = *(VVMARKER = ++VVCURSOR);
			goto vv348;
vv3:
// 182 "scanner.re"
			{
			token->opcode = PHVOLT_T_INTEGER;
			token->value = estrndup(start, VVCURSOR - start);
			token->len = VVCURSOR - start;
			q = VVCURSOR;
			return 0;
		}
// 295 "scanner.c"
vv4:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case 'F':
			case 'f':	goto vv310;
			case 'N':
			case 'n':	goto vv312;
			case 'S':
			case 's':	goto vv314;
			case 'T':
			case 't':	goto vv316;
			default:	goto vv101;
			}
vv5:
// 507 "scanner.re"
			{
			token->opcode = PHVOLT_T_IDENTIFIER;
			token->value = estrndup(start, VVCURSOR - start);
			token->len = VVCURSOR - start;
			q = VVCURSOR;
			return 0;
		}
// 318 "scanner.c"
vv6:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv310;
			case 'N':
			case 'n':	goto vv312;
			case 'S':	goto vv314;
			case 'T':
			case 't':	goto vv316;
			case 's':	goto vv317;
			default:	goto vv101;
			}
vv7:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv238;
			case 'M':
			case 'm':	goto vv239;
			case 'N':
			case 'n':	goto vv240;
			case 'V':
			case 'v':	goto vv241;
			case 'X':
			case 'x':	goto vv242;
			default:	goto vv101;
			}
vv8:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv230;
			case 'O':
			case 'o':	goto vv231;
			default:	goto vv101;
			}
vv9:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv221;
			case 'E':
			case 'e':	goto vv222;
			default:	goto vv101;
			}
vv10:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv208;
			case 'U':
			case 'u':	goto vv209;
			default:	goto vv101;
			}
vv11:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv204;
			default:	goto vv101;
			}
vv12:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv191;
			case 'U':
			case 'u':	goto vv192;
			default:	goto vv101;
			}
vv13:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv186;
			case 'R':
			case 'r':	goto vv187;
			default:	goto vv101;
			}
vv14:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv176;
			case 'R':
			case 'r':	goto vv177;
			default:	goto vv101;
			}
vv15:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv171;
			default:	goto vv101;
			}
vv16:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv155;
			case 'O':
			case 'o':	goto vv156;
			default:	goto vv101;
			}
vv17:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv151;
			default:	goto vv101;
			}
vv18:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv142;
			case 'E':
			case 'e':	goto vv143;
			default:	goto vv101;
			}
vv19:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv133;
			case 'O':
			case 'o':	goto vv134;
			default:	goto vv101;
			}
vv20:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '%':	goto vv127;
			case '{':	goto vv125;
			default:	goto vv21;
			}
vv21:
// 590 "scanner.re"
			{
			token->opcode = PHVOLT_T_CBRACKET_OPEN;
			return 0;
		}
// 462 "scanner.c"
vv22:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '}':	goto vv123;
			default:	goto vv23;
			}
vv23:
// 535 "scanner.re"
			{
			token->opcode = PHVOLT_T_MOD;
			return 0;
		}
// 475 "scanner.c"
vv24:
			vvaccept = 1;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case '%':	goto vv118;
			case '-':	goto vv115;
			case '=':	goto vv113;
			case '}':	goto vv117;
			default:	goto vv25;
			}
vv25:
// 520 "scanner.re"
			{
			token->opcode = PHVOLT_T_SUB;
			return 0;
		}
// 492 "scanner.c"
vv26:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '}':	goto vv111;
			default:	goto vv27;
			}
vv27:
// 595 "scanner.re"
			{
			token->opcode = PHVOLT_T_CBRACKET_CLOSE;
			return 0;
		}
// 505 "scanner.c"
vv28:
			vvaccept = 2;
			vvch = *(VVMARKER = ++VVCURSOR);
			if (vvch >= 0x01) goto vv109;
vv29:
// 706 "scanner.re"
			{
			status = PHVOLT_SCANNER_RETCODE_ERR;
			break;
		}
// 516 "scanner.c"
vv30:
			vvaccept = 2;
			vvch = *(VVMARKER = ++VVCURSOR);
			if (vvch <= 0x00) goto vv29;
			goto vv103;
vv31:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv29;
			}
vv32:
			vvch = *++VVCURSOR;
			goto vv101;
vv33:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '+':	goto vv98;
			case '=':	goto vv96;
			default:	goto vv34;
			}
vv34:
// 515 "scanner.re"
			{
			token->opcode = PHVOLT_T_ADD;
			return 0;
		}
// 596 "scanner.c"
vv35:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv94;
			default:	goto vv36;
			}
vv36:
// 525 "scanner.re"
			{
			token->opcode = PHVOLT_T_MUL;
			return 0;
		}
// 609 "scanner.c"
vv37:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv92;
			default:	goto vv38;
			}
vv38:
// 530 "scanner.re"
			{
			token->opcode = PHVOLT_T_DIV;
			return 0;
		}
// 622 "scanner.c"
vv39:
			++VVCURSOR;
// 550 "scanner.re"
			{
			token->opcode = PHVOLT_T_CONCAT;
			return 0;
		}
// 630 "scanner.c"
vv41:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '.':	goto vv90;
			default:	goto vv42;
			}
vv42:
// 560 "scanner.re"
			{
			token->opcode = PHVOLT_T_DOT;
			return 0;
		}
// 643 "scanner.c"
vv43:
			++VVCURSOR;
// 565 "scanner.re"
			{
			token->opcode = PHVOLT_T_COMMA;
			return 0;
		}
// 651 "scanner.c"
vv45:
			++VVCURSOR;
// 570 "scanner.re"
			{
			token->opcode = PHVOLT_T_PARENTHESES_OPEN;
			return 0;
		}
// 659 "scanner.c"
vv47:
			++VVCURSOR;
// 575 "scanner.re"
			{
			token->opcode = PHVOLT_T_PARENTHESES_CLOSE;
			return 0;
		}
// 667 "scanner.c"
vv49:
			++VVCURSOR;
// 580 "scanner.re"
			{
			token->opcode = PHVOLT_T_SBRACKET_OPEN;
			return 0;
		}
// 675 "scanner.c"
vv51:
			++VVCURSOR;
// 585 "scanner.re"
			{
			token->opcode = PHVOLT_T_SBRACKET_CLOSE;
			return 0;
		}
// 683 "scanner.c"
vv53:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv88;
			case '>':	goto vv86;
			default:	goto vv54;
			}
vv54:
// 665 "scanner.re"
			{
			token->opcode = PHVOLT_T_LESS;
			return 0;
		}
// 697 "scanner.c"
vv55:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv82;
			default:	goto vv56;
			}
vv56:
// 605 "scanner.re"
			{
			token->opcode = PHVOLT_T_ASSIGN;
			return 0;
		}
// 710 "scanner.c"
vv57:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv80;
			default:	goto vv58;
			}
vv58:
// 670 "scanner.re"
			{
			token->opcode = PHVOLT_T_GREATER;
			return 0;
		}
// 723 "scanner.c"
vv59:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv76;
			default:	goto vv60;
			}
vv60:
// 660 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOT;
			return 0;
		}
// 736 "scanner.c"
vv61:
			++VVCURSOR;
// 675 "scanner.re"
			{
			token->opcode = PHVOLT_T_PIPE;
			return 0;
		}
// 744 "scanner.c"
vv63:
			++VVCURSOR;
// 680 "scanner.re"
			{
			token->opcode = PHVOLT_T_COLON;
			return 0;
		}
// 752 "scanner.c"
vv65:
			++VVCURSOR;
// 685 "scanner.re"
			{
			token->opcode = PHVOLT_T_QUESTION;
			return 0;
		}
// 760 "scanner.c"
vv67:
			++VVCURSOR;
			vvch = *VVCURSOR;
			goto vv75;
vv68:
// 690 "scanner.re"
			{
			token->opcode = PHVOLT_T_IGNORE;
			return 0;
		}
// 771 "scanner.c"
vv69:
			++VVCURSOR;
// 695 "scanner.re"
			{
			s->active_line++;
			token->opcode = PHVOLT_T_IGNORE;
			return 0;
		}
// 780 "scanner.c"
vv71:
			++VVCURSOR;
// 701 "scanner.re"
			{
			status = PHVOLT_SCANNER_RETCODE_EOF;
			break;
		}
// 788 "scanner.c"
vv73:
			vvch = *++VVCURSOR;
			goto vv29;
vv74:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv75:
			switch (vvch) {
			case '\t':
			case '\r':
			case ' ':	goto vv74;
			default:	goto vv68;
			}
vv76:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv78;
			default:	goto vv77;
			}
vv77:
// 640 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 814 "scanner.c"
vv78:
			++VVCURSOR;
// 655 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOTIDENTICAL;
			return 0;
		}
// 822 "scanner.c"
vv80:
			++VVCURSOR;
// 630 "scanner.re"
			{
			token->opcode = PHVOLT_T_GREATEREQUAL;
			return 0;
		}
// 830 "scanner.c"
vv82:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv84;
			default:	goto vv83;
			}
vv83:
// 635 "scanner.re"
			{
			token->opcode = PHVOLT_T_EQUALS;
			return 0;
		}
// 843 "scanner.c"
vv84:
			++VVCURSOR;
// 650 "scanner.re"
			{
			token->opcode = PHVOLT_T_IDENTICAL;
			return 0;
		}
// 851 "scanner.c"
vv86:
			++VVCURSOR;
// 645 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 859 "scanner.c"
vv88:
			++VVCURSOR;
// 600 "scanner.re"
			{
			token->opcode = PHVOLT_T_LESSEQUAL;
			return 0;
		}
// 867 "scanner.c"
vv90:
			++VVCURSOR;
// 555 "scanner.re"
			{
			token->opcode = PHVOLT_T_RANGE;
			return 0;
		}
// 875 "scanner.c"
vv92:
			++VVCURSOR;
// 625 "scanner.re"
			{
			token->opcode = PHVOLT_T_DIV_ASSIGN;
			return 0;
		}
// 883 "scanner.c"
vv94:
			++VVCURSOR;
// 620 "scanner.re"
			{
			token->opcode = PHVOLT_T_MUL_ASSIGN;
			return 0;
		}
// 891 "scanner.c"
vv96:
			++VVCURSOR;
// 610 "scanner.re"
			{
			token->opcode = PHVOLT_T_ADD_ASSIGN;
			return 0;
		}
// 899 "scanner.c"
vv98:
			++VVCURSOR;
// 540 "scanner.re"
			{
			token->opcode = PHVOLT_T_INCR;
			return 0;
		}
// 907 "scanner.c"
vv100:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv101:
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv5;
			}
vv102:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv103:
			switch (vvch) {
			case 0x00:	goto vv104;
			case '\'':	goto vv106;
			case '\\':	goto vv105;
			default:	goto vv102;
			}
vv104:
			VVCURSOR = VVMARKER;
			switch (vvaccept) {
			case 0: 	goto vv3;
			case 1: 	goto vv25;
			case 2: 	goto vv29;
			default:	goto vv315;
			}
vv105:
			++VVCURSOR;
			vvch = *VVCURSOR;
			switch (vvch) {
			case '\n':	goto vv104;
			default:	goto vv102;
			}
vv106:
			++VVCURSOR;
// 498 "scanner.re"
			{
			token->opcode = PHVOLT_T_STRING;
			token->value = estrndup(q, VVCURSOR - q - 1);
			token->len = VVCURSOR - q - 1;
			q = VVCURSOR;
			return 0;
		}
// 1014 "scanner.c"
vv108:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv109:
			switch (vvch) {
			case 0x00:	goto vv104;
			case '"':	goto vv106;
			case '\\':	goto vv110;
			default:	goto vv108;
			}
vv110:
			++VVCURSOR;
			vvch = *VVCURSOR;
			switch (vvch) {
			case '\n':	goto vv104;
			default:	goto vv108;
			}
vv111:
			++VVCURSOR;
// 477 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			token->opcode = PHVOLT_T_CLOSE_EDELIMITER;
			return 0;
		}
// 1040 "scanner.c"
vv113:
			++VVCURSOR;
// 615 "scanner.re"
			{
			token->opcode = PHVOLT_T_SUB_ASSIGN;
			return 0;
		}
// 1048 "scanner.c"
vv115:
			++VVCURSOR;
// 545 "scanner.re"
			{
			token->opcode = PHVOLT_T_DECR;
			return 0;
		}
// 1056 "scanner.c"
vv117:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '}':	goto vv121;
			default:	goto vv104;
			}
vv118:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '}':	goto vv119;
			default:	goto vv104;
			}
vv119:
			++VVCURSOR;
// 463 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			s->whitespace_control = 1;
			token->opcode = PHVOLT_T_CLOSE_DELIMITER;
			return 0;
		}
// 1078 "scanner.c"
vv121:
			++VVCURSOR;
// 490 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			s->whitespace_control = 1;
			token->opcode = PHVOLT_T_CLOSE_EDELIMITER;
			return 0;
		}
// 1088 "scanner.c"
vv123:
			++VVCURSOR;
// 451 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			token->opcode = PHVOLT_T_CLOSE_DELIMITER;
			return 0;
		}
// 1097 "scanner.c"
vv125:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '-':	goto vv131;
			default:	goto vv126;
			}
vv126:
// 470 "scanner.re"
			{
			s->whitespace_control = 0;
			s->statement_position++;
			token->opcode = PHVOLT_T_OPEN_EDELIMITER;
			return 0;
		}
// 1112 "scanner.c"
vv127:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '-':	goto vv129;
			default:	goto vv128;
			}
vv128:
// 445 "scanner.re"
			{
			s->whitespace_control = 0;
			token->opcode = PHVOLT_T_OPEN_DELIMITER;
			return 0;
		}
// 1126 "scanner.c"
vv129:
			++VVCURSOR;
// 457 "scanner.re"
			{
			s->whitespace_control = 0;
			token->opcode = PHVOLT_T_OPEN_DELIMITER;
			return 0;
		}
// 1135 "scanner.c"
vv131:
			++VVCURSOR;
// 483 "scanner.re"
			{
			s->whitespace_control = 0;
			s->statement_position++;
			token->opcode = PHVOLT_T_OPEN_EDELIMITER;
			return 0;
		}
// 1145 "scanner.c"
vv133:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv136;
			default:	goto vv101;
			}
vv134:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv135;
			}
vv135:
// 403 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_DO;
			return 0;
		}
// 1229 "scanner.c"
vv136:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv137;
			default:	goto vv101;
			}
vv137:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv138;
			default:	goto vv101;
			}
vv138:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv139;
			default:	goto vv101;
			}
vv139:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv140;
			default:	goto vv101;
			}
vv140:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv141;
			}
vv141:
// 344 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_DEFINED;
			return 0;
		}
// 1334 "scanner.c"
vv142:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'W':
			case 'w':	goto vv149;
			default:	goto vv101;
			}
vv143:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv144;
			default:	goto vv101;
			}
vv144:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv145;
			default:	goto vv101;
			}
vv145:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv146;
			default:	goto vv101;
			}
vv146:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv147;
			default:	goto vv101;
			}
vv147:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv148;
			}
vv148:
// 309 "scanner.re"
			{
			token->opcode = PHVOLT_T_RETURN;
			return 0;
		}
// 1445 "scanner.c"
vv149:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv150;
			}
vv150:
// 433 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_RAW;
			return 0;
		}
// 1522 "scanner.c"
vv151:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv152;
			default:	goto vv101;
			}
vv152:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv153;
			default:	goto vv101;
			}
vv153:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv154;
			}
vv154:
// 304 "scanner.re"
			{
			token->opcode = PHVOLT_T_WITH;
			return 0;
		}
// 1612 "scanner.c"
vv155:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv165;
			case 'L':
			case 'l':	goto vv164;
			default:	goto vv101;
			}
vv156:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv157;
			default:	goto vv101;
			}
vv157:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv158;
			default:	goto vv101;
			}
vv158:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv159;
			default:	goto vv101;
			}
vv159:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv160;
			default:	goto vv101;
			}
vv160:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv161;
			default:	goto vv101;
			}
vv161:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv162;
			default:	goto vv101;
			}
vv162:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv163;
			}
vv163:
// 421 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_CONTINUE;
			return 0;
		}
// 1740 "scanner.c"
vv164:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv169;
			default:	goto vv101;
			}
vv165:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv166;
			default:	goto vv101;
			}
vv166:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv167;
			default:	goto vv101;
			}
vv167:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv168;
			}
vv168:
// 392 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_CACHE;
			return 0;
		}
// 1838 "scanner.c"
vv169:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv170;
			}
vv170:
// 293 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_CALL;
			return 0;
		}
// 1915 "scanner.c"
vv171:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv172;
			default:	goto vv101;
			}
vv172:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv173;
			default:	goto vv101;
			}
vv173:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv174;
			default:	goto vv101;
			}
vv174:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv175;
			}
vv175:
// 282 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_MACRO;
			return 0;
		}
// 2013 "scanner.c"
vv176:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv182;
			default:	goto vv101;
			}
vv177:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv178;
			default:	goto vv101;
			}
vv178:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv179;
			default:	goto vv101;
			}
vv179:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'K':
			case 'k':	goto vv180;
			default:	goto vv101;
			}
vv180:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv181;
			}
vv181:
// 427 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_BREAK;
			return 0;
		}
// 2118 "scanner.c"
vv182:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv183;
			default:	goto vv101;
			}
vv183:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'K':
			case 'k':	goto vv184;
			default:	goto vv101;
			}
vv184:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv185;
			}
vv185:
// 271 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_BLOCK;
			return 0;
		}
// 2209 "scanner.c"
vv186:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv189;
			default:	goto vv101;
			}
vv187:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv188;
			}
vv188:
// 266 "scanner.re"
			{
			token->opcode = PHVOLT_T_OR;
			return 0;
		}
// 2292 "scanner.c"
vv189:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv190;
			}
vv190:
// 368 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ODD;
			return 0;
		}
// 2369 "scanner.c"
vv191:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv202;
			default:	goto vv101;
			}
vv192:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv193;
			default:	goto vv101;
			}
vv193:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv194;
			default:	goto vv101;
			}
vv194:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv195;
			default:	goto vv101;
			}
vv195:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv196;
			default:	goto vv101;
			}
vv196:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv197;
			default:	goto vv101;
			}
vv197:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv198;
			default:	goto vv101;
			}
vv198:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'P':
			case 'p':	goto vv199;
			default:	goto vv101;
			}
vv199:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv200;
			default:	goto vv101;
			}
vv200:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv201;
			}
vv201:
// 409 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_AUTOESCAPE;
			return 0;
		}
// 2509 "scanner.c"
vv202:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv203;
			}
vv203:
// 261 "scanner.re"
			{
			token->opcode = PHVOLT_T_AND;
			return 0;
		}
// 2585 "scanner.c"
vv204:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv205;
			default:	goto vv101;
			}
vv205:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv206;
			default:	goto vv101;
			}
vv206:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv207;
			}
vv207:
// 256 "scanner.re"
			{
			token->opcode = PHVOLT_T_TRUE;
			return 0;
		}
// 2675 "scanner.c"
vv208:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv219;
			default:	goto vv101;
			}
vv209:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv210;
			case 'M':
			case 'm':	goto vv211;
			default:	goto vv101;
			}
vv210:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv217;
			default:	goto vv101;
			}
vv211:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv212;
			default:	goto vv101;
			}
vv212:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv213;
			default:	goto vv101;
			}
vv213:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv214;
			default:	goto vv101;
			}
vv214:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv215;
			default:	goto vv101;
			}
vv215:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv216;
			}
vv216:
// 374 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NUMERIC;
			return 0;
		}
// 2803 "scanner.c"
vv217:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv218;
			}
vv218:
// 246 "scanner.re"
			{
			token->opcode = PHVOLT_T_NULL;
			return 0;
		}
// 2879 "scanner.c"
vv219:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv220;
			}
vv220:
// 338 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NOT;
			return 0;
		}
// 2956 "scanner.c"
vv221:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv225;
			default:	goto vv101;
			}
vv222:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv223;
			default:	goto vv101;
			}
vv223:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv224;
			}
vv224:
// 241 "scanner.re"
			{
			token->opcode = PHVOLT_T_SET;
			return 0;
		}
// 3046 "scanner.c"
vv225:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv226;
			default:	goto vv101;
			}
vv226:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv227;
			default:	goto vv101;
			}
vv227:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv228;
			default:	goto vv101;
			}
vv228:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv229;
			}
vv229:
// 380 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_SCALAR;
			return 0;
		}
// 3144 "scanner.c"
vv230:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv234;
			default:	goto vv101;
			}
vv231:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv232;
			default:	goto vv101;
			}
vv232:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv233;
			}
vv233:
// 225 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_FOR;
			return 0;
		}
// 3235 "scanner.c"
vv234:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv235;
			default:	goto vv101;
			}
vv235:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv236;
			default:	goto vv101;
			}
vv236:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv237;
			}
vv237:
// 251 "scanner.re"
			{
			token->opcode = PHVOLT_T_FALSE;
			return 0;
		}
// 3325 "scanner.c"
vv238:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv300;
			default:	goto vv101;
			}
vv239:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'P':
			case 'p':	goto vv296;
			default:	goto vv101;
			}
vv240:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv252;
			default:	goto vv101;
			}
vv241:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv249;
			default:	goto vv101;
			}
vv242:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv243;
			default:	goto vv101;
			}
vv243:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv244;
			default:	goto vv101;
			}
vv244:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv245;
			default:	goto vv101;
			}
vv245:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv246;
			default:	goto vv101;
			}
vv246:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv247;
			default:	goto vv101;
			}
vv247:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv248;
			}
vv248:
// 314 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_EXTENDS;
			return 0;
		}
// 3465 "scanner.c"
vv249:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv250;
			default:	goto vv101;
			}
vv250:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv251;
			}
vv251:
// 362 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_EVEN;
			return 0;
		}
// 3549 "scanner.c"
vv252:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv253;
			case 'B':
			case 'b':	goto vv254;
			case 'C':
			case 'c':	goto vv255;
			case 'F':
			case 'f':	goto vv256;
			case 'I':
			case 'i':	goto vv257;
			case 'M':
			case 'm':	goto vv258;
			case 'R':
			case 'r':	goto vv259;
			default:	goto vv101;
			}
vv253:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv286;
			default:	goto vv101;
			}
vv254:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv281;
			default:	goto vv101;
			}
vv255:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv273;
			default:	goto vv101;
			}
vv256:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv270;
			default:	goto vv101;
			}
vv257:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv268;
			default:	goto vv101;
			}
vv258:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv263;
			default:	goto vv101;
			}
vv259:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv260;
			default:	goto vv101;
			}
vv260:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'W':
			case 'w':	goto vv261;
			default:	goto vv101;
			}
vv261:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv262;
			}
vv262:
// 439 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ENDRAW;
			return 0;
		}
// 3701 "scanner.c"
vv263:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv264;
			default:	goto vv101;
			}
vv264:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv265;
			default:	goto vv101;
			}
vv265:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv266;
			default:	goto vv101;
			}
vv266:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv267;
			}
vv267:
// 288 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDMACRO;
			return 0;
		}
// 3798 "scanner.c"
vv268:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv269;
			}
vv269:
// 220 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDIF;
			return 0;
		}
// 3874 "scanner.c"
vv270:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv271;
			default:	goto vv101;
			}
vv271:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv272;
			}
vv272:
// 231 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDFOR;
			return 0;
		}
// 3957 "scanner.c"
vv273:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv274;
			case 'L':
			case 'l':	goto vv275;
			default:	goto vv101;
			}
vv274:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv278;
			default:	goto vv101;
			}
vv275:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv276;
			default:	goto vv101;
			}
vv276:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv277;
			}
vv277:
// 299 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDCALL;
			return 0;
		}
// 4056 "scanner.c"
vv278:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv279;
			default:	goto vv101;
			}
vv279:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv280;
			}
vv280:
// 398 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDCACHE;
			return 0;
		}
// 4139 "scanner.c"
vv281:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv282;
			default:	goto vv101;
			}
vv282:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv283;
			default:	goto vv101;
			}
vv283:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'K':
			case 'k':	goto vv284;
			default:	goto vv101;
			}
vv284:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv285;
			}
vv285:
// 277 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDBLOCK;
			return 0;
		}
// 4236 "scanner.c"
vv286:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv287;
			default:	goto vv101;
			}
vv287:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv288;
			default:	goto vv101;
			}
vv288:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv289;
			default:	goto vv101;
			}
vv289:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv290;
			default:	goto vv101;
			}
vv290:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv291;
			default:	goto vv101;
			}
vv291:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv292;
			default:	goto vv101;
			}
vv292:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'P':
			case 'p':	goto vv293;
			default:	goto vv101;
			}
vv293:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv294;
			default:	goto vv101;
			}
vv294:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv295;
			}
vv295:
// 415 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ENDAUTOESCAPE;
			return 0;
		}
// 4369 "scanner.c"
vv296:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv297;
			default:	goto vv101;
			}
vv297:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'Y':
			case 'y':	goto vv298;
			default:	goto vv101;
			}
vv298:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv299;
			}
vv299:
// 356 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_EMPTY;
			return 0;
		}
// 4460 "scanner.c"
vv300:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv301;
			default:	goto vv101;
			}
vv301:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'G':
			case 'H':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'g':
			case 'h':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			case 'F':
			case 'f':	goto vv303;
			case 'I':
			case 'i':	goto vv304;
			default:	goto vv302;
			}
vv302:
// 205 "scanner.re"
			{
			token->opcode = PHVOLT_T_ELSE;
			return 0;
		}
// 4543 "scanner.c"
vv303:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv307;
			default:	goto vv101;
			}
vv304:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv305;
			default:	goto vv101;
			}
vv305:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv306;
			}
vv306:
// 215 "scanner.re"
			{
			token->opcode = PHVOLT_T_ELSEIF;
			return 0;
		}
// 4633 "scanner.c"
vv307:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv308;
			default:	goto vv101;
			}
vv308:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv309;
			}
vv309:
// 210 "scanner.re"
			{
			token->opcode = PHVOLT_T_ELSEFOR;
			return 0;
		}
// 4716 "scanner.c"
vv310:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv311;
			}
vv311:
// 199 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_IF;
			return 0;
		}
// 4793 "scanner.c"
vv312:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			case 'C':
			case 'c':	goto vv340;
			default:	goto vv313;
			}
vv313:
// 236 "scanner.re"
			{
			token->opcode = PHVOLT_T_IN;
			return 0;
		}
// 4869 "scanner.c"
vv314:
			vvaccept = 3;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case ' ':	goto vv339;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv315;
			}
vv315:
// 332 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_IS;
			return 0;
		}
// 4948 "scanner.c"
vv316:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv332;
			default:	goto vv101;
			}
vv317:
			vvaccept = 3;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case ' ':	goto vv318;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv315;
			}
vv318:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':	goto vv322;
			case 'n':	goto vv319;
			default:	goto vv321;
			}
vv319:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':	goto vv323;
			case 'o':	goto vv330;
			default:	goto vv104;
			}
vv320:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv321:
			switch (vvch) {
			case ' ':	goto vv320;
			case 'n':	goto vv326;
			default:	goto vv104;
			}
vv322:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv323;
			default:	goto vv104;
			}
vv323:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv324;
			default:	goto vv104;
			}
vv324:
			++VVCURSOR;
vv325:
// 320 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 5073 "scanner.c"
vv326:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'o':	goto vv327;
			default:	goto vv104;
			}
vv327:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 't':	goto vv328;
			default:	goto vv104;
			}
vv328:
			++VVCURSOR;
// 326 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 5094 "scanner.c"
vv330:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':	goto vv324;
			case 't':	goto vv331;
			default:	goto vv104;
			}
vv331:
			vvch = *++VVCURSOR;
			goto vv325;
vv332:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv333;
			default:	goto vv101;
			}
vv333:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv334;
			default:	goto vv101;
			}
vv334:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'B':
			case 'b':	goto vv335;
			default:	goto vv101;
			}
vv335:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv336;
			default:	goto vv101;
			}
vv336:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv337;
			default:	goto vv101;
			}
vv337:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv338;
			}
vv338:
// 386 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ITERABLE;
			return 0;
		}
// 5216 "scanner.c"
vv339:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv322;
			default:	goto vv104;
			}
vv340:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv341;
			default:	goto vv101;
			}
vv341:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv342;
			default:	goto vv101;
			}
vv342:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv343;
			default:	goto vv101;
			}
vv343:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv344;
			default:	goto vv101;
			}
vv344:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv345;
			}
vv345:
// 350 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_INCLUDE;
			return 0;
		}
// 5328 "scanner.c"
vv346:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv349;
			default:	goto vv104;
			}
vv347:
			vvaccept = 0;
			VVMARKER = ++VVCURSOR;
			vvch = *VVCURSOR;
vv348:
			switch (vvch) {
			case '.':	goto vv346;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv347;
			default:	goto vv3;
			}
vv349:
			++VVCURSOR;
			vvch = *VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv349;
			default:	goto vv351;
			}
vv351:
// 191 "scanner.re"
			{
			token->opcode = PHVOLT_T_DOUBLE;
			token->value = estrndup(start, VVCURSOR - start);
			token->len = VVCURSOR - start;
			q = VVCURSOR;
			return 0;
		}
// 5388 "scanner.c"
		}
// 711 "scanner.re"


		}
	}

	return status;
}
