/* GDCHART 0.10.0dev  GDC.H  2 Nov 2000 */
/* Copyright Bruce Verderaime 1998-2003 */

/*
General header common to chart (xy[z]) and pie
*/

#ifndef _GDC_H
#define _GDC_H

#ifndef _USE_MATH_DEFINES
#define _USE_MATH_DEFINES
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE
#endif
#include <math.h>
/* uncle */
#ifndef M_PI
#define M_PI	3.14159265358979323846
#define M_PI_2	1.57079632679489661923
#endif
#define FUZZ        0.0001

#include <limits.h>
#include <float.h>
#include "gd.h"
#include "gdfonts.h"
#include "gdfontt.h"
#include "gdfontmb.h"
#include "gdfontg.h"
#include "gdfontl.h"
#include "gifencode.h"
#include "array_alloc.h"

/* --- backward compatibility --- */
/* may be removed at a later date */
#define GDC_generate_gif	GDC_generate_img
#define pie_gif				GDC_out_pie
/* ------------------------------ */

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

#define GDC_NOVALUE			-FLT_MAX
#define GDC_NULL			GDC_NOVALUE

#define ABS( x )			( (x)<0.0? -(x): (x) )
#ifndef MAX
#define MAX( x, y )			( (x)>(y)?(x):(y) )
#endif
#ifndef MIN
#define MIN( x, y )			( (x)<(y)?(x):(y) ) 
#endif
#define TO_RAD(o)			( (o)/360.0*(2.0*M_PI) )

#define GDC_NOCOLOR			0x1000000L
#define GDC_DFLTCOLOR		0x2000000L
#define PVRED               0x00FF0000
#define PVGRN               0x0000FF00
#define PVBLU               0x000000FF
#define l2gdcal( c )        ((c)&PVRED)>>16 , ((c)&PVGRN)>>8 , ((c)&0x000000FF)
#define l2gdshd( c )        (((c)&PVRED)>>16)/2 , (((c)&PVGRN)>>8)/2 , (((c)&0x000000FF))/2
#define l2shl( c )          (((c)&0xff000000) + (((((c)&0x00ff0000)>>16)/2)<<16) + (((((c)&0x0000ff00)>>8)/2)<<8) + (((c)&0x000000ff))/2)
#define _gdcntrst(bg)		( ((bg)&0x800000?0x000000:0xFF0000)|	\
							  ((bg)&0x008000?0x000000:0x00FF00)|	\
							  ((bg)&0x000080?0x000000:0x0000FF) )

#define _clrallocate( im, rawclr, bgc ) 	( rawclr )
#define _clrshdallocate( im, rawclr, bgc )	l2shl( rawclr )

typedef enum {
			 GDC_GIF = 0,
			 GDC_JPEG = 1,
			 GDC_PNG = 2,
			 GDC_WBMP = 3					/* as of gd1.8.3 WBMP is black and white only. */
			 } GDC_image_type_t;

/* ordered by size */
enum GDC_font_size { GDC_pad     = 0,
					 GDC_TINY    = 1,
					 GDC_SMALL   = 2,
					 GDC_MEDBOLD = 3,
					 GDC_LARGE   = 4,
					 GDC_GIANT   = 5,
					 GDC_numfonts= 6 };		/* GDC[PIE]_fontc depends on this */

typedef enum {
			 GDC_DESTROY_IMAGE = 0,			/* default */
			 GDC_EXPOSE_IMAGE  = 1,			/* user must call GDC_destroy_image() */
			 GDC_REUSE_IMAGE   = 2			/* i.e., paint on top of */
			 } GDC_HOLD_IMAGE_T;			/* EXPOSE & REUSE */

#ifdef GDC_INCL
struct	GDC_FONT_T	{
					gdFontPtr	f;
					char		h;
					char		w;
					};

typedef enum { GDC_JUSTIFY_RIGHT,
			   GDC_JUSTIFY_CENTER,
			   GDC_JUSTIFY_LEFT } GDC_justify_t;


struct fnt_sz_t	{
				int	w;
				int	h;
				}	GDCfnt_sz( char* str, enum GDC_font_size gdfontsz, char* ttfont, double ttfptsz, double angle, char **status );

int		GDCImageStringNL( gdImagePtr, struct GDC_FONT_T*, char*, double, double, int, int, char*, int, GDC_justify_t, char** );
void	load_font_conversions();
short	cnt_nl( char*, int* );
#endif

#ifdef GDC_LIB
#define EXTERND	extern
#define DEFAULTO(val)
extern struct	GDC_FONT_T	GDC_fontc[];
#else
#define EXTERND
#define DEFAULTO(val) = val
#endif

/**** COMMON OPTIONS ********************************/
#ifndef _GDC_COMMON_OPTIONS
#define _GDC_COMMON_OPTIONS
EXTERND GDC_image_type_t	GDC_image_type		DEFAULTO( GDC_PNG );
EXTERND int					GDC_jpeg_quality	DEFAULTO( -1 );				/* 0-95 */
EXTERND char				GDC_generate_img	DEFAULTO( TRUE );

EXTERND GDC_HOLD_IMAGE_T	GDC_hold_img		DEFAULTO( GDC_DESTROY_IMAGE );
EXTERND void				*GDC_image			DEFAULTO( (void*)NULL );	/* in/out */
#endif
/****************************************************/


void	GDC_destroy_image( void* );
void	out_err( int			IMGWIDTH,
				 int			IMGHEIGHT,
				 gdIOCtx *ctx,
				 unsigned long	BGColor,
				 unsigned long	LineColor,
				 char			*str );

long	get_uniq_color( gdImagePtr	im );

#endif /*!_GDC_H*/

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
