/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parser.php7.lemon"

#include "parser.php7.inc.h"

#line 12 "parser.php7.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    phvolt_TOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is phvolt_TOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    phvolt_ARG_SDECL     A static variable declaration for the %extra_argument
**    phvolt_ARG_PDECL     A parameter declaration for the %extra_argument
**    phvolt_ARG_STORE     Code to store %extra_argument into yypParser
**    phvolt_ARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 131
#define YYACTIONTYPE unsigned short int
#define phvolt_TOKENTYPE phvolt_parser_token*
typedef union {
  phvolt_TOKENTYPE yy0;
  zval yy186;
  int yy261;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define phvolt_ARG_SDECL phvolt_parser_status *status;
#define phvolt_ARG_PDECL ,phvolt_parser_status *status
#define phvolt_ARG_FETCH phvolt_parser_status *status = yypParser->status
#define phvolt_ARG_STORE yypParser->status = status
#define YYNSTATE 365
#define YYNRULE 158
#define YYERRORSYMBOL 89
#define YYERRSYMDT yy261
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */    85,   95,  111,   63,   55,   57,   69,   65,   67,   75,
 /*    10 */    77,   79,   81,   71,   73,   51,   49,   53,   46,   43,
 /*    20 */    59,   92,   61,   87,   90,   91,   99,   83,  365,  245,
 /*    30 */    87,   90,   91,   99,   83,  300,   51,   49,   53,   46,
 /*    40 */    43,   59,   92,   61,   87,   90,   91,   99,   83,   33,
 /*    50 */   110,  299,  194,  215,  198,   85,   95,  196,   63,   55,
 /*    60 */    57,   69,   65,   67,   75,   77,   79,   81,   71,   73,
 /*    70 */    51,   49,   53,   46,   43,   59,   92,   61,   87,   90,
 /*    80 */    91,   99,   83,  331,  176,   85,   95,  195,   63,   55,
 /*    90 */    57,   69,   65,   67,   75,   77,   79,   81,   71,   73,
 /*   100 */    51,   49,   53,   46,   43,   59,   92,   61,   87,   90,
 /*   110 */    91,   99,   83,   35,  265,   85,   95,   39,   63,   55,
 /*   120 */    57,   69,   65,   67,   75,   77,   79,   81,   71,   73,
 /*   130 */    51,   49,   53,   46,   43,   59,   92,   61,   87,   90,
 /*   140 */    91,   99,   83,  347,  342,   92,   61,   87,   90,   91,
 /*   150 */    99,   83,  338,  174,  266,  197,  198,   88,   85,   95,
 /*   160 */   139,   63,   55,   57,   69,   65,   67,   75,   77,   79,
 /*   170 */    81,   71,   73,   51,   49,   53,   46,   43,   59,   92,
 /*   180 */    61,   87,   90,   91,   99,   83,  118,   29,   85,   95,
 /*   190 */   140,   63,   55,   57,   69,   65,   67,   75,   77,   79,
 /*   200 */    81,   71,   73,   51,   49,   53,   46,   43,   59,   92,
 /*   210 */    61,   87,   90,   91,   99,   83,  134,   42,   85,   95,
 /*   220 */   503,   63,   55,   57,   69,   65,   67,   75,   77,   79,
 /*   230 */    81,   71,   73,   51,   49,   53,   46,   43,   59,   92,
 /*   240 */    61,   87,   90,   91,   99,   83,   46,   43,   59,   92,
 /*   250 */    61,   87,   90,   91,   99,   83,  321,  322,  323,  324,
 /*   260 */   325,  326,  504,  111,  144,   94,  309,  327,  146,   85,
 /*   270 */    95,   97,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   280 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   290 */    92,   61,   87,   90,   91,   99,   83,   85,   95,  147,
 /*   300 */    63,   55,   57,   69,   65,   67,   75,   77,   79,   81,
 /*   310 */    71,   73,   51,   49,   53,   46,   43,   59,   92,   61,
 /*   320 */    87,   90,   91,   99,   83,  100,  503,  142,  142,  504,
 /*   330 */   107,  171,  129,  276,  287,  173,  107,  120,  137,  109,
 /*   340 */   145,  116,  120,  141,  141,  114,  105,  116,  120,  115,
 /*   350 */    85,   95,  180,   63,   55,   57,   69,   65,   67,   75,
 /*   360 */    77,   79,   81,   71,   73,   51,   49,   53,   46,   43,
 /*   370 */    59,   92,   61,   87,   90,   91,   99,   83,  187,  183,
 /*   380 */    85,   95,   26,   63,   55,   57,   69,   65,   67,   75,
 /*   390 */    77,   79,   81,   71,   73,   51,   49,   53,   46,   43,
 /*   400 */    59,   92,   61,   87,   90,   91,   99,   83,  192,  190,
 /*   410 */    85,   95,  213,   63,   55,   57,   69,   65,   67,   75,
 /*   420 */    77,   79,   81,   71,   73,   51,   49,   53,   46,   43,
 /*   430 */    59,   92,   61,   87,   90,   91,   99,   83,  100,  217,
 /*   440 */   220,   28,   93,  252,  165,  228,  214,  107,  218,  318,
 /*   450 */   120,  137,  143,  120,  120,  224,  120,  211,  128,  120,
 /*   460 */   259,   85,   95,  219,   63,   55,   57,   69,   65,   67,
 /*   470 */    75,   77,   79,   81,   71,   73,   51,   49,   53,   46,
 /*   480 */    43,   59,   92,   61,   87,   90,   91,   99,   83,   85,
 /*   490 */    95,  230,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   500 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   510 */    92,   61,   87,   90,   91,   99,   83,  234,  262,   85,
 /*   520 */    95,  254,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   530 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   540 */    92,   61,   87,   90,   91,   99,   83,  237,  268,   85,
 /*   550 */    95,  238,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   560 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   570 */    92,   61,   87,   90,   91,   99,   83,  242,  271,   85,
 /*   580 */    95,  293,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   590 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   600 */    92,   61,   87,   90,   91,   99,   83,  249,  274,   85,
 /*   610 */    95,  251,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   620 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   630 */    92,   61,   87,   90,   91,   99,   83,  257,  333,   85,
 /*   640 */    95,  256,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   650 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   660 */    92,   61,   87,   90,   91,   99,   83,  318,  349,   85,
 /*   670 */    95,  258,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   680 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   690 */    92,   61,   87,   90,   91,   99,   83,   85,   95,  277,
 /*   700 */    63,   55,   57,   69,   65,   67,   75,   77,   79,   81,
 /*   710 */    71,   73,   51,   49,   53,   46,   43,   59,   92,   61,
 /*   720 */    87,   90,   91,  227,   83,  524,    1,    2,  286,    4,
 /*   730 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   740 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   750 */    25,   95,  281,   63,   55,   57,   69,   65,   67,   75,
 /*   760 */    77,   79,   81,   71,   73,   51,   49,   53,   46,   43,
 /*   770 */    59,   92,   61,   87,   90,   91,   99,   83,   63,   55,
 /*   780 */    57,   69,   65,   67,   75,   77,   79,   81,   71,   73,
 /*   790 */    51,   49,   53,   46,   43,   59,   92,   61,   87,   90,
 /*   800 */    91,   99,   83,   30,  286,    4,    5,    6,    7,    8,
 /*   810 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   820 */    19,   20,   21,   22,   23,   24,   25,   36,  286,    4,
 /*   830 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   840 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   850 */    25,   55,   57,   69,   65,   67,   75,   77,   79,   81,
 /*   860 */    71,   73,   51,   49,   53,   46,   43,   59,   92,   61,
 /*   870 */    87,   90,   91,   99,   83,  177,  286,    4,    5,    6,
 /*   880 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*   890 */    17,   18,   19,   20,   21,   22,   23,   24,   25,  184,
 /*   900 */   286,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*   910 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   920 */    23,   24,   25,  221,  286,    4,    5,    6,    7,    8,
 /*   930 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   940 */    19,   20,   21,   22,   23,   24,   25,  231,  286,    4,
 /*   950 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   960 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   970 */    25,  239,  286,    4,    5,    6,    7,    8,    9,   10,
 /*   980 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*   990 */    21,   22,   23,   24,   25,  246,  286,    4,    5,    6,
 /*  1000 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*  1010 */    17,   18,   19,   20,   21,   22,   23,   24,   25,  278,
 /*  1020 */   286,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*  1030 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*  1040 */    23,   24,   25,  289,  286,    4,    5,    6,    7,    8,
 /*  1050 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*  1060 */    19,   20,   21,   22,   23,   24,   25,  295,  286,    4,
 /*  1070 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*  1080 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*  1090 */    25,  312,  286,    4,    5,    6,    7,    8,    9,   10,
 /*  1100 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*  1110 */    21,   22,   23,   24,   25,  334,  286,    4,    5,    6,
 /*  1120 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*  1130 */    17,   18,   19,   20,   21,   22,   23,   24,   25,  343,
 /*  1140 */   286,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*  1150 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*  1160 */    23,   24,   25,  350,  286,    4,    5,    6,    7,    8,
 /*  1170 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*  1180 */    19,   20,   21,   22,   23,   24,   25,    3,    4,    5,
 /*  1190 */     6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*  1200 */    16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
 /*  1210 */    27,  235,   32,   34,   40,  170,  172,   41,  283,  181,
 /*  1220 */   100,  188,  191,  193,  169,   45,  168,  285,  288,  120,
 /*  1230 */   216,  292,  120,  132,  178,  294,  120,  120,  120,  225,
 /*  1240 */   366,   26,  298,  236,  437,  243,  438,  250,  131,  260,
 /*  1250 */   263,  303,  269,  272,  275,  305,  282,  284,  255,    4,
 /*  1260 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*  1270 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*  1280 */    25,   27,  235,  358,  360,   40,  170,  172,   48,  357,
 /*  1290 */   181,   31,  188,  191,  193,  252,  354,   50,  130,   52,
 /*  1300 */   120,  216,  252,   54,  306,   56,  131,  308,  316,  120,
 /*  1310 */   225,  120,  259,  307,  236,  120,  243,  120,  250,  259,
 /*  1320 */   260,  263,  317,  269,  272,  275,  311,  282,  284,   58,
 /*  1330 */   315,   60,  319,   27,  235,   38,   62,   40,  170,  172,
 /*  1340 */   320,  120,  181,  120,  188,  191,  193,  330,  120,  337,
 /*  1350 */   252,  339,  252,  216,   37,  340,  229,  252,  310,  328,
 /*  1360 */   346,  185,  225,  222,  353,  232,  236,  259,  243,  259,
 /*  1370 */   250,  356,  260,  263,  259,  269,  272,  275,  359,  282,
 /*  1380 */   284,  361,   69,   65,   67,   75,   77,   79,   81,   71,
 /*  1390 */    73,   51,   49,   53,   46,   43,   59,   92,   61,   87,
 /*  1400 */    90,   91,   99,   83,  362,   27,  235,   64,  363,   40,
 /*  1410 */   170,  172,  364,  179,  181,  252,  188,  191,  193,  120,
 /*  1420 */   252,  290,  252,  244,  252,  216,  252,  290,  301,  290,
 /*  1430 */   240,  290,  259,  290,  225,  120,  290,  259,  236,  259,
 /*  1440 */   243,  259,  250,  259,  260,  263,  247,  269,  272,  275,
 /*  1450 */   279,  282,  284,  290,  290,  290,  290,   27,  235,  209,
 /*  1460 */   290,   40,  170,  172,  290,  212,  181,  186,  188,  191,
 /*  1470 */   193,  290,  290,  253,  290,  332,  290,  216,  290,  290,
 /*  1480 */   199,  201,  203,  205,  207,  120,  225,  120,  290,  252,
 /*  1490 */   236,  252,  243,  296,  250,  290,  260,  263,  313,  269,
 /*  1500 */   272,  275,  335,  282,  284,  290,  259,  252,  259,   27,
 /*  1510 */   235,  252,  290,   40,  170,  172,  290,  344,  181,  290,
 /*  1520 */   188,  191,  193,   66,  259,  290,  290,   68,  259,  216,
 /*  1530 */   290,  223,  290,  252,  290,  120,  290,  290,  225,  120,
 /*  1540 */   290,  290,  236,  290,  243,  290,  250,  290,  260,  263,
 /*  1550 */   259,  269,  272,  275,  252,  282,  284,   70,  290,  252,
 /*  1560 */   290,   27,  235,  252,  290,   40,  170,  172,  290,  120,
 /*  1570 */   181,  259,  188,  191,  193,   72,  259,  290,  252,  290,
 /*  1580 */   259,  216,  290,  290,  290,  290,  290,  120,  290,  290,
 /*  1590 */   225,  233,  290,  290,  236,  259,  243,  351,  250,   74,
 /*  1600 */   260,  263,  290,  269,  272,  275,  290,  282,  284,   76,
 /*  1610 */   290,  120,  290,   27,  235,   78,   80,   40,  170,  172,
 /*  1620 */    82,  120,  181,   84,  188,  191,  193,  120,  120,  290,
 /*  1630 */   290,   86,  120,  216,  290,  120,  290,   89,  290,   96,
 /*  1640 */   290,  290,  225,  120,  290,  290,  236,  241,  243,  120,
 /*  1650 */   250,  120,  260,  263,  290,  269,  272,  275,  252,  282,
 /*  1660 */   284,   98,  290,  290,  290,   27,  235,  102,  104,   40,
 /*  1670 */   170,  172,  119,  120,  181,  259,  188,  191,  193,  120,
 /*  1680 */   120,  290,  290,  135,  120,  216,  290,  167,  290,  290,
 /*  1690 */   290,  175,  290,  290,  225,  120,  290,  290,  236,  120,
 /*  1700 */   243,  248,  250,  120,  260,  263,  290,  269,  272,  275,
 /*  1710 */   290,  282,  284,  182,  290,  189,  290,   27,  235,  290,
 /*  1720 */   200,   40,  170,  172,  202,  120,  181,  120,  188,  191,
 /*  1730 */   193,  204,  120,  206,  290,  208,  120,  216,  290,  210,
 /*  1740 */   290,  226,  290,  120,  290,  120,  225,  120,  290,  290,
 /*  1750 */   236,  120,  243,  120,  250,  290,  260,  263,  290,  269,
 /*  1760 */   272,  275,  280,  282,  284,  261,  290,  264,  290,   27,
 /*  1770 */   235,  290,  267,   40,  170,  172,  270,  120,  181,  120,
 /*  1780 */   188,  191,  193,  273,  120,  341,  290,  348,  120,  216,
 /*  1790 */   290,  290,  290,  290,  290,  120,  290,  120,  225,  120,
 /*  1800 */   290,  290,  236,  290,  243,  290,  250,  290,  260,  263,
 /*  1810 */   290,  269,  272,  275,  291,  282,  284,  290,  290,  290,
 /*  1820 */   290,   27,  235,  290,  290,   40,  170,  172,  290,  290,
 /*  1830 */   181,  290,  188,  191,  193,  290,  290,  290,  290,  290,
 /*  1840 */   290,  216,  290,  290,  290,  290,  290,  290,  290,  290,
 /*  1850 */   225,  290,  290,  290,  236,  290,  243,  297,  250,  290,
 /*  1860 */   260,  263,  290,  269,  272,  275,  290,  282,  284,  290,
 /*  1870 */   290,  290,  290,   27,  235,  290,  290,   40,  170,  172,
 /*  1880 */   290,  290,  181,  290,  188,  191,  193,  290,  290,  290,
 /*  1890 */   290,  290,  290,  216,  290,  290,  290,  290,  290,  290,
 /*  1900 */   290,  290,  225,  290,  290,  290,  236,  302,  243,  290,
 /*  1910 */   250,  290,  260,  263,  290,  269,  272,  275,  290,  282,
 /*  1920 */   284,  290,  290,  290,  290,   27,  235,  290,  290,   40,
 /*  1930 */   170,  172,  290,  290,  181,  290,  188,  191,  193,  290,
 /*  1940 */   290,  290,  290,  290,  290,  216,  290,  314,  290,  290,
 /*  1950 */   290,  290,  290,  290,  225,  290,  290,  290,  236,  290,
 /*  1960 */   243,  290,  250,  290,  260,  263,  290,  269,  272,  275,
 /*  1970 */   290,  282,  284,  290,  290,  290,  290,   27,  235,  290,
 /*  1980 */   290,   40,  170,  172,  290,  290,  181,  329,  188,  191,
 /*  1990 */   193,  290,  290,  290,  290,  290,  290,  216,  290,  290,
 /*  2000 */   290,  290,  290,  290,  290,  290,  225,  290,  290,  290,
 /*  2010 */   236,  290,  243,  290,  250,  290,  260,  263,  290,  269,
 /*  2020 */   272,  275,  290,  282,  284,  290,  290,  290,  290,   27,
 /*  2030 */   235,  290,  290,   40,  170,  172,  290,  336,  181,  290,
 /*  2040 */   188,  191,  193,  290,  290,  290,  290,  290,  290,  216,
 /*  2050 */   290,  290,  290,  290,  290,  290,  290,  290,  225,  290,
 /*  2060 */   290,  290,  236,  290,  243,  290,  250,  290,  260,  263,
 /*  2070 */   290,  269,  272,  275,  290,  282,  284,  290,  290,  290,
 /*  2080 */   290,   27,  235,  290,  290,   40,  170,  172,  290,  345,
 /*  2090 */   181,  290,  188,  191,  193,  290,  290,  290,  290,  290,
 /*  2100 */   290,  216,  290,  290,  290,  290,  290,  290,  290,  290,
 /*  2110 */   225,  290,  290,  290,  236,  290,  243,  290,  250,  290,
 /*  2120 */   260,  263,  290,  269,  272,  275,  290,  282,  284,  290,
 /*  2130 */   290,  290,  290,   27,  235,  290,  290,   40,  170,  172,
 /*  2140 */   290,  352,  181,  290,  188,  191,  193,  290,  290,  290,
 /*  2150 */   290,  290,  290,  216,  290,  290,  290,  290,  290,  290,
 /*  2160 */   290,  290,  225,  290,  290,  290,  236,  290,  243,  290,
 /*  2170 */   250,  290,  260,  263,  290,  269,  272,  275,  290,  282,
 /*  2180 */   284,  290,  290,  290,  290,   27,  235,  355,  290,   40,
 /*  2190 */   170,  172,  290,  290,  181,  290,  188,  191,  193,  290,
 /*  2200 */   290,  290,  290,  290,  290,  216,  290,  290,  290,  290,
 /*  2210 */   290,  290,  290,  290,  225,  290,  290,  290,  236,  290,
 /*  2220 */   243,  290,  250,  290,  260,  263,  290,  269,  272,  275,
 /*  2230 */   290,  282,  284,  290,  290,  290,  290,   27,  235,  290,
 /*  2240 */   290,   40,  170,  172,  290,  290,  181,  290,  188,  191,
 /*  2250 */   193,  290,  290,  290,  290,  290,  290,  216,  290,  290,
 /*  2260 */   290,  290,  290,  290,  290,  290,  225,  290,  290,  290,
 /*  2270 */   236,  290,  243,  290,  250,  290,  260,  263,  290,  269,
 /*  2280 */   272,  275,  290,  282,  284,  290,  290,  290,   47,   44,
 /*  2290 */   290,  106,  290,  101,  290,  290,  103,  290,   47,   44,
 /*  2300 */   290,  106,  290,  101,  290,  121,  103,  290,  290,  290,
 /*  2310 */   290,  290,  290,  290,  290,  121,  290,  290,  290,  290,
 /*  2320 */   290,  122,  123,  124,  125,  126,  127,  290,  290,  290,
 /*  2330 */   290,  122,  123,  124,  125,  126,  127,  290,  290,  290,
 /*  2340 */   290,  290,  290,  290,  290,  290,  290,  157,  158,  159,
 /*  2350 */   160,  161,  162,  163,  112,  290,  290,  150,  151,  152,
 /*  2360 */   153,  154,  155,  156,  112,  290,  290,  166,  290,   47,
 /*  2370 */    44,  290,  106,  290,  101,  290,  164,  103,  290,   47,
 /*  2380 */    44,  290,  106,  290,  101,  290,  121,  103,  290,  290,
 /*  2390 */   290,  290,  290,  290,  290,  290,  121,  290,  290,  290,
 /*  2400 */   290,  290,  122,  123,  124,  125,  126,  127,  138,  290,
 /*  2410 */   290,  290,  122,  123,  124,  125,  126,  127,  290,  290,
 /*  2420 */   290,  290,  290,  290,   47,   44,  290,  106,  290,  101,
 /*  2430 */   290,  290,  103,  290,  290,  112,  290,  290,  290,   47,
 /*  2440 */    44,  149,  106,  290,  101,  112,  290,  103,  290,  290,
 /*  2450 */   290,  290,  290,  290,  290,  290,  121,  148,  123,  124,
 /*  2460 */   125,  126,  127,   47,   44,  290,  106,  290,  101,  290,
 /*  2470 */   136,  103,  122,  133,  124,  125,  126,  127,   47,   44,
 /*  2480 */   121,  106,  290,  101,  290,  290,  103,  290,  290,  290,
 /*  2490 */   112,  290,  108,  290,  290,  121,  122,  117,  124,  125,
 /*  2500 */   126,  127,  290,  290,  290,  112,  290,  290,  290,  290,
 /*  2510 */   290,  122,  117,  124,  125,  126,  127,   47,   44,  290,
 /*  2520 */   106,  290,  101,   47,   44,  103,  106,  290,  101,  112,
 /*  2530 */   290,  103,  290,  290,  121,  290,  290,  290,  290,  290,
 /*  2540 */   121,  290,  290,  290,  112,  113,  290,  290,  304,  290,
 /*  2550 */   122,  133,  124,  125,  126,  127,  122,  123,  124,  125,
 /*  2560 */   126,  127,   47,   44,  290,  106,  290,  101,  290,  290,
 /*  2570 */   103,  290,  290,   47,   44,  290,  106,  290,  101,  121,
 /*  2580 */   290,  103,  290,  112,  290,  290,  290,  290,  290,  112,
 /*  2590 */   121,  290,  290,  290,  290,  122,  117,  124,  125,  126,
 /*  2600 */   127,  290,  290,  290,  290,  290,  122,  133,  124,  125,
 /*  2610 */   126,  127,  290,  290,  290,  290,  290,  290,  290,  290,
 /*  2620 */   290,  290,  290,  290,  290,  290,  290,  290,  112,  290,
 /*  2630 */   290,  290,  290,  290,  290,  290,  290,  290,  290,  112,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */     3,    4,    2,    6,    7,    8,    9,   10,   11,   12,
 /*    10 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*    20 */    23,   24,   25,   26,   27,   28,   29,   30,    0,   32,
 /*    30 */    26,   27,   28,   29,   30,   38,   18,   19,   20,   21,
 /*    40 */    22,   23,   24,   25,   26,   27,   28,   29,   30,   32,
 /*    50 */    50,   54,  117,  118,  119,    3,    4,    2,    6,    7,
 /*    60 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*    70 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*    80 */    28,   29,   30,   31,   32,    3,    4,   32,    6,    7,
 /*    90 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   100 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   110 */    28,   29,   30,   32,   32,    3,    4,   32,    6,    7,
 /*   120 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   130 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   140 */    28,   29,   30,   31,   32,   24,   25,   26,   27,   28,
 /*   150 */    29,   30,    2,    3,   72,  118,  119,    3,    3,    4,
 /*   160 */   126,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   170 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   180 */    25,   26,   27,   28,   29,   30,    5,   32,    3,    4,
 /*   190 */    50,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   200 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   210 */    25,   26,   27,   28,   29,   30,    5,   32,    3,    4,
 /*   220 */    50,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   230 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   240 */    25,   26,   27,   28,   29,   30,   21,   22,   23,   24,
 /*   250 */    25,   26,   27,   28,   29,   30,   54,   55,   56,   57,
 /*   260 */    58,   59,   50,    2,    5,   50,  120,  121,  126,    3,
 /*   270 */     4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   280 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   290 */    24,   25,   26,   27,   28,   29,   30,    3,    4,   50,
 /*   300 */     6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*   310 */    16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
 /*   320 */    26,   27,   28,   29,   30,  116,    5,   38,   38,    5,
 /*   330 */   116,   32,  123,   58,   59,   38,  116,  128,  129,  125,
 /*   340 */    50,  127,  128,   54,   54,  125,   52,  127,  128,   88,
 /*   350 */     3,    4,   32,    6,    7,    8,    9,   10,   11,   12,
 /*   360 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   370 */    23,   24,   25,   26,   27,   28,   29,   30,   32,   32,
 /*   380 */     3,    4,    1,    6,    7,    8,    9,   10,   11,   12,
 /*   390 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   400 */    23,   24,   25,   26,   27,   28,   29,   30,   32,   32,
 /*   410 */     3,    4,   38,    6,    7,    8,    9,   10,   11,   12,
 /*   420 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   430 */    23,   24,   25,   26,   27,   28,   29,   30,  116,   38,
 /*   440 */    32,  116,  116,   62,  116,  123,  119,  116,   29,   38,
 /*   450 */   128,  129,  126,  128,  128,   32,  128,   50,  127,  128,
 /*   460 */    79,    3,    4,   52,    6,    7,    8,    9,   10,   11,
 /*   470 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*   480 */    22,   23,   24,   25,   26,   27,   28,   29,   30,    3,
 /*   490 */     4,   32,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   500 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   510 */    24,   25,   26,   27,   28,   29,   30,   32,   32,    3,
 /*   520 */     4,   63,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   530 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   540 */    24,   25,   26,   27,   28,   29,   30,   38,   32,    3,
 /*   550 */     4,   32,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   560 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   570 */    24,   25,   26,   27,   28,   29,   30,   32,   32,    3,
 /*   580 */     4,  124,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   590 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   600 */    24,   25,   26,   27,   28,   29,   30,   32,   32,    3,
 /*   610 */     4,   32,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   620 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   630 */    24,   25,   26,   27,   28,   29,   30,   69,   32,    3,
 /*   640 */     4,    1,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   650 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   660 */    24,   25,   26,   27,   28,   29,   30,   38,   32,    3,
 /*   670 */     4,   32,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   680 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   690 */    24,   25,   26,   27,   28,   29,   30,    3,    4,   32,
 /*   700 */     6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*   710 */    16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
 /*   720 */    26,   27,   28,   29,   30,   90,   91,   92,   93,   94,
 /*   730 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   740 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*   750 */   115,    4,   32,    6,    7,    8,    9,   10,   11,   12,
 /*   760 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   770 */    23,   24,   25,   26,   27,   28,   29,   30,    6,    7,
 /*   780 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   790 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   800 */    28,   29,   30,   92,   93,   94,   95,   96,   97,   98,
 /*   810 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   820 */   109,  110,  111,  112,  113,  114,  115,   92,   93,   94,
 /*   830 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   840 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*   850 */   115,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*   860 */    16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
 /*   870 */    26,   27,   28,   29,   30,   92,   93,   94,   95,   96,
 /*   880 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   890 */   107,  108,  109,  110,  111,  112,  113,  114,  115,   92,
 /*   900 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   910 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*   920 */   113,  114,  115,   92,   93,   94,   95,   96,   97,   98,
 /*   930 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   940 */   109,  110,  111,  112,  113,  114,  115,   92,   93,   94,
 /*   950 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   960 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*   970 */   115,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   980 */   101,  102,  103,  104,  105,  106,  107,  108,  109,  110,
 /*   990 */   111,  112,  113,  114,  115,   92,   93,   94,   95,   96,
 /*  1000 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1010 */   107,  108,  109,  110,  111,  112,  113,  114,  115,   92,
 /*  1020 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  1030 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  1040 */   113,  114,  115,   92,   93,   94,   95,   96,   97,   98,
 /*  1050 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*  1060 */   109,  110,  111,  112,  113,  114,  115,   92,   93,   94,
 /*  1070 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1080 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*  1090 */   115,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*  1100 */   101,  102,  103,  104,  105,  106,  107,  108,  109,  110,
 /*  1110 */   111,  112,  113,  114,  115,   92,   93,   94,   95,   96,
 /*  1120 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1130 */   107,  108,  109,  110,  111,  112,  113,  114,  115,   92,
 /*  1140 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  1150 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  1160 */   113,  114,  115,   92,   93,   94,   95,   96,   97,   98,
 /*  1170 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*  1180 */   109,  110,  111,  112,  113,  114,  115,   93,   94,   95,
 /*  1190 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1200 */   106,  107,  108,  109,  110,  111,  112,  113,  114,  115,
 /*  1210 */    31,   32,   33,   34,   35,   36,   37,  116,   32,   40,
 /*  1220 */   116,   42,   43,   44,  116,  116,  116,   32,   32,  128,
 /*  1230 */    51,   32,  128,  129,    1,   32,  128,  128,  128,   60,
 /*  1240 */     0,    1,   32,   64,   32,   66,   32,   68,    2,   70,
 /*  1250 */    71,   32,   73,   74,   75,   32,   77,   78,   93,   94,
 /*  1260 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1270 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*  1280 */   115,   31,   32,   33,   34,   35,   36,   37,  116,    1,
 /*  1290 */    40,    1,   42,   43,   44,   62,    1,  116,   52,  116,
 /*  1300 */   128,   51,   62,  116,    1,  116,    2,   32,    2,  128,
 /*  1310 */    60,  128,   79,   61,   64,  128,   66,  128,   68,   79,
 /*  1320 */    70,   71,  121,   73,   74,   75,   32,   77,   78,  116,
 /*  1330 */    32,  116,   45,   31,   32,   33,  116,   35,   36,   37,
 /*  1340 */   122,  128,   40,  128,   42,   43,   44,   32,  128,   32,
 /*  1350 */    62,   38,   62,   51,    1,    3,   52,   62,   52,    1,
 /*  1360 */    32,    1,   60,    1,   32,    1,   64,   79,   66,   79,
 /*  1370 */    68,   32,   70,   71,   79,   73,   74,   75,   32,   77,
 /*  1380 */    78,   32,    9,   10,   11,   12,   13,   14,   15,   16,
 /*  1390 */    17,   18,   19,   20,   21,   22,   23,   24,   25,   26,
 /*  1400 */    27,   28,   29,   30,    1,   31,   32,  116,   33,   35,
 /*  1410 */    36,   37,   32,   39,   40,   62,   42,   43,   44,  128,
 /*  1420 */    62,  130,   62,  116,   62,   51,   62,  130,    1,  130,
 /*  1430 */     1,  130,   79,  130,   60,  128,  130,   79,   64,   79,
 /*  1440 */    66,   79,   68,   79,   70,   71,    1,   73,   74,   75,
 /*  1450 */     1,   77,   78,  130,  130,  130,  130,   31,   32,   24,
 /*  1460 */   130,   35,   36,   37,  130,   30,   40,   41,   42,   43,
 /*  1470 */    44,  130,    1,  116,  130,  116,  130,   51,  130,  130,
 /*  1480 */    45,   46,   47,   48,   49,  128,   60,  128,  130,   62,
 /*  1490 */    64,   62,   66,    1,   68,  130,   70,   71,    1,   73,
 /*  1500 */    74,   75,    1,   77,   78,  130,   79,   62,   79,   31,
 /*  1510 */    32,   62,  130,   35,   36,   37,  130,    1,   40,  130,
 /*  1520 */    42,   43,   44,  116,   79,  130,  130,  116,   79,   51,
 /*  1530 */   130,   53,  130,   62,  130,  128,  130,  130,   60,  128,
 /*  1540 */   130,  130,   64,  130,   66,  130,   68,  130,   70,   71,
 /*  1550 */    79,   73,   74,   75,   62,   77,   78,  116,  130,   62,
 /*  1560 */   130,   31,   32,   62,  130,   35,   36,   37,  130,  128,
 /*  1570 */    40,   79,   42,   43,   44,  116,   79,  130,   62,  130,
 /*  1580 */    79,   51,  130,  130,  130,  130,  130,  128,  130,  130,
 /*  1590 */    60,   61,  130,  130,   64,   79,   66,    1,   68,  116,
 /*  1600 */    70,   71,  130,   73,   74,   75,  130,   77,   78,  116,
 /*  1610 */   130,  128,  130,   31,   32,  116,  116,   35,   36,   37,
 /*  1620 */   116,  128,   40,  116,   42,   43,   44,  128,  128,  130,
 /*  1630 */   130,  116,  128,   51,  130,  128,  130,  116,  130,  116,
 /*  1640 */   130,  130,   60,  128,  130,  130,   64,   65,   66,  128,
 /*  1650 */    68,  128,   70,   71,  130,   73,   74,   75,   62,   77,
 /*  1660 */    78,  116,  130,  130,  130,   31,   32,  116,  116,   35,
 /*  1670 */    36,   37,  116,  128,   40,   79,   42,   43,   44,  128,
 /*  1680 */   128,  130,  130,  116,  128,   51,  130,  116,  130,  130,
 /*  1690 */   130,  116,  130,  130,   60,  128,  130,  130,   64,  128,
 /*  1700 */    66,   67,   68,  128,   70,   71,  130,   73,   74,   75,
 /*  1710 */   130,   77,   78,  116,  130,  116,  130,   31,   32,  130,
 /*  1720 */   116,   35,   36,   37,  116,  128,   40,  128,   42,   43,
 /*  1730 */    44,  116,  128,  116,  130,  116,  128,   51,  130,  116,
 /*  1740 */   130,  116,  130,  128,  130,  128,   60,  128,  130,  130,
 /*  1750 */    64,  128,   66,  128,   68,  130,   70,   71,  130,   73,
 /*  1760 */    74,   75,   76,   77,   78,  116,  130,  116,  130,   31,
 /*  1770 */    32,  130,  116,   35,   36,   37,  116,  128,   40,  128,
 /*  1780 */    42,   43,   44,  116,  128,  116,  130,  116,  128,   51,
 /*  1790 */   130,  130,  130,  130,  130,  128,  130,  128,   60,  128,
 /*  1800 */   130,  130,   64,  130,   66,  130,   68,  130,   70,   71,
 /*  1810 */   130,   73,   74,   75,   76,   77,   78,  130,  130,  130,
 /*  1820 */   130,   31,   32,  130,  130,   35,   36,   37,  130,  130,
 /*  1830 */    40,  130,   42,   43,   44,  130,  130,  130,  130,  130,
 /*  1840 */   130,   51,  130,  130,  130,  130,  130,  130,  130,  130,
 /*  1850 */    60,  130,  130,  130,   64,  130,   66,   67,   68,  130,
 /*  1860 */    70,   71,  130,   73,   74,   75,  130,   77,   78,  130,
 /*  1870 */   130,  130,  130,   31,   32,  130,  130,   35,   36,   37,
 /*  1880 */   130,  130,   40,  130,   42,   43,   44,  130,  130,  130,
 /*  1890 */   130,  130,  130,   51,  130,  130,  130,  130,  130,  130,
 /*  1900 */   130,  130,   60,  130,  130,  130,   64,   65,   66,  130,
 /*  1910 */    68,  130,   70,   71,  130,   73,   74,   75,  130,   77,
 /*  1920 */    78,  130,  130,  130,  130,   31,   32,  130,  130,   35,
 /*  1930 */    36,   37,  130,  130,   40,  130,   42,   43,   44,  130,
 /*  1940 */   130,  130,  130,  130,  130,   51,  130,   53,  130,  130,
 /*  1950 */   130,  130,  130,  130,   60,  130,  130,  130,   64,  130,
 /*  1960 */    66,  130,   68,  130,   70,   71,  130,   73,   74,   75,
 /*  1970 */   130,   77,   78,  130,  130,  130,  130,   31,   32,  130,
 /*  1980 */   130,   35,   36,   37,  130,  130,   40,   41,   42,   43,
 /*  1990 */    44,  130,  130,  130,  130,  130,  130,   51,  130,  130,
 /*  2000 */   130,  130,  130,  130,  130,  130,   60,  130,  130,  130,
 /*  2010 */    64,  130,   66,  130,   68,  130,   70,   71,  130,   73,
 /*  2020 */    74,   75,  130,   77,   78,  130,  130,  130,  130,   31,
 /*  2030 */    32,  130,  130,   35,   36,   37,  130,   39,   40,  130,
 /*  2040 */    42,   43,   44,  130,  130,  130,  130,  130,  130,   51,
 /*  2050 */   130,  130,  130,  130,  130,  130,  130,  130,   60,  130,
 /*  2060 */   130,  130,   64,  130,   66,  130,   68,  130,   70,   71,
 /*  2070 */   130,   73,   74,   75,  130,   77,   78,  130,  130,  130,
 /*  2080 */   130,   31,   32,  130,  130,   35,   36,   37,  130,   39,
 /*  2090 */    40,  130,   42,   43,   44,  130,  130,  130,  130,  130,
 /*  2100 */   130,   51,  130,  130,  130,  130,  130,  130,  130,  130,
 /*  2110 */    60,  130,  130,  130,   64,  130,   66,  130,   68,  130,
 /*  2120 */    70,   71,  130,   73,   74,   75,  130,   77,   78,  130,
 /*  2130 */   130,  130,  130,   31,   32,  130,  130,   35,   36,   37,
 /*  2140 */   130,   39,   40,  130,   42,   43,   44,  130,  130,  130,
 /*  2150 */   130,  130,  130,   51,  130,  130,  130,  130,  130,  130,
 /*  2160 */   130,  130,   60,  130,  130,  130,   64,  130,   66,  130,
 /*  2170 */    68,  130,   70,   71,  130,   73,   74,   75,  130,   77,
 /*  2180 */    78,  130,  130,  130,  130,   31,   32,   33,  130,   35,
 /*  2190 */    36,   37,  130,  130,   40,  130,   42,   43,   44,  130,
 /*  2200 */   130,  130,  130,  130,  130,   51,  130,  130,  130,  130,
 /*  2210 */   130,  130,  130,  130,   60,  130,  130,  130,   64,  130,
 /*  2220 */    66,  130,   68,  130,   70,   71,  130,   73,   74,   75,
 /*  2230 */   130,   77,   78,  130,  130,  130,  130,   31,   32,  130,
 /*  2240 */   130,   35,   36,   37,  130,  130,   40,  130,   42,   43,
 /*  2250 */    44,  130,  130,  130,  130,  130,  130,   51,  130,  130,
 /*  2260 */   130,  130,  130,  130,  130,  130,   60,  130,  130,  130,
 /*  2270 */    64,  130,   66,  130,   68,  130,   70,   71,  130,   73,
 /*  2280 */    74,   75,  130,   77,   78,  130,  130,  130,   21,   22,
 /*  2290 */   130,   24,  130,   26,  130,  130,   29,  130,   21,   22,
 /*  2300 */   130,   24,  130,   26,  130,   38,   29,  130,  130,  130,
 /*  2310 */   130,  130,  130,  130,  130,   38,  130,  130,  130,  130,
 /*  2320 */   130,   54,   55,   56,   57,   58,   59,  130,  130,  130,
 /*  2330 */   130,   54,   55,   56,   57,   58,   59,  130,  130,  130,
 /*  2340 */   130,  130,  130,  130,  130,  130,  130,   80,   81,   82,
 /*  2350 */    83,   84,   85,   86,   87,  130,  130,   80,   81,   82,
 /*  2360 */    83,   84,   85,   86,   87,  130,  130,   19,  130,   21,
 /*  2370 */    22,  130,   24,  130,   26,  130,   18,   29,  130,   21,
 /*  2380 */    22,  130,   24,  130,   26,  130,   38,   29,  130,  130,
 /*  2390 */   130,  130,  130,  130,  130,  130,   38,  130,  130,  130,
 /*  2400 */   130,  130,   54,   55,   56,   57,   58,   59,    5,  130,
 /*  2410 */   130,  130,   54,   55,   56,   57,   58,   59,  130,  130,
 /*  2420 */   130,  130,  130,  130,   21,   22,  130,   24,  130,   26,
 /*  2430 */   130,  130,   29,  130,  130,   87,  130,  130,  130,   21,
 /*  2440 */    22,   38,   24,  130,   26,   87,  130,   29,  130,  130,
 /*  2450 */   130,  130,  130,  130,  130,  130,   38,   54,   55,   56,
 /*  2460 */    57,   58,   59,   21,   22,  130,   24,  130,   26,  130,
 /*  2470 */    52,   29,   54,   55,   56,   57,   58,   59,   21,   22,
 /*  2480 */    38,   24,  130,   26,  130,  130,   29,  130,  130,  130,
 /*  2490 */    87,  130,   50,  130,  130,   38,   54,   55,   56,   57,
 /*  2500 */    58,   59,  130,  130,  130,   87,  130,  130,  130,  130,
 /*  2510 */   130,   54,   55,   56,   57,   58,   59,   21,   22,  130,
 /*  2520 */    24,  130,   26,   21,   22,   29,   24,  130,   26,   87,
 /*  2530 */   130,   29,  130,  130,   38,  130,  130,  130,  130,  130,
 /*  2540 */    38,  130,  130,  130,   87,   88,  130,  130,   52,  130,
 /*  2550 */    54,   55,   56,   57,   58,   59,   54,   55,   56,   57,
 /*  2560 */    58,   59,   21,   22,  130,   24,  130,   26,  130,  130,
 /*  2570 */    29,  130,  130,   21,   22,  130,   24,  130,   26,   38,
 /*  2580 */   130,   29,  130,   87,  130,  130,  130,  130,  130,   87,
 /*  2590 */    38,  130,  130,  130,  130,   54,   55,   56,   57,   58,
 /*  2600 */    59,  130,  130,  130,  130,  130,   54,   55,   56,   57,
 /*  2610 */    58,   59,  130,  130,  130,  130,  130,  130,  130,  130,
 /*  2620 */   130,  130,  130,  130,  130,  130,  130,  130,   87,  130,
 /*  2630 */   130,  130,  130,  130,  130,  130,  130,  130,  130,   87,
};
#define YY_SHIFT_USE_DFLT (-4)
static short yy_shift_ofst[] = {
 /*     0 */   381,   28, 1240,   -4,   -4,   -4,   -4,   -4,   -4,   -4,
 /*    10 */    -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,
 /*    20 */    -4,   -4,   -4,   -4,   -4,   -4, 2206, 2502,  155, 1288,
 /*    30 */  1290, 1179,   17,   -4,   81, 1295, 1353, 1302,   85,   -4,
 /*    40 */  2502,  185,   -4, 2502, 2502,  121, 2502, 2502,  121, 2348,
 /*    50 */   225, 2358,  225, 2502,  225, 2502, 1373, 2502, 1373, 2502,
 /*    60 */   121, 2502,    4, 2502,  844, 2502,   18, 2267,   18, 2277,
 /*    70 */    18, 2502,   18, 2502,   18, 2502,   18, 2502,   18, 2502,
 /*    80 */    18, 2502,   18, 2502,   -4, 2502,  747,  154, 2502,    4,
 /*    90 */    -4,   -4, 2403,  215,   -4, 2502,  266, 2502,  772, 2418,
 /*   100 */   666, 2502,    4, 2502,  294,   -4, 2442,  666,   -4,    0,
 /*   110 */    -4, 2541, 2457,   -4,  261,   -4,   -4,  181, 2502,  666,
 /*   120 */    -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4, 1246,
 /*   130 */    -4, 2552,   -4,  211, 2502,  666,   -4,   -4,  289,  140,
 /*   140 */    -4,  170,  212,  259,  290,   -4,  249,   -4,  321,  324,
 /*   150 */    -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,
 /*   160 */    -4,   -4,   -4,   -4, 2502,  225, 2502,  225,  121,  121,
 /*   170 */   299,   -4,  297,  150, 2502,   52,  381, 1233, 1374,  320,
 /*   180 */    -4, 2502,  347, 1358, 1360, 1426,  346,   -4, 2502,  377,
 /*   190 */    -4,  376,   -4,  374,   55,   -4,  374,   -4, 1435, 2502,
 /*   200 */   666, 2502,  666, 2502,  666, 2502,  666, 2502,  666, 2502,
 /*   210 */   407,   -4,  374,   -4,   -4,   -4,  401,  419,  411,  408,
 /*   220 */   381, 1362, 1478,  423,   -4, 2502,  694, 2496, 1304,  459,
 /*   230 */   381, 1364, 1530,  485,   -4,   -4,  509,  519, 1427, 1429,
 /*   240 */  1582,  545,   -4, 2502,   -3,  381, 1445, 1634,  575,   -4,
 /*   250 */   579,  381, 2502,  458,   -4,  640,  568,  639,   -4,   -4,
 /*   260 */  2502,  486,   -4, 2502,   82,   -4, 2502,  516,   -4, 2502,
 /*   270 */   546,   -4, 2502,  576,   -4,  275,  667,  381, 1449, 1686,
 /*   280 */   720,   -4, 1186,   -4, 1195,   -4,   -4, 1196,  381, 1471,
 /*   290 */  1738, 1199,   -4, 1203,  381, 1492, 1790, 1210,   -4, 1212,
 /*   300 */  1214, 1842, 1219,   -4, 1223, 1303, 1252, 1275,   -4, 1306,
 /*   310 */  1294,  381, 1497, 1894, 1298,   -4,  629,   -4, 1287,  202,
 /*   320 */    -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4, 1946, 1315,
 /*   330 */    -4, 2502,  606,  381, 1501, 1998, 1317,   -4, 1313, 1352,
 /*   340 */  2502,  112,  381, 1516, 2050, 1328,   -4, 2502,  636,  381,
 /*   350 */  1596, 2102, 1332,   -4, 2154, 1339,   -4, 1250, 1346,   -4,
 /*   360 */  1349, 1403, 1375, 1380,   -4,
};
#define YY_REDUCE_USE_DFLT (-66)
static short yy_reduce_ofst[] = {
 /*     0 */   635,  -66, 1094,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*    10 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*    20 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  325,  -66,  711,
 /*    30 */  1094,  -66,  -66,  -66,  -66,  735, 1094,  -66,  -66,  -66,
 /*    40 */  1101,  -66,  -66, 1108, 1109,  -66, 1110, 1172,  -66, 1181,
 /*    50 */   -66, 1183,  -66, 1187,  -66, 1189,  -66, 1213,  -66, 1215,
 /*    60 */   -66, 1220,  -66, 1291,  -66, 1407,  -66, 1411,  -66, 1441,
 /*    70 */   -66, 1459,  -66, 1483,  -66, 1493,  -66, 1499,  -66, 1500,
 /*    80 */   -66, 1504,  -66, 1507,  -66, 1515,  -66,  -66, 1521,  -66,
 /*    90 */   -66,  -66,  326,  -66,  -66, 1523,  -66, 1545,  -66,  209,
 /*   100 */   -66, 1551,  -66, 1552,  -66,  -66,  214,  -66,  -66,  -66,
 /*   110 */   -66,  331,  220,  -66,  -66,  -66,  -66,  -66, 1556,  -66,
 /*   120 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   130 */   -66, 1104,  -66,  -66, 1567,  -66,  -66,  -66,   34,  -66,
 /*   140 */   -66,  -66,  -66,  -66,  142,  -66,  -66,  -66,  -66,  -66,
 /*   150 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   160 */   -66,  -66,  -66,  -66,  328,  -66, 1571,  -66,  -66,  -66,
 /*   170 */   -66,  -66,  -66,  -66, 1575,  -66,  783, 1094,  -66,  -66,
 /*   180 */   -66, 1597,  -66,  807, 1094,  -66,  -66,  -66, 1599,  -66,
 /*   190 */   -66,  -66,  -66,  -65,  -66,  -66,   37,  -66,  -66, 1604,
 /*   200 */   -66, 1608,  -66, 1615,  -66, 1617,  -66, 1619,  -66, 1623,
 /*   210 */   -66,  -66,  327,  -66,  -66,  -66,  -66,  -66,  146,  -66,
 /*   220 */   831, 1094,  -66,  -66,  -66, 1625,  -66,  322,  -66,  -66,
 /*   230 */   855, 1094,  -66,  -66,  -66,  -66,  -66,  -66,  879, 1094,
 /*   240 */   -66,  -66,  -66, 1307,  457,  903, 1094,  -66,  -66,  -66,
 /*   250 */   -66, 1165, 1357,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   260 */  1649,  -66,  -66, 1651,  -66,  -66, 1656,  -66,  -66, 1660,
 /*   270 */   -66,  -66, 1667,  -66,  -66,  -66,  -66,  927, 1094,  -66,
 /*   280 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  951, 1094,
 /*   290 */   -66,  -66,  -66,  -66,  975, 1094,  -66,  -66,  -66,  -66,
 /*   300 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   310 */   -66,  999, 1094,  -66,  -66,  -66, 1201,  -66,  -66, 1218,
 /*   320 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   330 */   -66, 1359,  -66, 1023, 1094,  -66,  -66,  -66,  -66,  -66,
 /*   340 */  1669,  -66, 1047, 1094,  -66,  -66,  -66, 1671,  -66, 1071,
 /*   350 */  1094,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   360 */   -66,  -66,  -66,  -66,  -66,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   523,  523,  523,  367,  369,  370,  371,  372,  373,  374,
 /*    10 */   375,  376,  377,  378,  379,  380,  381,  382,  383,  384,
 /*    20 */   385,  386,  387,  388,  389,  390,  523,  523,  523,  523,
 /*    30 */   523,  523,  523,  391,  523,  523,  523,  523,  523,  393,
 /*    40 */   523,  523,  396,  523,  523,  450,  523,  523,  451,  523,
 /*    50 */   454,  523,  456,  523,  458,  523,  459,  523,  460,  523,
 /*    60 */   461,  523,  462,  523,  463,  523,  464,  523,  480,  523,
 /*    70 */   479,  523,  481,  523,  482,  523,  483,  523,  484,  523,
 /*    80 */   485,  523,  486,  523,  487,  523,  488,  523,  523,  489,
 /*    90 */   491,  492,  523,  523,  498,  523,  523,  523,  499,  523,
 /*   100 */   514,  523,  490,  523,  523,  493,  523,  508,  494,  523,
 /*   110 */   495,  523,  523,  496,  523,  497,  506,  518,  523,  507,
 /*   120 */   509,  516,  517,  518,  519,  520,  521,  522,  505,  523,
 /*   130 */   510,  523,  512,  518,  523,  515,  511,  513,  523,  523,
 /*   140 */   500,  523,  523,  523,  523,  501,  523,  502,  517,  516,
 /*   150 */   466,  468,  470,  472,  474,  476,  478,  465,  467,  469,
 /*   160 */   471,  473,  475,  477,  523,  457,  523,  455,  453,  452,
 /*   170 */   523,  397,  523,  523,  523,  523,  523,  523,  523,  523,
 /*   180 */   398,  523,  523,  523,  523,  523,  523,  402,  523,  523,
 /*   190 */   404,  523,  405,  523,  523,  406,  523,  407,  523,  523,
 /*   200 */   409,  523,  410,  523,  411,  523,  412,  523,  413,  523,
 /*   210 */   523,  415,  523,  414,  416,  408,  523,  523,  523,  523,
 /*   220 */   523,  523,  523,  523,  417,  523,  523,  523,  523,  510,
 /*   230 */   523,  523,  523,  523,  429,  431,  523,  523,  523,  523,
 /*   240 */   523,  523,  433,  523,  523,  523,  523,  523,  523,  435,
 /*   250 */   523,  523,  523,  523,  432,  523,  523,  523,  439,  449,
 /*   260 */   523,  523,  440,  523,  523,  441,  523,  523,  442,  523,
 /*   270 */   523,  443,  523,  523,  444,  523,  523,  523,  523,  523,
 /*   280 */   523,  445,  523,  447,  523,  448,  368,  523,  523,  523,
 /*   290 */   523,  523,  446,  523,  523,  523,  523,  523,  436,  523,
 /*   300 */   523,  523,  523,  434,  511,  523,  523,  523,  430,  523,
 /*   310 */   523,  523,  523,  523,  523,  418,  523,  419,  421,  523,
 /*   320 */   422,  423,  424,  425,  426,  427,  428,  420,  523,  523,
 /*   330 */   403,  523,  523,  523,  523,  523,  523,  399,  523,  523,
 /*   340 */   523,  523,  523,  523,  523,  523,  400,  523,  523,  523,
 /*   350 */   523,  523,  523,  401,  523,  523,  394,  523,  523,  392,
 /*   360 */   523,  523,  523,  523,  395,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  phvolt_ARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void phvolt_Trace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "OPEN_DELIMITER",  "COMMA",         "IN",          
  "QUESTION",      "COLON",         "RANGE",         "AND",         
  "OR",            "IS",            "EQUALS",        "NOTEQUALS",   
  "LESS",          "GREATER",       "GREATEREQUAL",  "LESSEQUAL",   
  "IDENTICAL",     "NOTIDENTICAL",  "DIVIDE",        "TIMES",       
  "MOD",           "PLUS",          "MINUS",         "CONCAT",      
  "SBRACKET_OPEN",  "PIPE",          "NOT",           "INCR",        
  "DECR",          "PARENTHESES_OPEN",  "DOT",           "IF",          
  "CLOSE_DELIMITER",  "ENDIF",         "ELSE",          "ELSEIF",      
  "ELSEFOR",       "FOR",           "IDENTIFIER",    "ENDFOR",      
  "SWITCH",        "ENDSWITCH",     "CASE",          "DEFAULT",     
  "SET",           "ASSIGN",        "ADD_ASSIGN",    "SUB_ASSIGN",  
  "MUL_ASSIGN",    "DIV_ASSIGN",    "SBRACKET_CLOSE",  "MACRO",       
  "PARENTHESES_CLOSE",  "ENDMACRO",      "INTEGER",       "STRING",      
  "DOUBLE",        "NULL",          "FALSE",         "TRUE",        
  "CALL",          "ENDCALL",       "OPEN_EDELIMITER",  "CLOSE_EDELIMITER",
  "BLOCK",         "ENDBLOCK",      "CACHE",         "ENDCACHE",    
  "RAW",           "ENDRAW",        "EXTENDS",       "INCLUDE",     
  "WITH",          "DO",            "RETURN",        "AUTOESCAPE",  
  "ENDAUTOESCAPE",  "BREAK",         "CONTINUE",      "RAW_FRAGMENT",
  "DEFINED",       "EMPTY",         "EVEN",          "ODD",         
  "NUMERIC",       "SCALAR",        "ITERABLE",      "CBRACKET_OPEN",
  "CBRACKET_CLOSE",  "error",         "program",       "volt_language",
  "statement_list",  "statement",     "raw_fragment",  "if_statement",
  "elseif_statement",  "elsefor_statement",  "for_statement",  "switch_statement",
  "case_clause",   "set_statement",  "echo_statement",  "block_statement",
  "cache_statement",  "extends_statement",  "include_statement",  "do_statement",
  "return_statement",  "autoescape_statement",  "raw_statement",  "break_statement",
  "continue_statement",  "macro_statement",  "empty_statement",  "macro_call_statement",
  "expr",          "set_assignments",  "set_assignment",  "assignable_expr",
  "macro_parameters",  "macro_parameter",  "macro_parameter_default",  "argument_list",
  "cache_lifetime",  "array_list",    "slice_offset",  "array_item",  
  "function_call",  "argument_item",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "program ::= volt_language",
 /*   1 */ "volt_language ::= statement_list",
 /*   2 */ "statement_list ::= statement_list statement",
 /*   3 */ "statement_list ::= statement",
 /*   4 */ "statement ::= raw_fragment",
 /*   5 */ "statement ::= if_statement",
 /*   6 */ "statement ::= elseif_statement",
 /*   7 */ "statement ::= elsefor_statement",
 /*   8 */ "statement ::= for_statement",
 /*   9 */ "statement ::= switch_statement",
 /*  10 */ "statement ::= case_clause",
 /*  11 */ "statement ::= set_statement",
 /*  12 */ "statement ::= echo_statement",
 /*  13 */ "statement ::= block_statement",
 /*  14 */ "statement ::= cache_statement",
 /*  15 */ "statement ::= extends_statement",
 /*  16 */ "statement ::= include_statement",
 /*  17 */ "statement ::= do_statement",
 /*  18 */ "statement ::= return_statement",
 /*  19 */ "statement ::= autoescape_statement",
 /*  20 */ "statement ::= raw_statement",
 /*  21 */ "statement ::= break_statement",
 /*  22 */ "statement ::= continue_statement",
 /*  23 */ "statement ::= macro_statement",
 /*  24 */ "statement ::= empty_statement",
 /*  25 */ "statement ::= macro_call_statement",
 /*  26 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  27 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  28 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ELSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  29 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ELSE CLOSE_DELIMITER OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  30 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER OPEN_DELIMITER ELSE CLOSE_DELIMITER OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  31 */ "elseif_statement ::= OPEN_DELIMITER ELSEIF expr CLOSE_DELIMITER",
 /*  32 */ "elsefor_statement ::= OPEN_DELIMITER ELSEFOR CLOSE_DELIMITER",
 /*  33 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER IN expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  34 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER IN expr IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  35 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER COMMA IDENTIFIER IN expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  36 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER COMMA IDENTIFIER IN expr IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  37 */ "switch_statement ::= OPEN_DELIMITER SWITCH expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDSWITCH CLOSE_DELIMITER",
 /*  38 */ "switch_statement ::= OPEN_DELIMITER SWITCH expr CLOSE_DELIMITER OPEN_DELIMITER ENDSWITCH CLOSE_DELIMITER",
 /*  39 */ "case_clause ::= OPEN_DELIMITER CASE expr CLOSE_DELIMITER",
 /*  40 */ "case_clause ::= OPEN_DELIMITER DEFAULT CLOSE_DELIMITER",
 /*  41 */ "set_statement ::= OPEN_DELIMITER SET set_assignments CLOSE_DELIMITER",
 /*  42 */ "set_assignments ::= set_assignments COMMA set_assignment",
 /*  43 */ "set_assignments ::= set_assignment",
 /*  44 */ "set_assignment ::= assignable_expr ASSIGN expr",
 /*  45 */ "set_assignment ::= assignable_expr ADD_ASSIGN expr",
 /*  46 */ "set_assignment ::= assignable_expr SUB_ASSIGN expr",
 /*  47 */ "set_assignment ::= assignable_expr MUL_ASSIGN expr",
 /*  48 */ "set_assignment ::= assignable_expr DIV_ASSIGN expr",
 /*  49 */ "assignable_expr ::= IDENTIFIER",
 /*  50 */ "assignable_expr ::= assignable_expr SBRACKET_OPEN expr SBRACKET_CLOSE",
 /*  51 */ "assignable_expr ::= assignable_expr DOT assignable_expr",
 /*  52 */ "macro_statement ::= OPEN_DELIMITER MACRO IDENTIFIER PARENTHESES_OPEN PARENTHESES_CLOSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDMACRO CLOSE_DELIMITER",
 /*  53 */ "macro_statement ::= OPEN_DELIMITER MACRO IDENTIFIER PARENTHESES_OPEN macro_parameters PARENTHESES_CLOSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDMACRO CLOSE_DELIMITER",
 /*  54 */ "macro_parameters ::= macro_parameters COMMA macro_parameter",
 /*  55 */ "macro_parameters ::= macro_parameter",
 /*  56 */ "macro_parameter ::= IDENTIFIER",
 /*  57 */ "macro_parameter ::= IDENTIFIER ASSIGN macro_parameter_default",
 /*  58 */ "macro_parameter_default ::= INTEGER",
 /*  59 */ "macro_parameter_default ::= STRING",
 /*  60 */ "macro_parameter_default ::= DOUBLE",
 /*  61 */ "macro_parameter_default ::= NULL",
 /*  62 */ "macro_parameter_default ::= FALSE",
 /*  63 */ "macro_parameter_default ::= TRUE",
 /*  64 */ "macro_call_statement ::= OPEN_DELIMITER CALL expr PARENTHESES_OPEN argument_list PARENTHESES_CLOSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDCALL CLOSE_DELIMITER",
 /*  65 */ "macro_call_statement ::= OPEN_DELIMITER CALL expr PARENTHESES_OPEN PARENTHESES_CLOSE CLOSE_DELIMITER OPEN_DELIMITER ENDCALL CLOSE_DELIMITER",
 /*  66 */ "empty_statement ::= OPEN_DELIMITER CLOSE_DELIMITER",
 /*  67 */ "echo_statement ::= OPEN_EDELIMITER expr CLOSE_EDELIMITER",
 /*  68 */ "block_statement ::= OPEN_DELIMITER BLOCK IDENTIFIER CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDBLOCK CLOSE_DELIMITER",
 /*  69 */ "block_statement ::= OPEN_DELIMITER BLOCK IDENTIFIER CLOSE_DELIMITER OPEN_DELIMITER ENDBLOCK CLOSE_DELIMITER",
 /*  70 */ "cache_statement ::= OPEN_DELIMITER CACHE expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDCACHE CLOSE_DELIMITER",
 /*  71 */ "cache_statement ::= OPEN_DELIMITER CACHE expr cache_lifetime CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDCACHE CLOSE_DELIMITER",
 /*  72 */ "cache_lifetime ::= INTEGER",
 /*  73 */ "cache_lifetime ::= IDENTIFIER",
 /*  74 */ "raw_statement ::= OPEN_DELIMITER RAW CLOSE_DELIMITER statement OPEN_DELIMITER ENDRAW CLOSE_DELIMITER",
 /*  75 */ "extends_statement ::= OPEN_DELIMITER EXTENDS expr CLOSE_DELIMITER",
 /*  76 */ "include_statement ::= OPEN_DELIMITER INCLUDE expr CLOSE_DELIMITER",
 /*  77 */ "include_statement ::= OPEN_DELIMITER INCLUDE expr WITH expr CLOSE_DELIMITER",
 /*  78 */ "do_statement ::= OPEN_DELIMITER DO expr CLOSE_DELIMITER",
 /*  79 */ "return_statement ::= OPEN_DELIMITER RETURN expr CLOSE_DELIMITER",
 /*  80 */ "autoescape_statement ::= OPEN_DELIMITER AUTOESCAPE FALSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDAUTOESCAPE CLOSE_DELIMITER",
 /*  81 */ "autoescape_statement ::= OPEN_DELIMITER AUTOESCAPE TRUE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDAUTOESCAPE CLOSE_DELIMITER",
 /*  82 */ "break_statement ::= OPEN_DELIMITER BREAK CLOSE_DELIMITER",
 /*  83 */ "continue_statement ::= OPEN_DELIMITER CONTINUE CLOSE_DELIMITER",
 /*  84 */ "raw_fragment ::= RAW_FRAGMENT",
 /*  85 */ "expr ::= MINUS expr",
 /*  86 */ "expr ::= PLUS expr",
 /*  87 */ "expr ::= expr MINUS expr",
 /*  88 */ "expr ::= expr PLUS expr",
 /*  89 */ "expr ::= expr TIMES expr",
 /*  90 */ "expr ::= expr TIMES TIMES expr",
 /*  91 */ "expr ::= expr DIVIDE expr",
 /*  92 */ "expr ::= expr DIVIDE DIVIDE expr",
 /*  93 */ "expr ::= expr MOD expr",
 /*  94 */ "expr ::= expr AND expr",
 /*  95 */ "expr ::= expr OR expr",
 /*  96 */ "expr ::= expr CONCAT expr",
 /*  97 */ "expr ::= expr PIPE expr",
 /*  98 */ "expr ::= expr RANGE expr",
 /*  99 */ "expr ::= expr EQUALS expr",
 /* 100 */ "expr ::= expr NOTEQUALS DEFINED",
 /* 101 */ "expr ::= expr IS DEFINED",
 /* 102 */ "expr ::= expr NOTEQUALS EMPTY",
 /* 103 */ "expr ::= expr IS EMPTY",
 /* 104 */ "expr ::= expr NOTEQUALS EVEN",
 /* 105 */ "expr ::= expr IS EVEN",
 /* 106 */ "expr ::= expr NOTEQUALS ODD",
 /* 107 */ "expr ::= expr IS ODD",
 /* 108 */ "expr ::= expr NOTEQUALS NUMERIC",
 /* 109 */ "expr ::= expr IS NUMERIC",
 /* 110 */ "expr ::= expr NOTEQUALS SCALAR",
 /* 111 */ "expr ::= expr IS SCALAR",
 /* 112 */ "expr ::= expr NOTEQUALS ITERABLE",
 /* 113 */ "expr ::= expr IS ITERABLE",
 /* 114 */ "expr ::= expr IS expr",
 /* 115 */ "expr ::= expr NOTEQUALS expr",
 /* 116 */ "expr ::= expr IDENTICAL expr",
 /* 117 */ "expr ::= expr NOTIDENTICAL expr",
 /* 118 */ "expr ::= expr LESS expr",
 /* 119 */ "expr ::= expr GREATER expr",
 /* 120 */ "expr ::= expr GREATEREQUAL expr",
 /* 121 */ "expr ::= expr LESSEQUAL expr",
 /* 122 */ "expr ::= expr DOT expr",
 /* 123 */ "expr ::= expr IN expr",
 /* 124 */ "expr ::= expr NOT IN expr",
 /* 125 */ "expr ::= NOT expr",
 /* 126 */ "expr ::= expr INCR",
 /* 127 */ "expr ::= expr DECR",
 /* 128 */ "expr ::= PARENTHESES_OPEN expr PARENTHESES_CLOSE",
 /* 129 */ "expr ::= SBRACKET_OPEN SBRACKET_CLOSE",
 /* 130 */ "expr ::= SBRACKET_OPEN array_list SBRACKET_CLOSE",
 /* 131 */ "expr ::= CBRACKET_OPEN CBRACKET_CLOSE",
 /* 132 */ "expr ::= CBRACKET_OPEN array_list CBRACKET_CLOSE",
 /* 133 */ "expr ::= expr SBRACKET_OPEN expr SBRACKET_CLOSE",
 /* 134 */ "expr ::= expr QUESTION expr COLON expr",
 /* 135 */ "expr ::= expr SBRACKET_OPEN COLON slice_offset SBRACKET_CLOSE",
 /* 136 */ "expr ::= expr SBRACKET_OPEN slice_offset COLON SBRACKET_CLOSE",
 /* 137 */ "expr ::= expr SBRACKET_OPEN slice_offset COLON slice_offset SBRACKET_CLOSE",
 /* 138 */ "slice_offset ::= INTEGER",
 /* 139 */ "slice_offset ::= IDENTIFIER",
 /* 140 */ "array_list ::= array_list COMMA array_item",
 /* 141 */ "array_list ::= array_item",
 /* 142 */ "array_item ::= STRING COLON expr",
 /* 143 */ "array_item ::= expr",
 /* 144 */ "expr ::= function_call",
 /* 145 */ "function_call ::= expr PARENTHESES_OPEN argument_list PARENTHESES_CLOSE",
 /* 146 */ "function_call ::= expr PARENTHESES_OPEN PARENTHESES_CLOSE",
 /* 147 */ "argument_list ::= argument_list COMMA argument_item",
 /* 148 */ "argument_list ::= argument_item",
 /* 149 */ "argument_item ::= expr",
 /* 150 */ "argument_item ::= STRING COLON expr",
 /* 151 */ "expr ::= IDENTIFIER",
 /* 152 */ "expr ::= INTEGER",
 /* 153 */ "expr ::= STRING",
 /* 154 */ "expr ::= DOUBLE",
 /* 155 */ "expr ::= NULL",
 /* 156 */ "expr ::= FALSE",
 /* 157 */ "expr ::= TRUE",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *phvolt_TokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to phvolt_ and phvolt_Free.
*/
void *phvolt_Alloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:
    case 77:
    case 78:
    case 79:
    case 80:
    case 81:
    case 82:
    case 83:
    case 84:
    case 85:
    case 86:
    case 87:
    case 88:
#line 142 "parser.php7.lemon"
{
	if ((yypminor->yy0)) {
		if ((yypminor->yy0)->free_flag) {
			efree((yypminor->yy0)->token);
		}
		efree((yypminor->yy0));
	}
}
#line 1217 "parser.php7.c"
      break;
    case 92:
    case 93:
    case 94:
    case 95:
    case 96:
    case 97:
    case 98:
    case 99:
    case 100:
    case 101:
    case 102:
    case 103:
    case 104:
    case 105:
    case 106:
    case 107:
    case 108:
    case 109:
    case 110:
    case 111:
    case 112:
    case 113:
    case 114:
    case 115:
    case 116:
    case 117:
    case 118:
    case 120:
    case 121:
    case 123:
    case 124:
    case 125:
    case 126:
    case 127:
    case 128:
    case 129:
#line 159 "parser.php7.lemon"
{
	zval_ptr_dtor(&(yypminor->yy186));
}
#line 1259 "parser.php7.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from phvolt_Alloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void phvolt_Free(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     phvolt_ARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 90, 1 },
  { 91, 1 },
  { 92, 2 },
  { 92, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 95, 8 },
  { 95, 7 },
  { 95, 12 },
  { 95, 11 },
  { 95, 10 },
  { 96, 4 },
  { 97, 3 },
  { 98, 10 },
  { 98, 12 },
  { 98, 12 },
  { 98, 14 },
  { 99, 8 },
  { 99, 7 },
  { 100, 4 },
  { 100, 3 },
  { 101, 4 },
  { 117, 3 },
  { 117, 1 },
  { 118, 3 },
  { 118, 3 },
  { 118, 3 },
  { 118, 3 },
  { 118, 3 },
  { 119, 1 },
  { 119, 4 },
  { 119, 3 },
  { 113, 10 },
  { 113, 11 },
  { 120, 3 },
  { 120, 1 },
  { 121, 1 },
  { 121, 3 },
  { 122, 1 },
  { 122, 1 },
  { 122, 1 },
  { 122, 1 },
  { 122, 1 },
  { 122, 1 },
  { 115, 11 },
  { 115, 9 },
  { 114, 2 },
  { 102, 3 },
  { 103, 8 },
  { 103, 7 },
  { 104, 8 },
  { 104, 9 },
  { 124, 1 },
  { 124, 1 },
  { 110, 7 },
  { 105, 4 },
  { 106, 4 },
  { 106, 6 },
  { 107, 4 },
  { 108, 4 },
  { 109, 8 },
  { 109, 8 },
  { 111, 3 },
  { 112, 3 },
  { 94, 1 },
  { 116, 2 },
  { 116, 2 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 4 },
  { 116, 3 },
  { 116, 4 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 4 },
  { 116, 2 },
  { 116, 2 },
  { 116, 2 },
  { 116, 3 },
  { 116, 2 },
  { 116, 3 },
  { 116, 2 },
  { 116, 3 },
  { 116, 4 },
  { 116, 5 },
  { 116, 5 },
  { 116, 5 },
  { 116, 6 },
  { 126, 1 },
  { 126, 1 },
  { 125, 3 },
  { 125, 1 },
  { 127, 3 },
  { 127, 1 },
  { 116, 1 },
  { 128, 4 },
  { 128, 3 },
  { 123, 3 },
  { 123, 1 },
  { 129, 1 },
  { 129, 3 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  phvolt_ARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
#line 151 "parser.php7.lemon"
{
	ZVAL_ZVAL(&status->ret, &yymsp[0].minor.yy186, 1, 1);
}
#line 1634 "parser.php7.c"
        break;
      case 1:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 144:
#line 155 "parser.php7.lemon"
{
	yygotominor.yy186 = yymsp[0].minor.yy186;
}
#line 1664 "parser.php7.c"
        break;
      case 2:
#line 163 "parser.php7.lemon"
{
	phvolt_ret_zval_list(&yygotominor.yy186, &yymsp[-1].minor.yy186, &yymsp[0].minor.yy186);
}
#line 1671 "parser.php7.c"
        break;
      case 3:
      case 43:
      case 55:
      case 141:
      case 148:
#line 167 "parser.php7.lemon"
{
	phvolt_ret_zval_list(&yygotominor.yy186, NULL, &yymsp[0].minor.yy186);
}
#line 1682 "parser.php7.c"
        break;
      case 26:
#line 268 "parser.php7.lemon"
{
	phvolt_ret_if_statement(&yygotominor.yy186, &yymsp[-5].minor.yy186, &yymsp[-3].minor.yy186, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(31,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1695 "parser.php7.c"
        break;
      case 27:
#line 273 "parser.php7.lemon"
{
	phvolt_ret_if_statement(&yygotominor.yy186, &yymsp[-4].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(31,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1708 "parser.php7.c"
        break;
      case 28:
#line 278 "parser.php7.lemon"
{
	phvolt_ret_if_statement(&yygotominor.yy186, &yymsp[-9].minor.yy186, &yymsp[-7].minor.yy186, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-11].minor);
  yy_destructor(31,&yymsp[-10].minor);
  yy_destructor(32,&yymsp[-8].minor);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(34,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1724 "parser.php7.c"
        break;
      case 29:
#line 283 "parser.php7.lemon"
{
	phvolt_ret_if_statement(&yygotominor.yy186, &yymsp[-8].minor.yy186, &yymsp[-6].minor.yy186, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-10].minor);
  yy_destructor(31,&yymsp[-9].minor);
  yy_destructor(32,&yymsp[-7].minor);
  yy_destructor(1,&yymsp[-5].minor);
  yy_destructor(34,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1740 "parser.php7.c"
        break;
      case 30:
#line 288 "parser.php7.lemon"
{
	phvolt_ret_if_statement(&yygotominor.yy186, &yymsp[-7].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-9].minor);
  yy_destructor(31,&yymsp[-8].minor);
  yy_destructor(32,&yymsp[-6].minor);
  yy_destructor(1,&yymsp[-5].minor);
  yy_destructor(34,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1756 "parser.php7.c"
        break;
      case 31:
#line 296 "parser.php7.lemon"
{
	phvolt_ret_elseif_statement(&yygotominor.yy186, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(35,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1766 "parser.php7.c"
        break;
      case 32:
#line 304 "parser.php7.lemon"
{
	phvolt_ret_elsefor_statement(&yygotominor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(36,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1776 "parser.php7.c"
        break;
      case 33:
#line 312 "parser.php7.lemon"
{
	phvolt_ret_for_statement(&yygotominor.yy186, yymsp[-7].minor.yy0, NULL, &yymsp[-5].minor.yy186, NULL, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-9].minor);
  yy_destructor(37,&yymsp[-8].minor);
  yy_destructor(3,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1790 "parser.php7.c"
        break;
      case 34:
#line 316 "parser.php7.lemon"
{
	phvolt_ret_for_statement(&yygotominor.yy186, yymsp[-9].minor.yy0, NULL, &yymsp[-7].minor.yy186, &yymsp[-5].minor.yy186, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-11].minor);
  yy_destructor(37,&yymsp[-10].minor);
  yy_destructor(3,&yymsp[-8].minor);
  yy_destructor(31,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1805 "parser.php7.c"
        break;
      case 35:
#line 320 "parser.php7.lemon"
{
	phvolt_ret_for_statement(&yygotominor.yy186, yymsp[-7].minor.yy0, yymsp[-9].minor.yy0, &yymsp[-5].minor.yy186, NULL, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-11].minor);
  yy_destructor(37,&yymsp[-10].minor);
  yy_destructor(2,&yymsp[-8].minor);
  yy_destructor(3,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1820 "parser.php7.c"
        break;
      case 36:
#line 324 "parser.php7.lemon"
{
	phvolt_ret_for_statement(&yygotominor.yy186, yymsp[-9].minor.yy0, yymsp[-11].minor.yy0, &yymsp[-7].minor.yy186, &yymsp[-5].minor.yy186, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-13].minor);
  yy_destructor(37,&yymsp[-12].minor);
  yy_destructor(2,&yymsp[-10].minor);
  yy_destructor(3,&yymsp[-8].minor);
  yy_destructor(31,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1836 "parser.php7.c"
        break;
      case 37:
#line 333 "parser.php7.lemon"
{
	phvolt_ret_switch_statement(&yygotominor.yy186, &yymsp[-5].minor.yy186, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(40,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(41,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1849 "parser.php7.c"
        break;
      case 38:
#line 338 "parser.php7.lemon"
{
	phvolt_ret_switch_statement(&yygotominor.yy186, &yymsp[-4].minor.yy186, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(40,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(41,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1862 "parser.php7.c"
        break;
      case 39:
#line 347 "parser.php7.lemon"
{
	phvolt_ret_case_clause(&yygotominor.yy186, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(42,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1872 "parser.php7.c"
        break;
      case 40:
#line 352 "parser.php7.lemon"
{
	phvolt_ret_case_clause(&yygotominor.yy186, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(43,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1882 "parser.php7.c"
        break;
      case 41:
#line 360 "parser.php7.lemon"
{
	phvolt_ret_set_statement(&yygotominor.yy186, &yymsp[-1].minor.yy186);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(44,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1892 "parser.php7.c"
        break;
      case 42:
      case 54:
      case 140:
      case 147:
#line 368 "parser.php7.lemon"
{
	phvolt_ret_zval_list(&yygotominor.yy186, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186);
  yy_destructor(2,&yymsp[-1].minor);
}
#line 1903 "parser.php7.c"
        break;
      case 44:
#line 380 "parser.php7.lemon"
{
	phvolt_ret_set_assignment(&yygotominor.yy186, &yymsp[-2].minor.yy186, PHVOLT_T_ASSIGN, &yymsp[0].minor.yy186, status->scanner_state);
  yy_destructor(45,&yymsp[-1].minor);
}
#line 1911 "parser.php7.c"
        break;
      case 45:
#line 384 "parser.php7.lemon"
{
	phvolt_ret_set_assignment(&yygotominor.yy186, &yymsp[-2].minor.yy186, PHVOLT_T_ADD_ASSIGN, &yymsp[0].minor.yy186, status->scanner_state);
  yy_destructor(46,&yymsp[-1].minor);
}
#line 1919 "parser.php7.c"
        break;
      case 46:
#line 388 "parser.php7.lemon"
{
	phvolt_ret_set_assignment(&yygotominor.yy186, &yymsp[-2].minor.yy186, PHVOLT_T_SUB_ASSIGN, &yymsp[0].minor.yy186, status->scanner_state);
  yy_destructor(47,&yymsp[-1].minor);
}
#line 1927 "parser.php7.c"
        break;
      case 47:
#line 392 "parser.php7.lemon"
{
	phvolt_ret_set_assignment(&yygotominor.yy186, &yymsp[-2].minor.yy186, PHVOLT_T_MUL_ASSIGN, &yymsp[0].minor.yy186, status->scanner_state);
  yy_destructor(48,&yymsp[-1].minor);
}
#line 1935 "parser.php7.c"
        break;
      case 48:
#line 396 "parser.php7.lemon"
{
	phvolt_ret_set_assignment(&yygotominor.yy186, &yymsp[-2].minor.yy186, PHVOLT_T_DIV_ASSIGN, &yymsp[0].minor.yy186, status->scanner_state);
  yy_destructor(49,&yymsp[-1].minor);
}
#line 1943 "parser.php7.c"
        break;
      case 49:
      case 73:
      case 139:
      case 151:
#line 400 "parser.php7.lemon"
{
	phvolt_ret_literal_zval(&yygotominor.yy186, PHVOLT_T_IDENTIFIER, yymsp[0].minor.yy0, status->scanner_state);
}
#line 1953 "parser.php7.c"
        break;
      case 50:
      case 133:
#line 404 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ARRAYACCESS, &yymsp[-3].minor.yy186, &yymsp[-1].minor.yy186, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-2].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 1963 "parser.php7.c"
        break;
      case 51:
      case 122:
#line 408 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_DOT, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(30,&yymsp[-1].minor);
}
#line 1972 "parser.php7.c"
        break;
      case 52:
#line 416 "parser.php7.lemon"
{
	phvolt_ret_macro_statement(&yygotominor.yy186, yymsp[-7].minor.yy0, NULL, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-9].minor);
  yy_destructor(51,&yymsp[-8].minor);
  yy_destructor(29,&yymsp[-6].minor);
  yy_destructor(52,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1987 "parser.php7.c"
        break;
      case 53:
#line 420 "parser.php7.lemon"
{
	phvolt_ret_macro_statement(&yygotominor.yy186, yymsp[-8].minor.yy0, &yymsp[-6].minor.yy186, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-10].minor);
  yy_destructor(51,&yymsp[-9].minor);
  yy_destructor(29,&yymsp[-7].minor);
  yy_destructor(52,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2002 "parser.php7.c"
        break;
      case 56:
#line 440 "parser.php7.lemon"
{
	phvolt_ret_macro_parameter(&yygotominor.yy186, yymsp[0].minor.yy0, NULL, status->scanner_state);
}
#line 2009 "parser.php7.c"
        break;
      case 57:
#line 444 "parser.php7.lemon"
{
	phvolt_ret_macro_parameter(&yygotominor.yy186, yymsp[-2].minor.yy0, &yymsp[0].minor.yy186, status->scanner_state);
  yy_destructor(45,&yymsp[-1].minor);
}
#line 2017 "parser.php7.c"
        break;
      case 58:
      case 72:
      case 138:
      case 152:
#line 448 "parser.php7.lemon"
{
	phvolt_ret_literal_zval(&yygotominor.yy186, PHVOLT_T_INTEGER, yymsp[0].minor.yy0, status->scanner_state);
}
#line 2027 "parser.php7.c"
        break;
      case 59:
      case 153:
#line 452 "parser.php7.lemon"
{
	phvolt_ret_literal_zval(&yygotominor.yy186, PHVOLT_T_STRING, yymsp[0].minor.yy0, status->scanner_state);
}
#line 2035 "parser.php7.c"
        break;
      case 60:
      case 154:
#line 456 "parser.php7.lemon"
{
	phvolt_ret_literal_zval(&yygotominor.yy186, PHVOLT_T_DOUBLE, yymsp[0].minor.yy0, status->scanner_state);
}
#line 2043 "parser.php7.c"
        break;
      case 61:
      case 155:
#line 460 "parser.php7.lemon"
{
	phvolt_ret_literal_zval(&yygotominor.yy186, PHVOLT_T_NULL, NULL, status->scanner_state);
  yy_destructor(57,&yymsp[0].minor);
}
#line 2052 "parser.php7.c"
        break;
      case 62:
      case 156:
#line 464 "parser.php7.lemon"
{
	phvolt_ret_literal_zval(&yygotominor.yy186, PHVOLT_T_FALSE, NULL, status->scanner_state);
  yy_destructor(58,&yymsp[0].minor);
}
#line 2061 "parser.php7.c"
        break;
      case 63:
      case 157:
#line 468 "parser.php7.lemon"
{
	phvolt_ret_literal_zval(&yygotominor.yy186, PHVOLT_T_TRUE, NULL, status->scanner_state);
  yy_destructor(59,&yymsp[0].minor);
}
#line 2070 "parser.php7.c"
        break;
      case 64:
#line 476 "parser.php7.lemon"
{
	phvolt_ret_macro_call_statement(&yygotominor.yy186, &yymsp[-8].minor.yy186, &yymsp[-6].minor.yy186, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-10].minor);
  yy_destructor(60,&yymsp[-9].minor);
  yy_destructor(29,&yymsp[-7].minor);
  yy_destructor(52,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(61,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2085 "parser.php7.c"
        break;
      case 65:
#line 480 "parser.php7.lemon"
{
	phvolt_ret_macro_call_statement(&yygotominor.yy186, &yymsp[-6].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-8].minor);
  yy_destructor(60,&yymsp[-7].minor);
  yy_destructor(29,&yymsp[-5].minor);
  yy_destructor(52,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(61,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2100 "parser.php7.c"
        break;
      case 66:
#line 488 "parser.php7.lemon"
{
	phvolt_ret_empty_statement(&yygotominor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2109 "parser.php7.c"
        break;
      case 67:
#line 496 "parser.php7.lemon"
{
	phvolt_ret_echo_statement(&yygotominor.yy186, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(62,&yymsp[-2].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2118 "parser.php7.c"
        break;
      case 68:
#line 504 "parser.php7.lemon"
{
	phvolt_ret_block_statement(&yygotominor.yy186, yymsp[-5].minor.yy0, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(64,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2131 "parser.php7.c"
        break;
      case 69:
#line 508 "parser.php7.lemon"
{
	phvolt_ret_block_statement(&yygotominor.yy186, yymsp[-4].minor.yy0, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(64,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2144 "parser.php7.c"
        break;
      case 70:
#line 516 "parser.php7.lemon"
{
	phvolt_ret_cache_statement(&yygotominor.yy186, &yymsp[-5].minor.yy186, NULL, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(66,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(67,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2157 "parser.php7.c"
        break;
      case 71:
#line 520 "parser.php7.lemon"
{
	phvolt_ret_cache_statement(&yygotominor.yy186, &yymsp[-6].minor.yy186, &yymsp[-5].minor.yy186, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-8].minor);
  yy_destructor(66,&yymsp[-7].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(67,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2170 "parser.php7.c"
        break;
      case 74:
#line 540 "parser.php7.lemon"
{
	phvolt_ret_raw_statement(&yygotominor.yy186, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(68,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(69,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2183 "parser.php7.c"
        break;
      case 75:
#line 548 "parser.php7.lemon"
{
	phvolt_ret_extends_statement(&yygotominor.yy186, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(70,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2193 "parser.php7.c"
        break;
      case 76:
#line 556 "parser.php7.lemon"
{
	phvolt_ret_include_statement(&yygotominor.yy186, &yymsp[-1].minor.yy186, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(71,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2203 "parser.php7.c"
        break;
      case 77:
#line 560 "parser.php7.lemon"
{
	phvolt_ret_include_statement(&yygotominor.yy186, &yymsp[-3].minor.yy186, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-5].minor);
  yy_destructor(71,&yymsp[-4].minor);
  yy_destructor(72,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2214 "parser.php7.c"
        break;
      case 78:
#line 568 "parser.php7.lemon"
{
	phvolt_ret_do_statement(&yygotominor.yy186, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(73,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2224 "parser.php7.c"
        break;
      case 79:
#line 576 "parser.php7.lemon"
{
	phvolt_ret_return_statement(&yygotominor.yy186, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(74,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2234 "parser.php7.c"
        break;
      case 80:
#line 584 "parser.php7.lemon"
{
	phvolt_ret_autoescape_statement(&yygotominor.yy186, 0, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(75,&yymsp[-6].minor);
  yy_destructor(58,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(76,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2248 "parser.php7.c"
        break;
      case 81:
#line 588 "parser.php7.lemon"
{
	phvolt_ret_autoescape_statement(&yygotominor.yy186, 1, &yymsp[-3].minor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(75,&yymsp[-6].minor);
  yy_destructor(59,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(76,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2262 "parser.php7.c"
        break;
      case 82:
#line 596 "parser.php7.lemon"
{
	phvolt_ret_break_statement(&yygotominor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(77,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2272 "parser.php7.c"
        break;
      case 83:
#line 604 "parser.php7.lemon"
{
	phvolt_ret_continue_statement(&yygotominor.yy186, status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(78,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2282 "parser.php7.c"
        break;
      case 84:
#line 612 "parser.php7.lemon"
{
	phvolt_ret_literal_zval(&yygotominor.yy186, PHVOLT_T_RAW_FRAGMENT, yymsp[0].minor.yy0, status->scanner_state);
}
#line 2289 "parser.php7.c"
        break;
      case 85:
#line 620 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_MINUS, NULL, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(22,&yymsp[-1].minor);
}
#line 2297 "parser.php7.c"
        break;
      case 86:
#line 624 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_PLUS, NULL, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(21,&yymsp[-1].minor);
}
#line 2305 "parser.php7.c"
        break;
      case 87:
#line 628 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_SUB, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(22,&yymsp[-1].minor);
}
#line 2313 "parser.php7.c"
        break;
      case 88:
#line 632 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ADD, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(21,&yymsp[-1].minor);
}
#line 2321 "parser.php7.c"
        break;
      case 89:
#line 636 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_MUL, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(19,&yymsp[-1].minor);
}
#line 2329 "parser.php7.c"
        break;
      case 90:
#line 640 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_POW, &yymsp[-3].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(19,&yymsp[-2].minor);
  yy_destructor(19,&yymsp[-1].minor);
}
#line 2338 "parser.php7.c"
        break;
      case 91:
#line 644 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_DIV, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(18,&yymsp[-1].minor);
}
#line 2346 "parser.php7.c"
        break;
      case 92:
#line 648 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_MOD, &yymsp[-3].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(18,&yymsp[-2].minor);
  yy_destructor(18,&yymsp[-1].minor);
}
#line 2355 "parser.php7.c"
        break;
      case 93:
#line 652 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_MOD, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(20,&yymsp[-1].minor);
}
#line 2363 "parser.php7.c"
        break;
      case 94:
#line 656 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_AND, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(7,&yymsp[-1].minor);
}
#line 2371 "parser.php7.c"
        break;
      case 95:
#line 660 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_OR, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(8,&yymsp[-1].minor);
}
#line 2379 "parser.php7.c"
        break;
      case 96:
#line 664 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_CONCAT, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(23,&yymsp[-1].minor);
}
#line 2387 "parser.php7.c"
        break;
      case 97:
#line 668 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_PIPE, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(25,&yymsp[-1].minor);
}
#line 2395 "parser.php7.c"
        break;
      case 98:
#line 672 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_RANGE, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(6,&yymsp[-1].minor);
}
#line 2403 "parser.php7.c"
        break;
      case 99:
#line 676 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_EQUALS, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(10,&yymsp[-1].minor);
}
#line 2411 "parser.php7.c"
        break;
      case 100:
#line 680 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOT_ISSET, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(80,&yymsp[0].minor);
}
#line 2420 "parser.php7.c"
        break;
      case 101:
#line 684 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ISSET, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(80,&yymsp[0].minor);
}
#line 2429 "parser.php7.c"
        break;
      case 102:
#line 688 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOT_ISEMPTY, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(81,&yymsp[0].minor);
}
#line 2438 "parser.php7.c"
        break;
      case 103:
#line 692 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ISEMPTY, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(81,&yymsp[0].minor);
}
#line 2447 "parser.php7.c"
        break;
      case 104:
#line 696 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOT_ISEVEN, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(82,&yymsp[0].minor);
}
#line 2456 "parser.php7.c"
        break;
      case 105:
#line 700 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ISEVEN, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(82,&yymsp[0].minor);
}
#line 2465 "parser.php7.c"
        break;
      case 106:
#line 704 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOT_ISODD, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(83,&yymsp[0].minor);
}
#line 2474 "parser.php7.c"
        break;
      case 107:
#line 708 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ISODD, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(83,&yymsp[0].minor);
}
#line 2483 "parser.php7.c"
        break;
      case 108:
#line 712 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOT_ISNUMERIC, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(84,&yymsp[0].minor);
}
#line 2492 "parser.php7.c"
        break;
      case 109:
#line 716 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ISNUMERIC, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(84,&yymsp[0].minor);
}
#line 2501 "parser.php7.c"
        break;
      case 110:
#line 720 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOT_ISSCALAR, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(85,&yymsp[0].minor);
}
#line 2510 "parser.php7.c"
        break;
      case 111:
#line 724 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ISSCALAR, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(85,&yymsp[0].minor);
}
#line 2519 "parser.php7.c"
        break;
      case 112:
#line 728 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOT_ISITERABLE, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(86,&yymsp[0].minor);
}
#line 2528 "parser.php7.c"
        break;
      case 113:
#line 732 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ISITERABLE, &yymsp[-2].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(86,&yymsp[0].minor);
}
#line 2537 "parser.php7.c"
        break;
      case 114:
#line 736 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_IS, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
}
#line 2545 "parser.php7.c"
        break;
      case 115:
#line 740 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOTEQUALS, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
}
#line 2553 "parser.php7.c"
        break;
      case 116:
#line 744 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_IDENTICAL, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(16,&yymsp[-1].minor);
}
#line 2561 "parser.php7.c"
        break;
      case 117:
#line 748 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOTIDENTICAL, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(17,&yymsp[-1].minor);
}
#line 2569 "parser.php7.c"
        break;
      case 118:
#line 752 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_LESS, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(12,&yymsp[-1].minor);
}
#line 2577 "parser.php7.c"
        break;
      case 119:
#line 756 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_GREATER, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(13,&yymsp[-1].minor);
}
#line 2585 "parser.php7.c"
        break;
      case 120:
#line 760 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_GREATEREQUAL, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(14,&yymsp[-1].minor);
}
#line 2593 "parser.php7.c"
        break;
      case 121:
#line 764 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_LESSEQUAL, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(15,&yymsp[-1].minor);
}
#line 2601 "parser.php7.c"
        break;
      case 123:
#line 772 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_IN, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(3,&yymsp[-1].minor);
}
#line 2609 "parser.php7.c"
        break;
      case 124:
#line 776 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOT_IN, &yymsp[-3].minor.yy186, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(26,&yymsp[-2].minor);
  yy_destructor(3,&yymsp[-1].minor);
}
#line 2618 "parser.php7.c"
        break;
      case 125:
#line 780 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_NOT, NULL, &yymsp[0].minor.yy186, NULL, status->scanner_state);
  yy_destructor(26,&yymsp[-1].minor);
}
#line 2626 "parser.php7.c"
        break;
      case 126:
#line 784 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_INCR, &yymsp[-1].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(27,&yymsp[0].minor);
}
#line 2634 "parser.php7.c"
        break;
      case 127:
#line 788 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_DECR, &yymsp[-1].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(28,&yymsp[0].minor);
}
#line 2642 "parser.php7.c"
        break;
      case 128:
#line 792 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ENCLOSED, &yymsp[-1].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(29,&yymsp[-2].minor);
  yy_destructor(52,&yymsp[0].minor);
}
#line 2651 "parser.php7.c"
        break;
      case 129:
#line 796 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ARRAY, NULL, NULL, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-1].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2660 "parser.php7.c"
        break;
      case 130:
#line 800 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ARRAY, &yymsp[-1].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-2].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2669 "parser.php7.c"
        break;
      case 131:
#line 804 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ARRAY, NULL, NULL, NULL, status->scanner_state);
  yy_destructor(87,&yymsp[-1].minor);
  yy_destructor(88,&yymsp[0].minor);
}
#line 2678 "parser.php7.c"
        break;
      case 132:
#line 808 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_ARRAY, &yymsp[-1].minor.yy186, NULL, NULL, status->scanner_state);
  yy_destructor(87,&yymsp[-2].minor);
  yy_destructor(88,&yymsp[0].minor);
}
#line 2687 "parser.php7.c"
        break;
      case 134:
#line 816 "parser.php7.lemon"
{
	phvolt_ret_expr(&yygotominor.yy186, PHVOLT_T_TERNARY, &yymsp[-2].minor.yy186, &yymsp[0].minor.yy186, &yymsp[-4].minor.yy186, status->scanner_state);
  yy_destructor(4,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-1].minor);
}
#line 2696 "parser.php7.c"
        break;
      case 135:
#line 820 "parser.php7.lemon"
{
	phvolt_ret_slice(&yygotominor.yy186, &yymsp[-4].minor.yy186, NULL, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(24,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-2].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2706 "parser.php7.c"
        break;
      case 136:
#line 824 "parser.php7.lemon"
{
	phvolt_ret_slice(&yygotominor.yy186, &yymsp[-4].minor.yy186, &yymsp[-2].minor.yy186, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2716 "parser.php7.c"
        break;
      case 137:
#line 828 "parser.php7.lemon"
{
	phvolt_ret_slice(&yygotominor.yy186, &yymsp[-5].minor.yy186, &yymsp[-3].minor.yy186, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(24,&yymsp[-4].minor);
  yy_destructor(5,&yymsp[-2].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2726 "parser.php7.c"
        break;
      case 142:
      case 150:
#line 860 "parser.php7.lemon"
{
	phvolt_ret_named_item(&yygotominor.yy186, yymsp[-2].minor.yy0, &yymsp[0].minor.yy186, status->scanner_state);
  yy_destructor(5,&yymsp[-1].minor);
}
#line 2735 "parser.php7.c"
        break;
      case 143:
      case 149:
#line 864 "parser.php7.lemon"
{
	phvolt_ret_named_item(&yygotominor.yy186, NULL, &yymsp[0].minor.yy186, status->scanner_state);
}
#line 2743 "parser.php7.c"
        break;
      case 145:
#line 876 "parser.php7.lemon"
{
	phvolt_ret_func_call(&yygotominor.yy186, &yymsp[-3].minor.yy186, &yymsp[-1].minor.yy186, status->scanner_state);
  yy_destructor(29,&yymsp[-2].minor);
  yy_destructor(52,&yymsp[0].minor);
}
#line 2752 "parser.php7.c"
        break;
      case 146:
#line 880 "parser.php7.lemon"
{
	phvolt_ret_func_call(&yygotominor.yy186, &yymsp[-2].minor.yy186, NULL, status->scanner_state);
  yy_destructor(29,&yymsp[-1].minor);
  yy_destructor(52,&yymsp[0].minor);
}
#line 2761 "parser.php7.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  phvolt_ARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  phvolt_ARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 37 "parser.php7.lemon"

	{

		smart_str error_str = {0};

		char *token_name = NULL;
		const phvolt_token_names *tokens = phvolt_tokens;
		int token_len = 0;
		int active_token = status->scanner_state->active_token;

		if (status->scanner_state->start_length) {

			if (active_token) {

				do {
					if (tokens->code == active_token) {
						token_name = tokens->name;
						token_len = tokens->len;
						break;
					}
					++tokens;
				} while (tokens[0].code != 0);

			}

			smart_str_appendl(&error_str, "Syntax error, unexpected token ", sizeof("Syntax error, unexpected token ") - 1);
			if (!token_name) {
				smart_str_appendl(&error_str, "UNKNOWN", sizeof("UNKNOWN") - 1);
			} else {
				smart_str_appendl(&error_str, token_name, token_len);
			}

			if (status->token->value) {
				smart_str_appendc(&error_str, '(');
				smart_str_appendl(&error_str, status->token->value, status->token->len);
				smart_str_appendc(&error_str, ')');
			}

			smart_str_appendl(&error_str, " in ", sizeof(" in ") - 1);
			smart_str_appendl(&error_str, Z_STRVAL_P(status->scanner_state->active_file), Z_STRLEN_P(status->scanner_state->active_file));
			smart_str_appendl(&error_str, " on line ", sizeof(" on line ") - 1);

			{
				char stmp[MAX_LENGTH_OF_LONG + 1];
				int str_len;
				str_len = slprintf(stmp, sizeof(stmp), "%u", status->scanner_state->active_line);
				smart_str_appendl(&error_str, stmp, str_len);
			}

		} else {

			smart_str_appendl(&error_str, "Syntax error, unexpected EOF in ", sizeof("Syntax error, unexpected EOF in ") - 1);
			smart_str_appendl(&error_str, Z_STRVAL_P(status->scanner_state->active_file), Z_STRLEN_P(status->scanner_state->active_file));

			/* Report unclosed 'if' blocks */
			if ((status->scanner_state->if_level + status->scanner_state->old_if_level) > 0) {
				if ((status->scanner_state->if_level + status->scanner_state->old_if_level) == 1) {
					smart_str_appendl(&error_str, ", there is one 'if' block without close", sizeof(", there is one 'if' block without close") - 1);
				} else {
					smart_str_appendl(&error_str, ", there are ", sizeof(", there are ") - 1);
					{
						char stmp[MAX_LENGTH_OF_LONG + 1];
						int str_len;
						str_len = slprintf(stmp, sizeof(stmp), "%u", status->scanner_state->if_level + status->scanner_state->old_if_level);
						smart_str_appendl(&error_str, stmp, str_len);
					}
					smart_str_appendl(&error_str, " 'if' blocks without close", sizeof(" 'if' blocks without close") - 1);
				}
			}

			/* Report unclosed 'for' blocks */
			if (status->scanner_state->for_level > 0) {
				if (status->scanner_state->for_level == 1) {
					smart_str_appendl(&error_str, ", there is one 'for' block without close", sizeof(", there is one 'for' block without close") - 1);
				} else {
					smart_str_appendl(&error_str, ", there are ", sizeof(", there are ") - 1);
					{
						char stmp[MAX_LENGTH_OF_LONG + 1];
						int str_len;
						str_len = slprintf(stmp, sizeof(stmp), "%u", status->scanner_state->if_level);
						smart_str_appendl(&error_str, stmp, str_len);
					}
					smart_str_appendl(&error_str, " 'for' blocks without close", sizeof(" 'for' blocks without close") - 1);
				}
			}

			/* Report unclosed 'switch' blocks */
			if (status->scanner_state->switch_level > 0) {
				smart_str_appendl(&error_str, ", there is a 'switch' block without 'endswitch'", sizeof(", there is a 'switch' block without 'endswitch'") - 1);
			}
		}

		smart_str_0(&error_str);

		if (error_str.s) {
			status->syntax_error = estrndup(ZSTR_VAL(error_str.s), ZSTR_LEN(error_str.s));
			status->syntax_error_len = ZSTR_LEN(error_str.s);
		} else {
			status->syntax_error = NULL;
		}
	}

	status->status = PHVOLT_PARSING_FAILED;

#line 2908 "parser.php7.c"
  phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  phvolt_ARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "phvolt_Alloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void phvolt_(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  phvolt_TOKENTYPE yyminor       /* The value for the token */
  phvolt_ARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  phvolt_ARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
