#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.12';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 97 => 0x69 },
	'about' => { 417 => 'about' },
	'aboutcvterm' => { 408 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 408 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 408 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 408 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 408 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 423 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 73 => 0x518 },
	'accelerometer' => { 330 => 0x3 },
	'accelerometerx' => { 269 => 0x8d },
	'accelerometery' => { 269 => 0x8e },
	'accelerometerz' => { 269 => 0x8c },
	'accessoryserialnumber' => { 269 => 0x54 },
	'accessorytype' => { 269 => 0x53 },
	'acedemicfield' => { 413 => 'acedemicField' },
	'actionadvised' => { 113 => 0x2a },
	'activearea' => { 105 => 0xc68d },
	'actived-lighting' => { 193 => 0x22, 227 => 0x24 },
	'actived-lightingmode' => { 227 => 0x25 },
	'adaptervoltage' => { 119 => 0x407 },
	'addaspectratioinfo' => { 73 => 0x80e },
	'additionalmodelinformation' => { 408 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 73 => 0x80f, 74 => 0x11, 75 => 0x13, 78 => 0x14 },
	'address' => { 140 => 'Address' },
	'adjustmentmode' => { 336 => 0x15 },
	'adobe' => { 106 => 'Adobe' },
	'adultcontentwarning' => { 411 => 'AdultContentWarning', 416 => 'adultContentWarning' },
	'advancedfilter' => { 110 => 0x1201 },
	'advancedraw' => { 229 => 0x76a43203 },
	'advancedscenetype' => { 269 => 0x3d },
	'advisory' => { 421 => 'Advisory' },
	'ae_iso' => { 276 => 0x2, 277 => 0x4, 278 => 0x12 },
	'aeaperture' => { 276 => 0x1, 277 => 0x3, 278 => 0x11 },
	'aeaperturesteps' => { 276 => 0x8, 277 => 0xb },
	'aebautocancel' => { 73 => 0x104 },
	'aebbracketvalue' => { 67 => 0x11 },
	'aebsequence' => { 73 => 0x105 },
	'aebsequenceautocancel' => { 71 => 0x9, 72 => 0x9, 74 => 0x8, 75 => 0x9, 78 => 0x9, 79 => 0x7 },
	'aebshotcount' => { 73 => 0x106 },
	'aebxv' => { 276 => 0x4, 277 => 0x6 },
	'aeerror' => { 277 => 0x8 },
	'aeexposuretime' => { 276 => 0x0, 277 => 0x2, 278 => 0x10 },
	'aelbutton' => { 160 => 0x45 },
	'aelexposureindicator' => { 160 => 0x51 },
	'aelock' => { 160 => 0x5b, 238 => '4.2', 244 => '4.2', 249 => 0x201, 302 => 0x48, 343 => 0x40, 344 => 0x40, 345 => [0x86,0x286] },
	'aelockbutton' => { 236 => '16.1', 238 => '4.1', 239 => '15.1', 240 => '16.1', 241 => '16.1', 242 => '30.1', 243 => '16.1', 244 => '4.1', 246 => '17.1', 247 => '17.1' },
	'aelockbuttonplusdials' => { 236 => '16.2', 242 => '32.1', 246 => '44.1' },
	'aelockformb-d80' => { 247 => '3.1' },
	'aemaxaperture' => { 276 => 0x9, 277 => 0x10, 278 => 0x1c },
	'aemaxaperture2' => { 276 => 0xa, 277 => 0x11, 278 => 0x1d },
	'aemeteringmode' => { 276 => 0xc },
	'aemeteringmode2' => { 276 => '13.1' },
	'aemeteringsegments' => { 163 => 0x628, 302 => 0x209 },
	'aemicroadjustment' => { 73 => 0x110 },
	'aeminaperture' => { 276 => 0xb, 277 => 0x12, 278 => 0x1e },
	'aeminexposuretime' => { 276 => 0x5, 277 => 0x13, 278 => 0x1f },
	'aeprogrammode' => { 276 => 0x6 },
	'aeprojectlink' => { 397 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 397 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 397 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 397 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 397 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 397 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 31 => 0x21 },
	'aewhitebalance' => { 276 => 0xd },
	'aexv' => { 276 => 0x3, 277 => 0x5 },
	'af-cpriorityselection' => { 236 => '1.1', 237 => '1.1', 240 => '0.1', 241 => '0.1', 242 => '1.1', 243 => '0.1', 246 => '1.1' },
	'af-onformb-d10' => { 236 => '3.3', 242 => '3.2' },
	'af-onformb-d11' => { 243 => '2.2' },
	'af-onformb-d12' => { 246 => '50.1' },
	'af-spriorityselection' => { 236 => '1.2', 237 => '1.2', 242 => '1.2', 243 => '0.2', 246 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 236 => '2.1', 237 => '2.1', 242 => '2.1', 246 => '2.1' },
	'afadjustment' => { 302 => 0x72 },
	'afandmeteringbuttons' => { 73 => 0x701 },
	'afaperture' => { 189 => 0x5, 190 => 0x5 },
	'afareaheight' => { 169 => 0x1a },
	'afareaillumination' => { 160 => 0x4b, 244 => '15.3' },
	'afareamode' => { 156 => 0x33, 160 => 0xe, 168 => 0x0, 169 => 0x5, 269 => 0xf, 327 => 0x1205, 337 => [0xa,0x3a], 343 => 0x11, 344 => 0x10, 345 => 0x24, 355 => 0xb043, 374 => 0x17 },
	'afareamodesetting' => { 238 => '11.1', 239 => '0.1', 244 => '16.1', 247 => '2.1', 355 => 0x201c },
	'afareas' => { 249 => 0x304 },
	'afareaselectmethod' => { 73 => 0x51b },
	'afareawidth' => { 169 => 0x18 },
	'afareaxposition' => { 169 => 0x14, 327 => 0x1203 },
	'afareaxposition1' => { 327 => 0x1201 },
	'afareayposition' => { 169 => 0x16, 327 => 0x1204 },
	'afareayposition1' => { 327 => 0x1202 },
	'afassist' => { 71 => 0x5, 79 => 0x5, 160 => 0x48, 236 => '2.5', 238 => '0.2', 239 => '0.2', 240 => '1.1', 241 => '1.1', 242 => '2.4', 243 => '1.4', 244 => '0.2', 246 => '2.4', 247 => '2.3' },
	'afassistbeam' => { 73 => 0x50e, 74 => 0x4, 75 => 0x5, 76 => 0x4, 77 => 0x4, 78 => 0x5 },
	'afassistlamp' => { 269 => 0x31 },
	'afbuttonpressed' => { 345 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 279 => 0x6 },
	'afduringliveview' => { 73 => 0x511 },
	'affinea' => { 391 => 'AffineA' },
	'affineb' => { 391 => 'AffineB' },
	'affinec' => { 391 => 'AffineC' },
	'affined' => { 391 => 'AffineD' },
	'affinetune' => { 170 => 0x0, 249 => 0x306 },
	'affinetuneadj' => { 170 => 0x2, 202 => 0x2d1, 203 => 0x2dc, 249 => 0x307 },
	'affinetuneindex' => { 170 => 0x1 },
	'affinex' => { 391 => 'AffineX' },
	'affiney' => { 391 => 'AffineY' },
	'afhold' => { 279 => 0x1fd },
	'afilluminator' => { 343 => 0x29, 355 => 0xb044 },
	'afimageheight' => { 169 => 0x12 },
	'afimagewidth' => { 169 => 0x10 },
	'afintegrationtime' => { 279 => 0x7 },
	'afmicroadj' => { 337 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 340 => 0x131 },
	'afmicroadjregisteredlenses' => { 340 => '305.1' },
	'afmicroadjustment' => { 73 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 340 => 0x130 },
	'afmode' => { 101 => 0x3009, 110 => 0x1022, 156 => 0x16, 336 => 0x5 },
	'afmoderestrictions' => { 237 => '50.3', 246 => '48.3' },
	'afonaelockbuttonswitch' => { 73 => 0x702 },
	'afonbutton' => { 236 => '3.1', 237 => '47.1' },
	'afpoint' => { 31 => 0x13, 100 => 0x18, 156 => 0x15, 168 => 0x1, 252 => 0x308, 336 => 0x1f, 337 => 0x7, 340 => 0x19, 341 => 0x18, 342 => [0x18,0x20] },
	'afpointactivationarea' => { 72 => 0x11, 78 => 0x11 },
	'afpointareaexpansion' => { 73 => 0x508 },
	'afpointatshutterrelease' => { 337 => 0x9 },
	'afpointautoselection' => { 73 => 0x50b },
	'afpointbrightness' => { 73 => 0x50d, 236 => '2.4', 237 => '46.5', 246 => '2.3' },
	'afpointdisplayduringfocus' => { 73 => 0x50c },
	'afpointillumination' => { 72 => 0xa, 236 => '2.3', 237 => '46.2', 242 => '2.3', 243 => '1.3', 246 => '47.2', 247 => '2.4' },
	'afpointinfocus' => { 337 => 0x8 },
	'afpointmode' => { 283 => 0x3 },
	'afpointposition' => { 101 => 0x2021, 269 => 0x4d },
	'afpointregistration' => { 71 => 0x7 },
	'afpoints' => { 159 => 0x10 },
	'afpointselected' => { 160 => 0xd, 249 => 0x305, 302 => 0xe, 340 => 0x15, 341 => 0x14, 342 => [0x14,0x1c], 355 => 0x201e },
	'afpointselected2' => { 283 => 0x4 },
	'afpointselection' => { 72 => 0xb, 236 => '1.3', 237 => '1.3', 242 => '1.3', 246 => '1.3' },
	'afpointselectionmethod' => { 73 => 0x50f, 74 => 0xc, 75 => 0xd, 78 => 0xd },
	'afpointsetting' => { 343 => 0x12, 344 => 0x11 },
	'afpointsinfocus' => { 67 => 0xe, 168 => 0x2, 279 => 0xb, 302 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 72 => 0xd },
	'afpointsselected' => { 381 => 0x4 },
	'afpointsunknown1' => { 279 => 0x0 },
	'afpointsunknown2' => { 279 => 0x2 },
	'afpointsused' => { 169 => 0x8, 337 => 0x16e },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 279 => 0x4 },
	'afresponse' => { 193 => 0xad },
	'afresult' => { 254 => 0x1038 },
	'afsearch' => { 249 => 0x303 },
	'afsensoractive' => { 156 => 0x1 },
	'afstatus' => { 327 => 0x1200 },
	'afstatusactivesensor' => { 156 => 0x2, 337 => 0x4, 340 => 0x1e, 341 => 0x1b, 342 => [0x1b,0x21] },
	'afstatusbottom' => { 156 => 0x8, 340 => 0x2a, 341 => 0x21, 342 => 0x21 },
	'afstatusbottom-left' => { 156 => 0x12, 341 => 0x2b, 342 => 0x2b },
	'afstatusbottom-right' => { 156 => 0x6, 341 => 0x1f, 342 => 0x1f },
	'afstatusbottomassist-left' => { 340 => 0x28 },
	'afstatusbottomassist-right' => { 340 => 0x2c },
	'afstatusbottomhorizontal' => { 338 => 0x10, 339 => 0x1c },
	'afstatusbottomvertical' => { 338 => 0x16, 339 => 0x26 },
	'afstatuscenter-10' => { 340 => 0x34 },
	'afstatuscenter-11' => { 340 => 0x36 },
	'afstatuscenter-12' => { 340 => 0x38 },
	'afstatuscenter-14' => { 340 => 0x3c },
	'afstatuscenter-7' => { 340 => 0x2e },
	'afstatuscenter-9' => { 340 => 0x32 },
	'afstatuscenter-horizontal' => { 340 => 0x30 },
	'afstatuscenter-vertical' => { 340 => 0x3a },
	'afstatuscenterf2-8' => { 340 => 0x4c },
	'afstatuscenterhorizontal' => { 156 => 0x2f, 338 => 0xc, 339 => 0x18, 341 => 0x2f, 342 => 0x2f },
	'afstatuscentervertical' => { 156 => 0xc, 338 => 0x14, 339 => 0x22, 341 => 0x25, 342 => 0x25 },
	'afstatusfarleft' => { 338 => 0x6, 340 => 0x26 },
	'afstatusfarlefthorizontal' => { 339 => 0x4 },
	'afstatusfarleftvertical' => { 339 => 0x12 },
	'afstatusfarright' => { 338 => 0x18, 340 => 0x44 },
	'afstatusfarrighthorizontal' => { 339 => 0x2c },
	'afstatusfarrightvertical' => { 339 => 0x34 },
	'afstatusleft' => { 156 => 0x2d, 338 => 0x2, 340 => 0x22, 341 => 0x2d, 342 => 0x2d },
	'afstatuslefthorizontal' => { 339 => 0x6 },
	'afstatusleftvertical' => { 339 => 0xe },
	'afstatuslower-left' => { 338 => 0x4, 340 => 0x24 },
	'afstatuslower-lefthorizontal' => { 339 => 0xa },
	'afstatuslower-leftvertical' => { 339 => 0x10 },
	'afstatuslower-middle' => { 338 => 0x22, 339 => 0x24 },
	'afstatuslower-right' => { 338 => 0x1e, 340 => 0x4a },
	'afstatuslower-righthorizontal' => { 339 => 0x32 },
	'afstatuslower-rightvertical' => { 339 => 0x3a },
	'afstatuslowerfarleft' => { 339 => 0x8 },
	'afstatuslowerfarright' => { 339 => 0x30 },
	'afstatusmiddlehorizontal' => { 156 => 0xa, 341 => 0x23, 342 => 0x23 },
	'afstatusnearleft' => { 338 => 0xe, 339 => 0x1a },
	'afstatusnearright' => { 338 => 0xa, 339 => 0x16 },
	'afstatusright' => { 156 => 0x31, 338 => 0x1c, 340 => 0x48, 341 => 0x31, 342 => 0x31 },
	'afstatusrighthorizontal' => { 339 => 0x2e },
	'afstatusrightvertical' => { 339 => 0x38 },
	'afstatustop' => { 156 => 0xe, 340 => 0x40, 341 => 0x27, 342 => 0x27 },
	'afstatustop-left' => { 156 => 0x10, 341 => 0x29, 342 => 0x29 },
	'afstatustop-right' => { 156 => 0x4, 341 => 0x1d, 342 => 0x1d },
	'afstatustopassist-left' => { 340 => 0x3e },
	'afstatustopassist-right' => { 340 => 0x42 },
	'afstatustophorizontal' => { 338 => 0x8, 339 => 0x14 },
	'afstatustopvertical' => { 338 => 0x12, 339 => 0x1e },
	'afstatusupper-left' => { 338 => 0x0, 340 => 0x20 },
	'afstatusupper-lefthorizontal' => { 339 => 0x2 },
	'afstatusupper-leftvertical' => { 339 => 0xc },
	'afstatusupper-middle' => { 338 => 0x20, 339 => 0x20 },
	'afstatusupper-right' => { 338 => 0x1a, 340 => 0x46 },
	'afstatusupper-righthorizontal' => { 339 => 0x2a },
	'afstatusupper-rightvertical' => { 339 => 0x36 },
	'afstatusupperfarleft' => { 339 => 0x0 },
	'afstatusupperfarright' => { 339 => 0x28 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 337 => 0x2 },
	'afwithshutter' => { 343 => 0x2a },
	'afzoneselected' => { 355 => 0x201e },
	'aggregateissuenumber' => { 413 => 'aggregateIssueNumber' },
	'aggregationtype' => { 413 => 'aggregationType' },
	'agreement' => { 416 => 'agreement' },
	'aiservocontinuousshooting' => { 72 => 0x15 },
	'aiservofirstimagepriority' => { 73 => 0x519 },
	'aiservoimagepriority' => { 73 => 0x503 },
	'aiservosecondimagepriority' => { 73 => 0x51a },
	'aiservotrackingmethod' => { 73 => 0x504 },
	'aiservotrackingsensitivity' => { 72 => 0x14, 73 => 0x502 },
	'album' => { 423 => 'album' },
	'alreadyapplied' => { 398 => 'AlreadyApplied' },
	'alternatetitle' => { 413 => 'alternateTitle' },
	'alternatetitlea-lang' => { 413 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 413 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 413 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 171 => 0x6 },
	'alttapename' => { 423 => 'altTapeName' },
	'alttimecode' => { 423 => 'altTimecode' },
	'alttimecodetimeformat' => { 423 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 423 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 423 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 323 => 0x14, 374 => 0x4 },
	'ambienttemperaturefahrenheit' => { 323 => 0x13 },
	'analogbalance' => { 105 => 0xc627 },
	'angleadj' => { 91 => 0x10003, 97 => 0x8b },
	'angleinforoll' => { 393 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 393 => 'AngleInfoYaw' },
	'anti-blur' => { 355 => 0xb04b },
	'antialiasstrength' => { 105 => 0xc632 },
	'aperturelock' => { 237 => '38.2', 246 => '38.2' },
	'aperturerange' => { 73 => 0x10d },
	'apertureringuse' => { 283 => '1.4' },
	'aperturesetting' => { 160 => 0x7, 343 => 0x30, 344 => 0x29, 345 => 0x1 },
	'aperturevalue' => { 82 => 0x2, 105 => 0x9202, 254 => 0x1002, 311 => 0x401, 402 => 'ApertureValue' },
	'applekeywords' => { 258 => 'AAPL:Keywords' },
	'applicationnotes' => { 105 => 0x2bc, 273 => 0x2bc },
	'applicationrecordversion' => { 113 => 0x0 },
	'applyshootingmeteringmode' => { 73 => 0x10e },
	'approved' => { 404 => 'Approved' },
	'approvedby' => { 404 => 'ApprovedBy' },
	'approximatefnumber' => { 265 => 0x313, 271 => 0x3406 },
	'approximatefocusdistance' => { 394 => 'ApproximateFocusDistance' },
	'aquahsl' => { 91 => 0x20913 },
	'armidentifier' => { 114 => 0x78 },
	'armversion' => { 114 => 0x7a },
	'artfilter' => { 249 => 0x529 },
	'artfiltereffect' => { 249 => 0x52f },
	'artist' => { 105 => 0x13b, 261 => 'Artist', 302 => 0x22e, 419 => 'Artist', 423 => 'artist' },
	'artmode' => { 101 => 0x301b },
	'artmodeparameters' => { 101 => 0x310b },
	'artworkcircadatecreated' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 408 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 408 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 253 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 253 => 0x1112, 302 => 0x80, 343 => 0x55, 344 => 0x55, 345 => 0xa },
	'asshoticcprofile' => { 105 => 0xc68f },
	'asshotneutral' => { 105 => 0xc628 },
	'asshotpreprofilematrix' => { 105 => 0xc690 },
	'asshotprofilename' => { 105 => 0xc6f6 },
	'asshotwhitexy' => { 105 => 0xc629 },
	'assignbktbutton' => { 236 => '4.2', 237 => '16.1', 246 => '16.1' },
	'assignfuncbutton' => { 73 => 0x70b },
	'assignmovierecordbutton' => { 237 => '43.2', 246 => '45.1' },
	'assignremotefnbutton' => { 237 => '54.1', 246 => '51.1' },
	'assistbuttonfunction' => { 71 => 0xd },
	'attributionname' => { 395 => 'attributionName' },
	'attributionurl' => { 395 => 'attributionURL' },
	'audio' => { 269 => 0x20 },
	'audiobitrate' => { 58 => 0x6c },
	'audiochannels' => { 58 => 0x70 },
	'audiochanneltype' => { 423 => 'audioChannelType' },
	'audiocompression' => { 134 => 'Compression' },
	'audiocompressor' => { 423 => 'audioCompressor' },
	'audioduration' => { 113 => 0x99 },
	'audiomoddate' => { 423 => 'audioModDate' },
	'audiooutcue' => { 113 => 0x9a },
	'audiosamplerate' => { 58 => 0x6e, 423 => 'audioSampleRate' },
	'audiosampletype' => { 423 => 'audioSampleType' },
	'audiosamplingrate' => { 113 => 0x97 },
	'audiosamplingresolution' => { 113 => 0x98 },
	'audiotype' => { 113 => 0x96 },
	'author' => { 136 => 'Author', 258 => 'Author', 261 => 'Author', 318 => 'Author', 392 => 'author', 409 => 'Author', 421 => 'Author' },
	'authorsposition' => { 410 => 'AuthorsPosition' },
	'autoaperture' => { 293 => '0.1' },
	'autobracket' => { 336 => 0x19 },
	'autobracketing' => { 110 => 0x1100, 302 => 0x18, 327 => 0x1007 },
	'autobracketingmode' => { 245 => '12.3' },
	'autobracketingset' => { 245 => '12.1' },
	'autobracketmodem' => { 236 => '21.2', 237 => '13.3', 242 => '26.2', 246 => '13.3' },
	'autobracketorder' => { 160 => 0x43, 236 => '21.3', 237 => '13.2', 242 => '26.3', 243 => '12.2', 244 => '2.2', 245 => '12.2', 246 => '13.2', 247 => '13.2' },
	'autobracketset' => { 236 => '21.1', 237 => '13.1', 239 => '11.1', 240 => '12.1', 241 => '12.1', 242 => '26.1', 243 => '12.1', 244 => '2.1', 246 => '13.1', 247 => '13.1' },
	'autobrightness' => { 398 => 'AutoBrightness' },
	'autocontrast' => { 398 => 'AutoContrast' },
	'autodistortioncontrol' => { 179 => 0x4 },
	'autodynamicrange' => { 110 => 0x140b },
	'autoexposure' => { 398 => 'AutoExposure' },
	'autoexposurebracketing' => { 67 => 0x10 },
	'autofocus' => { 252 => 0x209 },
	'autofp' => { 244 => '7.3', 247 => '31.4' },
	'autoiso' => { 67 => 0x1, 101 => 0x3008, 238 => '1.1', 244 => '1.1' },
	'autoisomax' => { 238 => '1.2', 244 => '1.2' },
	'autoisominshutterspeed' => { 238 => '1.3', 244 => '1.3' },
	'autolateralca' => { 398 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 54 => 0x2, 73 => 0x204, 91 => 0x20500, 97 => 0x6f },
	'autolightingoptimizeron' => { 91 => '0x20500.0', 97 => 0x6e },
	'autoportraitframed' => { 355 => 0x2016 },
	'autoredeye' => { 229 => 0xfe28a44f },
	'autorotate' => { 67 => 0x1b },
	'autoshadows' => { 398 => 'AutoShadows' },
	'autowhiteversion' => { 398 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 193 => 0x82 },
	'avaperturesetting' => { 283 => 0x13 },
	'averageblacklevel' => { 38 => 0xe7, 40 => 0xfb, 41 => 0x114, 42 => 0x146 },
	'averagelv' => { 163 => 0x38 },
	'avsettingwithoutlens' => { 73 => 0x707 },
	'azimuth' => { 144 => 'Azimuth' },
	'babyage' => { 269 => [0x8010,0x33] },
	'babyname' => { 269 => 0x66 },
	'backgroundalpha' => { 418 => 'bgalpha' },
	'baseexposurecompensation' => { 283 => 0x15 },
	'baseiso' => { 67 => 0x2, 86 => 0x101c, 119 => 0x903, 271 => 0x312a, 379 => 0x6 },
	'baselineexposure' => { 105 => 0xc62a },
	'baselineexposureoffset' => { 105 => 0xc7a5 },
	'baselinenoise' => { 105 => 0xc62b },
	'baselinesharpness' => { 105 => 0xc62c },
	'baseurl' => { 421 => 'BaseURL' },
	'batterylevel' => { 343 => 0x51, 347 => 0xc, 348 => 0x4, 349 => 0x4, 380 => 0x7 },
	'batterylevelgrip1' => { 380 => 0x6 },
	'batterylevelgrip2' => { 380 => 0x8 },
	'batteryorder' => { 236 => '12.5', 242 => '13.2', 243 => '2.1', 246 => '3.1' },
	'batterystate' => { 160 => 0x60, 343 => 0x50, 349 => 0x14 },
	'batterytemperature' => { 347 => 0x1, 349 => 0x2, 380 => 0x5 },
	'batteryunknown' => { 347 => 0x2, 349 => 0x0 },
	'batteryvoltage' => { 119 => 0x408, 323 => 0x2a, 347 => 0x8 },
	'batteryvoltage1' => { 349 => 0x6 },
	'batteryvoltage2' => { 349 => 0x8 },
	'bayergreensplit' => { 105 => 0xc62d },
	'bayerpattern' => { 118 => 0xf902, 164 => 0x17 },
	'beatspliceparams' => { 423 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 423 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 423 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 423 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 423 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 423 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 236 => '13.1', 237 => '5.4', 238 => '0.1', 239 => '2.1', 240 => '3.1', 241 => '3.1', 242 => '10.1', 244 => '0.1', 246 => '5.5', 247 => '4.1' },
	'beeppitch' => { 243 => '3.1' },
	'beepvolume' => { 243 => '4.5' },
	'bestqualityscale' => { 105 => 0xc65c },
	'bestshotmode' => { 101 => 0x3007 },
	'bitdepth' => { 141 => 'BitDepth', 164 => 0x11, 199 => 0x41 },
	'bitspercomponent' => { 115 => 0x87 },
	'bitspersample' => { 105 => 0x102, 419 => 'BitsPerSample' },
	'blacklevel' => { 105 => 0xc61a, 193 => 0x3d, 254 => [0x401,0x1012], 311 => 0x21d },
	'blacklevel1' => { 273 => 0x8 },
	'blacklevel2' => { 253 => 0x600, 257 => 0x600, 273 => 0x9 },
	'blacklevel3' => { 273 => 0xa },
	'blacklevelblue' => { 273 => 0x1e },
	'blackleveldata' => { 311 => 0x223 },
	'blackleveldeltah' => { 105 => 0xc61b },
	'blackleveldeltav' => { 105 => 0xc61c },
	'blacklevelgreen' => { 273 => 0x1d },
	'blacklevelred' => { 273 => 0x1c },
	'blacklevelrepeatdim' => { 105 => 0xc619 },
	'blackpoint' => { 302 => 0x200 },
	'blacks2012' => { 398 => 'Blacks2012' },
	'bleachbypasstoning' => { 302 => 0x7f },
	'blogtitle' => { 413 => 'blogTitle' },
	'blogurl' => { 413 => 'blogURL' },
	'bluebalance' => { 177 => 0x271, 254 => 0x1018, 273 => 0x12, 302 => 0x1b },
	'bluecurvelimits' => { 96 => 0x1fe },
	'bluecurvepoints' => { 95 => 0x79, 96 => 0x1d4 },
	'bluehsl' => { 91 => [0x20914,0x20915] },
	'bluehue' => { 398 => 'BlueHue' },
	'bluesaturation' => { 398 => 'BlueSaturation' },
	'blurcontrol' => { 302 => 0x82 },
	'blurwarning' => { 110 => 0x1300 },
	'bodybatteryadload' => { 281 => 0x3 },
	'bodybatteryadnoload' => { 281 => 0x2 },
	'bodybatterystate' => { 281 => '1.1' },
	'bodybatteryvoltage1' => { 281 => 0x2 },
	'bodybatteryvoltage2' => { 281 => 0x4 },
	'bodybatteryvoltage3' => { 281 => 0x6 },
	'bodybatteryvoltage4' => { 281 => 0x8 },
	'bodyfirmware' => { 328 => 0x0 },
	'bodyfirmwareversion' => { 250 => 0x104, 251 => 0x100, 254 => 0x104 },
	'bodyserialnumber' => { 328 => 0x10 },
	'bookedition' => { 413 => 'bookEdition' },
	'bracketmode' => { 49 => 0x3 },
	'bracketsequence' => { 101 => 0x301d },
	'bracketsettings' => { 269 => 0x45 },
	'bracketshotnumber' => { 49 => 0x5, 283 => 0x9, 354 => 0x2b },
	'bracketshotnumber2' => { 354 => 0x2d },
	'bracketstep' => { 157 => 0xe },
	'bracketvalue' => { 49 => 0x4 },
	'brightness' => { 105 => 0xfe53, 135 => 'Brightness', 153 => 'Brightness', 157 => 0x2c, 195 => 0x34, 323 => 0x25, 343 => 0x22, 355 => 0x2007, 398 => 'Brightness' },
	'brightnessadj' => { 96 => 0x114, 222 => 0x0, 232 => 0x2d, 383 => 0x8018 },
	'brightnessvalue' => { 105 => 0x9203, 163 => [0x691,0x49c3], 254 => 0x1003, 359 => 0x1e, 362 => 0x1140, 363 => 0x1140, 364 => 0x111c, 365 => 0x1198, 366 => 0x1174, 367 => 0x102c, 368 => 0x224, 369 => 0x224, 402 => 'BrightnessValue' },
	'bulbduration' => { 67 => 0x18 },
	'burstmode' => { 121 => 0xa, 269 => 0x2a },
	'burstmode2' => { 121 => 0x18 },
	'burstshot' => { 336 => 0x34 },
	'burstspeed' => { 269 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 73 => 0x70a },
	'bwfilter' => { 157 => 0x2a, 165 => 0x39 },
	'bwmode' => { 254 => 0x203 },
	'by-line' => { 113 => 0x50 },
	'by-linetitle' => { 113 => 0x55 },
	'bytecount' => { 413 => 'byteCount' },
	'calibration' => { 336 => [0x24,0x30] },
	'calibrationilluminant1' => { 105 => 0xc65a },
	'calibrationilluminant2' => { 105 => 0xc65b },
	'cameraangle' => { 423 => 'cameraAngle' },
	'cameracalibration1' => { 105 => 0xc623 },
	'cameracalibration2' => { 105 => 0xc624 },
	'cameracalibrationsig' => { 105 => 0xc6f3 },
	'cameracolorcalibration01' => { 33 => 0x0, 39 => 0xba },
	'cameracolorcalibration02' => { 33 => 0x4, 39 => 0xbf },
	'cameracolorcalibration03' => { 33 => 0x8, 39 => 0xc4 },
	'cameracolorcalibration04' => { 33 => 0xc, 39 => 0xc9 },
	'cameracolorcalibration05' => { 33 => 0x10, 39 => 0xce },
	'cameracolorcalibration06' => { 33 => 0x14, 39 => 0xd3 },
	'cameracolorcalibration07' => { 33 => 0x18, 39 => 0xd8 },
	'cameracolorcalibration08' => { 33 => 0x1c, 39 => 0xdd },
	'cameracolorcalibration09' => { 33 => 0x20, 39 => 0xe2 },
	'cameracolorcalibration10' => { 33 => 0x24, 39 => 0xe7 },
	'cameracolorcalibration11' => { 33 => 0x28, 39 => 0xec },
	'cameracolorcalibration12' => { 33 => 0x2c, 39 => 0xf1 },
	'cameracolorcalibration13' => { 33 => 0x30, 39 => 0xf6 },
	'cameracolorcalibration14' => { 33 => 0x34, 39 => 0xfb },
	'cameracolorcalibration15' => { 33 => 0x38, 39 => 0x100 },
	'camerae-mountversion' => { 382 => 0xb },
	'cameraid' => { 254 => 0x209, 335 => 0x209 },
	'cameraiso' => { 31 => 0x10 },
	'cameralabel' => { 105 => 0xc7a1, 423 => 'cameraLabel' },
	'cameramodel' => { 311 => 0x410, 423 => 'cameraModel' },
	'cameramodelid' => { 153 => 'CameraModelID' },
	'cameramove' => { 423 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 269 => 0x8f, 306 => 0x1, 311 => 0x100, 349 => [0x16,0x18], 371 => 0x28, 372 => 0x24, 373 => 0x29 },
	'cameraowner' => { 122 => 0xc353 },
	'cameraparameters' => { 254 => 0x2050 },
	'cameraprofile' => { 398 => 'CameraProfile' },
	'cameraprofiledigest' => { 398 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 105 => 0xc62f, 155 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 249 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 30 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 67 => 0xc, 119 => 0x406, 253 => 0x1306, 265 => 0x320, 271 => 0x3402, 302 => 0x47, 333 => 0x43, 375 => 0x5 },
	'cameratemperature4' => { 307 => 0x14 },
	'cameratemperature5' => { 307 => 0x16 },
	'cameratemperaturerangemax' => { 107 => 0x5 },
	'cameratemperaturerangemin' => { 107 => 0x6 },
	'cameratype' => { 67 => 0x1a, 254 => 0x207 },
	'cameratype2' => { 250 => 0x100 },
	'canondr4' => { 106 => 'CanonDR4' },
	'canonexposuremode' => { 31 => 0x14 },
	'canonfiledescription' => { 86 => 0x805 },
	'canonfilelength' => { 55 => 0xe },
	'canonfirmwareversion' => { 55 => 0x7, 86 => 0x80b },
	'canonflashinfo' => { 86 => 0x1028 },
	'canonflashmode' => { 31 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 31 => 0xa },
	'canonimagetype' => { 55 => 0x6, 86 => 0x815 },
	'canonmodelid' => { 55 => 0x10, 86 => 0x1834 },
	'canonvrd' => { 106 => 'CanonVRD' },
	'caption' => { 392 => 'caption' },
	'caption-abstract' => { 113 => 0x78 },
	'captionsauthornames' => { 401 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 401 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 410 => 'CaptionWriter' },
	'captureframerate' => { 101 => 0x4001 },
	'capturesoftware' => { 387 => 'CaptureSoftware' },
	'cardshutterlock' => { 160 => 0x49 },
	'casioimagesize' => { 101 => 0x9 },
	'catalogsets' => { 113 => 0xff, 386 => 'CatalogSets', 390 => 'CatalogSets' },
	'categories' => { 55 => 0x23, 392 => 'categories' },
	'category' => { 113 => 0xf, 248 => 0x30, 410 => 'Category' },
	'cbcrgain' => { 333 => 0xa036 },
	'cbcrgaindefault' => { 333 => 0xa035 },
	'cbcrmatrix' => { 333 => 0xa034 },
	'cbcrmatrixdefault' => { 333 => 0xa033 },
	'ccdboardversion' => { 265 => 0x331 },
	'ccdscanmode' => { 254 => 0x1039 },
	'ccdsensitivity' => { 219 => 0x6 },
	'ccdversion' => { 265 => 0x330 },
	'cellglobalid' => { 396 => 'cgi' },
	'celllength' => { 105 => 0x109 },
	'cellr' => { 396 => 'r' },
	'celltowerid' => { 396 => 'cellid' },
	'cellwidth' => { 105 => 0x108 },
	'centerafarea' => { 244 => '15.1' },
	'centerfocuspoint' => { 247 => '2.2' },
	'centerweightedareasize' => { 236 => '7.1', 237 => '8.1', 242 => '5.1', 243 => '7.1', 244 => '6.3', 246 => '8.1', 247 => '8.1' },
	'certificate' => { 427 => 'Certificate' },
	'cfapattern' => { 105 => 0xa302, 402 => 'CFAPattern' },
	'cfapattern2' => { 105 => 0x828e },
	'cfapatterncolumns' => { 402 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 402 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 402 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 105 => 0x828d },
	'channel' => { 413 => 'channel' },
	'channela-lang' => { 413 => [\'channel','channelA-lang'] },
	'channelchannel' => { 413 => [\'channel','channelChannel'] },
	'channels' => { 134 => 'Channels' },
	'channelsubchannel1' => { 413 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 413 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 413 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 413 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 91 => 0x10101, 96 => 0x26a },
	'checkmark2' => { 97 => 0x8e },
	'childfontfiles' => { 428 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 236 => '10.3', 237 => '11.2' },
	'chromablurradius' => { 105 => 0xc631 },
	'chromaticaberration' => { 91 => 0x20703, 97 => 0x66, 333 => 0xa051 },
	'chromaticaberrationb' => { 398 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 91 => 0x20708, 97 => 0x6b },
	'chromaticaberrationcorr' => { 69 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 292 => 0x1 },
	'chromaticaberrationon' => { 91 => '0x20703.0', 97 => 0x62 },
	'chromaticaberrationr' => { 398 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 91 => 0x20707, 97 => 0x6a },
	'chromaticaberrationsetting' => { 70 => 0x6 },
	'chrominancenoisereduction' => { 91 => 0x20601, 97 => 0x5e, 336 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 97 => 0x60 },
	'circgradbasedcorractive' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 398 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 398 => 'CircularGradientBasedCorrections' },
	'city' => { 113 => 0x5a, 140 => 'City', 269 => 0x6d, 410 => 'City' },
	'city2' => { 269 => 0x80 },
	'clarity' => { 398 => 'Clarity' },
	'clarity2012' => { 398 => 'Clarity2012' },
	'classifystate' => { 113 => 0xe1 },
	'clearretouch' => { 269 => 0x7c },
	'clearretouchvalue' => { 269 => 0xa3 },
	'client' => { 423 => 'client' },
	'clientname' => { 404 => 'ClientName' },
	'clmodeshootingspeed' => { 236 => '10.2', 237 => '11.3', 242 => '11.2', 243 => '10.2', 246 => '11.2', 247 => '11.1' },
	'cmcontrast' => { 257 => 0x2022 },
	'cmexposurecompensation' => { 257 => 0x2000 },
	'cmhue' => { 257 => 0x2021 },
	'cmsaturation' => { 257 => 0x2020 },
	'cmsharpness' => { 257 => 0x2023 },
	'cmwhitebalance' => { 257 => 0x2001 },
	'cmwhitebalancecomp' => { 257 => 0x2002 },
	'cmwhitebalancegraypoint' => { 257 => 0x2010 },
	'codec' => { 148 => 'Codec' },
	'codedcharacterset' => { 114 => 0x5a },
	'collectionname' => { 149 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 149 => 'Collections', 392 => 'collections' },
	'collectionuri' => { 149 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 412 => 'color' },
	'coloraberrationcontrol' => { 229 => 0xc89224b },
	'coloradjustment' => { 336 => 0x14 },
	'coloradjustmentmode' => { 335 => 0x210 },
	'coloranta' => { 428 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 428 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 428 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 428 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 428 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 428 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 428 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 428 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 428 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 428 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 428 => 'Colorants' },
	'colorantswatchname' => { 428 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 428 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 428 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 428 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 135 => 'ColorBalance' },
	'colorbalanceadj' => { 229 => 0x76a43202 },
	'colorbalanceblue' => { 157 => 0x1e },
	'colorbalancegreen' => { 157 => 0x1d },
	'colorbalancered' => { 157 => 0x1c },
	'colorbalanceversion' => { 178 => 0x0 },
	'colorblur' => { 97 => 0x65 },
	'colorbluron' => { 91 => 0x20704 },
	'colorbooster' => { 229 => 0x5f0e7d23 },
	'colorboostlevel' => { 223 => 0x1 },
	'colorboosttype' => { 223 => 0x0 },
	'colorclass' => { 313 => 0xde, 314 => 'ColorClass' },
	'colorcompensationfilter' => { 160 => [0x3a,0x5f], 162 => 0x111, 355 => 0xb022 },
	'colorcompensationfiltercustom' => { 343 => 0xd, 344 => 0xc },
	'colorcompensationfilterset' => { 343 => 0x8, 344 => 0x7, 345 => 0x18, 359 => 0xf },
	'colorcontrol' => { 254 => 0x102b },
	'colorcorrection' => { 383 => 0x8015 },
	'colordataversion' => { 37 => 0x0, 38 => 0x0, 40 => 0x0, 41 => 0x0, 42 => 0x0 },
	'coloreffect' => { 269 => 0x28 },
	'colorfilter' => { 100 => 0x17, 101 => 0x3017, 157 => 0x29, 165 => [0x38,0x4d,0x4f], 309 => 0x17 },
	'colorgain' => { 199 => 0x51 },
	'colorhue' => { 91 => 0x20900, 193 => 0x8d },
	'colorimetricreference' => { 105 => 0xc6bf },
	'colorlabel' => { 401 => 'ColorLabel' },
	'colormatrix' => { 253 => 0x200, 254 => 0x1011, 333 => 0xa030 },
	'colormatrix1' => { 105 => 0xc621, 311 => 0x106 },
	'colormatrix2' => { 105 => 0xc622, 257 => 0x200, 311 => 0x226 },
	'colormatrixa' => { 302 => 0x203 },
	'colormatrixadobergb' => { 333 => 0xa032 },
	'colormatrixb' => { 302 => 0x204 },
	'colormatrixnumber' => { 254 => 0x1019 },
	'colormatrixsrgb' => { 333 => 0xa031 },
	'colormode' => { 101 => 0x3015, 110 => 0x1210, 121 => 0x66, 157 => 0x28, 160 => 0x16, 162 => 0x101, 163 => 0x36, 165 => 0x7, 193 => 0x3, 219 => 0x4, 269 => 0x32, 336 => 0x2c, 355 => 0xb029, 410 => 'ColorMode' },
	'colormoirereduction' => { 230 => 0x15 },
	'colormoirereductionmode' => { 230 => 0x5 },
	'colornoisereduction' => { 383 => 0x8029, 398 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 398 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 230 => 0x18 },
	'colornoisereductionsharpness' => { 230 => 0x1c },
	'colornoisereductionsmoothness' => { 398 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 109 => 0x2 },
	'colorprofile' => { 157 => 0x33 },
	'colorrepresentation' => { 115 => 0x3c },
	'colorsaturationadj' => { 91 => 0x20305 },
	'colorsequence' => { 115 => 0x41 },
	'colorspace' => { 43 => 0x3, 55 => 0xb4, 86 => 0x10b4, 105 => 0xa001, 141 => 'ColorSpace', 158 => 0x2f, 159 => 0x25, 160 => 0x17, 193 => 0x1e, 249 => 0x507, 302 => 0x37, 333 => 0xa011, 336 => 0xb, 343 => 0x1b, 344 => 0x83, 345 => 0xe, 359 => 0x6, 402 => 'ColorSpace' },
	'colortempasshot' => { 34 => 0x4, 35 => 0x1d, 36 => 0x26, 37 => 0x43, 40 => 0x43, 41 => 0x43, 42 => 0x43 },
	'colortempauto' => { 34 => 0x9, 35 => 0x22, 36 => 0x1c, 37 => 0x48, 40 => 0x48, 41 => 0x48, 42 => 0x48 },
	'colortempcloudy' => { 34 => 0x22, 35 => 0x31, 36 => 0x35, 37 => 0x5c, 40 => 0x75, 41 => 0x8e, 42 => 0x93, 302 => 0x55 },
	'colortempcustom' => { 37 => 0x84 },
	'colortempcustom1' => { 35 => 0x45 },
	'colortempcustom2' => { 35 => 0x4a },
	'colortempdaylight' => { 34 => 0x18, 35 => 0x27, 36 => 0x2b, 37 => 0x52, 40 => 0x6b, 41 => 0x84, 42 => 0x89, 302 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 55 => 0xae, 65 => 0x9, 86 => 0x10ae, 110 => 0x1005, 119 => 0x846, 135 => 'ColorTemperature', 158 => [0x6e,0x49], 159 => 0x3f, 160 => [0x39,0x5e], 162 => 0x10b, 165 => [0x3c,0x4c,0x4e], 265 => 0x321, 302 => 0x50, 327 => 0x1308, 355 => 0xb021, 398 => 'Temperature' },
	'colortemperatureadj' => { 383 => 0x8013 },
	'colortemperaturebg' => { 254 => 0x1013 },
	'colortemperaturecustom' => { 343 => 0xc, 344 => 0xb },
	'colortemperaturerg' => { 254 => 0x1014 },
	'colortemperatureset' => { 343 => 0x7, 344 => 0x6 },
	'colortemperaturesetting' => { 160 => 0x25, 345 => 0x17, 359 => 0xe },
	'colortempflash' => { 34 => 0x36, 35 => 0x40, 36 => 0x49, 37 => 0x70, 40 => 0x89, 41 => 0xa2, 42 => 0xa7, 302 => 0x5a },
	'colortempflashdata' => { 37 => 0x24a },
	'colortempfluorescent' => { 34 => 0x2c, 35 => 0x3b, 36 => 0x3f, 37 => 0x66, 40 => 0x7f, 41 => 0x98, 42 => 0x9d },
	'colortempfluorescentd' => { 302 => 0x57 },
	'colortempfluorescentn' => { 302 => 0x58 },
	'colortempfluorescentw' => { 302 => 0x59 },
	'colortempkelvin' => { 34 => 0x31, 36 => 0x44, 37 => 0x6b, 40 => 0x84, 41 => 0x9d, 42 => 0xa2, 269 => 0x44, 327 => 0x1307 },
	'colortempmeasured' => { 34 => 0xe, 37 => 0x4d, 40 => 0x4d, 41 => 0x4d, 42 => 0x4d },
	'colortemppc1' => { 36 => 0x94, 37 => 0x75 },
	'colortemppc2' => { 36 => 0x99, 37 => 0x7a },
	'colortemppc3' => { 36 => 0x9e, 37 => 0x7f },
	'colortempshade' => { 34 => 0x1d, 35 => 0x2c, 36 => 0x30, 37 => 0x57, 40 => 0x70, 41 => 0x89, 42 => 0x8e, 302 => 0x54 },
	'colortemptungsten' => { 34 => 0x27, 35 => 0x36, 36 => 0x3a, 37 => 0x61, 40 => 0x7a, 41 => 0x93, 42 => 0x98, 302 => 0x56 },
	'colortempunknown' => { 34 => 0x13, 36 => 0x21, 40 => 0x52, 41 => 0x52, 42 => 0x52 },
	'colortempunknown10' => { 34 => 0x63, 36 => 0x76, 40 => 0xa2, 41 => 0x7f, 42 => 0x7f },
	'colortempunknown11' => { 34 => 0x68, 36 => 0x7b, 40 => 0xa7, 41 => 0xa7, 42 => 0x84 },
	'colortempunknown12' => { 34 => 0x6d, 36 => 0x80, 40 => 0xac, 41 => 0xac, 42 => 0xac },
	'colortempunknown13' => { 34 => 0x72, 36 => 0x85, 40 => 0xb1, 41 => 0xb1, 42 => 0xb1 },
	'colortempunknown14' => { 36 => 0x8a, 40 => 0xb6, 41 => 0xb6, 42 => 0xb6 },
	'colortempunknown15' => { 36 => 0x8f, 40 => 0xbb, 41 => 0xbb, 42 => 0xbb },
	'colortempunknown16' => { 36 => 0xa3, 41 => 0xc0, 42 => 0xc0 },
	'colortempunknown17' => { 41 => 0xc5, 42 => 0xc5 },
	'colortempunknown18' => { 41 => 0xca, 42 => 0xca },
	'colortempunknown19' => { 41 => 0xcf, 42 => 0xcf },
	'colortempunknown2' => { 34 => 0x3b, 36 => 0x4e, 40 => 0x57, 41 => 0x57, 42 => 0x57 },
	'colortempunknown20' => { 41 => 0xd4, 42 => 0xd4 },
	'colortempunknown21' => { 42 => 0xd9 },
	'colortempunknown22' => { 42 => 0xde },
	'colortempunknown23' => { 42 => 0xe3 },
	'colortempunknown24' => { 42 => 0xe8 },
	'colortempunknown25' => { 42 => 0xed },
	'colortempunknown26' => { 42 => 0xf2 },
	'colortempunknown27' => { 42 => 0xf7 },
	'colortempunknown28' => { 42 => 0xfc },
	'colortempunknown29' => { 42 => 0x101 },
	'colortempunknown3' => { 34 => 0x40, 36 => 0x53, 40 => 0x5c, 41 => 0x5c, 42 => 0x5c },
	'colortempunknown30' => { 42 => 0x106 },
	'colortempunknown4' => { 34 => 0x45, 36 => 0x58, 40 => 0x61, 41 => 0x61, 42 => 0x61 },
	'colortempunknown5' => { 34 => 0x4a, 36 => 0x5d, 40 => 0x66, 41 => 0x66, 42 => 0x66 },
	'colortempunknown6' => { 34 => 0x4f, 36 => 0x62, 40 => 0x8e, 41 => 0x6b, 42 => 0x6b },
	'colortempunknown7' => { 34 => 0x54, 36 => 0x67, 40 => 0x93, 41 => 0x70, 42 => 0x70 },
	'colortempunknown8' => { 34 => 0x59, 36 => 0x6c, 40 => 0x98, 41 => 0x75, 42 => 0x75 },
	'colortempunknown9' => { 34 => 0x5e, 36 => 0x71, 40 => 0x9d, 41 => 0x7a, 42 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 31 => 0x2a, 43 => 0x2 },
	'colortoneadj' => { 91 => 0x20304, 96 => 0x11e },
	'colortoneauto' => { 62 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 61 => 0x6c, 62 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 61 => 0x3c, 62 => 0x3c },
	'colortonemonochrome' => { 61 => 0x84, 62 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 61 => 0x54, 62 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 61 => 0x24, 62 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 61 => 0xc, 62 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 61 => 0x9c, 62 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 61 => 0xb4, 62 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 61 => 0xcc, 62 => 0xe4 },
	'commanddials' => { 244 => '5.1' },
	'commanddialsaperturesetting' => { 236 => '17.3', 237 => '18.3', 242 => '33.3', 243 => '17.3', 246 => '18.3' },
	'commanddialschangemainsub' => { 236 => '17.2', 237 => '18.1', 242 => '33.2', 243 => '17.2', 246 => '18.1' },
	'commanddialsmenuandplayback' => { 236 => '17.4', 237 => '18.2', 242 => '33.4', 243 => '17.4', 246 => '18.2' },
	'commanddialsreverserotation' => { 236 => '17.1', 237 => '6.4', 239 => '16.2', 240 => '17.2', 242 => '33.1', 243 => '17.1', 246 => '6.2', 247 => '18.1' },
	'commanderchannel' => { 244 => '10.2', 245 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 244 => '13.1', 245 => '31.1' },
	'commandergroupa_ttlcomp' => { 247 => '32.1' },
	'commandergroupamanualoutput' => { 244 => '13.2', 245 => '28.2' },
	'commandergroupamode' => { 244 => '11.2', 245 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 244 => '14.1', 245 => '32.1' },
	'commandergroupb_ttlcomp' => { 247 => '33.1' },
	'commandergroupbmanualoutput' => { 244 => '14.2', 245 => '29.2' },
	'commandergroupbmode' => { 244 => '11.3', 245 => '29.1' },
	'commanderinternalflash' => { 244 => '11.1', 245 => '27.1' },
	'commanderinternalmanualoutput' => { 244 => '12.2', 245 => '27.2' },
	'commanderinternalttlchannel' => { 242 => '18.2' },
	'commanderinternalttlcomp' => { 244 => '12.1', 245 => '30.2', 247 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 242 => '20.1', 243 => '26.1' },
	'commanderinternalttlcompgroupa' => { 242 => '21.1', 243 => '27.1' },
	'commanderinternalttlcompgroupb' => { 242 => '22.1', 243 => '28.1' },
	'comment' => { 0 => 0x2, 106 => 'Comment', 136 => 'Comment', 261 => 'Comment' },
	'compass' => { 330 => 0x4 },
	'complianceprofile' => { 413 => 'complianceProfile' },
	'componentsconfiguration' => { 105 => 0x9101, 141 => 'Components', 402 => 'ComponentsConfiguration' },
	'componentversion' => { 86 => 0x80c },
	'composer' => { 423 => 'composer' },
	'compositionadjust' => { 301 => '0.1' },
	'compositionadjustrotation' => { 301 => 0x7 },
	'compositionadjustx' => { 301 => 0x5 },
	'compositionadjusty' => { 301 => 0x6 },
	'compressedbitsperpixel' => { 105 => 0x9102, 402 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 162 => 0x40, 254 => 0x40 },
	'compression' => { 105 => 0x103, 419 => 'Compression' },
	'compressionfactor' => { 249 => 0x50d },
	'compressionratio' => { 141 => 'Compression', 254 => 0x1034 },
	'confidencelevel' => { 393 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 96 => 0x266, 313 => 0xd6 },
	'constrainedcropwidth' => { 96 => 0x262, 313 => 0xd5 },
	'contact' => { 113 => 0x76 },
	'contactinfo' => { 412 => 'contactInfo' },
	'contentlocationcode' => { 113 => 0x1a },
	'contentlocationname' => { 113 => 0x1b },
	'contenttype' => { 413 => 'contentType' },
	'continuousbracketing' => { 160 => 0x20 },
	'continuousdrive' => { 31 => 0x5 },
	'continuousshootingspeed' => { 73 => 0x610 },
	'continuousshotlimit' => { 73 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 31 => 0xd, 100 => 0xc, 101 => [0x3012,0x20], 105 => [0xa408,0xfe54], 110 => [0x1004,0x1006], 135 => 'Contrast', 153 => 'Contrast', 157 => 0x20, 158 => 0x31, 159 => 0x27, 160 => 0x19, 165 => 0x2, 195 => 0x33, 254 => 0x1029, 269 => 0x39, 271 => 0x300a, 302 => 0x20, 309 => 0xc, 323 => 0x24, 327 => 0x1012, 336 => 0xd, 343 => 0x1d, 344 => 0x1a, 355 => 0x2004, 398 => 'Contrast', 402 => 'Contrast' },
	'contrast2012' => { 398 => 'Contrast2012' },
	'contrastadj' => { 91 => 0x20303, 96 => 0x115, 232 => 0x2c, 383 => 0x8017 },
	'contrastauto' => { 62 => 0x90 },
	'contrastcurve' => { 193 => 0x8c },
	'contrastdetectaf' => { 169 => 0x4 },
	'contrastdetectafarea' => { 302 => 0x231 },
	'contrastdetectafinfocus' => { 169 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 61 => 0x60, 62 => 0x60 },
	'contrasthighlight' => { 302 => 0x6d },
	'contrasthighlightshadowadj' => { 302 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 61 => 0x30, 62 => 0x30 },
	'contrastmode' => { 269 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 61 => 0x78, 62 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 61 => 0x48, 62 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 61 => 0x18, 62 => 0x18 },
	'contrastsetting' => { 249 => 0x505, 257 => 0x1012, 345 => 0x10, 359 => 0x8 },
	'contrastshadow' => { 302 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 61 => 0x0, 62 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 61 => 0x90, 62 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 61 => 0xa8, 62 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 61 => 0xc0, 62 => 0xd8 },
	'contributedmedia' => { 423 => 'contributedMedia' },
	'contributedmediaduration' => { 423 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 423 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 423 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 423 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 423 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 423 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 423 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 423 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 423 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 423 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 399 => 'contributor' },
	'contributors' => { 136 => 'Contributors' },
	'controldialset' => { 160 => 0x46 },
	'controlledvocabularyterm' => { 408 => 'CVterm' },
	'controllerboardversion' => { 265 => 0x332 },
	'controlmode' => { 67 => 0x12 },
	'conversionlens' => { 250 => 0x403, 269 => 0x35 },
	'converter' => { 105 => 0xfe4d, 219 => 0xb, 398 => 'Converter' },
	'converttograyscale' => { 398 => 'ConvertToGrayscale' },
	'cookingequipment' => { 415 => 'cookingEquipment' },
	'cookingmethod' => { 415 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 105 => 0x8298, 136 => 'Copyright', 261 => 'Copyright', 302 => 0x22f, 318 => 'Copyright', 409 => 'Copyright', 416 => 'copyright', 419 => 'Copyright', 423 => 'copyright' },
	'copyrightflag' => { 316 => 0x40a },
	'copyrightnotice' => { 113 => 0x74 },
	'copyrightowner' => { 411 => 'CopyrightOwner' },
	'copyrightownerid' => { 411 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 411 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 411 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 411 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 411 => 'CopyrightStatus' },
	'copyrightyear' => { 413 => 'copyrightYear' },
	'coringfilter' => { 253 => 0x310, 254 => 0x102d, 257 => 0x310 },
	'coringvalues' => { 253 => 0x311, 257 => 0x311 },
	'corporateentity' => { 413 => 'corporateEntity' },
	'country' => { 140 => 'Country', 269 => 0x69, 410 => 'Country' },
	'country-primarylocationcode' => { 113 => 0x64 },
	'country-primarylocationname' => { 113 => 0x65 },
	'countrycode' => { 192 => 0x5, 314 => 'CountryCode', 407 => 'CountryCode' },
	'course' => { 415 => 'course' },
	'coverage' => { 399 => 'coverage' },
	'coverdate' => { 413 => 'coverDate' },
	'coverdisplaydate' => { 413 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 302 => 0x28 },
	'crc32' => { 400 => 'crc32' },
	'createdate' => { 105 => 0x9004, 136 => 'CreateDate', 258 => 'CreationDate', 261 => 'create-date', 318 => 'CreationDate', 320 => 0x1, 421 => 'CreateDate' },
	'creationdate' => { 409 => 'CreationDate', 413 => 'creationDate' },
	'creationtime' => { 261 => 'Creation Time' },
	'creativestyle' => { 343 => 0x1a, 344 => 0x18, 354 => 0x41, 355 => 0xb020, 379 => 0x4a },
	'creativestylesetting' => { 345 => 0xf, 359 => 0x7 },
	'creativestylewaschanged' => { 383 => 0x8001 },
	'creator' => { 258 => 'Creator', 318 => 'Creator', 399 => 'creator', 409 => 'Creator' },
	'creatoraddress' => { 407 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 155 => 'CreatorAppId' },
	'creatorcity' => { 407 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 407 => 'CreatorContactInfo' },
	'creatorcountry' => { 407 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoropenwithuioptions' => { 155 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 407 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 407 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 421 => 'CreatorTool' },
	'creatorworkemail' => { 407 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 407 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 407 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 113 => 0x6e, 410 => 'Credit' },
	'creditline' => { 416 => 'creditLine' },
	'creditlinereq' => { 426 => 'CreditLineReq' },
	'creditlinerequired' => { 411 => 'CreditLineRequired' },
	'cropactive' => { 90 => 0x0, 96 => 0x244 },
	'cropangle' => { 398 => 'CropAngle' },
	'cropaspectratio' => { 91 => 0x30101, 96 => 0x260 },
	'cropaspectratiocustom' => { 91 => 0x30102 },
	'cropbottom' => { 109 => 0x9, 224 => 0x36, 273 => 0x31, 313 => 0xdc, 398 => 'CropBottom' },
	'cropbottommargin' => { 45 => 0x3 },
	'cropcircleactive' => { 97 => 0xd6 },
	'cropcircleradius' => { 97 => 0xd9 },
	'cropcirclex' => { 97 => 0xd7 },
	'cropcircley' => { 97 => 0xd8 },
	'cropconstraintowarp' => { 398 => 'CropConstrainToWarp' },
	'croph' => { 391 => 'CropH' },
	'cropheight' => { 90 => 0x6, 96 => 0x24c, 253 => 0x615, 257 => 0x615, 398 => 'CropHeight' },
	'crophispeed' => { 193 => 0x1b },
	'cropleft' => { 96 => 0x246, 109 => 0x6, 224 => 0x1e, 253 => 0x612, 257 => 0x612, 273 => 0x30, 313 => 0xd9, 398 => 'CropLeft' },
	'cropleftmargin' => { 45 => 0x0 },
	'cropmode35mm' => { 327 => 0x1018 },
	'croporiginalheight' => { 90 => 0xb },
	'croporiginalwidth' => { 90 => 0xa },
	'cropoutputheight' => { 224 => 0xce },
	'cropoutputheightinches' => { 224 => 0x96 },
	'cropoutputpixels' => { 224 => 0xd6 },
	'cropoutputresolution' => { 224 => 0xb6 },
	'cropoutputscale' => { 224 => 0xbe },
	'cropoutputwidth' => { 224 => 0xc6 },
	'cropoutputwidthinches' => { 224 => 0x8e },
	'croppedareaimageheightpixels' => { 387 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 387 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 387 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 387 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 327 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 327 => 0x1603 },
	'cropright' => { 109 => 0x8, 224 => 0x2e, 273 => 0x32, 313 => 0xdb, 398 => 'CropRight' },
	'croprightmargin' => { 45 => 0x1 },
	'croprotatedoriginalheight' => { 90 => 0x2 },
	'croprotatedoriginalwidth' => { 90 => 0x1 },
	'croprotation' => { 90 => 0x8, 109 => 0xb },
	'cropscaledresolution' => { 224 => 0x9e },
	'cropsourceresolution' => { 224 => 0xae },
	'croptop' => { 96 => 0x248, 109 => 0x7, 224 => 0x26, 253 => 0x613, 257 => 0x613, 273 => 0x2f, 313 => 0xda, 398 => 'CropTop' },
	'croptopmargin' => { 45 => 0x2 },
	'cropunit' => { 398 => 'CropUnit' },
	'cropunits' => { 398 => 'CropUnits' },
	'cropw' => { 391 => 'CropW' },
	'cropwidth' => { 90 => 0x5, 96 => 0x24a, 253 => 0x614, 257 => 0x614, 398 => 'CropWidth' },
	'cropx' => { 90 => 0x3, 391 => 'CropX' },
	'cropy' => { 90 => 0x4, 391 => 'CropY' },
	'crossprocess' => { 302 => 0x7b },
	'crossprocessparams' => { 302 => 0x235 },
	'cuisine' => { 415 => 'cuisine' },
	'currenticcprofile' => { 105 => 0xc691 },
	'currentpreprofilematrix' => { 105 => 0xc692 },
	'currentversion' => { 383 => 0xd000 },
	'curve0x' => { 391 => 'Curve0x' },
	'curve0y' => { 391 => 'Curve0y' },
	'curve1x' => { 391 => 'Curve1x' },
	'curve1y' => { 391 => 'Curve1y' },
	'curve2x' => { 391 => 'Curve2x' },
	'curve2y' => { 391 => 'Curve2y' },
	'curve3x' => { 391 => 'Curve3x' },
	'curve3y' => { 391 => 'Curve3y' },
	'curve4x' => { 391 => 'Curve4x' },
	'curve4y' => { 391 => 'Curve4y' },
	'curves' => { 229 => 0x76a43201 },
	'custom1' => { 411 => 'Custom1' },
	'custom10' => { 411 => 'Custom10' },
	'custom2' => { 411 => 'Custom2' },
	'custom3' => { 411 => 'Custom3' },
	'custom4' => { 411 => 'Custom4' },
	'custom5' => { 411 => 'Custom5' },
	'custom6' => { 411 => 'Custom6' },
	'custom7' => { 411 => 'Custom7' },
	'custom8' => { 411 => 'Custom8' },
	'custom9' => { 411 => 'Custom9' },
	'customcolortone' => { 97 => 0x4c },
	'customcontrast' => { 97 => 0x4e },
	'customcontrols' => { 73 => 0x70c },
	'customdefaultunsharpfineness' => { 97 => 0xbe },
	'customdefaultunsharpstrength' => { 97 => 0xbc },
	'customdefaultunsharpthreshold' => { 97 => 0xc0 },
	'customlinear' => { 97 => 0x4f },
	'customoutputhighlightpoint' => { 97 => 0x53 },
	'customoutputshadowpoint' => { 97 => 0x54 },
	'custompicturestyle' => { 91 => 0x10021 },
	'custompicturestyledata' => { 91 => 0xf0500 },
	'custompicturestylefilename' => { 55 => 0x4010 },
	'customrawhighlight' => { 97 => 0x7c },
	'customrawhighlightpoint' => { 97 => 0x51 },
	'customrawshadow' => { 97 => 0x85 },
	'customrawshadowpoint' => { 97 => 0x52 },
	'customrendered' => { 105 => 0xa401, 402 => 'CustomRendered' },
	'customsaturation' => { 97 => 0x4d, 249 => 0x503 },
	'customsettingsalldefault' => { 236 => '0.2', 242 => '0.2' },
	'customsettingsbank' => { 236 => '0.1', 237 => '0.1', 242 => '0.1', 246 => '0.2' },
	'customsharpness' => { 97 => 0x50 },
	'customunsharpmaskfineness' => { 97 => 0xb8 },
	'customunsharpmaskstrength' => { 97 => 0xb6 },
	'customunsharpmaskthreshold' => { 97 => 0xba },
	'customwb_rblevels' => { 359 => 0x1a },
	'customwb_rgblevels' => { 344 => 0x8, 345 => 0x19 },
	'customwbbluelevel' => { 160 => 0x36 },
	'customwberror' => { 160 => 0x37 },
	'customwbgreenlevel' => { 160 => 0x35 },
	'customwbredlevel' => { 160 => 0x34 },
	'customwbsetting' => { 160 => 0x26 },
	'd-lightinghq' => { 229 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 225 => 0x2 },
	'd-lightinghqhighlight' => { 225 => 0x1 },
	'd-lightinghqselected' => { 229 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 225 => 0x0 },
	'd-lightinghs' => { 229 => 0xce5554aa },
	'd-lightinghsadjustment' => { 226 => 0x0 },
	'd-lightinghscolorboost' => { 226 => 0x1 },
	'd-rangeoptimizerhighlight' => { 383 => 0x8024 },
	'd-rangeoptimizermode' => { 383 => 0x8022 },
	'd-rangeoptimizershadow' => { 383 => 0x802d },
	'd-rangeoptimizervalue' => { 383 => 0x8023 },
	'd810meteringmode' => { 217 => 0x175e },
	'datacompressionmethod' => { 115 => 0x6e },
	'dataimprint' => { 157 => 0x34 },
	'datascaling' => { 302 => 0x3d },
	'date' => { 302 => 0x6, 399 => 'date' },
	'dateacquired' => { 155 => 'DateAcquired' },
	'datecreated' => { 113 => 0x37, 410 => 'DateCreated' },
	'datedisplayformat' => { 221 => 0x3 },
	'dateidentified' => { 104 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 239 => '4.2' },
	'daterecieved' => { 413 => 'dateRecieved' },
	'datesent' => { 114 => 0x46 },
	'datestampmode' => { 55 => 0x1c },
	'datetime' => { 392 => 'datetime', 419 => 'DateTime' },
	'datetimedigitized' => { 402 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 89 => 0x0, 105 => 0x9003, 133 => 0x14, 136 => 'OriginalDate', 323 => 0xb, 402 => 'DateTimeOriginal' },
	'datetimestamp' => { 121 => 0x64 },
	'datetimeutc' => { 249 => 0x908 },
	'daylightsavings' => { 68 => 0x3, 221 => 0x2 },
	'dccontinent' => { 104 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 104 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 104 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 104 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 104 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 104 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 104 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 104 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 104 => 'Event' },
	'dcfootprintspatialfit' => { 104 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 104 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 104 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 104 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 104 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 104 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 104 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 104 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 104 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 104 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 104 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 104 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 104 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 104 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 104 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 104 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 104 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 104 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 104 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 104 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 104 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 104 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 104 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 104 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 104 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 104 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 104 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 104 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 104 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 104 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 104 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 104 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 104 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 104 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 104 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 104 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 104 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 144 => 'Declination' },
	'decposition' => { 157 => 0x32 },
	'defaultblackrender' => { 105 => 0xc7a6 },
	'defaultcroporigin' => { 105 => 0xc61f },
	'defaultcropsize' => { 105 => 0xc620 },
	'defaulteraseoption' => { 73 => 0x813 },
	'defaultscale' => { 105 => 0xc61e },
	'defaultusercrop' => { 105 => 0xc7b5 },
	'defringe' => { 398 => 'Defringe' },
	'defringegreenamount' => { 398 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 398 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 398 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 398 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 398 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 398 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 193 => 0xa6, 200 => 0x6e },
	'deprecatedon' => { 395 => 'deprecatedOn' },
	'derivedfrom' => { 424 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 424 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 424 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 424 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 424 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 424 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 424 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 424 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 424 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 424 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 424 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 424 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 424 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 424 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 424 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 424 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 424 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 424 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 261 => 'Description', 399 => 'description', 421 => 'Description' },
	'destination' => { 114 => 0x5 },
	'destinationcity' => { 302 => 0x24, 308 => 0x3 },
	'destinationcitycode' => { 309 => 0x1001 },
	'destinationdst' => { 302 => 0x26, 308 => '0.3' },
	'developmentdynamicrange' => { 110 => 0x1403 },
	'device' => { 413 => 'device' },
	'devicesettingdescription' => { 402 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 402 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 402 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 402 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 333 => 0x2 },
	'dialdirectiontvav' => { 73 => 0x706 },
	'dietaryneeds' => { 415 => 'dietaryNeeds' },
	'diffractioncorrection' => { 292 => 0x3 },
	'digitalcreationdate' => { 113 => 0x3e },
	'digitalcreationtime' => { 113 => 0x3f },
	'digitaldeehighlightadj' => { 199 => 0x202 },
	'digitaldeeshadowadj' => { 199 => 0x200 },
	'digitaldeethreshold' => { 199 => 0x201 },
	'digitalfilter' => { 336 => 0x59 },
	'digitalfilter01' => { 289 => 0x5 },
	'digitalfilter02' => { 289 => 0x16 },
	'digitalfilter03' => { 289 => 0x27 },
	'digitalfilter04' => { 289 => 0x38 },
	'digitalfilter05' => { 289 => 0x49 },
	'digitalfilter06' => { 289 => 0x5a },
	'digitalfilter07' => { 289 => 0x6b },
	'digitalfilter08' => { 289 => 0x7c },
	'digitalfilter09' => { 289 => 0x8d },
	'digitalfilter10' => { 289 => 0x9e },
	'digitalfilter11' => { 289 => 0xaf },
	'digitalfilter12' => { 289 => 0xc0 },
	'digitalfilter13' => { 289 => 0xd1 },
	'digitalfilter14' => { 289 => 0xe2 },
	'digitalfilter15' => { 289 => 0xf3 },
	'digitalfilter16' => { 289 => 0x104 },
	'digitalfilter17' => { 289 => 0x115 },
	'digitalfilter18' => { 289 => 0x126 },
	'digitalfilter19' => { 289 => 0x137 },
	'digitalfilter20' => { 289 => 0x148 },
	'digitalgain' => { 65 => 0xb },
	'digitalgem' => { 185 => 0x0 },
	'digitalice' => { 199 => 0x100 },
	'digitalimageguid' => { 408 => 'DigImageGUID' },
	'digitalroc' => { 197 => 0x0 },
	'digitalsourcefiletype' => { 408 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 408 => 'DigitalSourceType' },
	'digitalzoom' => { 31 => 0xc, 100 => 0xa, 121 => 0x68, 135 => 'DigitalZoom', 157 => 0xc, 193 => 0x86, 219 => 0xa, 254 => 0x204, 302 => 0x1e, 309 => 0xa, 335 => 0x204, 371 => 0x12, 372 => 0x12 },
	'digitalzoomon' => { 335 => 0x21b },
	'digitalzoomratio' => { 105 => 0xa404, 364 => 0x200, 366 => 0x21c, 402 => 'DigitalZoomRatio' },
	'director' => { 423 => 'director' },
	'directorphotography' => { 423 => 'directorPhotography' },
	'directory' => { 106 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 181 => 0x3 },
	'disclaimer' => { 261 => 'Disclaimer' },
	'discnumber' => { 423 => 'discNumber' },
	'dishtype' => { 415 => 'dishType' },
	'displayallafpoints' => { 73 => 0x514 },
	'displayaperture' => { 31 => 0x23 },
	'displayedunitsx' => { 317 => 0x2 },
	'displayedunitsy' => { 317 => 0x6 },
	'displayname' => { 412 => 'displayName' },
	'distance1' => { 121 => 0x28 },
	'distance2' => { 121 => 0x2c },
	'distance3' => { 121 => 0x30 },
	'distance4' => { 121 => 0x34 },
	'distortion' => { 333 => 0xa050 },
	'distortioncontrol' => { 200 => 0x10 },
	'distortioncorrection' => { 91 => 0x20705, 97 => 0x67, 249 => 0x50b, 272 => '7.1', 292 => 0x0, 378 => 0x601, 379 => 0x5b },
	'distortioncorrection2' => { 253 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 394 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 91 => '0x20705.0', 97 => 0x63 },
	'distortioncorrectionsetting' => { 355 => 0x2013 },
	'distortioneffect' => { 91 => 0x20709 },
	'distortionn' => { 272 => 0xc },
	'distortionparam02' => { 272 => 0x2 },
	'distortionparam04' => { 272 => 0x4 },
	'distortionparam08' => { 272 => 0x8 },
	'distortionparam09' => { 272 => 0x9 },
	'distortionparam11' => { 272 => 0xb },
	'distortionscale' => { 272 => 0x5 },
	'distributor' => { 413 => 'distributor' },
	'distributorproductid' => { 412 => 'distributorProductID' },
	'dloon' => { 91 => '0x20706.0', 97 => 0xdc },
	'dlosetting' => { 91 => 0x20706, 97 => 0xdd },
	'dlosettingapplied' => { 97 => 0xe4 },
	'dloshootingdistance' => { 97 => 0xde },
	'dloversion' => { 97 => 0xe5 },
	'dmcomment' => { 423 => 'comment' },
	'dngadobedata' => { 105 => 0xc634 },
	'dngbackwardversion' => { 105 => 0xc613 },
	'dnglensinfo' => { 105 => 0xc630 },
	'dngprivatedata' => { 105 => 0xc634 },
	'dngversion' => { 105 => 0xc612 },
	'document' => { 261 => 'Document' },
	'documentancestors' => { 410 => 'DocumentAncestors' },
	'documenthistory' => { 113 => 0xe7 },
	'documentid' => { 424 => 'DocumentID' },
	'documentname' => { 105 => 0x10d },
	'documentnotes' => { 113 => 0xe6 },
	'doi' => { 413 => 'doi' },
	'dotrange' => { 105 => 0x150 },
	'dpp' => { 392 => 'dpp' },
	'dr4cameramodel' => { 92 => 0x3 },
	'drivemode' => { 101 => 0x3103, 157 => 0x6, 160 => 0x1e, 163 => 0xe, 249 => 0x600, 302 => 0x34, 327 => 0x1002, 336 => 0x3, 343 => 0x4, 344 => 0x7e, 345 => 0x34 },
	'drivemode2' => { 160 => 0xa, 283 => 0x7, 354 => 0xe, 359 => 0x1 },
	'drivemodesetting' => { 345 => 0x4 },
	'dspfirmwareversion' => { 302 => 0x27 },
	'duration' => { 58 => 0x6a, 134 => 'Duration', 148 => 'Duration', 415 => 'duration', 423 => 'duration' },
	'durationscale' => { 423 => [\'duration','durationScale'] },
	'durationvalue' => { 423 => [\'duration','durationValue'] },
	'dustremovaldata' => { 55 => 0x97 },
	'dynamicafarea' => { 236 => '1.4', 242 => '1.4' },
	'dynamicareaafdisplay' => { 237 => '46.1', 246 => '47.1' },
	'dynamicrange' => { 110 => 0x1400 },
	'dynamicrangeexpansion' => { 302 => 0x69, 327 => 0x100e },
	'dynamicrangemax' => { 96 => 0x7c },
	'dynamicrangemin' => { 96 => 0x7a },
	'dynamicrangeoptimizer' => { 160 => 0x15, 355 => [0xb025,0xb04f], 362 => 0x1144, 363 => [0x1144,0x324], 364 => [0x1120,0x300], 365 => [0x119c,0x37c], 366 => [0x1178,0x328], 367 => [0x1030,0x50], 368 => [0x228,0x50], 369 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 354 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 343 => 0x19, 344 => 0x17, 345 => 0xd, 354 => 0x79, 359 => 0x5 },
	'dynamicrangeoptimizermode' => { 163 => 0x15, 343 => 0x18, 344 => 0x16, 354 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 160 => 0x27, 345 => 0xc, 359 => 0x4 },
	'dynamicrangesetting' => { 110 => 0x1402 },
	'e-dialinprogram' => { 283 => '1.3' },
	'earliestageorloweststage' => { 104 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 104 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 104 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 104 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 104 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 247 => '6.1' },
	'easyexposurecompensation' => { 236 => '6.4', 237 => '6.5', 242 => '4.4', 243 => '5.2', 246 => '6.3' },
	'easymode' => { 31 => 0xb },
	'edgenoisereduction' => { 230 => 0x4, 383 => 0x8028 },
	'edition' => { 413 => 'edition' },
	'editorialupdate' => { 113 => 0x8 },
	'editstatus' => { 113 => 0x7, 314 => 'EditStatus' },
	'editversionname' => { 229 => 0x3d136244 },
	'effectivelv' => { 302 => 0x2d },
	'effectivemaxaperture' => { 189 => 0x12, 190 => 0x13 },
	'eissn' => { 413 => 'eIssn' },
	'electronicfront-curtainshutter' => { 246 => '5.3' },
	'elevation' => { 144 => 'Elevation' },
	'email' => { 136 => 'EMail' },
	'embargodate' => { 416 => 'embargoDate' },
	'embdencrightsexpr' => { 408 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 408 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 408 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 408 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 410 => 'EmbeddedXMPDigest' },
	'emissivity' => { 107 => 0x3 },
	'encryptionkey' => { 333 => 0xa020 },
	'endingpage' => { 413 => 'endingPage' },
	'enduser' => { 411 => 'EndUser' },
	'enduserid' => { 411 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 411 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 423 => 'engineer' },
	'enhancedarktones' => { 222 => 0x8 },
	'enhancement' => { 100 => 0x16, 101 => 0x3016 },
	'enhancer' => { 253 => 0x300 },
	'enhancervalues' => { 253 => 0x301 },
	'envelopenumber' => { 114 => 0x28 },
	'envelopepriority' => { 114 => 0x3c },
	'enveloperecordversion' => { 114 => 0x0 },
	'epsonimageheight' => { 254 => 0x20c },
	'epsonimagewidth' => { 254 => 0x20b },
	'epsonsoftware' => { 254 => 0x20d },
	'equipmentinstitution' => { 385 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 385 => 'EquipmentManufacturer' },
	'equipmentversion' => { 250 => 0x0 },
	'ettlii' => { 73 => 0x304, 74 => 0xd, 75 => 0xe, 76 => 0x7, 77 => 0x7, 78 => 0xe },
	'event' => { 386 => 'Event', 390 => 'Event', 408 => 'Event', 413 => 'event' },
	'eventalias' => { 412 => 'eventAlias' },
	'eventday' => { 104 => [\'Event','EventDay'] },
	'eventearliestdate' => { 104 => [\'Event','EventEarliestDate'] },
	'eventend' => { 412 => 'eventEnd' },
	'eventenddayofyear' => { 104 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 104 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 104 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 104 => [\'Event','EventHabitat'] },
	'eventid' => { 104 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 104 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 104 => [\'Event','EventMonth'] },
	'eventnumber' => { 323 => 0x9 },
	'eventremarks' => { 104 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 104 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 104 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 412 => 'eventStart' },
	'eventstartdayofyear' => { 104 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 412 => 'eventSubtype' },
	'eventtime' => { 104 => [\'Event','EventEventTime'] },
	'eventtype' => { 412 => 'eventType' },
	'eventverbatimeventdate' => { 104 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 104 => [\'Event','EventYear'] },
	'evsteps' => { 283 => '1.2', 285 => 0x0 },
	'evstepsize' => { 239 => '5.1', 240 => '6.1', 241 => '6.1', 244 => '0.7' },
	'exclusivityenddate' => { 416 => 'exclusivityEndDate' },
	'excursiontolerance' => { 115 => 0x82 },
	'exif' => { 106 => 'EXIF' },
	'exifbyteorder' => { 106 => 'ExifByteOrder' },
	'exifcamerainfo' => { 113 => 0xe8 },
	'exifimageheight' => { 105 => 0xa003, 402 => 'PixelYDimension' },
	'exifimagewidth' => { 105 => 0xa002, 402 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 106 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 105 => 0x9000, 402 => 'ExifVersion' },
	'exitpupilposition' => { 189 => 0x4, 190 => 0x4 },
	'expirationdate' => { 113 => 0x25, 416 => 'expirationDate' },
	'expirationtime' => { 113 => 0x26 },
	'exposure' => { 105 => 0xfe51, 398 => 'Exposure' },
	'exposure2012' => { 398 => 'Exposure2012' },
	'exposureadj' => { 227 => 0x0 },
	'exposureadj2' => { 227 => 0x12 },
	'exposureadjust' => { 336 => 0xc },
	'exposurebracketingindicatorlast' => { 160 => 0x52 },
	'exposurebracketshotnumber' => { 163 => 0x2d, 354 => 0x2f },
	'exposurebracketstepsize' => { 283 => 0x8 },
	'exposurebracketvalue' => { 193 => 0x19 },
	'exposurecompensation' => { 67 => 0x6, 82 => 0x0, 105 => 0x9204, 121 => 0x24, 135 => 'ExposureComp', 153 => 'ExposureCompensation', 157 => 0xd, 158 => 0x53, 159 => 0x1e, 163 => 0x49c0, 254 => 0x1006, 302 => 0x16, 311 => 0x402, 333 => 0xa013, 336 => [0xc,0x35,0x4d], 362 => 0x114c, 363 => 0x114c, 364 => 0x1128, 366 => 0x1180, 367 => 0x1038, 368 => 0x230, 369 => 0x230, 402 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 359 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 160 => 0x47, 163 => 0x2a },
	'exposurecompensationset' => { 343 => 0x3, 344 => 0x3, 345 => 0x3, 359 => 0x1e },
	'exposurecompensationsetting' => { 160 => 0x1 },
	'exposurecompstepsize' => { 236 => '6.3', 237 => '7.3', 242 => '4.3', 246 => '7.3' },
	'exposurecontrolstep' => { 243 => '6.1' },
	'exposurecontrolstepsize' => { 236 => '6.2', 237 => '7.1', 242 => '4.2', 246 => '7.1', 247 => '7.1' },
	'exposurecount' => { 110 => 0x1032 },
	'exposuredelaymode' => { 236 => '10.1', 237 => '11.1', 239 => '9.1', 240 => '10.1', 241 => '10.1', 242 => '10.4', 243 => '10.1', 244 => '6.4', 246 => '11.1', 247 => '11.2' },
	'exposuredifference' => { 193 => 0xe },
	'exposureindex' => { 105 => 0xa215, 402 => 'ExposureIndex' },
	'exposureindicator' => { 160 => 0x50 },
	'exposurelevelincrements' => { 71 => 0x6, 72 => 0x6, 73 => 0x101, 74 => 0x5, 75 => 0x6, 76 => 0x5, 77 => 0x5, 78 => 0x6, 79 => 0x4, 343 => 0x58, 344 => 0x58 },
	'exposurelockused' => { 387 => 'ExposureLockUsed' },
	'exposuremode' => { 105 => 0xa402, 135 => 'ExposureMode', 157 => 0x1, 158 => 0xa, 159 => 0x0, 160 => 0x0, 163 => 0x34, 249 => 0x200, 267 => 0x40d, 336 => 0x8, 355 => 0xb041, 402 => 'ExposureMode' },
	'exposuremodeinmanual' => { 73 => 0x10b },
	'exposureprogram' => { 105 => 0x8822, 327 => 0x1001, 337 => 0x17e, 343 => 0x3c, 344 => 0x3c, 345 => 0x5, 349 => 0x14, 354 => 0x3f, 359 => 0x2, 362 => 0x1175, 363 => 0x1179, 364 => 0x1155, 365 => 0x11d1, 366 => 0x11ad, 367 => 0x1065, 368 => 0x25d, 369 => 0x25d, 379 => 0x48, 402 => 'ExposureProgram' },
	'exposureshift' => { 249 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 67 => 0x16, 105 => 0x829a, 118 => 0xfd05, 121 => 0x20, 123 => 0xfa24, 125 => 0xf104, 128 => 0x12, 130 => 0x38, 133 => 0x10, 135 => 'ExposureTime', 157 => 0x9, 158 => 0x35, 159 => 0x48, 160 => 0x8, 163 => 0x49b8, 302 => 0x12, 333 => 0xa018, 336 => [0x32,0x4a], 343 => 0x0, 344 => 0x0, 359 => [0x21,0x23,0x27], 379 => 0x10, 402 => 'ExposureTime' },
	'exposuretime2' => { 336 => [0x33,0x4b] },
	'exposuretuning' => { 193 => 0x1c },
	'exposurevalue' => { 119 => 0x3 },
	'exposurewarning' => { 110 => 0x1302 },
	'exrauto' => { 110 => 0x1033 },
	'exrmode' => { 110 => 0x1034 },
	'extendedwbdetect' => { 249 => 0x902 },
	'extender' => { 250 => 0x301 },
	'extenderfirmwareversion' => { 250 => 0x304 },
	'extendermagnification' => { 137 => 'Magnification' },
	'extendermake' => { 137 => 'Make' },
	'extendermodel' => { 137 => 'Model', 250 => 0x303 },
	'extenderserialnumber' => { 137 => 'SerialNumber', 250 => 0x302 },
	'extenderstatus' => { 300 => 0x3 },
	'externalflash' => { 252 => 0x1201 },
	'externalflashae1' => { 254 => 0x101f },
	'externalflashae1_0' => { 254 => 0x101b },
	'externalflashae2' => { 254 => 0x1020 },
	'externalflashae2_0' => { 254 => 0x101c },
	'externalflashbounce' => { 252 => 0x1204, 254 => 0x1026, 290 => 0x1a },
	'externalflashcompensation' => { 184 => 0x1b },
	'externalflashexposurecomp' => { 193 => 0x17, 290 => 0x19 },
	'externalflashfirmware' => { 182 => 0x6, 183 => 0x6, 184 => 0x6 },
	'externalflashflags' => { 182 => 0x8, 183 => 0x8, 184 => 0x8 },
	'externalflashguidenumber' => { 252 => 0x1203, 290 => '24.1' },
	'externalflashgvalue' => { 254 => 0x1025 },
	'externalflashmode' => { 254 => 0x1028, 290 => 0x2 },
	'externalflashzoom' => { 252 => 0x1205, 254 => 0x1027 },
	'externalsensorbrightnessvalue' => { 265 => 0x311, 271 => 0x3408 },
	'extrainfoversion' => { 347 => 0x1a },
	'eyestartaf' => { 160 => 0x40 },
	'face10position' => { 98 => 0x3f4, 99 => 0x1ec, 180 => 0x28, 287 => 0x12 },
	'face10size' => { 288 => 0x12 },
	'face11position' => { 180 => 0x2c, 287 => 0x14 },
	'face11size' => { 288 => 0x14 },
	'face12position' => { 180 => 0x30, 287 => 0x16 },
	'face12size' => { 288 => 0x16 },
	'face13position' => { 287 => 0x18 },
	'face13size' => { 288 => 0x18 },
	'face14position' => { 287 => 0x1a },
	'face14size' => { 288 => 0x1a },
	'face15position' => { 287 => 0x1c },
	'face15size' => { 288 => 0x1c },
	'face16position' => { 287 => 0x1e },
	'face16size' => { 288 => 0x1e },
	'face17position' => { 287 => 0x20 },
	'face17size' => { 288 => 0x20 },
	'face18position' => { 287 => 0x22 },
	'face18size' => { 288 => 0x22 },
	'face19position' => { 287 => 0x24 },
	'face19size' => { 288 => 0x24 },
	'face1position' => { 46 => 0x8, 98 => 0xd, 99 => 0x18, 180 => 0x4, 263 => 0x1, 287 => 0x0, 324 => 0xbc, 350 => 0x1, 351 => 0x0, 352 => 0x0, 353 => 0x5b },
	'face1size' => { 288 => 0x0 },
	'face20position' => { 287 => 0x26 },
	'face20size' => { 288 => 0x26 },
	'face21position' => { 287 => 0x28 },
	'face21size' => { 288 => 0x28 },
	'face22position' => { 287 => 0x2a },
	'face22size' => { 288 => 0x2a },
	'face23position' => { 287 => 0x2c },
	'face23size' => { 288 => 0x2c },
	'face24position' => { 287 => 0x2e },
	'face24size' => { 288 => 0x2e },
	'face25position' => { 287 => 0x30 },
	'face25size' => { 288 => 0x30 },
	'face26position' => { 287 => 0x32 },
	'face26size' => { 288 => 0x32 },
	'face27position' => { 287 => 0x34 },
	'face27size' => { 288 => 0x34 },
	'face28position' => { 287 => 0x36 },
	'face28size' => { 288 => 0x36 },
	'face29position' => { 287 => 0x38 },
	'face29size' => { 288 => 0x38 },
	'face2position' => { 46 => 0xa, 98 => 0x7c, 99 => 0x4c, 180 => 0x8, 263 => 0x5, 287 => 0x2, 324 => 0xc8, 350 => 0x6, 351 => 0x20, 352 => 0x25, 353 => 0x65 },
	'face2size' => { 288 => 0x2 },
	'face30position' => { 287 => 0x3a },
	'face30size' => { 288 => 0x3a },
	'face31position' => { 287 => 0x3c },
	'face31size' => { 288 => 0x3c },
	'face32position' => { 287 => 0x3e },
	'face32size' => { 288 => 0x3e },
	'face3position' => { 46 => 0xc, 98 => 0xeb, 99 => 0x80, 180 => 0xc, 263 => 0x9, 287 => 0x4, 324 => 0xd4, 350 => 0xb, 351 => 0x40, 352 => 0x4a, 353 => 0x6f },
	'face3size' => { 288 => 0x4 },
	'face4position' => { 46 => 0xe, 98 => 0x15a, 99 => 0xb4, 180 => 0x10, 263 => 0xd, 287 => 0x6, 324 => 0xe0, 350 => 0x10, 351 => 0x60, 352 => 0x6f, 353 => 0x79 },
	'face4size' => { 288 => 0x6 },
	'face5position' => { 46 => 0x10, 98 => 0x1c9, 99 => 0xe8, 180 => 0x14, 263 => 0x11, 287 => 0x8, 324 => 0xec, 350 => 0x15, 351 => 0x80, 352 => 0x94 },
	'face5size' => { 288 => 0x8 },
	'face6position' => { 46 => 0x12, 98 => 0x238, 99 => 0x11c, 180 => 0x18, 287 => 0xa, 324 => 0xf8, 350 => 0x1a, 351 => 0xa0, 352 => 0xb9 },
	'face6size' => { 288 => 0xa },
	'face7position' => { 46 => 0x14, 98 => 0x2a7, 99 => 0x150, 180 => 0x1c, 287 => 0xc, 324 => 0x104, 350 => 0x1f, 351 => 0xc0, 352 => 0xde },
	'face7size' => { 288 => 0xc },
	'face8position' => { 46 => 0x16, 98 => 0x316, 99 => 0x184, 180 => 0x20, 287 => 0xe, 324 => 0x110, 350 => 0x24, 351 => 0xe0, 352 => 0x103 },
	'face8size' => { 288 => 0xe },
	'face9position' => { 46 => 0x18, 98 => 0x385, 99 => 0x1b8, 180 => 0x24, 287 => 0x10 },
	'face9size' => { 288 => 0x10 },
	'facedetect' => { 302 => 0x76, 333 => 0x100 },
	'facedetectarea' => { 253 => 0x1201 },
	'facedetectframecrop' => { 253 => 0x1207 },
	'facedetectframesize' => { 46 => 0x3, 98 => 0x1, 99 => 0x4, 180 => 0x1, 253 => 0x1203, 302 => 0x77, 324 => 0xb6 },
	'facedetection' => { 345 => 0x30, 359 => 0x19 },
	'faceid' => { 393 => 'FaceID' },
	'faceinfounknown' => { 101 => 0x2089 },
	'facename' => { 333 => 0x123 },
	'faceorientation' => { 99 => 0x8 },
	'faceposition' => { 286 => 0x2, 334 => 0x4 },
	'facepositions' => { 110 => 0x4103 },
	'facerecognition' => { 333 => 0x120 },
	'facesdetected' => { 46 => 0x2, 47 => 0x2, 48 => 0x3, 98 => 0x0, 99 => 0x2, 101 => 0x211c, 110 => 0x4100, 180 => 0x3, 253 => 0x1200, 269 => 0x3f, 286 => 0x0, 324 => 0xb5, 334 => 0x0, 350 => 0x0, 353 => 0x3, 361 => 0x30 },
	'facesrecognized' => { 264 => 0x0 },
	'facewidth' => { 47 => 0x1 },
	'faithfuloutputhighlightpoint' => { 97 => 0x38 },
	'faithfuloutputshadowpoint' => { 97 => 0x39 },
	'faithfulrawcolortone' => { 97 => 0x31 },
	'faithfulrawcontrast' => { 97 => 0x33 },
	'faithfulrawhighlight' => { 97 => 0x79 },
	'faithfulrawhighlightpoint' => { 97 => 0x36 },
	'faithfulrawlinear' => { 97 => 0x34 },
	'faithfulrawsaturation' => { 97 => 0x32 },
	'faithfulrawshadow' => { 97 => 0x82 },
	'faithfulrawshadowpoint' => { 97 => 0x37 },
	'faithfulrawsharpness' => { 97 => 0x35 },
	'faithfulunsharpmaskfineness' => { 97 => 0xac },
	'faithfulunsharpmaskstrength' => { 97 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 97 => 0xae },
	'femicroadjustment' => { 73 => 0x111 },
	'ffid' => { 400 => 'ffid' },
	'field' => { 412 => 'field' },
	'fieldcount' => { 254 => 0x103f },
	'filecreatedate' => { 106 => 'FileCreateDate' },
	'filedatarate' => { 423 => 'fileDataRate' },
	'fileformat' => { 84 => 0x0, 114 => 0x14, 336 => [0x22,0x26], 355 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 270 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 106 => 'FileModifyDate' },
	'filename' => { 106 => 'FileName' },
	'filenameasdelivered' => { 411 => 'FileNameAsDelivered' },
	'filenumber' => { 49 => 0x1, 55 => 0x8, 86 => 0x1817, 102 => 'FileNumber', 181 => 0x4 },
	'filenumbermemory' => { 157 => 0x1a },
	'filenumbersequence' => { 236 => '12.2', 239 => '3.1', 240 => '4.1', 241 => '4.1', 242 => '11.1', 243 => '4.3', 247 => '5.2' },
	'filesource' => { 105 => 0xa300, 110 => 0x8000, 402 => 'FileSource' },
	'fileversion' => { 114 => 0x16 },
	'fillflashautoreduction' => { 71 => 0xe, 72 => 0xe, 79 => 0xa },
	'filllight' => { 398 => 'FillLight' },
	'fillorder' => { 105 => 0x10a },
	'filmmode' => { 110 => 0x1401, 267 => 0x412, 269 => 0x42 },
	'filmtype' => { 199 => 0x2 },
	'filtereffect' => { 49 => 0xe, 195 => 0x37 },
	'filtereffectauto' => { 62 => 0xa0 },
	'filtereffectfaithful' => { 61 => 0x70, 62 => 0x70 },
	'filtereffectlandscape' => { 61 => 0x40, 62 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 61 => 0x88, 62 => 0x88 },
	'filtereffectneutral' => { 61 => 0x58, 62 => 0x58 },
	'filtereffectportrait' => { 61 => 0x28, 62 => 0x28 },
	'filtereffectstandard' => { 61 => 0x10, 62 => 0x10 },
	'filtereffectuserdef1' => { 61 => 0xa0, 62 => 0xb8 },
	'filtereffectuserdef2' => { 61 => 0xb8, 62 => 0xd0 },
	'filtereffectuserdef3' => { 61 => 0xd0, 62 => 0xe8 },
	'finderdisplayduringexposure' => { 72 => 0x1 },
	'finesharpness' => { 302 => 0x70 },
	'finetuneoptcenterweighted' => { 236 => '7.2', 237 => '9.1', 246 => '9.1', 247 => '9.1' },
	'finetuneopthighlightweighted' => { 246 => '46.1' },
	'finetuneoptmatrixmetering' => { 236 => '8.1', 237 => '8.2', 242 => '6.1', 246 => '8.2', 247 => '8.2' },
	'finetuneoptspotmetering' => { 236 => '8.2', 237 => '9.2', 242 => '6.2', 246 => '9.2', 247 => '9.2' },
	'firmware' => { 254 => 0x405, 336 => [0x17,0x3b,0x57], 394 => 'Firmware' },
	'firmwaredate' => { 100 => 0x15, 101 => 0x2001, 323 => 0x4 },
	'firmwareid' => { 164 => 0x0 },
	'firmwarename' => { 333 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 55 => 0x1e, 325 => 0x0 },
	'firmwarerevision2' => { 325 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 119 => 0xce5, 133 => 0x57, 135 => 'FirmwareVersion', 269 => 0x2, 271 => 0x3109, 302 => 0x230, 327 => 0x2 },
	'firmwareversions' => { 311 => 0x301 },
	'firstphotodate' => { 387 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 411 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 113 => 0x16 },
	'flash' => { 102 => 'Flash', 105 => 0x9209, 158 => 0x1f, 159 => 0x15, 402 => 'Flash' },
	'flashaction' => { 343 => 0x3e, 344 => 0x3e, 355 => 0x2017, 359 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 343 => 0x4c, 344 => 0x4c, 359 => 0x77 },
	'flashactionexternal' => { 359 => [0x78,0x7c] },
	'flashactivity' => { 31 => 0x1c },
	'flashbatterylevel' => { 37 => 0x249 },
	'flashbias' => { 269 => 0x24 },
	'flashbits' => { 31 => 0x1d },
	'flashbuttonfunction' => { 73 => 0x70e },
	'flashchargelevel' => { 254 => 0x1010 },
	'flashcolorfilter' => { 184 => 0x10 },
	'flashcommandermode' => { 182 => '9.1', 183 => '9.1', 184 => '9.1' },
	'flashcompensation' => { 182 => 0xa, 183 => 0xa, 184 => 0xa, 394 => 'FlashCompensation' },
	'flashcontrol' => { 343 => 0x23, 344 => 0x1f, 345 => 0x21 },
	'flashcontrolbuilt-in' => { 242 => '16.1', 243 => '23.1', 245 => '23.1', 246 => '24.1' },
	'flashcontrolmode' => { 182 => '9.2', 183 => '9.2', 184 => '9.2', 249 => 0x404 },
	'flashcurtain' => { 269 => 0x48 },
	'flashdefault' => { 160 => 0x42 },
	'flashdevice' => { 254 => 0x1005 },
	'flashdistance' => { 101 => 0x2034 },
	'flashenergy' => { 105 => 0xa20b, 402 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 193 => 0x18 },
	'flashexposurecomp' => { 67 => 0xf, 110 => 0x1011, 138 => 'ExposureComp', 157 => 0x23, 162 => 0x104, 163 => 0x49c1, 193 => 0x12, 249 => 0x401, 254 => 0x1023, 302 => 0x4d, 327 => 0x100b, 336 => [0x3a,0x56], 355 => 0x104 },
	'flashexposurecomp2' => { 216 => 0x4d2 },
	'flashexposurecomp3' => { 184 => 0x1d },
	'flashexposurecomp4' => { 184 => 0x27 },
	'flashexposurecomparea' => { 237 => '38.4', 246 => '38.4' },
	'flashexposurecompset' => { 160 => 0x10, 276 => 0xe, 343 => 0x14, 344 => 0x12, 345 => 0x23, 359 => 0x1f },
	'flashexposurecompset2' => { 359 => [0x26,0x2c] },
	'flashexposureindicator' => { 160 => 0x54 },
	'flashexposureindicatorlast' => { 160 => 0x56 },
	'flashexposureindicatornext' => { 160 => 0x55 },
	'flashexposurelock' => { 49 => 0x19 },
	'flashfired' => { 121 => 0x5d, 138 => 'Fired', 157 => 0x14, 215 => '590.3', 269 => 0x8007, 402 => [\'Flash','FlashFired'] },
	'flashfiring' => { 73 => 0x306, 74 => 0x6, 75 => 0x7, 78 => 0x7 },
	'flashfirmwareversion' => { 250 => 0x1002 },
	'flashfocallength' => { 182 => 0xb, 183 => 0xc, 184 => 0xc },
	'flashfunction' => { 163 => 0x31, 402 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 182 => 0xe, 183 => 0xf, 184 => 0xf },
	'flashgroupacompensation' => { 182 => 0x11, 183 => 0x12, 184 => 0x13 },
	'flashgroupacontrolmode' => { 182 => 0xf, 183 => '16.1', 184 => '17.1' },
	'flashgroupaoutput' => { 182 => 0x11, 183 => 0x12, 184 => 0x13 },
	'flashgroupbcompensation' => { 182 => 0x12, 183 => 0x13, 184 => 0x14 },
	'flashgroupbcontrolmode' => { 182 => 0x10, 183 => '17.1', 184 => '18.1' },
	'flashgroupboutput' => { 182 => 0x12, 183 => 0x13, 184 => 0x14 },
	'flashgroupccompensation' => { 183 => 0x14, 184 => 0x15 },
	'flashgroupccontrolmode' => { 183 => '17.2', 184 => '18.2' },
	'flashgroupcoutput' => { 183 => 0x14, 184 => 0x15 },
	'flashguidenumber' => { 67 => 0xd, 83 => 0x0, 138 => 'GuideNumber' },
	'flashintensity' => { 100 => [0x19,0x5], 249 => 0x405 },
	'flashlevel' => { 238 => 0x9, 355 => 0xb048 },
	'flashmake' => { 138 => 'Make' },
	'flashmanufacturer' => { 155 => 'FlashManufacturer' },
	'flashmetering' => { 157 => 0x3f, 160 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 302 => 0x20a },
	'flashmode' => { 100 => 0x4, 121 => 0x5c, 138 => 'Mode', 157 => 0x2, 158 => 0x20, 159 => 0x16, 160 => 0xf, 193 => 0x87, 249 => 0x400, 254 => 0x1004, 302 => 0xc, 309 => 0x4, 326 => 0x20, 327 => 0x100a, 335 => 0x225, 343 => 0x13, 344 => 0x7f, 345 => 0x20, 359 => 0x10, 362 => 0x1138, 363 => 0x1138, 364 => 0x1114, 365 => 0x1190, 366 => 0x116c, 367 => 0x1024, 368 => 0x21c, 369 => 0x21c, 402 => [\'Flash','FlashMode'] },
	'flashmodel' => { 138 => 'Model', 155 => 'FlashModel', 250 => 0x1001 },
	'flashoptions' => { 283 => 0x2 },
	'flashoptions2' => { 283 => 0x10 },
	'flashoutput' => { 37 => 0x248, 67 => 0x21, 182 => 0xa, 183 => 0xa, 184 => 0xa },
	'flashpixversion' => { 105 => 0xa000, 402 => 'FlashpixVersion' },
	'flashredeyemode' => { 402 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 249 => 0x403 },
	'flashreturn' => { 402 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 138 => 'SerialNumber', 250 => 0x1003 },
	'flashsetting' => { 193 => 0x8 },
	'flashshutterspeed' => { 236 => '20.2', 237 => '23.2', 242 => '15.2', 243 => '22.2', 244 => '7.2', 245 => '22.2', 246 => '23.2', 247 => '23.1' },
	'flashsource' => { 182 => 0x4, 183 => 0x4, 184 => 0x4 },
	'flashstatus' => { 290 => 0x0, 359 => [0x82,0x86], 370 => [0x31,0x39] },
	'flashstatusbuilt-in' => { 345 => [0x87,0x287] },
	'flashstatusexternal' => { 345 => [0x88,0x288] },
	'flashsyncspeed' => { 236 => '20.1', 237 => '23.1', 242 => '15.1', 243 => '22.1', 245 => '22.1', 246 => '23.1' },
	'flashsyncspeedav' => { 71 => 0x3, 73 => 0x10f, 74 => 0x2, 75 => 0x3, 76 => 0x2, 77 => 0x2, 78 => 0x3, 79 => 0x6 },
	'flashthreshold' => { 83 => 0x1 },
	'flashtype' => { 138 => 'Type', 160 => 0x59, 193 => 0x9, 250 => 0x1000 },
	'flashwarning' => { 243 => '30.1', 244 => '7.1', 247 => '31.1', 269 => 0x62 },
	'flexiblespotposition' => { 355 => 0x201d },
	'flickerreduce' => { 335 => 0x218 },
	'fliphorizontal' => { 229 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 67 => 0x15, 105 => 0x829d, 118 => 0xfd04, 121 => 0x1e, 123 => 0xfa23, 125 => 0xf103, 128 => 0x13, 130 => 0x3c, 133 => 0xc, 142 => 'FNumber', 157 => 0xa, 158 => 0x36, 159 => 0x47, 160 => 0x9, 163 => 0x49c7, 302 => 0x13, 333 => 0xa019, 336 => [0x31,0x49], 343 => 0x1, 344 => 0x1, 359 => [0x20,0x22,0x26], 402 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 51 => 0x1, 101 => 0x1d, 105 => 0x920a, 128 => 0x1d, 142 => 'FocalLength', 157 => 0x12, 189 => 0xa, 190 => 0xb, 302 => 0x1d, 311 => 0x403, 327 => 0x1500, 342 => 0xe, 366 => 0x1278, 367 => 0x1134, 368 => 0x32c, 369 => 0x32c, 402 => 'FocalLength' },
	'focallength2' => { 359 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 105 => 0xa405, 333 => 0xa01a, 402 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 342 => 0x10 },
	'focalplanediagonal' => { 250 => 0x103, 254 => 0x205 },
	'focalplaneresolutionunit' => { 105 => 0xa210, 402 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 105 => 0xa20e, 402 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 51 => 0x2 },
	'focalplanexunknown' => { 51 => 0x2 },
	'focalplaneyresolution' => { 105 => 0xa20f, 402 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 51 => 0x3 },
	'focalplaneyunknown' => { 51 => 0x3 },
	'focaltype' => { 9 => 0x2d, 51 => 0x0 },
	'focalunits' => { 31 => 0x19 },
	'focus' => { 219 => 0x8 },
	'focusarea' => { 157 => 0x31 },
	'focusareaselection' => { 244 => '15.2' },
	'focuscontinuous' => { 31 => 0x20 },
	'focusdisplayaiservoandmf' => { 73 => 0x515 },
	'focusdistance' => { 142 => 'FocusDistance', 157 => 0x13, 163 => 0x49bb, 189 => 0x9, 190 => 0xa, 252 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 49 => 0x15, 67 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 49 => 0x14, 67 => 0x13 },
	'focusholdbutton' => { 160 => 0x44 },
	'focusinfoversion' => { 252 => 0x0 },
	'focusingscreen' => { 72 => 0x0, 73 => 0x80b, 78 => 0x0 },
	'focuslocked' => { 156 => 0x14 },
	'focusmode' => { 31 => 0x7, 100 => 0x3, 101 => [0x3003,0xd], 110 => 0x1021, 121 => 0x38, 135 => 'FocusMode', 157 => 0x30, 159 => 0xe, 160 => 0xc, 193 => 0x7, 249 => 0x301, 254 => 0x100b, 269 => 0x7, 302 => 0xd, 309 => 0x3, 327 => 0x1006, 337 => [0xb,0x5], 342 => [0x15,0x1d], 343 => 0x4d, 344 => 0x4d, 355 => [0xb042,0xb04e,0x201b], 359 => 0x13, 374 => 0x16 },
	'focusmode2' => { 283 => '3.1', 359 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 238 => '10.1', 340 => 0x14, 341 => 0x15, 343 => 0x10, 344 => 0xf, 345 => 0x6 },
	'focusmodeswitch' => { 160 => 0x58, 343 => 0x2e },
	'focuspixel' => { 110 => 0x1023 },
	'focuspointwrap' => { 236 => '2.2', 237 => '2.2', 242 => '2.2', 243 => '1.2', 246 => '2.2', 247 => '2.5' },
	'focusposition' => { 189 => 0x8, 190 => 0x8, 302 => 0x10, 354 => 0x9bb },
	'focusposition2' => { 359 => [0x29,0x2b,0x2f], 374 => 0x2d, 377 => 0x20 },
	'focusprocess' => { 249 => 0x302 },
	'focusrange' => { 31 => 0x12, 254 => 0x100a },
	'focusrangeindex' => { 293 => '3.1' },
	'focussetting' => { 336 => 0x6 },
	'focusstatus' => { 342 => 0x19, 343 => 0x53, 344 => 0x53 },
	'focusstepcount' => { 252 => 0x301, 254 => 0x100e },
	'focusstepinfinity' => { 252 => 0x303, 254 => 0x103b },
	'focusstepnear' => { 252 => 0x304, 254 => 0x103c },
	'focustrackinglockon' => { 236 => ['1.5','4.1'], 237 => '1.4', 242 => '3.1', 243 => '0.4', 246 => '1.4' },
	'focuswarning' => { 110 => 0x1301 },
	'foldername' => { 157 => 0x27 },
	'foldernumber' => { 343 => 0x9a, 345 => [0x402,0x114,0x316] },
	'fontcomposite' => { 428 => [\'Fonts','FontsComposite'] },
	'fontface' => { 428 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 428 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 428 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 428 => [\'Fonts','FontsFontName'] },
	'fonts' => { 428 => 'Fonts' },
	'fonttype' => { 428 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 428 => [\'Fonts','FontsVersionString'] },
	'for' => { 318 => 'For' },
	'format' => { 399 => 'format', 421 => 'Format' },
	'forwardlock' => { 418 => 'forwardlock' },
	'forwardmatrix1' => { 105 => 0xc714 },
	'forwardmatrix2' => { 105 => 0xc715 },
	'framecount' => { 58 => [0x2,0x4] },
	'frameheight' => { 110 => 0x3822 },
	'framenum' => { 313 => 0xd7 },
	'framenumber' => { 110 => 0x8003, 163 => 0x3c, 302 => 0x29 },
	'framerate' => { 58 => [0x1,0x6], 105 => 0xc764, 110 => 0x3820 },
	'framewidth' => { 110 => 0x3821 },
	'framing' => { 412 => 'framing' },
	'freebytes' => { 86 => 0x1 },
	'freememorycardimages' => { 158 => [0x37,0x54], 159 => [0x2d,0x4a], 160 => 0x32 },
	'fujiflashmode' => { 110 => 0x1010 },
	'fullimagesize' => { 355 => 0xb02b },
	'fullpanoheightpixels' => { 387 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 387 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 327 => 0x100d },
	'fullsizeimage' => { 141 => 'data' },
	'fullsizeimagename' => { 141 => '1Name' },
	'fullsizeimagetype' => { 141 => '0Type' },
	'funcbutton' => { 236 => ['14.1','15.1'], 237 => '14.1', 242 => '28.1', 243 => '13.1', 246 => '14.1', 247 => '14.1' },
	'funcbuttonplusdials' => { 236 => ['14.2','15.2'], 237 => '14.2', 242 => '31.1', 246 => '42.1' },
	'functionbutton' => { 241 => '13.1', 244 => '5.2' },
	'gainbase' => { 253 => 0x610 },
	'gaincontrol' => { 105 => 0xa407, 402 => 'GainControl' },
	'gamma' => { 105 => 0xa500, 403 => 'Gamma' },
	'gammablackpoint' => { 93 => 0xc },
	'gammacolortone' => { 93 => 0x3 },
	'gammacompensatedvalue' => { 115 => 0x91 },
	'gammacontrast' => { 93 => 0x2 },
	'gammacurveoutputrange' => { 93 => 0xf },
	'gammahighlight' => { 93 => 0xa },
	'gammalinear' => { 91 => 0x20200 },
	'gammamidpoint' => { 93 => 0xe },
	'gammasaturation' => { 93 => 0x4 },
	'gammashadow' => { 93 => 0x9 },
	'gammasharpnessstrength' => { 93 => 0x8 },
	'gammaunsharpmaskfineness' => { 93 => 0x6 },
	'gammaunsharpmaskstrength' => { 93 => 0x5 },
	'gammaunsharpmaskthreshold' => { 93 => 0x7 },
	'gammawhitepoint' => { 93 => 0xd },
	'geimagesize' => { 110 => 0x1304 },
	'gemake' => { 111 => 0x300 },
	'gemodel' => { 111 => 0x207 },
	'genre' => { 413 => 'genre', 423 => 'genre' },
	'geography' => { 414 => 'geography' },
	'geologicalcontext' => { 104 => 'GeologicalContext' },
	'geologicalcontextbed' => { 104 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 104 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 104 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 104 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 104 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 106 => 'Geosync' },
	'geotag' => { 106 => 'Geotag' },
	'geotiffasciiparams' => { 105 => 0x87b1 },
	'geotiffdirectory' => { 105 => 0x87af },
	'geotiffdoubleparams' => { 105 => 0x87b0 },
	'geotime' => { 106 => 'Geotime' },
	'globalaltitude' => { 316 => 0x419 },
	'globalangle' => { 316 => 0x40d },
	'good' => { 423 => 'good' },
	'googleplusuploadcode' => { 105 => 0x9009 },
	'gpsaltitude' => { 112 => 0x6, 139 => 'Altitude', 402 => 'GPSAltitude' },
	'gpsaltituderef' => { 112 => 0x5, 402 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 112 => 0x1c, 402 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 112 => 0x1d },
	'gpsdatetime' => { 139 => 'DateTime', 402 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 112 => 0x18, 139 => 'Bearing', 402 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 112 => 0x17, 402 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 112 => 0x1a, 139 => 'Distance', 402 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 112 => 0x19, 402 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 112 => 0x14, 402 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 112 => 0x13 },
	'gpsdestlongitude' => { 112 => 0x16, 402 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 112 => 0x15 },
	'gpsdifferential' => { 112 => 0x1e, 139 => 'Differential', 402 => 'GPSDifferential' },
	'gpsdop' => { 112 => 0xb, 402 => 'GPSDOP' },
	'gpshpositioningerror' => { 112 => 0x1f, 402 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 112 => 0x11, 402 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 112 => 0x10, 402 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 112 => 0x2, 139 => 'Latitude', 402 => 'GPSLatitude' },
	'gpslatituderef' => { 112 => 0x1 },
	'gpslongitude' => { 112 => 0x4, 139 => 'Longitude', 402 => 'GPSLongitude' },
	'gpslongituderef' => { 112 => 0x3 },
	'gpsmapdatum' => { 112 => 0x12, 139 => 'Datum', 402 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 112 => 0xa, 139 => 'MeasureMode', 402 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 112 => 0x1b, 402 => 'GPSProcessingMethod' },
	'gpssatellites' => { 112 => 0x8, 139 => 'Satellites', 402 => 'GPSSatellites' },
	'gpsspeed' => { 112 => 0xd, 139 => 'Speed', 402 => 'GPSSpeed' },
	'gpsspeedref' => { 112 => 0xc, 402 => 'GPSSpeedRef' },
	'gpsstatus' => { 112 => 0x9, 402 => 'GPSStatus' },
	'gpstimestamp' => { 112 => 0x7 },
	'gpstrack' => { 112 => 0xf, 139 => 'Heading', 402 => 'GPSTrack' },
	'gpstrackref' => { 112 => 0xe, 402 => 'GPSTrackRef' },
	'gpsversionid' => { 112 => 0x0, 402 => 'GPSVersionID' },
	'gradation' => { 249 => 0x50f },
	'gradientbasedcorractive' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 398 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 398 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 398 => 'GrainAmount' },
	'grainfrequency' => { 398 => 'GrainFrequency' },
	'grainsize' => { 398 => 'GrainSize' },
	'graymixeraqua' => { 398 => 'GrayMixerAqua' },
	'graymixerblue' => { 398 => 'GrayMixerBlue' },
	'graymixergreen' => { 398 => 'GrayMixerGreen' },
	'graymixermagenta' => { 398 => 'GrayMixerMagenta' },
	'graymixerorange' => { 398 => 'GrayMixerOrange' },
	'graymixerpurple' => { 398 => 'GrayMixerPurple' },
	'graymixerred' => { 398 => 'GrayMixerRed' },
	'graymixeryellow' => { 398 => 'GrayMixerYellow' },
	'graypoint' => { 383 => 0x8021 },
	'grayresponseunit' => { 105 => 0x122 },
	'greencurvelimits' => { 96 => 0x1c4 },
	'greencurvepoints' => { 95 => 0x53, 96 => 0x19a },
	'greenhsl' => { 91 => 0x20912 },
	'greenhue' => { 398 => 'GreenHue' },
	'greensaturation' => { 398 => 'GreenSaturation' },
	'griddisplay' => { 236 => '13.3', 237 => '4.3', 239 => '2.2', 242 => '10.5', 243 => '3.4', 244 => '6.1', 246 => '4.4', 247 => '4.2' },
	'gripbatteryadload' => { 281 => 0x5 },
	'gripbatteryadnoload' => { 281 => 0x4 },
	'gripbatterystate' => { 281 => '1.2' },
	'groupareaafillumination' => { 237 => '46.4', 246 => '47.4' },
	'halftonehints' => { 105 => 0x141 },
	'hardlink' => { 106 => 'HardLink' },
	'hasalternative' => { 413 => 'hasAlternative' },
	'hascorrection' => { 413 => 'hasCorrection' },
	'hascorrectiona-lang' => { 413 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 413 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 413 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 398 => 'HasCrop' },
	'hasextendedxmp' => { 425 => 'HasExtendedXMP' },
	'hassettings' => { 398 => 'HasSettings' },
	'hastranslation' => { 413 => 'hasTranslation' },
	'hdr' => { 52 => 0x1, 186 => 0x4, 269 => 0x9e, 302 => 0x85, 355 => 0x200a },
	'hdreffect' => { 52 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 186 => 0x0 },
	'hdrlevel' => { 186 => 0x5, 345 => 0x2e, 359 => 0x17 },
	'hdrlevel2' => { 186 => 0x7 },
	'hdrsetting' => { 345 => 0x2d, 359 => 0x16, 362 => 0x1148, 363 => 0x1148, 364 => 0x1124, 365 => 0x11a0, 366 => 0x117c, 367 => 0x1034, 368 => 0x22c, 369 => 0x22c },
	'hdrsmoothing' => { 186 => 0x6 },
	'headline' => { 113 => 0x69, 410 => 'Headline' },
	'hierarchicalkeywords' => { 150 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 150 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 150 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 150 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 150 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 150 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 150 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 389 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 104 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 273 => 0x1a },
	'highisomultipliergreen' => { 273 => 0x19 },
	'highisomultiplierred' => { 273 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 54 => 0x5, 73 => 0x202, 110 => 0x100e, 193 => 0xb1, 302 => 0x71, 343 => 0x2c, 344 => 0x26, 345 => 0x26, 355 => 0x2009, 359 => 0x12, 379 => 0x42 },
	'highisonoisereduction2' => { 355 => 0xb050 },
	'highlight' => { 336 => 0xf },
	'highlightadj' => { 91 => 0x2030c },
	'highlightcolordistortreduct' => { 383 => 0x8026 },
	'highlightprotection' => { 228 => 0x6 },
	'highlightrecovery' => { 398 => 'HighlightRecovery' },
	'highlights' => { 391 => 'Highlights' },
	'highlights2012' => { 398 => 'Highlights2012' },
	'highlighttone' => { 110 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 54 => 0x3, 73 => 0x203 },
	'highlowkeyadj' => { 302 => 0x6c },
	'highspeedsync' => { 160 => 0x5, 343 => 0x2, 344 => 0x2 },
	'histogramxml' => { 229 => 0x83a1a25 },
	'history' => { 410 => 'History', 424 => 'History' },
	'historyaction' => { 424 => [\'History','HistoryAction'] },
	'historychanged' => { 424 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 424 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 424 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 424 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 424 => [\'History','HistoryWhen'] },
	'hometowncity' => { 101 => 0x3006, 302 => 0x23, 308 => 0x2 },
	'hometowncitycode' => { 309 => 0x1000 },
	'hometowndst' => { 302 => 0x25, 308 => '0.2' },
	'hostcomputer' => { 105 => 0x13c },
	'hue' => { 165 => 0x3b, 302 => 0x67 },
	'hueadj' => { 232 => 0x2f, 383 => 0x8019 },
	'hueadjust' => { 327 => 0x1016 },
	'hueadjustment' => { 158 => 0x4a, 159 => 0x40, 193 => 0x92, 195 => 0x36 },
	'hueadjustmentaqua' => { 398 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 398 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 398 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 398 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 398 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 398 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 398 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 398 => 'HueAdjustmentYellow' },
	'huesetting' => { 257 => 0x1011 },
	'icc_profile' => { 106 => 'ICC_Profile' },
	'iccprofilename' => { 410 => 'ICCProfile' },
	'idccreativestyle' => { 383 => 0x8000 },
	'idcpreviewlength' => { 383 => 0x202 },
	'idcpreviewstart' => { 383 => 0x201 },
	'identification' => { 104 => 'Identification' },
	'identificationid' => { 104 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 104 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 104 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 104 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 104 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 104 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 399 => 'identifier', 421 => 'Identifier' },
	'illumination' => { 244 => '0.5' },
	'imageadjustment' => { 193 => 0x80, 219 => 0x5 },
	'imagealterationconstraints' => { 411 => 'ImageAlterationConstraints' },
	'imagearea' => { 204 => 0x10, 207 => 0x10 },
	'imageareaoffset' => { 302 => 0x38 },
	'imageauthentication' => { 193 => 0x20 },
	'imageboundary' => { 193 => 0x16 },
	'imagecount' => { 110 => 0x1438, 193 => 0xa5, 357 => 0x11b, 370 => [0x32,0x3a] },
	'imagecount2' => { 370 => [0x4c,0x58] },
	'imagecount3' => { 370 => [0x1a0,0x1aa,0x1bd,0x1cb] },
	'imagecreator' => { 411 => 'ImageCreator' },
	'imagecreatorid' => { 411 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 411 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 411 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 193 => 0xa2 },
	'imagedescription' => { 105 => 0x10e, 419 => 'ImageDescription' },
	'imageduplicationconstraints' => { 411 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 229 => 0xfe443a45 },
	'imageeditcount' => { 302 => 0x41 },
	'imageediting' => { 302 => 0x32 },
	'imageeffects' => { 327 => 0x1010 },
	'imagefileconstraints' => { 411 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 411 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 411 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 110 => 0x1436 },
	'imageheight' => { 105 => 0x101, 164 => 0xc, 311 => 0x10d, 419 => 'ImageLength' },
	'imagehistory' => { 105 => 0x9213, 401 => 'ImageHistory' },
	'imageidnumber' => { 265 => 0x340 },
	'imagenumber' => { 105 => 0x9211, 135 => 'ImageNumber', 158 => 0xae, 159 => 0x5e, 311 => 0x113, 343 => 0x9b, 345 => [0x400,'276.1',0x314], 394 => 'ImageNumber' },
	'imagenumber2' => { 159 => 0x62 },
	'imageoptimization' => { 193 => 0xa9 },
	'imageorientation' => { 113 => 0x83 },
	'imageprocessing' => { 193 => 0x1a },
	'imageprocessingversion' => { 253 => 0x0 },
	'imagequality' => { 135 => 'ImageQuality', 206 => '723.2', 207 => '732.2', 215 => '708.1', 269 => 0x1 },
	'imagequality2' => { 249 => 0x603 },
	'imageref' => { 406 => 'ImageRef' },
	'imagereview' => { 238 => '0.4', 244 => '0.4' },
	'imagereviewmonitorofftime' => { 237 => '21.1', 246 => '21.1' },
	'imagereviewtime' => { 236 => '25.1', 238 => '2.1', 239 => '19.1', 240 => '20.1', 241 => '20.1', 242 => '9.2', 243 => '20.1', 247 => '21.2' },
	'imagesize' => { 141 => 'ImageSize' },
	'imagesizerestriction' => { 416 => 'imageSizeRestriction' },
	'imagesourcedata' => { 105 => 0x935c },
	'imagestabilization' => { 31 => 0x22, 101 => 0x3020, 110 => 0x1422, 135 => 'ImageStabilization', 158 => 0xbd, 159 => 0x71, 160 => 0x57, 161 => 0x0, 162 => [0x18,0x107,0x113], 163 => 0x49c2, 193 => 0xac, 249 => 0x604, 252 => 0x1600, 269 => 0x1a, 348 => 0x12, 349 => 0x11, 355 => 0xb026 },
	'imagestabilization2' => { 347 => 0xa },
	'imagestabilizationsetting' => { 163 => 0x14, 343 => 0x3d, 344 => 0x3d, 354 => 0x14 },
	'imagestyle' => { 343 => 0x2d, 344 => 0x27 },
	'imagesupplier' => { 411 => 'ImageSupplier' },
	'imagesupplierid' => { 411 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 411 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 411 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 107 => 0x1 },
	'imagetemperaturemin' => { 107 => 0x2 },
	'imagetone' => { 302 => 0x4f },
	'imagetype' => { 113 => 0x82, 411 => 'ImageType' },
	'imageuniqueid' => { 55 => 0x28, 105 => 0xa420, 402 => 'ImageUniqueID' },
	'imagewidth' => { 105 => 0x100, 164 => 0xe, 311 => 0x10c, 419 => 'ImageWidth' },
	'incrementaltemperature' => { 398 => 'IncrementalTemperature' },
	'incrementaltint' => { 398 => 'IncrementalTint' },
	'industry' => { 413 => 'industry', 414 => 'industry' },
	'infobuttonwhenshooting' => { 73 => 0x409 },
	'infraredilluminator' => { 323 => 0x28 },
	'ingredientexclusion' => { 415 => 'ingredientExclusion' },
	'ingredients' => { 424 => 'Ingredients' },
	'ingredientsalternatepaths' => { 424 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 424 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 424 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 424 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 424 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 424 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 424 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 424 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 424 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 424 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 424 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 424 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 424 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 424 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 424 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 424 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 424 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 387 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 387 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 387 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 387 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 236 => '4.4' },
	'initialzoomsetting' => { 236 => '9.3', 242 => '27.3' },
	'inkset' => { 105 => 0x14c },
	'inputprofile' => { 119 => 0x1389 },
	'instanceid' => { 424 => 'InstanceID' },
	'instantplaybacksetup' => { 160 => 0x3e },
	'instantplaybacktime' => { 160 => 0x3d },
	'instructions' => { 410 => 'Instructions' },
	'instrument' => { 423 => 'instrument' },
	'intellectualgenre' => { 407 => 'IntellectualGenre' },
	'intelligentauto' => { 355 => 0xb052 },
	'intelligentcontrast' => { 44 => 0x4 },
	'intelligentd-range' => { 269 => 0x79 },
	'intelligentexposure' => { 269 => 0x5d },
	'intelligentresolution' => { 269 => 0x70 },
	'interchangecolorspace' => { 115 => 0x40 },
	'internalflash' => { 157 => 0x2b, 236 => '23.1', 238 => '8.1', 239 => '22.1', 241 => '23.1', 244 => '8.1', 247 => '24.1', 252 => 0x1208 },
	'internalflashae1' => { 254 => 0x1021 },
	'internalflashae1_0' => { 254 => 0x101d },
	'internalflashae2' => { 254 => 0x1022 },
	'internalflashae2_0' => { 254 => 0x101e },
	'internalflashmode' => { 290 => 0x1 },
	'internalflashstrength' => { 290 => 0x3 },
	'internalflashtable' => { 254 => 0x1024 },
	'internallensserialnumber' => { 333 => 0xa005 },
	'internalndfilter' => { 269 => 0x9d },
	'internalserialnumber' => { 55 => 0x96, 66 => 0x9, 110 => 0x10, 163 => 0x49dc, 248 => 0x18, 250 => 0x102, 269 => 0x25, 282 => 0x4, 327 => 0x5, 370 => [0x7c,0x88,0xf0] },
	'interopindex' => { 105 => 0x1, 403 => 'InteroperabilityIndex' },
	'interopversion' => { 105 => 0x2 },
	'intervallength' => { 157 => 0x10 },
	'intervalmode' => { 157 => 0x26 },
	'intervalnumber' => { 157 => 0x11 },
	'introtime' => { 423 => 'introTime' },
	'introtimescale' => { 423 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 423 => [\'introTime','introTimeValue'] },
	'iptc' => { 106 => 'IPTC' },
	'iptc-naa' => { 105 => 0x83bb, 273 => 0x83bb },
	'iptcbitspersample' => { 115 => 0x56 },
	'iptcdigest' => { 316 => 0x425 },
	'iptcimageheight' => { 115 => 0x1e },
	'iptcimagerotation' => { 115 => 0x66 },
	'iptcimagewidth' => { 115 => 0x14 },
	'iptclastedited' => { 408 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 115 => 0xa },
	'iptcpixelheight' => { 115 => 0x32 },
	'iptcpixelwidth' => { 115 => 0x28 },
	'isalternativeof' => { 413 => 'isAlternativeOf' },
	'isbn' => { 413 => 'isbn' },
	'iscorrectionof' => { 413 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 97 => 0x3 },
	'ismergedhdr' => { 394 => 'IsMergedHDR' },
	'ismergedpanorama' => { 394 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 100 => 0x14, 101 => [0x3014,0x14], 105 => 0x8827, 118 => 0xfd06, 119 => 0x1784, 121 => 0x60, 123 => [0xfa2e,0xfa46], 124 => [0x27,0x28], 125 => 0xf105, 128 => 0x14, 130 => 0x4e, 133 => 0x34, 135 => 'ISO', 157 => 0x8, 163 => 0x49ba, 187 => 0x0, 193 => 0x2, 273 => 0x17, 302 => [0x8b,0x14], 309 => 0x14, 311 => 0x105, 333 => 0xa014, 354 => 0x6f, 359 => [0x1f,0x21,0x25], 402 => 'ISOSpeedRatings' },
	'iso2' => { 187 => 0x6, 201 => 0x265, 202 => 0x25c, 203 => 0x265, 204 => 0x221, 205 => 0x25d, 206 => 0x256, 207 => 0x25d, 210 => 0x2b5, 213 => 0x265, 218 => 0x2b5 },
	'isoauto' => { 283 => '14.4' },
	'isoautoparameters' => { 302 => 0x7a },
	'isodisplay' => { 239 => '2.3', 240 => '3.3', 241 => '3.3', 243 => '3.3', 246 => '4.3', 247 => '4.3' },
	'isoexpansion' => { 73 => 0x103, 74 => 0x7, 75 => 0x8, 78 => 0x8, 187 => 0x4 },
	'isoexpansion2' => { 187 => 0xa },
	'isofloor' => { 283 => 0x6 },
	'isoselection' => { 193 => 0xf },
	'isosensitivitystep' => { 243 => '6.2' },
	'isosetting' => { 121 => 0x5e, 135 => 'ISOSetting', 157 => 0x24, 158 => 0x26, 159 => 0x1c, 160 => 0x13, 165 => 0x6, 193 => 0x13, 283 => '17.3', 326 => 0x27, 343 => 0x16, 344 => 0x14, 345 => 0x2, 354 => 0x6d },
	'isospeed' => { 105 => 0x8833, 403 => 'ISOSpeed' },
	'isospeedexpansion' => { 72 => 0x3 },
	'isospeedincrements' => { 73 => 0x102 },
	'isospeedlatitudeyyy' => { 105 => 0x8834, 403 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 105 => 0x8835, 403 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 73 => 0x103 },
	'isostepsize' => { 236 => '6.1', 237 => '7.2', 242 => '4.1', 246 => '7.2' },
	'isovalue' => { 254 => 0x1001 },
	'issn' => { 413 => 'issn' },
	'issueidentifier' => { 413 => 'issueIdentifier' },
	'issuename' => { 413 => 'issueName' },
	'issueteaser' => { 413 => 'issueTeaser' },
	'issuetype' => { 413 => 'issueType' },
	'istranslationof' => { 413 => 'isTranslationOf' },
	'jobid' => { 113 => 0xb8 },
	'jobname' => { 404 => 'JobName' },
	'jobref' => { 422 => 'JobRef' },
	'jobrefid' => { 422 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 422 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 422 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 404 => 'JobStatus' },
	'jpegquality' => { 9 => 0x66, 271 => 0x3034, 355 => 0xb047 },
	'jpegsize' => { 271 => 0x303a },
	'jpgfromraw' => { 86 => 0x2007, 102 => 'JpgFromRaw', 273 => 0x2e },
	'jpgfromrawlength' => { 105 => [0x117,0x202] },
	'jpgfromrawstart' => { 105 => [0x111,0x201] },
	'jpgrecordedpixels' => { 283 => '14.1' },
	'jurisdiction' => { 395 => 'jurisdiction' },
	'kelvinwb_01' => { 291 => 0x5 },
	'kelvinwb_02' => { 291 => 0x9 },
	'kelvinwb_03' => { 291 => 0xd },
	'kelvinwb_04' => { 291 => 0x11 },
	'kelvinwb_05' => { 291 => 0x15 },
	'kelvinwb_06' => { 291 => 0x19 },
	'kelvinwb_07' => { 291 => 0x1d },
	'kelvinwb_08' => { 291 => 0x21 },
	'kelvinwb_09' => { 291 => 0x25 },
	'kelvinwb_10' => { 291 => 0x29 },
	'kelvinwb_11' => { 291 => 0x2d },
	'kelvinwb_12' => { 291 => 0x31 },
	'kelvinwb_13' => { 291 => 0x35 },
	'kelvinwb_14' => { 291 => 0x39 },
	'kelvinwb_15' => { 291 => 0x3d },
	'kelvinwb_16' => { 291 => 0x41 },
	'kelvinwb_daylight' => { 291 => 0x1 },
	'key' => { 423 => 'key' },
	'keyword' => { 413 => 'keyword' },
	'keywordinfo' => { 150 => 'Keywords' },
	'keywords' => { 113 => 0x19, 136 => 'Keywords', 258 => 'Keywords', 318 => 'Keywords', 392 => 'keywords', 409 => 'Keywords', 421 => 'Keywords' },
	'killdate' => { 413 => 'killDate' },
	'killdatea-platform' => { 413 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 413 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 118 => 0xf908, 121 => 0xe, 123 => [0xfa1e,0xfa52], 129 => 0x70 },
	'kodakimagewidth' => { 118 => 0xf907, 121 => 0xc, 123 => [0xfa1d,0xfa51], 129 => 0x6c },
	'kodakinfotype' => { 118 => 0xfa00 },
	'kodaklook' => { 119 => 0xe4c },
	'kodaklookprofile' => { 119 => 0x138a },
	'kodakmaker' => { 129 => 0x8 },
	'kodakmodel' => { 121 => 0x0, 129 => 0x28 },
	'label' => { 261 => 'Label', 421 => 'Label' },
	'labelname1' => { 406 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 406 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 269 => 0x6f },
	'landscapeoutputhighlightpoint' => { 97 => 0x26 },
	'landscapeoutputshadowpoint' => { 97 => 0x27 },
	'landscaperawcolortone' => { 97 => 0x1f },
	'landscaperawcontrast' => { 97 => 0x21 },
	'landscaperawhighlight' => { 97 => 0x77 },
	'landscaperawhighlightpoint' => { 97 => 0x24 },
	'landscaperawlinear' => { 97 => 0x22 },
	'landscaperawsaturation' => { 97 => 0x20 },
	'landscaperawshadow' => { 97 => 0x80 },
	'landscaperawshadowpoint' => { 97 => 0x25 },
	'landscaperawsharpness' => { 97 => 0x23 },
	'landscapeunsharpmaskfineness' => { 97 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 97 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 97 => 0xa2 },
	'language' => { 399 => 'language' },
	'languageidentifier' => { 113 => 0x87 },
	'largestvalidinteriorrectheight' => { 387 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 387 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 387 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 387 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 157 => 0x1b },
	'lastkeywordiptc' => { 155 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 155 => 'LastKeywordXMP' },
	'lastphotodate' => { 387 => 'LastPhotoDate' },
	'lasturl' => { 424 => 'LastURL' },
	'lateralchromaticaberration' => { 355 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 394 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 104 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 104 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 104 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 104 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 104 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 293 => 0x2 },
	'lc10' => { 293 => 0xb },
	'lc11' => { 293 => 0xc },
	'lc12' => { 293 => 0xd },
	'lc14' => { 293 => 0xf },
	'lc15' => { 293 => 0x10 },
	'lc3' => { 293 => 0x4 },
	'lc4' => { 293 => 0x5 },
	'lc5' => { 293 => 0x6 },
	'lc6' => { 293 => 0x7 },
	'lc7' => { 293 => 0x8 },
	'lc8' => { 293 => 0x9 },
	'lcddisplayatpoweron' => { 73 => 0x811, 77 => 0xa },
	'lcddisplayreturntoshoot' => { 78 => 0x12 },
	'lcdillumination' => { 236 => '17.5', 237 => '5.2', 242 => '10.3', 243 => '4.2', 246 => '5.2', 247 => '5.4' },
	'lcdilluminationduringbulb' => { 73 => 0x408 },
	'lcdpanels' => { 72 => 0x8 },
	'lcheditor' => { 229 => 0x8ae85e },
	'legacyiptcdigest' => { 410 => 'LegacyIPTCDigest' },
	'legalcode' => { 395 => 'legalcode' },
	'lens' => { 105 => 0xfdea, 193 => 0x84, 394 => 'Lens' },
	'lensafstopbutton' => { 71 => 0x11, 72 => 0x13, 73 => 0x506, 74 => 0x10, 75 => 0x12, 78 => 0x13, 79 => 0x9 },
	'lensaperturerange' => { 336 => [0x30,0x48] },
	'lenscorrectionsettings' => { 401 => 'LensCorrectionSettings' },
	'lensdistortionparams' => { 254 => 0x206 },
	'lensdrivenoaf' => { 73 => 0x505 },
	'lense-mountversion' => { 345 => 0x3f0, 382 => 0xd },
	'lensfirmware' => { 328 => 0x20, 333 => 0xa004 },
	'lensfirmwareversion' => { 250 => 0x204, 269 => 0x60, 345 => 0x3f4, 382 => 0x15 },
	'lensfocallength' => { 91 => 0xf0512, 293 => 0x9 },
	'lensfocalrange' => { 336 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 237 => '55.1', 246 => '52.1' },
	'lensformat' => { 366 => 0x1891, 368 => 0x18bd, 369 => 0x18ed, 370 => 0x106, 378 => 0x603, 379 => 0x5d },
	'lensfstops' => { 188 => 0x7, 189 => 0xc, 190 => 0xd, 193 => 0x8b, 293 => '0.3' },
	'lensid' => { 394 => 'LensID' },
	'lensidnumber' => { 188 => 0x6, 189 => 0xb, 190 => 0xc },
	'lensinfo' => { 105 => 0xa432, 299 => 0x2a, 394 => 'LensInfo', 403 => 'LensSpecification' },
	'lenskind' => { 293 => 0x1 },
	'lensmake' => { 105 => 0xa433, 142 => 'Make', 403 => 'LensMake' },
	'lensmanualdistortionamount' => { 398 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 155 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 336 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 55 => 0x95, 105 => 0xa434, 142 => 'Model', 155 => 'LensModel', 191 => 0x18a, 250 => 0x203, 267 => 0x303, 299 => 0xc, 311 => 0x412, 403 => 'LensModel' },
	'lensmount' => { 345 => 0x99, 366 => 0x1892, 368 => 0x18be, 369 => 0x18ee, 370 => 0x105, 378 => 0x604, 379 => 0x5e },
	'lensmount2' => { 382 => 0x8 },
	'lensparameters' => { 363 => 0x1a23, 366 => 0x1870, 368 => 0x189c, 369 => 0x18cc, 378 => 0x6ca, 379 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 398 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 398 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 398 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 398 => 'LensProfileEnable' },
	'lensprofilefilename' => { 398 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 398 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 398 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 398 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 398 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 398 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 398 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 398 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 398 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 398 => 'LensProfileName' },
	'lensprofilesetup' => { 398 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 398 => 'LensProfileVignettingScale' },
	'lensproperties' => { 250 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 29 => 0x16b, 53 => 0x0, 105 => 0xa435, 142 => 'SerialNumber', 250 => 0x202, 269 => 0x52, 328 => 0x30, 394 => 'LensSerialNumber', 403 => 'LensSerialNumber' },
	'lensshutterlock' => { 160 => 0x4a },
	'lensspec' => { 340 => 0x0, 341 => 0x0, 342 => 0x0, 355 => 0xb02a },
	'lensspecfeatures' => { 370 => [0x115,0x116] },
	'lenstemperature' => { 254 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 31 => 0x16, 162 => 0x10c, 163 => 0x49bd, 193 => 0x83, 250 => 0x201, 262 => 0x16, 265 => 0x310, 268 => 0x303, 269 => 0x51, 271 => 0x3405, 294 => 0x0, 295 => 0x0, 296 => 0x1, 297 => 0x1, 298 => 0x1, 300 => 0x0, 333 => 0xa003, 336 => 0x27, 355 => 0xb027, 366 => 0x1896, 368 => 0x18c2, 369 => 0x18f2, 370 => 0x109, 378 => 0x608, 379 => 0x62 },
	'lenstype2' => { 345 => 0x3f7, 366 => 0x1893, 368 => 0x18bf, 369 => 0x18ef, 370 => 0x107, 378 => 0x605, 379 => 0x60 },
	'lenstype3' => { 382 => 0x9 },
	'lenszoomposition' => { 376 => 0x19, 377 => 0x1e, 379 => [0x342,0x35a] },
	'levelindicator' => { 276 => 0x15 },
	'levelorientation' => { 301 => 0x0 },
	'license' => { 395 => 'license' },
	'licensee' => { 411 => 'Licensee' },
	'licenseeid' => { 411 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 411 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 411 => 'LicenseeImageNotes' },
	'licenseename' => { 411 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 411 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 411 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 411 => 'LicenseeTransactionID' },
	'licenseid' => { 411 => 'LicenseID' },
	'licensestartdate' => { 411 => 'LicenseStartDate' },
	'licensetransactiondate' => { 411 => 'LicenseTransactionDate' },
	'licensetype' => { 400 => 'licensetype' },
	'licensor' => { 411 => 'Licensor' },
	'licensorcity' => { 411 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 411 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 411 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 411 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 411 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 411 => 'LicensorImageID' },
	'licensorname' => { 411 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 411 => 'LicensorNotes' },
	'licensorpostalcode' => { 411 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 411 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 411 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 411 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 411 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 411 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 411 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 411 => 'LicensorTransactionID' },
	'licensorurl' => { 411 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 254 => 0x1009 },
	'lightingmode' => { 101 => 0x302a },
	'lightreading' => { 302 => 0x15 },
	'lightsource' => { 105 => 0x9208, 193 => 0x90, 257 => 0x1000, 402 => 'LightSource' },
	'lightsourcespecial' => { 335 => 0x21d },
	'lightswitch' => { 246 => '0.1', 247 => '0.1' },
	'lightvaluecenter' => { 254 => 0x103d },
	'lightvalueperiphery' => { 254 => 0x103e },
	'limitafareamodeselection' => { 237 => '51.1', 246 => '49.1' },
	'linearitylimitblue' => { 273 => 0x10 },
	'linearitylimitgreen' => { 273 => 0xf },
	'linearitylimitred' => { 273 => 0xe },
	'linearityuppermargin' => { 38 => [0x2ba,0x2d1,0x2d5], 40 => 0x1e5, 41 => [0x1fe,0x2de], 42 => 0x310 },
	'linearizationtable' => { 105 => 0xc618 },
	'linearresponselimit' => { 105 => 0xc62e },
	'link' => { 413 => 'link' },
	'linkaetoafpoint' => { 283 => '14.2' },
	'linkedencodedrightsexpr' => { 408 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 408 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 408 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 408 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 104 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 239 => '32.1', 247 => '34.1' },
	'liveviewafareamode' => { 243 => '34.1' },
	'liveviewafmethod' => { 359 => 0x20 },
	'liveviewafmode' => { 243 => '34.2' },
	'liveviewafsetting' => { 345 => 0x36 },
	'liveviewbuttonoptions' => { 237 => '50.2', 246 => '48.2' },
	'liveviewexposuresimulation' => { 73 => 0x810 },
	'liveviewfocusmode' => { 345 => [0x8b,0x28b] },
	'liveviewmetering' => { 345 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 237 => '21.2', 240 => '20.2', 241 => '20.2', 243 => '20.2', 246 => '21.2' },
	'liveviewshooting' => { 49 => 0x13 },
	'localcaption' => { 113 => 0x79 },
	'localizedcameramodel' => { 105 => 0xc615 },
	'locallocationname' => { 333 => 0x30 },
	'location' => { 192 => 0x9, 269 => 0x67, 390 => 'Location', 407 => 'Location', 412 => 'location', 413 => 'location' },
	'locationareacode' => { 396 => 'lac' },
	'locationcreated' => { 408 => 'LocationCreated' },
	'locationcreatedcity' => { 408 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 408 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 408 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 408 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 408 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 408 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 408 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 192 => 0x0 },
	'locationname' => { 333 => 0x31 },
	'locationshown' => { 408 => 'LocationShown' },
	'locationshowncity' => { 408 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 408 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 408 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 408 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 408 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 408 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 408 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 73 => 0x709 },
	'logcomment' => { 423 => 'logComment' },
	'longexposurenoisereduction' => { 54 => 0x4, 73 => 0x201, 74 => 0x1, 75 => 0x2, 76 => 0x1, 77 => 0x1, 78 => 0x2, 79 => 0x1, 269 => 0x49, 343 => 0x2b, 344 => 0x25, 345 => 0x25, 355 => 0x2008, 359 => 0x11, 379 => 0x44 },
	'longexposurenoisereduction2' => { 49 => 0x8 },
	'loop' => { 423 => 'loop' },
	'lowestbiostratigraphiczone' => { 104 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 398 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 398 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 398 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 398 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 398 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 398 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 398 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 398 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 96 => 0x150 },
	'luminancecurvepoints' => { 96 => 0x126 },
	'luminancenoisereduction' => { 91 => 0x20600, 97 => 0x5f, 336 => 0x1b },
	'luminancenoisereductioncontrast' => { 398 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 398 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 97 => 0x6d },
	'luminancesmoothing' => { 398 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 73 => 0x40b },
	'lyrics' => { 423 => 'lyrics' },
	'm16cversion' => { 265 => 0x333 },
	'macatom' => { 397 => 'macAtom' },
	'macatomapplicationcode' => { 397 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 397 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 397 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 110 => 0x1020, 111 => 0x202, 254 => 0x202, 326 => 0x21, 335 => 0x202, 355 => 0xb040 },
	'macroled' => { 252 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 49 => 0x10 },
	'macromode' => { 31 => 0x1, 157 => 0xb, 249 => 0x300, 269 => 0x1c, 327 => 0x1009 },
	'magentahsl' => { 91 => 0x20917 },
	'magicfilter' => { 249 => 0x52c },
	'magnifiedview' => { 75 => 0x11, 77 => 0x9 },
	'maindialexposurecomp' => { 244 => '0.6' },
	'mainingredient' => { 415 => 'mainIngredient' },
	'make' => { 87 => 0x0, 105 => 0x10f, 135 => 'Make', 261 => 'Make', 273 => 0x10f, 412 => 'make', 419 => 'Make' },
	'makernote' => { 402 => 'MakerNote' },
	'makernoteapple' => { 103 => 'MakN', 105 => 0x927c },
	'makernotecanon' => { 103 => 'MakN', 105 => 0x927c },
	'makernotecasio' => { 103 => 'MakN', 105 => 0x927c },
	'makernotecasio2' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteflir' => { 103 => 'MakN', 105 => 0x927c },
	'makernotefujifilm' => { 103 => 'MakN', 105 => 0x927c },
	'makernotege' => { 103 => 'MakN', 105 => 0x927c },
	'makernotege2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotehasselblad' => { 103 => 'MakN', 105 => 0x927c },
	'makernotehp' => { 103 => 'MakN', 105 => 0x927c },
	'makernotehp2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotehp4' => { 103 => 'MakN', 105 => 0x927c },
	'makernotehp6' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteisl' => { 103 => 'MakN', 105 => 0x927c },
	'makernotejvc' => { 103 => 'MakN', 105 => 0x927c },
	'makernotejvctext' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak10' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak11' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak1a' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak1b' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak3' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak4' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak5' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak6a' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak6b' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak7' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak8a' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak8b' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak8c' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodak9' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekodakunknown' => { 103 => 'MakN', 105 => 0x927c },
	'makernotekyocera' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteleica' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteleica2' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteleica3' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteleica4' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteleica5' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteleica6' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteleica7' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteleica8' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteleica9' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteminolta' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteminolta2' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteminolta3' => { 103 => 'MakN', 105 => 0x927c },
	'makernotemotorola' => { 103 => 'MakN', 105 => 0x927c },
	'makernotenikon' => { 103 => 'MakN', 105 => 0x927c },
	'makernotenikon2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotenikon3' => { 103 => 'MakN', 105 => 0x927c },
	'makernotenintendo' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteoffset' => { 335 => 0xff },
	'makernoteolympus' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteolympus2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotepanasonic' => { 103 => 'MakN', 105 => 0x927c },
	'makernotepanasonic2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotepentax' => { 103 => 'MakN', 105 => 0x927c },
	'makernotepentax2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotepentax3' => { 103 => 'MakN', 105 => 0x927c },
	'makernotepentax4' => { 103 => 'MakN', 105 => 0x927c },
	'makernotepentax5' => { 103 => 'MakN', 105 => 0x927c },
	'makernotepentax6' => { 103 => 'MakN', 105 => 0x927c },
	'makernotephaseone' => { 103 => 'MakN', 105 => 0x927c },
	'makernotereconyx' => { 103 => 'MakN', 105 => 0x927c },
	'makernotericoh' => { 103 => 'MakN', 105 => 0x927c },
	'makernotericoh2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotericohtext' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesafety' => { 105 => 0xc635 },
	'makernotesamsung1a' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesamsung1b' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesamsung2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesanyo' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesanyoc4' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesanyopatch' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesigma' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesony' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesony2' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesony3' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesony4' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesony5' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesonyericsson' => { 103 => 'MakN', 105 => 0x927c },
	'makernotesonysrf' => { 103 => 'MakN', 105 => 0x927c },
	'makernotetype' => { 327 => 0x1 },
	'makernoteunknown' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteunknownbinary' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteunknowntext' => { 103 => 'MakN', 105 => 0x927c },
	'makernoteversion' => { 162 => 0x0, 193 => 0x1, 254 => 0x0, 269 => 0x8000, 331 => 0x0, 333 => 0x1, 336 => [0x1d,0x1f], 346 => 0x2000 },
	'managedfrom' => { 424 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 424 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 424 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 424 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 424 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 424 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 424 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 424 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 424 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 424 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 424 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 424 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 424 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 424 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 424 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 424 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 424 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 424 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 424 => 'Manager' },
	'managervariant' => { 424 => 'ManagerVariant' },
	'manageto' => { 424 => 'ManageTo' },
	'manageui' => { 424 => 'ManageUI' },
	'manifest' => { 424 => 'Manifest' },
	'manifestlinkform' => { 424 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 424 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 424 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 424 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 424 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 424 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 424 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 424 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 424 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 424 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 424 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 424 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 424 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 424 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 424 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 424 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 424 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 424 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 424 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 424 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 424 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 424 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 249 => 0x900, 269 => 0x86 },
	'manometerreading' => { 249 => 0x901 },
	'manualafpointselectpattern' => { 73 => 0x513 },
	'manualflash' => { 252 => 0x1209 },
	'manualflashoutput' => { 31 => 0x29, 238 => '8.2', 239 => '22.2', 240 => '23.1', 241 => '23.2', 242 => '16.2', 243 => '23.2', 244 => '8.2', 245 => '23.2', 247 => '24.2', 327 => 0x100c },
	'manualflashstrength' => { 249 => 0x406 },
	'manualfocusdistance' => { 193 => 0x85, 254 => 0x100c, 335 => 0x223 },
	'manualtv' => { 72 => 0x5, 73 => 0x705 },
	'manufacturedate' => { 167 => 0x6705, 282 => 0x1 },
	'manufacturedate1' => { 329 => 0x4 },
	'manufacturedate2' => { 329 => 0x5 },
	'manufacturer' => { 412 => 'manufacturer' },
	'marked' => { 409 => 'Marked', 427 => 'Marked' },
	'markers' => { 423 => 'markers' },
	'markerscomment' => { 423 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 423 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 423 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 423 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 423 => [\'markers','markersCuePointType'] },
	'markersduration' => { 423 => [\'markers','markersDuration'] },
	'markerslocation' => { 423 => [\'markers','markersLocation'] },
	'markersname' => { 423 => [\'markers','markersName'] },
	'markersprobability' => { 423 => [\'markers','markersProbability'] },
	'markersspeaker' => { 423 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 423 => [\'markers','markersStartTime'] },
	'markerstarget' => { 423 => [\'markers','markersTarget'] },
	'markerstype' => { 423 => [\'markers','markersType'] },
	'maskedareas' => { 105 => 0xc68e },
	'masterdocumentid' => { 113 => 0xb9 },
	'mastergain' => { 199 => 0x50 },
	'matrixmetering' => { 237 => '50.1', 246 => '48.1' },
	'maxaperture' => { 31 => 0x1a, 125 => 0x6103, 142 => 'MaxAperture', 157 => 0x17, 163 => 0x49c5, 250 => 0x20a, 293 => '14.1', 370 => 0x0 },
	'maxapertureatmaxfocal' => { 110 => 0x1407, 142 => 'MaxApertureAtMaxFocal', 188 => 0xb, 189 => 0x10, 190 => 0x11, 250 => 0x206 },
	'maxapertureatminfocal' => { 110 => 0x1406, 188 => 0xa, 189 => 0xf, 190 => 0x10, 250 => 0x205 },
	'maxaperturevalue' => { 105 => 0x9205, 311 => 0x414, 402 => 'MaxApertureValue' },
	'maxavailheight' => { 408 => 'MaxAvailHeight' },
	'maxavailwidth' => { 408 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 236 => 0xb, 237 => 0xc, 242 => 0xc, 243 => 0xb, 246 => '12.1' },
	'maxfaces' => { 253 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 31 => 0x17, 110 => 0x1405, 142 => 'MaxFocalLength', 188 => 0x9, 189 => 0xe, 190 => 0xf, 250 => 0x208, 366 => 0x127c, 367 => 0x1138, 368 => 0x330, 369 => 0x330 },
	'maximumdensityrange' => { 115 => 0x8c },
	'maxpagesize' => { 428 => 'MaxPageSize' },
	'maxpagesizeh' => { 428 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 428 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 428 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 105 => 0x119 },
	'maxstorage' => { 418 => 'maxstorage' },
	'mb-d10batteries' => { 236 => '12.6' },
	'mb-d10batterytype' => { 242 => '13.3' },
	'mb-d11batterytype' => { 243 => '2.3' },
	'mb-d12batterytype' => { 246 => '3.2' },
	'mb-d80batteries' => { 244 => '6.5' },
	'mb-d80batterytype' => { 247 => '3.2' },
	'mcuversion' => { 188 => 0xc, 189 => 0x11, 190 => 0x12 },
	'md5digest' => { 143 => 'zmd5' },
	'meal' => { 415 => 'meal' },
	'measuredev' => { 26 => 0x9, 67 => 0x3, 86 => 0x1814, 135 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 67 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 163 => 0x690, 265 => 0x312, 271 => 0x3407 },
	'measuredrggb' => { 56 => 0x1 },
	'measuredrggbdata' => { 37 => 0x287 },
	'measurementaccuracy' => { 104 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 104 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 104 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 104 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 104 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 104 => 'MeasurementOrFact' },
	'measurementremarks' => { 104 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 104 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 104 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 104 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 411 => 'MediaConstraints' },
	'mediacreatedate' => { 319 => 0x1 },
	'mediamodifydate' => { 319 => 0x2 },
	'mediasummarycode' => { 411 => 'MediaSummaryCode' },
	'memoaudioquality' => { 73 => 0x812 },
	'memorycardconfiguration' => { 349 => 0x16 },
	'menubuttondisplayposition' => { 71 => 0xb, 74 => 0xa, 75 => 0xb, 78 => 0xb },
	'menubuttonreturn' => { 79 => 0xb },
	'menumonitorofftime' => { 236 => '26.1', 237 => '22.1', 242 => '8.2', 243 => '21.1', 246 => '22.1', 247 => '22.1' },
	'metadatadate' => { 421 => 'MetadataDate' },
	'metadatamoddate' => { 423 => 'metadataModDate' },
	'metaversion' => { 361 => 0x34 },
	'meterinfo1row1' => { 356 => 0x0 },
	'meterinfo1row2' => { 356 => 0x6c },
	'meterinfo1row3' => { 356 => 0xd8 },
	'meterinfo1row4' => { 356 => 0x144 },
	'meterinfo1row5' => { 356 => 0x1b0 },
	'meterinfo1row6' => { 356 => 0x21c },
	'meterinfo1row7' => { 356 => 0x288 },
	'meterinfo2row1' => { 356 => 0x2f4 },
	'meterinfo2row2' => { 356 => 0x378 },
	'meterinfo2row3' => { 356 => 0x3fc },
	'meterinfo2row4' => { 356 => 0x480 },
	'meterinfo2row5' => { 356 => 0x504 },
	'meterinfo2row6' => { 356 => 0x588 },
	'meterinfo2row7' => { 356 => 0x60c },
	'meterinfo2row8' => { 356 => 0x690 },
	'meterinfo2row9' => { 356 => 0x714 },
	'metering' => { 238 => '6.1' },
	'meteringmode' => { 31 => 0x11, 105 => 0x9207, 121 => 0x1c, 157 => 0x7, 158 => 0x25, 160 => 0x12, 249 => 0x202, 302 => 0x17, 336 => 0x9, 343 => 0x15, 344 => 0x13, 345 => 0x7, 359 => 0x3, 362 => 0x1174, 363 => 0x1178, 364 => 0x1154, 365 => 0x11d0, 366 => 0x11ac, 367 => 0x1064, 368 => 0x25c, 369 => 0x25c, 402 => 'MeteringMode' },
	'meteringmode2' => { 283 => '2.1' },
	'meteringmode3' => { 283 => '16.1' },
	'meteringoffscaleindicator' => { 160 => 0x53 },
	'meteringtime' => { 236 => '22.2', 238 => '3.2', 239 => '17.1', 240 => '18.1', 242 => '7.3', 243 => '18.1', 244 => '3.2', 247 => '19.1' },
	'mieversion' => { 143 => '0Vers' },
	'minaperture' => { 31 => 0x1b, 142 => 'MinAperture', 293 => '0.2', 370 => 0x1 },
	'minaperturevalue' => { 311 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 31 => 0x18, 110 => 0x1404, 142 => 'MinFocalLength', 188 => 0x8, 189 => 0xd, 190 => 0xe, 250 => 0x207, 366 => 0x127a, 367 => 0x1136, 368 => 0x32e, 369 => 0x32e },
	'minfocusdistance' => { 293 => 0x3 },
	'minoltadate' => { 157 => 0x15 },
	'minoltaimagesize' => { 157 => 0x4, 158 => 0xc, 159 => 0x2, 162 => 0x103 },
	'minoltamodelid' => { 157 => 0x25 },
	'minoltaquality' => { 157 => 0x5, 158 => 0xd, 159 => 0x3, 162 => [0x102,0x103] },
	'minoltatime' => { 157 => 0x16 },
	'minormodelagedisclosure' => { 411 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 105 => 0x118 },
	'mirrorlockup' => { 71 => 0xc, 72 => 0xc, 73 => 0x60f, 74 => 0xb, 75 => 0xc, 76 => 0x6, 77 => 0x6, 78 => 0xc, 79 => 0x3 },
	'mobilecountrycode' => { 396 => 'mcc' },
	'mobilenetworkcode' => { 396 => 'mnc' },
	'moddate' => { 261 => 'modify-date', 409 => 'ModDate' },
	'modedialposition' => { 349 => 0x14 },
	'model' => { 87 => 0x6, 105 => 0x110, 135 => 'Model', 261 => 'Model', 273 => 0x110, 412 => 'model', 419 => 'Model' },
	'modelage' => { 408 => 'ModelAge' },
	'modelid' => { 248 => 0x0 },
	'modelingflash' => { 236 => '21.4', 237 => '31.1', 242 => '26.4', 243 => '30.2', 244 => '7.4', 245 => '30.1', 246 => '31.1', 247 => '31.3' },
	'modelreleaseid' => { 411 => 'ModelReleaseID' },
	'modelreleasestatus' => { 411 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 371 => 0x52, 372 => 0x46, 373 => 0x53 },
	'modelyear' => { 412 => 'modelYear' },
	'modificationdate' => { 413 => 'modificationDate' },
	'modifiedcolortemp' => { 57 => 0x9 },
	'modifieddigitalgain' => { 57 => 0xb },
	'modifiedparamflag' => { 50 => 0x1 },
	'modifiedpicturestyle' => { 57 => 0xa },
	'modifiedsaturation' => { 249 => 0x504 },
	'modifiedsensorbluelevel' => { 57 => 0x5 },
	'modifiedsensorredlevel' => { 57 => 0x4 },
	'modifiedsharpness' => { 57 => 0x2 },
	'modifiedsharpnessfreq' => { 57 => 0x3 },
	'modifiedtonecurve' => { 57 => 0x1 },
	'modifiedwhitebalance' => { 57 => 0x8 },
	'modifiedwhitebalanceblue' => { 57 => 0x7 },
	'modifiedwhitebalancered' => { 57 => 0x6 },
	'modifydate' => { 105 => 0x132, 136 => 'ModifyDate', 258 => 'ModDate', 259 => 'tIME', 318 => 'ModDate', 320 => 0x2, 421 => 'ModifyDate' },
	'moirefilter' => { 105 => 0xfe58, 398 => 'MoireFilter' },
	'monitordisplayoff' => { 160 => 0x4c },
	'monitorofftime' => { 236 => '18.2', 238 => '3.1', 244 => '3.1' },
	'monochromecontrast' => { 97 => 0x3c },
	'monochromefiltereffect' => { 91 => 0x20307, 97 => 0x3a, 302 => 0x73 },
	'monochromelinear' => { 97 => 0x3d },
	'monochromeoutputhighlightpoint' => { 97 => 0x41 },
	'monochromeoutputshadowpoint' => { 97 => 0x42 },
	'monochromerawhighlight' => { 97 => 0x7a },
	'monochromerawhighlightpoint' => { 97 => 0x3f },
	'monochromerawshadow' => { 97 => 0x83 },
	'monochromerawshadowpoint' => { 97 => 0x40 },
	'monochromesharpness' => { 97 => 0x3e },
	'monochrometoning' => { 302 => 0x74 },
	'monochrometoningeffect' => { 91 => 0x20306, 97 => 0x3b },
	'monochromeunsharpmaskfineness' => { 97 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 97 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 97 => 0xb4 },
	'monthdaycreated' => { 121 => 0x12, 130 => 0xe },
	'moonphase' => { 323 => 0x12 },
	'morepermissions' => { 395 => 'morePermissions' },
	'motionsensitivity' => { 323 => 0x29 },
	'movieaelockbuttonassignment' => { 246 => '40.1' },
	'moviefunctionbutton' => { 237 => '41.1', 246 => '41.1' },
	'moviefunctionbuttonplusdials' => { 237 => '52.1' },
	'moviepreviewbutton' => { 237 => '41.2', 246 => '41.2' },
	'moviepreviewbuttonplusdials' => { 237 => '52.2' },
	'movieshutterbutton' => { 237 => '38.3', 246 => '38.3' },
	'moviesubselectorassignment' => { 237 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 237 => '53.1' },
	'multiburstimageheight' => { 355 => 0x1002 },
	'multiburstimagewidth' => { 355 => 0x1001 },
	'multiburstmode' => { 355 => 0x1000 },
	'multicontrollerwhilemetering' => { 73 => 0x517 },
	'multiexposure' => { 59 => 0x1 },
	'multiexposureautogain' => { 194 => 0x3 },
	'multiexposurecontrol' => { 59 => 0x2 },
	'multiexposuremode' => { 194 => 0x1 },
	'multiexposureshots' => { 59 => 0x3, 194 => 0x2 },
	'multiframenoisereduction' => { 345 => 0x35, 355 => 0x200b, 359 => 0x15 },
	'multifunctionlock' => { 73 => 0x70f },
	'multipleexposuremode' => { 253 => 0x101c },
	'multipleexposureset' => { 283 => '10.1' },
	'multisample' => { 199 => 0x40 },
	'multiselector' => { 236 => '9.4', 237 => '10.3', 242 => '27.4', 246 => '10.3' },
	'multiselectorliveview' => { 236 => '4.3', 246 => '37.1' },
	'multiselectorliveviewmode' => { 209 => 0x18c2 },
	'multiselectorplaybackmode' => { 236 => ['13.5','9.2'], 237 => '10.2', 242 => '27.2', 246 => '10.2' },
	'multiselectorshootmode' => { 236 => '9.1', 237 => '10.1', 242 => '27.1', 246 => '10.1' },
	'mycolormode' => { 60 => 0x2 },
	'nationalcatalognumber' => { 413 => 'nationalCatalogNumber' },
	'nativedigest' => { 402 => 'NativeDigest', 419 => 'NativeDigest' },
	'ncdfileinfo' => { 119 => 0x414 },
	'ndfilter' => { 67 => 0x1c, 249 => 0x204, 327 => 0x1019 },
	'nefbitdepth' => { 193 => 0xe22 },
	'nefcompression' => { 193 => 0x93 },
	'neflinearizationtable' => { 193 => 0x96 },
	'neutraldensityfilter' => { 302 => 0x88 },
	'neutraloutputhighlightpoint' => { 97 => 0x2f },
	'neutraloutputshadowpoint' => { 97 => 0x30 },
	'neutralrawcolortone' => { 97 => 0x28 },
	'neutralrawcontrast' => { 97 => 0x2a },
	'neutralrawhighlight' => { 97 => 0x78 },
	'neutralrawhighlightpoint' => { 97 => 0x2d },
	'neutralrawlinear' => { 97 => 0x2b },
	'neutralrawsaturation' => { 97 => 0x29 },
	'neutralrawshadow' => { 97 => 0x81 },
	'neutralrawshadowpoint' => { 97 => 0x2e },
	'neutralrawsharpness' => { 97 => 0x2c },
	'neutralunsharpmaskfineness' => { 97 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 97 => 0xa8 },
	'neutraunsharpmaskstrength' => { 97 => 0xa4 },
	'newrawimagedigest' => { 105 => 0xc7a7 },
	'newsphotoversion' => { 115 => 0x0 },
	'nickname' => { 421 => 'Nickname' },
	'nikoncapturedata' => { 193 => 0xe01 },
	'nikoncaptureeditversions' => { 193 => 0xe13 },
	'nikoncaptureoutput' => { 193 => 0xe1e },
	'nikoncaptureversion' => { 193 => 0xe09 },
	'nikoniccprofile' => { 193 => 0xe1d },
	'nikonimagesize' => { 206 => '723.1', 207 => '732.1', 215 => 0x2c4 },
	'noisefilter' => { 249 => 0x527 },
	'noiseprofile' => { 105 => 0xc761 },
	'noisereduction' => { 110 => 0x100b, 158 => 0xb0, 159 => 0x60, 160 => 0x3f, 193 => 0x95, 229 => 0x753dcbc0, 230 => 0x17, 249 => 0x50a, 254 => 0x103a, 269 => 0x2d, 302 => 0x49, 327 => 0x100f, 329 => 0x2a },
	'noisereduction2' => { 253 => 0x1010 },
	'noisereductionapplied' => { 105 => 0xc6f7 },
	'noisereductionintensity' => { 230 => 0x9 },
	'noisereductionmethod' => { 230 => 0x11 },
	'noisereductionmode' => { 383 => 0x801e },
	'noisereductionsharpness' => { 230 => 0xd },
	'noisereductionvalue' => { 383 => 0x8027 },
	'nomemorycard' => { 236 => '22.1', 237 => '4.2', 238 => '0.3', 239 => '2.4', 240 => '3.2', 241 => '3.2', 242 => '33.7', 243 => '3.2', 244 => '0.3', 246 => '4.2', 247 => '4.5' },
	'nominalmaxaperture' => { 293 => 0xa },
	'nominalminaperture' => { 293 => '10.1' },
	'normalwhitelevel' => { 38 => [0x2b8,0x2cf,0x2d3], 40 => 0x1e3, 41 => [0x1fc,0x2dc], 42 => 0x30e },
	'notes' => { 384 => 'Notes', 392 => 'notes' },
	'npages' => { 428 => 'NPages' },
	'nrwdata' => { 193 => 0x14 },
	'nullrecord' => { 86 => 0x0 },
	'number' => { 413 => 'number' },
	'numberofbeats' => { 423 => 'numberOfBeats' },
	'numberoffocuspoints' => { 241 => '0.2', 243 => '0.3' },
	'numfacepositions' => { 263 => 0x0 },
	'numindexentries' => { 115 => 0x54 },
	'numwbentries' => { 274 => 0x0, 275 => 0x0 },
	'object' => { 413 => 'object' },
	'objectattributereference' => { 113 => 0x4 },
	'objectcycle' => { 113 => 0x4b },
	'objectdescription' => { 412 => 'objectDescription' },
	'objectdistance' => { 100 => 0x6, 101 => 0x2022 },
	'objectname' => { 113 => 0x5 },
	'objectpreviewdata' => { 113 => 0xca },
	'objectpreviewfileformat' => { 113 => 0xc8 },
	'objectpreviewfileversion' => { 113 => 0xc9 },
	'objectsubtype' => { 412 => 'objectSubtype' },
	'objecttype' => { 412 => 'objectType' },
	'objecttypereference' => { 113 => 0x3 },
	'occurrence' => { 104 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 104 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 104 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 104 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 104 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 104 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 104 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 104 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 104 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 104 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 104 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 104 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 104 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 104 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 104 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 104 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 104 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 104 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 104 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 104 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 104 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 104 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 104 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 104 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 402 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 402 => [\'OECF','OECFNames'] },
	'oecfrows' => { 402 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 402 => [\'OECF','OECFValues'] },
	'offsaledate' => { 413 => 'offSaleDate' },
	'offsaledatea-platform' => { 413 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 413 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 105 => 0xea1d },
	'okbutton' => { 243 => '15.1', 247 => '16.1' },
	'oldsubfiletype' => { 105 => 0xff },
	'olympusimageheight' => { 254 => 0x102f },
	'olympusimagewidth' => { 254 => 0x102e },
	'onetouchwb' => { 254 => 0x302 },
	'onsaledate' => { 413 => 'onSaleDate' },
	'onsaledatea-platform' => { 413 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 413 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 413 => 'onSaleDay' },
	'onsaledaya-platform' => { 413 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 413 => [\'onSaleDay','onSaleDayDay'] },
	'opticalzoom' => { 123 => 0xfa3d, 125 => [0x6006,0xf006], 126 => 0x1000, 127 => 0xf, 130 => 0x1e, 142 => 'OpticalZoom' },
	'opticalzoomcode' => { 67 => 0xa },
	'opticalzoommode' => { 269 => 0x34 },
	'opticalzoomon' => { 335 => 0x219 },
	'optionenddate' => { 416 => 'optionEndDate' },
	'opto-electricconvfactor' => { 402 => 'OECF' },
	'orangehsl' => { 91 => 0x20911 },
	'ordernumber' => { 110 => 0x8002 },
	'organisationinimagecode' => { 408 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 408 => 'OrganisationInImageName' },
	'organization' => { 413 => 'organization' },
	'orientation' => { 105 => 0x112, 273 => 0x112, 412 => 'orientation', 419 => 'Orientation' },
	'orientation2' => { 359 => [0x28,0x2e] },
	'orientationlinkedafpoint' => { 73 => 0x516 },
	'originalbestqualitysize' => { 105 => 0xc792 },
	'originaldecisiondata' => { 102 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 55 => 0x83 },
	'originaldefaultcropsize' => { 105 => 0xc793 },
	'originaldefaultfinalsize' => { 105 => 0xc791 },
	'originaldirectory' => { 267 => 0x408 },
	'originaldocumentid' => { 424 => 'OriginalDocumentID' },
	'originalfilename' => { 86 => 0x816, 119 => 0x3e9, 131 => 0x20, 267 => 0x407, 388 => 'OriginalFilename' },
	'originalimageheight' => { 69 => 0xc, 109 => 0x1 },
	'originalimagewidth' => { 69 => 0xb, 109 => 0x0 },
	'originalrawfiledata' => { 105 => 0xc68c },
	'originalrawfiledigest' => { 105 => 0xc71d },
	'originalrawfilename' => { 105 => 0xc68b },
	'originaltransmissionreference' => { 113 => 0x67 },
	'originatingprogram' => { 113 => 0x41 },
	'originplatform' => { 413 => 'originPlatform' },
	'os' => { 400 => 'os' },
	'otherconditions' => { 411 => 'OtherConditions' },
	'otherconstraints' => { 411 => 'OtherConstraints' },
	'otherimage' => { 102 => 'OtherImage' },
	'otherimageinfo' => { 411 => 'OtherImageInfo' },
	'otherimagelength' => { 105 => 0x202 },
	'otherimagestart' => { 105 => 0x201 },
	'otherlicensedocuments' => { 411 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 411 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 411 => 'OtherLicenseRequirements' },
	'outcue' => { 423 => 'outCue' },
	'outcuescale' => { 423 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 423 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 172 => 0x3 },
	'outputimagewidth' => { 172 => 0x2 },
	'outputprofile' => { 119 => 0x138b },
	'outputresolution' => { 172 => 0x4 },
	'owner' => { 427 => 'Owner' },
	'ownerid' => { 113 => 0xbc },
	'ownername' => { 14 => 0x10f, 55 => 0x9, 86 => 0x810, 105 => [0xa430,0xfde8], 135 => 'OwnerName', 394 => 'OwnerName', 403 => 'CameraOwnerName' },
	'padding' => { 105 => 0xea1c },
	'pagecount' => { 413 => 'pageCount' },
	'pageimage' => { 421 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 421 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 421 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 421 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 421 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 421 => 'PageInfo' },
	'pagename' => { 105 => 0x11d },
	'pagenumber' => { 105 => 0x129 },
	'pageprogressiondirection' => { 413 => 'pageProgressionDirection' },
	'pagerange' => { 413 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 398 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 398 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 269 => 0x26 },
	'panasonicimageheight' => { 269 => 0x4c },
	'panasonicimagewidth' => { 269 => 0x4b },
	'panasonicrawversion' => { 273 => 0x1 },
	'panasonictitle' => { 105 => 0xc6d2 },
	'panasonictitle2' => { 105 => 0xc6d3 },
	'panoramacropbottom' => { 360 => 0x7 },
	'panoramacropleft' => { 360 => 0x4 },
	'panoramacropright' => { 360 => 0x6 },
	'panoramacroptop' => { 360 => 0x5 },
	'panoramadirection' => { 63 => 0x5, 360 => 0x3 },
	'panoramaframeheight' => { 360 => 0x9 },
	'panoramaframenumber' => { 63 => 0x2 },
	'panoramaframewidth' => { 360 => 0x8 },
	'panoramafullheight' => { 360 => 0x2 },
	'panoramafullwidth' => { 360 => 0x1 },
	'panoramamode' => { 121 => 0x3c, 249 => 0x601 },
	'panoramasize3d' => { 345 => 0x38 },
	'panoramasourceheight' => { 360 => 0xb },
	'panoramasourcewidth' => { 360 => 0xa },
	'panoramicstitchcameramotion' => { 153 => 'PanoramicStitchCameraMotion', 154 => 0x1 },
	'panoramicstitchmaptype' => { 153 => 'PanoramicStitchMapType', 154 => 0x2 },
	'panoramicstitchphi0' => { 153 => 'PanoramicStitchPhi0', 154 => 0x5 },
	'panoramicstitchphi1' => { 153 => 'PanoramicStitchPhi1', 154 => 0x6 },
	'panoramicstitchtheta0' => { 153 => 'PanoramicStitchTheta0', 154 => 0x3 },
	'panoramicstitchtheta1' => { 153 => 'PanoramicStitchTheta1', 154 => 0x4 },
	'panoramicstitchversion' => { 154 => 0x0 },
	'pantry' => { 424 => 'Pantry' },
	'parallax' => { 110 => 0xb211, 248 => 0x28 },
	'parametricdarks' => { 398 => 'ParametricDarks' },
	'parametrichighlights' => { 398 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 398 => 'ParametricHighlightSplit' },
	'parametriclights' => { 398 => 'ParametricLights' },
	'parametricmidtonesplit' => { 398 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 398 => 'ParametricShadows' },
	'parametricshadowsplit' => { 398 => 'ParametricShadowSplit' },
	'parentmeid' => { 388 => 'ParentMEID' },
	'parentreference1' => { 406 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 406 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 423 => 'partOfCompilation' },
	'patientbirthdate' => { 385 => 'PatientDOB' },
	'patientid' => { 385 => 'PatientID' },
	'patientname' => { 385 => 'PatientName' },
	'patientsex' => { 385 => 'PatientSex' },
	'pdfversion' => { 409 => 'PDFVersion' },
	'pentaximagesize' => { 302 => 0x9 },
	'pentaxmodelid' => { 282 => 0x0, 302 => 0x5 },
	'pentaxmodeltype' => { 302 => 0x1 },
	'pentaxversion' => { 302 => 0x0 },
	'people' => { 386 => 'People', 390 => 'People' },
	'perchannelblacklevel' => { 37 => 0xc4, 38 => [0x2b4,0x2cb,0x2cf], 39 => 0x108, 40 => 0x1df, 41 => [0x1f8,0x2d8], 42 => 0x30a },
	'peripheralillumcentralradius' => { 383 => 0x8030 },
	'peripheralillumcentralvalue' => { 383 => 0x8031 },
	'peripheralillumination' => { 91 => 0x20702, 97 => 0x68 },
	'peripheralilluminationcorr' => { 54 => 0x1, 292 => 0x2 },
	'peripheralilluminationon' => { 91 => '0x20702.0', 97 => 0x64 },
	'peripheralillumperiphvalue' => { 383 => 0x8032 },
	'peripherallighting' => { 69 => 0x2 },
	'peripherallightingsetting' => { 70 => 0x5 },
	'peripherallightingvalue' => { 69 => 0x6 },
	'permissions' => { 416 => 'permissions' },
	'permits' => { 395 => 'permits' },
	'person' => { 413 => 'person' },
	'personality' => { 388 => 'Personality' },
	'personinimage' => { 408 => 'PersonInImage' },
	'personinimagecharacteristic' => { 408 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 408 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 408 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 408 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 408 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 408 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 408 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 408 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 408 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 398 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 398 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 398 => 'PerspectiveRotate' },
	'perspectivescale' => { 398 => 'PerspectiveScale' },
	'perspectiveupright' => { 398 => 'PerspectiveUpright' },
	'perspectivevertical' => { 398 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 81 => 0x1 },
	'pf10retainprogramshift' => { 81 => 0xb },
	'pf13drivepriority' => { 81 => 0xe },
	'pf14disablefocussearch' => { 81 => 0xf },
	'pf15disableafassistbeam' => { 81 => 0x10 },
	'pf16autofocuspointshoot' => { 81 => 0x11 },
	'pf17disableafpointsel' => { 81 => 0x12 },
	'pf18enableautoafpointsel' => { 81 => 0x13 },
	'pf19continuousshootspeed' => { 81 => 0x14 },
	'pf19shootingspeedhigh' => { 80 => 0xa },
	'pf19shootingspeedlow' => { 80 => 0x9 },
	'pf1disableshootingmodes' => { 81 => 0x2 },
	'pf1value' => { 80 => 0x1 },
	'pf20limitcontinousshots' => { 81 => 0x15 },
	'pf20maxcontinousshots' => { 80 => 0xb },
	'pf21enablequietoperation' => { 81 => 0x16 },
	'pf23felocktime' => { 80 => 0xd },
	'pf23postreleasetime' => { 80 => 0xe },
	'pf23settimerlengths' => { 81 => 0x18 },
	'pf23shutterbuttontime' => { 80 => 0xc },
	'pf24lightlcdduringbulb' => { 81 => 0x19 },
	'pf25aemode' => { 80 => 0xf },
	'pf25afmode' => { 80 => 0x12 },
	'pf25afpointsel' => { 80 => 0x13 },
	'pf25colormatrix' => { 80 => 0x17 },
	'pf25defaultclearsettings' => { 81 => 0x1a },
	'pf25drivemode' => { 80 => 0x11 },
	'pf25imagesize' => { 80 => 0x14 },
	'pf25meteringmode' => { 80 => 0x10 },
	'pf25parameters' => { 80 => 0x16 },
	'pf25wbmode' => { 80 => 0x15 },
	'pf26shortenreleaselag' => { 81 => 0x1b },
	'pf27reversedialrotation' => { 81 => 0x1c },
	'pf27value' => { 80 => 0x18 },
	'pf28noquickdialexpcomp' => { 81 => 0x1d },
	'pf29quickdialswitchoff' => { 81 => 0x1e },
	'pf2disablemeteringmodes' => { 81 => 0x3 },
	'pf2value' => { 80 => 0x2 },
	'pf30enlargementmode' => { 81 => 0x1f },
	'pf31originaldecisiondata' => { 81 => 0x20 },
	'pf3manualexposuremetering' => { 81 => 0x4 },
	'pf3value' => { 80 => 0x3 },
	'pf4exposuretimelimits' => { 81 => 0x5 },
	'pf4exposuretimemax' => { 80 => 0x5 },
	'pf4exposuretimemin' => { 80 => 0x4 },
	'pf5aperturelimits' => { 81 => 0x6 },
	'pf5aperturemax' => { 80 => 0x7 },
	'pf5aperturemin' => { 80 => 0x6 },
	'pf6presetshootingmodes' => { 81 => 0x7 },
	'pf7bracketcontinuousshoot' => { 81 => 0x8 },
	'pf8bracketshots' => { 80 => 0x8 },
	'pf8setbracketshots' => { 81 => 0x9 },
	'pf9changebracketsequence' => { 81 => 0xa },
	'phasedetectaf' => { 169 => 0x6 },
	'phonenumber' => { 136 => 'Phone' },
	'photoeffect' => { 31 => 0x28 },
	'photoeffecthistoryxml' => { 229 => 0xe9651831 },
	'photoeffects' => { 229 => 0xab5eca5e },
	'photoeffectsblue' => { 231 => 0x8 },
	'photoeffectsgreen' => { 231 => 0x6 },
	'photoeffectsred' => { 231 => 0x4 },
	'photoeffectstype' => { 231 => 0x0 },
	'photographicsensitivity' => { 403 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 236 => '17.6', 242 => '33.6' },
	'photometricinterpretation' => { 105 => 0x106, 419 => 'PhotometricInterpretation' },
	'photoshopbgrthumbnail' => { 316 => 0x409 },
	'photoshopquality' => { 315 => 0x0 },
	'photoshopthumbnail' => { 316 => 0x40c },
	'photostyle' => { 269 => 0x89 },
	'picklabel' => { 401 => 'PickLabel' },
	'pictinfo' => { 335 => 0x208 },
	'picturecontrol' => { 229 => 0xe2173c47 },
	'picturecontrolactive' => { 232 => 0x0 },
	'picturecontroladjust' => { 195 => 0x30 },
	'picturecontrolbase' => { 195 => 0x18 },
	'picturecontroldata' => { 193 => [0xbd,0x23] },
	'picturecontrolmode' => { 232 => 0x13 },
	'picturecontrolname' => { 195 => 0x4 },
	'picturecontrolquickadjust' => { 195 => 0x31 },
	'pictureeffect' => { 355 => 0x200e },
	'pictureeffect2' => { 362 => 0x1163, 363 => 0x1167, 364 => 0x1143, 365 => 0x11bf, 366 => 0x119b, 367 => 0x1053, 368 => 0x24b, 369 => 0x24b, 379 => 0x46 },
	'picturefinish' => { 158 => 0x71 },
	'picturemode' => { 110 => 0x1031, 249 => 0x520, 302 => [0xb,0x33], 336 => 0x3d },
	'picturemode2' => { 283 => 0x0 },
	'picturemodebwfilter' => { 249 => 0x525 },
	'picturemodecontrast' => { 249 => 0x523 },
	'picturemodeeffect' => { 249 => 0x52d },
	'picturemodehue' => { 249 => 0x522 },
	'picturemodesaturation' => { 249 => 0x521 },
	'picturemodesharpness' => { 249 => 0x524 },
	'picturemodetone' => { 249 => 0x526 },
	'pictureprofile' => { 362 => [0x115e,0x115f], 363 => [0x1162,0x1163], 364 => [0x113e,0x113f], 365 => [0x11ba,0x11bb], 366 => [0x1196,0x1197], 367 => [0x104e,0x104f], 368 => [0x246,0x247], 369 => [0x246,0x247] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 65 => 0xa, 91 => 0x20301, 97 => 0x2 },
	'picturewizard' => { 333 => 0x21 },
	'picturewizardcolor' => { 332 => 0x1 },
	'picturewizardcontrast' => { 332 => 0x4 },
	'picturewizardmode' => { 332 => 0x0 },
	'picturewizardsaturation' => { 332 => 0x2 },
	'picturewizardsharpness' => { 332 => 0x3 },
	'pipelineversion' => { 153 => 'PipelineVersion' },
	'pitch' => { 237 => '4.1', 246 => '4.1' },
	'pitchangle' => { 209 => 0x350f, 249 => 0x904, 269 => 0x91, 301 => 0x2 },
	'pixelshiftresolution' => { 303 => 0x0 },
	'pixelsperunitx' => { 260 => 0x0 },
	'pixelsperunity' => { 260 => 0x4 },
	'pixelunits' => { 260 => 0x8 },
	'planarconfiguration' => { 105 => 0x11c, 419 => 'PlanarConfiguration' },
	'platenames' => { 428 => 'PlateNames' },
	'platform' => { 413 => 'platform' },
	'playbackmenustime' => { 239 => '20.1', 240 => '21.1', 241 => '21.1' },
	'playbackmonitorofftime' => { 236 => '25.2', 237 => '36.1', 242 => '8.1', 243 => '35.1', 246 => '36.1', 247 => '21.1' },
	'playbackzoom' => { 237 => '37.1' },
	'playdisplay' => { 160 => 0x4e },
	'plusversion' => { 411 => 'Version' },
	'pmversion' => { 314 => 'PMVersion' },
	'pngwarning' => { 261 => 'Warning' },
	'poilevel' => { 192 => 0x8 },
	'portraitoutputhighlightpoint' => { 97 => 0x1d },
	'portraitoutputshadowpoint' => { 97 => 0x1e },
	'portraitrawcolortone' => { 97 => 0x16 },
	'portraitrawcontrast' => { 97 => 0x18 },
	'portraitrawhighlight' => { 97 => 0x76 },
	'portraitrawhighlightpoint' => { 97 => 0x1b },
	'portraitrawlinear' => { 97 => 0x19 },
	'portraitrawsaturation' => { 97 => 0x17 },
	'portraitrawshadow' => { 97 => 0x7f },
	'portraitrawshadowpoint' => { 97 => 0x1c },
	'portraitrawsharpness' => { 97 => 0x1a },
	'portraitrefiner' => { 101 => 0x302b },
	'portraitunsharpmaskfineness' => { 97 => 0x9a },
	'portraitunsharpmaskstrength' => { 97 => 0x98 },
	'portraitunsharpmaskthreshold' => { 97 => 0x9c },
	'poseheadingdegrees' => { 387 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 387 => 'PosePitchDegrees' },
	'poserolldegrees' => { 387 => 'PoseRollDegrees' },
	'positiondescriptor' => { 412 => 'positionDescriptor' },
	'postalcode' => { 140 => 'PostalCode' },
	'postcropvignetteamount' => { 398 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 398 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 398 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 398 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 398 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 398 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 353 => 0xb },
	'potentialface2position' => { 353 => 0x15 },
	'potentialface3position' => { 353 => 0x1f },
	'potentialface4position' => { 353 => 0x29 },
	'potentialface5position' => { 353 => 0x33 },
	'potentialface6position' => { 353 => 0x3d },
	'potentialface7position' => { 353 => 0x47 },
	'potentialface8position' => { 353 => 0x51 },
	'powersource' => { 281 => '0.1' },
	'poweruptime' => { 193 => 0xb6 },
	'precaptureframes' => { 254 => 0x300 },
	'predictor' => { 105 => 0x13d },
	'preflashreturnstrength' => { 207 => 0x28a },
	'prefs' => { 113 => 0xdd, 314 => 'Prefs' },
	'preservedfilename' => { 424 => 'PreservedFileName' },
	'presetwhitebalance' => { 160 => 0x24, 383 => 0x8002 },
	'presetwhitebalanceadj' => { 383 => 0x8014 },
	'previewapplicationname' => { 105 => 0xc716 },
	'previewapplicationversion' => { 105 => 0xc717 },
	'previewbutton' => { 236 => ['14.1','15.1'], 237 => '15.1', 242 => '29.1', 243 => '14.1', 246 => '15.1' },
	'previewbuttonplusdials' => { 236 => ['14.2','15.2'], 237 => '15.2', 242 => '31.2', 246 => '43.1' },
	'previewcolorspace' => { 105 => 0xc71a },
	'previewcropbottom' => { 313 => 0xef },
	'previewcropleft' => { 313 => 0xec },
	'previewcropright' => { 313 => 0xee },
	'previewcroptop' => { 313 => 0xed },
	'previewdate' => { 321 => 0x0 },
	'previewdatetime' => { 105 => 0xc71b },
	'previewimage' => { 101 => 0x2000, 102 => 'PreviewImage', 106 => 'PreviewImage', 108 => 0x4, 145 => 'data', 162 => 0x81, 254 => 0x280, 268 => 0x300, 355 => 0x2001 },
	'previewimageborders' => { 302 => 0x3e },
	'previewimageheight' => { 64 => 0x4, 123 => 0xfa58 },
	'previewimagelength' => { 64 => 0x2, 101 => 0x3, 105 => [0x117,0x202], 162 => 0x89, 196 => 0x202, 249 => 0x102, 254 => 0x1037, 302 => 0x3, 326 => 0x1e, 331 => 0x3, 336 => [0x1b,0x1d], 346 => 0x202 },
	'previewimagename' => { 145 => '1Name' },
	'previewimagesize' => { 101 => 0x2, 128 => 0x2, 145 => 'ImageSize', 302 => 0x2, 336 => [0x1c,0x1e], 355 => 0xb02c },
	'previewimagestart' => { 64 => 0x5, 101 => 0x4, 105 => [0x111,0x201], 162 => 0x88, 196 => 0x201, 249 => 0x101, 254 => 0x1036, 302 => 0x4, 326 => 0x1c, 331 => 0x2, 336 => [0x1a,0x1c], 346 => 0x201 },
	'previewimagetype' => { 145 => '0Type' },
	'previewimagevalid' => { 249 => 0x100, 254 => 0x1035 },
	'previewimagewidth' => { 64 => 0x3, 123 => 0xfa57 },
	'previewquality' => { 64 => 0x1 },
	'previewsettingsdigest' => { 105 => 0xc719 },
	'previewsettingsname' => { 105 => 0xc718 },
	'primaryafpoint' => { 169 => 0x7 },
	'primarychromaticities' => { 105 => 0x13f, 419 => 'PrimaryChromaticities' },
	'printim' => { 105 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 160 => 0x1d, 343 => 0x28 },
	'privatertkinfo' => { 389 => 'privateRTKInfo' },
	'processingsoftware' => { 105 => 0xb },
	'processversion' => { 398 => 'ProcessVersion' },
	'producer' => { 258 => 'Producer', 409 => 'Producer' },
	'productcode' => { 413 => 'productCode' },
	'productid' => { 114 => 0x32, 412 => 'productID' },
	'productidtype' => { 412 => 'productIDType' },
	'productinimage' => { 408 => 'ProductInImage' },
	'productinimagedescription' => { 408 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 408 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 408 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 282 => 0x2 },
	'productorserviceconstraints' => { 411 => 'ProductOrServiceConstraints' },
	'profession' => { 413 => 'profession' },
	'profilecalibrationsig' => { 105 => 0xc6f4 },
	'profilecopyright' => { 105 => 0xc6fe },
	'profileembedpolicy' => { 105 => 0xc6fd },
	'profilehuesatmapdata1' => { 105 => 0xc6fa },
	'profilehuesatmapdata2' => { 105 => 0xc6fb },
	'profilehuesatmapdims' => { 105 => 0xc6f9 },
	'profilehuesatmapencoding' => { 105 => 0xc7a3 },
	'profilelooktabledata' => { 105 => 0xc726 },
	'profilelooktabledims' => { 105 => 0xc725 },
	'profilelooktableencoding' => { 105 => 0xc7a4 },
	'profilename' => { 105 => 0xc6f8 },
	'profiletonecurve' => { 105 => 0xc6fc },
	'programiso' => { 269 => 0x3c },
	'programline' => { 283 => '1.1' },
	'programmode' => { 165 => 0x5 },
	'programshift' => { 193 => 0xd },
	'programversion' => { 113 => 0x46 },
	'prohibits' => { 395 => 'prohibits' },
	'projectiontype' => { 387 => 'ProjectionType' },
	'projectname' => { 423 => 'projectName' },
	'projectref' => { 423 => 'projectRef' },
	'projectrefpath' => { 423 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 423 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 411 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 411 => 'PropertyReleaseStatus' },
	'province-state' => { 113 => 0x5f },
	'publicationdate' => { 413 => 'publicationDate' },
	'publicationdatea-platform' => { 413 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 413 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 413 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 413 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 413 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 413 => 'publicationName' },
	'publisher' => { 399 => 'publisher' },
	'publishingfrequency' => { 413 => 'publishingFrequency' },
	'pulldown' => { 423 => 'pullDown' },
	'purplehsl' => { 91 => 0x20916 },
	'quality' => { 0 => 0x1, 31 => 0x3, 100 => 0x2, 101 => 0x3002, 110 => 0x1000, 121 => 0x9, 193 => 0x4, 219 => 0x3, 254 => 0x201, 265 => 0x300, 302 => 0x8, 309 => 0x2, 336 => 0x16, 343 => 0x56, 344 => 0x56, 345 => 0xb, 355 => 0x102 },
	'quality2' => { 362 => 0x1170, 363 => 0x1174, 364 => 0x1150, 366 => 0x11a8, 367 => 0x1060, 368 => 0x258, 369 => 0x258, 371 => 0x29, 372 => 0x25, 373 => 0x2a },
	'qualitymode' => { 101 => 0x8 },
	'quantizationmethod' => { 115 => 0x78 },
	'quickadjust' => { 232 => 0x2a },
	'quickcontroldialinmeter' => { 73 => 0x703 },
	'quickfix' => { 229 => 0x416391c6 },
	'quickshot' => { 335 => 0x213 },
	'rangefinder' => { 239 => '4.1', 240 => '5.1', 241 => '5.1' },
	'rasterizedcaption' => { 113 => 0x7d },
	'rating' => { 105 => 0x4746, 110 => 0x1431, 313 => 0xdf, 355 => 0x2002, 392 => 'rating', 400 => 'rating', 413 => 'rating', 421 => 'Rating' },
	'ratingpercent' => { 105 => 0x4749, 155 => 'Rating' },
	'rawandjpgrecording' => { 71 => 0x8, 162 => 0x109, 283 => 0xd },
	'rawbrightnessadj' => { 91 => 0x20001, 96 => 0x38 },
	'rawcoloradj' => { 96 => 0x2e },
	'rawcompressionmode' => { 333 => 0x45 },
	'rawcropbottom' => { 313 => 0xd4 },
	'rawcropleft' => { 313 => 0xd1 },
	'rawcropright' => { 313 => 0xd3 },
	'rawcroptop' => { 313 => 0xd2 },
	'rawcustomsaturation' => { 96 => 0x30 },
	'rawcustomtone' => { 96 => 0x34 },
	'rawdata' => { 333 => 0xa048 },
	'rawdatauniqueid' => { 105 => 0xc65d },
	'rawdepth' => { 164 => 0x10 },
	'rawdevartfilter' => { 256 => 0x121 },
	'rawdevautogradation' => { 256 => 0x119 },
	'rawdevcolorspace' => { 255 => 0x108, 256 => 0x109 },
	'rawdevcontrastvalue' => { 255 => 0x106, 256 => 0x105 },
	'rawdeveditstatus' => { 255 => 0x10b },
	'rawdevelopmentprocess' => { 302 => 0x62 },
	'rawdevengine' => { 255 => 0x109, 256 => 0x10b },
	'rawdevexposurebiasvalue' => { 255 => 0x100, 256 => 0x100 },
	'rawdevgradation' => { 256 => 0x112 },
	'rawdevgraypoint' => { 255 => 0x103, 256 => 0x104 },
	'rawdevmemorycoloremphasis' => { 255 => 0x105, 256 => 0x108 },
	'rawdevnoisereduction' => { 255 => 0x10a, 256 => 0x10a },
	'rawdevpicturemode' => { 256 => 0x10c },
	'rawdevpm_bwfilter' => { 256 => 0x110 },
	'rawdevpmcontrast' => { 256 => 0x10e },
	'rawdevpmnoisefilter' => { 256 => 0x120 },
	'rawdevpmpicturetone' => { 256 => 0x111 },
	'rawdevpmsaturation' => { 256 => 0x10d },
	'rawdevpmsharpness' => { 256 => 0x10f },
	'rawdevsaturation3' => { 256 => 0x113 },
	'rawdevsaturationemphasis' => { 255 => 0x104, 256 => 0x107 },
	'rawdevsettings' => { 255 => 0x10c },
	'rawdevsharpnessvalue' => { 255 => 0x107, 256 => 0x106 },
	'rawdevversion' => { 255 => 0x0, 256 => 0x0 },
	'rawdevwbfineadjustment' => { 255 => 0x102, 256 => 0x103 },
	'rawdevwhitebalance' => { 256 => 0x101 },
	'rawdevwhitebalancevalue' => { 255 => 0x101, 256 => 0x102 },
	'rawfile' => { 105 => 0xfe4c },
	'rawfilename' => { 398 => 'RawFileName' },
	'rawformat' => { 311 => 0x10e },
	'rawimagecenter' => { 193 => 0x99 },
	'rawimagedigest' => { 105 => 0xc71c },
	'rawimagesize' => { 302 => 0x39 },
	'rawinfoversion' => { 257 => 0x0 },
	'rawjpgheight' => { 88 => 0x4 },
	'rawjpgquality' => { 49 => 0x6, 88 => 0x1 },
	'rawjpgsize' => { 49 => 0x7, 88 => 0x2 },
	'rawjpgwidth' => { 88 => 0x3 },
	'rawmeasuredrggb' => { 36 => 0x26a, 38 => 0x280, 40 => 0x194, 41 => [0x1ad,0x26b] },
	'rawrppused' => { 392 => 'rawrppused' },
	'rawtopreviewgain' => { 105 => 0xc7a8 },
	'reardisplay' => { 236 => '12.3', 237 => '6.2' },
	'recipeendingpage' => { 415 => 'recipeEndingPage' },
	'recipepagerange' => { 415 => 'recipePageRange' },
	'recipesource' => { 415 => 'recipeSource' },
	'recipestartingpage' => { 415 => 'recipeStartingPage' },
	'recipetitle' => { 415 => 'recipeTitle' },
	'recognizedface1age' => { 264 => 0x20 },
	'recognizedface1name' => { 264 => 0x4 },
	'recognizedface1position' => { 264 => 0x18 },
	'recognizedface2age' => { 264 => 0x50 },
	'recognizedface2name' => { 264 => 0x34 },
	'recognizedface2position' => { 264 => 0x48 },
	'recognizedface3age' => { 264 => 0x80 },
	'recognizedface3name' => { 264 => 0x64 },
	'recognizedface3position' => { 264 => 0x78 },
	'recognizedfaceflags' => { 269 => 0x63 },
	'recommendedexposureindex' => { 105 => 0x8832, 403 => 'RecommendedExposureIndex' },
	'record' => { 104 => 'Record' },
	'recordbasisofrecord' => { 104 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 104 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 104 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 104 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 104 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 104 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 160 => 0x4d },
	'recorddynamicproperties' => { 104 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 86 => 0x1804 },
	'recordinformationwithheld' => { 104 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 327 => 0x1000 },
	'recordingmode' => { 100 => 0x1, 309 => 0x1 },
	'recordinstitutioncode' => { 104 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 104 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 31 => 0x9, 101 => 0x3000 },
	'recordownerinstitutioncode' => { 104 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 335 => 0x217 },
	'redbalance' => { 177 => 0x270, 254 => 0x1017, 273 => 0x11, 302 => 0x1c },
	'redcurvelimits' => { 96 => 0x18a },
	'redcurvepoints' => { 95 => 0x2d, 96 => 0x160 },
	'redeyecorrection' => { 233 => 0x0 },
	'redeyeinfo' => { 398 => 'RedEyeInfo' },
	'redeyereduction' => { 160 => 0x41, 343 => 0x6a, 345 => 0x28 },
	'redhsl' => { 91 => 0x20910 },
	'redhue' => { 398 => 'RedHue' },
	'redsaturation' => { 398 => 'RedSaturation' },
	'reductionmatrix1' => { 105 => 0xc625 },
	'reductionmatrix2' => { 105 => 0xc626 },
	'reelname' => { 105 => 0xc789 },
	'reference1' => { 406 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 406 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 105 => 0x214, 419 => 'ReferenceBlackWhite' },
	'referencedate' => { 113 => 0x2f },
	'referencenumber' => { 113 => 0x32 },
	'references' => { 136 => 'References' },
	'referenceservice' => { 113 => 0x2d },
	'regionappliedtodimensions' => { 151 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 151 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 151 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 151 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 151 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 151 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 151 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 151 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 151 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 151 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 151 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 151 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 411 => 'RegionConstraints' },
	'regiondescription' => { 151 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 151 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 151 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 151 => 'Regions' },
	'regioninfodateregionsvalid' => { 152 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 152 => 'RegionInfo' },
	'regioninforegions' => { 152 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 151 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 151 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 152 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 152 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 152 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 152 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 152 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 151 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 151 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 151 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 408 => 'RegistryId' },
	'registryitemid' => { 408 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 408 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 134 => 'data' },
	'relatedaudiofilename' => { 134 => '1Name' },
	'relatedaudiofiletype' => { 134 => '0Type' },
	'relatedimagefileformat' => { 105 => 0x1000 },
	'relatedimageheight' => { 105 => 0x1002 },
	'relatedimagewidth' => { 105 => 0x1001 },
	'relatedresourceid' => { 104 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 105 => 0xa004, 402 => 'RelatedSoundFile' },
	'relatedvideofile' => { 148 => 'data' },
	'relatedvideofilename' => { 148 => '1Name' },
	'relatedvideofiletype' => { 148 => '0Type' },
	'relation' => { 399 => 'relation' },
	'relationshipaccordingto' => { 104 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 104 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 104 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 104 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 423 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 423 => 'relativeTimestamp' },
	'relativetimestampscale' => { 423 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 423 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 236 => '17.8', 237 => '18.5', 242 => '33.8', 243 => '17.6', 246 => '18.5' },
	'releasedate' => { 113 => 0x1e, 423 => 'releaseDate' },
	'releasemode' => { 101 => 0x3001, 355 => 0xb049 },
	'releasemode2' => { 362 => 0x112c, 363 => [0x112c,0x8], 364 => [0x1108,0x8], 365 => [0x1184,0x8], 366 => [0x1160,0x8], 367 => [0x4,0x1018], 368 => [0x4,0x210], 369 => [0x4,0x210], 370 => [0x67,0x73,0x3f,0x4b], 371 => 0x10, 372 => 0x10, 373 => 0x9, 379 => 0x34 },
	'releasemode3' => { 362 => 0x1128, 363 => 0x1128, 364 => 0x1104, 365 => 0x1180, 366 => 0x115c, 367 => 0x1014, 368 => 0x20c, 369 => 0x20c },
	'releasesetting' => { 86 => 0x1016 },
	'releasetime' => { 113 => 0x23 },
	'remoteonduration' => { 238 => '3.4', 239 => '17.2', 240 => '18.2', 241 => '18.2', 243 => '18.2', 244 => '4.3', 247 => '19.2' },
	'renditionclass' => { 424 => 'RenditionClass' },
	'renditionof' => { 424 => 'RenditionOf' },
	'renditionofalternatepaths' => { 424 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 424 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 424 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 424 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 424 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 424 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 424 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 424 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 424 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 424 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 424 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 424 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 424 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 424 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 424 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 424 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 424 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 424 => 'RenditionParams' },
	'repeatingflashcount' => { 182 => 0xd, 183 => 0xe, 184 => 0xe, 242 => '17.2', 243 => '24.2', 244 => '9.2', 245 => '24.2', 247 => '25.2' },
	'repeatingflashcountbuilt-in' => { 216 => 0x4db },
	'repeatingflashcountexternal' => { 216 => 0x4c3 },
	'repeatingflashoutput' => { 242 => '17.1', 243 => '24.1', 244 => '9.1', 245 => '24.1', 247 => '25.1' },
	'repeatingflashoutputexternal' => { 216 => 0x4c0 },
	'repeatingflashrate' => { 182 => 0xc, 183 => 0xd, 184 => 0xd, 242 => '18.1', 243 => '25.1', 244 => '10.1', 245 => '25.1', 247 => '26.1' },
	'repeatingflashratebuilt-in' => { 216 => 0x4da },
	'repeatingflashrateexternal' => { 216 => 0x4c2 },
	'requires' => { 395 => 'requires' },
	'resampleparams' => { 423 => 'resampleParams' },
	'resampleparamsquality' => { 423 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 335 => 0x21e },
	'resolution' => { 141 => 'Resolution' },
	'resolutionmode' => { 336 => 0x4 },
	'resolutionunit' => { 105 => 0x128, 116 => 0x2, 419 => 'ResolutionUnit' },
	'resourceid' => { 104 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 104 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 104 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 73 => 0x612 },
	'restrictions' => { 416 => 'restrictions' },
	'retouchareafeather' => { 398 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 398 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 398 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 398 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 398 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 398 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 398 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 398 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 398 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 398 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 398 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 398 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 398 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 398 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 398 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 398 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 398 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 398 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 398 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 398 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 398 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 398 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 398 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 398 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 398 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 398 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 398 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 398 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 398 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 398 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 398 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 398 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 398 => 'RetouchAreas' },
	'retouchareaseed' => { 398 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 398 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 398 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 398 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 193 => 0x9e },
	'retouchinfo' => { 398 => 'RetouchInfo' },
	'retouchnefprocessing' => { 198 => 0x5 },
	'reuse' => { 411 => 'Reuse' },
	'reuseallowed' => { 426 => 'ReuseAllowed' },
	'reuseprohibited' => { 416 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 241 => '5.2' },
	'reverseindicators' => { 236 => '12.1', 237 => '6.1', 239 => '4.3', 240 => '5.2', 241 => '5.4', 242 => '33.5', 243 => '5.1', 246 => '6.1', 247 => '6.2' },
	'reverseshutterspeedaperture' => { 241 => '5.3' },
	'revision' => { 400 => 'revision' },
	'rgbcurvelimits' => { 96 => 0x238 },
	'rgbcurvepoints' => { 95 => 0x7, 96 => 0x20e },
	'richtextcomment' => { 405 => 'RichTextComment' },
	'ricohdate' => { 326 => 0x6 },
	'ricohimageheight' => { 326 => 0x2 },
	'ricohimagewidth' => { 326 => 0x0 },
	'rightascension' => { 144 => 'RightAscension' },
	'rights' => { 399 => 'rights' },
	'rightsagent' => { 416 => 'rightsAgent' },
	'rightsowner' => { 416 => 'rightsOwner' },
	'rollangle' => { 209 => 0x350b, 249 => 0x903, 269 => 0x90, 301 => 0x1 },
	'romoperationmode' => { 86 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 85 => 0x3, 91 => 0x10002, 96 => 0x26e, 109 => 0x4, 144 => 'Rotation', 158 => [0x65,0x50], 159 => 0x46, 160 => 0x5a, 163 => 0x10, 215 => '590.1', 229 => 0x76a43207, 269 => 0x30, 283 => '17.2', 313 => 0xd8, 343 => 0x3f, 344 => 0x3f, 354 => 0x10 },
	'routedto' => { 404 => 'RoutedTo' },
	'routing' => { 318 => 'Routing' },
	'routingnotes' => { 404 => 'RoutingNotes' },
	'rowsperstrip' => { 105 => 0x116 },
	'rpp' => { 392 => 'rpp' },
	'safetyshift' => { 73 => 0x108 },
	'safetyshiftinavortv' => { 71 => 0x10, 72 => 0x10, 74 => 0xf, 75 => 0x10, 78 => 0x10 },
	'samplebits' => { 134 => 'SampleBits' },
	'samplepagerange' => { 413 => 'samplePageRange' },
	'samplerate' => { 134 => 'SampleRate' },
	'samplesperpixel' => { 105 => 0x115, 419 => 'SamplesPerPixel' },
	'samplestructure' => { 115 => 0x5a },
	'samsungmodelid' => { 333 => 0x3 },
	'sanyoquality' => { 335 => 0x201 },
	'sanyothumbnail' => { 335 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 31 => 0xe, 43 => 0x1, 100 => 0xd, 101 => [0x3013,0x1f], 105 => [0xa409,0xfe55], 110 => 0x1003, 135 => 'Saturation', 157 => 0x1f, 158 => 0x32, 159 => 0x28, 160 => 0x1a, 165 => 0x1, 193 => [0x94,0xaa], 195 => 0x35, 269 => 0x40, 271 => 0x300d, 302 => 0x1f, 309 => 0xd, 323 => 0x27, 326 => 0x28, 327 => 0x1013, 336 => 0x10, 343 => 0x1e, 344 => 0x1b, 355 => 0x2005, 398 => 'Saturation', 402 => 'Saturation' },
	'saturationadj' => { 91 => 0x20901, 96 => 0x116, 228 => 0x1, 232 => 0x2e, 383 => 0x8016 },
	'saturationadjustmentaqua' => { 398 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 398 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 398 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 398 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 398 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 398 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 398 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 398 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 62 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 61 => 0x68, 62 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 61 => 0x38, 62 => 0x38 },
	'saturationmonochrome' => { 61 => 0x80, 62 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 61 => 0x50, 62 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 61 => 0x20, 62 => 0x20 },
	'saturationsetting' => { 257 => 0x1010, 345 => 0x11, 359 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 61 => 0x8, 62 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 61 => 0x98, 62 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 61 => 0xb0, 62 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 61 => 0xc8, 62 => 0xe0 },
	'saveid' => { 424 => 'SaveID' },
	'scaletype' => { 423 => 'scaleType' },
	'scanimageenhancer' => { 199 => 0x60 },
	'scanningdirection' => { 115 => 0x64 },
	'scene' => { 407 => 'Scene', 423 => 'scene' },
	'scenearea' => { 252 => 0x211, 254 => 0x1031 },
	'sceneassist' => { 193 => 0x9c },
	'scenecapturetype' => { 105 => 0xa406, 402 => 'SceneCaptureType' },
	'scenedetect' => { 252 => 0x210, 254 => 0x1030 },
	'scenedetectdata' => { 252 => 0x212, 254 => 0x1033 },
	'scenemode' => { 123 => 0xfa02, 162 => 0x100, 193 => 0x8f, 249 => 0x509, 254 => 0x403, 269 => 0x8001, 277 => 0xf, 355 => 0xb023 },
	'scenemodeused' => { 125 => [0x6002,0xf002] },
	'sceneselect' => { 335 => 0x21f },
	'scenetype' => { 105 => 0xa301, 402 => 'SceneType' },
	'screentips' => { 236 => '12.7', 237 => '5.3', 242 => '13.1', 243 => '4.4', 246 => '5.4', 247 => '5.1' },
	'season' => { 412 => 'season' },
	'section' => { 413 => 'section' },
	'securityclassification' => { 105 => 0x9212 },
	'selectableafpoint' => { 73 => 0x509 },
	'selectafareaselectmode' => { 73 => 0x512 },
	'selftimer' => { 31 => 0x2, 269 => 0x2e, 335 => 0x214 },
	'selftimer2' => { 67 => 0x1d },
	'selftimerinterval' => { 243 => '19.2' },
	'selftimermode' => { 105 => 0x882b },
	'selftimershotcount' => { 237 => '20.2', 239 => '18.2', 240 => '19.2', 241 => '19.2', 243 => '19.3', 246 => '20.3', 247 => '20.2' },
	'selftimershotinterval' => { 237 => '20.3', 246 => '20.2' },
	'selftimertime' => { 86 => 0x1806, 160 => 0x1f, 236 => '18.1', 237 => '20.1', 238 => '3.3', 239 => '18.1', 240 => '19.1', 241 => '19.1', 242 => '7.2', 243 => '19.1', 244 => '3.3', 246 => '20.1', 247 => '20.1' },
	'sellingagency' => { 413 => 'sellingAgency' },
	'seminfo' => { 105 => 0x8546 },
	'sensingmethod' => { 105 => 0xa217, 402 => 'SensingMethod' },
	'sensitivityadjust' => { 302 => 0x40 },
	'sensitivitysteps' => { 283 => ['14.3','17.4'], 285 => 0x1 },
	'sensitivitytype' => { 105 => 0x8830, 403 => 'SensitivityType' },
	'sensor' => { 167 => 0x665e },
	'sensorareas' => { 333 => 0xa010 },
	'sensorbitdepth' => { 271 => 0x312d },
	'sensorbluelevel' => { 65 => 0x5 },
	'sensorcalibration' => { 253 => 0x805 },
	'sensorcleaning' => { 79 => 0xd },
	'sensorfullheight' => { 118 => 0xf904 },
	'sensorfullwidth' => { 118 => 0xf903 },
	'sensorheight' => { 118 => 0xf901, 123 => 0xfa21, 164 => 0x8, 271 => 0x312c, 311 => 0x109, 327 => 0x1602 },
	'sensorleftmargin' => { 311 => 0x10a },
	'sensorpixelsize' => { 193 => 0x9a },
	'sensorredlevel' => { 65 => 0x4 },
	'sensorserialnumber' => { 119 => 0x9ce },
	'sensorsize' => { 135 => 'SensorSize', 302 => 0x35 },
	'sensortemperature' => { 252 => 0x1500, 254 => 0x1007, 307 => 0xc, 311 => 0x210, 336 => [0x39,0x55] },
	'sensortemperature2' => { 307 => 0xe, 311 => 0x211 },
	'sensortopmargin' => { 311 => 0x10b },
	'sensorwidth' => { 118 => 0xf900, 123 => 0xfa20, 164 => 0xa, 271 => 0x312b, 311 => 0x108, 327 => 0x1601 },
	'sequence' => { 323 => 0x7 },
	'sequencefilenumber' => { 363 => 0x4, 364 => 0x4, 365 => 0x4, 366 => 0x4, 371 => 0xc, 372 => 0xc, 373 => 0x1a },
	'sequenceimagenumber' => { 363 => 0x0, 364 => 0x0, 365 => 0x0, 366 => 0x0, 371 => 0x8, 372 => 0x8, 373 => 0x12, 379 => 0x24 },
	'sequencelength' => { 371 => 0x22, 372 => 0x1e, 373 => [0x16,0x1e] },
	'sequencename' => { 412 => 'sequenceName' },
	'sequencenumber' => { 67 => 0x9, 101 => 0x301c, 110 => 0x1101, 121 => 0x1d, 216 => 0x51c, 269 => 0x2b, 345 => [0x10c,0x30c], 355 => 0xb04a, 412 => 'sequenceNumber' },
	'sequenceshotinterval' => { 335 => 0x224 },
	'sequencetotalnumber' => { 412 => 'sequenceTotalNumber' },
	'sequentialshot' => { 335 => 0x20e },
	'serialnumber' => { 55 => 0xc, 86 => 0x180b, 105 => [0xa431,0xfde9], 118 => 0xfa04, 120 => 0xfa00, 122 => 0xc354, 123 => 0xfa19, 132 => 0x0, 135 => 'SerialNumber', 193 => [0xa0,0x1d], 250 => 0x101, 254 => [0x404,0x101a], 265 => 0x303, 271 => 0x3103, 302 => 0x229, 311 => 0x102, 312 => 0x407, 323 => 0x15, 327 => 0x5, 336 => 0x2, 394 => 'SerialNumber', 403 => 'BodySerialNumber' },
	'serialnumberformat' => { 55 => 0x15, 86 => 0x183b },
	'seriesdatetime' => { 385 => 'SeriesDateTime' },
	'seriesdescription' => { 385 => 'SeriesDescription' },
	'seriesmodality' => { 385 => 'SeriesModality' },
	'seriesnumber' => { 385 => 'SeriesNumber', 413 => 'seriesNumber' },
	'seriestitle' => { 413 => 'seriesTitle' },
	'serviceidentifier' => { 114 => 0x1e },
	'servingsize' => { 415 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 76 => 0x0, 77 => 0x0 },
	'setbuttonwhenshooting' => { 71 => 0x1, 73 => 0x704, 79 => 0xc },
	'setfunctionwhenshooting' => { 74 => 0x0, 75 => 0x1, 78 => 0x1 },
	'setting' => { 412 => 'setting' },
	'shadingcompensation' => { 249 => 0x50c, 269 => 0x8a },
	'shadingcompensation2' => { 253 => 0x1012 },
	'shadow' => { 336 => 0xe },
	'shadowadj' => { 91 => 0x2030b },
	'shadowcorrection' => { 302 => 0x79 },
	'shadowprotection' => { 228 => 0x0 },
	'shadows' => { 105 => 0xfe52, 391 => 'Shadows', 398 => 'Shadows' },
	'shadows2012' => { 398 => 'Shadows2012' },
	'shadowscale' => { 105 => 0xc633 },
	'shadowtint' => { 398 => 'ShadowTint' },
	'shadowtone' => { 110 => 0x1040 },
	'shakereduction' => { 304 => 0x1, 305 => 0x1 },
	'sharpendetail' => { 398 => 'SharpenDetail' },
	'sharpenedgemasking' => { 398 => 'SharpenEdgeMasking' },
	'sharpening' => { 271 => 0x300b },
	'sharpeningadj' => { 232 => 0x2b },
	'sharpenradius' => { 398 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 31 => 0xf, 65 => 0x2, 100 => 0xb, 101 => [0x3011,0x21], 105 => [0xa40a,0xfe56], 110 => 0x1001, 121 => 0x6b, 130 => 0x37, 135 => 'Sharpness', 157 => 0x21, 158 => 0x30, 159 => 0x26, 160 => 0x18, 165 => 0x3, 193 => 0x6, 195 => 0x32, 254 => 0x100f, 269 => 0x41, 302 => 0x21, 309 => 0xb, 323 => 0x26, 326 => 0x22, 327 => [0x1003,0x1014], 336 => 0x11, 343 => 0x1c, 344 => 0x19, 355 => 0x2006, 379 => 0x52, 398 => 'Sharpness', 402 => 'Sharpness' },
	'sharpnessadj' => { 91 => 0x20310, 96 => 0x25a, 383 => 0x801a },
	'sharpnessadjon' => { 91 => '0x20310.0' },
	'sharpnessauto' => { 62 => 0x94 },
	'sharpnessfactor' => { 254 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 61 => 0x64, 62 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 65 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 61 => 0x34, 62 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 61 => 0x7c, 62 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 61 => 0x4c, 62 => 0x4c },
	'sharpnessovershoot' => { 383 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 61 => 0x1c, 62 => 0x1c },
	'sharpnesssetting' => { 249 => 0x506, 257 => 0x1013, 345 => 0x12, 359 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 61 => 0x4, 62 => 0x4 },
	'sharpnessstrength' => { 91 => 0x20311 },
	'sharpnessthreshold' => { 383 => 0x801d },
	'sharpnessundershoot' => { 383 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 61 => 0x94, 62 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 61 => 0xac, 62 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 61 => 0xc4, 62 => 0xdc },
	'shootid' => { 412 => 'shootID' },
	'shootingdistance' => { 91 => 0x20701 },
	'shootinginfodisplay' => { 236 => '13.2', 237 => '5.1', 242 => '10.2', 243 => '4.1', 246 => '5.1', 247 => '5.3' },
	'shootinginfomonitorofftime' => { 236 => '26.2', 237 => '22.2', 242 => '9.1', 243 => '21.2', 246 => '22.2', 247 => '22.2' },
	'shootingmode' => { 135 => 'ShootingMode', 193 => 0x89, 269 => 0x1f },
	'shootingmodesetting' => { 238 => '5.1' },
	'shortdescription' => { 400 => 'shortdescription' },
	'shortdocumentid' => { 113 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 73 => 0x80d },
	'shotdate' => { 423 => 'shotDate' },
	'shotday' => { 423 => 'shotDay' },
	'shotlocation' => { 423 => 'shotLocation' },
	'shotname' => { 423 => 'shotName' },
	'shotnumber' => { 423 => 'shotNumber' },
	'shotnumbersincepowerup' => { 358 => 0x44e, 371 => 0x1a, 372 => 0x16, 373 => 0xa },
	'shotnumbersincepowerup2' => { 345 => 0x200 },
	'shotsize' => { 423 => 'shotSize' },
	'shutter-aelock' => { 71 => 0x4, 73 => 0x701, 74 => 0x3, 75 => 0x4, 76 => 0x3, 77 => 0x3, 78 => 0x4, 79 => 0x2 },
	'shutteraelbutton' => { 72 => 0x4 },
	'shutterbuttonafonbutton' => { 73 => 0x701 },
	'shuttercount' => { 10 => 0x176, 49 => 0x1, 193 => 0xa7, 200 => [0x6a,0x157,0x24d], 201 => 0x286, 202 => 0x279, 203 => 0x284, 204 => 0x242, 205 => 0x280, 206 => 0x276, 207 => [0x27d,0x27f], 208 => 0x246, 210 => 0x2d6, 211 => 0x321, 212 => 0xbd8, 213 => 0x287, 214 => 0x320, 215 => 0x24a, 216 => 0x5fb, 218 => 0x2d5, 302 => 0x5d, 354 => 0x846, 357 => [0x125,0x14a] },
	'shuttercurtainsync' => { 71 => 0xf, 72 => 0xf, 73 => 0x305, 74 => 0xe, 75 => 0xf, 76 => 0x8, 77 => 0x8, 78 => 0xf, 79 => 0x8 },
	'shuttermode' => { 121 => 0x1b },
	'shutterreleasebuttonae-l' => { 236 => '17.7', 237 => '18.4', 239 => '16.1', 240 => '17.1', 241 => '17.1', 242 => '7.1', 243 => '17.5', 246 => '18.4', 247 => '18.2' },
	'shutterreleasemethod' => { 86 => 0x1010 },
	'shutterreleasenocfcard' => { 71 => 0x2, 72 => 0x2, 79 => 0xf },
	'shutterreleasetiming' => { 86 => 0x1011 },
	'shutterreleasewithoutlens' => { 73 => 0x711 },
	'shutterspeedlock' => { 237 => '38.1', 246 => '38.1' },
	'shutterspeedrange' => { 73 => 0x10c },
	'shutterspeedsetting' => { 160 => 0x6, 343 => 0x2f, 344 => 0x28, 345 => 0x0 },
	'shutterspeedvalue' => { 82 => 0x1, 105 => 0x9201, 254 => 0x1000, 311 => 0x400, 402 => 'ShutterSpeedValue' },
	'shuttertype' => { 110 => 0x1050, 269 => 0x9f },
	'sidecarforextension' => { 410 => 'SidecarForExtension' },
	'similarityindex' => { 113 => 0xe4 },
	'singleframebracketing' => { 160 => 0x21 },
	'skilllevel' => { 415 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 302 => 0x20b },
	'slideshowname' => { 412 => 'slideshowName' },
	'slideshownumber' => { 412 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 412 => 'slideshowTotalNumber' },
	'slowshutter' => { 67 => 0x8 },
	'slowsync' => { 110 => 0x1030 },
	'smartrange' => { 333 => 0xa012 },
	'smileshutter' => { 345 => 0x31 },
	'smileshuttermode' => { 345 => 0x27 },
	'smoothness' => { 105 => 0xfe57, 398 => 'Smoothness' },
	'softskineffect' => { 355 => 0x200f },
	'software' => { 105 => 0x131, 136 => 'Software', 261 => 'Software', 311 => 0x203, 336 => 0x18, 419 => 'Software' },
	'softwareversion' => { 335 => 0x207 },
	'sonydatetime' => { 361 => 0x6, 363 => 0x1b6, 364 => 0x210, 365 => 0x1fe, 366 => 0x22c },
	'sonydatetime2' => { 370 => [0x51,0x5d] },
	'sonyexposuretime' => { 370 => 0x46 },
	'sonyexposuretime2' => { 379 => 0xe },
	'sonyfnumber' => { 370 => [0x3c,0x48], 379 => 0x14 },
	'sonyimageheight' => { 361 => 0x1a, 371 => 0x44, 372 => 0x3f, 373 => 0x47 },
	'sonyimagesize' => { 160 => 0x3b, 343 => 0x54, 344 => 0x54, 345 => 0x9 },
	'sonyimagewidth' => { 361 => 0x1c },
	'sonyiso' => { 363 => 0x1218, 364 => 0x11f4, 365 => 0x1270, 366 => [0x1254,0x1258,0x1280], 367 => 0x113c, 368 => 0x344, 369 => 0x346, 379 => 0x4 },
	'sonymaxaperturevalue' => { 379 => 0x16 },
	'sonymodelid' => { 355 => 0xb001 },
	'sonyquality' => { 160 => 0x3c },
	'source' => { 113 => 0x73, 261 => 'Source', 399 => 'source', 400 => 'source', 410 => 'Source' },
	'sourcedirectoryindex' => { 289 => 0x0 },
	'sourcefileindex' => { 289 => 0x2 },
	'sourcephotoscount' => { 387 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 402 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 402 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 402 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 402 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 402 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 423 => 'speakerPlacement' },
	'specialeffectlevel' => { 101 => 0x3030 },
	'specialeffectmode' => { 101 => 0x2076 },
	'specialeffectsetting' => { 101 => 0x3031 },
	'specialinstructions' => { 113 => 0x28 },
	'specialmode' => { 254 => 0x200, 335 => 0x200 },
	'specialoccasion' => { 415 => 'specialOccasion' },
	'spectralsensitivity' => { 105 => 0x8824, 402 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 38 => [0x2b9,0x2d0,0x2d4], 40 => 0x1e4, 41 => [0x1fd,0x2dd], 42 => 0x30f },
	'splitcolumn' => { 311 => 0x222 },
	'splittoningbalance' => { 398 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 398 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 398 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 398 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 398 => 'SplitToningShadowSaturation' },
	'sport' => { 413 => 'sport' },
	'spotfocuspointx' => { 157 => 0x2d },
	'spotfocuspointy' => { 157 => 0x2e },
	'spotmeteringmode' => { 31 => 0x27 },
	'spotmeterlinktoafpoint' => { 73 => 0x107 },
	'sractive' => { 283 => '17.1' },
	'srawquality' => { 31 => 0x2e },
	'srfocallength' => { 304 => 0x3 },
	'srhalfpresstime' => { 304 => 0x2 },
	'srresult' => { 304 => 0x0, 305 => 0x0 },
	'stackedimage' => { 249 => 0x804 },
	'standardoutputhighlightpoint' => { 97 => 0x14 },
	'standardoutputsensitivity' => { 105 => 0x8831, 403 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 97 => 0x15 },
	'standardrawcolortone' => { 97 => 0xd },
	'standardrawcontrast' => { 97 => 0xf },
	'standardrawhighlight' => { 97 => 0x75 },
	'standardrawhighlightpoint' => { 97 => 0x12 },
	'standardrawlinear' => { 97 => 0x10 },
	'standardrawsaturation' => { 97 => 0xe },
	'standardrawshadow' => { 97 => 0x7e },
	'standardrawshadowpoint' => { 97 => 0x13 },
	'standardrawsharpness' => { 97 => 0x11 },
	'standardunsharpmaskfineness' => { 97 => 0x94 },
	'standardunsharpmaskstrength' => { 97 => 0x92 },
	'standardunsharpmaskthreshold' => { 97 => 0x96 },
	'standbytimer' => { 237 => '19.1', 241 => '18.1', 246 => '19.1' },
	'startingpage' => { 413 => 'startingPage' },
	'startmovieshooting' => { 73 => 0x70d },
	'starttimecode' => { 423 => 'startTimecode' },
	'starttimecodetimeformat' => { 423 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 423 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 423 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 423 => 'startTimeSampleSize' },
	'starttimescale' => { 423 => 'startTimeScale' },
	'state' => { 140 => 'State', 269 => 0x6b, 410 => 'State' },
	'status' => { 386 => 'Status', 390 => 'Status' },
	'stitchingsoftware' => { 387 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 362 => 0x113e, 363 => 0x113e, 364 => 0x111a, 365 => 0x1196, 366 => 0x1172, 367 => 0x102a, 368 => 0x222, 369 => 0x222, 379 => 0xa },
	'storagemethod' => { 164 => 0x12 },
	'storebyorientation' => { 237 => '46.3', 246 => '47.3' },
	'straightenangle' => { 229 => 0x2fc08431 },
	'streamtype' => { 153 => 'StreamType' },
	'stretchmode' => { 423 => 'stretchMode' },
	'studydatetime' => { 385 => 'StudyDateTime' },
	'studydescription' => { 385 => 'StudyDescription' },
	'studyid' => { 385 => 'StudyID' },
	'studyphysician' => { 385 => 'StudyPhysician' },
	'sub-location' => { 113 => 0x5c },
	'subfiledata' => { 143 => 'data' },
	'subfiledirectory' => { 143 => '1Directory' },
	'subfilemimetype' => { 143 => '2MIME' },
	'subfilename' => { 143 => '1Name' },
	'subfileresource' => { 143 => 'rsrc' },
	'subfiletype' => { 105 => 0xfe, 143 => '0Type' },
	'subject' => { 258 => 'Subject', 318 => 'Subject', 399 => 'subject', 409 => 'Subject', 424 => 'subject' },
	'subjectarea' => { 105 => 0x9214, 402 => 'SubjectArea' },
	'subjectcode' => { 407 => 'SubjectCode' },
	'subjectdistance' => { 105 => 0x9206, 121 => 0x3e, 402 => 'SubjectDistance' },
	'subjectdistancerange' => { 105 => 0xa40c, 402 => 'SubjectDistanceRange' },
	'subjectlocation' => { 105 => 0xa214, 402 => 'SubjectLocation' },
	'subjectprogram' => { 157 => 0x22 },
	'subjectreference' => { 113 => 0xc },
	'sublabels4' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 406 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 406 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 105 => 0x9290 },
	'subsectimedigitized' => { 105 => 0x9292 },
	'subsectimeoriginal' => { 105 => 0x9291 },
	'subsection1' => { 413 => 'subsection1' },
	'subsection2' => { 413 => 'subsection2' },
	'subsection3' => { 413 => 'subsection3' },
	'subsection4' => { 413 => 'subsection4' },
	'subselector' => { 237 => '49.1' },
	'subselectorassignment' => { 237 => '48.1' },
	'subselectorplusdials' => { 237 => '49.2' },
	'subtitle' => { 413 => 'subtitle' },
	'subversionfilename' => { 406 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 406 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 406 => 'SubVersions' },
	'superimposeddisplay' => { 71 => 0xa, 73 => 0x510, 74 => 0x9, 75 => 0xa, 78 => 0xa, 79 => 0xe },
	'supermacro' => { 55 => 0x1a },
	'supplementalcategories' => { 113 => 0x14, 410 => 'SupplementalCategories' },
	'supplementaltype' => { 115 => 0x37 },
	'supplementdisplayid' => { 413 => 'supplementDisplayID' },
	'supplementstartingpage' => { 413 => 'supplementStartingPage' },
	'supplementtitle' => { 413 => 'supplementTitle' },
	'svisosetting' => { 283 => 0x14 },
	'sweeppanoramadirection' => { 269 => 0x93, 345 => 0x33 },
	'sweeppanoramafieldofview' => { 269 => 0x94 },
	'sweeppanoramasize' => { 345 => 0x32 },
	'switchtoregisteredafpoint' => { 72 => 0x12, 73 => 0x50a },
	'system' => { 311 => 0x204 },
	'tagged' => { 313 => 0xdd, 314 => 'Tagged', 392 => 'tagged' },
	'tagslist' => { 401 => 'TagsList' },
	'tagstructure' => { 406 => 'TagStructure' },
	'takenumber' => { 423 => 'takeNumber' },
	'tapename' => { 423 => 'tapeName' },
	'targetaperture' => { 67 => 0x4 },
	'targetcompressionratio' => { 84 => 0x1 },
	'targetdistancesetting' => { 86 => 0x1807 },
	'targetexposuretime' => { 67 => 0x5 },
	'targetimagetype' => { 86 => 0x100a },
	'taxon' => { 104 => 'Taxon' },
	'taxonacceptednameusage' => { 104 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 104 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 104 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 104 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 104 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 104 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 104 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 104 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 104 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 104 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 104 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 104 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 104 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 104 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 104 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 104 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 104 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 104 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 104 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 104 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 104 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 104 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 104 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 104 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 104 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 104 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 104 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 104 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 104 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 104 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 104 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 104 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 104 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 413 => 'teaser' },
	'teleconverter' => { 162 => 0x105, 355 => 0x105 },
	'tempo' => { 423 => 'tempo' },
	'termsandconditionstext' => { 411 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 411 => 'TermsAndConditionsURL' },
	'testname' => { 106 => 'TestName' },
	'textencoding' => { 192 => 0x4 },
	'textlayername' => { 410 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 410 => 'TextLayers' },
	'textlayertext' => { 410 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 269 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 105 => 0x107 },
	'thumbnailfilename' => { 86 => 0x817 },
	'thumbnailformat' => { 421 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 123 => 0xfa55, 421 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 86 => 0x2008, 102 => 'ThumbnailImage', 108 => 0x3, 146 => 'data', 254 => 0x100, 421 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 146 => '1Name' },
	'thumbnailimagesize' => { 146 => 'ImageSize' },
	'thumbnailimagetype' => { 146 => '0Type' },
	'thumbnailimagevalidarea' => { 55 => 0x13 },
	'thumbnaillength' => { 105 => 0x202 },
	'thumbnailoffset' => { 105 => 0x201 },
	'thumbnails' => { 421 => 'Thumbnails' },
	'thumbnailwidth' => { 123 => 0xfa54, 421 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 413 => 'ticker' },
	'tiffmeteringimage' => { 163 => 0x104c, 354 => 0x1110 },
	'tilelength' => { 105 => 0x143 },
	'tilewidth' => { 105 => 0x142 },
	'time' => { 119 => 0x401, 302 => 0x7 },
	'timecodes' => { 105 => 0xc763 },
	'timecreated' => { 113 => 0x3c, 121 => 0x14, 130 => 0x10, 314 => 'TimeCreated' },
	'timeperiod' => { 413 => 'timePeriod' },
	'timerfunctionbutton' => { 238 => '5.2', 239 => '12.1', 240 => '13.1' },
	'timerlength' => { 73 => 0x80c },
	'timerrecording' => { 269 => 0x96 },
	'timescaleparams' => { 423 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 423 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 423 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 423 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 114 => 0x50 },
	'timesignature' => { 423 => 'timeSignature' },
	'timesincepoweron' => { 269 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 248 => 0x8, 261 => 'TimeStamp', 393 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 68 => 0x1, 221 => 0x0, 330 => 0xa },
	'timezonecity' => { 68 => 0x2 },
	'timezonecode' => { 89 => 0x1 },
	'timezoneinfo' => { 89 => 0x2 },
	'timezoneoffset' => { 105 => 0x882a },
	'tint' => { 398 => 'Tint' },
	'title' => { 136 => 'Title', 258 => 'Title', 261 => 'Title', 269 => 0x65, 318 => 'Title', 399 => 'title', 409 => 'Title', 421 => 'Title' },
	'tonecomp' => { 193 => 0x81 },
	'tonecurve' => { 65 => 0x1, 302 => 0x402, 398 => 'ToneCurve' },
	'tonecurveactive' => { 96 => 0x110 },
	'tonecurveadobergb' => { 333 => 0xa043 },
	'tonecurveadobergbdefault' => { 333 => 0xa041 },
	'tonecurveblue' => { 398 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 383 => 0x9003 },
	'tonecurvebluey' => { 383 => 0x9007 },
	'tonecurvebrightness' => { 91 => 0x20410 },
	'tonecurvebrightnessx' => { 383 => 0x9000 },
	'tonecurvebrightnessy' => { 383 => 0x9004 },
	'tonecurvecolorspace' => { 95 => 0x0 },
	'tonecurvecontrast' => { 91 => 0x20411 },
	'tonecurvefilename' => { 119 => 0x1391 },
	'tonecurvegreen' => { 398 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 383 => 0x9002 },
	'tonecurvegreeny' => { 383 => 0x9006 },
	'tonecurveinputrange' => { 95 => 0x3 },
	'tonecurveinterpolation' => { 96 => 0x159 },
	'tonecurvemode' => { 96 => 0x113 },
	'tonecurvename' => { 398 => 'ToneCurveName' },
	'tonecurvename2012' => { 398 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 91 => '0x20400.1' },
	'tonecurveoutputrange' => { 95 => 0x5 },
	'tonecurveproperty' => { 96 => 0x3c },
	'tonecurvepv2012' => { 398 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 398 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 398 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 398 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 398 => 'ToneCurveRed' },
	'tonecurveredx' => { 383 => 0x9001 },
	'tonecurveredy' => { 383 => 0x9005 },
	'tonecurves' => { 302 => 0x403 },
	'tonecurveshape' => { 95 => 0x1 },
	'tonecurvesrgb' => { 333 => 0xa042 },
	'tonecurvesrgbdefault' => { 333 => 0xa040 },
	'tonecurvex' => { 95 => 0xa },
	'tonecurvey' => { 95 => 0xb },
	'tonelevel' => { 249 => 0x52e },
	'toningeffect' => { 49 => 0xf, 193 => 0xb3, 195 => 0x38, 327 => 0x1015 },
	'toningeffectauto' => { 62 => 0xa4 },
	'toningeffectfaithful' => { 61 => 0x74, 62 => 0x74 },
	'toningeffectlandscape' => { 61 => 0x44, 62 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 61 => 0x8c, 62 => 0x8c },
	'toningeffectneutral' => { 61 => 0x5c, 62 => 0x5c },
	'toningeffectportrait' => { 61 => 0x2c, 62 => 0x2c },
	'toningeffectstandard' => { 61 => 0x14, 62 => 0x14 },
	'toningeffectuserdef1' => { 61 => 0xa4, 62 => 0xbc },
	'toningeffectuserdef2' => { 61 => 0xbc, 62 => 0xd4 },
	'toningeffectuserdef3' => { 61 => 0xd4, 62 => 0xec },
	'toningsaturation' => { 195 => 0x39 },
	'totalzoom' => { 121 => 0x62 },
	'touchae' => { 269 => 0xab },
	'trackcreatedate' => { 322 => 0x1 },
	'trackmodifydate' => { 322 => 0x2 },
	'tracknumber' => { 423 => 'trackNumber' },
	'tracks' => { 423 => 'Tracks' },
	'tracksframerate' => { 423 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 423 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 423 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 423 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 423 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 423 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 423 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 423 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 423 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 423 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 423 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 423 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 423 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 423 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 423 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 423 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 423 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 143 => 'zmie' },
	'transferfunction' => { 105 => 0x12d, 419 => 'TransferFunction' },
	'transform' => { 269 => [0x8012,0x59] },
	'transmissionreference' => { 410 => 'TransmissionReference' },
	'trapped' => { 258 => 'Trapped', 409 => 'Trapped' },
	'trashbuttonfunction' => { 73 => 0x710 },
	'travelday' => { 269 => 0x36 },
	'triggermode' => { 323 => 0x6 },
	'tstop' => { 105 => 0xc772 },
	'ttl_da_adown' => { 290 => 0x5 },
	'ttl_da_aup' => { 290 => 0x4 },
	'ttl_da_bdown' => { 290 => 0x7 },
	'ttl_da_bup' => { 290 => 0x6 },
	'tungstenawb' => { 280 => 0x1 },
	'tvexposuretimesetting' => { 283 => 0x12 },
	'type' => { 399 => 'type', 418 => 'type' },
	'typestatus' => { 104 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 105 => 0xc614 },
	'uniquedocumentid' => { 113 => 0xbb },
	'uniqueobjectname' => { 114 => 0x64 },
	'unknownblock' => { 302 => 0x405 },
	'unknownblock1' => { 253 => 0x635 },
	'unknownblock2' => { 253 => 0x636 },
	'unknownblock3' => { 253 => 0x1103 },
	'unknownblock4' => { 253 => 0x1104 },
	'unknowncontrast' => { 97 => 0x45 },
	'unknowndate' => { 311 => 0x212 },
	'unknownev' => { 119 => 0x1 },
	'unknownlinear' => { 97 => 0x46 },
	'unknownnumber' => { 86 => 0x180b },
	'unknownoutputhighlightpoint' => { 97 => 0x4a },
	'unknownoutputshadowpoint' => { 97 => 0x4b },
	'unknownrawhighlight' => { 97 => 0x7b },
	'unknownrawhighlightpoint' => { 97 => 0x48 },
	'unknownrawshadow' => { 97 => 0x84 },
	'unknownrawshadowpoint' => { 97 => 0x49 },
	'unknownsharpness' => { 97 => 0x47 },
	'unknowntemperature' => { 107 => 0x4 },
	'unsharp1color' => { 234 => 0x13 },
	'unsharp1halowidth' => { 234 => 0x19 },
	'unsharp1intensity' => { 234 => 0x17 },
	'unsharp1threshold' => { 234 => 0x1b },
	'unsharp2color' => { 234 => 0x2e },
	'unsharp2halowidth' => { 234 => 0x34 },
	'unsharp2intensity' => { 234 => 0x32 },
	'unsharp2threshold' => { 234 => 0x36 },
	'unsharp3color' => { 234 => 0x49 },
	'unsharp3halowidth' => { 234 => 0x4f },
	'unsharp3intensity' => { 234 => 0x4d },
	'unsharp3threshold' => { 234 => 0x51 },
	'unsharp4color' => { 234 => 0x64 },
	'unsharp4halowidth' => { 234 => 0x6a },
	'unsharp4intensity' => { 234 => 0x68 },
	'unsharp4threshold' => { 234 => 0x6c },
	'unsharpcount' => { 234 => 0x0 },
	'unsharpmask' => { 97 => 0x90, 229 => 0x76a43200 },
	'unsharpmaskfineness' => { 91 => 0x20309 },
	'unsharpmaskstrength' => { 91 => 0x20308 },
	'unsharpmaskthreshold' => { 91 => 0x2030a },
	'uprightcentermode' => { 398 => 'UprightCenterMode' },
	'uprightcenternormx' => { 398 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 398 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 398 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 398 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 398 => 'UprightFocalMode' },
	'uprightpreview' => { 398 => 'UprightPreview' },
	'uprighttransform_0' => { 398 => 'UprightTransform_0' },
	'uprighttransform_1' => { 398 => 'UprightTransform_1' },
	'uprighttransform_2' => { 398 => 'UprightTransform_2' },
	'uprighttransform_3' => { 398 => 'UprightTransform_3' },
	'uprighttransform_4' => { 398 => 'UprightTransform_4' },
	'uprighttransformcount' => { 398 => 'UprightTransformCount' },
	'uprightversion' => { 398 => 'UprightVersion' },
	'urgency' => { 113 => 0xa, 410 => 'Urgency' },
	'url' => { 136 => 'URL', 261 => 'URL', 316 => 0x40b, 413 => 'url' },
	'urla-platform' => { 413 => [\'url','urlA-platform'] },
	'urlurl' => { 413 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 73 => 0x10a },
	'usableshootingmodes' => { 73 => 0x109 },
	'usage' => { 414 => 'usage' },
	'usageterms' => { 427 => 'UsageTerms' },
	'useguidelines' => { 395 => 'useGuidelines' },
	'usepanoramaviewer' => { 387 => 'UsePanoramaViewer' },
	'usercomment' => { 86 => 0x805, 105 => 0x9286, 402 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 61 => 0xd8, 62 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 61 => 0xda, 62 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 61 => 0xdc, 62 => 0xf4 },
	'userfields' => { 390 => 'UserFields' },
	'userlabel' => { 323 => 0x2b },
	'userprofile' => { 265 => 0x302, 271 => 0x3038 },
	'usmlenselectronicmf' => { 72 => 0x7, 73 => 0x501 },
	'uspsnumber' => { 413 => 'uspsNumber' },
	'utmeasting' => { 147 => 'Easting' },
	'utmmapdatum' => { 147 => 'Datum' },
	'utmnorthing' => { 147 => 'Northing' },
	'utmzone' => { 147 => 'Zone' },
	'uv-irfiltercorrection' => { 265 => 0x325 },
	'validbits' => { 253 => 0x611, 254 => 0x102c },
	'validpixeldepth' => { 257 => 0x611 },
	'variousmodes' => { 121 => 0x26 },
	'variousmodes2' => { 121 => 0x3a },
	'variprogram' => { 193 => 0xab },
	'version' => { 110 => 0x0, 318 => 'Version', 398 => 'Version' },
	'versioncreatedate' => { 383 => 0xd100 },
	'versionid' => { 424 => 'VersionID' },
	'versionidentifier' => { 413 => 'versionIdentifier' },
	'versionmodifydate' => { 383 => 0xd101 },
	'versions' => { 424 => 'Versions' },
	'versionscomments' => { 424 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 424 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 424 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 424 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 424 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 424 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 424 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 424 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 424 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 424 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 424 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 236 => '3.2', 237 => '47.2' },
	'verticalfuncbutton' => { 237 => '42.2' },
	'verticalfuncbuttonplusdials' => { 237 => '43.1' },
	'verticalmultiselector' => { 237 => '42.1' },
	'vfdisplayillumination' => { 73 => 0x510 },
	'vibrance' => { 391 => 'Vibrance', 398 => 'Vibrance' },
	'vibrationreduction' => { 200 => [0x75,0x82,0x1ae], 208 => '586.1', 215 => '590.2', 220 => 0x4 },
	'videoalphamode' => { 423 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 423 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 423 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 423 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 58 => 0x74 },
	'videocolorspace' => { 423 => 'videoColorSpace' },
	'videocompressor' => { 423 => 'videoCompressor' },
	'videofieldorder' => { 423 => 'videoFieldOrder' },
	'videoframerate' => { 423 => 'videoFrameRate' },
	'videoframesize' => { 423 => 'videoFrameSize' },
	'videoframesizeh' => { 423 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 423 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 423 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 423 => 'videoModDate' },
	'videopixelaspectratio' => { 423 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 423 => 'videoPixelDepth' },
	'videoquality' => { 101 => 0x4003 },
	'viewfinderdisplay' => { 236 => '12.4', 237 => '6.3' },
	'viewfinderwarning' => { 236 => '13.4', 243 => '3.5', 244 => '6.2', 247 => '4.4' },
	'viewfinderwarnings' => { 73 => 0x40a },
	'viewinfoduringexposure' => { 73 => 0x407 },
	'viewingmode' => { 345 => 0x2f, 359 => 0x18 },
	'viewingmode2' => { 345 => [0x85,0x285] },
	'viewpoint' => { 412 => 'viewpoint' },
	'vignetteamount' => { 398 => 'VignetteAmount' },
	'vignettecontrol' => { 193 => 0x2a, 229 => 0x76a43205 },
	'vignettecontrolintensity' => { 229 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 394 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 398 => 'VignetteMidpoint' },
	'vignetting' => { 327 => 0x1011, 333 => 0xa052 },
	'vignettingcorrection' => { 333 => 0xa053, 355 => 0x2011 },
	'vignettingsetting' => { 333 => 0xa054 },
	'visualtechnique' => { 412 => 'visualTechnique' },
	'voicememo' => { 335 => 0x216 },
	'volume' => { 413 => 'volume' },
	'vr_0x66' => { 200 => 0x66 },
	'vrdoffset' => { 55 => 0xd0 },
	'vrmode' => { 220 => 0x6 },
	'wb_bluelevel3500k' => { 163 => 0x19a },
	'wb_bluelevel6500k' => { 163 => 0x18a },
	'wb_bluelevelcustom' => { 163 => 0x18e },
	'wb_bluelevelscloudy' => { 163 => 0x106 },
	'wb_bluelevelsdaylight' => { 163 => 0xea },
	'wb_bluelevelsflash' => { 163 => 0x122 },
	'wb_bluelevelsfluorescent' => { 163 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 163 => 0x254 },
	'wb_bluelevelsshade' => { 163 => 0x176 },
	'wb_bluelevelstungsten' => { 163 => 0xce },
	'wb_gbrglevels' => { 163 => 0xae, 166 => 0x4 },
	'wb_glevel' => { 253 => 0x11f },
	'wb_glevel3000k' => { 253 => 0x113 },
	'wb_glevel3300k' => { 253 => 0x114 },
	'wb_glevel3600k' => { 253 => 0x115 },
	'wb_glevel3900k' => { 253 => 0x116 },
	'wb_glevel4000k' => { 253 => 0x117 },
	'wb_glevel4300k' => { 253 => 0x118 },
	'wb_glevel4500k' => { 253 => 0x119 },
	'wb_glevel4800k' => { 253 => 0x11a },
	'wb_glevel5300k' => { 253 => 0x11b },
	'wb_glevel6000k' => { 253 => 0x11c },
	'wb_glevel6600k' => { 253 => 0x11d },
	'wb_glevel7500k' => { 253 => 0x11e },
	'wb_grbglevels' => { 176 => 0x0 },
	'wb_rbgglevels' => { 173 => 0x0 },
	'wb_rblevels' => { 193 => 0xc, 253 => 0x100 },
	'wb_rblevels1' => { 274 => 0x2 },
	'wb_rblevels2' => { 274 => 0x5 },
	'wb_rblevels3' => { 274 => 0x8 },
	'wb_rblevels3000k' => { 253 => 0x102 },
	'wb_rblevels3300k' => { 253 => 0x103 },
	'wb_rblevels3500k' => { 163 => 0x430 },
	'wb_rblevels3600k' => { 253 => 0x104 },
	'wb_rblevels3900k' => { 253 => 0x105 },
	'wb_rblevels4' => { 274 => 0xb },
	'wb_rblevels4000k' => { 253 => 0x106 },
	'wb_rblevels4300k' => { 253 => 0x107 },
	'wb_rblevels4500k' => { 253 => 0x108 },
	'wb_rblevels4800k' => { 253 => 0x109 },
	'wb_rblevels5' => { 274 => 0xe },
	'wb_rblevels5300k' => { 253 => 0x10a },
	'wb_rblevels6' => { 274 => 0x11 },
	'wb_rblevels6000k' => { 253 => 0x10b },
	'wb_rblevels6500k' => { 163 => 0x420 },
	'wb_rblevels6600k' => { 253 => 0x10c },
	'wb_rblevels7' => { 274 => 0x14 },
	'wb_rblevels7500k' => { 253 => 0x10d },
	'wb_rblevelsauto' => { 257 => 0x110 },
	'wb_rblevelscloudy' => { 163 => 0x3f0, 165 => 0x10, 257 => 0x121 },
	'wb_rblevelscoolwhitef' => { 163 => 0x308, 165 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 257 => 0x132 },
	'wb_rblevelscustom' => { 163 => 0x424 },
	'wb_rblevelscwb1' => { 253 => 0x10e },
	'wb_rblevelscwb2' => { 253 => 0x10f },
	'wb_rblevelscwb3' => { 253 => 0x110 },
	'wb_rblevelscwb4' => { 253 => 0x111 },
	'wb_rblevelsdaylight' => { 163 => [0x3ec,0x528], 165 => 0xc },
	'wb_rblevelsdaylightf' => { 165 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 257 => 0x130 },
	'wb_rblevelsdaywhitef' => { 165 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 257 => 0x131 },
	'wb_rblevelseveningsunlight' => { 257 => 0x124 },
	'wb_rblevelsfineweather' => { 257 => 0x122 },
	'wb_rblevelsflash' => { 163 => [0x3f4,0x304], 165 => 0x18 },
	'wb_rblevelsshade' => { 163 => 0x418, 165 => 0x20, 257 => 0x120 },
	'wb_rblevelstungsten' => { 163 => 0x3e8, 165 => 0x8, 257 => 0x123 },
	'wb_rblevelsunknown' => { 165 => 0x1c },
	'wb_rblevelsused' => { 257 => 0x100 },
	'wb_rblevelswhitef' => { 165 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 257 => 0x133 },
	'wb_redlevel3500k' => { 163 => 0x198 },
	'wb_redlevel6500k' => { 163 => 0x188 },
	'wb_redlevelcustom' => { 163 => 0x18c },
	'wb_redlevelscloudy' => { 163 => 0xf8 },
	'wb_redlevelsdaylight' => { 163 => 0xdc },
	'wb_redlevelsflash' => { 163 => 0x114 },
	'wb_redlevelsfluorescent' => { 163 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 163 => 0x1be },
	'wb_redlevelsshade' => { 163 => 0x168 },
	'wb_redlevelstungsten' => { 163 => 0xc0 },
	'wb_rgbglevels' => { 175 => 0x0 },
	'wb_rgblevels' => { 163 => [0x546,0x96], 266 => 0xd, 267 => 0x413, 271 => 0x3036, 311 => 0x107, 362 => 0x117c, 363 => 0x1180, 364 => 0x115c, 365 => 0x11d8, 366 => 0x11b4, 367 => 0x106c, 368 => 0x264, 369 => 0x264 },
	'wb_rgblevels1' => { 275 => 0x2 },
	'wb_rgblevels2' => { 275 => 0x6 },
	'wb_rgblevels3' => { 275 => 0xa },
	'wb_rgblevels4' => { 275 => 0xe },
	'wb_rgblevels5' => { 275 => 0x12 },
	'wb_rgblevels6' => { 275 => 0x16 },
	'wb_rgblevels7' => { 275 => 0x1a },
	'wb_rggbblacklevels' => { 32 => 0x25 },
	'wb_rggblevels' => { 166 => 0x4, 174 => 0x0 },
	'wb_rggblevelsasshot' => { 34 => 0x0, 35 => 0x19, 36 => 0x22, 37 => 0x3f, 40 => 0x3f, 41 => 0x3f, 42 => 0x3f },
	'wb_rggblevelsauto' => { 32 => 0x1, 34 => 0x5, 35 => 0x1e, 36 => 0x18, 37 => 0x44, 40 => 0x44, 41 => 0x44, 42 => 0x44, 333 => 0xa022 },
	'wb_rggblevelsblack' => { 333 => 0xa028 },
	'wb_rggblevelscloudy' => { 32 => 0xd, 34 => 0x1e, 35 => 0x2d, 36 => 0x31, 37 => 0x58, 40 => 0x71, 41 => 0x8a, 42 => 0x8f, 302 => 0x20f, 310 => 0x14 },
	'wb_rggblevelscustom' => { 32 => 0x1d, 37 => 0x80 },
	'wb_rggblevelscustom1' => { 35 => 0x41 },
	'wb_rggblevelscustom2' => { 35 => 0x46 },
	'wb_rggblevelsdaylight' => { 32 => 0x5, 34 => 0x14, 35 => 0x23, 36 => 0x27, 37 => 0x4e, 40 => 0x67, 41 => 0x80, 42 => 0x85, 302 => 0x20d, 310 => 0x2 },
	'wb_rggblevelsflash' => { 32 => 0x19, 34 => 0x32, 35 => 0x3c, 36 => 0x45, 37 => 0x6c, 40 => 0x85, 41 => 0x9e, 42 => 0xa3, 302 => 0x214, 310 => 0x41 },
	'wb_rggblevelsfluorescent' => { 32 => 0x15, 34 => 0x28, 35 => 0x37, 36 => 0x3b, 37 => 0x62, 40 => 0x7b, 41 => 0x94, 42 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 302 => 0x211, 310 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 310 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 302 => 0x212, 310 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 302 => 0x213, 310 => 0x38 },
	'wb_rggblevelsilluminator1' => { 333 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 333 => 0xa024 },
	'wb_rggblevelskelvin' => { 32 => 0x21, 34 => 0x2d, 36 => 0x40, 37 => 0x67, 40 => 0x80, 41 => 0x99, 42 => 0x9e },
	'wb_rggblevelsmeasured' => { 34 => 0xa, 37 => 0x49, 40 => 0x49, 41 => 0x49, 42 => 0x49 },
	'wb_rggblevelspc1' => { 36 => 0x90, 37 => 0x71 },
	'wb_rggblevelspc2' => { 36 => 0x95, 37 => 0x76 },
	'wb_rggblevelspc3' => { 36 => 0x9a, 37 => 0x7b },
	'wb_rggblevelsshade' => { 32 => 0x9, 34 => 0x19, 35 => 0x28, 36 => 0x2c, 37 => 0x53, 40 => 0x6c, 41 => 0x85, 42 => 0x8a, 302 => 0x20e, 310 => 0xb },
	'wb_rggblevelstungsten' => { 32 => 0x11, 34 => 0x23, 35 => 0x32, 36 => 0x36, 37 => 0x5d, 40 => 0x76, 41 => 0x8f, 42 => 0x94, 302 => 0x210, 310 => 0x1d },
	'wb_rggblevelsuncorrected' => { 333 => 0xa021 },
	'wb_rggblevelsunknown' => { 34 => 0xf, 36 => 0x1d, 40 => 0x4e, 41 => 0x4e, 42 => 0x4e, 310 => 0x53 },
	'wb_rggblevelsunknown10' => { 34 => 0x5f, 36 => 0x72, 40 => 0x9e, 41 => 0x7b, 42 => 0x7b },
	'wb_rggblevelsunknown11' => { 34 => 0x64, 36 => 0x77, 40 => 0xa3, 41 => 0xa3, 42 => 0x80 },
	'wb_rggblevelsunknown12' => { 34 => 0x69, 36 => 0x7c, 40 => 0xa8, 41 => 0xa8, 42 => 0xa8 },
	'wb_rggblevelsunknown13' => { 34 => 0x6e, 36 => 0x81, 40 => 0xad, 41 => 0xad, 42 => 0xad },
	'wb_rggblevelsunknown14' => { 36 => 0x86, 40 => 0xb2, 41 => 0xb2, 42 => 0xb2 },
	'wb_rggblevelsunknown15' => { 36 => 0x8b, 40 => 0xb7, 41 => 0xb7, 42 => 0xb7 },
	'wb_rggblevelsunknown16' => { 36 => 0x9f, 41 => 0xbc, 42 => 0xbc },
	'wb_rggblevelsunknown17' => { 41 => 0xc1, 42 => 0xc1 },
	'wb_rggblevelsunknown18' => { 41 => 0xc6, 42 => 0xc6 },
	'wb_rggblevelsunknown19' => { 41 => 0xcb, 42 => 0xcb },
	'wb_rggblevelsunknown2' => { 34 => 0x37, 36 => 0x4a, 40 => 0x53, 41 => 0x53, 42 => 0x53 },
	'wb_rggblevelsunknown20' => { 41 => 0xd0, 42 => 0xd0 },
	'wb_rggblevelsunknown21' => { 42 => 0xd5 },
	'wb_rggblevelsunknown22' => { 42 => 0xda },
	'wb_rggblevelsunknown23' => { 42 => 0xdf },
	'wb_rggblevelsunknown24' => { 42 => 0xe4 },
	'wb_rggblevelsunknown25' => { 42 => 0xe9 },
	'wb_rggblevelsunknown26' => { 42 => 0xee },
	'wb_rggblevelsunknown27' => { 42 => 0xf3 },
	'wb_rggblevelsunknown28' => { 42 => 0xf8 },
	'wb_rggblevelsunknown29' => { 42 => 0xfd },
	'wb_rggblevelsunknown3' => { 34 => 0x3c, 36 => 0x4f, 40 => 0x58, 41 => 0x58, 42 => 0x58 },
	'wb_rggblevelsunknown30' => { 42 => 0x102 },
	'wb_rggblevelsunknown4' => { 34 => 0x41, 36 => 0x54, 40 => 0x5d, 41 => 0x5d, 42 => 0x5d },
	'wb_rggblevelsunknown5' => { 34 => 0x46, 36 => 0x59, 40 => 0x62, 41 => 0x62, 42 => 0x62 },
	'wb_rggblevelsunknown6' => { 34 => 0x4b, 36 => 0x5e, 40 => 0x8a, 41 => 0x67, 42 => 0x67 },
	'wb_rggblevelsunknown7' => { 34 => 0x50, 36 => 0x63, 40 => 0x8f, 41 => 0x6c, 42 => 0x6c },
	'wb_rggblevelsunknown8' => { 34 => 0x55, 36 => 0x68, 40 => 0x94, 41 => 0x71, 42 => 0x71 },
	'wb_rggblevelsunknown9' => { 34 => 0x5a, 36 => 0x6d, 40 => 0x99, 41 => 0x76, 42 => 0x76 },
	'wb_rggblevelsuserselected' => { 310 => 0x5c },
	'wbadjblueamber' => { 91 => 0x20106 },
	'wbadjbluebalance' => { 235 => 0x8 },
	'wbadjcolortemp' => { 91 => 0x20102, 96 => 0x1a },
	'wbadjlighting' => { 235 => 0x14 },
	'wbadjmagentagreen' => { 91 => 0x20105 },
	'wbadjmode' => { 235 => 0x10 },
	'wbadjredbalance' => { 235 => 0x0 },
	'wbadjrggblevels' => { 91 => 0x20125, 96 => 0x6 },
	'wbadjtemperature' => { 235 => 0x18 },
	'wbadjtint' => { 235 => 0x25 },
	'wbbluelevel' => { 265 => 0x324, 269 => 0x8006, 273 => 0x26 },
	'wbbracketmode' => { 49 => 0x9 },
	'wbbracketshotnumber' => { 163 => 0x2b, 327 => 0x101a },
	'wbbracketvalueab' => { 49 => 0xc },
	'wbbracketvaluegm' => { 49 => 0xd },
	'wbfinetuneactive' => { 96 => 0x24 },
	'wbfinetunesaturation' => { 96 => 0x28 },
	'wbfinetunetone' => { 96 => 0x2c },
	'wbgreenlevel' => { 265 => 0x323, 269 => 0x8005, 273 => 0x25 },
	'wbmediaimagesizesetting' => { 73 => 0x708 },
	'wbmode' => { 165 => 0x4, 254 => 0x1015 },
	'wbredlevel' => { 265 => 0x322, 269 => 0x8004, 273 => 0x24 },
	'wbscale' => { 166 => 0x0 },
	'wbshiftab' => { 65 => 0xc, 269 => 0x46, 284 => 0x10 },
	'wbshiftab_gm' => { 355 => 0x2014 },
	'wbshiftgm' => { 65 => 0xd, 269 => 0x47, 284 => 0x11 },
	'wbtype1' => { 274 => 0x1, 275 => 0x1 },
	'wbtype2' => { 274 => 0x4, 275 => 0x5 },
	'wbtype3' => { 274 => 0x7, 275 => 0x9 },
	'wbtype4' => { 274 => 0xa, 275 => 0xd },
	'wbtype5' => { 274 => 0xd, 275 => 0x11 },
	'wbtype6' => { 274 => 0x10, 275 => 0x15 },
	'wbtype7' => { 274 => 0x13, 275 => 0x19 },
	'webstatement' => { 427 => 'WebStatement' },
	'what' => { 398 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 65 => 0x8, 67 => 0x7, 100 => 0x7, 101 => [0x19,0x2012], 105 => [0xa403,0xfe4e], 110 => 0x1002, 119 => 0x3fc, 120 => 0xfa0d, 121 => 0x40, 157 => 0x3, 158 => 0xe, 159 => 0x4, 160 => 0xb, 162 => 0x115, 193 => 0x5, 219 => 0x7, 265 => 0x304, 269 => 0x3, 271 => 0x3033, 302 => 0x19, 309 => 0x7, 326 => 0x26, 327 => 0x1003, 336 => [0x3c,0x7,0x58], 343 => 0xf, 344 => 0xe, 355 => [0x115,0xb054], 398 => 'WhiteBalance', 402 => 'WhiteBalance' },
	'whitebalance0' => { 153 => 'WhiteBalance0' },
	'whitebalance1' => { 153 => 'WhiteBalance1' },
	'whitebalance2' => { 153 => 'WhiteBalance2', 249 => 0x500 },
	'whitebalanceadj' => { 91 => 0x20101, 96 => 0x18, 229 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 280 => 0x0 },
	'whitebalancebias' => { 101 => 0x2011, 254 => 0x304, 269 => 0x23 },
	'whitebalanceblue' => { 65 => 0x7 },
	'whitebalancebracket' => { 249 => 0x502, 254 => 0x303 },
	'whitebalancebracketing' => { 160 => 0x22, 163 => 0x2c, 354 => 0x2c },
	'whitebalancecomp' => { 257 => 0x1001 },
	'whitebalancefinetune' => { 110 => 0x100a, 160 => 0x38, 162 => 0x112, 193 => 0xb, 327 => 0x1004, 343 => 0x6, 344 => 0x5, 355 => 0x112 },
	'whitebalancemode' => { 302 => 0x1a },
	'whitebalancered' => { 65 => 0x6 },
	'whitebalanceset' => { 283 => 0xa },
	'whitebalancesetting' => { 160 => 0x23, 343 => 0x5, 344 => 0x4, 345 => 0x16, 359 => 0xd },
	'whitebalancetemperature' => { 249 => 0x501 },
	'whiteboard' => { 254 => 0x301 },
	'whitelevel' => { 105 => 0xc61d, 302 => 0x7e },
	'whitepoint' => { 105 => 0x13e, 302 => 0x201, 419 => 'WhitePoint' },
	'whites2012' => { 398 => 'Whites2012' },
	'wideadapter' => { 327 => 0x1017 },
	'widefocuszone' => { 157 => 0x2f },
	'widerange' => { 335 => 0x20f },
	'windowsatom' => { 397 => 'windowsAtom' },
	'windowsatomextension' => { 397 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 397 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 397 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 413 => 'wordCount' },
	'workcolorspace' => { 91 => 0x10200, 96 => 0x270 },
	'worktodo' => { 404 => 'WorkToDo' },
	'worldtimelocation' => { 269 => 0x3a, 302 => 0x22, 308 => '0.1' },
	'writer-editor' => { 113 => 0x7a },
	'x3filllight' => { 336 => 0x12 },
	'xml' => { 117 => 'xml ' },
	'xmp' => { 94 => 0xffff00f6, 106 => 'XMP' },
	'xmptoolkit' => { 420 => 'xmptk' },
	'xpauthor' => { 105 => 0x9c9d },
	'xpcomment' => { 105 => 0x9c9c },
	'xpkeywords' => { 105 => 0x9c9e },
	'xposition' => { 105 => 0x11e },
	'xpsubject' => { 105 => 0x9c9f },
	'xptitle' => { 105 => 0x9c9b },
	'xresolution' => { 105 => 0x11a, 116 => 0x3, 317 => 0x0, 419 => 'XResolution' },
	'xyresolution' => { 109 => 0x3 },
	'yawangle' => { 209 => 0x3513 },
	'ycbcrcoefficients' => { 105 => 0x211, 419 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 105 => 0x213, 419 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 105 => 0x212, 419 => 'YCbCrSubSampling' },
	'yearcreated' => { 121 => 0x10, 130 => 0xc },
	'yield' => { 415 => 'yield' },
	'yposition' => { 105 => 0x11f },
	'yresolution' => { 105 => 0x11b, 116 => 0x5, 317 => 0x4, 419 => 'YResolution' },
	'zonematching' => { 162 => 0x10a, 165 => [0x3a,0x4a], 355 => 0xb024 },
	'zonematchingmode' => { 160 => 0x14 },
	'zonematchingon' => { 159 => 0x75 },
	'zonematchingvalue' => { 343 => 0x1f },
	'zoomedpreviewlength' => { 254 => 0xf05 },
	'zoomedpreviewsize' => { 254 => 0xf06 },
	'zoomedpreviewstart' => { 254 => 0xf04 },
	'zoomsourcewidth' => { 31 => 0x24 },
	'zoomstepcount' => { 252 => 0x300, 254 => 0x100d },
	'zoomtargetwidth' => { 31 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationcorrparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioncorrparams' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filegroupid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileuserid' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplaneafpointsused' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammainfo' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layercomps' => 1,
	'layergroupsenabledid' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemtags' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2016, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
