<?php
/**
 * FIT Examples
 * 
 * $Id: Trigonometry.php 12 2007-08-12 18:34:25Z gerd $
 * 
 * These examples are derived from http://fit.c2.com/ 
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Example
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */

/**
 * Load basic fixture: Column and HelloWorld 
 */
Testing_FIT_Loader::loadClass( 
            'Testing_FIT_Fixture'
            , 'Testing_FIT_Fixture_Column'
            );

/**
 * FIT Examples
 * 
 * @version 0.1.1
 * @package FIT
 * @subpackage Example
 */
class Math_Trigonometry extends Testing_FIT_Fixture_Column
{
    /**
    * number "degree"
    * @var float
    */
    public $degree;
    
    private $infinite   =   1000000;
    private $round      =   3;

    /**
    * calculate sin
    * 
    * This is the same as sin( degree )
    * 
    * @return float
    */
    public function sin() 
    {
        $res    =   sin( deg2rad( $this->degree ) );
        return round( $res, $this->round );
    }
    
    /**
    * calculate cos
    * 
    * This is the same as cos( degree )
    * 
    * @return float
    */
    public function cos() 
    {
        $res    =   cos( deg2rad( $this->degree ) );
        return round( $res, $this->round );
    }
    
    /**
    * calculate tan
    * 
    * This is the same as tan( degree )
    * 
    * @return float
    */
    public function tan() 
    {
        $res    =   tan( deg2rad( $this->degree ) );
        if( $res > $this->infinite ) {
            return 'infinite';
        }
        
        return round( $res, $this->round );
    }
}
?>