<?php
/**
 * FIT Fixture type filter: string
 * 
 * $Id: String.php 6 2007-06-06 07:37:36Z gerd $
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Parser
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */
 
/**
 * FIT Fixture type filter: string
 * 
 * @version 0.1.0
 * @package FIT
 * @subpackage Fixture
 */
class Testing_FIT_TypeFilter_String extends Testing_FIT_TypeFilter
{
   /**
    * name of type
    * @var string
    */
    protected $type = 'string';

   /**
    * compare string with PHP value
    * 
    * @param string $string
    * @param moxes $value
    * @return bool  true if equal, else false
    */
    public function isEqual( $string, $value )
    {
        if( !is_scalar( $value ) && ( $value != null ) ) {
            return false;
        }

        $string = $this->in( $string );
        $value = (string) $value;
        return ( $string == $value );
    }
}
?>