<?php
/**
 * FIT Fixture type filter: integer
 * 
 * $Id: Integer.php 6 2007-06-06 07:37:36Z gerd $
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Parser
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */
 
/**
 * FIT Fixture type filter: integer
 * 
 * @version 0.1.0
 * @package FIT
 * @subpackage Fixture
 */
class Testing_FIT_TypeFilter_Integer extends Testing_FIT_TypeFilter
{
   /**
    * name of type
    * @var string
    */
    protected $type = 'integer';
    
   /**
    * make string representation of value
    * 
    * @param mixed $value
    * @return string 
    */
    public function out( $value ) {
        return strval( $value );
    }
    
   /**
    * parse string to figure out PHP value
    *
    * @param string $cData
    * @return mixed $value
    */
    public function in( $cData ) {    
        return intval( $cData );
    }
}
?>