<?php
/**
 * FIT Fixture type adapter
 * 
 * $Id: TypeFilter.php 12 2007-08-12 18:34:25Z gerd $
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Parser
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */
 
/**
 * FIT Fixture type adapter
 * 
 * @version 0.1.0
 * @package FIT
 * @subpackage Fixture
 */
class Testing_FIT_TypeFilter
{
   /**
    * name of type
    * @var string
    */
    protected $type = 'filter type';
    
   /**
    * alias map to load a proper filter
    * @var array    
    */
    private static $typeAlias   = array(
            '_default'  => 'string',
            'bool'      => 'boolean',
            'int'       => 'integer',
            'double'    => 'float'
        );
    
   /**
    * create a filter object
    *
    * @param string $type variable type
    * @return object filter
    */
    public static function create( $type ) 
    {
        $type   = strtolower( $type );
        
        if( isset( self::$typeAlias[$type] ) ) {
            $type   = self::$typeAlias[$type];
        }
    
        $class  =   'Testing_FIT_TypeFilter_' . ucfirst( $type );
        Testing_FIT_Loader::loadClass( $class );
        
        $a  = new $class();
        return $a;
    }
    
   /**
    * compare string with PHP value
    * 
    * @param string $string
    * @param moxes $value
    * @return string 
    */
    public function isEqual( $string, $value ) 
    {
        $string = $this->in( $string );
        return ( $string == $value );
    }
    
   /**
    * make string representation of value
    * 
    * @param moxes $value
    * @return string 
    */
    public function out( $value ) 
    {
        return strval( $value );
    }
    
   /**
    * parse string to figure out PHP value
    *
    * @param string $cData
    * @return mixes $value
    */
    public function in( $cData ) 
    {
        $cData = str_replace( '&nbsp;', ' ', $cData );
        return trim( $cData );
    }
}
?>