<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * This file is part of the PEAR Testing_DocTest package.
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to the MIT license that is available
 * through the world-wide-web at the following URI:
 * http://opensource.org/licenses/mit-license.php
 *
 * @category  Testing 
 * @package   Testing_DocTest
 * @author    David JEAN LOUIS <izimobil@gmail.com>
 * @copyright 2008 David JEAN LOUIS
 * @license   http://opensource.org/licenses/mit-license.php MIT License 
 * @version   CVS: $Id: RunnerInterface.php 271418 2008-12-17 16:15:04Z izi $
 * @link      http://pear.php.net/package/Testing_DocTest
 * @since     File available since release 0.1.0
 * @filesource
 */

/**
 * DocTest Runner interface.
 * All runners must implement this interface.
 *
 * @category  Testing
 * @package   Testing_DocTest
 * @author    David JEAN LOUIS <izimobil@gmail.com>
 * @copyright 2008 David JEAN LOUIS
 * @license   http://opensource.org/licenses/mit-license.php MIT License 
 * @version   Release: 0.5.0
 * @link      http://pear.php.net/package/Testing_DocTest
 * @since     Class available since release 0.1.0
 */
interface Testing_DocTest_RunnerInterface
{
    // run() {{{

    /**
     * Run the test provided by comparing the expected result with the actual
     * result returned by the test code.
     *
     * @param object $testCase Testing_DocTest_TestCase instance to run.
     *
     * @access public
     * @return void
     * @throws Testing_DocTest_Exception
     */
    public function run(Testing_DocTest_TestCase $testCase);

    // }}}
}
