<?php
/**
 * Unit tests for Payment_Process2 package
 *
 * PHP version 5
 *
 * LICENSE:
 *
 * Copyright (c) 2008, 2009, Daniel O'Connor
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    * The names of the authors may not be used to endorse or promote products
 *      derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @category   HTTP
 * @package    Payment_Process2
 * @author     Daniel O'Connor <daniel.oconnor@valex.com.au>
 * @license    http://opensource.org/licenses/bsd-license.php New BSD License
 * @version    CVS: $Id: Payment_Process2_AuthorizeNetTest.php 277238 2009-03-16 03:24:52Z clockwerx $
 * @link       http://pear.php.net/package/Payment_Process2
 */

require_once 'PHPUnit/Framework/TestCase.php';
require_once 'Payment/Process2.php';
require_once 'HTTP/Request2.php';
require_once 'HTTP/Request2/Adapter/Mock.php';

class Payment_Process2_AuthorizeNetTest extends PHPUnit_Framework_TestCase {

    public function aValidPayment() {
        $object = Payment_Process2_Type::factory('eCheck');
        $object->accountNumber = 1;
        $object->routingCode = 2;
        $object->bankName = "Unit test";

        return $object;
    }

    public function testShouldLoadClassFromFactory() {
        $payment = new Payment_Process2();
        $object = $payment->factory('AuthorizeNet');

        $this->assertTrue($object instanceOf Payment_Process2_AuthorizeNet);
    }


    public function testShouldCompleteTransaction() {

        $mock = new HTTP_Request2_Adapter_Mock();
        $mock->addResponse('HTTP/1.1 200 OK');

        $request = new HTTP_Request2();
        $request->setAdapter($mock);

        $object = Payment_Process2::factory('AuthorizeNet');
        $object->login = 'unit';
        $object->password = 'test';
        $object->action = Payment_Process2::ACTION_NORMAL;
        $object->amount = 1;

        $object->setRequest($request);

        $object->setPayment($this->aValidPayment());

        $result = $object->process();

        $this->assertTrue($result instanceof Payment_Process2_Result_AuthorizeNet);
    }

    public function testShouldFailGracefullyOnFailedTransaction() {

        $response = new HTTP_Request2_Response('HTTP/1.1 200 OK');
        $response->appendBody(file_get_contents(dirname(__FILE__) . '/data/AuthorizeNet/error.html'));

        $mock = new HTTP_Request2_Adapter_Mock();
        $mock->addResponse($response);

        $request = new HTTP_Request2();
        $request->setAdapter($mock);

        $object = Payment_Process2::factory('AuthorizeNet');
        $object->login = 'unit';
        $object->password = 'test';
        $object->amount = 1;
        $object->action = Payment_Process2::ACTION_NORMAL;

        $object->setRequest($request);

        $object->setPayment($this->aValidPayment());

        $result = $object->process();

        $this->assertTrue($result instanceof PEAR_Error);
    }


    /*
function __construct($options = false)
function process()
function processCallback()
function getStatus()
function _prepareQueryString()
function _handleName()
    */
}