<?php
/**
 * This file contains the test case for MP3_IDv2_Frame
 * 
 * PHP version 5
 * 
 * Copyright (C) 2006-2007 Alexander Merz
 *
 * LICENSE: This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category  File_Formats
 * @package   MP3_IDv2
 * @author    Alexander Merz <alexander.merz@web.de>
 * @copyright 2007 Alexander Merz
 * @license   http://www.gnu.org/licenses/lgpl.html LGPL 2.1
 * @version   CVS: $Id: MP3_IDv2_FrameTest.php 324821 2012-04-04 22:28:06Z alexmerz $
 * @link      http://pear.php.net/package/MP3_IDv2
 * @since     File available since Release 0.1.5
 */

require_once('MP3/IDv2/Frame.php');

require_once('PHPUnit/Framework/TestCase.php');


/**
 * MP3_IDv2_Frame test case.
 */
class MP3_IDv2_FrameTest extends PHPUnit_Framework_TestCase
{

	/**
	 * @var MP3_IDv2_Frame
	 */
	private $MP3_IDv2_Frame;
	
	/**
	 * Prepares the environment before running a test.
	 */
	protected function setUp()
	{
		parent::setUp();
		$this->MP3_IDv2_Frame = new MP3_IDv2_Frame('WXXX', 'User-defined URL');
		$this->MP3_IDv2_Frame->isCompressed(false);
		$this->MP3_IDv2_Frame->setFlagFileAlterPres(false);
		$this->MP3_IDv2_Frame->setFlagReadOnly(false);
		$this->MP3_IDv2_Frame->setFlagTagAlterPres(false);
		$this->MP3_IDv2_Frame->useCompression(false);
		$this->MP3_IDv2_Frame->setEncryptionMethod(null);
		$this->MP3_IDv2_Frame->useEncryption(false);		
		$this->MP3_IDv2_Frame->useGroupingIdentifier(true);
		$this->MP3_IDv2_Frame->setGroupIdentifier('A');
		$this->MP3_IDv2_Frame->setRawContent("Test\0");
	}

	/**
	 * Cleans up the environment after running a test.
	 */
	protected function tearDown()
	{
		$this->MP3_IDv2_Frame = null;		
		parent::tearDown();
	}

	
	/**
	 * Tests MP3_IDv2_Frame->CreateContent()
	 */
	public function testCreateContent()
	{
		$result = $this->MP3_IDv2_Frame->CreateContent();
		$this->assertEquals("Test\0", $result);		
	}
	
	/**
	 * Tests MP3_IDv2_Frame->CreateFrame()
	 */
	public function testCreateFrame()
	{
		$result = $this->MP3_IDv2_Frame->createFrame();		
		$this->assertEquals("WXXX\0\0\0".chr(6)."\0".chr(32)."ATest\0", $result);;		
	}
	
	/**
	 * Tests MP3_IDv2_Frame->CreateHeader()
	 */
	public function testCreateHeader()
	{
		$result = $this->MP3_IDv2_Frame->CreateHeader();
		$this->assertEquals("WXXX\0\0\0".chr(6)."\0".chr(32).'A', $result);
		
	}
	
	/**
	 * Tests MP3_IDv2_Frame->GetEncryptionMethod()
	 */
	public function testGetEncryptionMethod()
	{
		$result = $this->MP3_IDv2_Frame->getEncryptionMethod();
		$this->assertEquals('', $result);		
	}
	
	/**
	 * Tests MP3_IDv2_Frame->GetGroupIdentifier()
	 */
	public function testGetGroupIdentifier()
	{
		$result = $this->MP3_IDv2_Frame->getGroupIdentifier();		
		$this->assertEquals('A', $result);
	}
	
	/**
	 * Tests MP3_IDv2_Frame->GetId()
	 */
	public function testGetId()
	{
		$result = $this->MP3_IDv2_Frame->getId();
		$this->assertEquals('WXXX', $result);		
	}
	
	/**
	 * Tests MP3_IDv2_Frame::GetInstance()
	 */
	public function testGetInstance()
	{
		$apicFrame = MP3_IDv2_Frame::getInstance('APIC');
		$this->assertTrue($apicFrame instanceof MP3_IDv2_Frame_APIC);		
	}

    /**
     * Tests MP3_IDv2_Frame::GetInstance()
     * 
     * without a given type
     */
    public function testGetInstanceEmpty()
    {
        $apicFrame = MP3_IDv2_Frame::getInstance();
        $this->assertTrue($apicFrame instanceof MP3_IDv2_Frame);      
    }	
	
    /**
     * Tests MP3_IDv2_Frame::GetInstance()
     * 
     * with a non existing frame type
     */
    public function testGetInstanceFail()
    {
        $apicFrame = MP3_IDv2_Frame::getInstance('____');
        $this->assertTrue($apicFrame instanceof MP3_IDv2_Frame);        
    }
	
	
	/**
	 * Tests MP3_IDv2_Frame->GetPurpose()
	 */
	public function testGetPurpose()
	{
		$result = $this->MP3_IDv2_Frame->getPurpose();
		$this->assertEquals('User-defined URL', $result);		
	}
	
	/**
	 * Tests MP3_IDv2_Frame->GetRawContent()
	 */
	public function testGetRawContent()
	{
		$result = $this->MP3_IDv2_Frame->getRawContent();
		$this->assertEquals("Test\0", $result);		
	}
	
	/**
	 * Tests MP3_IDv2_Frame->HasGroupingIdentifier()
	 */
	public function testHasGroupingIdentifier()
	{
		$result = $this->MP3_IDv2_Frame->hasGroupingIdentifier();
		$this->assertTrue($result);		
	}
	
	/**
	 * Tests MP3_IDv2_Frame->IsCompressed()
	 */
	public function testIsCompressed()
	{
		$result = $this->MP3_IDv2_Frame->IsCompressed();
        $this->assertFalse($result);				
	}
	
	/**
	 * Tests MP3_IDv2_Frame->IsEncrypted()
	 */
	public function testIsEncrypted()
	{		
		$result = $this->MP3_IDv2_Frame->IsEncrypted();
		$this->assertFalse($result);
		
	}
	
	/**
	 * Tests MP3_IDv2_Frame->IsFlagFileAlterPres()
	 */
	public function testIsFlagFileAlterPres()
	{
		$result = $this->MP3_IDv2_Frame->IsFlagFileAlterPres();
		$this->assertFalse($result);
	}
	
	/**
	 * Tests MP3_IDv2_Frame->IsFlagReadOnly()
	 */
	public function testIsFlagReadOnly()
	{
		$result = $this->MP3_IDv2_Frame->IsFlagReadOnly(/* parameters */);
		$this->assertFalse($result);
		
	}
	
	/**
	 * Tests MP3_IDv2_Frame->IsFlagTagAlterPres()
	 */
	public function testIsFlagTagAlterPres()
	{
        $result = $this->MP3_IDv2_Frame->IsFlagTagAlterPres(/* parameters */);
		$this->assertFalse($result);
	}
		
	
	/**
	 * Tests MP3_IDv2_Frame->ToString()
	 */
	public function testToString()
	{
		$result = $this->MP3_IDv2_Frame->toString();
		$this->assertEquals('WXXX', $result);		
	}
		
}

