<?php
/**
 * This file contains an example for using all frames
 * 
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   File Formats      
 * @package    MP3_IDv2
 * @author     Alexander Merz <alexander.merz@web.de>
 * @copyright  2005 The PHP Group
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id: mp3testall.php 194432 2005-08-26 10:46:52Z alexmerz $
 * @link       http://pear.php.net/package/MP3_IDv2
 * @since      File available since Release 0.1
 */


/**
* This example creates an 'empty' MP3 file with
* all kinds of frames supported by MP3_IDv2 currently
*
* To test the APIC frame you need an arbitrary JPEG file named test.jpg
*/


require_once 'PEAR.php';
require_once 'MP3/IDv2/Reader.php';
require_once 'MP3/IDv2/Writer.php';
require_once 'MP3/IDv2/Tag.php';
require_once 'MP3/IDv2/Frame.php';

require_once 'MP3/IDv2/Frame/APIC.php';
require_once 'MP3/IDv2/Frame/IPLS.php';
require_once 'MP3/IDv2/Frame/PCNT.php';
require_once 'MP3/IDv2/Frame/MCDI.php';
require_once 'MP3/IDv2/Frame/POPM.php';
require_once 'MP3/IDv2/Frame/PRIV.php';
require_once 'MP3/IDv2/Frame/RBUF.php';
require_once 'MP3/IDv2/Frame/TALB.php';
require_once 'MP3/IDv2/Frame/TBPM.php';
require_once 'MP3/IDv2/Frame/TCOM.php';
require_once 'MP3/IDv2/Frame/TCON.php';
require_once 'MP3/IDv2/Frame/TCOP.php';
require_once 'MP3/IDv2/Frame/TDAT.php';
require_once 'MP3/IDv2/Frame/TDLY.php';
require_once 'MP3/IDv2/Frame/TENC.php';
require_once 'MP3/IDv2/Frame/TEXT.php';
require_once 'MP3/IDv2/Frame/TFLT.php';
require_once 'MP3/IDv2/Frame/TIME.php';
require_once 'MP3/IDv2/Frame/TIT1.php';
require_once 'MP3/IDv2/Frame/TIT2.php';
require_once 'MP3/IDv2/Frame/TIT3.php';
require_once 'MP3/IDv2/Frame/TKEY.php';
require_once 'MP3/IDv2/Frame/TLAN.php';
require_once 'MP3/IDv2/Frame/TLEN.php';
require_once 'MP3/IDv2/Frame/TMED.php';
require_once 'MP3/IDv2/Frame/TOAL.php';
require_once 'MP3/IDv2/Frame/TOFN.php';
require_once 'MP3/IDv2/Frame/TOLY.php';
require_once 'MP3/IDv2/Frame/TOPE.php';
require_once 'MP3/IDv2/Frame/TORY.php';
require_once 'MP3/IDv2/Frame/TOWN.php';
require_once 'MP3/IDv2/Frame/TPE1.php';
require_once 'MP3/IDv2/Frame/TPE2.php';
require_once 'MP3/IDv2/Frame/TPE3.php';
require_once 'MP3/IDv2/Frame/TPE4.php';
require_once 'MP3/IDv2/Frame/TPOS.php';
require_once 'MP3/IDv2/Frame/TPUB.php';
require_once 'MP3/IDv2/Frame/TRCK.php';
require_once 'MP3/IDv2/Frame/TRDA.php';
require_once 'MP3/IDv2/Frame/TRSN.php';
require_once 'MP3/IDv2/Frame/TRSO.php';
require_once 'MP3/IDv2/Frame/TSIZ.php';
require_once 'MP3/IDv2/Frame/TSRC.php';
require_once 'MP3/IDv2/Frame/TSSE.php';
require_once 'MP3/IDv2/Frame/TXXX.php';
require_once 'MP3/IDv2/Frame/TYER.php';
require_once 'MP3/IDv2/Frame/UFID.php';
require_once 'MP3/IDv2/Frame/USER.php';
require_once 'MP3/IDv2/Frame/USLT.php';
require_once 'MP3/IDv2/Frame/WCOM.php';
require_once 'MP3/IDv2/Frame/WCOP.php';
require_once 'MP3/IDv2/Frame/WOAF.php';
require_once 'MP3/IDv2/Frame/WOAR.php';
require_once 'MP3/IDv2/Frame/WOAS.php';
require_once 'MP3/IDv2/Frame/WORS.php';
require_once 'MP3/IDv2/Frame/WPAY.php';
require_once 'MP3/IDv2/Frame/WPUB.php';
require_once 'MP3/IDv2/Frame/WXXX.php';

@unlink("all.mp3");

$tag = new MP3_IDv2_Tag();

$fAPIC = new MP3_IDv2_Frame_APIC();
$fAPIC->readFromFile("test.jpg");
$fAPIC->setMimeType("image/jpeg");
$fAPIC->setType(3);
$fAPIC->setDescription("This is the CD frontcover");

$fIPLS = new MP3_IDv2_Frame_IPLS();
$fIPLS->setText("Involved people, the list");

$fMCDI = new MP3_IDv2_Frame_MCDI();
$fMCDI->setMCDI("mcdi_unknown");

$fPCNT = new MP3_IDv2_Frame_PCNT();
$fPCNT->setCounter(12);

$fPOPM = new MP3_IDv2_Frame_POPM();
$fPOPM->setEmail("alexander.merz@example.com");
$fPOPM->setCounter(24);
$fPOPM->setRating(12);

$fPRIV = new MP3_IDv2_Frame_PRIV();
$fPRIV->setOwnerId("alexander.merz@example.com");
$fPRIV->setPrivateData("a private frame with private data");

$fRBUF = new MP3_IDv2_Frame_RBUF();
$fRBUF->setBufferSize(255);
$fRBUF->useEmbedding();
$fRBUF->setOffsetToNextTag(16184);

$fTALB = new MP3_IDv2_Frame_TALB();
$fTALB->setText("This is the album title");

$fTBPM = new MP3_IDv2_Frame_TBPM();
$fTBPM->setBPM(200);

$fTCOM = new MP3_IDv2_Frame_TCOM();
$fTCOM->addComposer("Alexander Merz");
$fTCOM->addComposer("Another composer");

$fTCON = new MP3_IDv2_Frame_TCON();
$fTCON->addGenre("13", "My Music");
$fTCON->addGenre("10");

$fTCOP = new MP3_IDv2_Frame_TCOP();
$fTCOP->setText("2005 ");

$fTDAT = new MP3_IDv2_Frame_TDAT();
$fTDAT->setText("2005");

$fTDLY = new MP3_IDv2_Frame_TDLY();
$fTDLY->setText("60");

$fTENC = new MP3_IDv2_Frame_TENC();
$fTENC->setText("Encoded by myself");

$fTEXT = new MP3_IDv2_Frame_TEXT();
$fTEXT->addTexter("The lyricist");
$fTEXT->addTexter("Another texter");

$fTFLT = new MP3_IDv2_Frame_TFLT();
$fTFLT->setText("MPG/3");

$fTIME = new MP3_IDv2_Frame_TIME();
$fTIME->setText("1200");

$fTIT1 = new MP3_IDv2_Frame_TIT1();
$fTIT1->setText("Best of Titel-Collection.");

$fTIT2 = new MP3_IDv2_Frame_TIT2();
$fTIT2->setText("The title is: Everybody sings!");

$fTIT3 = new MP3_IDv2_Frame_TIT3();
$fTIT3->setText("Die Weltrevolution beginnt im Foyer des WDR.");

$fTKEY = new MP3_IDv2_Frame_TKEY();
$fTKEY->setText("Cbm");

$fTLAN = new MP3_IDv2_Frame_TLAN();
$fTLAN->setText("deu");

$fTLEN = new MP3_IDv2_Frame_TLEN();
$fTLEN->setText("3:56");

$fTMED = new MP3_IDv2_Frame_TMED();
$fTMED->setText("(MC/III)");

$fTOAL = new MP3_IDv2_Frame_TOAL();
$fTOAL->setText("The original album titel");

$fTOFN = new MP3_IDv2_Frame_TOFN();
$fTOFN->setText("all_my_frames.mp3");

$fTOLY = new MP3_IDv2_Frame_TOLY();
$fTOLY->addTexter("The original lyricist");
$fTOLY->addTexter("The other forgotten one");

$fTOPE = new MP3_IDv2_Frame_TOPE();
$fTOPE->addArtist("I'm the original performer");
$fTOPE->addArtist("You not");

$fTORY = new MP3_IDv2_Frame_TORY();
$fTORY->setText("1964");

$fTOWN = new MP3_IDv2_Frame_TOWN();
$fTOWN->setText("Alexander 'My Stuff' Merz");

$fTPE1 = new MP3_IDv2_Frame_TPE1();
$fTPE1->addArtist("The leader - Der Dieter");
$fTPE1->addArtist("The performer - Der Thomas");
$fTPE1->addArtist("The group - Die Cherry Lady");

$fTPE2 = new MP3_IDv2_Frame_TPE2();
$fTPE2->setText("Blue System Band");

$fTPE3 = new MP3_IDv2_Frame_TPE3();
$fTPE3->setText("Mr. Vip Conductor");

$fTPE4 = new MP3_IDv2_Frame_TPE4();
$fTPE4->setText("Von Karel Interpreter");

$fTPOS = new MP3_IDv2_Frame_TPOS();
$fTPOS->setText("1");

$fTPUB = new MP3_IDv2_Frame_TPUB();
$fTPUB->setText("The music publisher");

$fTRCK = new MP3_IDv2_Frame_TRCK();
$fTRCK->setText("1/32");

$fTRDA = new MP3_IDv2_Frame_TRDA();
$fTRDA->setText("12th May - 17th May");

$fTRSN = new MP3_IDv2_Frame_TRSN();
$fTRSN->setText("Radio Free GEMA!");

$fTRSO = new MP3_IDv2_Frame_TRSO();
$fTRSO->setText("GEMA owns no radiostation");

$fTSIZ = new MP3_IDv2_Frame_TSIZ();
$fTSIZ->setText("32368");

$fTSRC = new MP3_IDv2_Frame_TSRC();
$fTSRC->setText("DE0000500000");

$fTSSE = new MP3_IDv2_Frame_TSSE();
$fTSSE->setText("Audiograbber 1.83.01, LAME dll 3.96, VBR 0 (Default method), Stereo, High quality");

$fTXXX = new MP3_IDv2_Frame_TXXX();
$fTXXX->setDescription("My text frame");
$fTXXX->setValue("The content of my text frame");

$fTYER = new MP3_IDv2_Frame_TYER();
$fTYER->setText("2005");

$fUFID = new MP3_IDv2_Frame_UFID();
$fUFID->setOwnerIdentifier("http://www.id3.org/dummy/ufid.html");
$fUFID->setFileIdentifier("xxxxxxxxxxxx");

$fUSER = new MP3_IDv2_Frame_USER();
$fUSER->setLanguage("eng");
$fUSER->setTermsOfUse("Pay as much as you can and you get nothing");

$fUSLT = new MP3_IDv2_Frame_USLT();
$fUSLT->setLanguage("eng");
$fUSLT->setDescription("This are the unsynch lyrics");
$fUSLT->setLyrics("Strangers in the night\nExchanging glances");

$fWCOM = new MP3_IDv2_Frame_WCOM();
$fWCOM->setUrl("http://www.example.com/shop");

$fWCOP = new MP3_IDv2_Frame_WCOP();
$fWCOP->setUrl("http://www.example.com/copyright");

$fWOAF = new MP3_IDv2_Frame_WOAF();
$fWOAF->setUrl("http://www.example.com/audiofile");

$fWOAR = new MP3_IDv2_Frame_WOAR();
$fWOAR->setUrl("http://www.example.com/artist");

$fWOAS = new MP3_IDv2_Frame_WOAS();
$fWOAS->setUrl("http://www.example.com/audiosource");

$fWORS = new MP3_IDv2_Frame_WORS();
$fWORS->setUrl("http://www.example.com/radiostation");

$fWPAY = new MP3_IDv2_Frame_WPAY();
$fWPAY->setUrl("http://www.example.com/payment");

$fWPUB = new MP3_IDv2_Frame_WPUB();
$fWPUB->setUrl("http://www.example.com/publisher");

$fWXXX = new MP3_IDv2_Frame_WXXX();
$fWXXX->setDescription("My URL-Frame");
$fWXXX->setUrl("http://www.example.com/myurl");

$tag->addFrame($fRBUF);
$tag->addFrame($fPRIV);
$tag->addFrame($fIPLS);
$tag->addFrame($fMCDI);
$tag->addFrame($fPCNT);
$tag->addFrame($fPOPM);
$tag->addFrame($fAPIC);
$tag->addFrame($fTALB);
$tag->addFrame($fTBPM);
$tag->addFrame($fTCOM);
$tag->addFrame($fTCON);
$tag->addFrame($fTCOP);
$tag->addFrame($fTDAT);
$tag->addFrame($fTDLY);
$tag->addFrame($fTENC);
$tag->addFrame($fTEXT);
$tag->addFrame($fTFLT);
$tag->addFrame($fTIME);
$tag->addFrame($fTIT1);
$tag->addFrame($fTIT2);
$tag->addFrame($fTIT3);
$tag->addFrame($fTKEY);
$tag->addFrame($fTLAN);
$tag->addFrame($fTLEN);
$tag->addFrame($fTMED);
$tag->addFrame($fTOAL);
$tag->addFrame($fTOFN);
$tag->addFrame($fTOLY);
$tag->addFrame($fTOPE);
$tag->addFrame($fTORY);
$tag->addFrame($fTOWN);
$tag->addFrame($fTPE1);
$tag->addFrame($fTPE2);
$tag->addFrame($fTPE3);
$tag->addFrame($fTPE4);
$tag->addFrame($fTPOS);
$tag->addFrame($fTPUB);
$tag->addFrame($fTRCK);
$tag->addFrame($fTRDA);
$tag->addFrame($fTRSN);
$tag->addFrame($fTSIZ);
$tag->addFrame($fTSRC);
$tag->addFrame($fTRSO);
$tag->addFrame($fTSSE);
$tag->addFrame($fTXXX);
$tag->addFrame($fTYER);
$tag->addFrame($fUFID);
$tag->addFrame($fUSER);
$tag->addFrame($fUSLT);
$tag->addFrame($fWCOM);
$tag->addFrame($fWCOP);
$tag->addFrame($fWOAF);
$tag->addFrame($fWOAR);
$tag->addFrame($fWOAS);
$tag->addFrame($fWORS);
$tag->addFrame($fWPAY);
$tag->addFrame($fWPUB);
$tag->addFrame($fWXXX);

echo "Write ...";
$writer = new MP3_IDv2_Writer();
$writer->addTag($tag);
$writer->write("all.mp3");
echo "... finished\n";

echo "Read ...\n" ;
$reader = new MP3_IDv2_Reader();
$reader->read("all.mp3");
$rtag = $reader->getTag();
$frames = $tag->getFrames();
foreach($frames as $f) {
    echo $f->toString();
    echo "\n";
}
echo "...finished";

?>
