<?php
// Call HTML_Template_PHPLIBTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD')) {
    define('PHPUnit_MAIN_METHOD', 'HTML_Template_PHPLIBTest::main');
}

require_once dirname(__FILE__) . '/helper.inc';

chdir(dirname(__FILE__) . '/../');
require_once 'HTML/Template/PHPLIB.php';

/**
 * Test class for HTML_Template_PHPLIB.
 * Generated by PHPUnit on 2007-07-08 at 11:59:46.
 */
class HTML_Template_PHPLIBTest extends PHPUnit_Framework_TestCase
{
    /**
     * Template object, initialized at setUp()
     *
     * @var HTML_Template_PHPLIB
     */
    protected $tpl = null;



    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once 'PHPUnit/TextUI/TestRunner.php';

        $suite  = new PHPUnit_Framework_TestSuite('HTML_Template_PHPLIBTest');
        PHPUnit_TextUI_TestRunner::run($suite);
    }



    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
        chdir(dirname(__FILE__) . '/');
        $this->tpl = new HTML_Template_PHPLIB('templates');
        $this->tpl->haltOnError = 'no';
        $this->assertFalse($this->tpl->getLastError());
    }



    /**
     *
     */
    public function testSetRoot() {
        $this->assertTrue(
            $this->tpl->setRoot(dirname(__FILE__) . '/templates')
        );
        $this->assertTrue(
            $this->tpl->setFile('testfile', 'simple.tpl')
        );
        $this->assertFalse(
            $this->tpl->setFile('testfile', 'templates/simple.tpl')
        );

        $this->setUp();
        $this->assertTrue(
            $this->tpl->setRoot(dirname(__FILE__))
        );
        $this->assertTrue(
            $this->tpl->setFile('testfile', 'templates/simple.tpl')
        );
        $this->assertFalse(
            $this->tpl->setFile('testfile', 'simple.tpl')
        );
    }

    /**
     *
     */
    public function testSetUnknowns() {
        $this->assertNull(
            $this->tpl->setUnknowns('remove')
        );
        $this->tpl->setFile('testfile2', 'simple2.tpl');
        $this->tpl->parse('TMP', 'testfile2');
        $this->assertEquals(
            ' ',
            $this->tpl->get('TMP')
        );

        $this->assertNull(
            $this->tpl->setUnknowns('keep')
        );
        $this->tpl->setFile('testfile2', 'simple2.tpl');
        $this->tpl->parse('TMP', 'testfile2');
        $this->assertEquals(
            '{HELLO} {WORLD}',
            $this->tpl->get('TMP')
        );


        $this->assertNull(
            $this->tpl->setUnknowns('comment')
        );
        $this->tpl->setFile('testfile2', 'simple2.tpl');
        $this->tpl->parse('TMP', 'testfile2');
        $this->assertNotEquals(
            '{HELLO} {WORLD}',
            $this->tpl->get('TMP')
        );
        $this->assertNotEquals(
            ' ',
            $this->tpl->get('TMP')
        );
    }

    /**
     *
     */
    public function testSetFile() {
        $this->assertTrue(
            $this->tpl->setFile('testfile', 'simple.tpl')
        );
        $this->assertFalse($this->tpl->getLastError());

        $this->assertTrue(
            $this->tpl->setFile('testfile', 'simple2.tpl')
        );
        $this->assertFalse($this->tpl->getLastError());

        $this->assertFalse(
            $this->tpl->setFile('bugfile', 'doesnotexist.tpl')
        );
        $this->assertTrue($this->tpl->getLastError() !== false);

        //multiple files
        $this->setUp();
        $this->assertTrue(
            $this->tpl->setFile(array(
                'testfile'  => 'simple.tpl',
                'testfile2' => 'simple2.tpl',
            ))
        );
        $this->assertFalse($this->tpl->getLastError());

        //multiple files, with error at last one
        $this->setUp();
        $this->assertFalse(
            $this->tpl->setFile(array(
                'testfile'  => 'simple.tpl',
                'testfile2' => 'simple2.tpl',
                'bugfile'   => 'doesnotexist.tpl'
            ))
        );
        $this->assertTrue($this->tpl->getLastError() !== false);

        //multiple files with error at first - should load others anyway
        $this->setUp();
        $this->assertFalse(
            $this->tpl->setFile(array(
                'bugfile'   => 'doesnotexist.tpl',
                'testfile'  => 'simple.tpl',
                'testfile2' => 'simple2.tpl'
            ))
        );
        $this->assertTrue($this->tpl->getLastError() !== false);
        //this checks internals..
        $this->assertEquals('templates/simple.tpl',  $this->tpl->file['testfile']);
        $this->assertEquals('templates/simple2.tpl', $this->tpl->file['testfile2']);
    }



    /**
     * This should show a bug, but it does not (#12198)
     */
    public function testSetFileMultipleTimes()
    {
        $this->assertTrue(
            $this->tpl->setFile('testfile', 'block.tpl')
        );
        $this->assertTrue(
            $this->tpl->setFile('testfile2', 'block.tpl')
        );
        $this->assertTrue(
            $this->tpl->setBlock('testfile', 'hello_world', 'hello_world_ref')
        );
        $this->tpl->parse('hello_world_ref', 'hello_world');
    }//public function testSetFileMultipleTimes()



    /**
     *
     */
    public function testSetBlock() {
        $this->tpl->setFile('testfile', 'block.tpl');
        $this->assertTrue(
            $this->tpl->setBlock('testfile', 'hello_world', 'hello_world_ref')
        );
        $this->tpl->parse('hello_world_ref', 'hello_world');
        $this->tpl->parse('TMP', 'testfile');
        $this->assertEquals(
            "Hello world\n",
            $this->tpl->get('TMP')
        );

        $this->tpl->parse('hello_world_ref', 'hello_world');
        $this->tpl->parse('TMP', 'testfile');
        $this->assertEquals(
            "Hello world\n",
            $this->tpl->get('TMP')
        );

        $this->tpl->parse('hello_world_ref', 'hello_world', true);
        $this->tpl->parse('TMP', 'testfile');
        $this->assertEquals(
            "Hello world\nHello world\n",
            $this->tpl->get('TMP')
        );


        //nested blocks
        $this->tpl->setFile('testfile', 'block3.tpl');
        $this->assertTrue(
            $this->tpl->setBlock('testfile', 'hello', 'hello_ref')
        );
        $this->assertTrue(
            $this->tpl->setBlock('testfile', 'world', 'world_ref')
        );
        $this->assertTrue(
            $this->tpl->setBlock('testfile', 'hello_world', 'hello_world_ref')
        );
        $this->tpl->parse('hello_ref', 'hello');
        $this->tpl->parse('world_ref', 'world');
        $this->tpl->parse('hello_world_ref', 'hello_world');
        $this->tpl->parse('TMP', 'testfile');
        $this->assertEquals(
            "Hello world\n",
            $this->tpl->get('TMP')
        );
    }

    /**
     *
     */
    public function testSetVar() {
        //plain
        $this->tpl->setFile('testfile', 'simple.tpl');
        $this->assertNull(
            $this->tpl->setVar('WORLD', 'world!')
        );
        $this->tpl->parse('TMP', 'testfile');
        $this->assertEquals(
            'Hello world!',
            $this->tpl->get('TMP')
        );

        $this->assertNull(
            $this->tpl->setVar('WORLD', 'you all...')
        );
        $this->tpl->parse('TMP', 'testfile');
        $this->assertEquals(
            'Hello you all...',
            $this->tpl->get('TMP')
        );

        //array
        $this->tpl->setFile('testfile2', 'simple2.tpl');
        $this->assertNull(
            $this->tpl->setVar(array(
                'HELLO' => 'Hello',
                'WORLD' => 'world!'
            ))
        );
        $this->tpl->parse('TMP', 'testfile2');
        $this->assertEquals(
            'Hello world!',
            $this->tpl->get('TMP')
        );
    }



    public function testExists()
    {
        $this->assertFalse($this->tpl->exists('one'));
        $this->assertFalse($this->tpl->exists('two'));
        $this->assertFalse($this->tpl->exists(array('three', 'four')));

        $this->tpl->setVar('one', '1');
        $this->tpl->setVar('three', '3');
        $this->assertTrue($this->tpl->exists('one'));
        $this->assertFalse($this->tpl->exists('two'));
        $this->assertTrue($this->tpl->exists('three'));
    }



    public function testExistsArray()
    {
        $this->assertFalse($this->tpl->exists(array('three', 'four')));

        $this->tpl->setVar('one', '1');
        $this->tpl->setVar('three', '3');

        $this->assertTrue($this->tpl->exists(array('one')));
        $this->assertTrue($this->tpl->exists(array('one', 'three')));

        $this->assertFalse($this->tpl->exists(array('two')));
        $this->assertFalse($this->tpl->exists(array('one', 'two')));
        $this->assertFalse($this->tpl->exists(array('two', 'three')));
        $this->assertFalse($this->tpl->exists(array('one', 'two', 'three')));
    }



    public function testClearVar()
    {
        $this->tpl->setVar('one', '1');
        $this->tpl->setVar('two', '2');
        $this->tpl->setVar('three', '3');

        $this->tpl->clearVar('two');
        $this->assertTrue($this->tpl->exists('two'));
        $this->assertEquals('1', $this->tpl->getVar('one'));
        $this->assertEquals('',  $this->tpl->getVar('two'));
        $this->assertEquals('3', $this->tpl->getVar('three'));
    }



    public function testClearVarArray()
    {
        $this->tpl->setVar('one', '1');
        $this->tpl->setVar('two', '2');
        $this->tpl->setVar('three', '3');
        $this->tpl->setVar('four', '4');

        $this->tpl->clearVar(array('two', 'four'));

        $this->assertTrue($this->tpl->exists('two'));
        $this->assertTrue($this->tpl->exists('four'));
        $this->assertEquals('1', $this->tpl->getVar('one'));
        $this->assertEquals('',  $this->tpl->getVar('two'));
        $this->assertEquals('3', $this->tpl->getVar('three'));
        $this->assertEquals('',  $this->tpl->getVar('four'));
    }//public function testClearVarArray()



    public function testUnsetVar()
    {
        $this->tpl->setVar('one', '1');
        $this->tpl->setVar('two', '2');
        $this->tpl->setVar('three', '3');

        $this->tpl->unsetVar('two');
        $this->assertFalse($this->tpl->exists('two'));
        $this->assertEquals('1', $this->tpl->getVar('one'));
        $this->assertEquals('',  $this->tpl->getVar('two'));
        $this->assertEquals('3', $this->tpl->getVar('three'));
    }//public function testUnsetVar()



    public function testUnsetVarArray()
    {
        $this->tpl->setVar('one', '1');
        $this->tpl->setVar('two', '2');
        $this->tpl->setVar('three', '3');
        $this->tpl->setVar('four', '4');

        $this->tpl->unsetVar(array('two', 'four'));

        $this->assertFalse($this->tpl->exists('two'));
        $this->assertFalse($this->tpl->exists('four'));
        $this->assertEquals('1', $this->tpl->getVar('one'));
        $this->assertEquals('',  $this->tpl->getVar('two'));
        $this->assertEquals('3', $this->tpl->getVar('three'));
        $this->assertEquals('',  $this->tpl->getVar('four'));
    }//public function testUnsetVarArray()



    public function testIsAbsolute()
    {
        $this->assertTrue($this->tpl->_isAbsolute('/home/user/project/template.tpl'));
        $this->assertTrue($this->tpl->_isAbsolute('C:\\Documents And Settings\\User\\template.tpl'));
        $this->assertFalse($this->tpl->_isAbsolute('templates/file.tpl'));
        $this->assertFalse($this->tpl->_isAbsolute('./templates/file.tpl'));
    }//public function testIsAbsolute()



    public function testIsError()
    {
        $this->assertFalse($this->tpl->isError(true));
        $this->assertFalse($this->tpl->isError('abc'));
        $this->assertFalse($this->tpl->isError(''));

        $this->assertTrue($this->tpl->isError(false));

        require_once 'PEAR.php';
        $this->tpl->haltOnError = 'return';
        $error = PEAR::raiseError('test');
        $this->assertTrue($this->tpl->isError($error));
    }//public function testIsError()



    /**
     * Test "yes" $_haltOnError option
     */
    public function testHaltOnErrorYes()
    {
        //FIXME: implement this when we know how to catch errors
        $this->markTestIncomplete();
    }//public function testHaltOnErrorYes()



    /**
     * Test "no" $_haltOnError option
     */
    public function testHaltOnErrorno()
    {
        $this->tpl->haltOnError = 'no';

        //setRoot
        $this->assertFalse(
            $this->tpl->setRoot('this/dir/should/really/not/exist/anywhere')
        );

        //setFile
        $this->assertFalse(
            $this->tpl->setFile('')
        );
        $this->assertFalse(
            $this->tpl->setFile('abc', 'no/body/has/this/one')
        );
        $this->assertFalse(
            $this->tpl->setFile(
                array(
                    'abc' => 'no/body/has/this/one',
                    'def' => 'no/body/has/this/two',
                )
            )
        );

        //setBlock
        $this->assertFalse(
            $this->tpl->setBlock('no/body/has/this/one', '')
        );

        //subst
        $this->assertFalse(
            $this->tpl->subst('no/body/has/this/one', '')
        );

        //getUndefined
        $this->assertFalse(
            $this->tpl->subst('no/body/has/this/one', '')
        );
    }//public function testHaltOnErrorno()



    /**
     * Test "report" $_haltOnError option
     */
    public function testHaltOnErrorReport()
    {
        $this->tpl->haltOnError = 'report';

        //setRoot
        ob_start();
        $this->assertFalse(
            $this->tpl->setRoot('this/dir/should/really/not/exist/anywhere')
        );
        $this->assertNotEquals('', ob_get_clean());

        //setFile
        ob_start();
        $this->assertFalse(
            $this->tpl->setFile('')
        );
        $this->assertNotEquals('', ob_get_clean());

        ob_start();
        $this->assertFalse(
            $this->tpl->setFile('abc', 'no/body/has/this/one')
        );
        $this->assertNotEquals('', ob_get_clean());

        ob_start();
        $this->assertFalse(
            $this->tpl->setFile(
                array(
                    'abc' => 'no/body/has/this/one',
                    'def' => 'no/body/has/this/two',
                )
            )
        );
        $this->assertNotEquals('', ob_get_clean());

        //setBlock
        ob_start();
        $this->assertFalse(
            $this->tpl->setBlock('no/body/has/this/one', '')
        );
        $this->assertNotEquals('', ob_get_clean());

        //subst
        ob_start();
        $this->assertFalse(
            $this->tpl->subst('no/body/has/this/one', '')
        );
        $this->assertNotEquals('', ob_get_clean());

        //getUndefined
        ob_start();
        $this->assertFalse(
            $this->tpl->subst('no/body/has/this/one', '')
        );
        $this->assertNotEquals('', ob_get_clean());
    }//public function testHaltOnErrorReport()



    /**
     * Test "return" $_haltOnError option
     */
    public function testHaltOnErrorReturn()
    {
        $this->tpl->haltOnError = 'return';

        //setRoot
        $this->assertInstanceOf(
            'PEAR_Error',
            $this->tpl->setRoot('this/dir/should/really/not/exist/anywhere')
        );

        //setFile
        $this->assertInstanceOf(
            'PEAR_Error',
            $this->tpl->setFile('')
        );
        $this->assertInstanceOf(
            'PEAR_Error',
            $this->tpl->setFile('abc', 'no/body/has/this/one')
        );
        $this->assertInstanceOf(
            'PEAR_Error',
            $this->tpl->setFile(
                array(
                    'abc' => 'no/body/has/this/one',
                    'def' => 'no/body/has/this/two',
                )
            )
        );

        //setBlock
        $this->assertInstanceOf(
            'PEAR_Error',
            $this->tpl->setBlock('no/body/has/this/one', '')
        );

        //subst
        $this->assertInstanceOf(
            'PEAR_Error',
            $this->tpl->subst('no/body/has/this/one', '')
        );

        //getUndefined
        $this->assertInstanceOf(
            'PEAR_Error',
            $this->tpl->subst('no/body/has/this/one', '')
        );

    }//public function testHaltOnErrorReturn()

}

// Call HTML_Template_PHPLIBTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'HTML_Template_PHPLIBTest::main') {
    HTML_Template_PHPLIBTest::main();
}
?>
