<?php
/**
 * Console Getopt tests
 *
 * PHP version 5
 *
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * + Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * + Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 * + The names of its contributors may not be used to endorse or promote
 * products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @category  PHP
 * @package   Console_GetoptPlus
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2008 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   SVN: $Id: GetoptTest.php 47 2008-01-10 11:03:38Z mcorne $
 * @link      http://pear.php.net/package/Console_GetoptPlus
 */
// Call tests_GetoptPlus_GetoptTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "tests_GetoptPlus_GetoptTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'Console/GetoptPlus/Getopt.php';

/**
 * Test class for Console_GetoptPlus_Getopt.
 * Generated by PHPUnit_Util_Skeleton on 2007-05-17 at 11:00:39.
 *
 * @category  PHP
 * @package   Console_GetoptPlus
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2008 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   Release:@package_version@
 * @link      http://pear.php.net/package/Console_GetoptPlus
 */
class tests_GetoptPlus_GetoptTest extends PHPUnit_Framework_TestCase
{
    private $getopt;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main()
    {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite = new PHPUnit_Framework_TestSuite("Console_GetoptPlus_GetoptTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp()
    {
        $this->getopt = new Console_GetoptPlus_Getopt();
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown()
    {
    }

    /**
     * Tests readPHPArgv()
     */
    public function testReadPHPArgv()
    {
        global $argv;
        // format: <$argv>, <$_SERVER['argv']>,
        // <$GLOBALS['HTTP_SERVER_VARS']['argv']>, <expected>
        $test = array(// /
            0 => array(array(), null, null, array()),
            1 => array(null, array(), null, array()),
            2 => array(null, null, array(), array()),
            3 => array(null, null, null, 13),
            );

        foreach($test as $idx => $values) {
            list($argv, $_SERVER['argv'], $GLOBALS['HTTP_SERVER_VARS']['argv'], $expected) = $values;
            // process the arguments
            try {
                $result = $this->getopt->readPHPArgv();
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests isOption()
     */
    public function testIsOption()
    {
        // format: <option>, true|false
        $test = array(// /
            // valid options
            0 => array('--foo', true),
            1 => array('-f', true),
            // invalid options
            10 => array('--', false),
            11 => array('-- foo', false),
            12 => array('foo', false),
            13 => array('foo--foo', false),
            14 => array('-', false),
            15 => array('- foo', false),
            16 => array('f', false),
            17 => array('f-f', false),
            );

        foreach($test as $idx => $values) {
            list($option, $expected) = $values;
            // cheks if the option is a valid one
            $isValid = $this->getopt->isOption($option);

            $this->assertEquals($expected, $isValid, 'test #' . $idx);
        }
    }

    /**
     * Tests parseLongOptionsDef()
     */
    public function testParseLongOptionsDef()
    {
        // format: <options definition>, <parsed options or errors>
        $test = array(// /
            // valid options
            0 => array('', array()),
            1 => array(null, array()),
            2 => array(array(), array()),
            3 => array('foo', array('foo' => 'noarg')),
            4 => array(array('foo='), array('foo' => 'mandatory')),
            5 => array(array('foo=='), array('foo' => 'optional')),
            6 => array(// /
                array('foo', 'bar=', 'blah=='),
                array('foo' => 'noarg', 'bar' => 'mandatory', 'blah' => 'optional')),
            // invalid options, in the order errors appear in parseLongOptionsDef()
            10 => array(array('foo==', 'bar', 'foo'), 20),
            11 => array('foo===', 21),
            12 => array('=foo', 21),
            13 => array('==foo', 21),
            14 => array('=foo=bar', 21),
            15 => array('=foo bar', 21),
            16 => array('foo:', 21),
            );

        foreach($test as $idx => $values) {
            list($options, $expected) = $values;
            // parses the options, possibly captures an exception
            try {
                $result = $this->getopt->parseLongOptionsDef($options);
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests parseShortOptionsDef()
     */
    public function testParseShortOptionsDef()
    {
        // format: <options definition>, <parsed options or error>
        $test = array(// /
            // valid options
            0 => array(null, array()),
            1 => array('', array()),
            2 => array('f', array('f' => 'noarg')),
            3 => array('f:', array('f' => 'mandatory')),
            4 => array('f::', array('f' => 'optional')),
            5 => array('fb:c::', array('f' => 'noarg', 'b' => 'mandatory', 'c' => 'optional')),
            // invalid options, in the order errors appear in parseShortOptionsDef()
            10 => array(array('f'), 22),
            11 => array('f::bf', 20),
            12 => array('f:::', 23),
            13 => array(':f', 23),
            14 => array('::f', 23),
            15 => array('f b', 23),
            16 => array('f=', 23),
            );

        foreach($test as $idx => $values) {
            list($options, $expected) = $values;
            // parses the options, possibly captures an exception
            try {
                $result = $this->getopt->parseShortOptionsDef($options);
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests createShorcuts()
     */
    public function testCreateShorcuts()
    {
        // format: <options definition>, <expected shortcuts and ambigous names>
        $test = array(// /
            // valid options
            0 => array(array(), array(array(), array())),
            1 => array(// /
                array('foo' => 'noarg'),
                array(array('f' => 'foo', 'fo' => 'foo', 'foo' => 'foo'), array())),
            2 => array(array('fo' => 'noarg', 'ba' => 'mandatory', 'bl' => 'optional'),
                array(
                    array('f' => 'fo', 'fo' => 'fo', 'ba' => 'ba', 'bl' => 'bl'),
                    array('b' => array('ba', 'bl')),
                    )),
            // invalid options, in the order errors appear in parseLongOptionsDef()
            10 => array(array('fo' => 'noarg', 'ba' => 'mandatory', 'bl' => 'optional', 'b' => 'optional'), 10),

            );
        foreach($test as $idx => $values) {
            list($options, $expected) = $values;
            // creates the shortcuts, possibly captures an exception
            try {
                $result = $this->getopt->createShorcuts($options, 'shortcuts');
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests verifyNoAmbiguity()
     */
    public function testVerifyNoAmbiguity()
    {
        // format: <options definition>, <ambiguity>, <true or an exception>
        $test = array(// /
            // valid options
            0 => array('', 'strict', true),
            1 => array(null, 'strict', true),
            2 => array(array(), 'strict', true),
            3 => array(array('foo' => 'noarg'), 'strict', true),
            4 => array(array('foo' => 'mandatory'), 'strict', true),
            5 => array(array('foo' => 'optional'), 'strict', true),
            6 => array(array('foo' => 'noarg', 'bar' => 'mandatory', 'blah' => 'optional'),
                'strict', true),
            7 => array(array('foo' => 'noarg', 'bar' => 'mandatory', 'blah' => 'optional'),
                'loose', true),
            8 => array(array('foo' => 'noarg', 'bar' => 'mandatory', 'fool' => 'optional'),
                'loose', true),
            // invalid options
            10 => array(array('foo' => 'optional', 'bar' => 'mandatory', 'fool' => 'optional',),
                'loose', 10),
            11 => array(array('foo' => 'noarg', 'bar' => 'mandatory', 'fool' => 'optional',),
                'strict', 10),
            );
        foreach($test as $idx => $values) {
            list($options, $ambiguity, $expected) = $values;
            // verifies there is no name ambiguity, possibly captures an exception
            try {
                $result = $this->getopt->verifyNoAmbiguity($options, $ambiguity);
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertSame($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests process()
     */
    public function testProcess()
    {
        // format: <version>, <arguments>, <short options definition>,
        // <long options definition>, <ambiguity>, <expected options and parameters>
        $test = array(// /
            // valid command
            0 => array(2, array(), '', null, null, array(array(), array())),
            1 => array(2, array('foo'), '', null, null, array(array(), array('foo'))),
            2 => array(2, array('--', '--foo', 'bar'), '', null, null, array(array(), array('--foo', 'bar'))),
            3 => array(2, array('--', '-f', 'bar'), '', null, null, array(array(), array('-f', 'bar'))),
            4 => array(2, array('-', '--foo', 'bar'), '', null, null, array(array(), array('-', '--foo', 'bar'))),
            5 => array(2, array('-', '-f', 'bar'), '', null, null, array(array(), array('-', '-f', 'bar'))),
            6 => array(2, array('--foo'), '', array(), null, array(array(), array('foo'))),
            7 => array(1, array('foo'), '', null, null, array(array(), array())),
            // valid command with 1 long option
            10 => array(2, array('--foo'), '', array('foo'), null, array(array(array('--foo', '')), array())),
            11 => array(2, array('--foo=bar'), '', array('foo='), null, array(array(array('--foo', 'bar')), array())),
            12 => array(2, array('--foo', 'bar'), '', array('foo='), null, array(array(array('--foo', 'bar')), array())),
            13 => array(2, array('--foo', 'bar'), '', array('foo=='), null, array(array(array('--foo', '')), array('bar'))),
            14 => array(2, array('--foo'), '', array('foo=='), null, array(array(array('--foo', '')), array())),
            // valid command with 2 long options
            20 => array(2, array('--foo'), '', array('foo', 'bar'), null, array(array(array('--foo', '')), array())),
            21 => array(2, array('--foo', '--bar'), '', array('foo', 'bar'), null,
                array(array(array('--foo', ''), array('--bar', '')), array())),
            22 => array(2, array('--foo=bar', '--blah'), '', array('foo=', 'blah'), null,
                array(array(array('--foo', 'bar'), array('--blah', '')), array())),
            23 => array(2, array('--foo', 'bar', '--blah'), '', array('foo=', 'blah'), null,
                array(array(array('--foo', 'bar'), array('--blah', '')), array())),
            24 => array(2, array('--foo=bar', '--blah'), '', array('foo==', 'blah'), null,
                array(array(array('--foo', 'bar'), array('--blah', '')), array())),
            25 => array(2, array('--foo', 'bar', '--blah'), '', array('foo==', 'blah'), null,
                array(array(array('--foo', '')), array('bar', '--blah'))),
            // valid command with 1 short option
            30 => array(2, array('-f'), 'f', null, null, array(array(array('f', '')), array())),
            31 => array(2, array('-fbar'), 'f:', '', null, array(array(array('f', 'bar')), array())),
            32 => array(2, array('-f', 'bar'), 'f:', '', null, array(array(array('f', 'bar')), array())),
            33 => array(2, array('-f', 'bar'), 'f::', '', null, array(array(array('f', '')), array('bar'))),
            34 => array(2, array('-f'), 'f::', '', null, array(array(array('f', '')), array())),
            // valid command with 2 short options
            40 => array(2, array('-f'), 'fb', '', null, array(array(array('f', '')), array())),
            41 => array(2, array('-f', '-b'), 'fb', '', null, array(array(array('f', ''), array('b', '')), array())),
            42 => array(2, array('-fbar', '-b'), 'f:b', '', null, array(array(array('f', 'bar'), array('b', '')), array())),
            43 => array(2, array('-f', 'bar', '-b'), 'f:b', '', null, array(array(array('f', 'bar'), array('b', '')), array())),
            44 => array(2, array('-fbar', '-b'), 'f::b', '', null, array(array(array('f', 'bar'), array('b', '')), array())),
            45 => array(2, array('-f', 'bar', '-b'), 'f::b', '', null, array(array(array('f', '')), array('bar', '-b'))),
            46 => array(2, array('-fb', 'bar'), 'fb', '', null, array(array(array('f', ''), array('b', '')), array('bar'))),
            47 => array(2, array('-fb', 'bar'), 'fb:', '', null, array(array(array('f', ''), array('b', 'bar')), array())),
            48 => array(2, array('-fb', 'bar'), 'fb::', '', null, array(array(array('f', ''), array('b', '')), array('bar'))),
            49 => array(2, array('-fbbar'), 'fb::', '', null, array(array(array('f', ''), array('b', 'bar')), array())),
            // valid command with 1 long + 1 short options
            50 => array(2, array('--foo'), 'fb', array('foo', 'bar'), null, array(array(array('--foo', '')), array())),
            51 => array(2, array('--foo', '-b'), 'fb', array('foo', 'bar'), null,
                array(array(array('--foo', ''), array('b', '')), array())),
            52 => array(2, array('--foo=bar', '-b'), 'f:b', array('foo=', 'blah'), null,
                array(array(array('--foo', 'bar'), array('b', '')), array())),
            53 => array(2, array('--foo', 'bar', '-b'), 'f:b', array('foo=', 'blah'), null,
                array(array(array('--foo', 'bar'), array('b', '')), array())),
            54 => array(2, array('--foo=bar', '-b'), 'f::b', array('foo==', 'blah'), null,
                array(array(array('--foo', 'bar'), array('b', '')), array())),
            55 => array(2, array('--foo', 'bar', '-b'), 'f::b', array('foo==', 'blah'), null,
                array(array(array('--foo', '')), array('bar', '-b'))),
            // valid command with 1 short + 1 long options
            60 => array(2, array('-f'), 'fb', array('foo', 'bar'), null, array(array(array('f', '')), array())),
            61 => array(2, array('-f', '--bar'), 'fb', array('foo', 'bar'), null,
                array(array(array('f', ''), array('--bar', '')), array())),
            62 => array(2, array('-f', 'bar', '--blah'), 'f:b', array('foo=', 'blah'), null,
                array(array(array('f', 'bar'), array('--blah', '')), array())),
            63 => array(2, array('-f', 'bar', '--blah'), 'f::b', array('foo==', 'blah'), null,
                array(array(array('f', '')), array('bar', '--blah'))),
            // integration test
            70 => array(2, // /
                array('--foo', '-f', '--bar=1', '-b2', '--cool=3', '-c4', 'abc'),
                'fb:c::', array('foo', 'bar=', 'cool=='), null,
                array(// /
                    array(array('--foo', ''), array('f', ''), array('--bar', '1'),
                        array('b', '2'), array('--cool', '3'), array('c', '4')),
                    array('abc'))),
            71 => array(2, // /
                array('--foo', '-fb2', '--bar', '1', '--cool=3', '-c', 'abc'),
                'fb:c::', array('foo', 'bar=', 'cool=='), null,
                array(// /
                    array(array('--foo', ''), array('f', ''), array('b', '2'),
                        array('--bar', '1'), array('--cool', '3'), array('c', '')),
                    array('abc'))),
            72 => array(2, // /
                array('--foo', '-fb2', '--bar', '1', '--', '--cool=3', '-c', 'abc'),
                'fb:c::', array('foo', 'bar=', 'cool=='), null,
                array(// /
                    array(array('--foo', ''), array('f', ''), array('b', '2'),
                        array('--bar', '1')),
                    array('--cool=3', '-c', 'abc'))),
            73 => array(2, // /
                array('--fo', '-fb2', '--ba', '1', '--co=3', 'abc'),
                'fb:c::', array('foo', 'bar=', 'cool=='), 'shortcuts',
                array(// /
                    array(array('--foo', ''), array('f', ''), array('b', '2'),
                        array('--bar', '1'), array('--cool' , '3')),
                    array('abc'))),
            // invalid options, in the order errors appear
            // in process(), parseLongOption(), parseShortOption()
            80 => array(2, array('--foo'), '', array('bar'), null, 14),
            81 => array(2, array('-f'), '', array(), null, 14),
            82 => array(2, array('-f'), 'b', array(), null, 14),
            83 => array(2, array('--foo'), '', array('foo='), null, 11),
            84 => array(2, array('--foo', '--bar'), '', array('foo=', 'bar'), null, 11),
            85 => array(2, array('--foo', '-b'), 'b', array('foo='), null, 11),
            86 => array(2, array('-f'), 'f:', array(), null, 11),
            87 => array(2, array('-f', '-b'), 'f:b', array(), null, 11),
            88 => array(2, array('-f', '--bar'), 'f:', array('bar'), null, 11),
            89 => array(2, array('--foo=bar'), '', array('foo'), null, 12),
            );
        foreach($test as $idx => $values) {
            list($version, $args, $short, $long, $ambiguity, $expected) = $values;
            // process the arguments
            try {
                $result = $this->getopt->process($args, $short, $long, $ambiguity, $version);
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests doGetopt()
     */
    public function testDoGetopt()
    {
        $result = Console_GetoptPlus_Getopt::doGetopt();
        $this->assertEquals(array(array(), array()), $result);
    }

    /**
     * Tests getopt()
     */
    public function testGetopt()
    {
        $result = Console_GetoptPlus_Getopt::getopt();
        $this->assertEquals(array(array(), array()), $result);
    }

    /**
     * Tests getopt2()
     */
    public function testGetopt2()
    {
        $result = Console_GetoptPlus_Getopt::getopt2();
        $this->assertEquals(array(array(), array()), $result);
    }
}
// Call tests_GetoptPlus_GetoptTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "tests_GetoptPlus_GetoptTest::main") {
    tests_GetoptPlus_GetoptTest::main();
}

?>
