/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.HandlerFactory;
import com.puppycrawl.tools.checkstyle.checks.indentation.PrimordialHandler;
import org.apache.commons.collections.ArrayStack;

public class IndentationCheck
extends Check {
    private static final int DEFAULT_INDENTATION = 4;
    private int mBasicOffset = 4;
    private int mCaseIndentationAmount = 4;
    private int mBraceAdjustment;
    private final ArrayStack mHandlers = new ArrayStack();
    private final HandlerFactory mHandlerFactory = new HandlerFactory();

    public void setBasicOffset(int aBasicOffset) {
        this.mBasicOffset = aBasicOffset;
    }

    public int getBasicOffset() {
        return this.mBasicOffset;
    }

    public void setBraceAdjustment(int aAdjustmentAmount) {
        this.mBraceAdjustment = aAdjustmentAmount;
    }

    public int getBraceAdjustement() {
        return this.mBraceAdjustment;
    }

    public void setCaseIndent(int aAmount) {
        this.mCaseIndentationAmount = aAmount;
    }

    public int getCaseIndent() {
        return this.mCaseIndentationAmount;
    }

    public void indentationLog(int aLine, String aKey, Object[] aArgs) {
        super.log(aLine, aKey, aArgs);
    }

    public int getIndentationTabWidth() {
        return this.getTabWidth();
    }

    public int[] getDefaultTokens() {
        return this.mHandlerFactory.getHandledTypes();
    }

    public void beginTree(DetailAST aAst) {
        this.mHandlerFactory.clearCreatedHandlers();
        this.mHandlers.clear();
        this.mHandlers.push(new PrimordialHandler(this));
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 10 && ScopeUtils.isLocalVariableDef(aAST)) {
            return;
        }
        ExpressionHandler handler = this.mHandlerFactory.getHandler(this, aAST, (ExpressionHandler)this.mHandlers.peek());
        this.mHandlers.push(handler);
        try {
            handler.checkIndentation();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    public void leaveToken(DetailAST aAST) {
        if (aAST.getType() == 10 && ScopeUtils.isLocalVariableDef(aAST)) {
            return;
        }
        this.mHandlers.pop();
    }

    final HandlerFactory getHandlerFactory() {
        return this.mHandlerFactory;
    }
}

