#include "readfile.h"

#undef DEBUG

GraphList getGraphFromFile (char * file, NodeHashTbl * nodehash, Config * config)
{
	FILE * in;
	GraphListNode * current_graphlistnode = NULL;

	in = fopen (file, "r");

	if (in == NULL)
	{
		char * error = "Error opening file with events ('";
		char * errmsg = (char *) malloc (strlen(error) + strlen(file) + 2 + 1);
		sprintf(errmsg, "%s%s')", error, file);
		perror(errmsg);
		exit(0);
	};

	char buffer[BUFSIZE];
	char session[BUFSIZE];
	int timestamp;
	char name[BUFSIZE];

	char * current_session = (char *) calloc (1, sizeof(char)); // so we can free it
	int last_timestamp = 0;
	Node * last_node = NULL;
	Node * current_node = NULL;

#ifdef DEBUG
	fprintf(stderr, "Ignoring refreshes: %d", config->ignore_refresh);
#endif

	/* Start reading line-by-line here */
	while (fgets (buffer, BUFSIZE, in))
	{
		/* ignore any data after the first BUFSIZE characters */
		int num_matches;
		if (num_matches = sscanf(buffer, "%s\t%d\t%[^\n]\n", &session, &timestamp, &name) != 3)
		{
			if ((num_matches == 1) || (num_matches == 2))
			{
				//fprintf(stderr, "Warning: the following line could not be read totally (only %d matches):\n", num_matches);
				//fprintf(stderr, "%s", buffer);
				strcpy(name, "");
			}
			else
			{
				fprintf(stderr, "String could not be parsed: %s (only %d tokens)\n", buffer, num_matches);
				break;
			}
		}

		last_node = current_node;
		current_node = getNode(name, nodehash);

		/* is this a new session? */
		if ((strcmp(session, current_session) != 0) 
				/* or, has this session 'timed out'? (eventsfile must be chronological!) */
				|| ((config->session_timeout > -1) 
					&& (timestamp - last_timestamp > config->session_timeout)))
		{
			free (current_session);
			current_session = strdup(session);
			// TODO maybe check for graphs without edges?
			current_graphlistnode = newGraphListNode(current_graphlistnode, current_node);
		}
		else
		{
			if ((!config->ignore_refresh) // if false, just add the edge
					|| (strcmp(last_node->name, current_node->name) != 0))
			{
				addEdge(current_graphlistnode->graph, last_node, current_node);
			}
		}
		last_timestamp = timestamp;
	}

	fclose(in);
	return current_graphlistnode;
}
