#include "hashtbl.h"

HashTable::HashTable(int n_size)
{
	size = n_size;
	for (int i=0; i<size; i++)
	{
		table[i] = NULL;
	}
}

unsigned int HashTable::HashString (const char * str)
{
	unsigned int retval = 0;
	int length = strlen(str);

	unsigned int top5bits = 0xf8000000;
	unsigned int carry = 0;

	const int kleftmove=5;
	const int krightmove=27;

	for (int i=0; i<length; i++)
	{
		carry = retval & top5bits;
		carry = carry >> krightmove;
		retval = retval << kleftmove;
		retval ^= carry;
		retval ^= str[i];
	}
	return retval;
}

HashNode * HashTable::newHashNode(char * key, void * content, HashNode * next)
{
	HashNode * retval = (HashNode *) malloc (sizeof(HashNode));
	retval->key = key;
	retval->content = content;
	retval->next = next;
	return retval;
}


void HashTable::add(char * key, void * content)
{
	int hkey = HashString (key);
	table[hkey] = newHashNode(key, content, table[hkey]);
}

void * HashTable::get(char * key)
{
	HashNode * current_node = table[HashString (key)];
	while (current_node != NULL)
	{
		if (strcmp(current_node->key, key) == 0)
		{
			return current_node->content;
		}
	}
	return NULL;
}
