#include <assert.h>
#include "graph.h"

#define BUFSIZE 100
#undef DEBUG

/* 
 * a pointer to a struct such as this
 * is passed on to FindTreshold while walking
 */
struct findtreshold_arg
{
	int n_edges;
	int current_treshold;
};

void CountEdges (void * content, void * arg)
{
	findtreshold_arg * args = (findtreshold_arg *) arg;
	AnnotatedEdge * current = (AnnotatedEdge *)content;

	while (current != NULL)
	{
		if (current->n_taken > args->current_treshold)
			args->n_edges++;
		current = current->next;
	}
}

/* try to establish the largest min_edgewidth */
/* where the number of edges remains below max_edgecount */
int FindTreshold(BinaryTree * tree_root, int max_edgecount)
{
	static findtreshold_arg * args = (findtreshold_arg*) malloc (sizeof(findtreshold_arg));
	args->n_edges = -1;
	args->current_treshold=0;

#ifdef DEBUG
	fprintf(stderr, "  Finding treshold. max_edgecount: %d\n", max_edgecount);
#endif
	
	while ((args->n_edges > max_edgecount) || (args->n_edges == -1))
	{
		//AnnotatedEdge * current_edge = start_edge;
		args->n_edges = 0;

		tree_root->walk(CountEdges, args);

		/*while (current_edge != NULL)
		{
			if (current_edge->n_taken > findtreshold_treshold)
				edges++;
			current_edge = current_edge->next;
		}*/

#ifdef DEBUG
		fprintf(stderr, "  With treshold %d, found %d edges.\n", findtreshold_treshold, findtreshold_edges);
#endif

		args->current_treshold++;
	}
	return args->current_treshold-1;
}

struct printedge_arg
{
	int min_edgewidth;
	int max_edgewidth;
};

float GetWidth (float value, float min, float max)
{
	return 0.7 - (((value - min) / (max - min)) * 0.7);
}

void PrintEdge (void * content, void * arg)
{
	printedge_arg * args = (printedge_arg*) arg;
	AnnotatedEdge * current = (AnnotatedEdge *)content;

	while (current != NULL)
	{
		if (current->n_taken > args->min_edgewidth)
		{
			printf("\"%s\" -> \"%s\"[label=%d,color=\"0,0,%f\"];\n", 
					current->from->name,
					current->to->name,
					current->n_taken, GetWidth(current->n_taken, args->min_edgewidth, args->max_edgewidth));
						// 1.0-((float)current->n_taken/args->max_edgewidth*7.0));
			 current->from->used = true;
			 current->to->used = true;
		}
		current = current->next;
	}
}

	
void GenerateDot (FILE * dest, AnnotatedGraph * g, NodeHashTbl * nodehash, Config * config, int max_edgewidth)
{
	
	fprintf(dest, "digraph site_usage {\n");
	//fprintf(dest, "concentrate=true\n");
	fprintf(dest, "size=\"7,10\"\n");
	fprintf(dest, "page=\"8.5,11\"\n");
	fprintf(dest, "rotate=90\n");
	fprintf(dest, "center=\"\";\n");
	fprintf(dest, "node[width=.25,hight=.375,fontsize=9]");
	fprintf(dest, "edge[fontsize=11]");

	printedge_arg * args = (printedge_arg*) malloc (sizeof(printedge_arg));
	args->max_edgewidth = max_edgewidth;

	if (config->min_edgewidth < 0)
	{
		args->min_edgewidth = FindTreshold(g->edgetree, config->max_edgecount);
		fprintf(stderr, "  Chose treshold: %d\n", args->min_edgewidth);
	} else {
		args->min_edgewidth = config->min_edgewidth;
	}

	g->edgetree->walk(PrintEdge, args);

	/*
	AnnotatedEdge * current_edge = g->edges;
				
	while (current_edge != NULL)
	{

		current_edge = current_edge->next;
	}
	*/

	//NodeListNode * current_nodelistnode = nodes;
	for (int hkey=0; hkey < nodehash->size; hkey++)
	{
		HashNode * current_hashnode = nodehash->table[hkey];

		while (current_hashnode != NULL)
		{
			char * shape;
			shape = "ellipse";
			// char color [BUFSIZE];
			// sprintf(color, "white");
	
			if (!current_hashnode->node->used)
			{
				current_hashnode = current_hashnode->next;
				continue;
			}
	
			if ((current_hashnode->node->start > 0)
					&& (current_hashnode->node->end > 0))
			{
				shape = "octagon";
			}
			else if (current_hashnode->node->start > 0)
			{
				shape = "box";
			}
			else if (current_hashnode->node->end > 0)
			{
				// sprintf(color, "\"0,0,0.5\"", current_nodelistnode->node->end/10);
				shape = "diamond";
			}
			
			fprintf(dest, "\"%s\" [shape=%s];\n", 
				current_hashnode->node->name,
				shape);

			current_hashnode = current_hashnode->next;
		}
	}

	fprintf(dest, "}\n");
}
