#include <sys/types.h>
#include <regex.h>

#ifndef CONFIG_H
#define CONFIG_H

/* Set to '0' to disable, for optimization */
#define USE_UNIFY 1
#define USE_IGNORE 1

#if USE_UNIFY
struct unifier 
{
	regex_t * from;
	char * to;
	unifier * next;
};
#endif

#if USE_IGNORE
struct ignorer
{
	regex_t * regexp;
	ignorer * next;
};
#endif

struct Config {
	int min_edgewidth;
	int ignore_refresh;
	int max_edgecount; 
	int session_timeout;

#if USE_IGNORE
	ignorer * ignores;
#endif
#if USE_UNIFY
	unifier * unifiers;
#endif
};

Config * ReadConfig (char * file);

#endif
