# Copyright (c) 2012-2016 DreamWorks Animation LLC
#
# All rights reserved. This software is distributed under the
# Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
#
# Redistributions of source code must retain the above copyright
# and license notice and the following restrictions and disclaimer.
#
# *     Neither the name of DreamWorks Animation nor the names of
# its contributors may be used to endorse or promote products derived
# from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# IN NO EVENT SHALL THE COPYRIGHT HOLDERS' AND CONTRIBUTORS' AGGREGATE
# LIABILITY FOR ALL CLAIMS REGARDLESS OF THEIR BASIS EXCEED US$250.00.
#

#-*-cmake-*-
# - Find GLFW
#
# Author : Nicholas Yue yue.nicholas@gmail.com
#
# This auxiliary CMake file helps in find the GLFW headers and libraries
#
# GLFW_FOUND            set if GLFW is found.
# GLFW_INCLUDE_DIR      GLFW's include directory
# GLFW_glfw_LIBRARY     GLFW libraries

SET ( GLFW_FOUND FALSE )

FIND_PATH( GLFW_LOCATION include/GL/glfw.h
  "$ENV{GLFW_ROOT}"
  NO_SYSTEM_ENVIRONMENT_PATH
  )

SET( GLFW_INCLUDE_DIR "${GLFW_LOCATION}/include" CACHE STRING "GLFW include path")

SET ( ORIGINAL_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})
IF (GLFW_USE_STATIC_LIBS)
  IF (APPLE)
    SET(CMAKE_FIND_LIBRARY_SUFFIXES ".a")
    FIND_LIBRARY ( GLFW_LIBRARY_PATH GLFW PATHS ${GLFW_LOCATION}/lib
      NO_DEFAULT_PATH
      NO_SYSTEM_ENVIRONMENT_PATH
	  )
	MESSAGE ( "APPLE STATIC" )
	MESSAGE ( "GLFW_LIBRARY_PATH = " ${GLFW_LIBRARY_PATH} )
  ELSEIF (WIN32)
    # Link library
    SET(CMAKE_FIND_LIBRARY_SUFFIXES ".lib")
    FIND_LIBRARY ( GLFW_LIBRARY_PATH GLFW32S PATHS ${GLFW_LOCATION}/lib )
  ELSE (APPLE)
    SET(CMAKE_FIND_LIBRARY_SUFFIXES ".a")
    FIND_LIBRARY ( GLFW_LIBRARY_PATH glfw PATHS ${GLFW_LOCATION}/lib ${GLFW_LOCATION}/lib64
      NO_DEFAULT_PATH
      NO_SYSTEM_ENVIRONMENT_PATH
	  )
	MESSAGE ( "LINUX STATIC" )
	MESSAGE ( "GLFW_LIBRARY_PATH = " ${GLFW_LIBRARY_PATH} )
  ENDIF (APPLE)
ELSE ()
  IF (APPLE)
    SET(CMAKE_FIND_LIBRARY_SUFFIXES ".dylib")
    FIND_LIBRARY ( GLFW_LIBRARY_PATH GLFW PATHS ${GLFW_LOCATION}/lib )
  ELSEIF (WIN32)
    # Link library
    SET(CMAKE_FIND_LIBRARY_SUFFIXES ".lib")
    FIND_LIBRARY ( GLFW_LIBRARY_PATH GLFW32 PATHS ${GLFW_LOCATION}/lib )
    # Load library
    SET(CMAKE_FIND_LIBRARY_SUFFIXES ".dll")
    FIND_LIBRARY ( GLFW_DLL_PATH GLFW32 PATHS ${GLFW_LOCATION}/bin
      NO_DEFAULT_PATH
      NO_SYSTEM_ENVIRONMENT_PATH
      )
  ELSE (APPLE)
	# Unices
    FIND_LIBRARY ( GLFW_LIBRARY_PATH glfw PATHS ${GLFW_LOCATION}/lib ${GLFW_LOCATION}/lib64
      NO_SYSTEM_ENVIRONMENT_PATH
	  )
  ENDIF (APPLE)
ENDIF ()
# MUST reset
SET(CMAKE_FIND_LIBRARY_SUFFIXES ${ORIGINAL_CMAKE_FIND_LIBRARY_SUFFIXES})

SET( GLFW_glfw_LIBRARY ${GLFW_LIBRARY_PATH} CACHE STRING "GLFW library")
