/* VXHCSC2TCTable.c: Simplified Chinese -> Traditional Chinese conv. table
 * (VX is abbr. for Vanilla OS X, a legacy from OpenVanilla 0.6.x)
 *
 * Copyright (c) 2004-2006 The OpenVanilla Project (http://openvanilla.org)
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of OpenVanilla nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The data is derived from Perl's Encode::HanConvert (0.31), 
 * Copyright (c) 2002-2004 by Autrijus Tang
 * 
 */

unsigned short vxSC2TCTable[8189*2]={
0x002d,0x0000, 0x0047,0x0042, 0x00a4,0x25ce, 0x00a8,0x2025, 0x00b7,0x2027, 
0x00e0,0xff41, 0x00e1,0xff41, 0x00e8,0xff45, 0x00e9,0xff45, 0x00ea,0xff45, 
0x00ec,0xff49, 0x00ed,0xff49, 0x00f2,0xff4f, 0x00f3,0xff4f, 0x00f9,0xff55, 
0x00fc,0xff55, 0x0101,0xff41, 0x0113,0xff45, 0x011b,0xff45, 0x012b,0xff49, 
0x0144,0xff4e, 0x0148,0xff4e, 0x014d,0xff4f, 0x016b,0xff55, 0x01ce,0xff41, 
0x01d0,0xff49, 0x01d2,0xff4f, 0x01d4,0xff55, 0x01d6,0xff55, 0x01d8,0xff55, 
0x01da,0xff55, 0x01dc,0xff55, 0x0251,0xff41, 0x0261,0xff47, 0x02c9,0x00af, 
0x042f,0x30cb, 0x0430,0x30cc, 0x2010,0xff0d, 0x2014,0x2500, 0x2015,0x2500, 
0x2016,0x2225, 0x2030,0x2105, 0x2033,0x301e, 0x2121,0x25a1, 0x216a,0xff38, 
0x216b,0xff38, 0x2170,0x25a1, 0x2171,0x25a1, 0x2172,0x25a1, 0x2173,0x25a1, 
0x2174,0x25a1, 0x2175,0x25a1, 0x2176,0x25a1, 0x2177,0x25a1, 0x2178,0x25a1, 
0x2179,0x25a1, 0x2208,0x0395, 0x220f,0x03a0, 0x2211,0x03a3, 0x221d,0x03b1, 
0x2227,0x039b, 0x2228,0xff36, 0x2236,0xfe30, 0x2237,0x203b, 0x223d,0xff5e, 
0x2248,0x2252, 0x224c,0x2252, 0x2264,0x2266, 0x2265,0x2267, 0x226e,0x2190, 
0x226f,0x2192, 0x2312,0xfe35, 0x247e,0xff11, 0x247f,0xff12, 0x2480,0xff13, 
0x2481,0xff14, 0x2482,0xff15, 0x2483,0xff16, 0x2484,0xff17, 0x2485,0xff18, 
0x2486,0xff19, 0x2487,0xff10, 0x2488,0xff11, 0x2489,0xff12, 0x248a,0xff13, 
0x248b,0xff14, 0x248c,0xff15, 0x248d,0xff16, 0x248e,0xff17, 0x248f,0xff18, 
0x2490,0xff19, 0x2491,0xff10, 0x2492,0xff11, 0x2493,0xff12, 0x2494,0xff13, 
0x2495,0xff14, 0x2496,0xff15, 0x2497,0xff16, 0x2498,0xff17, 0x2499,0xff18, 
0x249a,0xff19, 0x249b,0xff10, 0x2501,0x2550, 0x2503,0xff5c, 0x2504,0x2026, 
0x2505,0x2026, 0x2506,0xff5c, 0x2507,0xff5c, 0x2508,0x2014, 0x2509,0x2013, 
0x250a,0xff5c, 0x250b,0xff5c, 0x250d,0x250c, 0x250e,0x250c, 0x250f,0x250c, 
0x2511,0x2510, 0x2512,0x2510, 0x2513,0x2510, 0x2515,0x2514, 0x2516,0x2514, 
0x2517,0x2514, 0x2519,0x2518, 0x251a,0x2518, 0x251b,0x2518, 0x251d,0x255e, 
0x251e,0x251c, 0x251f,0x251c, 0x2520,0x251c, 0x2521,0x251c, 0x2522,0x251c, 
0x2523,0x251c, 0x2525,0x2561, 0x2526,0x2524, 0x2527,0x2524, 0x2528,0x2524, 
0x2529,0x2524, 0x252a,0x2524, 0x252b,0x2524, 0x252d,0x252c, 0x252e,0x252c, 
0x252f,0x252c, 0x2530,0x252c, 0x2531,0x252c, 0x2532,0x252c, 0x2533,0x252c, 
0x2535,0x2534, 0x2536,0x2534, 0x2537,0x2534, 0x2538,0x2534, 0x2539,0x2534, 
0x253a,0x2534, 0x253b,0x2534, 0x253d,0x253c, 0x253e,0x253c, 0x253f,0x256a, 
0x2540,0x253c, 0x2541,0x253c, 0x2542,0x253c, 0x2543,0x253c, 0x2544,0x253c, 
0x2545,0x253c, 0x2546,0x253c, 0x2547,0x253c, 0x2548,0x253c, 0x2549,0x253c, 
0x254a,0x253c, 0x254b,0x253c, 0x2554,0xffe5, 0x2557,0x201d, 0x255a,0x300a, 
0x255d,0x32a3, 0x2588,0x2593, 0x2609,0x2299, 0x3006,0x25a1, 0x3007,0x25a1, 
0x3013,0x2550, 0x3016,0x3010, 0x3017,0x3011, 0x309b,0x201c, 0x309c,0x3002, 
0x309d,0x2461, 0x309e,0x2462, 0x30fc,0x2500, 0x30fd,0x3001, 0x30fe,0x2460, 
0x3220,0x4e00, 0x3221,0x4e8c, 0x3222,0x4e09, 0x3223,0x56db, 0x3224,0x4e94, 
0x3225,0x516d, 0x3226,0x4e03, 0x3227,0x516b, 0x3228,0x4e5d, 0x3229,0x5341, 
0x3231,0x25a1, 0x4e02,0x25a1, 0x4e04,0x25a1, 0x4e05,0x25a1, 0x4e06,0x25a1, 
0x4e07,0x842c, 0x4e0e,0x8207, 0x4e11,0x919c, 0x4e12,0x56df, 0x4e13,0x5c08, 
0x4e17,0x5345, 0x4e1a,0x696d, 0x4e1b,0x53e2, 0x4e1c,0x6771, 0x4e1d,0x7d72, 
0x4e20,0x25a1, 0x4e21,0x5169, 0x4e22,0x4e1f, 0x4e23,0x25a1, 0x4e24,0x5169, 
0x4e25,0x56b4, 0x4e27,0x55aa, 0x4e28,0xff5c, 0x4e29,0x25a1, 0x4e2a,0x500b, 
0x4e2c,0x723f, 0x4e2f,0x4e30, 0x4e30,0x8c50, 0x4e34,0x81e8, 0x4e35,0x25a1, 
0x4e36,0x2f02, 0x4e37,0x25a1, 0x4e3a,0x70ba, 0x4e3d,0x9e97, 0x4e3e,0x8209, 
0x4e3f,0x2f03, 0x4e40,0x25a1, 0x4e41,0x25a1, 0x4e44,0x25a1, 0x4e46,0x25a1, 
0x4e48,0x9ebc, 0x4e49,0x7fa9, 0x4e4a,0x25a1, 0x4e4c,0x70cf, 0x4e50,0x6a02, 
0x4e51,0x25a1, 0x4e54,0x55ac, 0x4e55,0x25a1, 0x4e57,0x25a1, 0x4e5a,0x25a1, 
0x4e5b,0x25a1, 0x4e60,0x7fd2, 0x4e61,0x9109, 0x4e62,0x25a1, 0x4e63,0x25a1, 
0x4e64,0x25a1, 0x4e65,0x25a1, 0x4e66,0x66f8, 0x4e67,0x25a1, 0x4e68,0x25a1, 
0x4e6a,0x25a1, 0x4e6b,0x25a1, 0x4e6c,0x25a1, 0x4e6d,0x25a1, 0x4e6e,0x25a1, 
0x4e6f,0x25a1, 0x4e70,0x8cb7, 0x4e71,0x4e82, 0x4e72,0x25a1, 0x4e74,0x25a1, 
0x4e75,0x25a1, 0x4e76,0x25a1, 0x4e77,0x25a1, 0x4e78,0x25a1, 0x4e79,0x25a1, 
0x4e7a,0x25a1, 0x4e7b,0x25a1, 0x4e7c,0x25a1, 0x4e7d,0x25a1, 0x4e80,0x9f9c, 
0x4e81,0x4e7e, 0x4e85,0x25a1, 0x4e87,0x25a1, 0x4e89,0x722d, 0x4e8a,0x25a1, 
0x4e8f,0x8667, 0x4e90,0x25a1, 0x4e91,0x96f2, 0x4e96,0x25a1, 0x4e97,0x25a1, 
0x4e98,0x4e99, 0x4e9a,0x4e9e, 0x4e9c,0x25a1, 0x4e9d,0x25a1, 0x4ea0,0x2f07, 
0x4ea3,0x25a1, 0x4ea7,0x7522, 0x4ea9,0x755d, 0x4eaa,0x25a1, 0x4eaf,0x25a1, 
0x4eb0,0x25a1, 0x4eb1,0x25a1, 0x4eb2,0x89aa, 0x4eb4,0x25a1, 0x4eb5,0x893b, 
0x4eb7,0x25a1, 0x4eb8,0x56b2, 0x4ebb,0x4eba, 0x4ebc,0x25a1, 0x4ebd,0x25a1, 
0x4ebe,0x25a1, 0x4ebf,0x5104, 0x4ec5,0x50c5, 0x4ec6,0x50d5, 0x4ecc,0x25a1, 
0x4ece,0x5f9e, 0x4ecf,0x25a1, 0x4ed0,0x25a1, 0x4ed1,0x5d19, 0x4ed2,0x25a1, 
0x4ed3,0x5009, 0x4edb,0x25a1, 0x4ee0,0x25a1, 0x4ee2,0x25a1, 0x4ee6,0x25a1, 
0x4ee7,0x25a1, 0x4eea,0x5100, 0x4eeb,0x9ebc, 0x4eec,0x5011, 0x4eed,0x25a1, 
0x4eee,0x5047, 0x4eef,0x25a1, 0x4ef7,0x50f9, 0x4ef8,0x25a1, 0x4ef9,0x25a1, 
0x4efa,0x25a1, 0x4efc,0x25a1, 0x4efe,0x25a1, 0x4f03,0x25a1, 0x4f06,0x25a1, 
0x4f07,0x25a1, 0x4f0c,0x25a1, 0x4f16,0x25a1, 0x4f17,0x773e, 0x4f18,0x512a, 
0x4f1a,0x6703, 0x4f1b,0x50b4, 0x4f1c,0x25a1, 0x4f1e,0x5098, 0x4f1f,0x5049, 
0x4f20,0x50b3, 0x4f21,0x25a1, 0x4f23,0x25a1, 0x4f24,0x50b7, 0x4f25,0x5000, 
0x4f26,0x502b, 0x4f27,0x5096, 0x4f28,0x25a1, 0x4f29,0x25a1, 0x4f2a,0x507d, 
0x4f2b,0x4f47, 0x4f2e,0x25a1, 0x4f31,0x25a1, 0x4f32,0x62b3, 0x4f35,0x25a1, 
0x4f37,0x25a1, 0x4f39,0x25a1, 0x4f40,0x25a1, 0x4f42,0x25a1, 0x4f44,0x25a1, 
0x4f45,0x25a1, 0x4f4a,0x25a1, 0x4f4b,0x25a1, 0x4f53,0x9ad4, 0x4f65,0x50c9, 
0x4f66,0x25a1, 0x4f68,0x25a1, 0x4f6d,0x25a1, 0x4f71,0x25a1, 0x4f72,0x25a1, 
0x4f8a,0x25a1, 0x4f8c,0x25a1, 0x4f8e,0x25a1, 0x4f93,0x25a1, 0x4f99,0x25a1, 
0x4f9f,0x25a1, 0x4fa0,0x4fe0, 0x4fa1,0x25a1, 0x4fa2,0x25a1, 0x4fa3,0x4fb6, 
0x4fa4,0x25a1, 0x4fa5,0x50e5, 0x4fa6,0x5075, 0x4fa7,0x5074, 0x4fa8,0x50d1, 
0x4fa9,0x5108, 0x4faa,0x5115, 0x4fab,0x25a1, 0x4fac,0x5102, 0x4fad,0x25a1, 
0x4fb0,0x25a1, 0x4fb1,0x25a1, 0x4fb4,0x25a1, 0x4fb8,0x25a1, 0x4fbc,0x25a1, 
0x4fbd,0x25a1, 0x4fbe,0x25a1, 0x4fc6,0x25a1, 0x4fc8,0x25a1, 0x4fcc,0x25a1, 
0x4fd2,0x25a1, 0x4fd5,0x25a1, 0x4fe2,0x25a1, 0x4fe3,0x4fc1, 0x4fe4,0x25a1, 
0x4fe5,0x25a1, 0x4fe6,0x5114, 0x4fe7,0x25a1, 0x4fe8,0x513c, 0x4fe9,0x5006, 
0x4fea,0x5137, 0x4feb,0x25a1, 0x4fed,0x5109, 0x4ff0,0x25a1, 0x4ff2,0x25a1, 
0x4ff9,0x25a1, 0x4ffb,0x25a1, 0x4ffc,0x25a1, 0x4ffd,0x25a1, 0x4fff,0x25a1, 
0x5001,0x25a1, 0x5002,0x25a1, 0x5003,0x25a1, 0x5004,0x25a1, 0x5008,0x25a1, 
0x500a,0x25a1, 0x5010,0x25a1, 0x501d,0x25a1, 0x5024,0x25a1, 0x502e,0x60c8, 
0x5032,0x25a1, 0x5034,0x25a1, 0x5036,0x25a1, 0x5038,0x25a1, 0x5039,0x25a1, 
0x503a,0x50b5, 0x503b,0x25a1, 0x503d,0x25a1, 0x503e,0x50be, 0x503f,0x25a1, 
0x5042,0x25a1, 0x5044,0x25a1, 0x5050,0x25a1, 0x5052,0x25a1, 0x5054,0x25a1, 
0x5056,0x25a1, 0x5058,0x25a1, 0x5059,0x25a1, 0x5066,0x25a1, 0x5067,0x25a1, 
0x506c,0x50af, 0x5071,0x25a1, 0x5078,0x25a1, 0x5079,0x25a1, 0x507b,0x50c2, 
0x507c,0x25a1, 0x507e,0x50e8, 0x507f,0x511f, 0x5081,0x25a1, 0x5084,0x25a1, 
0x5086,0x25a1, 0x5088,0x6144, 0x5089,0x25a1, 0x508a,0x25a1, 0x508f,0x25a1, 
0x5090,0x25a1, 0x5093,0x25a1, 0x5097,0x25a1, 0x509f,0x25a1, 0x50a0,0x25a1, 
0x50a1,0x25a1, 0x50a4,0x25a1, 0x50a5,0x513b, 0x50a6,0x25a1, 0x50a7,0x5110, 
0x50a8,0x5132, 0x50a9,0x513a, 0x50aa,0x25a1, 0x50ab,0x25a1, 0x50b9,0x25a1, 
0x50bc,0x25a1, 0x50c0,0x25a1, 0x50c3,0x25a1, 0x50cc,0x25a1, 0x50cd,0x25a1, 
0x50d0,0x25a1, 0x50d2,0x25a1, 0x50d8,0x25a1, 0x50d9,0x25a1, 0x50dc,0x25a1, 
0x50de,0x25a1, 0x50df,0x25a1, 0x50e1,0x25a1, 0x50e2,0x25a1, 0x50eb,0x25a1, 
0x50f2,0x25a1, 0x50f4,0x25a1, 0x50f5,0x6bad, 0x50f7,0x25a1, 0x50fa,0x25a1, 
0x50fc,0x25a1, 0x5101,0x25a1, 0x510d,0x25a1, 0x510e,0x25a1, 0x510f,0x25a1, 
0x5116,0x25a1, 0x5119,0x25a1, 0x511b,0x25a1, 0x511d,0x25a1, 0x511e,0x25a1, 
0x5123,0x25a1, 0x5127,0x25a1, 0x5128,0x25a1, 0x512b,0x25a1, 0x512c,0x25a1, 
0x512f,0x25a1, 0x5136,0x25a1, 0x513e,0x25a1, 0x513f,0x5152, 0x5142,0x25a1, 
0x514a,0x25a1, 0x514e,0x5154, 0x514f,0x25a1, 0x5150,0x25a1, 0x5151,0x514c, 
0x5153,0x25a1, 0x5156,0x5157, 0x5158,0x25a1, 0x515a,0x9ee8, 0x5160,0x25a1, 
0x5164,0x25a1, 0x5166,0x25a1, 0x516a,0x4fde, 0x516f,0x25a1, 0x5170,0x862d, 
0x5172,0x25a1, 0x5173,0x95dc, 0x5174,0x8208, 0x5179,0x8332, 0x517a,0x25a1, 
0x517b,0x990a, 0x517d,0x7378, 0x517e,0x7cde, 0x517f,0x85dd, 0x5181,0x56c5, 
0x5182,0x2f0c, 0x5183,0x25a1, 0x5184,0x25a1, 0x5185,0x5167, 0x5186,0x4e39, 
0x5188,0x5ca1, 0x518b,0x25a1, 0x518c,0x518a, 0x518e,0x25a1, 0x5190,0x25a1, 
0x5196,0x2f0d, 0x5199,0x5beb, 0x519a,0x25a1, 0x519b,0x8ecd, 0x519c,0x8fb2, 
0x519d,0x5b9c, 0x519f,0x25a1, 0x51a1,0x25a1, 0x51a2,0x585a, 0x51a3,0x25a1, 
0x51a6,0x5bc7, 0x51a7,0x9716, 0x51a8,0x5bcc, 0x51a9,0x5beb, 0x51ab,0x2f0e, 
0x51ad,0x25a1, 0x51ae,0x6c5f, 0x51af,0x99ae, 0x51b2,0x885d, 0x51b3,0x6c7a, 
0x51b4,0x25a1, 0x51b5,0x6cc1, 0x51b8,0x6cee, 0x51ba,0x6cef, 0x51bb,0x51cd, 
0x51bf,0x6d25, 0x51c0,0x6de8, 0x51c1,0x6d91, 0x51c2,0x6d7c, 0x51c3,0x6d82, 
0x51c4,0x6dd2, 0x51c7,0x6dde, 0x51c9,0x6dbc, 0x51cf,0x6e1b, 0x51d1,0x6e4a, 
0x51d2,0x6eb0, 0x51d3,0x6ea7, 0x51d5,0x6e9f, 0x51d6,0x6e96, 0x51d9,0x6fa4, 
0x51da,0x6fbf, 0x51db,0x51dc, 0x51df,0x7006, 0x51e0,0x5e7e, 0x51e2,0x25a1, 
0x51e3,0x25a1, 0x51e4,0x9cf3, 0x51e5,0x5c3b, 0x51e6,0x8655, 0x51e7,0x98a8, 
0x51e8,0x4e91, 0x51e9,0x9591, 0x51ea,0x25a1, 0x51eb,0x9ce7, 0x51ec,0x51f0, 
0x51ed,0x6191, 0x51ee,0x9cf3, 0x51ef,0x51f1, 0x51f2,0x25a1, 0x51f4,0x6191, 
0x51f7,0x25a1, 0x51fb,0x64ca, 0x51fc,0x7a9e, 0x51fe,0x4e9f, 0x51ff,0x947f, 
0x5204,0x5203, 0x5205,0x5203, 0x520b,0x520a, 0x520d,0x82bb, 0x520f,0x25a1, 
0x5212,0x5283, 0x5214,0x25a1, 0x5215,0x25a1, 0x5218,0x5289, 0x5219,0x5247, 
0x521a,0x525b, 0x521b,0x5275, 0x521f,0x25a1, 0x5220,0x522a, 0x5222,0x25a1, 
0x5223,0x25a1, 0x5226,0x52ab, 0x5227,0x52ab, 0x522b,0x5225, 0x522c,0x25a1, 
0x522d,0x5244, 0x522f,0x25a1, 0x5234,0x5241, 0x5239,0x524e, 0x523c,0x52ab, 
0x523d,0x528a, 0x523e,0x25a1, 0x523f,0x528c, 0x5240,0x5274, 0x5242,0x5291, 
0x5245,0x25a1, 0x5248,0x25a1, 0x524f,0x25a1, 0x5250,0x526e, 0x5251,0x528d, 
0x5253,0x25a1, 0x5257,0x25a1, 0x5258,0x25a1, 0x5259,0x25a1, 0x5260,0x25a1, 
0x5263,0x25a1, 0x5264,0x25a1, 0x5265,0x525d, 0x5266,0x25a1, 0x5267,0x5287, 
0x5268,0x25a1, 0x5270,0x5269, 0x5271,0x25a1, 0x5273,0x25a1, 0x5276,0x25a1, 
0x5279,0x25a1, 0x527e,0x25a1, 0x5285,0x25a1, 0x5286,0x25a1, 0x528e,0x528d, 
0x528f,0x25a1, 0x5290,0x944a, 0x5292,0x528d, 0x5294,0x528d, 0x5295,0x25a1, 
0x529a,0x25a1, 0x529c,0x25a1, 0x529d,0x52f8, 0x529e,0x8fa6, 0x52a1,0x52d9, 
0x52a2,0x52f1, 0x52a4,0x25a1, 0x52a5,0x25a1, 0x52a7,0x25a1, 0x52a8,0x52d5, 
0x52af,0x25a1, 0x52b0,0x6548, 0x52b1,0x52f5, 0x52b2,0x52c1, 0x52b3,0x52de, 
0x52b4,0x52de, 0x52b5,0x5377, 0x52b6,0x25a1, 0x52b7,0x25a1, 0x52b8,0x25a1, 
0x52b9,0x6548, 0x52ba,0x25a1, 0x52bd,0x88c2, 0x52bf,0x52e2, 0x52c4,0x25a1, 
0x52c5,0x6555, 0x52c6,0x25a1, 0x52c8,0x25a1, 0x52ca,0x25a1, 0x52cb,0x52db, 
0x52cc,0x25a1, 0x52ce,0x25a1, 0x52cf,0x25a1, 0x52d0,0x731b, 0x52d1,0x25a1, 
0x52d4,0x25a1, 0x52da,0x52e9, 0x52dc,0x25a1, 0x52e0,0x622e, 0x52e1,0x25a1, 
0x52e5,0x5f37, 0x52e7,0x52f8, 0x52e8,0x25a1, 0x52ea,0x25a1, 0x52ec,0x25a1, 
0x52ed,0x25a1, 0x52ee,0x25a1, 0x52f2,0x52f3, 0x52f6,0x25a1, 0x52f9,0x2f13, 
0x52fd,0x25a1, 0x5300,0x52fb, 0x5301,0x25a1, 0x5302,0x25a1, 0x5303,0x25a1, 
0x5304,0x25a1, 0x5307,0x25a1, 0x530c,0x25a1, 0x5313,0x25a1, 0x5314,0x25a1, 
0x5318,0x25a1, 0x531b,0x25a1, 0x531e,0x25a1, 0x5324,0x25a1, 0x5325,0x25a1, 
0x5326,0x532d, 0x5327,0x25a1, 0x5328,0x25a1, 0x5329,0x25a1, 0x532b,0x25a1, 
0x532c,0x25a1, 0x532e,0x5331, 0x5332,0x25a1, 0x5333,0x25a1, 0x5335,0x25a1, 
0x5336,0x25a1, 0x5338,0x25a1, 0x533a,0x5340, 0x533b,0x91ab, 0x5342,0x25a1, 
0x5344,0x3039, 0x5346,0x25a1, 0x534b,0x25a1, 0x534e,0x83ef, 0x534f,0x5354, 
0x5350,0x534d, 0x5355,0x55ae, 0x5356,0x8ce3, 0x5358,0x55ae, 0x5359,0x659f, 
0x535b,0x6523, 0x535d,0x25a1, 0x535f,0x5687, 0x5362,0x76e7, 0x5364,0x9e75, 
0x5365,0x56df, 0x5367,0x81e5, 0x5368,0x25a1, 0x5369,0x2f19, 0x536a,0x25a1, 
0x536b,0x885b, 0x536d,0x25a1, 0x5374,0x537b, 0x5376,0x25a1, 0x537a,0x5df9, 
0x537d,0x25a1, 0x537e,0x25a1, 0x5380,0x25a1, 0x5381,0x25a1, 0x5382,0x5ee0, 
0x5383,0x25a1, 0x5385,0x5ef3, 0x5386,0x6b77, 0x5387,0x25a1, 0x5388,0x25a1, 
0x5389,0x53b2, 0x538b,0x58d3, 0x538c,0x53ad, 0x538d,0x5399, 0x5390,0x25a1, 
0x5391,0x25a1, 0x5393,0x25a1, 0x5395,0x5ec1, 0x539b,0x5ef3, 0x53a0,0x5ec1, 
0x53a1,0x25a1, 0x53a2,0x5ec2, 0x53a3,0x53b4, 0x53a6,0x5ec8, 0x53a8,0x5eda, 
0x53a9,0x5ec4, 0x53aa,0x25a1, 0x53ab,0x25a1, 0x53ae,0x5edd, 0x53af,0x25a1, 
0x53b0,0x5ee0, 0x53b1,0x25a1, 0x53b3,0x56b4, 0x53b5,0x25a1, 0x53b6,0x2f1b, 
0x53b7,0x25a1, 0x53b8,0x25a1, 0x53ba,0x25a1, 0x53bc,0x25a1, 0x53bd,0x25a1, 
0x53be,0x25a1, 0x53bf,0x7e23, 0x53c0,0x25a1, 0x53c1,0x53c3, 0x53c2,0x53c3, 
0x53c4,0x53c3, 0x53c5,0x25a1, 0x53c6,0x9749, 0x53c7,0x9746, 0x53cc,0x96d9, 
0x53ce,0x6536, 0x53cf,0x767c, 0x53d0,0x767c, 0x53d1,0x767c, 0x53d2,0x25a1, 
0x53d3,0x25a1, 0x53d5,0x25a1, 0x53d8,0x8b8a, 0x53d9,0x6558, 0x53da,0x25a1, 
0x53dc,0x25a1, 0x53dd,0x25a1, 0x53de,0x25a1, 0x53e0,0x758a, 0x53e7,0x53e6, 
0x53f4,0x25a1, 0x53f6,0x8449, 0x53f7,0x865f, 0x53f9,0x5606, 0x53fa,0x25a1, 
0x53fd,0x5630, 0x53fe,0x25a1, 0x53ff,0x25a1, 0x5400,0x25a1, 0x5401,0x7c72, 
0x5402,0x25a1, 0x5405,0x25a1, 0x540e,0x5f8c, 0x5413,0x5687, 0x5414,0x8036, 
0x5415,0x5442, 0x5416,0x55c4, 0x5417,0x55ce, 0x541a,0x25a1, 0x5421,0x55f6, 
0x5422,0x25a1, 0x5423,0x551a, 0x5428,0x5678, 0x542c,0x807d, 0x542f,0x555f, 
0x5432,0x5f15, 0x5434,0x5433, 0x543a,0x25a1, 0x543f,0x544a, 0x5444,0x25a1, 
0x5449,0x25a1, 0x544b,0x5490, 0x544c,0x25a1, 0x544d,0x25a1, 0x5450,0x5436, 
0x5451,0x541e, 0x5452,0x5638, 0x5453,0x56c8, 0x5455,0x5614, 0x5456,0x56a6, 
0x5457,0x5504, 0x5458,0x54e1, 0x5459,0x54bc, 0x545a,0x25a1, 0x545b,0x55c6, 
0x545c,0x55da, 0x545d,0x25a1, 0x545e,0x25a1, 0x545f,0x25a1, 0x5469,0x25a1, 
0x546a,0x5492, 0x546d,0x25a1, 0x546e,0x25a1, 0x5479,0x25a1, 0x5483,0x25a1, 
0x5485,0x25a1, 0x5489,0x25a1, 0x548a,0x25a1, 0x548f,0x8a60, 0x5493,0x25a1, 
0x5494,0x54e2, 0x5497,0x25a1, 0x5499,0x56a8, 0x549b,0x5680, 0x549c,0x25a1, 
0x549d,0x5431, 0x549e,0x25a1, 0x549f,0x25a1, 0x54a3,0x5149, 0x54a4,0x5412, 
0x54b2,0x25a1, 0x54b4,0x5645, 0x54b5,0x25a1, 0x54b9,0x25a1, 0x54ca,0x25a1, 
0x54cb,0x25a1, 0x54cc,0x5471, 0x54cd,0x97ff, 0x54d0,0x5321, 0x54d1,0x555e, 
0x54d2,0x5660, 0x54d3,0x5635, 0x54d4,0x55f6, 0x54d5,0x5666, 0x54d7,0x5629, 
0x54d8,0x25a1, 0x54d9,0x5672, 0x54da,0x54c6, 0x54db,0x25a1, 0x54dc,0x568c, 
0x54dd,0x5665, 0x54df,0x55b2, 0x54e3,0x25a1, 0x54ec,0x25a1, 0x54ef,0x25a1, 
0x54f0,0x25a1, 0x54f4,0x25a1, 0x54f5,0x25a1, 0x54f6,0x25a1, 0x54f9,0x25a1, 
0x54fe,0x25a1, 0x5500,0x25a1, 0x5502,0x25a1, 0x550d,0x25a1, 0x5513,0x25a1, 
0x5515,0x25a1, 0x5516,0x25a1, 0x5518,0x25a1, 0x5519,0x25a1, 0x551b,0x561c, 
0x551c,0x25a1, 0x551d,0x55ca, 0x551e,0x25a1, 0x551f,0x25a1, 0x5520,0x562e, 
0x5521,0x5562, 0x5522,0x55e9, 0x5523,0x55e6, 0x5524,0x559a, 0x5525,0x25a1, 
0x5528,0x25a1, 0x5529,0x25a1, 0x552b,0x25a1, 0x553a,0x25a1, 0x553d,0x25a1, 
0x553f,0x547c, 0x5542,0x25a1, 0x5547,0x25a1, 0x5549,0x54bb, 0x554c,0x25a1, 
0x5553,0x25a1, 0x5554,0x25a1, 0x5558,0x25a1, 0x5559,0x25a1, 0x555a,0x25a1, 
0x555b,0x25a1, 0x555d,0x25a1, 0x5560,0x25a1, 0x5567,0x5616, 0x5568,0x25a1, 
0x5569,0x25a1, 0x556b,0x25a1, 0x556c,0x55c7, 0x556d,0x56c0, 0x556e,0x5699, 
0x556f,0x25a1, 0x5570,0x56c9, 0x5571,0x25a1, 0x5572,0x25a1, 0x5573,0x25a1, 
0x5574,0x563d, 0x5578,0x562f, 0x5579,0x25a1, 0x557a,0x25a1, 0x5585,0x25a1, 
0x5586,0x25a1, 0x5590,0x25a1, 0x5596,0x25a1, 0x5597,0x25a1, 0x559b,0x25a1, 
0x559e,0x25a1, 0x55a0,0x25a1, 0x55a9,0x25a1, 0x55af,0x25a1, 0x55b0,0x25a1, 
0x55b4,0x25a1, 0x55b6,0x25a1, 0x55b7,0x5674, 0x55b8,0x25a1, 0x55b9,0x594e, 
0x55ba,0x25a1, 0x55bc,0x25a1, 0x55bd,0x560d, 0x55be,0x56b3, 0x55c0,0xfa0d, 
0x55c1,0x25a1, 0x55c9,0x8186, 0x55d7,0x25a1, 0x55d8,0x25a1, 0x55de,0x25a1, 
0x55e0,0x25a1, 0x55ea,0x551a, 0x55eb,0x56c1, 0x55ec,0x5475, 0x55ed,0x25a1, 
0x55ee,0x25a1, 0x55f0,0x25a1, 0x55f1,0x25a1, 0x55f3,0x566f, 0x55f4,0x25a1, 
0x55f5,0x901a, 0x55f8,0x25a1, 0x55fb,0x25a1, 0x5603,0x25a1, 0x5605,0x25a1, 
0x5607,0x25a1, 0x560a,0x25a1, 0x560b,0x25a1, 0x5611,0x25a1, 0x5618,0x5653, 
0x5619,0x25a1, 0x561a,0x25a1, 0x561e,0x54a7, 0x5620,0x560e, 0x5621,0x25a1, 
0x5622,0x25a1, 0x5623,0x8ff8, 0x5624,0x56b6, 0x5625,0x25a1, 0x5626,0x25a1, 
0x5628,0x562f, 0x562b,0x25a1, 0x562d,0x81a8, 0x5631,0x56d1, 0x5637,0x568e, 
0x563c,0x25a1, 0x5643,0x25a1, 0x5644,0x25a1, 0x5647,0x25a1, 0x564b,0x25a1, 
0x564d,0x7126, 0x564f,0x25a1, 0x5650,0x25a1, 0x5651,0x25a1, 0x5652,0x25a1, 
0x5654,0x767b, 0x5655,0x25a1, 0x5656,0x25a1, 0x565b,0x25a1, 0x565c,0x5695, 
0x565d,0x25a1, 0x565f,0x25a1, 0x5661,0x25a1, 0x5667,0x25a1, 0x5675,0x25a1, 
0x567a,0x25a1, 0x567b,0x585e, 0x567c,0x5288, 0x567d,0x25a1, 0x5688,0x25a1, 
0x5689,0x25a1, 0x568a,0x25a1, 0x568b,0x25a1, 0x5691,0x25a1, 0x5692,0x25a1, 
0x5694,0x6d95, 0x5696,0x25a1, 0x569b,0x25a1, 0x569e,0x25a1, 0x569f,0x25a1, 
0x56a0,0x25a1, 0x56a1,0x25a1, 0x56a2,0x56ca, 0x56a3,0x56c2, 0x56a4,0x25a1, 
0x56a9,0x25a1, 0x56af,0x8b14, 0x56b0,0x25a1, 0x56b1,0x25a1, 0x56b8,0x25a1, 
0x56b9,0x25a1, 0x56ba,0x25a1, 0x56bb,0x25a1, 0x56bf,0x25a1, 0x56c4,0x25a1, 
0x56c7,0x25a1, 0x56ce,0x25a1, 0x56cf,0x25a1, 0x56d0,0x25a1, 0x56d2,0x25a1, 
0x56d5,0x25a1, 0x56d6,0x25a1, 0x56d8,0x25a1, 0x56d9,0x25a1, 0x56dc,0x25a1, 
0x56e2,0x5718, 0x56e3,0x25a1, 0x56e6,0x25a1, 0x56e8,0x25a1, 0x56e9,0x25a1, 
0x56ec,0x25a1, 0x56ed,0x5712, 0x56ef,0x25a1, 0x56f1,0x56ea, 0x56f2,0x25a1, 
0x56f3,0x25a1, 0x56f4,0x570d, 0x56f5,0x5707, 0x56f6,0x25a1, 0x56f8,0x25a1, 
0x56fb,0x25a1, 0x56fc,0x25a1, 0x56fd,0x570b, 0x56fe,0x5716, 0x5700,0x25a1, 
0x5705,0x25a1, 0x5706,0x5713, 0x570e,0x25a1, 0x570f,0x25a1, 0x5710,0x25a1, 
0x5711,0x25a1, 0x5715,0x25a1, 0x5717,0x25a1, 0x5719,0x25a1, 0x571d,0x25a1, 
0x5721,0x25a1, 0x5723,0x8056, 0x5724,0x25a1, 0x5725,0x25a1, 0x5726,0x25a1, 
0x5727,0x25a1, 0x572b,0x25a1, 0x5731,0x25a1, 0x5732,0x25a1, 0x5735,0x25a1, 
0x5736,0x25a1, 0x5737,0x25a1, 0x5738,0x25a1, 0x5739,0x58d9, 0x573a,0x5834, 
0x573c,0x25a1, 0x573d,0x25a1, 0x573f,0x25a1, 0x5742,0x962a, 0x5743,0x25a1, 
0x5744,0x25a1, 0x5746,0x25a1, 0x5748,0x25a1, 0x574f,0x58de, 0x5753,0x25a1, 
0x5754,0x25a1, 0x5755,0x25a1, 0x5756,0x25a1, 0x5757,0x584a, 0x5758,0x25a1, 
0x5759,0x25a1, 0x575a,0x5805, 0x575b,0x58c7, 0x575c,0x58e2, 0x575d,0x58e9, 
0x575e,0x5862, 0x575f,0x58b3, 0x5760,0x589c, 0x5763,0x25a1, 0x5765,0x25a1, 
0x5767,0x25a1, 0x576c,0x25a1, 0x576e,0x25a1, 0x5778,0x25a1, 0x5779,0x25a1, 
0x577a,0x25a1, 0x577e,0x25a1, 0x577f,0x25a1, 0x5781,0x25a1, 0x5784,0x58df, 
0x5785,0x58df, 0x5786,0x58da, 0x5787,0x25a1, 0x5788,0x25a1, 0x5789,0x25a1, 
0x578a,0x25a1, 0x578d,0x25a1, 0x578e,0x25a1, 0x5790,0x25a1, 0x5791,0x25a1, 
0x5792,0x58d8, 0x5796,0x25a1, 0x579c,0x25a1, 0x57a1,0x5750, 0x57a6,0x58be, 
0x57a7,0x5770, 0x57a8,0x25a1, 0x57a9,0x580a, 0x57aa,0x25a1, 0x57ab,0x588a, 
0x57ac,0x25a1, 0x57ad,0x57e1, 0x57af,0x25a1, 0x57b0,0x25a1, 0x57b1,0x25a1, 
0x57b2,0x584f, 0x57b3,0x25a1, 0x57b4,0x7459, 0x57b7,0x25a1, 0x57bb,0x25a1, 
0x57be,0x25a1, 0x57c0,0x25a1, 0x57c4,0x25a1, 0x57c5,0x25a1, 0x57c8,0x25a1, 
0x57c9,0x25a1, 0x57ca,0x25a1, 0x57cd,0x25a1, 0x57d1,0x25a1, 0x57d3,0x25a1, 
0x57d6,0x25a1, 0x57d7,0x25a1, 0x57d8,0x5852, 0x57d9,0x5864, 0x57da,0x581d, 
0x57db,0x25a1, 0x57dd,0x588a, 0x57de,0x25a1, 0x57e6,0x25a1, 0x57e8,0x25a1, 
0x57ea,0x25a1, 0x57eb,0x25a1, 0x57ef,0x57b5, 0x57fe,0x25a1, 0x57ff,0x25a1, 
0x5803,0x25a1, 0x580f,0x25a1, 0x5811,0x5879, 0x5812,0x25a1, 0x5813,0x25a1, 
0x5815,0x58ae, 0x5816,0x25a1, 0x5817,0x25a1, 0x5818,0x25a1, 0x581a,0x25a1, 
0x581f,0x25a1, 0x5822,0x25a1, 0x5826,0x25a1, 0x582b,0x25a1, 0x583a,0x25a1, 
0x583c,0x25a1, 0x583e,0x25a1, 0x5840,0x25a1, 0x5841,0x25a1, 0x5842,0x25a1, 
0x5843,0x25a1, 0x5844,0x043f, 0x5845,0x25a1, 0x5846,0x25a1, 0x5847,0x25a1, 
0x5850,0x25a1, 0x5856,0x25a1, 0x585c,0x25a1, 0x585f,0x25a1, 0x5860,0x25a1, 
0x5861,0x586b, 0x5866,0x25a1, 0x5867,0x25a1, 0x5869,0x25a1, 0x586a,0x25a1, 
0x586c,0x539f, 0x586e,0x25a1, 0x5870,0x25a1, 0x5872,0x25a1, 0x5873,0x25a1, 
0x5877,0x25a1, 0x5878,0x25a1, 0x5884,0x25a1, 0x588c,0x25a1, 0x588d,0x25a1, 
0x5892,0x5891, 0x5895,0x25a1, 0x5896,0x25a1, 0x5897,0x25a1, 0x5899,0x7246, 
0x589a,0x6a11, 0x589b,0x25a1, 0x58a2,0x25a1, 0x58a4,0x25a1, 0x58a7,0x25a1, 
0x58aa,0x25a1, 0x58ad,0x25a1, 0x58b0,0x25a1, 0x58b2,0x25a1, 0x58b4,0x25a1, 
0x58b5,0x25a1, 0x58b6,0x25a1, 0x58b7,0x25a1, 0x58b8,0x25a1, 0x58b9,0x25a1, 
0x58bb,0x25a1, 0x58c0,0x25a1, 0x58c3,0x25a1, 0x58c4,0x25a1, 0x58ca,0x25a1, 
0x58cb,0x25a1, 0x58cc,0x25a1, 0x58cd,0x25a1, 0x58d0,0x25a1, 0x58d7,0x25a1, 
0x58dc,0x25a1, 0x58e0,0x25a1, 0x58e1,0x25a1, 0x58e5,0x25a1, 0x58e6,0x25a1, 
0x58ea,0x25a1, 0x58ed,0x25a1, 0x58ee,0x58ef, 0x58f0,0x8072, 0x58f1,0x25a1, 
0x58f2,0x25a1, 0x58f3,0x6bbc, 0x58f5,0x25a1, 0x58f6,0x58fa, 0x58f7,0x25a1, 
0x58f8,0x58fc, 0x58fb,0x25a1, 0x5900,0x25a1, 0x5901,0x25a1, 0x5902,0x2f22, 
0x5904,0x8655, 0x5905,0x25a1, 0x5907,0x5099, 0x5908,0x25a1, 0x5909,0x25a1, 
0x590a,0x2f22, 0x590b,0x25a1, 0x590d,0x8907, 0x5910,0x25a1, 0x5911,0x25a1, 
0x5913,0x25a1, 0x5918,0x25a1, 0x591b,0x25a1, 0x591d,0x25a1, 0x591e,0x25a1, 
0x591f,0x5920, 0x5921,0x25a1, 0x5923,0x25a1, 0x5926,0x25a1, 0x5928,0x25a1, 
0x5930,0x25a1, 0x5932,0x25a1, 0x5933,0x25a1, 0x5934,0x982d, 0x5935,0x25a1, 
0x5936,0x25a1, 0x5938,0x8a87, 0x5939,0x593e, 0x593a,0x596a, 0x593b,0x25a1, 
0x593d,0x25a1, 0x593f,0x25a1, 0x5941,0x5969, 0x5942,0x5950, 0x5943,0x25a1, 
0x5946,0x25a1, 0x594b,0x596e, 0x594c,0x25a1, 0x594d,0x25a1, 0x5952,0x25a1, 
0x5956,0x734e, 0x5959,0x25a1, 0x595b,0x25a1, 0x595d,0x25a1, 0x595e,0x25a1, 
0x595f,0x25a1, 0x5963,0x25a1, 0x5964,0x25a1, 0x5965,0x5967, 0x5966,0x25a1, 
0x5968,0x25a1, 0x596c,0x25a1, 0x596f,0x25a1, 0x5975,0x25a1, 0x597a,0x25a1, 
0x5986,0x599d, 0x5987,0x5a66, 0x5988,0x5abd, 0x5989,0x25a1, 0x598b,0x25a1, 
0x598c,0x25a1, 0x5991,0x25a1, 0x5994,0x25a1, 0x5995,0x25a1, 0x599a,0x25a1, 
0x599b,0x25a1, 0x599c,0x25a1, 0x599f,0x25a1, 0x59a9,0x5af5, 0x59aa,0x5ad7, 
0x59ab,0x5aaf, 0x59ac,0x25a1, 0x59ad,0x25a1, 0x59b0,0x25a1, 0x59b7,0x25a1, 
0x59b8,0x25a1, 0x59bf,0x25a1, 0x59c2,0x25a1, 0x59c4,0x25a1, 0x59c9,0x25a1, 
0x59d5,0x25a1, 0x59d7,0x59cd, 0x59d9,0x25a1, 0x59df,0x25a1, 0x59e2,0x25a1, 
0x59e7,0x25a1, 0x59eb,0x25a1, 0x59ef,0x25a1, 0x59f0,0x25a1, 0x59f8,0x25a1, 
0x59f9,0x597c, 0x5a02,0x25a1, 0x5a04,0x5a41, 0x5a05,0x5a6d, 0x5a06,0x5b08, 
0x5a07,0x5b0c, 0x5a08,0x5b4c, 0x5a0b,0x25a1, 0x5a0d,0x25a1, 0x5a0e,0x25a1, 
0x5a10,0x25a1, 0x5a12,0x25a1, 0x5a14,0x25a1, 0x5a1a,0x25a1, 0x5a1d,0x25a1, 
0x5a21,0x25a1, 0x5a22,0x25a1, 0x5a24,0x25a1, 0x5a26,0x25a1, 0x5a27,0x25a1, 
0x5a28,0x25a1, 0x5a2a,0x25a1, 0x5a2b,0x25a1, 0x5a2c,0x25a1, 0x5a2f,0x25a1, 
0x5a30,0x59d2, 0x5a31,0x5a1b, 0x5a32,0x5aa7, 0x5a34,0x5afb, 0x5a3a,0x25a1, 
0x5a3b,0x25a1, 0x5a3d,0x25a1, 0x5a3f,0x25a1, 0x5a45,0x25a1, 0x5a4b,0x25a1, 
0x5a4e,0x25a1, 0x5a4f,0x25a1, 0x5a54,0x25a1, 0x5a59,0x25a1, 0x5a61,0x25a1, 
0x5a63,0x25a1, 0x5a68,0x25a1, 0x5a6b,0x25a1, 0x5a6e,0x25a1, 0x5a6f,0x25a1, 
0x5a71,0x25a1, 0x5a72,0x25a1, 0x5a73,0x5aff, 0x5a74,0x5b30, 0x5a75,0x5b0b, 
0x5a76,0x5b38, 0x5a79,0x25a1, 0x5a7e,0x25a1, 0x5a80,0x25a1, 0x5a81,0x25a1, 
0x5a82,0x25a1, 0x5a85,0x25a1, 0x5a86,0x25a1, 0x5a87,0x25a1, 0x5a88,0x25a1, 
0x5a89,0x25a1, 0x5a8d,0x25a1, 0x5a91,0x25a1, 0x5a96,0x25a1, 0x5a98,0x25a1, 
0x5a99,0x25a1, 0x5aa0,0x25a1, 0x5aa1,0x25a1, 0x5aa3,0x25a1, 0x5aa4,0x25a1, 
0x5aa8,0x25a1, 0x5aaa,0x5abc, 0x5aab,0x25a1, 0x5aad,0x25a1, 0x5ac3,0x25a1, 
0x5ac5,0x25a1, 0x5ace,0x25a1, 0x5acf,0x25a1, 0x5ad0,0x25a1, 0x5ad1,0x25a1, 
0x5ad2,0x5b21, 0x5ad3,0x25a1, 0x5ad4,0x5b2a, 0x5ae4,0x25a1, 0x5ae7,0x25a1, 
0x5aef,0x25a1, 0x5af0,0x25a1, 0x5af1,0x5b19, 0x5af2,0x25a1, 0x5afc,0x25a1, 
0x5afe,0x25a1, 0x5b00,0x25a1, 0x5b04,0x25a1, 0x5b06,0x25a1, 0x5b0a,0x25a1, 
0x5b0d,0x25a1, 0x5b0e,0x25a1, 0x5b11,0x25a1, 0x5b12,0x25a1, 0x5b15,0x25a1, 
0x5b18,0x25a1, 0x5b1c,0x25a1, 0x5b1f,0x25a1, 0x5b22,0x25a1, 0x5b29,0x25a1, 
0x5b2b,0x25a1, 0x5b31,0x25a1, 0x5b33,0x25a1, 0x5b35,0x25a1, 0x5b36,0x25a1, 
0x5b37,0x5b24, 0x5b39,0x25a1, 0x5b3a,0x25a1, 0x5b3b,0x25a1, 0x5b41,0x25a1, 
0x5b42,0x25a1, 0x5b44,0x25a1, 0x5b46,0x25a1, 0x5b49,0x25a1, 0x5b4a,0x25a1, 
0x5b4f,0x25a1, 0x5b52,0x25a1, 0x5b59,0x5b6b, 0x5b5e,0x25a1, 0x5b60,0x25a1, 
0x5b61,0x25a1, 0x5b66,0x5b78, 0x5b67,0x25a1, 0x5b68,0x25a1, 0x5b6a,0x5b7f, 
0x5b6d,0x25a1, 0x5b6f,0x25a1, 0x5b74,0x25a1, 0x5b76,0x5b73, 0x5b79,0x25a1, 
0x5b7c,0x25a1, 0x5b7e,0x25a1, 0x5b80,0x2f27, 0x5b81,0x5be7, 0x5b82,0x25a1, 
0x5b86,0x25a1, 0x5b8a,0x25a1, 0x5b8d,0x25a1, 0x5b90,0x25a1, 0x5b91,0x25a1, 
0x5b94,0x25a1, 0x5b96,0x25a1, 0x5b9d,0x5bf6, 0x5b9e,0x5be6, 0x5b9f,0x25a1, 
0x5ba0,0x5bf5, 0x5ba1,0x5be9, 0x5ba9,0x25a1, 0x5baa,0x61b2, 0x5bab,0x5bae, 
0x5baf,0x25a1, 0x5bb1,0x25a1, 0x5bb2,0x25a1, 0x5bb7,0x25a1, 0x5bba,0x25a1, 
0x5bbb,0x25a1, 0x5bbc,0x25a1, 0x5bbd,0x5bec, 0x5bbe,0x8cd3, 0x5bc3,0x25a1, 
0x5bc8,0x25a1, 0x5bc9,0x25a1, 0x5bcf,0x25a1, 0x5bd5,0x25a1, 0x5bd7,0x25a1, 
0x5bda,0x25a1, 0x5bdb,0x25a1, 0x5bdc,0x25a1, 0x5bdd,0x5be2, 0x5bed,0x25a1, 
0x5bf3,0x25a1, 0x5bf4,0x25a1, 0x5bf7,0x25a1, 0x5bf9,0x5c0d, 0x5bfb,0x5c0b, 
0x5bfc,0x5c0e, 0x5bfd,0x25a1, 0x5bfe,0x5c0d, 0x5bff,0x58fd, 0x5c00,0x25a1, 
0x5c02,0x5c08, 0x5c05,0x524b, 0x5c06,0x5c07, 0x5c13,0x723e, 0x5c14,0x723e, 
0x5c17,0x25a1, 0x5c18,0x5875, 0x5c19,0x25a1, 0x5c1b,0x25a1, 0x5c1c,0x5c16, 
0x5c1d,0x5617, 0x5c1e,0x25a1, 0x5c20,0x25a1, 0x5c21,0x25a1, 0x5c23,0x25a1, 
0x5c26,0x25a1, 0x5c27,0x582f, 0x5c29,0x25a1, 0x5c2b,0x25a1, 0x5c2d,0x25a1, 
0x5c2e,0x25a1, 0x5c2f,0x25a1, 0x5c32,0x25a1, 0x5c34,0x5c37, 0x5c35,0x25a1, 
0x5c36,0x25a1, 0x5c3d,0x76e1, 0x5c42,0x5c64, 0x5c43,0x5c6d, 0x5c49,0x5c5c, 
0x5c4a,0x5c46, 0x5c52,0x25a1, 0x5c53,0x25a1, 0x5c57,0x25a1, 0x5c5a,0x25a1, 
0x5c5b,0x5c4f, 0x5c5e,0x5c6c, 0x5c5f,0x25a1, 0x5c61,0x5c62, 0x5c66,0x5c68, 
0x5c6b,0x25a1, 0x5c70,0x25a1, 0x5c72,0x25a1, 0x5c75,0x25a1, 0x5c76,0x25a1, 
0x5c77,0x25a1, 0x5c78,0x25a1, 0x5c7d,0x25a1, 0x5c7f,0x5dbc, 0x5c80,0x25a1, 
0x5c81,0x6b72, 0x5c82,0x8c48, 0x5c83,0x25a1, 0x5c84,0x25a1, 0x5c85,0x25a1, 
0x5c87,0x25a1, 0x5c8e,0x25a1, 0x5c96,0x5d87, 0x5c97,0x5d17, 0x5c98,0x5cf4, 
0x5c99,0x5db4, 0x5c9a,0x5d50, 0x5c9b,0x5cf6, 0x5c9c,0x5c8a, 0x5c9e,0x25a1, 
0x5cad,0x5dba, 0x5cb2,0x25a1, 0x5cb4,0x25a1, 0x5cb9,0x25a1, 0x5cba,0x5cad, 
0x5cbb,0x25a1, 0x5cbc,0x25a1, 0x5cbd,0x5d20, 0x5cbe,0x25a1, 0x5cbf,0x5dcb, 
0x5cc0,0x25a1, 0x5cc1,0x536c, 0x5cc2,0x25a1, 0x5cc3,0x5da8, 0x5cc4,0x5da7, 
0x5cc5,0x25a1, 0x5ccd,0x25a1, 0x5cd1,0x25a1, 0x5cd5,0x25a1, 0x5cdc,0x25a1, 
0x5cdd,0x25a1, 0x5ce0,0x25a1, 0x5ce1,0x5cfd, 0x5ce2,0x25a1, 0x5ce3,0x5da2, 
0x5ce4,0x5da0, 0x5ce5,0x5d22, 0x5ce6,0x5dd2, 0x5ce7,0x25a1, 0x5ce9,0x25a1, 
0x5ceb,0x25a1, 0x5cef,0x5cf0, 0x5cf2,0x25a1, 0x5cf3,0x25a1, 0x5cf5,0x25a1, 
0x5cfa,0x25a1, 0x5cfc,0x25a1, 0x5cfe,0x25a1, 0x5d02,0x5d97, 0x5d03,0x5d0d, 
0x5d04,0x5dae, 0x5d05,0x25a1, 0x5d08,0x25a1, 0x5d09,0x25a1, 0x5d0a,0x25a1, 
0x5d10,0x25a1, 0x5d13,0x25a1, 0x5d15,0x25a1, 0x5d18,0x25a1, 0x5d1c,0x25a1, 
0x5d21,0x25a1, 0x5d2a,0x25a1, 0x5d2b,0x25a1, 0x5d2c,0x25a1, 0x5d2d,0x5d84, 
0x5d2f,0x25a1, 0x5d3b,0x25a1, 0x5d3e,0x8981, 0x5d44,0x25a1, 0x5d46,0x25a1, 
0x5d48,0x25a1, 0x5d4d,0x25a1, 0x5d4f,0x25a1, 0x5d53,0x25a1, 0x5d54,0x25a1, 
0x5d56,0x25a1, 0x5d57,0x25a1, 0x5d58,0x5db8, 0x5d5a,0x5d94, 0x5d5b,0x5d33, 
0x5d5c,0x25a1, 0x5d5d,0x5d81, 0x5d5f,0x25a1, 0x5d60,0x25a1, 0x5d61,0x25a1, 
0x5d64,0x25a1, 0x5d66,0x25a1, 0x5d6a,0x25a1, 0x5d6d,0x25a1, 0x5d6e,0x25a1, 
0x5d70,0x25a1, 0x5d73,0x25a1, 0x5d74,0xf80a, 0x5d75,0x25a1, 0x5d76,0x25a1, 
0x5d78,0x25a1, 0x5d7b,0x25a1, 0x5d83,0x25a1, 0x5d85,0x25a1, 0x5d8b,0x25a1, 
0x5d8c,0x25a1, 0x5d8e,0x25a1, 0x5d8f,0x25a1, 0x5d90,0x25a1, 0x5d91,0x25a1, 
0x5d96,0x25a1, 0x5d98,0x25a1, 0x5d9b,0x25a1, 0x5da3,0x25a1, 0x5da4,0x25a1, 
0x5da5,0x25a1, 0x5da6,0x25a1, 0x5dab,0x25a1, 0x5db3,0x25a1, 0x5db6,0x25a1, 
0x5db9,0x25a1, 0x5dbb,0x25a1, 0x5dbe,0x25a1, 0x5dbf,0x25a1, 0x5dc1,0x25a1, 
0x5dc4,0x5dc3, 0x5dc5,0x5dd4, 0x5dc8,0x25a1, 0x5dca,0x25a1, 0x5dcc,0x5dd6, 
0x5dce,0x25a1, 0x5dd0,0x25a1, 0x5dd3,0x5dd4, 0x5dd7,0x25a1, 0x5dd9,0x25a1, 
0x5dda,0x25a1, 0x5ddb,0x2f2e, 0x5ddc,0x25a1, 0x5de3,0x25a1, 0x5de4,0x25a1, 
0x5de9,0x978f, 0x5dea,0x25a1, 0x5dec,0x25a1, 0x5ded,0x25a1, 0x5def,0x5df0, 
0x5df5,0x25a1, 0x5df6,0x25a1, 0x5df8,0x25a1, 0x5dfa,0x25a1, 0x5dfb,0x25a1, 
0x5dfc,0x25a1, 0x5e00,0x25a1, 0x5e01,0x5e63, 0x5e05,0x5e25, 0x5e07,0x25a1, 
0x5e08,0x5e2b, 0x5e09,0x25a1, 0x5e0b,0x25a1, 0x5e0d,0x25a1, 0x5e0f,0x5e43, 
0x5e10,0x5e33, 0x5e12,0x25a1, 0x5e13,0x25a1, 0x5e18,0x7c3e, 0x5e1c,0x5e5f, 
0x5e1e,0x25a1, 0x5e26,0x5e36, 0x5e27,0x5e40, 0x5e2a,0x25a1, 0x5e2c,0x25a1, 
0x5e2e,0x5e6b, 0x5e2f,0x5e36, 0x5e30,0x25a1, 0x5e31,0x5e6c, 0x5e32,0x25a1, 
0x5e35,0x25a1, 0x5e39,0x25a1, 0x5e3a,0x25a1, 0x5e3b,0x5e58, 0x5e3c,0x5e57, 
0x5e3f,0x25a1, 0x5e42,0x51aa, 0x5e46,0x25a1, 0x5e47,0x5e6b, 0x5e48,0x25a1, 
0x5e49,0x25a1, 0x5e50,0x25a1, 0x5e51,0x25a1, 0x5e52,0x25a1, 0x5e56,0x25a1, 
0x5e5a,0x5e6b, 0x5e5e,0x8946, 0x5e64,0x25a1, 0x5e65,0x25a1, 0x5e71,0x25a1, 
0x5e72,0x5e79, 0x5e76,0x4e26, 0x5e77,0x5e76, 0x5e7a,0x4e48, 0x5e7f,0x5ee3, 
0x5e81,0x5ef3, 0x5e83,0x9ebc, 0x5e84,0x838a, 0x5e85,0x9ebc, 0x5e86,0x6176, 
0x5e8e,0x5e84, 0x5e90,0x5eec, 0x5e91,0x5ee1, 0x5e92,0x25a1, 0x5e93,0x5eab, 
0x5e94,0x61c9, 0x5e98,0x25a1, 0x5e99,0x5edf, 0x5e9d,0x25a1, 0x5e9e,0x9f90, 
0x5e9f,0x5ee2, 0x5ea1,0x25a1, 0x5ea9,0x25a1, 0x5eaf,0x25a1, 0x5eba,0x25a1, 
0x5ebb,0x25a1, 0x5ebc,0x5ece, 0x5ebd,0x25a1, 0x5ebf,0x25a1, 0x5ec0,0x25a1, 
0x5ec3,0x25a1, 0x5ecd,0x25a1, 0x5ecf,0x5ec4, 0x5ed0,0x5ec4, 0x5ee4,0x25a1, 
0x5eea,0x5ee9, 0x5eeb,0x25a1, 0x5eed,0x25a1, 0x5ef0,0x25a1, 0x5ef4,0x2f35, 
0x5ef5,0x5de1, 0x5ef8,0x25a1, 0x5ef9,0x25a1, 0x5efb,0x25a1, 0x5efc,0x25a1, 
0x5efd,0x25a1, 0x5f00,0x958b, 0x5f02,0x7570, 0x5f03,0x68c4, 0x5f06,0x25a1, 
0x5f09,0x25a1, 0x5f0c,0x25a1, 0x5f0d,0x25a1, 0x5f0e,0x25a1, 0x5f10,0x25a1, 
0x5f11,0x5f12, 0x5f16,0x25a1, 0x5f19,0x25a1, 0x5f1c,0x25a1, 0x5f1e,0x25a1, 
0x5f20,0x5f35, 0x5f21,0x25a1, 0x5f25,0x5f4c, 0x5f2a,0x5f33, 0x5f2b,0x25a1, 
0x5f2c,0x25a1, 0x5f2f,0x5f4e, 0x5f32,0x25a1, 0x5f34,0x25a1, 0x5f39,0x5f48, 
0x5f3a,0x5f37, 0x5f3b,0x25a1, 0x5f3d,0x25a1, 0x5f3e,0x25a1, 0x5f3f,0x25a1, 
0x5f41,0x25a1, 0x5f42,0x25a1, 0x5f45,0x25a1, 0x5f47,0x25a1, 0x5f4d,0x25a1, 
0x5f50,0x2f39, 0x5f51,0x25a1, 0x5f52,0x6b78, 0x5f53,0x7576, 0x5f55,0x9304, 
0x5f5a,0x5f59, 0x5f5b,0x7fbf, 0x5f5c,0x7fbf, 0x5f5d,0x5f5e, 0x5f5f,0x7372, 
0x5f60,0x7372, 0x5f61,0x2f3a, 0x5f63,0x25a1, 0x5f66,0x5f65, 0x5f68,0x25a1, 
0x5f6e,0x25a1, 0x5f72,0x25a1, 0x5f75,0x25a1, 0x5f77,0x5fac, 0x5f7a,0x25a1, 
0x5f7b,0x5fb9, 0x5f83,0x25a1, 0x5f84,0x5f91, 0x5f8d,0x25a1, 0x5f8e,0x25a1, 
0x5f8f,0x25a1, 0x5f93,0x25a1, 0x5f94,0x25a1, 0x5f95,0x5fa0, 0x5f9a,0x25a1, 
0x5f9d,0x25a1, 0x5fa2,0x25a1, 0x5fa3,0x25a1, 0x5fa4,0x25a1, 0x5fa7,0x25a1, 
0x5fb0,0x25a1, 0x5fb1,0x25a1, 0x5fb3,0x25a1, 0x5fb4,0x25a1, 0x5fb8,0x5fb7, 
0x5fba,0x25a1, 0x5fc2,0x25a1, 0x5fc4,0x5fc3, 0x5fc6,0x61b6, 0x5fc7,0x25a1, 
0x5fc8,0x25a1, 0x5fca,0x25a1, 0x5fcb,0x61b6, 0x5fce,0x25a1, 0x5fcf,0x61fa, 
0x5fd3,0x25a1, 0x5fda,0x25a1, 0x5fdb,0x25a1, 0x5fdc,0x25a1, 0x5fdf,0x25a1, 
0x5fe2,0x25a1, 0x5fe6,0x25a1, 0x5fe7,0x6182, 0x5fe9,0x25a1, 0x5fec,0x25a1, 
0x5ff0,0x25a1, 0x5ff2,0x25a1, 0x5ff6,0x25a1, 0x5ff9,0x25a1, 0x5ffc,0x25a1, 
0x5ffe,0x613e, 0x6000,0x61f7, 0x6001,0x614b, 0x6002,0x616b, 0x6003,0x61ae, 
0x6004,0x616a, 0x6005,0x60b5, 0x6006,0x6134, 0x6007,0x25a1, 0x6008,0x25a1, 
0x6018,0x25a1, 0x601c,0x6190, 0x601f,0x25a1, 0x6023,0x25a1, 0x6030,0x25a1, 
0x6031,0x25a1, 0x6036,0x25a1, 0x6038,0x25a1, 0x603a,0x25a1, 0x603b,0x7e3d, 
0x603c,0x61df, 0x603d,0x25a1, 0x603e,0x25a1, 0x603f,0x61cc, 0x6048,0x25a1, 
0x604a,0x25a1, 0x604b,0x6200, 0x604e,0x25a1, 0x604f,0x25a1, 0x6051,0x25a1, 
0x6052,0x6046, 0x6056,0x25a1, 0x6057,0x25a1, 0x605c,0x25a1, 0x6060,0x25a1, 
0x6061,0x25a1, 0x6071,0x25a1, 0x6073,0x61c7, 0x6074,0x25a1, 0x6075,0x25a1, 
0x6076,0x60e1, 0x6077,0x25a1, 0x6078,0x615f, 0x6079,0x61e8, 0x607a,0x6137, 
0x607b,0x60fb, 0x607c,0x60f1, 0x607d,0x60f2, 0x607e,0x25a1, 0x6082,0x25a1, 
0x608b,0x25a1, 0x608f,0x25a1, 0x6091,0x25a1, 0x6093,0x25a1, 0x6098,0x25a1, 
0x6099,0x25a1, 0x609e,0x25a1, 0x60a1,0x25a1, 0x60a4,0x25a1, 0x60a5,0x25a1, 
0x60a6,0x6085, 0x60a7,0x25a1, 0x60a9,0x25a1, 0x60aa,0x25a1, 0x60ab,0x6128, 
0x60ac,0x61f8, 0x60ad,0x6173, 0x60ae,0x25a1, 0x60af,0x61ab, 0x60b3,0x25a1, 
0x60c2,0x25a1, 0x60ca,0x9a5a, 0x60d0,0x25a1, 0x60d2,0x25a1, 0x60d6,0x25a1, 
0x60d7,0x25a1, 0x60de,0x25a1, 0x60e3,0x25a1, 0x60e5,0x25a1, 0x60e7,0x61fc, 
0x60e8,0x6158, 0x60e9,0x61f2, 0x60ea,0x25a1, 0x60eb,0x618a, 0x60ec,0x611c, 
0x60ed,0x615a, 0x60ee,0x619a, 0x60ef,0x6163, 0x60fd,0x60db, 0x6102,0x25a1, 
0x6107,0x25a1, 0x610c,0x25a1, 0x6111,0x25a1, 0x6117,0x25a1, 0x6119,0x25a1, 
0x611e,0x25a1, 0x6120,0x614d, 0x6121,0x25a1, 0x6122,0x25a1, 0x6124,0x61a4, 
0x6125,0x25a1, 0x6126,0x6192, 0x612a,0x25a1, 0x612d,0x25a1, 0x6130,0x25a1, 
0x6131,0x25a1, 0x6133,0x25a1, 0x6135,0x25a1, 0x6138,0x25a1, 0x6139,0x25a1, 
0x613a,0x25a1, 0x613c,0x25a1, 0x613d,0x25a1, 0x613f,0x9858, 0x6142,0x25a1, 
0x6143,0x25a1, 0x6150,0x25a1, 0x6151,0x61fe, 0x6157,0x25a1, 0x6159,0x25a1, 
0x615c,0x25a1, 0x6160,0x25a1, 0x6164,0x25a1, 0x6169,0x25a1, 0x616d,0x6196, 
0x616f,0x25a1, 0x6178,0x25a1, 0x617b,0x25a1, 0x617d,0x25a1, 0x617f,0x25a1, 
0x6181,0x25a1, 0x6184,0x25a1, 0x6185,0x25a1, 0x6186,0x25a1, 0x6187,0x25a1, 
0x6188,0x25a1, 0x618f,0x25a1, 0x6195,0x25a1, 0x6197,0x25a1, 0x6198,0x25a1, 
0x6199,0x25a1, 0x619c,0x25a1, 0x619e,0x25a1, 0x61a0,0x25a1, 0x61a3,0x25a1, 
0x61a5,0x25a1, 0x61a6,0x25a1, 0x61b7,0x695a, 0x61b9,0x25a1, 0x61bb,0x25a1, 
0x61bd,0x25a1, 0x61c0,0x25a1, 0x61c4,0x25a1, 0x61ce,0x25a1, 0x61cf,0x25a1, 
0x61d0,0x25a1, 0x61d1,0x61e3, 0x61d2,0x61f6, 0x61d3,0x25a1, 0x61d4,0x61cd, 
0x61d5,0x25a1, 0x61d7,0x25a1, 0x61d9,0x25a1, 0x61da,0x25a1, 0x61db,0x25a1, 
0x61dc,0x25a1, 0x61dd,0x25a1, 0x61e1,0x25a1, 0x61e2,0x25a1, 0x61ec,0x25a1, 
0x61ef,0x25a1, 0x61f3,0x25a1, 0x61f4,0x61fa, 0x6202,0x25a1, 0x6205,0x6207, 
0x6206,0x6207, 0x620b,0x6214, 0x620f,0x6232, 0x6213,0x25a1, 0x6217,0x6227, 
0x6218,0x6230, 0x621c,0x25a1, 0x621d,0x6557, 0x621e,0x25a1, 0x6226,0x6230, 
0x6228,0x25a1, 0x622c,0x6229, 0x622f,0x6232, 0x6231,0x6232, 0x6235,0x25a1, 
0x6237,0x6236, 0x6238,0x6236, 0x6239,0x25a1, 0x623b,0x25a1, 0x623c,0x25a1, 
0x6244,0x25a1, 0x6245,0x25a1, 0x624c,0x624b, 0x624f,0x25a1, 0x6251,0x64b2, 
0x6255,0x25a1, 0x6256,0x25a1, 0x6257,0x25a1, 0x625d,0x25a1, 0x625f,0x25a1, 
0x6267,0x57f7, 0x6268,0x25a1, 0x6269,0x64f4, 0x626a,0x636b, 0x626b,0x6383, 
0x626c,0x63da, 0x6270,0x64fe, 0x6275,0x25a1, 0x6278,0x25a1, 0x6282,0x25a1, 
0x6285,0x62d8, 0x628b,0x25a1, 0x628d,0x25a1, 0x6290,0x25a1, 0x6299,0x25a1, 
0x629a,0x64ab, 0x629b,0x62cb, 0x629c,0x25a1, 0x629d,0x25a1, 0x629e,0x25a1, 
0x629f,0x6476, 0x62a0,0x6473, 0x62a1,0x6384, 0x62a2,0x6436, 0x62a3,0x25a1, 
0x62a4,0x8b77, 0x62a5,0x5831, 0x62a6,0x25a1, 0x62a7,0x25a1, 0x62b2,0x25a1, 
0x62b7,0x25a1, 0x62ba,0x25a1, 0x62c0,0x25a1, 0x62c1,0x25a1, 0x62c3,0x25a1, 
0x62c5,0x64d4, 0x62d5,0x25a1, 0x62dd,0x25a1, 0x62de,0x25a1, 0x62df,0x64ec, 
0x62e0,0x25a1, 0x62e1,0x25a1, 0x62e2,0x650f, 0x62e3,0x63c0, 0x62e4,0x25a1, 
0x62e5,0x64c1, 0x62e6,0x6514, 0x62e7,0x64f0, 0x62e8,0x64a5, 0x62e9,0x64c7, 
0x62ea,0x25a1, 0x6304,0x25a1, 0x6305,0x25a1, 0x6306,0x25a1, 0x630a,0x25a1, 
0x6312,0x25a1, 0x6317,0x25a1, 0x6318,0x25a1, 0x6319,0x25a1, 0x631a,0x646f, 
0x631b,0x6523, 0x631c,0x6397, 0x631d,0x64be, 0x631e,0x64bb, 0x631f,0x633e, 
0x6320,0x6493, 0x6321,0x64cb, 0x6322,0x649f, 0x6323,0x6399, 0x6324,0x64e0, 
0x6325,0x63ee, 0x6326,0x648f, 0x6327,0x25a1, 0x632e,0x25a1, 0x6330,0x25a1, 
0x6331,0x25a1, 0x6335,0x25a1, 0x6337,0x25a1, 0x633f,0x25a1, 0x6352,0x25a1, 
0x6353,0x25a1, 0x635b,0x25a1, 0x635c,0x25a1, 0x635d,0x25a1, 0x635e,0x6488, 
0x635f,0x640d, 0x6360,0x25a1, 0x6361,0x64bf, 0x6362,0x63db, 0x6363,0x6417, 
0x6364,0x25a1, 0x6366,0x25a1, 0x636a,0x25a1, 0x636c,0x25a1, 0x636e,0x64da, 
0x6373,0x25a1, 0x6374,0x25a1, 0x6379,0x25a1, 0x637e,0x25a1, 0x637f,0x25a1, 
0x6386,0x25a1, 0x638b,0x25a1, 0x6393,0x25a1, 0x6395,0x25a1, 0x639a,0x25a1, 
0x63a6,0x25a1, 0x63b2,0x25a1, 0x63b3,0x64c4, 0x63b4,0x6451, 0x63b5,0x25a1, 
0x63b6,0x25a1, 0x63b7,0x64f2, 0x63b8,0x64a3, 0x63b9,0x25a1, 0x63ba,0x647b, 
0x63bb,0x25a1, 0x63bc,0x645c, 0x63bf,0x25a1, 0x63c1,0x25a1, 0x63d1,0x25a1, 
0x63d4,0x25a1, 0x63de,0x6309, 0x63e2,0x25a1, 0x63e6,0x25a1, 0x63ec,0x25a1, 
0x63f7,0x25a1, 0x63f8,0x55b3, 0x63fa,0x25a1, 0x63fb,0x25a1, 0x63fc,0x25a1, 
0x63fd,0x652c, 0x63fe,0x25a1, 0x63ff,0x64b3, 0x6400,0x6519, 0x6401,0x64f1, 
0x6402,0x645f, 0x6403,0x6460, 0x6404,0x25a1, 0x6405,0x652a, 0x6407,0x25a1, 
0x6408,0x25a1, 0x640c,0x6990, 0x6411,0x25a1, 0x6419,0x25a1, 0x641d,0x25a1, 
0x6429,0x25a1, 0x6431,0x25a1, 0x6432,0x25a1, 0x6438,0x25a1, 0x643a,0x651c, 
0x643b,0x25a1, 0x643c,0x25a1, 0x6442,0x25a1, 0x6444,0x651d, 0x6445,0x6504, 
0x6446,0x64fa, 0x6447,0x6416, 0x6448,0x64ef, 0x6449,0x25a1, 0x644a,0x6524, 
0x644c,0x25a1, 0x644f,0x25a1, 0x6455,0x25a1, 0x6456,0x25a1, 0x6457,0x25a1, 
0x645a,0x25a1, 0x6462,0x25a1, 0x6463,0x25a1, 0x6464,0x25a1, 0x646a,0x25a1, 
0x6471,0x25a1, 0x647c,0x25a1, 0x647e,0x25a1, 0x6480,0x64ca, 0x6481,0x25a1, 
0x6483,0x64ca, 0x6484,0x6516, 0x6486,0x25a1, 0x648d,0x25a1, 0x648e,0x25a1, 
0x6491,0x6490, 0x6494,0x25a1, 0x649b,0x25a1, 0x64a1,0x25a1, 0x64a7,0x25a1, 
0x64a8,0x25a1, 0x64aa,0x6506, 0x64af,0x25a1, 0x64b4,0x25a1, 0x64b5,0x6506, 
0x64b6,0x25a1, 0x64b7,0x64f7, 0x64b8,0x64fc, 0x64b9,0x652a, 0x64ba,0x651b, 
0x64c0,0x5e79, 0x64c6,0x25a1, 0x64c8,0x25a1, 0x64cc,0x25a1, 0x64d1,0x25a1, 
0x64d3,0x25a1, 0x64d5,0x651c, 0x64dc,0x25a1, 0x64dd,0x25a1, 0x64de,0x64fb, 
0x64df,0x25a1, 0x64e1,0x62ac, 0x64e5,0x6394, 0x64e7,0x8209, 0x64ea,0x58d3, 
0x64ee,0x25a1, 0x64f5,0x25a1, 0x64f6,0x25a1, 0x64f9,0x25a1, 0x6502,0x25a1, 
0x6505,0x25a1, 0x6508,0x25a1, 0x650a,0x25a1, 0x650b,0x25a1, 0x6511,0x25a1, 
0x6512,0x6522, 0x651a,0x25a1, 0x651e,0x25a1, 0x651f,0x25a1, 0x6527,0x25a1, 
0x6528,0x25a1, 0x6530,0x25a1, 0x6531,0x25a1, 0x6534,0x2f41, 0x6535,0x53c8, 
0x653a,0x25a1, 0x653c,0x25a1, 0x6540,0x25a1, 0x6542,0x25a1, 0x6544,0x25a1, 
0x6547,0x6555, 0x654b,0x25a1, 0x654c,0x6575, 0x654d,0x25a1, 0x654e,0x25a1, 
0x6550,0x25a1, 0x6552,0x25a1, 0x655a,0x25a1, 0x655b,0x6582, 0x655f,0x25a1, 
0x6560,0x25a1, 0x6561,0x25a1, 0x6569,0x25a1, 0x656b,0x6a84, 0x656d,0x25a1, 
0x656e,0x6b43, 0x6570,0x6578, 0x6571,0x25a1, 0x657d,0x25a1, 0x657e,0x25a1, 
0x6585,0x25a1, 0x6586,0x25a1, 0x6588,0x25a1, 0x6589,0x9f4a, 0x658a,0x25a1, 
0x658b,0x9f4b, 0x658d,0x25a1, 0x658e,0x9f4b, 0x658f,0x25a1, 0x6593,0x6595, 
0x6598,0x25a1, 0x659a,0x25a1, 0x65a3,0x25a1, 0x65a6,0x25a1, 0x65a9,0x65ac, 
0x65ad,0x65b7, 0x65b1,0x25a1, 0x65b4,0x25a1, 0x65b5,0x25a1, 0x65ba,0x25a1, 
0x65be,0x25a1, 0x65c0,0x25a1, 0x65c7,0x25a1, 0x65c8,0x25a1, 0x65c9,0x25a1, 
0x65ca,0x25a1, 0x65d1,0x25a1, 0x65d4,0x25a1, 0x65d5,0x25a1, 0x65d8,0x25a1, 
0x65d9,0x25a1, 0x65dc,0x25a1, 0x65e0,0x7121, 0x65e3,0x25a1, 0x65e4,0x25a1, 
0x65e7,0x820a, 0x65ea,0x25a1, 0x65eb,0x25a1, 0x65f6,0x6642, 0x65f7,0x66e0, 
0x65f8,0x6698, 0x65f9,0x25a1, 0x65fe,0x25a1, 0x65ff,0x25a1, 0x6601,0x25a1, 
0x6616,0x25a1, 0x6617,0x25a1, 0x6618,0x25a1, 0x6619,0x66c7, 0x661a,0x25a1, 
0x661b,0x25a1, 0x661e,0x25a1, 0x6623,0x25a1, 0x6629,0x25a1, 0x662a,0x25a1, 
0x662c,0x25a1, 0x6630,0x25a1, 0x6635,0x66b1, 0x6637,0x25a1, 0x6638,0x25a1, 
0x663b,0x25a1, 0x663c,0x665d, 0x663d,0x66e8, 0x663e,0x986f, 0x663f,0x25a1, 
0x6640,0x25a1, 0x6644,0x25a1, 0x6646,0x25a1, 0x6648,0x25a1, 0x664b,0x6649, 
0x664d,0x25a1, 0x664e,0x25a1, 0x6650,0x25a1, 0x6652,0x66ec, 0x6653,0x66c9, 
0x6654,0x66c4, 0x6655,0x6688, 0x6656,0x6689, 0x6657,0x542b, 0x6658,0x25a1, 
0x6660,0x25a1, 0x6663,0x25a1, 0x6667,0x25a1, 0x6669,0x25a1, 0x666b,0x25a1, 
0x666d,0x25a1, 0x6673,0x25a1, 0x6675,0x25a1, 0x667d,0x25a1, 0x667f,0x25a1, 
0x6681,0x25a1, 0x6682,0x66ab, 0x6683,0x25a1, 0x6685,0x25a1, 0x668e,0x25a1, 
0x668f,0x25a1, 0x6692,0x25a1, 0x6693,0x25a1, 0x669a,0x25a1, 0x669b,0x25a1, 
0x669c,0x25a1, 0x669e,0x25a1, 0x66a3,0x25a1, 0x66a4,0x25a1, 0x66a5,0x25a1, 
0x66a6,0x25a1, 0x66a7,0x66d6, 0x66ac,0x25a1, 0x66ad,0x25a1, 0x66b3,0x25a1, 
0x66b6,0x25a1, 0x66bc,0x25a1, 0x66bf,0x25a1, 0x66c1,0x25a1, 0x66c2,0x25a1, 
0x66c3,0x25a1, 0x66c5,0x25a1, 0x66cd,0x25a1, 0x66ce,0x25a1, 0x66d0,0x25a1, 
0x66d1,0x25a1, 0x66d3,0x25a1, 0x66d4,0x25a1, 0x66d5,0x25a1, 0x66d7,0x25a1, 
0x66df,0x25a1, 0x66e1,0x25a1, 0x66e2,0x25a1, 0x66e5,0x25a1, 0x66e7,0x25a1, 
0x66ea,0x25a1, 0x66ef,0x25a1, 0x66f1,0x25a1, 0x66f5,0x25a1, 0x66fa,0x25a1, 
0x66fb,0x25a1, 0x66fd,0x25a1, 0x6702,0x25a1, 0x6706,0x25a1, 0x6707,0x25a1, 
0x670c,0x25a1, 0x670e,0x25a1, 0x6711,0x25a1, 0x6716,0x25a1, 0x6719,0x25a1, 
0x671a,0x25a1, 0x671c,0x25a1, 0x671e,0x25a1, 0x6724,0x25a1, 0x6725,0x25a1, 
0x6729,0x25a1, 0x672f,0x8853, 0x6730,0x25a1, 0x6732,0x25a1, 0x6734,0x6a38, 
0x6736,0x25a1, 0x6737,0x25a1, 0x673a,0x6a5f, 0x6740,0x6bba, 0x6741,0x25a1, 
0x6742,0x96dc, 0x6743,0x6b0a, 0x6744,0x25a1, 0x6746,0x687f, 0x674a,0x25a1, 
0x6752,0x25a1, 0x6754,0x25a1, 0x6758,0x25a1, 0x675b,0x25a1, 0x6761,0x689d, 
0x6762,0x25a1, 0x6763,0x25a1, 0x6764,0x25a1, 0x6765,0x4f86, 0x6766,0x25a1, 
0x6767,0x25a1, 0x6768,0x694a, 0x6769,0x69aa, 0x676b,0x25a1, 0x676e,0x25a1, 
0x6770,0x5091, 0x6780,0x25a1, 0x6781,0x6975, 0x6782,0x25a1, 0x6784,0x69cb, 
0x6788,0x25a1, 0x678a,0x25a1, 0x678f,0x25a1, 0x6796,0x25a1, 0x679b,0x25a1, 
0x679e,0x6a05, 0x67a0,0x25a1, 0x67a1,0x25a1, 0x67a2,0x6a1e, 0x67a3,0x68d7, 
0x67a4,0x25a1, 0x67a5,0x6aea, 0x67a6,0x25a1, 0x67a7,0x898b, 0x67a8,0x68d6, 
0x67a9,0x25a1, 0x67aa,0x69cd, 0x67ab,0x6953, 0x67ac,0x25a1, 0x67ad,0x689f, 
0x67b1,0x25a1, 0x67bc,0x25a1, 0x67bd,0x25a1, 0x67be,0x25a1, 0x67bf,0x25a1, 
0x67c7,0x25a1, 0x67d5,0x25a1, 0x67d6,0x25a1, 0x67d7,0x25a1, 0x67dc,0x6ac3, 
0x67e0,0x6ab8, 0x67e1,0x25a1, 0x67e8,0x25a1, 0x67f9,0x25a1, 0x67fb,0x25a1, 
0x67fd,0x6a89, 0x67fe,0x25a1, 0x6800,0x6894, 0x6801,0x25a1, 0x6802,0x25a1, 
0x6803,0x25a1, 0x6804,0x25a1, 0x6805,0x67f5, 0x6806,0x25a1, 0x6807,0x6a19, 
0x6808,0x68e7, 0x6809,0x6adb, 0x680a,0x6af3, 0x680b,0x68df, 0x680c,0x6ae8, 
0x680d,0x25a1, 0x680e,0x6adf, 0x680f,0x6b04, 0x6810,0x25a1, 0x6811,0x6a39, 
0x6815,0x25a1, 0x6816,0x68f2, 0x6817,0x6144, 0x6819,0x25a1, 0x681b,0x25a1, 
0x681e,0x25a1, 0x6822,0x25a1, 0x6823,0x25a1, 0x6824,0x25a1, 0x6827,0x25a1, 
0x682c,0x25a1, 0x6830,0x25a1, 0x6836,0x25a1, 0x6837,0x6a23, 0x683e,0x6b12, 
0x683f,0x25a1, 0x6847,0x25a1, 0x684a,0x68ec, 0x6852,0x25a1, 0x6855,0x6a01, 
0x6856,0x25a1, 0x6857,0x25a1, 0x6858,0x25a1, 0x6859,0x25a1, 0x685a,0x25a1, 
0x685b,0x25a1, 0x685c,0x25a1, 0x685d,0x25a1, 0x685e,0x25a1, 0x685f,0x25a1, 
0x6860,0x690f, 0x6861,0x6a48, 0x6862,0x6968, 0x6863,0x6a94, 0x6864,0x69bf, 
0x6865,0x6a4b, 0x6866,0x6a3a, 0x6867,0x6a9c, 0x6868,0x69f3, 0x6869,0x6a01, 
0x686a,0x25a1, 0x686c,0x25a1, 0x6870,0x25a1, 0x6873,0x25a1, 0x687a,0x25a1, 
0x6884,0x25a1, 0x6888,0x25a1, 0x688d,0x25a1, 0x688e,0x25a1, 0x6895,0x25a1, 
0x6898,0x25a1, 0x6899,0x25a1, 0x689a,0x25a1, 0x689e,0x25a1, 0x68a5,0x25a1, 
0x68a6,0x5922, 0x68b6,0x25a1, 0x68b7,0x25a1, 0x68b8,0x25a1, 0x68b9,0x25a1, 
0x68ba,0x25a1, 0x68bb,0x25a1, 0x68bc,0x6aae, 0x68bd,0x25a1, 0x68be,0x68f6, 
0x68bf,0x25a1, 0x68c0,0x6aa2, 0x68c1,0x25a1, 0x68c2,0x6b1e, 0x68c3,0x25a1, 
0x68c5,0x25a1, 0x68ca,0x25a1, 0x68cf,0x25a1, 0x68d9,0x25a1, 0x68db,0x25a1, 
0x68e2,0x25a1, 0x68e5,0x25a1, 0x68ed,0x25a1, 0x68fe,0x25a1, 0x68ff,0x25a1, 
0x6900,0x25a1, 0x6901,0x69e8, 0x6902,0x25a1, 0x6903,0x25a1, 0x6909,0x25a1, 
0x6916,0x25a1, 0x6918,0x25a1, 0x6919,0x25a1, 0x691a,0x25a1, 0x691b,0x25a1, 
0x691c,0x25a1, 0x691d,0x25a1, 0x691e,0x25a1, 0x691f,0x6add, 0x6920,0x69e7, 
0x6921,0x25a1, 0x6922,0x25a1, 0x6923,0x25a1, 0x6924,0x6b0f, 0x6926,0x25a1, 
0x6927,0x25a1, 0x6928,0x25a1, 0x6929,0x25a1, 0x692b,0x25a1, 0x692c,0x25a1, 
0x692d,0x6a62, 0x692e,0x25a1, 0x6931,0x25a1, 0x6936,0x25a1, 0x693a,0x25a1, 
0x693e,0x25a1, 0x6943,0x25a1, 0x6946,0x25a1, 0x6947,0x25a1, 0x694d,0x25a1, 
0x6950,0x25a1, 0x6955,0x25a1, 0x6961,0x25a1, 0x6964,0x25a1, 0x6967,0x25a1, 
0x6972,0x25a1, 0x6973,0x25a1, 0x697c,0x6a13, 0x697d,0x6a02, 0x697e,0x25a1, 
0x697f,0x25a1, 0x6980,0x54c1, 0x6981,0x25a1, 0x6984,0x6b16, 0x6985,0x25a1, 
0x6987,0x6aec, 0x6988,0x6ada, 0x6989,0x6af8, 0x698a,0x25a1, 0x698b,0x25a1, 
0x698c,0x25a1, 0x698f,0x25a1, 0x6992,0x25a1, 0x6998,0x77e9, 0x699d,0x25a1, 
0x699f,0x25a1, 0x69a2,0x25a1, 0x69b2,0x25a1, 0x69b8,0x25a1, 0x69ba,0x25a1, 
0x69c0,0x25a1, 0x69c5,0x25a1, 0x69c7,0x25a1, 0x69c8,0x25a1, 0x69d1,0x25a1, 
0x69d2,0x25a1, 0x69d5,0x25a1, 0x69d6,0x25a1, 0x69d7,0x25a1, 0x69d8,0x25a1, 
0x69da,0x6a9f, 0x69db,0x6abb, 0x69dc,0x25a1, 0x69dd,0x25a1, 0x69de,0x25a1, 
0x69df,0x6ab3, 0x69e0,0x6ae7, 0x69e1,0x25a1, 0x69e3,0x25a1, 0x69e9,0x25a1, 
0x69ea,0x25a1, 0x69ef,0x25a1, 0x69f0,0x25a1, 0x69f5,0x25a1, 0x69f9,0x25a1, 
0x69fa,0x25a1, 0x6a03,0x25a1, 0x6a0b,0x25a1, 0x6a0c,0x25a1, 0x6a0e,0x25a1, 
0x6a10,0x25a1, 0x6a12,0x25a1, 0x6a1a,0x25a1, 0x6a1c,0x25a1, 0x6a22,0x25a1, 
0x6a24,0x25a1, 0x6a29,0x25a1, 0x6a2a,0x6a6b, 0x6a2b,0x25a1, 0x6a2c,0x25a1, 
0x6a2d,0x25a1, 0x6a2e,0x25a1, 0x6a2f,0x6aa3, 0x6a30,0x25a1, 0x6a31,0x6afb, 
0x6a33,0x25a1, 0x6a36,0x25a1, 0x6a37,0x25a1, 0x6a42,0x25a1, 0x6a43,0x25a1, 
0x6a45,0x25a1, 0x6a4a,0x25a1, 0x6a4c,0x25a1, 0x6a52,0x25a1, 0x6a53,0x25a1, 
0x6a57,0x25a1, 0x6a5c,0x25a1, 0x6a63,0x25a1, 0x6a65,0x6aeb, 0x6a6c,0x25a1, 
0x6a6e,0x25a1, 0x6a70,0x25a1, 0x6a71,0x6ae5, 0x6a72,0x25a1, 0x6a73,0x25a1, 
0x6a74,0x25a1, 0x6a75,0x25a1, 0x6a77,0x25a1, 0x6a78,0x25a1, 0x6a79,0x6ad3, 
0x6a7a,0x25a1, 0x6a7b,0x25a1, 0x6a7c,0x6ade, 0x6a7d,0x25a1, 0x6a82,0x25a1, 
0x6a86,0x25a1, 0x6a88,0x25a1, 0x6a8a,0x25a1, 0x6a8b,0x25a1, 0x6a8f,0x25a1, 
0x6a90,0x7c37, 0x6a98,0x25a1, 0x6a99,0x25a1, 0x6a9d,0x25a1, 0x6aa7,0x25a1, 
0x6aa9,0x6a81, 0x6aaa,0x6adf, 0x6aab,0x5bdf, 0x6ab0,0x25a1, 0x6ab1,0x25a1, 
0x6ab2,0x25a1, 0x6ab5,0x25a1, 0x6abc,0x25a1, 0x6abe,0x25a1, 0x6abf,0x25a1, 
0x6ac0,0x25a1, 0x6ac1,0x25a1, 0x6ac4,0x25a1, 0x6ac8,0x25a1, 0x6ac9,0x25a1, 
0x6aca,0x25a1, 0x6ace,0x25a1, 0x6ad2,0x25a1, 0x6ad4,0x25a1, 0x6ad5,0x25a1, 
0x6ad6,0x25a1, 0x6ad7,0x25a1, 0x6ad8,0x25a1, 0x6ae2,0x25a1, 0x6ae3,0x25a1, 
0x6ae4,0x25a1, 0x6ae6,0x25a1, 0x6ae9,0x25a1, 0x6aed,0x25a1, 0x6af2,0x25a1, 
0x6af4,0x25a1, 0x6af5,0x25a1, 0x6af6,0x25a1, 0x6af7,0x25a1, 0x6afd,0x25a1, 
0x6afe,0x25a1, 0x6aff,0x25a1, 0x6b01,0x25a1, 0x6b05,0x25a1, 0x6b06,0x25a1, 
0x6b07,0x25a1, 0x6b0c,0x25a1, 0x6b0d,0x25a1, 0x6b0e,0x25a1, 0x6b14,0x25a1, 
0x6b15,0x25a1, 0x6b1b,0x25a1, 0x6b1c,0x25a1, 0x6b1d,0x25a1, 0x6b1f,0x25a1, 
0x6b22,0x6b61, 0x6b24,0x6b5f, 0x6b26,0x25a1, 0x6b27,0x6b50, 0x6b29,0x25a1, 
0x6b2a,0x25a1, 0x6b2b,0x6b43, 0x6b2e,0x25a1, 0x6b30,0x6b43, 0x6b35,0x25a1, 
0x6b40,0x25a1, 0x6b44,0x25a1, 0x6b4f,0x25a1, 0x6b52,0x25a1, 0x6b53,0x25a1, 
0x6b57,0x25a1, 0x6b58,0x25a1, 0x6b5a,0x25a1, 0x6b5d,0x25a1, 0x6b68,0x25a1, 
0x6b69,0x25a1, 0x6b6b,0x25a1, 0x6b6c,0x25a1, 0x6b6e,0x25a1, 0x6b6f,0x25a1, 
0x6b70,0x25a1, 0x6b71,0x25a1, 0x6b73,0x6b72, 0x6b74,0x66c6, 0x6b75,0x25a1, 
0x6b7a,0x6b72, 0x6b7c,0x6bb2, 0x6b7d,0x25a1, 0x6b81,0x6b7f, 0x6b85,0x25a1, 
0x6b87,0x6ba4, 0x6b8b,0x6b98, 0x6b90,0x25a1, 0x6b92,0x6b9e, 0x6b93,0x6bae, 
0x6b9a,0x6bab, 0x6b9c,0x25a1, 0x6b9d,0x25a1, 0x6ba1,0x6baf, 0x6ba8,0x25a1, 
0x6ba9,0x25a1, 0x6bac,0x25a1, 0x6bb1,0x6bb2, 0x6bb4,0x6bc6, 0x6bb8,0x25a1, 
0x6bb9,0x25a1, 0x6bbb,0x25a1, 0x6bbe,0x25a1, 0x6bc1,0x6bc0, 0x6bc2,0x8f42, 
0x6bce,0x25a1, 0x6bd1,0x25a1, 0x6bd5,0x7562, 0x6bd9,0x6583, 0x6bdc,0x25a1, 
0x6bdd,0x25a1, 0x6bdf,0x25a1, 0x6be1,0x6c08, 0x6be5,0x25a1, 0x6be9,0x25a1, 
0x6bea,0x725f, 0x6bed,0x25a1, 0x6bee,0x25a1, 0x6bf1,0x25a1, 0x6bf4,0x25a1, 
0x6bf5,0x6bff, 0x6bf6,0x97a0, 0x6bfa,0x25a1, 0x6c07,0x6c0c, 0x6c0a,0x25a1, 
0x6c0e,0x25a1, 0x6c12,0x25a1, 0x6c14,0x6c23, 0x6c17,0x6c23, 0x6c1c,0x25a1, 
0x6c1e,0x25a1, 0x6c22,0x6c2b, 0x6c29,0x6c2c, 0x6c2d,0x25a1, 0x6c31,0x25a1, 
0x6c32,0x6c33, 0x6c35,0x6c34, 0x6c37,0x25a1, 0x6c39,0x25a1, 0x6c3a,0x25a1, 
0x6c3c,0x25a1, 0x6c3d,0x6c46, 0x6c44,0x25a1, 0x6c45,0x25a1, 0x6c47,0x532f, 
0x6c48,0x25a1, 0x6c49,0x6f22, 0x6c51,0x25a1, 0x6c53,0x25a1, 0x6c56,0x25a1, 
0x6c58,0x25a1, 0x6c5a,0x25a1, 0x6c62,0x25a1, 0x6c63,0x25a1, 0x6c64,0x6e6f, 
0x6c6c,0x25a1, 0x6c6e,0x25a1, 0x6c75,0x25a1, 0x6c77,0x25a1, 0x6c79,0x6d36, 
0x6c7c,0x25a1, 0x6c7f,0x25a1, 0x6c91,0x25a1, 0x6c97,0x25a1, 0x6c9e,0x25a1, 
0x6c9f,0x6e9d, 0x6ca0,0x25a1, 0x6ca1,0x6c92, 0x6ca2,0x25a1, 0x6ca3,0x7043, 
0x6ca4,0x6f1a, 0x6ca5,0x701d, 0x6ca6,0x6dea, 0x6ca7,0x6ec4, 0x6ca8,0x6e22, 
0x6ca9,0x6e88, 0x6caa,0x6eec, 0x6caf,0x25a1, 0x6cb2,0x6c60, 0x6cb5,0x6fd4, 
0x6cc4,0x6d29, 0x6cc8,0x25a1, 0x6ccb,0x25a1, 0x6cce,0x25a1, 0x6cd8,0x25a1, 
0x6cde,0x6fd8, 0x6cdf,0x25a1, 0x6ce4,0x25a1, 0x6ce6,0x25a1, 0x6cea,0x6dda, 
0x6cf4,0x25a1, 0x6cf6,0x6fa9, 0x6cf7,0x7027, 0x6cf8,0x7018, 0x6cfa,0x6ffc, 
0x6cfb,0x7009, 0x6cfc,0x6f51, 0x6cfd,0x6fa4, 0x6cfe,0x6d87, 0x6cff,0x25a1, 
0x6d01,0x6f54, 0x6d02,0x25a1, 0x6d05,0x25a1, 0x6d06,0x25a1, 0x6d12,0x7051, 
0x6d13,0x25a1, 0x6d14,0x25a1, 0x6d15,0x25a1, 0x6d1c,0x25a1, 0x6d21,0x25a1, 
0x6d23,0x25a1, 0x6d24,0x25a1, 0x6d26,0x25a1, 0x6d3c,0x7aaa, 0x6d43,0x6d79, 
0x6d44,0x25a1, 0x6d45,0x6dfa, 0x6d46,0x6f3f, 0x6d47,0x6f86, 0x6d48,0x6e5e, 
0x6d49,0x6eae, 0x6d4a,0x6fc1, 0x6d4b,0x6e2c, 0x6d4c,0x25a1, 0x6d4d,0x6fae, 
0x6d4e,0x6fdf, 0x6d4f,0x700f, 0x6d50,0x6efb, 0x6d51,0x6e3e, 0x6d52,0x6ef8, 
0x6d53,0x6fc3, 0x6d54,0x6f6f, 0x6d55,0x6fdc, 0x6d56,0x25a1, 0x6d57,0x25a1, 
0x6d5b,0x25a1, 0x6d5c,0x6ff1, 0x6d5d,0x25a1, 0x6d6b,0x25a1, 0x6d71,0x25a1, 
0x6d72,0x25a1, 0x6d73,0x25a1, 0x6d81,0x25a1, 0x6d82,0x5857, 0x6d8c,0x6e67, 
0x6d8f,0x25a1, 0x6d96,0x25a1, 0x6d99,0x6dda, 0x6d9a,0x25a1, 0x6d9b,0x6fe4, 
0x6d9c,0x25a1, 0x6d9d,0x6f87, 0x6d9e,0x6df6, 0x6d9f,0x6f23, 0x6da0,0x6f7f, 
0x6da1,0x6e26, 0x6da2,0x6eb3, 0x6da3,0x6e19, 0x6da4,0x6ecc, 0x6da5,0x25a1, 
0x6da6,0x6f64, 0x6da7,0x6f97, 0x6da8,0x6f32, 0x6da9,0x6f80, 0x6dad,0x25a1, 
0x6db0,0x25a1, 0x6db1,0x25a1, 0x6db6,0x25a1, 0x6db9,0x25a1, 0x6dc0,0x6fb1, 
0x6dc1,0x25a1, 0x6dc3,0x25a1, 0x6dce,0x25a1, 0x6de7,0x25a1, 0x6df8,0x25a1, 
0x6dfe,0x25a1, 0x6dff,0x25a1, 0x6e01,0x25a1, 0x6e02,0x25a1, 0x6e04,0x25a1, 
0x6e06,0x25a1, 0x6e07,0x25a1, 0x6e08,0x25a1, 0x6e09,0x25a1, 0x6e0a,0x6df5, 
0x6e0b,0x25a1, 0x6e0c,0x6de5, 0x6e0d,0x6f2c, 0x6e0e,0x7006, 0x6e0f,0x25a1, 
0x6e10,0x6f38, 0x6e11,0x6fa0, 0x6e12,0x25a1, 0x6e13,0x25a1, 0x6e14,0x6f01, 
0x6e15,0x25a1, 0x6e16,0x700b, 0x6e17,0x6ef2, 0x6e18,0x25a1, 0x6e1e,0x25a1, 
0x6e29,0x6eab, 0x6e2a,0x25a1, 0x6e37,0x25a1, 0x6e42,0x25a1, 0x6e48,0x25a1, 
0x6e4c,0x25a1, 0x6e4f,0x25a1, 0x6e50,0x25a1, 0x6e57,0x25a1, 0x6e59,0x25a1, 
0x6e6a,0x25a1, 0x6e6c,0x25a1, 0x6e6d,0x25a1, 0x6e70,0x25a1, 0x6e75,0x25a1, 
0x6e76,0x25a1, 0x6e7a,0x25a1, 0x6e7b,0x25a1, 0x6e7c,0x6d85, 0x6e7d,0x25a1, 
0x6e7e,0x7063, 0x6e7f,0x6fd5, 0x6e80,0x25a1, 0x6e81,0x25a1, 0x6e82,0x25a1, 
0x6e83,0x6f70, 0x6e84,0x25a1, 0x6e85,0x6ffa, 0x6e86,0x6f35, 0x6e87,0x6f0a, 
0x6e8a,0x25a1, 0x6e8b,0x25a1, 0x6e8c,0x25a1, 0x6e91,0x25a1, 0x6e95,0x25a1, 
0x6e9a,0x25a1, 0x6ea8,0x25a1, 0x6ea9,0x25a1, 0x6eac,0x25a1, 0x6ead,0x25a1, 
0x6eb5,0x25a1, 0x6eb8,0x25a1, 0x6ebb,0x79a2, 0x6ed7,0x6f77, 0x6ed9,0x532f, 
0x6eda,0x6efe, 0x6edb,0x25a1, 0x6edd,0x7027, 0x6ede,0x6eef, 0x6edf,0x7069, 
0x6ee0,0x7044, 0x6ee1,0x6eff, 0x6ee2,0x7005, 0x6ee3,0x25a1, 0x6ee4,0x6ffe, 
0x6ee5,0x6feb, 0x6ee6,0x7064, 0x6ee7,0x25a1, 0x6ee8,0x6ff1, 0x6ee9,0x7058, 
0x6eea,0x6fa6, 0x6ef0,0x25a1, 0x6ef3,0x25a1, 0x6efa,0x25a1, 0x6f04,0x25a1, 
0x6f0b,0x25a1, 0x6f0c,0x25a1, 0x6f10,0x25a1, 0x6f11,0x6e89, 0x6f16,0x25a1, 
0x6f17,0x25a1, 0x6f1b,0x25a1, 0x6f1d,0x25a1, 0x6f24,0x7060, 0x6f28,0x25a1, 
0x6f34,0x25a1, 0x6f3d,0x25a1, 0x6f42,0x25a1, 0x6f44,0x25a1, 0x6f45,0x25a1, 
0x6f46,0x7020, 0x6f47,0x701f, 0x6f48,0x25a1, 0x6f49,0x25a1, 0x6f4a,0x25a1, 
0x6f4b,0x7032, 0x6f4c,0x25a1, 0x6f4d,0x6ff0, 0x6f56,0x25a1, 0x6f59,0x25a1, 
0x6f5c,0x6f5b, 0x6f65,0x25a1, 0x6f68,0x25a1, 0x6f71,0x25a1, 0x6f74,0x7026, 
0x6f75,0x25a1, 0x6f79,0x25a1, 0x6f81,0x25a1, 0x6f83,0x25a1, 0x6f8a,0x25a1, 
0x6f8f,0x25a1, 0x6f91,0x25a1, 0x6f98,0x25a1, 0x6f99,0x25a1, 0x6f9a,0x25a1, 
0x6f9b,0x25a1, 0x6f9c,0x703e, 0x6f9d,0x25a1, 0x6f9f,0x25a1, 0x6fb5,0x25a1, 
0x6fb7,0x25a1, 0x6fbb,0x25a1, 0x6fbe,0x25a1, 0x6fc5,0x25a1, 0x6fd0,0x25a1, 
0x6fd1,0x7028, 0x6fd2,0x7015, 0x6fd3,0x25a1, 0x6fd6,0x25a1, 0x6fd7,0x25a1, 
0x6fd9,0x25a1, 0x6fda,0x25a1, 0x6fe5,0x25a1, 0x6fea,0x25a1, 0x6ff3,0x25a1, 
0x6ff5,0x25a1, 0x6ff6,0x25a1, 0x6ff8,0x25a1, 0x6ff9,0x25a1, 0x6ffd,0x25a1, 
0x7002,0x25a1, 0x7003,0x25a1, 0x7008,0x25a1, 0x7010,0x25a1, 0x7012,0x25a1, 
0x7013,0x25a1, 0x701e,0x25a1, 0x7025,0x25a1, 0x702c,0x25a1, 0x702d,0x25a1, 
0x702e,0x25a1, 0x7036,0x25a1, 0x703d,0x25a1, 0x7047,0x25a1, 0x704b,0x25a1, 
0x704d,0x25a1, 0x704e,0x7069, 0x704f,0x705d, 0x7050,0x25a1, 0x7053,0x25a1, 
0x7054,0x7069, 0x7059,0x25a1, 0x705c,0x701b, 0x7067,0x7069, 0x706c,0x706b, 
0x706d,0x6ec5, 0x706e,0x25a1, 0x706f,0x71c8, 0x7072,0x25a1, 0x7073,0x25a1, 
0x7075,0x9748, 0x7077,0x25a1, 0x7079,0x25a1, 0x707b,0x25a1, 0x707e,0x707d, 
0x707f,0x71e6, 0x7080,0x716c, 0x7081,0x25a1, 0x7087,0x25a1, 0x7088,0x25a1, 
0x7089,0x7210, 0x708b,0x25a1, 0x708c,0x25a1, 0x708d,0x25a1, 0x708f,0x25a1, 
0x7090,0x25a1, 0x7096,0x71c9, 0x7097,0x25a1, 0x709b,0x25a1, 0x709c,0x7152, 
0x709d,0x7197, 0x709e,0x25a1, 0x70a0,0x25a1, 0x70a2,0x25a1, 0x70a3,0x25a1, 
0x70a5,0x25a1, 0x70a6,0x25a1, 0x70a7,0x25a1, 0x70a8,0x25a1, 0x70aa,0x25a1, 
0x70b2,0x25a1, 0x70b6,0x25a1, 0x70b9,0x9ede, 0x70bb,0x77f3, 0x70bc,0x7149, 
0x70bd,0x71be, 0x70bf,0x25a1, 0x70c0,0x4e4e, 0x70c1,0x720d, 0x70c2,0x721b, 
0x70c3,0x70f4, 0x70c4,0x25a1, 0x70c9,0x25a1, 0x70cc,0x25a1, 0x70d0,0x25a1, 
0x70d5,0x25a1, 0x70d6,0x25a1, 0x70db,0x71ed, 0x70df,0x7159, 0x70e3,0x25a1, 
0x70e5,0x25a1, 0x70e6,0x7169, 0x70e7,0x71d2, 0x70e8,0x71c1, 0x70e9,0x71f4, 
0x70ea,0x25a1, 0x70eb,0x71d9, 0x70ec,0x71fc, 0x70ed,0x71b1, 0x70ee,0x25a1, 
0x70f1,0x25a1, 0x70f2,0x25a1, 0x70f5,0x25a1, 0x70fe,0x25a1, 0x7101,0x25a1, 
0x7103,0x25a1, 0x7105,0x25a1, 0x7107,0x25a1, 0x7108,0x25a1, 0x710f,0x25a1, 
0x7111,0x25a1, 0x7112,0x25a1, 0x7114,0x25a1, 0x7115,0x7165, 0x7116,0x71dc, 
0x7118,0x71fe, 0x711d,0x25a1, 0x7124,0x25a1, 0x7127,0x25a1, 0x7129,0x25a1, 
0x712a,0x25a1, 0x712b,0x25a1, 0x712c,0x25a1, 0x712d,0x25a1, 0x7133,0x25a1, 
0x7134,0x25a1, 0x7135,0x25a1, 0x7137,0x25a1, 0x7138,0x25a1, 0x7139,0x25a1, 
0x713b,0x25a1, 0x713c,0x25a1, 0x713d,0x25a1, 0x713e,0x25a1, 0x713f,0x25a1, 
0x7140,0x25a1, 0x7145,0x7146, 0x7148,0x25a1, 0x714a,0x5ba3, 0x714f,0x25a1, 
0x7151,0x25a1, 0x7155,0x25a1, 0x7157,0x25a1, 0x715b,0x25a1, 0x716b,0x25a1, 
0x716d,0x25a1, 0x716f,0x25a1, 0x7171,0x25a1, 0x7173,0x7cca, 0x7174,0x25a1, 
0x7175,0x25a1, 0x7176,0x25a1, 0x7177,0x25a1, 0x7179,0x25a1, 0x717a,0x9000, 
0x717c,0x25a1, 0x717e,0x25a1, 0x717f,0x25a1, 0x7183,0x25a1, 0x7188,0x25a1, 
0x718b,0x25a1, 0x718c,0x25a1, 0x718d,0x25a1, 0x718e,0x25a1, 0x7191,0x25a1, 
0x7193,0x25a1, 0x7195,0x25a1, 0x7196,0x25a1, 0x7198,0x6e9c, 0x71a2,0x25a1, 
0x71a3,0x25a1, 0x71a6,0x25a1, 0x71ab,0x25a1, 0x71ad,0x5f57, 0x71ae,0x25a1, 
0x71b4,0x25a1, 0x71b6,0x25a1, 0x71b7,0x25a1, 0x71ba,0x25a1, 0x71bb,0x25a1, 
0x71cc,0x25a1, 0x71cd,0x25a1, 0x71d1,0x25a1, 0x71d3,0x25a1, 0x71d7,0x25a1, 
0x71dd,0x25a1, 0x71de,0x25a1, 0x71e3,0x25a1, 0x71e9,0x25a1, 0x71ea,0x25a1, 
0x71eb,0x25a1, 0x71ef,0x25a1, 0x71f3,0x25a1, 0x71f5,0x25a1, 0x71f6,0x25a1, 
0x71f7,0x25a1, 0x71fa,0x25a1, 0x7200,0x25a1, 0x7204,0x25a1, 0x7208,0x25a1, 
0x7209,0x25a1, 0x720b,0x25a1, 0x720e,0x25a1, 0x720f,0x25a1, 0x7211,0x25a1, 
0x7212,0x25a1, 0x7215,0x25a1, 0x7216,0x25a1, 0x7217,0x25a1, 0x7218,0x25a1, 
0x721c,0x25a1, 0x7220,0x25a1, 0x7221,0x25a1, 0x7224,0x25a1, 0x7225,0x25a1, 
0x722b,0x25a1, 0x722e,0x25a1, 0x722f,0x25a1, 0x7231,0x611b, 0x7232,0x70ba, 
0x7233,0x25a1, 0x7234,0x25a1, 0x7237,0x723a, 0x723c,0x25a1, 0x7240,0x25a1, 
0x7243,0x25a1, 0x7245,0x25a1, 0x724d,0x7258, 0x724e,0x25a1, 0x7250,0x25a1, 
0x7251,0x25a1, 0x7254,0x25a1, 0x7255,0x25a1, 0x7257,0x25a1, 0x725c,0x725b, 
0x7264,0x25a1, 0x7265,0x25a1, 0x7266,0x729b, 0x7268,0x25a1, 0x726b,0x25a1, 
0x726d,0x25a1, 0x7271,0x25a1, 0x7275,0x727d, 0x727a,0x72a7, 0x7282,0x25a1, 
0x7283,0x25a1, 0x7287,0x25a1, 0x728a,0x72a2, 0x728f,0x309b, 0x7294,0x25a1, 
0x7299,0x25a1, 0x729c,0x25a1, 0x729f,0x5f37, 0x72a0,0x25a1, 0x72ab,0x25a1, 
0x72ad,0x72ac, 0x72b1,0x25a1, 0x72b2,0x25a1, 0x72b3,0x25a1, 0x72b6,0x72c0, 
0x72b7,0x7377, 0x72b8,0x99ac, 0x72b9,0x7336, 0x72bb,0x25a1, 0x72bc,0x25a1, 
0x72be,0x25a1, 0x72c7,0x25a1, 0x72c8,0x72fd, 0x72cd,0x5305, 0x72cf,0x25a1, 
0x72d3,0x25a1, 0x72d5,0x25a1, 0x72db,0x25a1, 0x72dd,0x736e, 0x72de,0x7370, 
0x72e2,0x25a1, 0x72e5,0x25a1, 0x72e7,0x25a1, 0x72ec,0x7368, 0x72ed,0x72f9, 
0x72ee,0x7345, 0x72ef,0x736a, 0x72f0,0x7319, 0x72f1,0x7344, 0x72f2,0x733b, 
0x72f5,0x25a1, 0x7302,0x25a1, 0x7303,0x736b, 0x7304,0x25a1, 0x7305,0x25a1, 
0x7306,0x25a1, 0x7309,0x25a1, 0x730d,0x25a1, 0x730e,0x7375, 0x7310,0x25a1, 
0x7314,0x25a1, 0x7315,0x737c, 0x731a,0x25a1, 0x731f,0x25a1, 0x7320,0x25a1, 
0x7321,0x7380, 0x7324,0x25a1, 0x7328,0x25a1, 0x732a,0x8c6c, 0x732b,0x8c93, 
0x732c,0x875f, 0x732e,0x737b, 0x732f,0x25a1, 0x7338,0x875e, 0x7339,0x67e5, 
0x733d,0x25a1, 0x7341,0x25a1, 0x7346,0x25a1, 0x7347,0x25a1, 0x7348,0x25a1, 
0x734b,0x25a1, 0x734f,0x25a1, 0x7353,0x25a1, 0x7354,0x25a1, 0x7355,0x25a1, 
0x7356,0x25a1, 0x735c,0x25a1, 0x7363,0x25a1, 0x7364,0x25a1, 0x736d,0x737a, 
0x7371,0x25a1, 0x7374,0x25a1, 0x7379,0x25a1, 0x738c,0x25a1, 0x738d,0x25a1, 
0x738f,0x25a1, 0x7390,0x25a1, 0x7391,0x74a3, 0x7398,0x25a1, 0x7399,0x74b5, 
0x739a,0x7452, 0x739b,0x746a, 0x739c,0x25a1, 0x739e,0x25a1, 0x73a3,0x25a1, 
0x73a7,0x25a1, 0x73aa,0x25a1, 0x73ae,0x744b, 0x73af,0x74b0, 0x73b0,0x73fe, 
0x73b1,0x7472, 0x73ba,0x74bd, 0x73bd,0x25a1, 0x73c1,0x25a1, 0x73c4,0x25a1, 
0x73c9,0x6c0f, 0x73ce,0x25a1, 0x73cf,0x73a8, 0x73d0,0x743a, 0x73d1,0x74cf, 
0x73d5,0x25a1, 0x73df,0x25a1, 0x73e1,0x25a1, 0x73e2,0x25a1, 0x73e4,0x25a1, 
0x73e6,0x25a1, 0x73ec,0x25a1, 0x73ef,0x25a1, 0x73f0,0x74ab, 0x73f1,0x74d4, 
0x73f2,0x743f, 0x73f3,0x25a1, 0x73f7,0x25a1, 0x73f9,0x25a1, 0x73fb,0x25a1, 
0x7402,0x25a1, 0x740e,0x74a1, 0x740f,0x7489, 0x7410,0x7463, 0x7411,0x25a1, 
0x7412,0x25a1, 0x7413,0x25a1, 0x7414,0x25a1, 0x7415,0x25a1, 0x7417,0x25a1, 
0x7418,0x25a1, 0x7419,0x25a1, 0x741c,0x25a1, 0x741e,0x25a1, 0x741f,0x25a1, 
0x7427,0x25a1, 0x7437,0x25a1, 0x7438,0x25a1, 0x7439,0x25a1, 0x743b,0x25a1, 
0x743c,0x74ca, 0x743d,0x25a1, 0x743e,0x25a1, 0x7443,0x25a1, 0x7445,0x25a1, 
0x7447,0x25a1, 0x7448,0x25a1, 0x7449,0x25a1, 0x744c,0x25a1, 0x7453,0x25a1, 
0x7456,0x25a1, 0x7458,0x25a1, 0x745d,0x25a1, 0x7460,0x25a1, 0x7461,0x25a1, 
0x7465,0x25a1, 0x7466,0x25a1, 0x7468,0x25a1, 0x746b,0x25a1, 0x746c,0x25a1, 
0x7474,0x25a1, 0x7476,0x7464, 0x7477,0x74a6, 0x7478,0x25a1, 0x747a,0x25a1, 
0x747b,0x25a1, 0x7482,0x25a1, 0x7484,0x25a1, 0x748c,0x25a1, 0x748d,0x25a1, 
0x748e,0x74d4, 0x748f,0x25a1, 0x7491,0x25a1, 0x7493,0x25a1, 0x7496,0x25a1, 
0x7499,0x25a1, 0x749b,0x25a1, 0x749d,0x25a1, 0x74a2,0x25a1, 0x74a4,0x25a1, 
0x74ac,0x25a1, 0x74ae,0x25a1, 0x74b3,0x25a1, 0x74b4,0x25a1, 0x74b9,0x25a1, 
0x74bc,0x25a1, 0x74c4,0x25a1, 0x74c6,0x25a1, 0x74c7,0x25a1, 0x74c8,0x25a1, 
0x74c9,0x25a1, 0x74cc,0x25a1, 0x74cd,0x25a1, 0x74ce,0x25a1, 0x74d0,0x25a1, 
0x74d1,0x25a1, 0x74d2,0x74da, 0x74d3,0x25a1, 0x74e7,0x25a1, 0x74ea,0x25a1, 
0x74eb,0x25a1, 0x74ed,0x25a1, 0x74ee,0x7515, 0x74ef,0x750c, 0x74f0,0x25a1, 
0x74f1,0x25a1, 0x74f2,0x25a1, 0x74f3,0x25a1, 0x74f8,0x25a1, 0x74f9,0x25a1, 
0x74fa,0x25a1, 0x74fc,0x25a1, 0x7501,0x25a1, 0x7505,0x25a1, 0x7506,0x25a1, 
0x7509,0x25a1, 0x750a,0x25a1, 0x750e,0x25a1, 0x7519,0x8cb3, 0x751b,0x25a1, 
0x751e,0x25a1, 0x7520,0x25a1, 0x7523,0x7522, 0x7524,0x25a1, 0x7527,0x8564, 
0x7534,0x25a1, 0x7535,0x96fb, 0x7536,0x25a1, 0x753b,0x756b, 0x753c,0x25a1, 
0x7541,0x25a1, 0x7542,0x25a1, 0x7543,0x25a1, 0x7544,0x25a1, 0x7545,0x66a2, 
0x7546,0x25a1, 0x7549,0x25a1, 0x754a,0x25a1, 0x754d,0x25a1, 0x7550,0x25a1, 
0x7551,0x25a1, 0x7552,0x25a1, 0x7553,0x25a1, 0x7555,0x25a1, 0x7556,0x25a1, 
0x7557,0x25a1, 0x7558,0x25a1, 0x755e,0x25a1, 0x7560,0x25a1, 0x7561,0x25a1, 
0x7567,0x25a1, 0x7568,0x25a1, 0x7569,0x25a1, 0x756d,0x25a1, 0x756e,0x25a1, 
0x7571,0x25a1, 0x7572,0x756c, 0x7573,0x758a, 0x7574,0x7587, 0x7575,0x756b, 
0x757a,0x25a1, 0x757b,0x25a1, 0x757c,0x25a1, 0x7581,0x25a1, 0x7582,0x25a1, 
0x7583,0x757d, 0x7585,0x25a1, 0x7588,0x25a1, 0x7589,0x25a1, 0x758d,0x25a1, 
0x758e,0x758f, 0x7592,0x2f67, 0x7593,0x25a1, 0x7596,0x7664, 0x7597,0x7642, 
0x759b,0x25a1, 0x759c,0x25a1, 0x759e,0x25a1, 0x759f,0x7627, 0x75a0,0x7658, 
0x75a1,0x760d, 0x75a6,0x25a1, 0x75a8,0x25a1, 0x75a9,0x25a1, 0x75ac,0x7646, 
0x75ad,0x25a1, 0x75ae,0x7621, 0x75af,0x760b, 0x75b1,0x76b0, 0x75b4,0x75fe, 
0x75b7,0x25a1, 0x75c3,0x7d43, 0x75c6,0x25a1, 0x75c8,0x7670, 0x75c9,0x75d9, 
0x75d2,0x7662, 0x75d3,0x25a1, 0x75d6,0x555e, 0x75dc,0x25a1, 0x75e5,0x25a1, 
0x75e8,0x7646, 0x75e9,0x7626, 0x75ea,0x7613, 0x75eb,0x7647, 0x75ec,0x760d, 
0x75ee,0x25a1, 0x75f4,0x7661, 0x75f9,0x75fa, 0x7602,0x25a1, 0x7604,0x25a1, 
0x7605,0x7649, 0x7606,0x75b9, 0x7607,0x25a1, 0x760e,0x25a1, 0x7612,0x25a1, 
0x7617,0x761e, 0x7618,0x763a, 0x762a,0x765f, 0x762b,0x7671, 0x762c,0x25a1, 
0x762e,0x25a1, 0x7636,0x25a1, 0x7637,0x25a1, 0x7639,0x25a1, 0x763b,0x25a1, 
0x763e,0x766e, 0x763f,0x766d, 0x7640,0x5ee3, 0x7641,0x25a1, 0x7644,0x25a1, 
0x7645,0x25a1, 0x764a,0x25a1, 0x764b,0x25a1, 0x764d,0x6591, 0x764e,0x7647, 
0x764f,0x25a1, 0x7651,0x25a1, 0x7654,0x610f, 0x7655,0x25a1, 0x765b,0x25a1, 
0x765d,0x25a1, 0x765e,0x7669, 0x7663,0x766c, 0x7666,0x25a1, 0x7667,0x75e2, 
0x7668,0x25a1, 0x766b,0x7672, 0x766f,0x81d2, 0x7673,0x25a1, 0x7674,0x25a1, 
0x7676,0x25a1, 0x7677,0x25a1, 0x767a,0x767c, 0x7680,0x7682, 0x7683,0x25a1, 
0x7685,0x25a1, 0x768c,0x25a1, 0x768d,0x25a1, 0x7690,0x25a1, 0x7691,0x769a, 
0x7694,0x25a1, 0x7697,0x25a1, 0x7698,0x25a1, 0x769f,0x25a1, 0x76a0,0x25a1, 
0x76a1,0x25a1, 0x76a2,0x25a1, 0x76a3,0x25a1, 0x76a5,0x25a1, 0x76a7,0x25a1, 
0x76a8,0x25a1, 0x76a9,0x25a1, 0x76ac,0x25a1, 0x76b1,0x76ba, 0x76b2,0x76b8, 
0x76b3,0x25a1, 0x76b6,0x25a1, 0x76b7,0x25a1, 0x76b9,0x25a1, 0x76bc,0x25a1, 
0x76c0,0x25a1, 0x76c1,0x25a1, 0x76c3,0x554a, 0x76c7,0x25a1, 0x76cb,0x25a1, 
0x76cc,0x25a1, 0x76cf,0x76de, 0x76d0,0x9e7d, 0x76d1,0x76e3, 0x76d5,0x25a1, 
0x76d6,0x84cb, 0x76d7,0x76dc, 0x76d8,0x76e4, 0x76d9,0x25a1, 0x76e0,0x25a1, 
0x76e2,0x25a1, 0x76e8,0x25a1, 0x76eb,0x25a1, 0x76f6,0x25a1, 0x76fd,0x25a1, 
0x76ff,0x25a1, 0x7700,0x25a1, 0x7702,0x25a1, 0x7706,0x25a1, 0x770c,0x7e23, 
0x770d,0x5340, 0x770e,0x25a1, 0x770f,0x25a1, 0x7714,0x25a1, 0x7716,0x25a1, 
0x7717,0x25a1, 0x7718,0x25a1, 0x771c,0x25a1, 0x771e,0x771f, 0x7721,0x25a1, 
0x7724,0x25a1, 0x7726,0x7725, 0x772a,0x25a1, 0x772b,0x25a1, 0x772c,0x77d3, 
0x772e,0x25a1, 0x772f,0x7787, 0x7730,0x25a1, 0x773f,0x25a1, 0x7740,0x8457, 
0x7741,0x775c, 0x7742,0x25a1, 0x7743,0x68ad, 0x7748,0x25a1, 0x7749,0x25a1, 
0x7750,0x775e, 0x7751,0x77bc, 0x7753,0x25a1, 0x7757,0x25a1, 0x7758,0x25a1, 
0x775d,0x25a1, 0x7764,0x25a1, 0x7770,0x25a1, 0x7771,0x25a1, 0x7772,0x25a1, 
0x7773,0x25a1, 0x7774,0x25a1, 0x7775,0x25a1, 0x7776,0x25a1, 0x7777,0x25a1, 
0x7778,0x25a1, 0x777a,0x25a1, 0x777b,0x25a1, 0x7786,0x25a1, 0x778a,0x25a1, 
0x7790,0x25a1, 0x7792,0x779e, 0x7793,0x25a1, 0x7794,0x25a1, 0x7796,0x25a1, 
0x7798,0x25a1, 0x77a4,0x25a1, 0x77a6,0x25a1, 0x77a9,0x77da, 0x77ae,0x25a1, 
0x77af,0x25a1, 0x77b8,0x25a1, 0x77b9,0x25a1, 0x77be,0x25a1, 0x77c0,0x25a1, 
0x77c1,0x25a1, 0x77c3,0x25a1, 0x77c5,0x25a1, 0x77c6,0x25a1, 0x77c8,0x25a1, 
0x77cb,0x25a1, 0x77d1,0x25a1, 0x77d2,0x25a1, 0x77d6,0x25a1, 0x77dd,0x25a1, 
0x77df,0x25a1, 0x77e1,0x25a1, 0x77e4,0x75c5, 0x77e6,0x25a1, 0x77ea,0x25a1, 
0x77eb,0x77ef, 0x77f4,0x25a1, 0x77f5,0x25a1, 0x77f6,0x78ef, 0x77fe,0x792c, 
0x77ff,0x7926, 0x7800,0x78ad, 0x7801,0x78bc, 0x7804,0x25a1, 0x7807,0x25a1, 
0x7808,0x25a1, 0x780a,0x25a1, 0x780b,0x25a1, 0x7815,0x25a1, 0x7816,0x78da, 
0x7817,0x7868, 0x7818,0x5c6f, 0x7819,0x25a1, 0x781a,0x786f, 0x781b,0x25a1, 
0x781c,0x98a8, 0x781e,0x25a1, 0x7824,0x25a1, 0x7836,0x25a1, 0x7839,0x827e, 
0x783a,0x792a, 0x783b,0x7931, 0x783c,0x4edd, 0x783d,0x25a1, 0x783e,0x792b, 
0x783f,0x25a1, 0x7840,0x790e, 0x7841,0x785c, 0x7842,0x25a1, 0x7844,0x25a1, 
0x7846,0x25a1, 0x7847,0x6efe, 0x784b,0x25a1, 0x784f,0x25a1, 0x7851,0x25a1, 
0x7853,0x25a1, 0x7854,0x25a1, 0x7855,0x78a9, 0x7856,0x7864, 0x7857,0x78fd, 
0x7858,0x25a1, 0x7859,0x78d1, 0x785a,0x7904, 0x785b,0x25a1, 0x785f,0x25a1, 
0x7861,0x25a1, 0x7863,0x25a1, 0x7866,0x25a1, 0x7867,0x25a1, 0x786e,0x78ba, 
0x7872,0x25a1, 0x7873,0x25a1, 0x7874,0x25a1, 0x7875,0x25a1, 0x7876,0x25a1, 
0x7877,0x9e7c, 0x7878,0x25a1, 0x787a,0x25a1, 0x787d,0x25a1, 0x7882,0x25a1, 
0x7883,0x5834, 0x7888,0x25a1, 0x788a,0x25a1, 0x788b,0x25a1, 0x788d,0x7919, 
0x7890,0x25a1, 0x7892,0x25a1, 0x789b,0x78e7, 0x789c,0x78e3, 0x789d,0x25a1, 
0x78a6,0x25a1, 0x78ae,0x25a1, 0x78af,0x25a1, 0x78b1,0x9e7c, 0x78b5,0x25a1, 
0x78b6,0x25a1, 0x78b7,0x25a1, 0x78b8,0x25a1, 0x78b9,0x5ba3, 0x78bd,0x25a1, 
0x78bf,0x25a1, 0x78c0,0x25a1, 0x78c2,0x25a1, 0x78c6,0x25a1, 0x78c7,0x25a1, 
0x78d2,0x25a1, 0x78d3,0x25a1, 0x78d6,0x25a1, 0x78d7,0x25a1, 0x78d8,0x25a1, 
0x78d9,0x889e, 0x78dc,0x25a1, 0x78e4,0x25a1, 0x78e6,0x25a1, 0x78eb,0x25a1, 
0x78ee,0x25a1, 0x78f0,0x25a1, 0x78f1,0x25a1, 0x78f5,0x25a1, 0x78f6,0x25a1, 
0x78f8,0x25a1, 0x7900,0x25a1, 0x7903,0x25a1, 0x7906,0x25a1, 0x7907,0x25a1, 
0x7908,0x25a1, 0x790a,0x25a1, 0x790b,0x25a1, 0x790c,0x790e, 0x790d,0x25a1, 
0x790f,0x25a1, 0x7915,0x25a1, 0x7916,0x25a1, 0x7918,0x25a1, 0x791a,0x25a1, 
0x791f,0x25a1, 0x7920,0x25a1, 0x7922,0x25a1, 0x792e,0x25a1, 0x7930,0x25a1, 
0x7932,0x25a1, 0x7933,0x25a1, 0x7934,0x7921, 0x7936,0x25a1, 0x7937,0x25a1, 
0x793b,0x793a, 0x793c,0x79ae, 0x7943,0x25a1, 0x794d,0x25a1, 0x794e,0x7995, 
0x7958,0x25a1, 0x7959,0x25a1, 0x7962,0x79b0, 0x7966,0x25a1, 0x796c,0x25a1, 
0x796e,0x25a1, 0x796f,0x798e, 0x7971,0x25a1, 0x7975,0x25a1, 0x7976,0x25a1, 
0x7977,0x79b1, 0x7978,0x798d, 0x797b,0x25a1, 0x797e,0x25a1, 0x7980,0x7a1f, 
0x7983,0x25a1, 0x7984,0x797f, 0x7985,0x79aa, 0x7986,0x25a1, 0x7987,0x25a1, 
0x7989,0x25a1, 0x798c,0x25a1, 0x7991,0x25a1, 0x7992,0x6020, 0x7999,0x25a1, 
0x799d,0x25a1, 0x799e,0x25a1, 0x799f,0x25a1, 0x79a3,0x25a1, 0x79a5,0x25a1, 
0x79a9,0x25a1, 0x79af,0x25a1, 0x79b5,0x25a1, 0x79bb,0x96e2, 0x79bc,0x25a1, 
0x79c2,0x25a1, 0x79c3,0x79bf, 0x79c4,0x25a1, 0x79c6,0x7a08, 0x79c7,0x25a1, 
0x79ca,0x25a1, 0x79cc,0x25a1, 0x79cd,0x7a2e, 0x79d0,0x25a1, 0x79d3,0x25a1, 
0x79d4,0x25a1, 0x79d7,0x25a1, 0x79d9,0x25a1, 0x79da,0x25a1, 0x79db,0x25a1, 
0x79e1,0x25a1, 0x79e2,0x25a1, 0x79e5,0x25a1, 0x79e8,0x25a1, 0x79ef,0x7a4d, 
0x79f0,0x7a31, 0x79f1,0x25a1, 0x79f2,0x25a1, 0x79f3,0x25a1, 0x79f4,0x25a1, 
0x79f5,0x25a1, 0x79f9,0x25a1, 0x79fc,0x25a1, 0x79fd,0x7a62, 0x79fe,0x7a60, 
0x79ff,0x25a1, 0x7a01,0x25a1, 0x7a06,0x7a6d, 0x7a07,0x25a1, 0x7a09,0x25a1, 
0x7a0e,0x7a05, 0x7a0f,0x25a1, 0x7a16,0x25a1, 0x7a1d,0x25a1, 0x7a21,0x25a1, 
0x7a23,0x7a4c, 0x7a24,0x25a1, 0x7a25,0x25a1, 0x7a27,0x25a1, 0x7a29,0x25a1, 
0x7a2a,0x25a1, 0x7a2c,0x25a1, 0x7a2d,0x25a1, 0x7a32,0x25a1, 0x7a33,0x7a69, 
0x7a34,0x25a1, 0x7a35,0x25a1, 0x7a36,0x25a1, 0x7a38,0x25a1, 0x7a3a,0x25a1, 
0x7a3e,0x25a1, 0x7a41,0x25a1, 0x7a42,0x25a1, 0x7a43,0x25a1, 0x7a45,0x25a1, 
0x7a49,0x25a1, 0x7a4f,0x25a1, 0x7a50,0x25a1, 0x7a51,0x7a61, 0x7a52,0x25a1, 
0x7a53,0x25a1, 0x7a55,0x25a1, 0x7a59,0x25a1, 0x7a5d,0x25a1, 0x7a5e,0x25a1, 
0x7a63,0x25a1, 0x7a64,0x25a1, 0x7a65,0x25a1, 0x7a66,0x25a1, 0x7a6a,0x25a1, 
0x7a6f,0x25a1, 0x7a72,0x25a1, 0x7a73,0x25a1, 0x7a77,0x7aae, 0x7a7c,0x25a1, 
0x7a7d,0x25a1, 0x7a82,0x25a1, 0x7a83,0x7aca, 0x7a8d,0x7ac5, 0x7a8e,0x25a1, 
0x7a91,0x7aaf, 0x7a93,0x25a1, 0x7a9a,0x25a1, 0x7a9b,0x5202, 0x7a9c,0x7ac4, 
0x7a9d,0x7aa9, 0x7aa1,0x25a1, 0x7aa2,0x8cb3, 0x7aa4,0x25a1, 0x7aa5,0x7aba, 
0x7aa6,0x7ac7, 0x7aa7,0x25a1, 0x7aad,0x7ab6, 0x7ab0,0x25a1, 0x7ab9,0x25a1, 
0x7abb,0x25a1, 0x7abc,0x25a1, 0x7abd,0x25a1, 0x7ac2,0x25a1, 0x7ac3,0x25a1, 
0x7ac6,0x25a1, 0x7ac8,0x25a1, 0x7ac9,0x25a1, 0x7acc,0x25a1, 0x7acd,0x25a1, 
0x7ace,0x25a1, 0x7acf,0x25a1, 0x7ad0,0x25a1, 0x7ad2,0x25a1, 0x7ad3,0x25a1, 
0x7ad4,0x25a1, 0x7ad5,0x25a1, 0x7ad6,0x8c4e, 0x7ad7,0x25a1, 0x7ada,0x25a1, 
0x7adb,0x25a1, 0x7adc,0x9f8d, 0x7add,0x25a1, 0x7ade,0x7af6, 0x7ae1,0x25a1, 
0x7ae2,0x25a1, 0x7ae7,0x25a1, 0x7ae8,0x25a1, 0x7ae9,0x25a1, 0x7aea,0x25a1, 
0x7aec,0x25a1, 0x7af0,0x25a1, 0x7af1,0x25a1, 0x7af2,0x25a1, 0x7af3,0x25a1, 
0x7af4,0x25a1, 0x7af5,0x25a1, 0x7af8,0x25a1, 0x7afc,0x25a1, 0x7afe,0x25a1, 
0x7b02,0x25a1, 0x7b03,0x7be4, 0x7b07,0x25a1, 0x7b0b,0x7b4d, 0x7b0c,0x25a1, 
0x7b0d,0x25a1, 0x7b14,0x7b46, 0x7b15,0x7b67, 0x7b16,0x25a1, 0x7b17,0x25a1, 
0x7b1c,0x25a1, 0x7b1f,0x25a1, 0x7b21,0x25a1, 0x7b27,0x25a1, 0x7b29,0x25a1, 
0x7b2d,0x6d6e, 0x7b36,0x25a1, 0x7b37,0x25a1, 0x7b39,0x25a1, 0x7b3a,0x7b8b, 
0x7b3c,0x7c60, 0x7b3d,0x25a1, 0x7b3e,0x7c69, 0x7b3f,0x25a1, 0x7b41,0x25a1, 
0x7b42,0x25a1, 0x7b43,0x25a1, 0x7b51,0x7bc9, 0x7b53,0x25a1, 0x7b55,0x25a1, 
0x7b57,0x25a1, 0x7b59,0x25a1, 0x7b5a,0x7bf3, 0x7b5b,0x7be9, 0x7b5c,0x7c39, 
0x7b5d,0x7b8f, 0x7b5e,0x25a1, 0x7b5f,0x25a1, 0x7b62,0x628a, 0x7b68,0x25a1, 
0x7b6a,0x25a1, 0x7b6b,0x25a1, 0x7b6c,0x25a1, 0x7b6f,0x25a1, 0x7b79,0x7c4c, 
0x7b7a,0x25a1, 0x7b7b,0x66f4, 0x7b7c,0x25a1, 0x7b7d,0x25a1, 0x7b7e,0x7c3d, 
0x7b7f,0x25a1, 0x7b80,0x7c21, 0x7b81,0x25a1, 0x7b83,0x25a1, 0x7b86,0x25a1, 
0x7b89,0x25a1, 0x7b92,0x25a1, 0x7b93,0x7c59, 0x7b9a,0x25a1, 0x7b9e,0x25a1, 
0x7b9f,0x25a1, 0x7ba2,0x5b9b, 0x7ba3,0x25a1, 0x7ba5,0x25a1, 0x7ba6,0x7c00, 
0x7ba7,0x7bcb, 0x7ba8,0x7c5c, 0x7ba9,0x7c6e, 0x7baa,0x7c1e, 0x7bab,0x7c2b, 
0x7bae,0x25a1, 0x7bb0,0x25a1, 0x7bb2,0x25a1, 0x7bb3,0x25a1, 0x7bb6,0x25a1, 
0x7bba,0x25a1, 0x7bbb,0x25a1, 0x7bbc,0x25a1, 0x7bbd,0x25a1, 0x7bbf,0x25a1, 
0x7bc2,0x25a1, 0x7bc3,0x25a1, 0x7bc5,0x25a1, 0x7bc8,0x25a1, 0x7bcd,0x25a1, 
0x7bcf,0x25a1, 0x7bd0,0x25a1, 0x7bd1,0x7c23, 0x7bd2,0x25a1, 0x7bd3,0x7c0d, 
0x7bd6,0x25a1, 0x7bd7,0x25a1, 0x7bec,0x25a1, 0x7bed,0x25a1, 0x7bee,0x7c43, 
0x7bef,0x25a1, 0x7bf1,0x7c6c, 0x7bf5,0x25a1, 0x7bf6,0x25a1, 0x7bfa,0x25a1, 
0x7bfc,0x515c, 0x7c04,0x25a1, 0x7c08,0x25a1, 0x7c12,0x25a1, 0x7c13,0x25a1, 
0x7c14,0x25a1, 0x7c15,0x25a1, 0x7c16,0x7c6a, 0x7c17,0x25a1, 0x7c18,0x25a1, 
0x7c1a,0x25a1, 0x7c1b,0x25a1, 0x7c24,0x25a1, 0x7c2e,0x25a1, 0x7c2f,0x25a1, 
0x7c31,0x25a1, 0x7c32,0x25a1, 0x7c34,0x25a1, 0x7c35,0x25a1, 0x7c36,0x25a1, 
0x7c3a,0x25a1, 0x7c41,0x7c5f, 0x7c42,0x9ab8, 0x7c44,0x25a1, 0x7c46,0x25a1, 
0x7c4b,0x25a1, 0x7c4e,0x25a1, 0x7c4f,0x25a1, 0x7c51,0x25a1, 0x7c52,0x25a1, 
0x7c55,0x25a1, 0x7c56,0x25a1, 0x7c58,0x25a1, 0x7c5d,0x25a1, 0x7c5e,0x25a1, 
0x7c61,0x25a1, 0x7c62,0x25a1, 0x7c68,0x25a1, 0x7c6d,0x25a1, 0x7c70,0x25a1, 
0x7c71,0x25a1, 0x7c74,0x7cf4, 0x7c76,0x25a1, 0x7c77,0x25a1, 0x7c7b,0x985e, 
0x7c7c,0x79c8, 0x7c7e,0x25a1, 0x7c82,0x25a1, 0x7c83,0x25a1, 0x7c86,0x25a1, 
0x7c87,0x25a1, 0x7c8b,0x25a1, 0x7c8e,0x25a1, 0x7c8f,0x25a1, 0x7c90,0x25a1, 
0x7c93,0x25a1, 0x7c99,0x91c9, 0x7c9a,0x25a1, 0x7c9b,0x25a1, 0x7c9c,0x7cf6, 
0x7c9d,0x7cf2, 0x7ca0,0x25a1, 0x7ca4,0x7cb5, 0x7ca6,0x25a1, 0x7ca9,0x25a1, 
0x7caa,0x7cde, 0x7cab,0x25a1, 0x7cac,0x25a1, 0x7cad,0x25a1, 0x7cae,0x7ce7, 
0x7cb0,0x25a1, 0x7cb6,0x25a1, 0x7cb7,0x25a1, 0x7cb8,0x25a1, 0x7cbb,0x5f27, 
0x7cc0,0x25a1, 0x7cc1,0x7cdd, 0x7cc2,0x25a1, 0x7cc3,0x25a1, 0x7cc4,0x25a1, 
0x7cc6,0x25a1, 0x7cc7,0x9931, 0x7cc9,0x25a1, 0x7ccd,0x9908, 0x7ccf,0x25a1, 
0x7cd3,0x25a1, 0x7cd8,0x25a1, 0x7cda,0x25a1, 0x7cdb,0x25a1, 0x7ce1,0x25a1, 
0x7ce3,0x25a1, 0x7ce4,0x25a1, 0x7ce5,0x25a1, 0x7ce6,0x25a1, 0x7ce9,0x25a1, 
0x7ceb,0x25a1, 0x7ced,0x25a1, 0x7cf3,0x25a1, 0x7cf5,0x25a1, 0x7cf9,0x7cf8, 
0x7cfa,0x25a1, 0x7cfc,0x25a1, 0x7cff,0x25a1, 0x7d23,0x25a1, 0x7d24,0x25a1, 
0x7d25,0x25a1, 0x7d26,0x25a1, 0x7d27,0x7dca, 0x7d2a,0x25a1, 0x7d2d,0x25a1, 
0x7d34,0x25a1, 0x7d36,0x808c, 0x7d37,0x25a1, 0x7d48,0x25a1, 0x7d49,0x25a1, 
0x7d4b,0x25a1, 0x7d4c,0x25a1, 0x7d4d,0x25a1, 0x7d57,0x25a1, 0x7d59,0x25a1, 
0x7d5a,0x25a1, 0x7d5d,0x25a1, 0x7d60,0x25a1, 0x7d64,0x25a1, 0x7d65,0x25a1, 
0x7d6c,0x25a1, 0x7d74,0x25a1, 0x7d75,0x7e6a, 0x7d76,0x7d55, 0x7d77,0x7e36, 
0x7d78,0x25a1, 0x7d7e,0x25a1, 0x7d82,0x25a1, 0x7d87,0x25a1, 0x7d89,0x25a1, 
0x7d8a,0x25a1, 0x7d8b,0x25a1, 0x7d90,0x25a1, 0x7d95,0x25a1, 0x7d97,0x25a1, 
0x7d98,0x5065, 0x7d99,0x7e7c, 0x7d9a,0x7e8c, 0x7d9b,0x25a1, 0x7da4,0x25a1, 
0x7da5,0x25a1, 0x7da8,0x25a1, 0x7dab,0x25a1, 0x7db3,0x25a1, 0x7db6,0x25a1, 
0x7dc3,0x25a1, 0x7dc8,0x25a1, 0x7dcd,0x25a1, 0x7dcf,0x25a1, 0x7dd0,0x25a1, 
0x7dd1,0x25a1, 0x7dd3,0x25a1, 0x7dd4,0x25a1, 0x7dd5,0x25a1, 0x7dd6,0x25a1, 
0x7ddc,0x7dbf, 0x7de2,0x25a1, 0x7de4,0x25a1, 0x7de5,0x25a1, 0x7deb,0x25a1, 
0x7ded,0x25a1, 0x7df5,0x25a1, 0x7df8,0x25a1, 0x7dfa,0x76e1, 0x7dfc,0x25a1, 
0x7dfd,0x25a1, 0x7dfe,0x25a1, 0x7dff,0x25a1, 0x7e00,0x25a1, 0x7e01,0x25a1, 
0x7e02,0x7e3d, 0x7e04,0x7e69, 0x7e05,0x25a1, 0x7e06,0x25a1, 0x7e07,0x25a1, 
0x7e18,0x25a1, 0x7e19,0x25a1, 0x7e26,0x25a1, 0x7e27,0x25a1, 0x7e28,0x25a1, 
0x7e2c,0x25a1, 0x7e4a,0x25a1, 0x7e4b,0x7e6b, 0x7e4d,0x7e61, 0x7e4e,0x25a1, 
0x7e4f,0x25a1, 0x7e5b,0x25a1, 0x7e5d,0x4fca, 0x7e64,0x25a1, 0x7e65,0x25a1, 
0x7e66,0x25a1, 0x7e67,0x25a1, 0x7e6c,0x25a1, 0x7e6e,0x25a1, 0x7e71,0x25a1, 
0x7e7f,0x25a1, 0x7e83,0x25a1, 0x7e84,0x25a1, 0x7e85,0x25a1, 0x7e89,0x25a1, 
0x7e8e,0x25a1, 0x7e90,0x25a1, 0x7e92,0x25a1, 0x7e9d,0x25a1, 0x7e9e,0x25a1, 
0x7e9f,0x7cf8, 0x7ea0,0x7cfe, 0x7ea1,0x7d06, 0x7ea2,0x7d05, 0x7ea3,0x7d02, 
0x7ea4,0x7e96, 0x7ea5,0x7d07, 0x7ea6,0x7d04, 0x7ea7,0x7d1a, 0x7ea8,0x7d08, 
0x7ea9,0x7e8a, 0x7eaa,0x7d00, 0x7eab,0x7d09, 0x7eac,0x7def, 0x7ead,0x7d1c, 
0x7eae,0x7d18, 0x7eaf,0x7d14, 0x7eb0,0x7d15, 0x7eb1,0x7d17, 0x7eb2,0x7db1, 
0x7eb3,0x7d0d, 0x7eb4,0x7d1d, 0x7eb5,0x7e31, 0x7eb6,0x7db8, 0x7eb7,0x7d1b, 
0x7eb8,0x7d19, 0x7eb9,0x7d0b, 0x7eba,0x7d21, 0x7ebb,0x7d35, 0x7ebc,0x7d16, 
0x7ebd,0x7d10, 0x7ebe,0x7d13, 0x7ebf,0x7dda, 0x7ec0,0x7d3a, 0x7ec1,0x7d32, 
0x7ec2,0x7d31, 0x7ec3,0x7df4, 0x7ec4,0x7d44, 0x7ec5,0x7d33, 0x7ec6,0x7d30, 
0x7ec7,0x7e54, 0x7ec8,0x7d42, 0x7ec9,0x7e10, 0x7eca,0x7d46, 0x7ecb,0x7d3c, 
0x7ecc,0x7d40, 0x7ecd,0x7d39, 0x7ece,0x7e79, 0x7ecf,0x7d93, 0x7ed0,0x7d3f, 
0x7ed1,0x7d81, 0x7ed2,0x7d68, 0x7ed3,0x7d50, 0x7ed4,0x8932, 0x7ed5,0x7e5e, 
0x7ed6,0x7d70, 0x7ed7,0x7d4e, 0x7ed8,0x7e6a, 0x7ed9,0x7d66, 0x7eda,0x7d62, 
0x7edb,0x7d73, 0x7edc,0x7d61, 0x7edd,0x7d55, 0x7ede,0x7d5e, 0x7edf,0x7d71, 
0x7ee0,0x7d86, 0x7ee1,0x7d83, 0x7ee2,0x7d79, 0x7ee3,0x7e61, 0x7ee4,0x7d8c, 
0x7ee5,0x7d8f, 0x7ee6,0x7d5b, 0x7ee7,0x7e7c, 0x7ee8,0x7d88, 0x7ee9,0x7e3e, 
0x7eea,0x7dd2, 0x7eeb,0x7dbe, 0x7eec,0x25a1, 0x7eed,0x7e8c, 0x7eee,0x7dba, 
0x7eef,0x7dcb, 0x7ef0,0x7dbd, 0x7ef1,0x979c, 0x7ef2,0x7dc4, 0x7ef3,0x7e69, 
0x7ef4,0x7dad, 0x7ef5,0x7dbf, 0x7ef6,0x7dac, 0x7ef7,0x7e43, 0x7ef8,0x7da2, 
0x7ef9,0x7daf, 0x7efa,0x7db9, 0x7efb,0x7da3, 0x7efc,0x7d9c, 0x7efd,0x7dbb, 
0x7efe,0x7db0, 0x7eff,0x7da0, 0x7f00,0x7db4, 0x7f01,0x7dc7, 0x7f02,0x7dd9, 
0x7f03,0x7dd7, 0x7f04,0x7dd8, 0x7f05,0x7dec, 0x7f06,0x7e9c, 0x7f07,0x7df9, 
0x7f08,0x7df2, 0x7f09,0x7ddd, 0x7f0a,0x7e15, 0x7f0b,0x7e62, 0x7f0c,0x7de6, 
0x7f0d,0x7d9e, 0x7f0e,0x7dde, 0x7f0f,0x7df6, 0x7f10,0x7dda, 0x7f11,0x7df1, 
0x7f12,0x7e0b, 0x7f13,0x7de9, 0x7f14,0x7de0, 0x7f15,0x7e37, 0x7f16,0x7de8, 
0x7f17,0x7de1, 0x7f18,0x7de3, 0x7f19,0x7e09, 0x7f1a,0x7e1b, 0x7f1b,0x7e1f, 
0x7f1c,0x7e1d, 0x7f1d,0x7e2b, 0x7f1e,0x7e17, 0x7f1f,0x7e1e, 0x7f20,0x7e8f, 
0x7f21,0x7e2d, 0x7f22,0x7e0a, 0x7f23,0x7e11, 0x7f24,0x7e7d, 0x7f25,0x7e39, 
0x7f26,0x7e35, 0x7f27,0x7e32, 0x7f28,0x7e93, 0x7f29,0x7e2e, 0x7f2a,0x7e46, 
0x7f2b,0x7e45, 0x7f2c,0x7e88, 0x7f2d,0x7e5a, 0x7f2e,0x7e55, 0x7f2f,0x7e52, 
0x7f30,0x97c1, 0x7f31,0x7e7e, 0x7f32,0x7e70, 0x7f33,0x7e6f, 0x7f34,0x7e73, 
0x7f35,0x7e98, 0x7f37,0x25a1, 0x7f3b,0x25a1, 0x7f3c,0x25a1, 0x7f40,0x25a1, 
0x7f41,0x25a1, 0x7f42,0x7f4c, 0x7f46,0x25a1, 0x7f47,0x25a1, 0x7f49,0x25a1, 
0x7f4e,0x25a1, 0x7f51,0x7db2, 0x7f52,0x25a1, 0x7f53,0x994b, 0x7f56,0x25a1, 
0x7f57,0x7f85, 0x7f59,0x25a1, 0x7f5a,0x7f70, 0x7f62,0x7f77, 0x7f64,0x25a1, 
0x7f6f,0x25a1, 0x7f71,0x5357, 0x7f74,0x7f86, 0x7f78,0x25a1, 0x7f80,0x25a1, 
0x7f81,0x7f88, 0x7f82,0x25a1, 0x7f84,0x25a1, 0x7f8f,0x25a1, 0x7f90,0x25a1, 
0x7f93,0x25a1, 0x7f97,0x7f8c, 0x7f98,0x25a1, 0x7f99,0x7f94, 0x7f9f,0x7fa5, 
0x7fa1,0x7fa8, 0x7fa3,0x7fa4, 0x7faa,0x25a1, 0x7fab,0x25a1, 0x7fae,0x7fb9, 
0x7fb4,0x25a1, 0x7fc4,0x25a1, 0x7fc6,0x25a1, 0x7fc8,0x25a1, 0x7fd3,0x25a1, 
0x7fd6,0x25a1, 0x7fd8,0x7ff9, 0x7fd9,0x7ffd, 0x7fda,0x7fec, 0x7fdd,0x25a1, 
0x7fe3,0x75e2, 0x7fe4,0x25a1, 0x7fe7,0x25a1, 0x7ff6,0x25a1, 0x7ffa,0x25a1, 
0x8002,0x25a1, 0x8008,0x25a1, 0x8009,0x25a1, 0x800a,0x25a1, 0x8013,0x25a1, 
0x801a,0x25a1, 0x801d,0x25a1, 0x8020,0xf7ed, 0x8022,0x52de, 0x8023,0x25a1, 
0x8025,0x5c1a, 0x8027,0x802c, 0x802b,0x25a1, 0x802d,0x25a1, 0x802e,0x25a1, 
0x802f,0x25a1, 0x8031,0x78e8, 0x8032,0x25a1, 0x8038,0x8073, 0x803a,0x25a1, 
0x803b,0x6065, 0x803c,0x25a1, 0x8040,0x25a1, 0x8041,0x25a1, 0x8042,0x8076, 
0x8044,0x25a1, 0x8045,0x25a1, 0x8049,0x25a1, 0x804b,0x807e, 0x804c,0x8077, 
0x804d,0x8079, 0x804e,0x25a1, 0x8053,0x25a1, 0x8054,0x806f, 0x8055,0x25a1, 
0x8057,0x25a1, 0x8059,0x25a1, 0x805b,0x25a1, 0x805f,0x25a1, 0x8060,0x25a1, 
0x8061,0x25a1, 0x8062,0x25a1, 0x8063,0x25a1, 0x8065,0x25a1, 0x8066,0x25a1, 
0x8068,0x25a1, 0x8069,0x8075, 0x806a,0x8070, 0x806b,0x25a1, 0x806d,0x25a1, 
0x806e,0x25a1, 0x8074,0x25a1, 0x807a,0x25a1, 0x807b,0x25a1, 0x807c,0x25a1, 
0x807d,0x9686, 0x8080,0x807f, 0x8081,0x25a1, 0x8083,0x8085, 0x8088,0x25a1, 
0x808d,0x25a1, 0x808e,0x25a1, 0x8091,0x25a1, 0x8094,0x25a1, 0x8097,0x25a1, 
0x809e,0x25a1, 0x809f,0x9ad2, 0x80a0,0x8178, 0x80a4,0x819a, 0x80a6,0x25a1, 
0x80a7,0x25a1, 0x80a8,0x25a1, 0x80ac,0x25a1, 0x80ae,0x9aaf, 0x80b0,0x25a1, 
0x80b3,0x25a1, 0x80b6,0x25a1, 0x80b7,0x6b20, 0x80b9,0x25a1, 0x80bb,0x25a1, 
0x80bc,0x4e95, 0x80bd,0x592a, 0x80be,0x814e, 0x80bf,0x816b, 0x80c0,0x8139, 
0x80c1,0x8105, 0x80c6,0x81bd, 0x80cb,0x25a1, 0x80d2,0x25a1, 0x80d3,0x25a1, 
0x80dc,0x52dd, 0x80df,0x25a1, 0x80e2,0x25a1, 0x80e7,0x6727, 0x80e8,0x6771, 
0x80e9,0x5361, 0x80ea,0x81da, 0x80eb,0x811b, 0x80ec,0x8089, 0x80ee,0x25a1, 
0x80f6,0x81a0, 0x80f7,0x25a1, 0x80ff,0x25a1, 0x8103,0x25a1, 0x8104,0x25a1, 
0x8107,0x25a1, 0x8109,0x8108, 0x810b,0x25a1, 0x810c,0x25a1, 0x810d,0x81be, 
0x810e,0x6bba, 0x810f,0x9ad2, 0x8110,0x81cd, 0x8111,0x8166, 0x8112,0x7c73, 
0x8113,0x81bf, 0x8114,0x81e0, 0x8117,0x25a1, 0x811a,0x8173, 0x811c,0x25a1, 
0x8120,0x25a1, 0x8126,0x25a1, 0x8128,0x25a1, 0x812a,0x25a1, 0x812e,0x25a1, 
0x8131,0x812b, 0x8132,0x53cd, 0x8133,0x25a1, 0x8134,0x25a1, 0x8135,0x25a1, 
0x8136,0x8161, 0x8137,0x25a1, 0x8138,0x81c9, 0x813b,0x25a1, 0x813c,0x25a1, 
0x813f,0x8b3e, 0x8140,0x25a1, 0x8141,0x25a1, 0x8142,0x25a1, 0x8145,0x25a1, 
0x8148,0x9752, 0x8149,0x25a1, 0x814a,0x81d8, 0x814c,0x9183, 0x8156,0x25a1, 
0x8157,0x25a1, 0x8158,0x8195, 0x8159,0x5b97, 0x815a,0x5b9a, 0x815d,0x25a1, 
0x815f,0x25a1, 0x8163,0x25a1, 0x8168,0x25a1, 0x816a,0x25a1, 0x816c,0x25a1, 
0x816d,0x9f76, 0x8175,0x25a1, 0x817b,0x81a9, 0x817c,0x9766, 0x817d,0x8183, 
0x817e,0x9a30, 0x8181,0x25a1, 0x8184,0x25a1, 0x8185,0x25a1, 0x818e,0x25a1, 
0x8190,0x25a1, 0x8191,0x81cf, 0x8192,0x25a1, 0x8193,0x25a1, 0x8194,0x25a1, 
0x8196,0x25a1, 0x81a1,0x25a1, 0x81a4,0x25a1, 0x81a5,0x25a1, 0x81aa,0x557b, 
0x81ad,0x25a1, 0x81af,0x25a1, 0x81b6,0x25a1, 0x81b8,0x25a1, 0x81c1,0x5ec9, 
0x81c8,0x25a1, 0x81cb,0x25a1, 0x81ce,0x25a1, 0x81d3,0x6479, 0x81d4,0x25a1, 
0x81d6,0x25a1, 0x81dc,0x81e2, 0x81e4,0x25a1, 0x81eb,0x25a1, 0x81ef,0x25a1, 
0x81f0,0x25a1, 0x81f1,0x25a1, 0x81f5,0x25a1, 0x81f6,0x25a1, 0x81fd,0x25a1, 
0x8203,0x25a1, 0x8206,0x8f3f, 0x820e,0x25a1, 0x820f,0x25a1, 0x8213,0x25a1, 
0x8217,0x25a1, 0x8218,0x25a1, 0x8219,0x25a1, 0x821a,0x25a1, 0x8223,0x8264, 
0x8224,0x5e06, 0x8226,0x25a1, 0x8227,0x25a1, 0x8229,0x25a1, 0x822d,0x6bd4, 
0x822e,0x25a1, 0x8230,0x8266, 0x8231,0x8259, 0x823b,0x826b, 0x823e,0x897f, 
0x8241,0x25a1, 0x8243,0x25a1, 0x8246,0x25a1, 0x8248,0x25a1, 0x824a,0x25a1, 
0x824c,0x25a1, 0x824d,0x25a1, 0x8254,0x25a1, 0x825d,0x25a1, 0x8260,0x25a1, 
0x8262,0x25a1, 0x8265,0x25a1, 0x8267,0x25a1, 0x8269,0x64f0, 0x826a,0x25a1, 
0x8270,0x8271, 0x8273,0x8277, 0x8276,0x25a1, 0x8279,0x8278, 0x827a,0x85dd, 
0x827b,0x25a1, 0x8281,0x25a1, 0x8282,0x7bc0, 0x8286,0x25a1, 0x8287,0x25a1, 
0x8288,0x7f8b, 0x8289,0x25a1, 0x828c,0x25a1, 0x8295,0x25a1, 0x8296,0x25a1, 
0x8297,0x858c, 0x829c,0x856a, 0x82a6,0x8606, 0x82aa,0x6c0f, 0x82b2,0x25a1, 
0x82b8,0x8553, 0x82bf,0x25a1, 0x82c1,0x84ef, 0x82c4,0x8290, 0x82c5,0x25a1, 
0x82c6,0x25a1, 0x82c7,0x8466, 0x82c8,0x85f6, 0x82c9,0x25a1, 0x82ca,0x5384, 
0x82cb,0x83a7, 0x82cc,0x8407, 0x82cd,0x84bc, 0x82ce,0x82e7, 0x82cf,0x8607, 
0x82d0,0x25a1, 0x82d8,0x8435, 0x82da,0x25a1, 0x82dd,0x25a1, 0x82e2,0x25a1, 
0x82e9,0x25a1, 0x82ee,0x25a1, 0x82f7,0x7518, 0x82f8,0x25a1, 0x82f9,0x860b, 
0x82fc,0x25a1, 0x82fd,0x25a1, 0x82ff,0x25a1, 0x8303,0x7bc4, 0x830a,0x25a1, 
0x830b,0x25a1, 0x830e,0x8396, 0x830f,0x8622, 0x8310,0x25a1, 0x8311,0x8526, 
0x8312,0x25a1, 0x8313,0x25a1, 0x8314,0x584b, 0x8315,0x7162, 0x8318,0x25a1, 
0x831a,0x8306, 0x831d,0x25a1, 0x831f,0x25a1, 0x8321,0x25a1, 0x8323,0x25a1, 
0x8327,0x7e6d, 0x832e,0x25a1, 0x8330,0x25a1, 0x833d,0x5564, 0x833e,0x25a1, 
0x8346,0x834a, 0x8350,0x85a6, 0x8355,0x25a1, 0x8357,0x25a1, 0x8358,0x25a1, 
0x8359,0x8598, 0x835a,0x83a2, 0x835b,0x8558, 0x835c,0x84fd, 0x835d,0x25a1, 
0x835e,0x854e, 0x835f,0x8588, 0x8360,0x85ba, 0x8361,0x8569, 0x8362,0x25a1, 
0x8363,0x69ae, 0x8364,0x8477, 0x8365,0x6ece, 0x8366,0x7296, 0x8367,0x7192, 
0x8368,0x8541, 0x8369,0x85ce, 0x836a,0x84c0, 0x836b,0x852d, 0x836c,0x8ce3, 
0x836d,0x8452, 0x836e,0x7d02, 0x836f,0x85e5, 0x8370,0x25a1, 0x8371,0x25a1, 
0x8372,0x25a1, 0x8379,0x25a1, 0x8380,0x25a1, 0x8382,0x25a1, 0x8384,0x25a1, 
0x8385,0x849e, 0x8391,0x25a1, 0x839c,0x84e8, 0x839f,0x25a1, 0x83a1,0x25a1, 
0x83ac,0x25a1, 0x83ad,0x25a1, 0x83b1,0x840a, 0x83b2,0x84ee, 0x83b3,0x8494, 
0x83b4,0x8435, 0x83b5,0x25a1, 0x83b6,0x859f, 0x83b7,0x7372, 0x83b8,0x8555, 
0x83b9,0x7469, 0x83ba,0x9daf, 0x83bb,0x25a1, 0x83bc,0x84f4, 0x83be,0x25a1, 
0x83cd,0x25a1, 0x83d0,0x25a1, 0x83d2,0x25a1, 0x83d3,0x25a1, 0x83da,0x25a1, 
0x83e6,0x25a1, 0x83ed,0x6070, 0x83f7,0x25a1, 0x8400,0x25a1, 0x8402,0x25a1, 
0x8405,0x25a1, 0x8408,0x25a1, 0x8414,0x25a1, 0x8415,0x25a1, 0x8416,0x25a1, 
0x8417,0x25a1, 0x8418,0x5948, 0x8419,0x25a1, 0x841a,0x8600, 0x841c,0x5e16, 
0x841d,0x863f, 0x841e,0x25a1, 0x841f,0x25a1, 0x8420,0x25a1, 0x8421,0x25a1, 
0x8422,0x25a1, 0x8424,0x87a2, 0x8425,0x71df, 0x8426,0x7e08, 0x8427,0x856d, 
0x8428,0x85a9, 0x842a,0x25a1, 0x842e,0x25a1, 0x843e,0x25a1, 0x8441,0x25a1, 
0x8448,0x25a1, 0x844a,0x25a1, 0x844f,0x25a1, 0x8453,0x25a1, 0x8455,0x25a1, 
0x8458,0x25a1, 0x845c,0x5951, 0x8462,0x25a1, 0x8464,0x25a1, 0x846a,0x25a1, 
0x8471,0x8525, 0x8472,0x25a1, 0x847b,0x25a1, 0x847c,0x53d6, 0x847f,0x25a1, 
0x8480,0x25a1, 0x8481,0x25a1, 0x8483,0x25a1, 0x8484,0x25a1, 0x8485,0x25a1, 
0x8487,0x8546, 0x8488,0x7686, 0x8489,0x8562, 0x848a,0x25a1, 0x848b,0x8523, 
0x848c,0x851e, 0x8492,0x25a1, 0x8493,0x25a1, 0x8495,0x25a1, 0x8496,0x25a1, 
0x84a3,0x25a1, 0x84a5,0x25a1, 0x84a6,0x25a1, 0x84ad,0x25a1, 0x84b3,0x25a1, 
0x84b5,0x25a1, 0x84b7,0x25a1, 0x84bd,0x6069, 0x84be,0x25a1, 0x84c3,0x25a1, 
0x84c8,0x25a1, 0x84d5,0x25a1, 0x84d8,0x25a1, 0x84d9,0x25a1, 0x84da,0x25a1, 
0x84dc,0x25a1, 0x84dd,0x85cd, 0x84de,0x25a1, 0x84df,0x858a, 0x84e0,0x863a, 
0x84e1,0x25a1, 0x84e2,0x25a1, 0x84e3,0x8577, 0x84e4,0x25a1, 0x84e5,0x93a3, 
0x84e6,0x9a40, 0x84ed,0x25a1, 0x84f5,0x25a1, 0x84f8,0x25a1, 0x8501,0x25a1, 
0x8502,0x5098, 0x8503,0x25a1, 0x8504,0x25a1, 0x8505,0x25a1, 0x8510,0x25a1, 
0x851b,0x25a1, 0x8522,0x25a1, 0x8532,0x25a1, 0x8533,0x25a1, 0x8534,0x25a1, 
0x8535,0x25a1, 0x8536,0x25a1, 0x8537,0x8594, 0x8538,0x515c, 0x8539,0x861e, 
0x853a,0x85fa, 0x853c,0x85f9, 0x853f,0x25a1, 0x8542,0x25a1, 0x854b,0x25a1, 
0x854c,0x25a1, 0x854f,0x25a1, 0x8550,0x25a1, 0x8552,0x25a1, 0x855a,0x25a1, 
0x855c,0x25a1, 0x855f,0x25a1, 0x856f,0x25a1, 0x8570,0x25a1, 0x8572,0x8604, 
0x8573,0x25a1, 0x8574,0x860a, 0x857d,0x25a1, 0x857f,0x25a1, 0x8581,0x7701, 
0x8592,0x25a1, 0x8593,0x25a1, 0x8597,0x25a1, 0x85a5,0x25a1, 0x85ab,0x25a1, 
0x85ac,0x25a1, 0x85ad,0x25a1, 0x85ae,0x85ea, 0x85b2,0x25a1, 0x85bb,0x25a1, 
0x85bc,0x25a1, 0x85c1,0x69c1, 0x85ca,0x25a1, 0x85cc,0x25a1, 0x85d3,0x861a, 
0x85d4,0x25a1, 0x85d6,0x25a1, 0x85db,0x25a1, 0x85e0,0x25a1, 0x85e7,0x25a1, 
0x85ee,0x25a1, 0x85f3,0x25a1, 0x85f4,0x25a1, 0x85f5,0x25a1, 0x85f8,0x6055, 
0x85fc,0x25a1, 0x8602,0x25a1, 0x8603,0x25a1, 0x8608,0x25a1, 0x860d,0x25a1, 
0x860e,0x25a1, 0x860f,0x25a1, 0x8610,0x25a1, 0x8612,0x25a1, 0x8613,0x25a1, 
0x8614,0x25a1, 0x8615,0x25a1, 0x8616,0x8617, 0x861d,0x25a1, 0x8628,0x25a1, 
0x862b,0x25a1, 0x862f,0x25a1, 0x8630,0x25a1, 0x8637,0x25a1, 0x863d,0x25a1, 
0x8641,0x25a1, 0x8642,0x25a1, 0x8644,0x25a1, 0x8645,0x25a1, 0x8649,0x25a1, 
0x864a,0x25a1, 0x864f,0x865c, 0x8651,0x616e, 0x8657,0x25a1, 0x8658,0x25a1, 
0x865a,0x865b, 0x865d,0x25a1, 0x8660,0x25a1, 0x8666,0x25a1, 0x866a,0x737a, 
0x866b,0x87f2, 0x866c,0x866f, 0x866e,0x87e3, 0x8672,0x25a1, 0x8675,0x25a1, 
0x8676,0x25a1, 0x8678,0x25a1, 0x867d,0x96d6, 0x867e,0x8766, 0x867f,0x8806, 
0x8680,0x8755, 0x8681,0x87fb, 0x8682,0x879e, 0x8683,0x25a1, 0x8684,0x25a1, 
0x8688,0x25a1, 0x8689,0x25a1, 0x868f,0x25a1, 0x8692,0x25a1, 0x8695,0x8836, 
0x869b,0x25a1, 0x869f,0x25a1, 0x86a0,0x25a1, 0x86a6,0x25a1, 0x86ab,0x25a1, 
0x86ac,0x8706, 0x86ad,0x25a1, 0x86ae,0x25a1, 0x86b2,0x25a1, 0x86ca,0x8831, 
0x86cd,0x25a1, 0x86ce,0x8823, 0x86cf,0x87f6, 0x86d2,0x25a1, 0x86d5,0x25a1, 
0x86e0,0x25a1, 0x86e1,0x25a1, 0x86e5,0x25a1, 0x86e7,0x25a1, 0x86ee,0x883b, 
0x86ef,0x25a1, 0x86f0,0x87c4, 0x86f1,0x86fa, 0x86f2,0x87ef, 0x86f3,0x8784, 
0x86f4,0x8810, 0x86fc,0x25a1, 0x86fd,0x25a1, 0x86ff,0x25a1, 0x870f,0x25a1, 
0x8710,0x25a1, 0x8714,0x25a1, 0x8715,0x86fb, 0x8716,0x6c40, 0x8717,0x8778, 
0x871d,0x25a1, 0x871f,0x25a1, 0x8721,0x881f, 0x872b,0x25a1, 0x872f,0x25a1, 
0x8736,0x25a1, 0x8739,0x25a1, 0x873d,0x25a1, 0x8744,0x25a1, 0x8745,0x25a1, 
0x8747,0x8805, 0x8748,0x87c8, 0x8749,0x87ec, 0x874a,0x25a1, 0x874b,0x25a1, 
0x874e,0x880d, 0x8770,0x594e, 0x8771,0x25a1, 0x8772,0x25a1, 0x877c,0x87bb, 
0x877d,0x6625, 0x877e,0x8811, 0x877f,0x8805, 0x8780,0x87bf, 0x8786,0x25a1, 
0x878a,0x25a1, 0x878b,0x53df, 0x878c,0x25a1, 0x878e,0x25a1, 0x8795,0x25a1, 
0x8799,0x25a1, 0x87a0,0x25a1, 0x87a1,0x25a1, 0x87a4,0x5dcd, 0x87a5,0x25a1, 
0x87a6,0x25a1, 0x87a7,0x25a1, 0x87a8,0x9862, 0x87a9,0x25a1, 0x87b1,0x25a1, 
0x87c1,0x25a1, 0x87c7,0x25a1, 0x87cd,0x25a1, 0x87ce,0x25a1, 0x87cf,0x8828, 
0x87d0,0x25a1, 0x87d5,0x25a1, 0x87d6,0x25a1, 0x87da,0x25a1, 0x87e9,0x25a1, 
0x87ee,0x87fa, 0x87f0,0x25a1, 0x87f1,0x25a1, 0x87f5,0x25a1, 0x87f8,0x25a1, 
0x87fd,0x25a1, 0x8804,0x25a1, 0x8807,0x25a1, 0x880e,0x87d2, 0x880f,0x25a1, 
0x8812,0x25a1, 0x8818,0x25a1, 0x881a,0x25a1, 0x881e,0x25a1, 0x8827,0x25a1, 
0x882d,0x25a1, 0x8834,0x25a1, 0x883a,0x25a1, 0x8842,0x25a1, 0x8845,0x91c1, 
0x8846,0x25a1, 0x8847,0x25a1, 0x8849,0x25a1, 0x884f,0x25a1, 0x8850,0x25a1, 
0x8851,0x25a1, 0x8854,0x929c, 0x8858,0x25a1, 0x885c,0x25a1, 0x885e,0x25a1, 
0x885f,0x25a1, 0x8860,0x25a1, 0x8864,0x8863, 0x8865,0x88dc, 0x8866,0x25a1, 
0x886c,0x896f, 0x886e,0x889e, 0x8873,0x25a1, 0x8878,0x25a1, 0x887a,0x25a1, 
0x887b,0x25a1, 0x8884,0x8956, 0x8885,0x88ca, 0x8886,0x8918, 0x8887,0x25a1, 
0x888a,0x25a1, 0x888f,0x25a1, 0x8890,0x25a1, 0x8894,0x25a1, 0x889c,0x896a, 
0x889d,0x25a1, 0x88a0,0x25a1, 0x88a3,0x25a1, 0x88a5,0x25a1, 0x88a6,0x25a1, 
0x88a9,0x25a1, 0x88aa,0x5c0f, 0x88ad,0x8972, 0x88ae,0x25a1, 0x88af,0x894f, 
0x88b0,0x25a1, 0x88b3,0x25a1, 0x88b4,0x8932, 0x88b5,0x25a1, 0x88bb,0x25a1, 
0x88bf,0x25a1, 0x88c3,0x25a1, 0x88c4,0x25a1, 0x88c5,0x88dd, 0x88c6,0x8960, 
0x88c7,0x25a1, 0x88c8,0x890c, 0x88d1,0x25a1, 0x88d3,0x25a1, 0x88e0,0x25a1, 
0x88e2,0x8933, 0x88e3,0x895d, 0x88e4,0x8932, 0x88e5,0x8949, 0x88e6,0x25a1, 
0x88e9,0x25a1, 0x88ea,0x25a1, 0x88ed,0x25a1, 0x88f5,0x25a1, 0x88ff,0x25a1, 
0x8900,0x25a1, 0x8903,0x25a1, 0x8904,0x25a1, 0x8908,0x25a1, 0x890d,0x25a1, 
0x890f,0x25a1, 0x891b,0x8938, 0x891c,0x25a1, 0x891d,0x25a1, 0x8920,0x25a1, 
0x8924,0x25a1, 0x8928,0x25a1, 0x8934,0x8964, 0x8937,0x9078, 0x8939,0x25a1, 
0x893a,0x25a1, 0x893f,0x25a1, 0x8940,0x25a1, 0x8943,0x25a1, 0x8945,0x25a1, 
0x8947,0x25a1, 0x8948,0x25a1, 0x894a,0x25a1, 0x894d,0x25a1, 0x894e,0x25a1, 
0x8954,0x25a1, 0x8955,0x8974, 0x8965,0x25a1, 0x8967,0x25a1, 0x8968,0x25a1, 
0x8970,0x25a1, 0x8975,0x25a1, 0x8977,0x25a1, 0x8978,0x25a1, 0x897d,0x25a1, 
0x8980,0x25a1, 0x8984,0x25a1, 0x8987,0x9738, 0x8989,0x25a1, 0x898a,0x25a1, 
0x898c,0x25a1, 0x898d,0x25a1, 0x898e,0x25a1, 0x8990,0x25a1, 0x8991,0x25a1, 
0x8992,0x25a1, 0x8994,0x25a1, 0x8999,0x25a1, 0x899a,0x89ba, 0x89a0,0x25a1, 
0x89a5,0x25a1, 0x89a7,0x89bd, 0x89a8,0x25a1, 0x89a9,0x7779, 0x89ab,0x25a1, 
0x89b0,0x25a1, 0x89b1,0x25a1, 0x89b3,0x25a1, 0x89b4,0x25a1, 0x89b5,0x25a1, 
0x89b8,0x25a1, 0x89bb,0x25a1, 0x89bc,0x25a1, 0x89c1,0x898b, 0x89c2,0x89c0, 
0x89c3,0x25a1, 0x89c4,0x898f, 0x89c5,0x8993, 0x89c6,0x8996, 0x89c7,0x8998, 
0x89c8,0x89bd, 0x89c9,0x89ba, 0x89ca,0x89ac, 0x89cb,0x89a1, 0x89cc,0x89bf, 
0x89cd,0x25a1, 0x89ce,0x89a6, 0x89cf,0x89af, 0x89d0,0x89b2, 0x89d1,0x89b7, 
0x89d7,0x89dd, 0x89d8,0x25a1, 0x89de,0x89f4, 0x89e6,0x89f8, 0x89e7,0x25a1, 
0x89ea,0x25a1, 0x89ee,0x25a1, 0x89ef,0x89f6, 0x89f5,0x25a1, 0x89f9,0x25a1, 
0x89fd,0x25a1, 0x8a01,0x25a1, 0x8a05,0x25a1, 0x8a06,0x25a1, 0x8a09,0x25a1, 
0x8a0b,0x25a1, 0x8a0d,0x25a1, 0x8a14,0x25a1, 0x8a19,0x25a1, 0x8a1a,0x25a1, 
0x8a1c,0x25a1, 0x8a20,0x25a1, 0x8a21,0x541f, 0x8a24,0x25a1, 0x8a26,0x25a1, 
0x8a28,0x25a1, 0x8a29,0x25a1, 0x8a2b,0x25a1, 0x8a2e,0x25a1, 0x8a2f,0x25a1, 
0x8a32,0x25a1, 0x8a33,0x25a1, 0x8a35,0x25a1, 0x8a37,0x25a1, 0x8a38,0x25a1, 
0x8a3d,0x25a1, 0x8a42,0x25a1, 0x8a43,0x25a1, 0x8a47,0x25a1, 0x8a49,0x25a1, 
0x8a4b,0x25a1, 0x8a53,0x25a1, 0x8a5a,0x25a1, 0x8a5c,0x25a1, 0x8a5d,0x25a1, 
0x8a5f,0x8b8b, 0x8a64,0x8b0a, 0x8a65,0x25a1, 0x8a67,0x25a1, 0x8a6a,0x25a1, 
0x8a6f,0x25a1, 0x8a78,0x25a1, 0x8a7d,0x25a1, 0x8a7e,0x25a1, 0x8a80,0x6d74, 
0x8a88,0x25a1, 0x8a89,0x8b7d, 0x8a8a,0x8b04, 0x8a8e,0x25a1, 0x8a90,0x25a1, 
0x8a94,0x25a1, 0x8a97,0x25a1, 0x8a9b,0x25a1, 0x8a9c,0x25a1, 0x8a9d,0x25a1, 
0x8a9f,0x25a1, 0x8aa2,0x25a1, 0x8aa9,0x25a1, 0x8aac,0x8aaa, 0x8aad,0x8b80, 
0x8aae,0x25a1, 0x8aaf,0x25a1, 0x8ab1,0x25a1, 0x8ab3,0x25a1, 0x8ab4,0x25a1, 
0x8ab5,0x25a1, 0x8ab7,0x25a1, 0x8ac1,0x25a1, 0x8aca,0x25a1, 0x8acc,0x25a1, 
0x8ace,0x25a1, 0x8ad0,0x25a1, 0x8ada,0x25a1, 0x8ae3,0x9358, 0x8ae5,0x25a1, 
0x8ae9,0x25a1, 0x8aea,0x25a1, 0x8aec,0x25a1, 0x8af9,0x25a1, 0x8afd,0x25a1, 
0x8b03,0x25a1, 0x8b09,0x25a1, 0x8b0c,0x25a1, 0x8b1f,0x25a1, 0x8b21,0x25a1, 
0x8b29,0x25a1, 0x8b2d,0x25a1, 0x8b32,0x25a1, 0x8b34,0x25a1, 0x8b38,0x25a1, 
0x8b3f,0x25a1, 0x8b43,0x25a1, 0x8b44,0x25a1, 0x8b45,0x5e40, 0x8b4c,0x25a1, 
0x8b4d,0x25a1, 0x8b5b,0x25a1, 0x8b5e,0x25a1, 0x8b61,0x25a1, 0x8b62,0x25a1, 
0x8b64,0x25a1, 0x8b69,0x25a1, 0x8b6e,0x25a1, 0x8b71,0x25a1, 0x8b72,0x25a1, 
0x8b73,0x25a1, 0x8b75,0x25a1, 0x8b76,0x25a1, 0x8b7c,0x25a1, 0x8b81,0x8b2b, 
0x8b83,0x25a1, 0x8b87,0x25a1, 0x8b89,0x25a1, 0x8b8d,0x25a1, 0x8b8f,0x25a1, 
0x8b90,0x25a1, 0x8b91,0x25a1, 0x8b97,0x25a1, 0x8b9b,0x25a1, 0x8b9d,0x25a1, 
0x8ba0,0x8a00, 0x8ba1,0x8a08, 0x8ba2,0x8a02, 0x8ba3,0x8a03, 0x8ba4,0x8a8d, 
0x8ba5,0x8b4f, 0x8ba6,0x8a10, 0x8ba7,0x8a0c, 0x8ba8,0x8a0e, 0x8ba9,0x8b93, 
0x8baa,0x8a15, 0x8bab,0x8a16, 0x8bac,0x25a1, 0x8bad,0x8a13, 0x8bae,0x8b70, 
0x8baf,0x8a0a, 0x8bb0,0x8a18, 0x8bb1,0x8a12, 0x8bb2,0x8b1b, 0x8bb3,0x8af1, 
0x8bb4,0x8b33, 0x8bb5,0x8a4e, 0x8bb6,0x8a1d, 0x8bb7,0x8a25, 0x8bb8,0x8a31, 
0x8bb9,0x8a1b, 0x8bba,0x8ad6, 0x8bbb,0x25a1, 0x8bbc,0x8a1f, 0x8bbd,0x8af7, 
0x8bbe,0x8a2d, 0x8bbf,0x8a2a, 0x8bc0,0x8a23, 0x8bc1,0x8a3c, 0x8bc2,0x8a41, 
0x8bc3,0x8a36, 0x8bc4,0x8a55, 0x8bc5,0x8a5b, 0x8bc6,0x8b58, 0x8bc7,0x8a57, 
0x8bc8,0x8a50, 0x8bc9,0x8a34, 0x8bca,0x8a3a, 0x8bcb,0x8a46, 0x8bcc,0x8b05, 
0x8bcd,0x8a5e, 0x8bce,0x8a58, 0x8bcf,0x8a54, 0x8bd0,0x8a56, 0x8bd1,0x8b6f, 
0x8bd2,0x8a52, 0x8bd3,0x8a86, 0x8bd4,0x8a84, 0x8bd5,0x8a66, 0x8bd6,0x8a7f, 
0x8bd7,0x8a69, 0x8bd8,0x8a70, 0x8bd9,0x8a7c, 0x8bda,0x8aa0, 0x8bdb,0x8a85, 
0x8bdc,0x8a75, 0x8bdd,0x8a71, 0x8bde,0x8a95, 0x8bdf,0x8a6c, 0x8be0,0x8a6e, 
0x8be1,0x8a6d, 0x8be2,0x8a62, 0x8be3,0x8a63, 0x8be4,0x8acd, 0x8be5,0x8a72, 
0x8be6,0x8a73, 0x8be7,0x8a6b, 0x8be8,0x8ae2, 0x8be9,0x8a61, 0x8bea,0x8b78, 
0x8beb,0x8aa1, 0x8bec,0x8aa3, 0x8bed,0x8a9e, 0x8bee,0x8a9a, 0x8bef,0x8aa4, 
0x8bf0,0x8aa5, 0x8bf1,0x8a98, 0x8bf2,0x8aa8, 0x8bf3,0x8a91, 0x8bf4,0x8aaa, 
0x8bf5,0x8aa6, 0x8bf6,0x8a92, 0x8bf7,0x8acb, 0x8bf8,0x8af8, 0x8bf9,0x8acf, 
0x8bfa,0x8afe, 0x8bfb,0x8b80, 0x8bfc,0x8ad1, 0x8bfd,0x8ab9, 0x8bfe,0x8ab2, 
0x8bff,0x8ac9, 0x8c00,0x8adb, 0x8c01,0x8ab0, 0x8c02,0x8ad7, 0x8c03,0x8abf, 
0x8c04,0x8ac2, 0x8c05,0x8ad2, 0x8c06,0x8ac4, 0x8c07,0x8ab6, 0x8c08,0x8ac7, 
0x8c09,0x25a1, 0x8c0a,0x8abc, 0x8c0b,0x8b00, 0x8c0c,0x8af6, 0x8c0d,0x8adc, 
0x8c0e,0x8b0a, 0x8c0f,0x8aeb, 0x8c10,0x8ae7, 0x8c11,0x8b14, 0x8c12,0x8b01, 
0x8c13,0x8b02, 0x8c14,0x8ae4, 0x8c15,0x8aed, 0x8c16,0x8afc, 0x8c17,0x8b92, 
0x8c18,0x8aee, 0x8c19,0x8af3, 0x8c1a,0x8afa, 0x8c1b,0x8ae6, 0x8c1c,0x8b0e, 
0x8c1d,0x8ade, 0x8c1e,0x4f4f, 0x8c1f,0x8b28, 0x8c20,0x8b9c, 0x8c21,0x8b16, 
0x8c22,0x8b1d, 0x8c23,0x8b20, 0x8c24,0x8b17, 0x8c25,0x8b1a, 0x8c26,0x8b19, 
0x8c27,0x8b10, 0x8c28,0x8b39, 0x8c29,0x8b3e, 0x8c2a,0x8b2b, 0x8c2b,0x8b7e, 
0x8c2c,0x8b2c, 0x8c2d,0x8b5a, 0x8c2e,0x8b56, 0x8c2f,0x8b59, 0x8c30,0x8b95, 
0x8c31,0x8b5c, 0x8c32,0x8b4e, 0x8c33,0x8b9e, 0x8c34,0x8b74, 0x8c35,0x8b6b, 
0x8c36,0x8b96, 0x8c38,0x25a1, 0x8c3a,0x25a1, 0x8c40,0x25a1, 0x8c44,0x25a1, 
0x8c51,0x25a1, 0x8c52,0x25a1, 0x8c53,0x25a1, 0x8c58,0x25a1, 0x8c59,0x25a1, 
0x8c5b,0x25a1, 0x8c5e,0x25a1, 0x8c60,0x25a1, 0x8c63,0x25a1, 0x8c67,0x25a1, 
0x8c6e,0x8c76, 0x8c74,0x25a1, 0x8c7c,0x25a1, 0x8c7e,0x25a1, 0x8c7f,0x25a1, 
0x8c83,0x25a1, 0x8c87,0x25a1, 0x8c88,0x25a1, 0x8c8b,0x25a1, 0x8c8e,0x25a1, 
0x8c96,0x25a1, 0x8c9b,0x25a1, 0x8c9f,0x25a1, 0x8ca6,0x25a1, 0x8cad,0x4e8d, 
0x8cae,0x8cb3, 0x8cb1,0x25a1, 0x8cc6,0x25a1, 0x8cc9,0x25a1, 0x8ccb,0x25a1, 
0x8ccd,0x8d13, 0x8cce,0x8ce4, 0x8cd0,0x25a1, 0x8cd4,0x25a1, 0x8cd6,0x8cd2, 
0x8cd8,0x9ad2, 0x8cdb,0x25a1, 0x8ce9,0x25a1, 0x8ceb,0x25a1, 0x8cef,0x25a1, 
0x8cf2,0x25a1, 0x8cf6,0x25a1, 0x8cf7,0x25a1, 0x8cff,0x25a1, 0x8d01,0x25a1, 
0x8d03,0x25a1, 0x8d0b,0x8d17, 0x8d0c,0x25a1, 0x8d0e,0x25a1, 0x8d11,0x25a1, 
0x8d12,0x25a1, 0x8d18,0x511f, 0x8d1a,0x25a1, 0x8d1c,0x25a1, 0x8d1d,0x8c9d, 
0x8d1e,0x8c9e, 0x8d1f,0x8ca0, 0x8d20,0x25a1, 0x8d21,0x8ca2, 0x8d22,0x8ca1, 
0x8d23,0x8cac, 0x8d24,0x8ce2, 0x8d25,0x6557, 0x8d26,0x8cec, 0x8d27,0x8ca8, 
0x8d28,0x8cea, 0x8d29,0x8ca9, 0x8d2a,0x8caa, 0x8d2b,0x8ca7, 0x8d2c,0x8cb6, 
0x8d2d,0x8cfc, 0x8d2e,0x8caf, 0x8d2f,0x8cab, 0x8d30,0x8cb3, 0x8d31,0x8ce4, 
0x8d32,0x8cc1, 0x8d33,0x8cb0, 0x8d34,0x8cbc, 0x8d35,0x8cb4, 0x8d36,0x8cba, 
0x8d37,0x8cb8, 0x8d38,0x8cbf, 0x8d39,0x8cbb, 0x8d3a,0x8cc0, 0x8d3b,0x8cbd, 
0x8d3c,0x8cca, 0x8d3d,0x8d04, 0x8d3e,0x8cc8, 0x8d3f,0x8cc4, 0x8d40,0x8cb2, 
0x8d41,0x8cc3, 0x8d42,0x8cc2, 0x8d43,0x8d13, 0x8d44,0x8cc7, 0x8d45,0x8cc5, 
0x8d46,0x8d10, 0x8d47,0x8cd5, 0x8d48,0x8cd1, 0x8d49,0x8cda, 0x8d4a,0x8cd2, 
0x8d4b,0x8ce6, 0x8d4c,0x8ced, 0x8d4d,0x9f4e, 0x8d4e,0x8d16, 0x8d4f,0x8cde, 
0x8d50,0x8cdc, 0x8d51,0x8d14, 0x8d52,0x8cd9, 0x8d53,0x8ce1, 0x8d54,0x8ce0, 
0x8d55,0x8ce7, 0x8d56,0x8cf4, 0x8d57,0x8cf5, 0x8d58,0x8d05, 0x8d59,0x8cfb, 
0x8d5a,0x8cfa, 0x8d5b,0x8cfd, 0x8d5c,0x8cfe, 0x8d5d,0x8d17, 0x8d5e,0x8d0a, 
0x8d5f,0x8d07, 0x8d60,0x8d08, 0x8d61,0x8d0d, 0x8d62,0x8d0f, 0x8d63,0x8d1b, 
0x8d65,0x25a1, 0x8d6a,0x8d6c, 0x8d71,0x25a1, 0x8d75,0x8d99, 0x8d76,0x8d95, 
0x8d7a,0x25a1, 0x8d7c,0x25a1, 0x8d7e,0x25a1, 0x8d7f,0x25a1, 0x8d82,0x25a1, 
0x8d83,0x25a1, 0x8d86,0x25a1, 0x8d87,0x25a1, 0x8d88,0x25a1, 0x8d8b,0x8da8, 
0x8d97,0x25a1, 0x8d98,0x25a1, 0x8d9a,0x25a1, 0x8d9d,0x25a1, 0x8d9e,0x25a1, 
0x8da2,0x25a1, 0x8da4,0x25a1, 0x8da6,0x25a1, 0x8da9,0x25a1, 0x8db0,0x25a1, 
0x8db1,0x8db2, 0x8db8,0x8e89, 0x8dbb,0x25a1, 0x8dbd,0x25a1, 0x8dc0,0x25a1, 
0x8dc3,0x8e8d, 0x8dc4,0x8e4c, 0x8dc9,0x25a1, 0x8dca,0x25a1, 0x8dd2,0x25a1, 
0x8dd4,0x25a1, 0x8dde,0x8e92, 0x8de5,0x25a1, 0x8ded,0x25a1, 0x8df5,0x8e10, 
0x8df6,0x8e82, 0x8df7,0x8e7a, 0x8df8,0x8e55, 0x8df9,0x8e9a, 0x8dfb,0x8e8b, 
0x8e01,0x25a1, 0x8e08,0x25a1, 0x8e0b,0x25a1, 0x8e0c,0x8e8a, 0x8e0e,0x25a1, 
0x8e28,0x25a1, 0x8e2a,0x8e64, 0x8e2c,0x8e93, 0x8e2d,0x25a1, 0x8e2f,0x8e91, 
0x8e32,0x25a1, 0x8e37,0x25a1, 0x8e3a,0x8171, 0x8e3b,0x25a1, 0x8e43,0x25a1, 
0x8e46,0x25a1, 0x8e4f,0x25a1, 0x8e51,0x8ea1, 0x8e52,0x8e63, 0x8e58,0x25a1, 
0x8e68,0x25a1, 0x8e6b,0x25a1, 0x8e6e,0x25a1, 0x8e70,0x8e95, 0x8e71,0x90b8, 
0x8e75,0x25a1, 0x8e77,0x25a1, 0x8e79,0x25a1, 0x8e7d,0x25a1, 0x8e7e,0x25a1, 
0x8e7f,0x8ea5, 0x8e80,0x25a1, 0x8e83,0x25a1, 0x8e8f,0x8eaa, 0x8e99,0x25a1, 
0x8e9b,0x25a1, 0x8e9c,0x8ea6, 0x8ea2,0x25a1, 0x8ea7,0x25a1, 0x8ead,0x25a1, 
0x8eae,0x25a1, 0x8eaf,0x8ec0, 0x8eb0,0x25a1, 0x8eb1,0x25a1, 0x8eb3,0x25a1, 
0x8eb4,0x25a1, 0x8eb5,0x25a1, 0x8eb6,0x25a1, 0x8eb7,0x25a1, 0x8eb8,0x25a1, 
0x8eb9,0x25a1, 0x8ebb,0x25a1, 0x8ebc,0x25a1, 0x8ebe,0x25a1, 0x8ebf,0x25a1, 
0x8ec1,0x25a1, 0x8ec3,0x25a1, 0x8ec4,0x25a1, 0x8ec5,0x25a1, 0x8ec6,0x25a1, 
0x8ec7,0x25a1, 0x8ec8,0x25a1, 0x8ece,0x8eca, 0x8ed0,0x25a1, 0x8ed5,0x25a1, 
0x8ed6,0x25a1, 0x8ed9,0x25a1, 0x8eda,0x25a1, 0x8ee2,0x25a1, 0x8ee3,0x25a1, 
0x8ee4,0x5874, 0x8eea,0x25a1, 0x8eed,0x25a1, 0x8ef0,0x25a1, 0x8ef2,0x25a1, 
0x8ef3,0x25a1, 0x8efd,0x25a1, 0x8f04,0x25a1, 0x8f0c,0x25a1, 0x8f0f,0x25a1, 
0x8f19,0x25a1, 0x8f21,0x25a1, 0x8f22,0x25a1, 0x8f27,0x25a1, 0x8f28,0x25a1, 
0x8f2b,0x25a1, 0x8f2d,0x25a1, 0x8f30,0x25a1, 0x8f31,0x25a1, 0x8f3a,0x25a1, 
0x8f3c,0x25a1, 0x8f3d,0x25a1, 0x8f41,0x25a1, 0x8f4a,0x25a1, 0x8f4c,0x25a1, 
0x8f5c,0x25a1, 0x8f65,0x25a1, 0x8f66,0x8eca, 0x8f67,0x8ecb, 0x8f68,0x8ecc, 
0x8f69,0x8ed2, 0x8f6a,0x8ed1, 0x8f6b,0x8ed4, 0x8f6c,0x8f49, 0x8f6d,0x8edb, 
0x8f6e,0x8f2a, 0x8f6f,0x8edf, 0x8f70,0x8f5f, 0x8f71,0x53e4, 0x8f72,0x8efb, 
0x8f73,0x8f64, 0x8f74,0x8ef8, 0x8f75,0x8ef9, 0x8f76,0x8efc, 0x8f77,0x4e4e, 
0x8f78,0x8eeb, 0x8f79,0x8f62, 0x8f7a,0x8efa, 0x8f7b,0x8f15, 0x8f7c,0x8efe, 
0x8f7d,0x8f09, 0x8f7e,0x8f0a, 0x8f7f,0x8f4e, 0x8f80,0x8f08, 0x8f81,0x8f07, 
0x8f82,0x8f05, 0x8f83,0x8f03, 0x8f84,0x8f12, 0x8f85,0x8f14, 0x8f86,0x8f1b, 
0x8f87,0x8f26, 0x8f88,0x8f29, 0x8f89,0x8f1d, 0x8f8a,0x8f25, 0x8f8b,0x8f1e, 
0x8f8c,0x8f2c, 0x8f8d,0x8f1f, 0x8f8e,0x8f1c, 0x8f8f,0x8f33, 0x8f90,0x8f3b, 
0x8f91,0x8f2f, 0x8f92,0x8f40, 0x8f93,0x8f38, 0x8f94,0x8f61, 0x8f95,0x8f45, 
0x8f96,0x8f44, 0x8f97,0x8f3e, 0x8f98,0x8f46, 0x8f99,0x8f4d, 0x8f9a,0x8f54, 
0x8f9d,0x25a1, 0x8f9e,0x8fad, 0x8f9f,0x95e2, 0x8fa0,0x25a1, 0x8fa1,0x25a1, 
0x8fa2,0x25a1, 0x8fa4,0x25a1, 0x8fa5,0x25a1, 0x8fa7,0x25a1, 0x8fa9,0x8faf, 
0x8faa,0x25a1, 0x8fab,0x8fae, 0x8fac,0x8fa8, 0x8fb3,0x25a1, 0x8fb5,0x25a1, 
0x8fb6,0x8d70, 0x8fb7,0x25a1, 0x8fb8,0x25a1, 0x8fb9,0x908a, 0x8fba,0x25a1, 
0x8fbb,0x25a1, 0x8fbc,0x25a1, 0x8fbd,0x907c, 0x8fbe,0x9054, 0x8fc0,0x25a1, 
0x8fc1,0x9077, 0x8fc3,0x25a1, 0x8fc7,0x904e, 0x8fc8,0x9081, 0x8fca,0x25a1, 
0x8fcc,0x25a1, 0x8fcf,0x25a1, 0x8fd0,0x904b, 0x8fd8,0x9084, 0x8fd9,0x9019, 
0x8fda,0x25a1, 0x8fdb,0x9032, 0x8fdc,0x9060, 0x8fdd,0x9055, 0x8fde,0x9023, 
0x8fdf,0x9072, 0x8fe7,0x25a1, 0x8fe9,0x9087, 0x8fec,0x25a1, 0x8fef,0x25a1, 
0x8ff1,0x25a1, 0x8ff2,0x25a1, 0x8ff3,0x9015, 0x8ff9,0x8de1, 0x9002,0x9069, 
0x9007,0x25a1, 0x9008,0x25a1, 0x9009,0x9078, 0x900a,0x905c, 0x900e,0x25a1, 
0x9012,0x905e, 0x9013,0x25a1, 0x9018,0x8556, 0x9025,0x25a1, 0x9026,0x9090, 
0x9027,0x25a1, 0x9028,0x25a1, 0x9029,0x25a1, 0x902a,0x25a1, 0x902b,0x25a1, 
0x902c,0x25a1, 0x9030,0x25a1, 0x9033,0x25a1, 0x9037,0x25a1, 0x9039,0x25a1, 
0x903a,0x25a1, 0x903b,0x908f, 0x9040,0x25a1, 0x9043,0x25a1, 0x9045,0x25a1, 
0x9046,0x25a1, 0x9048,0x25a1, 0x904c,0x25a1, 0x9056,0x25a1, 0x9057,0x907a, 
0x905a,0x25a1, 0x905f,0x25a1, 0x9061,0x25a1, 0x9064,0x25a1, 0x9065,0x9059, 
0x9066,0x25a1, 0x906a,0x25a1, 0x906c,0x25a1, 0x9071,0x25a1, 0x9089,0x25a1, 
0x908c,0x25a1, 0x908e,0x25a1, 0x9092,0x25a1, 0x9093,0x9127, 0x9096,0x25a1, 
0x909a,0x25a1, 0x909c,0x25a1, 0x909d,0x913a, 0x90a4,0x25a1, 0x90a8,0x25a1, 
0x90a9,0x25a1, 0x90ab,0x25a1, 0x90ac,0x9114, 0x90ad,0x25a1, 0x90ae,0x90f5, 
0x90b7,0x25a1, 0x90b9,0x9112, 0x90ba,0x9134, 0x90bb,0x9130, 0x90bc,0x25a1, 
0x90c0,0x647a, 0x90c1,0x9b31, 0x90c2,0x25a1, 0x90c4,0x537b, 0x90c6,0x25a1, 
0x90c9,0x25a1, 0x90cc,0x25a1, 0x90cd,0x25a1, 0x90cf,0x90df, 0x90d0,0x9136, 
0x90d1,0x912d, 0x90d2,0x25a1, 0x90d3,0x9106, 0x90de,0x25a1, 0x90e6,0x9148, 
0x90e7,0x9116, 0x90ee,0x25a1, 0x90f6,0x25a1, 0x90f7,0x9109, 0x90f8,0x9132, 
0x910a,0x9109, 0x910c,0x25a1, 0x9113,0x25a1, 0x9115,0x9109, 0x9125,0x25a1, 
0x9137,0x9146, 0x913c,0x25a1, 0x913d,0x25a1, 0x9142,0x25a1, 0x9144,0x5537, 
0x9151,0x25a1, 0x9154,0x25a1, 0x9159,0x25a1, 0x915b,0x25a1, 0x915c,0x25a1, 
0x915d,0x919e, 0x915e,0x6c70, 0x9166,0x91b1, 0x9167,0x25a1, 0x916b,0x25a1, 
0x916d,0x25a1, 0x9170,0x2eb6, 0x9171,0x91ac, 0x9176,0x9ef4, 0x917b,0x25a1, 
0x917c,0x25a1, 0x917d,0x91c5, 0x917e,0x91c3, 0x917f,0x91c0, 0x9188,0x25a1, 
0x918c,0x6606, 0x918e,0x25a1, 0x9194,0x25a1, 0x9195,0x25a1, 0x9196,0x25a1, 
0x9197,0x25a1, 0x9198,0x25a1, 0x91a4,0x25a1, 0x91a6,0x25a1, 0x91a9,0x25a1, 
0x91b6,0x25a1, 0x91b8,0x25a1, 0x91bb,0x25a1, 0x91bf,0x25a1, 0x91c4,0x25a1, 
0x91c7,0x63a1, 0x91c8,0x25a1, 0x91ca,0x91cb, 0x91d2,0x25a1, 0x91d6,0x25a1, 
0x91db,0x25a1, 0x91de,0x25a1, 0x91df,0x25a1, 0x91e0,0x25a1, 0x91e1,0x65a7, 
0x91e5,0x5e37, 0x91ef,0x25a1, 0x91f0,0x25a1, 0x91f2,0x25a1, 0x91f6,0x25a1, 
0x91fa,0x25a1, 0x91fb,0x25a1, 0x91fc,0x25a1, 0x91fe,0x25a1, 0x9208,0x25a1, 
0x920b,0x25a1, 0x920e,0x25a1, 0x9213,0x25a1, 0x9218,0x25a1, 0x921b,0x25a1, 
0x921d,0x25a1, 0x921f,0x25a1, 0x9220,0x25a1, 0x9221,0x25a1, 0x9222,0x25a1, 
0x9228,0x25a1, 0x9229,0x25a1, 0x922a,0x25a1, 0x922b,0x25a1, 0x922c,0x25a1, 
0x922f,0x25a1, 0x9235,0x25a1, 0x923b,0x25a1, 0x923c,0x25a1, 0x9241,0x25a1, 
0x9242,0x25a1, 0x9243,0x25a1, 0x9244,0x25a1, 0x9247,0x25a1, 0x9255,0x25a1, 
0x9258,0x25a1, 0x9259,0x25a1, 0x925c,0x25a1, 0x925d,0x25a1, 0x925f,0x25a1, 
0x9262,0x25a1, 0x9268,0x25a1, 0x9269,0x25a1, 0x926a,0x25a1, 0x926b,0x25a1, 
0x926e,0x25a1, 0x9271,0x25a1, 0x9273,0x25a1, 0x9274,0x9452, 0x9275,0x25a1, 
0x9277,0x25a1, 0x9281,0x25a1, 0x9284,0x25a1, 0x9289,0x25a1, 0x928f,0x25a1, 
0x9290,0x25a1, 0x9292,0x25a1, 0x929e,0x25a1, 0x929f,0x25a1, 0x92a7,0x606a, 
0x92ad,0x25a1, 0x92ae,0x947e, 0x92af,0x25a1, 0x92b0,0x25a1, 0x92b1,0x25a1, 
0x92b8,0x25a1, 0x92ba,0x25a1, 0x92bd,0x25a1, 0x92be,0x25a1, 0x92bf,0x25a1, 
0x92d4,0x25a1, 0x92d6,0x25a1, 0x92da,0x25a1, 0x92db,0x25a1, 0x92dc,0x25a1, 
0x92e2,0x25a1, 0x92e3,0x25a1, 0x92e5,0x25a1, 0x92eb,0x25a1, 0x92ec,0x25a1, 
0x92ed,0x25a1, 0x92f2,0x25a1, 0x92f3,0x25a1, 0x92f4,0x25a1, 0x92f5,0x25a1, 
0x92f6,0x25a1, 0x92fd,0x25a1, 0x9303,0x25a1, 0x9305,0x25a1, 0x9307,0x25a1, 
0x9309,0x6d39, 0x930a,0x25a1, 0x9311,0x25a1, 0x9317,0x25a1, 0x931c,0x25a1, 
0x932c,0x25a1, 0x9330,0x25a1, 0x9331,0x25a1, 0x9332,0x25a1, 0x9337,0x25a1, 
0x933a,0x25a1, 0x933b,0x25a1, 0x933d,0x25a1, 0x933e,0x93e8, 0x933f,0x25a1, 
0x9340,0x25a1, 0x9341,0x25a1, 0x9342,0x25a1, 0x9343,0x25a1, 0x9344,0x25a1, 
0x9345,0x25a1, 0x9348,0x25a1, 0x9353,0x25a1, 0x935d,0x25a1, 0x935f,0x25a1, 
0x9362,0x25a1, 0x9366,0x25a1, 0x9368,0x25a1, 0x9369,0x25a1, 0x936b,0x6fc9, 
0x936e,0x25a1, 0x936f,0x25a1, 0x9372,0x25a1, 0x9373,0x25a1, 0x9374,0x25a1, 
0x9378,0x25a1, 0x937d,0x25a1, 0x937f,0x25a1, 0x9381,0x25a1, 0x9384,0x25a1, 
0x9385,0x25a1, 0x9386,0x25a1, 0x9387,0x25a1, 0x938b,0x25a1, 0x9390,0x25a1, 
0x9393,0x25a1, 0x939c,0x25a1, 0x93a0,0x25a1, 0x93ab,0x25a1, 0x93ad,0x25a1, 
0x93b6,0x25a1, 0x93b8,0x25a1, 0x93b9,0x25a1, 0x93ba,0x25a1, 0x93bb,0x9396, 
0x93bc,0x25a1, 0x93bd,0x25a1, 0x93be,0x25a1, 0x93bf,0x25a1, 0x93c1,0x25a1, 
0x93c5,0x25a1, 0x93c6,0x25a1, 0x93c9,0x25a1, 0x93cb,0x25a1, 0x93d3,0x25a1, 
0x93db,0x25a1, 0x93e0,0x25a1, 0x93e5,0x25a1, 0x93e9,0x25a1, 0x93ea,0x25a1, 
0x93eb,0x25a1, 0x93ed,0x25a1, 0x93ef,0x25a1, 0x93f0,0x25a1, 0x93f1,0x25a1, 
0x93f2,0x25a1, 0x93f3,0x25a1, 0x93f4,0x25a1, 0x9401,0x25a1, 0x9402,0x25a1, 
0x9404,0x25a1, 0x9405,0x25a1, 0x9408,0x25a1, 0x9417,0x25a1, 0x941a,0x25a1, 
0x941b,0x25a1, 0x941c,0x25a1, 0x941d,0x25a1, 0x941e,0x25a1, 0x941f,0x25a1, 
0x9421,0x25a1, 0x9422,0x25a1, 0x9423,0x25a1, 0x9424,0x25a1, 0x9425,0x25a1, 
0x9426,0x25a1, 0x9427,0x25a1, 0x942d,0x25a1, 0x942f,0x25a1, 0x9434,0x25a1, 
0x943e,0x58c1, 0x9441,0x25a1, 0x9442,0x25a1, 0x9443,0x25a1, 0x944d,0x25a1, 
0x944e,0x25a1, 0x9453,0x25a1, 0x9454,0x25a1, 0x9456,0x25a1, 0x9458,0x25a1, 
0x9459,0x25a1, 0x945a,0x25a1, 0x945b,0x25a1, 0x945c,0x25a1, 0x945f,0x25a1, 
0x9461,0x25a1, 0x9465,0x25a1, 0x9466,0x25a1, 0x9467,0x25a1, 0x946c,0x25a1, 
0x9479,0x25a1, 0x947a,0x25a1, 0x947b,0x25a1, 0x9484,0x25a1, 0x9485,0x91d1, 
0x9486,0x91d3, 0x9487,0x91d4, 0x9488,0x91dd, 0x9489,0x91d8, 0x948a,0x91d7, 
0x948b,0x91d9, 0x948c,0x91d5, 0x948d,0x91f7, 0x948e,0x9431, 0x948f,0x91e7, 
0x9490,0x91e4, 0x9491,0x9212, 0x9492,0x91e9, 0x9493,0x91e3, 0x9494,0x9346, 
0x9495,0x91f9, 0x9496,0x935a, 0x9497,0x91f5, 0x9498,0x9203, 0x9499,0x9223, 
0x949a,0x923d, 0x949b,0x9226, 0x949c,0x9245, 0x949d,0x920d, 0x949e,0x9214, 
0x949f,0x9418, 0x94a0,0x9209, 0x94a1,0x92c7, 0x94a2,0x92fc, 0x94a3,0x9211, 
0x94a4,0x9210, 0x94a5,0x9470, 0x94a6,0x6b3d, 0x94a7,0x921e, 0x94a8,0x93a2, 
0x94a9,0x9264, 0x94aa,0x9227, 0x94ab,0x9201, 0x94ac,0x9225, 0x94ad,0x9204, 
0x94ae,0x9215, 0x94af,0x9200, 0x94b0,0x923a, 0x94b1,0x9322, 0x94b2,0x9266, 
0x94b3,0x9257, 0x94b4,0x9237, 0x94b5,0x7f3d, 0x94b6,0x9233, 0x94b7,0x93c2, 
0x94b8,0x923d, 0x94b9,0x9238, 0x94ba,0x925e, 0x94bb,0x947d, 0x94bc,0x926c, 
0x94bd,0x926d, 0x94be,0x9240, 0x94bf,0x923f, 0x94c0,0x923e, 0x94c1,0x9435, 
0x94c2,0x9251, 0x94c3,0x9234, 0x94c4,0x9460, 0x94c5,0x925b, 0x94c6,0x925a, 
0x94c7,0x25a1, 0x94c8,0x9230, 0x94c9,0x9249, 0x94ca,0x9248, 0x94cb,0x924d, 
0x94cc,0x922e, 0x94cd,0x9239, 0x94ce,0x9438, 0x94cf,0x9276, 0x94d0,0x92ac, 
0x94d1,0x92a0, 0x94d2,0x927a, 0x94d3,0x92e9, 0x94d4,0x930f, 0x94d5,0x92aa, 
0x94d6,0x92ee, 0x94d7,0x92cf, 0x94d8,0x90aa, 0x94d9,0x9403, 0x94da,0x928d, 
0x94db,0x943a, 0x94dc,0x9285, 0x94dd,0x92c1, 0x94de,0x540a, 0x94df,0x92a6, 
0x94e0,0x93a7, 0x94e1,0x9358, 0x94e2,0x9296, 0x94e3,0x9291, 0x94e4,0x92cc, 
0x94e5,0x92a9, 0x94e6,0x929b, 0x94e7,0x93f5, 0x94e8,0x9293, 0x94e9,0x93a9, 
0x94ea,0x927f, 0x94eb,0x929a, 0x94ec,0x927b, 0x94ed,0x9298, 0x94ee,0x931a, 
0x94ef,0x92ab, 0x94f0,0x9278, 0x94f1,0x92a5, 0x94f2,0x93df, 0x94f3,0x9283, 
0x94f4,0x940b, 0x94f5,0x92a8, 0x94f6,0x9280, 0x94f7,0x92a3, 0x94f8,0x9444, 
0x94f9,0x9412, 0x94fa,0x92ea, 0x94fb,0x92d9, 0x94fc,0x9338, 0x94fd,0x92f1, 
0x94fe,0x93c8, 0x94ff,0x93d7, 0x9500,0x92b7, 0x9501,0x9396, 0x9502,0x92f0, 
0x9503,0x5448, 0x9504,0x92e4, 0x9505,0x934b, 0x9506,0x92ef, 0x9507,0x92e8, 
0x9508,0x93fd, 0x9509,0x92bc, 0x950a,0x92dd, 0x950b,0x92d2, 0x950c,0x92c5, 
0x950d,0x7409, 0x950e,0x9272, 0x950f,0x9592, 0x9510,0x92b3, 0x9511,0x92bb, 
0x9512,0x92c3, 0x9513,0x92df, 0x9514,0x92e6, 0x9515,0x9312, 0x9516,0x9306, 
0x9517,0x937a, 0x9518,0x82e5, 0x9519,0x932f, 0x951a,0x9328, 0x951b,0x931b, 
0x951c,0x9321, 0x951d,0x939d, 0x951e,0x9301, 0x951f,0x9315, 0x9520,0x741b, 
0x9521,0x932b, 0x9522,0x932e, 0x9523,0x947c, 0x9524,0x9318, 0x9525,0x9310, 
0x9526,0x9326, 0x9527,0x9455, 0x9528,0x6774, 0x9529,0x9308, 0x952a,0x5ffd, 
0x952b,0x57f9, 0x952c,0x931f, 0x952d,0x9320, 0x952e,0x9375, 0x952f,0x92f8, 
0x9530,0x9333, 0x9531,0x9319, 0x9532,0x9365, 0x9533,0x25a1, 0x9534,0x9347, 
0x9535,0x93d8, 0x9536,0x9376, 0x9537,0x9354, 0x9538,0x9364, 0x9539,0x936c, 
0x953a,0x937e, 0x953b,0x935b, 0x953c,0x93aa, 0x953d,0x9360, 0x953e,0x9370, 
0x953f,0x9440, 0x9540,0x934d, 0x9541,0x9382, 0x9542,0x93e4, 0x9543,0x93a1, 
0x9544,0x9428, 0x9545,0x92c2, 0x9546,0x93cc, 0x9547,0x93ae, 0x9548,0x939b, 
0x9549,0x9398, 0x954a,0x9477, 0x954b,0x9482, 0x954c,0x942b, 0x954d,0x93b3, 
0x954e,0x62ff, 0x954f,0x93a6, 0x9550,0x93ac, 0x9551,0x938a, 0x9552,0x93b0, 
0x9553,0x93b5, 0x9554,0x944c, 0x9555,0x9394, 0x9556,0x93e2, 0x9557,0x93dc, 
0x9558,0x93dd, 0x9559,0x93cd, 0x955a,0x25a1, 0x955b,0x93de, 0x955c,0x93e1, 
0x955d,0x93d1, 0x955e,0x93c3, 0x955f,0x93c7, 0x9560,0x93d0, 0x9561,0x9414, 
0x9562,0x9481, 0x9563,0x9410, 0x9564,0x93f7, 0x9565,0x9b6f, 0x9566,0x9413, 
0x9567,0x946d, 0x9568,0x9420, 0x9569,0x4e32, 0x956a,0x93f9, 0x956b,0x9419, 
0x956c,0x944a, 0x956d,0x9433, 0x956e,0x9436, 0x956f,0x9432, 0x9570,0x942e, 
0x9571,0x943f, 0x9572,0x5bdf, 0x9573,0x9463, 0x9574,0x945e, 0x9575,0x9471, 
0x9576,0x9472, 0x9578,0x25a1, 0x9579,0x25a1, 0x957e,0x25a1, 0x957f,0x9577, 
0x9581,0x25a1, 0x9584,0x25a1, 0x9585,0x25a1, 0x9587,0x25a1, 0x958a,0x25a1, 
0x9595,0x25a1, 0x9596,0x25a1, 0x9597,0x25a1, 0x9599,0x25a1, 0x959a,0x25a1, 
0x959d,0x25a1, 0x95a0,0x25a1, 0x95a2,0x25a1, 0x95a6,0x25a1, 0x95a7,0x25a1, 
0x95aa,0x25a1, 0x95af,0x25a1, 0x95b2,0x95b1, 0x95b3,0x25a1, 0x95b4,0x25a1, 
0x95b8,0x25a1, 0x95c1,0x25a1, 0x95c2,0x25a1, 0x95c4,0x25a1, 0x95ce,0x25a1, 
0x95cf,0x25a1, 0x95d7,0x25a1, 0x95d8,0x25a1, 0x95d9,0x25a1, 0x95dd,0x25a1, 
0x95e6,0x25a1, 0x95e7,0x25a1, 0x95e8,0x9580, 0x95e9,0x9582, 0x95ea,0x9583, 
0x95eb,0x9586, 0x95ec,0x9588, 0x95ed,0x9589, 0x95ee,0x554f, 0x95ef,0x95d6, 
0x95f0,0x958f, 0x95f1,0x95c8, 0x95f2,0x9592, 0x95f3,0x958e, 0x95f4,0x9593, 
0x95f5,0x9594, 0x95f6,0x958c, 0x95f7,0x60b6, 0x95f8,0x9598, 0x95f9,0x9b27, 
0x95fa,0x95a8, 0x95fb,0x805e, 0x95fc,0x95e5, 0x95fd,0x95a9, 0x95fe,0x95ad, 
0x95ff,0x95d3, 0x9600,0x95a5, 0x9601,0x95a3, 0x9602,0x95a1, 0x9603,0x95ab, 
0x9604,0x9b2e, 0x9605,0x95b1, 0x9606,0x95ac, 0x9607,0x95cd, 0x9608,0x95be, 
0x9609,0x95b9, 0x960a,0x95b6, 0x960b,0x9b29, 0x960c,0x95bf, 0x960d,0x95bd, 
0x960e,0x95bb, 0x960f,0x95bc, 0x9610,0x95e1, 0x9611,0x95cc, 0x9612,0x95c3, 
0x9613,0x95e0, 0x9614,0x95ca, 0x9615,0x95cb, 0x9616,0x95d4, 0x9617,0x95d0, 
0x9618,0x95d2, 0x9619,0x95d5, 0x961a,0x95de, 0x961b,0x95e4, 0x961d,0x961c, 
0x961f,0x968a, 0x9625,0x25a1, 0x9626,0x25a1, 0x9627,0x25a1, 0x9629,0x25a1, 
0x962b,0x25a1, 0x9633,0x967d, 0x9634,0x9670, 0x9635,0x9663, 0x9636,0x968e, 
0x9637,0x25a1, 0x9638,0x25a1, 0x963e,0x25a1, 0x9641,0x25a1, 0x9645,0x969b, 
0x9646,0x9678, 0x9647,0x96b4, 0x9648,0x9673, 0x9649,0x9658, 0x9652,0x25a1, 
0x9655,0x965d, 0x9656,0x25a1, 0x9657,0x25a1, 0x9659,0x25a1, 0x965a,0x25a1, 
0x9660,0x25a1, 0x9665,0x25a1, 0x9666,0x25a1, 0x9667,0x9689, 0x9668,0x9695, 
0x9669,0x96aa, 0x966e,0x25a1, 0x9679,0x25a1, 0x967a,0x25a1, 0x967b,0x25a1, 
0x967f,0x25a1, 0x9681,0x25a1, 0x9682,0x9670, 0x968c,0x6697, 0x968f,0x96a8, 
0x9690,0x96b1, 0x9696,0x25a1, 0x969a,0x25a1, 0x969d,0x25a1, 0x969f,0x25a1, 
0x96a0,0x96b1, 0x96a3,0x25a1, 0x96a5,0x25a1, 0x96a6,0x25a1, 0x96ab,0x25a1, 
0x96ad,0x25a1, 0x96af,0x25a1, 0x96b2,0x25a1, 0x96b5,0x25a1, 0x96b6,0x96b8, 
0x96b7,0x96b8, 0x96ba,0x25a1, 0x96bd,0x96cb, 0x96be,0x96e3, 0x96cf,0x96db, 
0x96d0,0x25a1, 0x96d1,0x25a1, 0x96e0,0x8b8e, 0x96e4,0x25a1, 0x96e6,0x25a1, 
0x96e7,0x25a1, 0x96eb,0x25a1, 0x96ec,0x25a1, 0x96ed,0x25a1, 0x96ee,0x25a1, 
0x96f3,0x9742, 0x96f4,0x25a1, 0x96fc,0x25a1, 0x96fe,0x9727, 0x9701,0x973d, 
0x9703,0x25a1, 0x970a,0x9748, 0x970c,0x25a1, 0x9714,0x25a1, 0x9715,0x25a1, 
0x9717,0x25a1, 0x971a,0x25a1, 0x971b,0x25a1, 0x9720,0x643f, 0x9721,0x25a1, 
0x972d,0x9744, 0x9731,0x25a1, 0x9733,0x25a1, 0x9734,0x25a1, 0x9736,0x25a1, 
0x9737,0x25a1, 0x973b,0x25a1, 0x973c,0x25a1, 0x9740,0x25a1, 0x9741,0x25a1, 
0x9745,0x25a1, 0x974a,0x25a1, 0x974c,0x25a1, 0x974d,0x25a1, 0x974e,0x25a1, 
0x974f,0x25a1, 0x9750,0x25a1, 0x9751,0x25a1, 0x9753,0x975a, 0x9754,0x25a1, 
0x9755,0x25a1, 0x9757,0x25a1, 0x9759,0x975c, 0x975d,0x25a1, 0x975f,0x25a1, 
0x9763,0x25a1, 0x9764,0x25a1, 0x9765,0x9768, 0x9767,0x25a1, 0x976b,0x25a1, 
0x976d,0x25a1, 0x976f,0x25a1, 0x9771,0x25a1, 0x9775,0x25a1, 0x9779,0x25a1, 
0x9786,0x25a1, 0x9787,0x25a1, 0x9789,0x25a1, 0x978c,0x25a1, 0x9790,0x25a1, 
0x9791,0x97c3, 0x9792,0x8f4e, 0x9793,0x25a1, 0x9795,0x25a1, 0x9796,0x25a1, 
0x979b,0x25a1, 0x979f,0x25a1, 0x97a7,0x25a1, 0x97a9,0x25a1, 0x97af,0x97c9, 
0x97b0,0x25a1, 0x97b1,0x25a1, 0x97b2,0x97dd, 0x97b4,0x9781, 0x97b5,0x25a1, 
0x97b8,0x25a1, 0x97ba,0x25a1, 0x97bc,0x25a1, 0x97bd,0x8f4e, 0x97be,0x25a1, 
0x97c0,0x25a1, 0x97c2,0x25a1, 0x97c8,0x25a1, 0x97ca,0x25a1, 0x97d1,0x25a1, 
0x97d2,0x25a1, 0x97da,0x25a1, 0x97db,0x25a1, 0x97e0,0x25a1, 0x97e2,0x25a1, 
0x97e4,0x25a1, 0x97e6,0x97cb, 0x97e7,0x97cc, 0x97e8,0x97cd, 0x97e9,0x97d3, 
0x97ea,0x97d9, 0x97eb,0x97de, 0x97ec,0x97dc, 0x97ee,0x25a1, 0x97ef,0x7c64, 
0x97f2,0x9f4b, 0x97f4,0x25a1, 0x97f5,0x97fb, 0x97f7,0x25a1, 0x97fc,0x25a1, 
0x9809,0x25a1, 0x980b,0x25a1, 0x9814,0x25a1, 0x9815,0x25a1, 0x9819,0x25a1, 
0x981a,0x25a1, 0x981f,0x25a1, 0x9822,0x25a1, 0x9823,0x25a1, 0x9825,0x25a1, 
0x982a,0x25a1, 0x982c,0x25a1, 0x982e,0x25a1, 0x9831,0x25a1, 0x9833,0x25a1, 
0x9834,0x25a1, 0x9836,0x25a1, 0x983a,0x25a1, 0x983c,0x25a1, 0x983d,0x25a1, 
0x983e,0x25a1, 0x983f,0x25a1, 0x9840,0x25a1, 0x9842,0x25a1, 0x9847,0x25a1, 
0x984b,0x816e, 0x9854,0x984f, 0x9855,0x986f, 0x9856,0x25a1, 0x985a,0x25a1, 
0x9861,0x25a1, 0x9866,0x25a1, 0x9868,0x25a1, 0x986c,0x25a1, 0x986d,0x25a1, 
0x986e,0x7762, 0x9875,0x9801, 0x9876,0x9802, 0x9877,0x9803, 0x9878,0x9807, 
0x9879,0x9805, 0x987a,0x9806, 0x987b,0x9808, 0x987c,0x980a, 0x987d,0x9811, 
0x987e,0x9867, 0x987f,0x9813, 0x9880,0x980e, 0x9881,0x9812, 0x9882,0x980c, 
0x9883,0x980f, 0x9884,0x9810, 0x9885,0x9871, 0x9886,0x9818, 0x9887,0x9817, 
0x9888,0x9838, 0x9889,0x9821, 0x988a,0x9830, 0x988b,0x9832, 0x988c,0x981c, 
0x988d,0x6f41, 0x988e,0x71b2, 0x988f,0x9826, 0x9890,0x9824, 0x9891,0x983b, 
0x9892,0x25a1, 0x9893,0x9839, 0x9894,0x9837, 0x9895,0x7a4e, 0x9896,0x7a4e, 
0x9897,0x9846, 0x9898,0x984c, 0x9899,0x9852, 0x989a,0x984e, 0x989b,0x9853, 
0x989c,0x984f, 0x989d,0x984d, 0x989e,0x9873, 0x989f,0x9862, 0x98a0,0x985b, 
0x98a1,0x9859, 0x98a2,0x9865, 0x98a3,0x7e87, 0x98a4,0x986b, 0x98a5,0x9808, 
0x98a6,0x9870, 0x98a7,0x9874, 0x98aa,0x25a1, 0x98ab,0x25a1, 0x98b0,0x65cb, 
0x98b4,0x25a1, 0x98b5,0x25a1, 0x98b7,0x98c6, 0x98b9,0x25a1, 0x98c3,0x25a1, 
0x98c5,0x25a1, 0x98c7,0x25a1, 0x98c8,0x25a1, 0x98ca,0x25a1, 0x98cd,0x25a1, 
0x98ce,0x98a8, 0x98cf,0x98ba, 0x98d0,0x98ad, 0x98d1,0x98ae, 0x98d2,0x98af, 
0x98d3,0x98b6, 0x98d4,0x98b8, 0x98d5,0x98bc, 0x98d6,0x98bb, 0x98d7,0x98c0, 
0x98d8,0x98c4, 0x98d9,0x98c6, 0x98da,0x98c6, 0x98dc,0x25a1, 0x98dd,0x25a1, 
0x98de,0x98db, 0x98e0,0x25a1, 0x98e1,0x25a1, 0x98e4,0x25a1, 0x98e6,0x25a1, 
0x98e8,0x9957, 0x98ec,0x990a, 0x98ee,0x98f2, 0x98f0,0x25a1, 0x98f1,0x9910, 
0x98f3,0x25a1, 0x98f5,0x25a1, 0x98f7,0x25a1, 0x98f8,0x25a1, 0x98fb,0x25a1, 
0x98ff,0x25a1, 0x9901,0x25a1, 0x9904,0x25a1, 0x9906,0x25a1, 0x9907,0x93a9, 
0x990b,0x25a1, 0x990d,0x995c, 0x990e,0x25a1, 0x990f,0x25a1, 0x9919,0x25a1, 
0x991c,0x25a1, 0x991d,0x25a1, 0x9920,0x25a1, 0x9922,0x25a1, 0x9923,0x25a1, 
0x9926,0x25a1, 0x9934,0x25a1, 0x9936,0x25a1, 0x9937,0x25a1, 0x9938,0x25a1, 
0x9939,0x25a1, 0x993b,0x25a1, 0x9940,0x25a1, 0x9942,0x25a1, 0x9944,0x25a1, 
0x9946,0x25a1, 0x994a,0x00f8, 0x994d,0x25a1, 0x994f,0x25a1, 0x995a,0x25a1, 
0x995d,0x25a1, 0x9960,0x25a1, 0x9962,0x25a1, 0x9963,0x98df, 0x9964,0x98e3, 
0x9965,0x98e2, 0x9966,0x98e5, 0x9967,0x9933, 0x9968,0x98e9, 0x9969,0x993c, 
0x996a,0x98ea, 0x996b,0x98eb, 0x996c,0x98ed, 0x996d,0x98ef, 0x996e,0x98f2, 
0x996f,0x991e, 0x9970,0x98fe, 0x9971,0x98fd, 0x9972,0x98fc, 0x9973,0x25a1, 
0x9974,0x98f4, 0x9975,0x990c, 0x9976,0x9952, 0x9977,0x9909, 0x9978,0x25a1, 
0x9979,0x25a1, 0x997a,0x9903, 0x997b,0x25a1, 0x997c,0x9905, 0x997d,0x9911, 
0x997e,0x9916, 0x997f,0x9913, 0x9980,0x9918, 0x9981,0x9912, 0x9982,0x9915, 
0x9983,0x25a1, 0x9984,0x991b, 0x9985,0x9921, 0x9986,0x9928, 0x9987,0x67e5, 
0x9988,0x994b, 0x9989,0x7a39, 0x998a,0x993f, 0x998b,0x995e, 0x998c,0x9941, 
0x998d,0x9943, 0x998e,0x993a, 0x998f,0x993e, 0x9990,0x9948, 0x9991,0x9949, 
0x9992,0x9945, 0x9993,0x00f8, 0x9994,0x994c, 0x9995,0x56ca, 0x999a,0x25a1, 
0x999b,0x25a1, 0x999f,0x25a1, 0x99a0,0x25a1, 0x99a2,0x25a1, 0x99a4,0x25a1, 
0x99a9,0x25a1, 0x99aa,0x25a1, 0x99b6,0x25a1, 0x99b7,0x25a1, 0x99b8,0x25a1, 
0x99bc,0x25a1, 0x99be,0x25a1, 0x99bf,0x25a1, 0x99c0,0x25a1, 0x99c4,0x25a1, 
0x99c5,0x25a1, 0x99c6,0x25a1, 0x99c8,0x25a1, 0x99ca,0x25a1, 0x99da,0x25a1, 
0x99de,0x25a1, 0x99e0,0x25a1, 0x99e1,0x25a1, 0x99e6,0x25a1, 0x99e8,0x25a1, 
0x99eb,0x25a1, 0x99ef,0x25a1, 0x99f2,0x25a1, 0x99f3,0x25a1, 0x99f5,0x25a1, 
0x99f9,0x761b, 0x9a00,0x25a1, 0x9a08,0x25a1, 0x9a0c,0x25a1, 0x9a10,0x25a1, 
0x9a12,0x25a1, 0x9a13,0x25a1, 0x9a17,0x25a1, 0x9a18,0x25a1, 0x9a1f,0x25a1, 
0x9a21,0x25a1, 0x9a26,0x25a1, 0x9a28,0x25a1, 0x9a2f,0x25a1, 0x9a33,0x25a1, 
0x9a3b,0x25a1, 0x9a3c,0x25a1, 0x9a47,0x25a1, 0x9a4b,0x25a1, 0x9a51,0x25a1, 
0x9a58,0x25a1, 0x9a59,0x9821, 0x9a5c,0x25a1, 0x9a5d,0x25a1, 0x9a61,0x25a1, 
0x9a63,0x25a1, 0x9a6c,0x99ac, 0x9a6d,0x99ad, 0x9a6e,0x99b1, 0x9a6f,0x99b4, 
0x9a70,0x99b3, 0x9a71,0x9a45, 0x9a72,0x99b9, 0x9a73,0x99c1, 0x9a74,0x9a62, 
0x9a75,0x99d4, 0x9a76,0x99db, 0x9a77,0x99df, 0x9a78,0x99d9, 0x9a79,0x99d2, 
0x9a7a,0x9a36, 0x9a7b,0x99d0, 0x9a7c,0x99dd, 0x9a7d,0x99d1, 0x9a7e,0x99d5, 
0x9a7f,0x9a5b, 0x9a80,0x99d8, 0x9a81,0x9a4d, 0x9a82,0x7f75, 0x9a83,0x99f0, 
0x9a84,0x9a55, 0x9a85,0x9a4a, 0x9a86,0x99f1, 0x9a87,0x99ed, 0x9a88,0x99e2, 
0x9a89,0x9a6b, 0x9a8a,0x9a6a, 0x9a8b,0x9a01, 0x9a8c,0x9a57, 0x9a8d,0x9a02, 
0x9a8e,0x99f8, 0x9a8f,0x99ff, 0x9a90,0x9a0f, 0x9a91,0x9a0e, 0x9a92,0x9a0d, 
0x9a93,0x9a05, 0x9a94,0x25a1, 0x9a95,0x9a4c, 0x9a96,0x9a42, 0x9a97,0x9a19, 
0x9a98,0x9a2d, 0x9a99,0x9a24, 0x9a9a,0x9a37, 0x9a9b,0x9a16, 0x9a9c,0x9a41, 
0x9a9d,0x9a2e, 0x9a9e,0x9a2b, 0x9a9f,0x9a38, 0x9aa0,0x9a43, 0x9aa1,0x9a3e, 
0x9aa2,0x9a44, 0x9aa3,0x9a4f, 0x9aa4,0x9a5f, 0x9aa5,0x9a65, 0x9aa6,0x9a66, 
0x9aa7,0x9a64, 0x9aa9,0x25a1, 0x9aaa,0x25a1, 0x9aac,0x25a1, 0x9aae,0x25a1, 
0x9ab2,0x25a1, 0x9ab5,0x25a1, 0x9ab6,0x80dd, 0x9aba,0x2ed7, 0x9abd,0x25a1, 
0x9ac3,0x25a1, 0x9ac4,0x25a1, 0x9ac5,0x9acf, 0x9ac8,0x25a1, 0x9ac9,0x25a1, 
0x9acb,0x9ad6, 0x9acc,0x9ad5, 0x9ace,0x25a1, 0x9ad7,0x25a1, 0x9ad9,0x25a1, 
0x9ada,0x25a1, 0x9adb,0x25a1, 0x9add,0x25a1, 0x9ade,0x25a1, 0x9ae0,0x25a1, 
0x9ae2,0x25a1, 0x9ae4,0x25a1, 0x9ae5,0x25a1, 0x9ae8,0x25a1, 0x9ae9,0x25a1, 
0x9aea,0x25a1, 0x9af0,0x25a1, 0x9af4,0x25a1, 0x9af5,0x25a1, 0x9af8,0x25a1, 
0x9aff,0x25a1, 0x9b00,0x25a1, 0x9b02,0x25a1, 0x9b06,0x87c6, 0x9b07,0x25a1, 
0x9b09,0x25a1, 0x9b0f,0x79cb, 0x9b13,0x9b22, 0x9b14,0x25a1, 0x9b1b,0x25a1, 
0x9b1c,0x25a1, 0x9b1d,0x25a1, 0x9b21,0x25a1, 0x9b26,0x25a1, 0x9b2a,0x25a1, 
0x9b2c,0x25a1, 0x9b2d,0x25a1, 0x9b30,0x25a1, 0x9b34,0x25a1, 0x9b36,0x25a1, 
0x9b38,0x25a1, 0x9b39,0x25a1, 0x9b3d,0x25a1, 0x9b40,0x25a1, 0x9b47,0x9b58, 
0x9b49,0x9b4e, 0x9b50,0x25a1, 0x9b53,0x25a1, 0x9b57,0x25a1, 0x9b5c,0x25a1, 
0x9b5d,0x25a1, 0x9b5e,0x25a1, 0x9b62,0x25a1, 0x9b63,0x25a1, 0x9b65,0x25a1, 
0x9b69,0x25a1, 0x9b6a,0x25a1, 0x9b6b,0x25a1, 0x9b6d,0x25a1, 0x9b6e,0x25a1, 
0x9b72,0x25a1, 0x9b73,0x25a1, 0x9b78,0x25a1, 0x9b79,0x25a1, 0x9b7b,0x7c1f, 
0x9b7f,0x25a1, 0x9b81,0x25a1, 0x9b83,0x25a1, 0x9b84,0x25a1, 0x9b89,0x25a1, 
0x9b8a,0x25a1, 0x9b8b,0x25a1, 0x9b8c,0x25a1, 0x9b8d,0x25a1, 0x9b8e,0x25a1, 
0x9b8f,0x25a1, 0x9b94,0x25a1, 0x9b96,0x25a1, 0x9b97,0x25a1, 0x9b98,0x25a1, 
0x9b99,0x25a1, 0x9b9c,0x25a1, 0x9b9d,0x25a1, 0x9b9f,0x25a1, 0x9ba3,0x25a1, 
0x9ba7,0x25a1, 0x9ba9,0x25a1, 0x9bac,0x25a1, 0x9bb0,0x25a1, 0x9bb1,0x25a1, 
0x9bb2,0x25a1, 0x9bb3,0x25a1, 0x9bb4,0x25a1, 0x9bb7,0x25a1, 0x9bba,0x25a1, 
0x9bbb,0x25a1, 0x9bbc,0x25a1, 0x9bbe,0x25a1, 0x9bc2,0x25a1, 0x9bc5,0x25a1, 
0x9bcb,0x25a1, 0x9bcc,0x25a1, 0x9bcd,0x25a1, 0x9bce,0x25a1, 0x9bcf,0x25a1, 
0x9bd0,0x25a1, 0x9bd1,0x25a1, 0x9bd2,0x25a1, 0x9bd8,0x25a1, 0x9bdd,0x25a1, 
0x9bdf,0x25a1, 0x9be3,0x25a1, 0x9be9,0x25a1, 0x9bed,0x25a1, 0x9bee,0x25a1, 
0x9bef,0x25a1, 0x9bf1,0x25a1, 0x9bf2,0x25a1, 0x9bf3,0x25a1, 0x9bf4,0x25a1, 
0x9bf5,0x25a1, 0x9bf6,0x25a1, 0x9bf9,0x25a1, 0x9bfa,0x25a1, 0x9bfb,0x25a1, 
0x9bfc,0x25a1, 0x9bfe,0x25a1, 0x9bff,0x25a1, 0x9c00,0x25a1, 0x9c01,0x25a1, 
0x9c02,0x25a1, 0x9c03,0x25a1, 0x9c04,0x25a1, 0x9c0a,0x25a1, 0x9c0c,0x25a1, 
0x9c0f,0x25a1, 0x9c10,0x25a1, 0x9c11,0x25a1, 0x9c15,0x25a1, 0x9c16,0x25a1, 
0x9c18,0x25a1, 0x9c19,0x25a1, 0x9c1a,0x25a1, 0x9c1b,0x25a1, 0x9c1e,0x25a1, 
0x9c1f,0x25a1, 0x9c20,0x25a1, 0x9c22,0x25a1, 0x9c26,0x25a1, 0x9c27,0x25a1, 
0x9c2a,0x25a1, 0x9c2e,0x25a1, 0x9c2f,0x25a1, 0x9c30,0x25a1, 0x9c35,0x25a1, 
0x9c38,0x25a1, 0x9c3a,0x25a1, 0x9c42,0x25a1, 0x9c43,0x25a1, 0x9c45,0x25a1, 
0x9c47,0x25a1, 0x9c4f,0x25a1, 0x9c51,0x25a1, 0x9c53,0x25a1, 0x9c5a,0x25a1, 
0x9c5b,0x25a1, 0x9c5c,0x25a1, 0x9c5d,0x25a1, 0x9c61,0x25a1, 0x9c64,0x25a1, 
0x9c65,0x25a1, 0x9c69,0x25a1, 0x9c6a,0x25a1, 0x9c6b,0x25a1, 0x9c6c,0x25a1, 
0x9c6f,0x25a1, 0x9c70,0x25a1, 0x9c72,0x25a1, 0x9c76,0x25a1, 0x9c7b,0x25a1, 
0x9c7c,0x9b5a, 0x9c7d,0x9b5b, 0x9c7e,0x25a1, 0x9c7f,0x9b77, 0x9c80,0x9b68, 
0x9c81,0x9b6f, 0x9c82,0x9b74, 0x9c83,0x25a1, 0x9c84,0x9b7a, 0x9c85,0x9c4d, 
0x9c86,0x5e73, 0x9c87,0x5360, 0x9c88,0x9c78, 0x9c89,0x25a1, 0x9c8a,0x9b93, 
0x9c8b,0x9b92, 0x9c8c,0x25a1, 0x9c8d,0x9b91, 0x9c8e,0x9c5f, 0x9c8f,0x25a1, 
0x9c90,0x9b90, 0x9c91,0x9bad, 0x9c92,0x9b9a, 0x9c93,0x25a1, 0x9c94,0x9baa, 
0x9c95,0x9b9e, 0x9c96,0x9ba6, 0x9c97,0x25a1, 0x9c98,0x25a1, 0x9c99,0x9c60, 
0x9c9a,0x9c6d, 0x9c9b,0x9bab, 0x9c9c,0x9bae, 0x9c9d,0x25a1, 0x9c9e,0x9bd7, 
0x9c9f,0x9c58, 0x9ca0,0x9bc1, 0x9ca1,0x9c7a, 0x9ca2,0x9c31, 0x9ca3,0x9c39, 
0x9ca4,0x9bc9, 0x9ca5,0x9c23, 0x9ca6,0x9c37, 0x9ca7,0x9bc0, 0x9ca8,0x9bca, 
0x9ca9,0x9bc7, 0x9caa,0x9bb6, 0x9cab,0x9bfd, 0x9cac,0x25a1, 0x9cad,0x9bd6, 
0x9cae,0x9bea, 0x9caf,0x9bd5, 0x9cb0,0x9beb, 0x9cb1,0x9be1, 0x9cb2,0x9be4, 
0x9cb3,0x9be7, 0x9cb4,0x56fa, 0x9cb5,0x9be2, 0x9cb6,0x9bf0, 0x9cb7,0x9bdb, 
0x9cb8,0x9be8, 0x9cb9,0x25a1, 0x9cba,0x8671, 0x9cbb,0x9bd4, 0x9cbc,0x8cc1, 
0x9cbd,0x9c08, 0x9cbe,0x25a1, 0x9cbf,0x9c68, 0x9cc0,0x9bf7, 0x9cc1,0x25a1, 
0x9cc2,0x25a1, 0x9cc3,0x9c13, 0x9cc4,0x9c77, 0x9cc5,0x9c0d, 0x9cc6,0x9c12, 
0x9cc7,0x9c09, 0x9cc8,0x25a1, 0x9cc9,0x25a1, 0x9cca,0x6241, 0x9ccb,0x86a4, 
0x9ccc,0x9c32, 0x9ccd,0x9c2d, 0x9cce,0x9c28, 0x9ccf,0x9c25, 0x9cd0,0x9c29, 
0x9cd1,0x25a1, 0x9cd2,0x9c1c, 0x9cd3,0x9c33, 0x9cd4,0x9c3e, 0x9cd5,0x9c48, 
0x9cd6,0x9c49, 0x9cd7,0x9c3b, 0x9cd8,0x9c49, 0x9cd9,0x5eb8, 0x9cda,0x25a1, 
0x9cdb,0x9c3c, 0x9cdc,0x9c56, 0x9cdd,0x9c54, 0x9cde,0x9c57, 0x9cdf,0x9c52, 
0x9ce0,0x25a1, 0x9ce1,0x9c32, 0x9ce2,0x9c67, 0x9ce3,0x9c63, 0x9ce4,0x25a1, 
0x9ce8,0x25a1, 0x9ceb,0x25a1, 0x9cec,0x25a1, 0x9cee,0x25a1, 0x9cef,0x25a1, 
0x9cf0,0x25a1, 0x9cf8,0x25a1, 0x9cfe,0x25a1, 0x9d01,0x25a1, 0x9d02,0x25a1, 
0x9d0a,0x25a1, 0x9d0b,0x25a1, 0x9d0c,0x25a1, 0x9d0d,0x25a1, 0x9d0e,0x25a1, 
0x9d0f,0x25a1, 0x9d11,0x25a1, 0x9d13,0x25a1, 0x9d16,0x25a1, 0x9d1a,0x25a1, 
0x9d1c,0x25a1, 0x9d21,0x25a1, 0x9d24,0x25a1, 0x9d27,0x25a1, 0x9d2a,0x25a1, 
0x9d2b,0x25a1, 0x9d2c,0x25a1, 0x9d32,0x25a1, 0x9d34,0x25a1, 0x9d35,0x25a1, 
0x9d39,0x25a1, 0x9d3a,0x25a1, 0x9d3c,0x25a1, 0x9d44,0x25a1, 0x9d46,0x25a1, 
0x9d47,0x25a1, 0x9d48,0x25a1, 0x9d49,0x25a1, 0x9d4d,0x25a1, 0x9d4e,0x25a1, 
0x9d50,0x25a1, 0x9d55,0x25a1, 0x9d5e,0x25a1, 0x9d62,0x25a1, 0x9d63,0x25a1, 
0x9d64,0x25a1, 0x9d65,0x25a1, 0x9d66,0x25a1, 0x9d6d,0x25a1, 0x9d6e,0x25a1, 
0x9d76,0x25a1, 0x9d7a,0x25a1, 0x9d7c,0x25a1, 0x9d7e,0x25a1, 0x9d83,0x25a1, 
0x9d8d,0x25a1, 0x9d8e,0x25a1, 0x9d8f,0x25a1, 0x9d91,0x25a1, 0x9d93,0x25a1, 
0x9d95,0x25a1, 0x9da5,0x25a1, 0x9dab,0x25a1, 0x9dae,0x25a1, 0x9db0,0x25a1, 
0x9dbd,0x25a1, 0x9dc0,0x25a1, 0x9dc4,0x25a1, 0x9dc6,0x25a1, 0x9dc9,0x25a1, 
0x9dd4,0x25a1, 0x9de0,0x25a1, 0x9de7,0x25a1, 0x9dea,0x25a1, 0x9df1,0x25a1, 
0x9dfc,0x25a1, 0x9e08,0x25a1, 0x9e0a,0x25a1, 0x9e0c,0x25a1, 0x9e0e,0x25a1, 
0x9e16,0x25a1, 0x9e18,0x25a1, 0x9e1c,0x25a1, 0x9e1f,0x9ce5, 0x9e20,0x9ce9, 
0x9e21,0x96de, 0x9e22,0x9cf6, 0x9e23,0x9cf4, 0x9e24,0x9cf2, 0x9e25,0x9dd7, 
0x9e26,0x9d09, 0x9e27,0x9dac, 0x9e28,0x9d07, 0x9e29,0x9d06, 0x9e2a,0x9d23, 
0x9e2b,0x9d87, 0x9e2c,0x9e15, 0x9e2d,0x9d28, 0x9e2e,0x9d1e, 0x9e2f,0x9d26, 
0x9e30,0x9d12, 0x9e31,0x9d1f, 0x9e32,0x9d1d, 0x9e33,0x9d1b, 0x9e34,0x25a1, 
0x9e35,0x9d15, 0x9e36,0x9de5, 0x9e37,0x9dd9, 0x9e38,0x9d2f, 0x9e39,0x9d30, 
0x9e3a,0x9d42, 0x9e3b,0x25a1, 0x9e3c,0x9d43, 0x9e3d,0x9d3f, 0x9e3e,0x9e1e, 
0x9e3f,0x9d3b, 0x9e40,0x25a1, 0x9e41,0x9d53, 0x9e42,0x9e1d, 0x9e43,0x9d51, 
0x9e44,0x9d60, 0x9e45,0x9d5d, 0x9e46,0x9d52, 0x9e47,0x9df3, 0x9e48,0x9d5c, 
0x9e49,0x9d61, 0x9e4a,0x9d72, 0x9e4b,0x82d7, 0x9e4c,0x9d6a, 0x9e4d,0x25a1, 
0x9e4e,0x9d6f, 0x9e4f,0x9d6c, 0x9e50,0x25a1, 0x9e51,0x9d89, 0x9e52,0x9d8a, 
0x9e53,0x9d77, 0x9e54,0x9deb, 0x9e55,0x9d98, 0x9e56,0x9da1, 0x9e57,0x9d9a, 
0x9e58,0x9dbb, 0x9e59,0x9d96, 0x9e5a,0x9dbf, 0x9e5b,0x7709, 0x9e5c,0x9da9, 
0x9e5d,0x9dca, 0x9e5e,0x9dc2, 0x9e5f,0x9db2, 0x9e60,0x9db9, 0x9e61,0x9dba, 
0x9e62,0x9dc1, 0x9e63,0x9dbc, 0x9e64,0x9db4, 0x9e65,0x9dd6, 0x9e66,0x9e1a, 
0x9e67,0x9dd3, 0x9e68,0x9dda, 0x9e69,0x9def, 0x9e6a,0x9de6, 0x9e6b,0x9df2, 
0x9e6c,0x9df8, 0x9e6d,0x9dfa, 0x9e6e,0x25a1, 0x9e6f,0x9e07, 0x9e70,0x9df9, 
0x9e71,0x7372, 0x9e72,0x9e0f, 0x9e73,0x9e1b, 0x9e74,0x25a1, 0x9e76,0x25a1, 
0x9e77,0x25a1, 0x9e78,0x25a1, 0x9e7b,0x25a1, 0x9e7e,0x9e7a, 0x9e81,0x25a1, 
0x9e84,0x25a1, 0x9e85,0x25a1, 0x9e8f,0x25a1, 0x9e90,0x25a1, 0x9e95,0x25a1, 
0x9e96,0x25a1, 0x9e98,0x25a1, 0x9e9e,0x25a1, 0x9ea2,0x25a1, 0x9ea3,0x25a1, 
0x9ea6,0x9ea5, 0x9ea8,0x25a1, 0x9eaa,0x25a1, 0x9eab,0x25a1, 0x9eac,0x25a1, 
0x9eaf,0x25a1, 0x9eb1,0x25a1, 0x9eb2,0x25a1, 0x9eb3,0x25a1, 0x9eb8,0x9ea9, 
0x9eb9,0x9eb4, 0x9eba,0x9eb5, 0x9ebd,0x9ebc, 0x9ebf,0x25a1, 0x9ec1,0x25a1, 
0x9ec4,0x9ec3, 0x9ec5,0x25a1, 0x9ec6,0x25a1, 0x9ec7,0x25a1, 0x9ec9,0x9ecc, 
0x9eca,0x25a1, 0x9ecb,0x25a1, 0x9ed2,0x9ed1, 0x9ed7,0x25a1, 0x9ed9,0x9ed8, 
0x9ee1,0x9ef6, 0x9ee2,0x68ad, 0x9ee3,0x25a1, 0x9ee9,0x9ef7, 0x9eea,0x9ef2, 
0x9eec,0x25a1, 0x9ef1,0x25a1, 0x9ef8,0x25a1, 0x9efe,0x9efd, 0x9f02,0x25a1, 
0x9f03,0x25a1, 0x9f04,0x25a1, 0x9f05,0x25a1, 0x9f08,0x25a1, 0x9f0b,0x9eff, 
0x9f0c,0x25a1, 0x9f0d,0x9f09, 0x9f11,0x25a1, 0x9f14,0x25a1, 0x9f17,0x9780, 
0x9f1d,0x25a1, 0x9f1f,0x25a1, 0x9f21,0x25a1, 0x9f26,0x25a1, 0x9f27,0x25a1, 
0x9f39,0x9f34, 0x9f3a,0x25a1, 0x9f3c,0x25a1, 0x9f3f,0x25a1, 0x9f44,0x76bb, 
0x9f45,0x25a1, 0x9f50,0x9f4a, 0x9f51,0x9f4f, 0x9f53,0x25a1, 0x9f5a,0x25a1, 
0x9f62,0x25a1, 0x9f68,0x25a1, 0x9f69,0x25a1, 0x9f6d,0x25a1, 0x9f73,0x25a1, 
0x9f7c,0x25a1, 0x9f7d,0x25a1, 0x9f7f,0x9f52, 0x9f80,0x9f54, 0x9f81,0x9f55, 
0x9f82,0x9f57, 0x9f83,0x9f5f, 0x9f84,0x9f61, 0x9f85,0x9f59, 0x9f86,0x9f60, 
0x9f87,0x9f5c, 0x9f88,0x9f66, 0x9f89,0x9f6c, 0x9f8a,0x9f6a, 0x9f8b,0x9f72, 
0x9f8c,0x9f77, 0x9f8e,0x25a1, 0x9f8f,0x25a1, 0x9f93,0x25a1, 0x9f96,0x25a1, 
0x9f97,0x25a1, 0x9f99,0x9f8d, 0x9f9a,0x9f94, 0x9f9b,0x9f95, 0x9f9d,0x25a1, 
0x9f9e,0x25a1, 0x9f9f,0x9f9c, 0x9fa1,0x25a1, 0x9fa3,0x25a1, 0x9fa5,0x25a1, 
0xf92c,0x25a1, 0xf979,0x25a1, 0xf995,0x25a1, 0xf9e7,0x25a1, 0xf9f1,0x25a1, 
0xfa0e,0x25a1, 0xfa0f,0x25a1, 0xfa11,0x25a1, 0xfa13,0x25a1, 0xfa14,0x25a1, 
0xfa18,0x25a1, 0xfa1f,0x25a1, 0xfa20,0x25a1, 0xfa21,0x25a1, 0xfa23,0x25a1, 
0xfa24,0x25a1, 0xfa27,0x25a1, 0xfa28,0x25a1, 0xfa29,0x25a1, 0xff02,0x301e, 
0xff07,0x2032, 0xff3b,0xfe5d, 0xff3d,0xfe5e, 0xff3e,0xfe3f, 0xff3f,0x2574, 
0xff40,0x2035, 0xffe2,0x25a1, 0xffe3,0x00af, 0xffe4,0x25a1
};
