// ATSComponent.r: Apple Text Service Component resource file
//
// Copyright (c) 2004-2006 The OpenVanilla Project (http://openvanilla.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of OpenVanilla nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

#define UseExtendedThingResource 1
#include <Carbon/Carbon.r>
#include "ATSComponent.h"

#ifndef ATSC_OSX_10_3_9
	resource 'thng' (ATSCBASERESOURCEID, "OpenVanilla")
	{
		'tsvc',                     // Type
		'inpm',                     // Subtype
		ATSCVENDORCODE,             // Manufacturer
		0x00000000,                 // use componentHasMultiplePlatorms
		0x00000000,
		0x00000000,
		0x00000000,
		'STR ',                     // Name Type
		ATSCBASERESOURCEID,         // Name ID
		'STR ',                     // Info ID
		ATSCBASERESOURCEID+1,       // Info ID
		'ICON',                     // Icon Type
		ATSCBASERESOURCEID,         // Icon ID
		0x00040000,                 // Version
		// componentHasMultiplePlatforms+myComponentRegistrationFlags,        
		0x00000008,                 
		ATSCBASERESOURCEID,         // Resource ID
		{
	#if TARGET_REZ_MAC_PPC
			ATSCCOMPONENTFLAGS,      // kMyComponentFlags
			'dlle',
			ATSCBASERESOURCEID,      // Resource ID
			// PowerPC-based Macintosh
			platformPowerPCNativeEntryPoint,  
	#endif
	#if TARGET_REZ_MAC_X86
			ATSCCOMPONENTFLAGS,      // kMyComponentFlags
			'dlle',
			ATSCBASERESOURCEID,      // Resource ID
			// Intel-based Macintosh        
			platformIA32NativeEntryPoint,     
	#endif
		};
	};
#endif

#ifdef ATSC_OSX_10_3_9
	resource 'thng' (128)
	{
		'tsvc',
		'inpm',
		ATSCVENDORCODE,
		0x8000+ATSCSCRIPT*0x100+ATSCLANGUAGE,
		kAnyComponentFlagsMask,
		'dlle', ATSCBASERESOURCEID,
		'STR ', ATSCBASERESOURCEID,
		'STR ', ATSCBASERESOURCEID,
		'ICON', ATSCBASERESOURCEID,
		0x00010000,
		componentHasMultiplePlatforms,
		ATSCBASERESOURCEID,
		{
			0x8000+ATSCSCRIPT*0x100+ATSCLANGUAGE,
			'dlle', ATSCBASERESOURCEID, 1000
		}
	};
#endif

/* component entry point */
resource 'dlle' (ATSCBASERESOURCEID)
{
	"ATSCDispatch"
};

#ifndef ATSC_OSX_10_3_9
	/* carbon bundle data */
	data 'cbnm' (0, "OpenVanilla", sysheap, purgeable) {
		ATSCBNLENGTH ATSCBUNDLENAME
	};

	/* default text service component name */
	data 'STR ' (ATSCBASERESOURCEID) {
		ATSCIMNLENGTH ATSCIMNAME
	};
#endif

#ifdef ATSC_OSX_10_3_9
	data 'cbnm' (0, "Component Bundle Name") {
		ATSCBNLENGTH ATSCBUNDLENAME
	};

	data 'STR ' (ATSCBASERESOURCEID, "IM Component Name") {
		ATSCIMNLENGTH ATSCIMNAME
	};
#endif

/* menu resource: (empty) */
resource 'MENU' (ATSCBASERESOURCEID + 1)
{
    ATSCBASERESOURCEID,
    textMenuProc,
    allEnabled,
    enabled,
    "00000",
    { }
};



/* keyboard icon resource (1-, 4-, 8-bit): obsolete, but is still required */

data 'kcs#' (ATSCBASERESOURCEID)
{
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

data 'kcs4' (ATSCBASERESOURCEID)
{
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"	
};

data 'kcs8' (ATSCBASERESOURCEID)
{
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF 0000"
	$"0000 FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"	
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"00FF FF00 0000 0000 0000 0000 00FF FF00"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
};

/* the vanilla icon; this is put back for 10.3.9 compatibility */
#ifdef ATSC_OSX_10_3_9
data 'kcns' (ATSCBASERESOURCEID) {
	$"6963 6E73 0000 2FAC 6963 7323 0000 0048"            
	$"CFFF E3FF E7FF F3F7 E35F F32F FC1F F84F"            
	$"E6AF D787 E3C3 F3E1 E3F9 E3FF E7FF EFFF"            
	$"7C00 7E00 3E3C 3EFC 1FFC 1FFC 1FF8 1FF8"            
	$"3FF8 7FFE 7FFF 3EFF 3E7F 3E07 3E00 3C00"            
	$"6963 7334 0000 0088 FFDC DFFF FFFF AFFF"            
	$"FFD0 0DFF FFFF FFFF FFFC 0CFF FFFE EFFF"            
	$"FFFD 00AF FFEB EEFF FFFE 0CEF EBBE AFFF"            
	$"FFFA 0BFD 1CB9 FFFF FFFF BBBC 01CA FFFF"            
	$"FFF9 BD10 C20D FFFF FFFB BBBB B1BC FFFF"            
	$"FFAD 19A9 BCCC 0EFF FFAB 0CFA FBC0 00EF"            
	$"FFFD 00EF FFAC 00CA FFFC 00EF FFFA 9BCB"            
	$"FFF0 0CFF FFFF FFAF FFFC 0EFF FFFF FFFF"            
	$"FFFD BFFF FFFF FFFF 6963 7338 0000 0108"            
	$"FFDF 56F7 FAFF FFFF FFFF FFFE FDFF FFFF"            
	$"FFEA FA00 00FA FFFF FFFF FFE0 FDFF FFFF"            
	$"FFFF FFF6 002B FFFF FFFF FFFD FDE0 FFFF"            
	$"FFFF FFF9 00F5 FDFF FFE0 FC82 82AC FFFF"            
	$"FFFF FFFB 0101 ADFF 8258 5EA6 ADE0 FFFF"            
	$"FFFF EAFE 0857 E0FA 332C 82AD FEFF FFFF"            
	$"FFFF FFFD 5789 5702 0108 2BFD E0FF FFFF"            
	$"FFFF FFFD 5858 2C01 2C35 0257 FFFF FFFF"            
	$"FFFF FF58 3458 835E 2D2D 35F8 E0FF FFFF"            
	$"FFFF 8858 33AD ACAD 822C 5601 F6FC FFFF"            
	$"FFFF AD81 0032 EAE0 ADFB 2CF5 0000 88EA"            
	$"FFFF FFF8 0000 FCFF F4FF AD2B 0000 26FE"            
	$"FFFF FF2B 0000 FCFF FFFF FFDF ACF9 0782"            
	$"FFFF FFF6 002B E0FF FFFF FFEA FFFF FFAD"            
	$"FFFF E02C 00FC FFFF FFFF FFE0 FFFF FFF4"            
	$"FFFF FF57 81FF FFFF FFFF E0EA FFEA FFFF"            
	$"6973 3332 0000 02BE 0500 2195 B881 0682"            
	$"0002 1122 0780 0004 0B7C FFFF 7682 0002"            
	$"0F20 0681 0004 08CD FFCB 0681 0002 1931"            
	$"0B82 000C 8DFF E325 0000 1441 6977 2C01"            
	$"0780 000C 55FF F23C 0051 948E 4F2B 1500"            
	$"0380 0009 29E7 A913 7CD7 C86C 2D1A 8300"            
	$"0816 9A55 93EF F9EF D129 8400 0838 89A6"            
	$"E8F4 E7C9 FF93 8300 0A06 91B9 8F6F 8BC0"            
	$"CFC0 B711 8200 0B5B 9DC3 3826 4C83 C9B4"            
	$"ECD2 4380 000D 0130 82FF B110 0826 69B4"            
	$"FEFF F654 8100 139C FFFD 4100 0007 32D7"            
	$"FFFF E122 0000 03C5 FFFF 4880 000C 0418"            
	$"3E85 DC72 0003 0ED7 FFCF 1180 000B 0306"            
	$"0000 112C 0004 0BCE FF43 8100 0304 0701"            
	$"0682 0001 8C68 8200 0504 0701 0600 0205"            
	$"001D 90B7 7F05 8200 0210 2106 8000 0409"            
	$"79FF FF75 8200 020F 1F05 8100 0408 CCFF"            
	$"CA06 8100 0218 2F0A 8200 0C8C FFE2 2300"            
	$"0012 3D62 7229 0106 8000 0C55 FFE9 3600"            
	$"4A89 8248 2813 0103 8000 0928 DB9B 1173"            
	$"C8BA 622B 1783 0008 148C 4E89 E5EF DED0"            
	$"2884 0008 327E 9ADC F0DA A6F0 9283 000A"            
	$"057B A284 6B7F B5BF A2AC 1182 000B 4987"            
	$"B534 2647 78C0 ACE9 D142 8000 0D01 247B"            
	$"FFAC 0F08 2665 B1FD FFF4 4F81 0013 9CFF"            
	$"FB40 0000 072E D4FF FFDC 1E00 0003 C5FF"            
	$"FF47 8000 0C02 163C 83D7 6A00 030E D7FF"            
	$"CE11 8000 0B02 0500 0010 2A00 0309 CBFF"            
	$"4281 0003 0306 0105 8200 0188 6682 0005"            
	$"0306 0105 0002 0500 0D7D B27E 0582 0002"            
	$"121E 0481 0003 6BFF FF74 8200 0211 1C04"            
	$"8100 0407 CCFF C905 8000 0301 1A2A 0782"            
	$"000C 88FF D81C 0000 0B24 3B4C 1C00 0480"            
	$"000C 4BE0 C220 002B 4E3E 120E 0C01 0280"            
	$"0009 20AB 6403 4582 7927 080C 8300 080E"            
	$"541E 4BAC C59D C522 8400 081B 3B4E 8ACF"            
	$"9B17 827D 8300 0A04 3832 2B28 3371 5618"            
	$"7514 8200 0B19 3E76 0804 0D32 A898 DCCF"            
	$"3D80 000D 0100 5DFF 9509 000C 3F93 F3FF"            
	$"E53B 8100 139A FFEE 3600 0100 13C3 FFFF"            
	$"B210 0000 02C3 FFFE 4280 000C 0110 367C"            
	$"B03F 0000 09CD FFCA 0E81 0004 0100 000A"            
	$"1880 0002 ACFD 3D81 0005 0103 0002 0001"            
	$"8000 0163 5682 0005 0103 0002 0001 7338"            
	$"6D6B 0000 0108 008F E3E2 DA46 0000 0000"            
	$"0000 0000 0000 007B EBFF FFD9 1400 0000"            
	$"0000 0000 0000 0000 4EFF FFFE 4200 0000"            
	$"2051 5A27 0000 0000 10DB FFFF 9200 259F"            
	$"EEFF FFA4 0000 0000 00B2 FFFF C557 E9FF"            
	$"FFFF FF80 0000 0000 0080 FFFF DCEA FFFF"            
	$"FFFF B00D 0000 0000 0060 FFFF FEFF FFFF"            
	$"FFB9 0A00 0000 0000 00A6 FFFF FFFF FFFF"            
	$"FFDB 1200 0000 0000 52FF FFFF FFFF FFFF"            
	$"FFFE 6400 0000 0017 D9FF FFFE FDFF FFFF"            
	$"FFFF FFAB 1C00 0028 E0FD FFFF 9F9F F8FF"            
	$"FFFF FFFF C913 0000 30EC FFFF 8300 3BB8"            
	$"FAFF FFFF FF7B 0000 3FFE FFFF 9A00 0004"            
	$"305B 94D6 FFBE 0000 4DFF FFFF 5B00 0000"            
	$"0000 000A 5C8E 0000 40FE FFAF 0100 0000"            
	$"0000 0000 0000 0000 1EDB BC1D 0000 0000"            
	$"0000 0000 0000 4943 4E23 0000 0108 FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFCF"            
	$"FFFF FFE3 FFFF FFE7 FFFF FFF3 F7FF FFE3"            
	$"5FFF FFF3 2FFF FFFC 1FFF FFF8 4FFF FFE6"            
	$"AFFF FFD7 87FF FFE3 C3FF FFF3 E1FF FFE3"            
	$"F9FF FFE3 FFFF FFE7 FFFF FFEF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 007C"            
	$"0000 007E 0000 003E 3C00 003E FC00 001F"            
	$"FC00 001F FC00 001F F800 001F F800 003F"            
	$"F800 007F FE00 007F FF00 003E FF00 003E"            
	$"7F00 003E 0700 003E 0000 003C 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 6963"            
	$"6C34 0000 0208 FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFDC DFFF FFFF"            
	$"AFFF FFFF FFFF FFFF FFFF FFD0 0DFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFC 0CFF FFFE"            
	$"EFFF FFFF FFFF FFFF FFFF FFFD 00AF FFEB"            
	$"EEFF FFFF FFFF FFFF FFFF FFFE 0CEF EBBE"            
	$"AFFF FFFF FFFF FFFF FFFF FFFA 0BFD 1CB9"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF BBBC 01CA"            
	$"FFFF FFFF FFFF FFFF FFFF FFFE BD10 C20D"            
	$"FFFF FFFF FFFF FFFF FFFF FFFB BBBB B1BC"            
	$"FFFF FFFF FFFF FFFF FFFF FFAD 19A9 BCCC"            
	$"0EFF FFFF FFFF FFFF FFFF FFAB 0CFF 9BC0"            
	$"00EF FFFF FFFF FFFF FFFF FFFD 00EF FFAC"            
	$"00CA FFFF FFFF FFFF FFFF FFFC 00EF FFFA"            
	$"9BCB FFFF FFFF FFFF FFFF FFF0 0CFF FFFF"            
	$"FFF9 FFFF FFFF FFFF FFFF FFFC 0EFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFD BFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF 6963 6C38 0000 0408 FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFDF 56F7 FAFF FFFF FFFF"            
	$"FFFE FDFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFEA FA00 00FA FFFF FFFF"            
	$"FFE0 FDFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFF6 002B FFFF FFFF"            
	$"FFFD FDE0 FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFF9 00F5 FDFF FFE0"            
	$"FC82 82AC FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFB 0101 ADFF 8258"            
	$"5EA6 ADE0 FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF EAFE 0857 DF81 2D2C"            
	$"82AD FEFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFD 5789 5702 0708"            
	$"2BAD F4FF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFAD 5E58 2607 2635"            
	$"02F9 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FF58 5858 825E 2D2D"            
	$"3533 F3EA FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF 825E 2CAD AD89 822C"            
	$"F8F5 25FC FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF DF57 0056 E0EA AD82"            
	$"32F5 0000 88FF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FF56 0000 FCFF F4FF"            
	$"ADF6 0000 26FD FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FF2B 0000 FCFF FFFF"            
	$"FFE0 ACF9 0782 FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFF6 002B E0FF FFFF"            
	$"FFEA FFFF FFAD FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF E02C 00FC FFFF FFFF"            
	$"FFE0 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FF57 81FF FFFF FFFF"            
	$"FFFF FFEA FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 696C"            
	$"3332 0000 02EB FF00 FF00 8200 0421 95B8"            
	$"8106 8200 0211 2207 9000 040B 7CFF FF76"            
	$"8200 020F 2006 9100 0408 CDFF CB06 8100"            
	$"0219 310B 9200 0C8D FFE3 2500 0014 4169"            
	$"772C 0107 9000 0C55 FFF2 3C00 5194 8E4F"            
	$"2B15 0003 9000 0929 E7A9 137C D7C8 6C2D"            
	$"1A93 0008 169A 5593 EFF9 EFD1 2994 0008"            
	$"3889 A6E8 F4E7 C9FF 9393 000A 0691 B98F"            
	$"6F8B C0CF C0B7 1192 000B 5B9D C338 264C"            
	$"83C9 B4EC D243 9000 0D01 3082 FFB1 1008"            
	$"2669 B4FE FFF6 5491 000C 9CFF FD41 0000"            
	$"0732 D7FF FFE1 228F 0004 03C5 FFFF 4880"            
	$"0005 0418 3E85 DC72 8E00 0503 0ED7 FFCF"            
	$"1180 0005 0306 0000 112C 8E00 0404 0BCE"            
	$"FF43 8100 0304 0701 0692 0001 8C68 8200"            
	$"0504 0701 0600 02FF 00FF 0081 00FF 00FF"            
	$"0082 0004 1D90 B77F 0582 0002 1021 0690"            
	$"0004 0979 FFFF 7582 0002 0F1F 0591 0004"            
	$"08CC FFCA 0681 0002 182F 0A92 000C 8CFF"            
	$"E223 0000 123D 6272 2901 0690 000C 55FF"            
	$"E936 004A 8982 4828 1301 0390 0009 28DB"            
	$"9B11 73C8 BA62 2B17 9300 0814 8C4E 89E5"            
	$"EFDE D028 9400 0832 7E9A DCF0 DAA6 F092"            
	$"9300 0A05 7BA2 846B 7FB5 BFA2 AC11 9200"            
	$"0B49 87B5 3426 4778 C0AC E9D1 4290 000D"            
	$"0124 7BFF AC0F 0826 65B1 FDFF F44F 9100"            
	$"0C9C FFFB 4000 0007 2ED4 FFFF DC1E 8F00"            
	$"0403 C5FF FF47 8000 0502 163C 83D7 6A8E"            
	$"0005 030E D7FF CE11 8000 0502 0500 0010"            
	$"2A8E 0004 0309 CBFF 4281 0003 0306 0105"            
	$"9200 0188 6682 0005 0306 0105 0002 FF00"            
	$"FF00 8100 FF00 FF00 8200 040D 7DB2 7E05"            
	$"8200 0212 1E04 9100 036B FFFF 7482 0002"            
	$"111C 0491 0004 07CC FFC9 0580 0003 011A"            
	$"2A07 9200 0C88 FFD8 1C00 000B 243B 4C1C"            
	$"0004 9000 0C4B E0C2 2000 2B4E 3E12 0E0C"            
	$"0102 9000 0920 AB64 0345 8279 2708 0C93"            
	$"0008 0E54 1E4B ACC5 9DC5 2294 0008 1B3B"            
	$"4E8A CF9B 1782 7D93 000A 0438 322B 2833"            
	$"7156 1875 1492 000B 193E 7608 040D 32A8"            
	$"98DC CF3D 9000 0D01 005D FF95 0900 0C3F"            
	$"93F3 FFE5 3B91 000C 9AFF EE36 0001 0013"            
	$"C3FF FFB2 108F 0004 02C3 FFFE 4280 0005"            
	$"0110 367C B03F 8F00 0409 CDFF CA0E 8100"            
	$"0401 0000 0A18 9000 02AC FD3D 8100 0501"            
	$"0300 0200 0190 0001 6356 8200 0501 0300"            
	$"0200 01FF 00FF 0081 006C 386D 6B00 0004"            
	$"0800 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 8FE3 E2DA 4600"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 7BEB FFFF D914"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 004E FFFF FE42"            
	$"0000 0020 515A 2700 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0010 DBFF FF92"            
	$"0025 9FEE FFFF A400 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 B2FF FFC5"            
	$"57E9 FFFF FFFF 8000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 80FF FFDC"            
	$"EAFF FFFF FFB0 0D00 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 60FF FFFE"            
	$"FFFF FFFF B90A 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 A6FF FFFF"            
	$"FFFF FFFF DB12 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0052 FFFF FFFF"            
	$"FFFF FFFF FE64 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 17D9 FFFF FEFD"            
	$"FFFF FFFF FFFF AB1C 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 28E0 FDFF FF9F"            
	$"9FF8 FFFF FFFF FFC9 1300 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0030 ECFF FF83"            
	$"003B B8FA FFFF FFFF 7B00 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 003F FEFF FF9A"            
	$"0000 0430 5B94 D6FF BE00 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 004D FFFF FF5B"            
	$"0000 0000 0000 0A5C 8E00 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0040 FEFF AF01"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 001E DBBC 1D00"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0069 6368 2300 0002 48FF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFCF FFFF FFFF"            
	$"FFE3 FFFF FFFF FFE7 FFFF FFFF FFF3 F7FF"            
	$"FFFF FFE3 5FFF FFFF FFF3 2FFF FFFF FFFC"            
	$"1FFF FFFF FFF8 4FFF FFFF FFE6 AFFF FFFF"            
	$"FFD7 87FF FFFF FFE3 C3FF FFFF FFF3 E1FF"            
	$"FFFF FFE3 F9FF FFFF FFE3 FFFF FFFF FFE7"            
	$"FFFF FFFF FFEF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 007C 0000 0000"            
	$"007E 0000 0000 003E 3C00 0000 003E FC00"            
	$"0000 001F FC00 0000 001F FC00 0000 001F"            
	$"F800 0000 001F F800 0000 003F F800 0000"            
	$"007F FE00 0000 007F FF00 0000 003E FF00"            
	$"0000 003E 7F00 0000 003E 0700 0000 003E"            
	$"0000 0000 003C 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0069 6368 3400 0004"            
	$"88FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF DCDF FFFF FFAF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF D00D FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FC0C FFFF FEEF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FD00 AFFF EBEE FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FE0C EFEB BEAF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FA0B FD1C B9FF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFBB BC01 CAFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FEBD 10C2 0DFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FBBB BBB1 BCFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF AD19 A9BC CC0E FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF AB0C FF9B C000"            
	$"EFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FD00 EFFF AC00 CAFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FC00 EFFF FA9B"            
	$"CBFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF F00C FFFF FFFF F9FF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FC0E FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FDBF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FF69 6368 3800 0009 08FF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF DF56 F7FA FFFF"            
	$"FFFF FFFF FEFD FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF EAFA 0000 FAFF"            
	$"FFFF FFFF E0FD FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF F600 2BFF"            
	$"FFFF FFFF FDFD E0FF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF F900 F5FD"            
	$"FFFF E0FC 8282 ACFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FB01 01AD"            
	$"FF82 585E A6AD E0FF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFEA FE08 57DF"            
	$"812D 2C82 ADFE FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FD57 8957"            
	$"0207 082B ADF4 FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF AD5E 5826"            
	$"0726 3502 F9FF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF 5858 5882"            
	$"5E2D 2D35 33F3 EAFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FF82 5E2C ADAD"            
	$"8982 2CF8 F525 FCFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFDF 5700 56E0"            
	$"EAAD 8232 F500 0088 FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF 5600 00FC"            
	$"FFF4 FFAD F600 0026 FDFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF 2B00 00FC"            
	$"FFFF FFFF E0AC F907 82FF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF F600 2BE0"            
	$"FFFF FFFF EAFF FFFF ADFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFE0 2C00 FCFF"            
	$"FFFF FFFF E0FF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF 5781 FFFF"            
	$"FFFF FFFF FFFF EAFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            
	$"FFFF FFFF FFFF FFFF FF69 6833 3200 0003"            
	$"1BFF 00FF 00FF 00FF 00FF 00FF 0082 0004"            
	$"2195 B881 0682 0002 1122 07A0 0004 0B7C"            
	$"FFFF 7682 0002 0F20 06A1 0004 08CD FFCB"            
	$"0681 0002 1931 0BA2 000C 8DFF E325 0000"            
	$"1441 6977 2C01 07A0 000C 55FF F23C 0051"            
	$"948E 4F2B 1500 03A0 0009 29E7 A913 7CD7"            
	$"C86C 2D1A A300 0816 9A55 93EF F9EF D129"            
	$"A400 0838 89A6 E8F4 E7C9 FF93 A300 0A06"            
	$"91B9 8F6F 8BC0 CFC0 B711 A200 0B5B 9DC3"            
	$"3826 4C83 C9B4 ECD2 43A0 000D 0130 82FF"            
	$"B110 0826 69B4 FEFF F654 A100 0C9C FFFD"            
	$"4100 0007 32D7 FFFF E122 9F00 0403 C5FF"            
	$"FF48 8000 0504 183E 85DC 729E 0005 030E"            
	$"D7FF CF11 8000 0503 0600 0011 2C9E 0004"            
	$"040B CEFF 4381 0003 0407 0106 A200 018C"            
	$"6882 0005 0407 0106 0002 FF00 FF00 FF00"            
	$"FF00 FF00 FF00 8100 FF00 FF00 FF00 FF00"            
	$"FF00 FF00 8200 041D 90B7 7F05 8200 0210"            
	$"2106 A000 0409 79FF FF75 8200 020F 1F05"            
	$"A100 0408 CCFF CA06 8100 0218 2F0A A200"            
	$"0C8C FFE2 2300 0012 3D62 7229 0106 A000"            
	$"0C55 FFE9 3600 4A89 8248 2813 0103 A000"            
	$"0928 DB9B 1173 C8BA 622B 17A3 0008 148C"            
	$"4E89 E5EF DED0 28A4 0008 327E 9ADC F0DA"            
	$"A6F0 92A3 000A 057B A284 6B7F B5BF A2AC"            
	$"11A2 000B 4987 B534 2647 78C0 ACE9 D142"            
	$"A000 0D01 247B FFAC 0F08 2665 B1FD FFF4"            
	$"4FA1 000C 9CFF FB40 0000 072E D4FF FFDC"            
	$"1E9F 0004 03C5 FFFF 4780 0005 0216 3C83"            
	$"D76A 9E00 0503 0ED7 FFCE 1180 0005 0205"            
	$"0000 102A 9E00 0403 09CB FF42 8100 0303"            
	$"0601 05A2 0001 8866 8200 0503 0601 0500"            
	$"02FF 00FF 00FF 00FF 00FF 00FF 0081 00FF"            
	$"00FF 00FF 00FF 00FF 00FF 0082 0004 0D7D"            
	$"B27E 0582 0002 121E 04A1 0003 6BFF FF74"            
	$"8200 0211 1C04 A100 0407 CCFF C905 8000"            
	$"0301 1A2A 07A2 000C 88FF D81C 0000 0B24"            
	$"3B4C 1C00 04A0 000C 4BE0 C220 002B 4E3E"            
	$"120E 0C01 02A0 0009 20AB 6403 4582 7927"            
	$"080C A300 080E 541E 4BAC C59D C522 A400"            
	$"081B 3B4E 8ACF 9B17 827D A300 0A04 3832"            
	$"2B28 3371 5618 7514 A200 0B19 3E76 0804"            
	$"0D32 A898 DCCF 3DA0 000D 0100 5DFF 9509"            
	$"000C 3F93 F3FF E53B A100 0C9A FFEE 3600"            
	$"0100 13C3 FFFF B210 9F00 0402 C3FF FE42"            
	$"8000 0501 1036 7CB0 3F9F 0004 09CD FFCA"            
	$"0E81 0004 0100 000A 18A0 0002 ACFD 3D81"            
	$"0005 0103 0002 0001 A000 0163 5682 0005"            
	$"0103 0002 0001 FF00 FF00 FF00 FF00 FF00"            
	$"FF00 8100 6838 6D6B 0000 0908 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 008F E3E2"            
	$"DA46 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 007B EBFF"            
	$"FFD9 1400 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 4EFF"            
	$"FFFE 4200 0000 2051 5A27 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 10DB"            
	$"FFFF 9200 259F EEFF FFA4 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 00B2"            
	$"FFFF C557 E9FF FFFF FF80 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0080"            
	$"FFFF DCEA FFFF FFFF B00D 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0060"            
	$"FFFF FEFF FFFF FFB9 0A00 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 00A6"            
	$"FFFF FFFF FFFF FFDB 1200 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 52FF"            
	$"FFFF FFFF FFFF FFFE 6400 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0017 D9FF"            
	$"FFFE FDFF FFFF FFFF FFAB 1C00 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0028 E0FD"            
	$"FFFF 9F9F F8FF FFFF FFFF C913 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 30EC"            
	$"FFFF 8300 3BB8 FAFF FFFF FF7B 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 3FFE"            
	$"FFFF 9A00 0004 305B 94D6 FFBE 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 4DFF"            
	$"FFFF 5B00 0000 0000 000A 5C8E 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 40FE"            
	$"FFAF 0100 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 1EDB"            
	$"BC1D 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000"                      
};
#endif

