// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.lang.reflect.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ToHostNode.class)
final class ToHostNodeGen extends ToHostNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @CompilationFinal private volatile int state_0_;
    @CompilationFinal private volatile int exclude_;
    @Child private CachedData cached_cache;

    private ToHostNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object execute(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        int state_0 = state_0_;
        if (state_0 != 0 /* is-state_0 doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode, BranchProfile) || doGeneric(Object, Class<>, Type, PolyglotLanguageContext, boolean) */) {
            if ((state_0 & 0b1) != 0 /* is-state_0 doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode, BranchProfile) */) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if ((s1_.interop_.accepts(arg0Value)) && (arg1Value == s1_.cachedTargetType_)) {
                        return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.cachedTargetType_, s1_.primitiveTarget_, s1_.allowsImplementation_, s1_.targetMapping_, s1_.error_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 0b10) != 0 /* is-state_0 doGeneric(Object, Class<>, Type, PolyglotLanguageContext, boolean) */) {
                return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    private Object executeAndSpecialize(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = state_0_;
        int exclude = exclude_;
        try {
            if ((exclude) == 0 /* is-not-exclude doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode, BranchProfile) */) {
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state_0 & 0b1) != 0 /* is-state_0 doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode, BranchProfile) */) {
                    while (s1_ != null) {
                        if ((s1_.interop_.accepts(arg0Value)) && (arg1Value == s1_.cachedTargetType_)) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    // assert (s1_.interop_.accepts(arg0Value));
                    // assert (arg1Value == s1_.cachedTargetType_);
                    if (count1_ < (ToHostNode.LIMIT)) {
                        s1_ = super.insert(new CachedData(cached_cache));
                        s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg0Value)));
                        s1_.cachedTargetType_ = (arg1Value);
                        s1_.primitiveTarget_ = (ToHostNode.isPrimitiveTarget(s1_.cachedTargetType_));
                        s1_.allowsImplementation_ = (ToHostNode.allowsImplementation(arg3Value, arg1Value));
                        s1_.targetMapping_ = s1_.insertAccessor((TargetMappingNode.create()));
                        s1_.error_ = (BranchProfile.create());
                        this.cached_cache = s1_;
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode, BranchProfile) */;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.cachedTargetType_, s1_.primitiveTarget_, s1_.allowsImplementation_, s1_.targetMapping_, s1_.error_);
                }
            }
            this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode, BranchProfile) */;
            this.cached_cache = null;
            state_0 = state_0 & 0xfffffffe /* remove-state_0 doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode, BranchProfile) */;
            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doGeneric(Object, Class<>, Type, PolyglotLanguageContext, boolean) */;
            lock.unlock();
            hasLock = false;
            return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToHostNode create() {
        return new ToHostNodeGen();
    }

    public static ToHostNode getUncached() {
        return ToHostNodeGen.UNCACHED;
    }

    @GeneratedBy(ToHostNode.class)
    private static final class CachedData extends Node {

        @Child CachedData next_;
        @Child InteropLibrary interop_;
        @CompilationFinal Class<?> cachedTargetType_;
        @CompilationFinal boolean primitiveTarget_;
        @CompilationFinal boolean allowsImplementation_;
        @Child TargetMappingNode targetMapping_;
        @CompilationFinal BranchProfile error_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(ToHostNode.class)
    private static final class Uncached extends ToHostNode {

        @TruffleBoundary
        @Override
        public Object execute(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
            return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
