/*
 * Decompiled with CFR 0.152.
 */
package org.nanohttpd.protocols.http.content;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nanohttpd.protocols.http.content.Cookie;
import org.nanohttpd.protocols.http.response.Response;

public class CookieHandler
implements Iterable<String> {
    private final HashMap<String, String> cookies = new HashMap();
    private final ArrayList<Cookie> queue = new ArrayList();

    public CookieHandler(Map<String, String> httpHeaders) {
        String raw = httpHeaders.get("cookie");
        if (raw != null) {
            String[] tokens;
            for (String token : tokens = raw.split(";")) {
                String[] data = token.trim().split("=");
                if (data.length != 2) continue;
                this.cookies.put(data[0], data[1]);
            }
        }
    }

    public void delete(String name) {
        this.set(name, "-delete-", -30);
    }

    @Override
    public Iterator<String> iterator() {
        return this.cookies.keySet().iterator();
    }

    public String read(String name) {
        return this.cookies.get(name);
    }

    public void set(Cookie cookie) {
        this.queue.add(cookie);
    }

    public void set(String name, String value, int expires) {
        this.queue.add(new Cookie(name, value, Cookie.getHTTPTime(expires)));
    }

    public void unloadQueue(Response response) {
        for (Cookie cookie : this.queue) {
            response.addCookieHeader(cookie.getHTTPHeader());
        }
    }
}

