/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.tools.utils.json.JSONObject;

public final class CallArgument {
    private static final String POSITIVE_INFINITY_STR = Double.toString(Double.POSITIVE_INFINITY);
    private static final String NEGATIVE_INFINITY_STR = Double.toString(Double.NEGATIVE_INFINITY);
    private static final String NAN_STR = Double.toString(Double.NaN);
    private static final Double NEGATIVE_ZERO = Double.valueOf("-0");
    private final Object value;
    private final String objectId;
    private final boolean undefined;

    private CallArgument(Object value, String objectId, boolean undefined) {
        this.value = value;
        this.objectId = objectId;
        this.undefined = undefined;
    }

    public static CallArgument get(JSONObject json) {
        Object value = json.opt("unserializableValue");
        if (value != null) {
            if (POSITIVE_INFINITY_STR.equals(value)) {
                value = Double.POSITIVE_INFINITY;
            } else if (NEGATIVE_INFINITY_STR.equals(value)) {
                value = Double.NEGATIVE_INFINITY;
            } else if (NAN_STR.equals(value)) {
                value = Double.NaN;
            } else if ("-0".equals(value) || "-0.0".equals(value)) {
                value = NEGATIVE_ZERO;
            }
        } else {
            value = json.opt("value");
            if (value == JSONObject.NULL) {
                value = null;
            }
        }
        String objectId = json.optString("objectId", null);
        return new CallArgument(value, objectId, json.length() == 0);
    }

    public Object getPrimitiveValue() {
        return this.value;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isUndefined() {
        return this.undefined;
    }
}

