/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.objects;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;

final class TruffleObject2JSON {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();

    private TruffleObject2JSON() {
    }

    static JSONObject fromObject(TruffleObject object) {
        long size;
        Object keys;
        JSONObject json = new JSONObject();
        try {
            keys = INTEROP.getMembers((Object)object);
        }
        catch (UnsupportedMessageException ex) {
            return json;
        }
        try {
            size = INTEROP.getArraySize(keys);
        }
        catch (UnsupportedMessageException ex) {
            return json;
        }
        if (size > 0L) {
            for (long i = 0L; i < size; ++i) {
                try {
                    Object key = INTEROP.readArrayElement(keys, i);
                    Object value = INTEROP.readMember((Object)object, INTEROP.asString(key));
                    json.put(key.toString(), TruffleObject2JSON.from(value));
                    continue;
                }
                catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException throwable) {
                    // empty catch block
                }
            }
        }
        return json;
    }

    static JSONArray fromArray(TruffleObject array) {
        long size;
        JSONArray json = new JSONArray();
        try {
            size = INTEROP.getArraySize((Object)array);
        }
        catch (UnsupportedMessageException ex) {
            return json;
        }
        if (size > 0L) {
            for (long i = 0L; i < size; ++i) {
                try {
                    Object value = INTEROP.readArrayElement((Object)array, i);
                    json.put((int)i, TruffleObject2JSON.from(value));
                    continue;
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException ex) {
                    break;
                }
            }
        }
        return json;
    }

    private static Object from(Object object) {
        if (object instanceof TruffleObject) {
            TruffleObject truffleObject = (TruffleObject)object;
            if (INTEROP.hasArrayElements((Object)truffleObject)) {
                return TruffleObject2JSON.fromArray(truffleObject);
            }
            return TruffleObject2JSON.fromObject(truffleObject);
        }
        return object;
    }
}

