/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.nativemode.runtime;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.nativemode.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;

abstract class WellKnownNFIFunctionNode
extends NativeContextExtension.WellKnownNativeFunctionNode {
    private final NFIContextExtension.WellKnownFunction function;
    private final ContextExtension.Key<NativeContextExtension> ctxExtKey;

    WellKnownNFIFunctionNode(NFIContextExtension.WellKnownFunction function) {
        this.function = function;
        this.ctxExtKey = LLVMLanguage.getLanguage().lookupContextExtension(NativeContextExtension.class);
    }

    Object getFunction(TruffleLanguage.ContextReference<LLVMContext> ctx) {
        NFIContextExtension ctxExt = (NFIContextExtension)this.ctxExtKey.get((LLVMContext)ctx.get());
        return ctxExt.getCachedWellKnownFunction(this.function);
    }

    @Specialization(assumptions={"singleContextAssumption()"})
    Object doCached(Object[] args, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctx, @Cached(value="getFunction(ctx)") Object cachedFunction, @CachedLibrary(value="cachedFunction") InteropLibrary interop) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
        return interop.execute(cachedFunction, args);
    }

    @Specialization(replaces={"doCached"})
    Object doGeneric(Object[] args, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctx, @CachedLibrary(limit="3") InteropLibrary interop) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
        Object fn = this.getFunction(ctx);
        return interop.execute(fn, args);
    }
}

