/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.nativemode;

import com.oracle.truffle.llvm.nativemode.NativeConfiguration;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.ConfigurationFactory;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.util.List;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionValues;

public class NativeConfigurationFactory
implements ConfigurationFactory<Key> {
    public Key parseOptions(OptionValues options) {
        return new Key(options);
    }

    public int getPriority() {
        return 0;
    }

    public List<OptionDescriptor> getOptionDescriptors() {
        return SulongEngineOption.describeOptions();
    }

    public Configuration createConfiguration(LLVMLanguage language, ContextExtension.Registry ctxExtRegistry, Key key) {
        return new NativeConfiguration(language, ctxExtRegistry, key);
    }

    public static final class Key {
        final boolean loadCxxLibraries;
        final boolean enableNFI;

        public Key(OptionValues options) {
            this.loadCxxLibraries = (Boolean)options.get(SulongEngineOption.LOAD_CXX_LIBRARIES);
            this.enableNFI = (Boolean)options.get(SulongEngineOption.ENABLE_NFI);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return this.loadCxxLibraries == other.loadCxxLibraries && this.enableNFI == other.enableNFI;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this.loadCxxLibraries ? 1 : 0);
            hash = 71 * hash + (this.enableNFI ? 1 : 0);
            return hash;
        }
    }
}

