/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.nativemode;

import com.oracle.truffle.llvm.DefaultLoader;
import com.oracle.truffle.llvm.nativemode.NativeConfigurationFactory;
import com.oracle.truffle.llvm.nativemode.NativeToolchainConfig;
import com.oracle.truffle.llvm.nativemode.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.nativemode.runtime.memory.LLVMNativeMemory;
import com.oracle.truffle.llvm.parser.factories.BasicIntrinsicsProvider;
import com.oracle.truffle.llvm.parser.factories.BasicNodeFactory;
import com.oracle.truffle.llvm.parser.factories.BasicPlatformCapability;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.ToolchainConfig;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.UnsafeArrayAccess;

public class NativeConfiguration
implements Configuration {
    private final LLVMLanguage.Loader loader = new DefaultLoader();
    private final LLVMIntrinsicProvider intrinsicProvider;
    private final PlatformCapability<?> platformCapability;

    protected NativeConfiguration(LLVMLanguage language, ContextExtension.Registry ctxExtRegistry, NativeConfigurationFactory.Key key) {
        this.intrinsicProvider = new BasicIntrinsicsProvider(language);
        this.platformCapability = BasicPlatformCapability.create((boolean)key.loadCxxLibraries);
        if (key.enableNFI) {
            ctxExtRegistry.register(NativeContextExtension.class, (ContextExtension.Factory)new NFIContextExtension.Factory());
        }
    }

    public NodeFactory createNodeFactory(LLVMLanguage language, DataLayout dataLayout) {
        return new BasicNodeFactory(language, dataLayout);
    }

    public <C extends LLVMCapability> C getCapability(Class<C> type) {
        if (type == LLVMMemory.class) {
            return (C)((LLVMCapability)type.cast((Object)LLVMNativeMemory.getInstance()));
        }
        if (type == UnsafeArrayAccess.class) {
            return (C)((LLVMCapability)type.cast(UnsafeArrayAccess.getInstance()));
        }
        if (type == ToolchainConfig.class) {
            return (C)((LLVMCapability)type.cast(NativeToolchainConfig.getInstance()));
        }
        if (type == LLVMLanguage.Loader.class) {
            return (C)((LLVMCapability)type.cast(this.loader));
        }
        if (type == LLVMIntrinsicProvider.class) {
            return (C)((LLVMCapability)type.cast(this.intrinsicProvider));
        }
        if (type == PlatformCapability.class) {
            return (C)((LLVMCapability)type.cast(this.platformCapability));
        }
        return null;
    }
}

