/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.Iterator;
import java.util.Properties;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayDump;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayDump;

class HprofProxy {
    HprofProxy() {
    }

    static Properties getProperties(Instance propertiesInstance) {
        Instance defaultsObj = (Instance)propertiesInstance.getValueOfField("defaults");
        ObjectArrayDump entriesObj = (ObjectArrayDump)propertiesInstance.getValueOfField("table");
        Properties props = defaultsObj != null ? new Properties(HprofProxy.getProperties(defaultsObj)) : new Properties();
        if (entriesObj != null) {
            return HprofProxy.getPropertiesFromTable(entriesObj, props, "key", "value");
        }
        Instance map = (Instance)propertiesInstance.getValueOfField("map");
        if (map != null) {
            entriesObj = (ObjectArrayDump)map.getValueOfField("table");
            return HprofProxy.getPropertiesFromTable(entriesObj, props, "key", "val");
        }
        entriesObj = (ObjectArrayDump)propertiesInstance.getValueOfField("elementData");
        if (entriesObj != null) {
            return HprofProxy.getPropertiesFromTable(entriesObj, props, "key", "value");
        }
        return null;
    }

    private static Properties getPropertiesFromTable(ObjectArrayDump entriesObj, Properties props, String keyName, String valueName) {
        Iterator enIt = entriesObj.getValues().iterator();
        while (enIt.hasNext()) {
            for (Instance entry = (Instance)enIt.next(); entry != null; entry = (Instance)entry.getValueOfField("next")) {
                Instance key = (Instance)entry.getValueOfField(keyName);
                Instance val = (Instance)entry.getValueOfField(valueName);
                if (key == null) continue;
                props.setProperty(HprofProxy.getString(key), HprofProxy.getString(val));
            }
        }
        return props;
    }

    static String getString(Instance stringInstance) {
        if (stringInstance == null) {
            return "*null*";
        }
        String className = stringInstance.getJavaClass().getName();
        if (String.class.getName().equals(className)) {
            Byte coder = (Byte)stringInstance.getValueOfField("coder");
            PrimitiveArrayDump chars = (PrimitiveArrayDump)stringInstance.getValueOfField("value");
            if (chars != null) {
                Integer offset = (Integer)stringInstance.getValueOfField("offset");
                Integer len = (Integer)stringInstance.getValueOfField("count");
                if (offset == null) {
                    offset = 0;
                }
                if (len == null) {
                    len = new Integer(chars.getLength());
                }
                char[] charArr = HprofProxy.getChars(chars, coder, offset, len);
                return new String(charArr).intern();
            }
            return "*null*";
        }
        return "*" + className + "#" + stringInstance.getInstanceNumber() + "*";
    }

    private static char[] getChars(PrimitiveArrayDump chars, Byte coder, int offset, int len) {
        if (coder == null) {
            return chars.getChars(offset, len);
        }
        int cdr = coder.intValue();
        switch (cdr) {
            case 0: {
                char[] charArr = new char[len];
                byte[] bytes = chars.getBytes(offset, len);
                for (int i = 0; i < bytes.length; ++i) {
                    charArr[i] = (char)(bytes[i] & 0xFF);
                }
                return charArr;
            }
            case 1: {
                int[] shifts = HprofProxy.getStringUTF16ShiftBytes(chars.dumpClass.getHprof());
                char[] charArr = new char[len / 2];
                byte[] bytes = chars.getBytes(offset, len);
                int HI_BYTE_SHIFT = shifts[0];
                int LO_BYTE_SHIFT = shifts[1];
                for (int i = 0; i < bytes.length; i += 2) {
                    charArr[i / 2] = (char)((bytes[i] & 0xFF) << HI_BYTE_SHIFT | (bytes[i + 1] & 0xFF) << LO_BYTE_SHIFT);
                }
                return charArr;
            }
        }
        return "*unknown coder*".toCharArray();
    }

    private static int[] getStringUTF16ShiftBytes(Heap heap) {
        JavaClass utf16Class = heap.getJavaClassByName("java.lang.StringUTF16");
        Integer HI_BYTE_SHIFT = (Integer)utf16Class.getValueOfStaticField("HI_BYTE_SHIFT");
        Integer LO_BYTE_SHIFT = (Integer)utf16Class.getValueOfStaticField("LO_BYTE_SHIFT");
        return new int[]{HI_BYTE_SHIFT, LO_BYTE_SHIFT};
    }
}

