/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.utils;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.graalvm.tools.lsp.server.utils.CoverageData;
import org.graalvm.tools.lsp.server.utils.SourceSectionReference;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;

public final class CoverageEventNode
extends ExecutionEventNode {
    private final URI coverageUri;
    private final Node instrumentedNode;
    private final SourceSection instrumentedSection;
    private final Function<URI, TextDocumentSurrogate> surrogateProvider;
    private Node child;
    @CompilerDirectives.CompilationFinal
    private boolean entered = false;
    private final long creatorThreadId;

    public CoverageEventNode(SourceSection instrumentedSection, Node instrumentedNode, URI coverageUri, Function<URI, TextDocumentSurrogate> func, long creatorThreadId) {
        this.instrumentedSection = instrumentedSection;
        this.instrumentedNode = instrumentedNode;
        this.coverageUri = coverageUri;
        this.surrogateProvider = func;
        this.creatorThreadId = creatorThreadId;
    }

    public Node getInstrumentedNode() {
        return this.instrumentedNode;
    }

    protected void onEnter(VirtualFrame frame) {
        if (this.entered || this.creatorThreadId != Thread.currentThread().getId()) {
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        Lock lock = this.getLock();
        lock.lock();
        try {
            if (this.entered) {
                return;
            }
            this.entered = true;
        }
        finally {
            lock.unlock();
        }
        this.putSection2Uri(frame.materialize());
    }

    private void putSection2Uri(MaterializedFrame frame) {
        CompilerAsserts.neverPartOfCompilation();
        URI sourceUri = this.instrumentedSection.getSource().getURI();
        if (!"file".equals(sourceUri.getScheme())) {
            String name = this.instrumentedSection.getSource().getName();
            Path pathFromName = null;
            try {
                if (name != null) {
                    pathFromName = Paths.get(name, new String[0]);
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            if (pathFromName == null || !Files.exists(pathFromName, new LinkOption[0])) {
                return;
            }
            sourceUri = pathFromName.toUri();
        }
        MaterializedFrame frameCopy = CoverageEventNode.copyFrame(frame);
        TextDocumentSurrogate surrogate = this.surrogateProvider.apply(sourceUri);
        surrogate.addLocationCoverage(SourceSectionReference.from(this.instrumentedSection), new CoverageData(this.coverageUri, frameCopy, this));
    }

    private static MaterializedFrame copyFrame(MaterializedFrame frame) {
        FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
        FrameDescriptor descriptorCopy = frameDescriptor.copy();
        for (FrameSlot slotCopy : descriptorCopy.getSlots()) {
            FrameSlotKind frameSlotKind = frameDescriptor.getFrameSlotKind(frameDescriptor.findFrameSlot(slotCopy.getIdentifier()));
            descriptorCopy.setFrameSlotKind(slotCopy, frameSlotKind);
        }
        Object[] arguments = frame.getArguments();
        MaterializedFrame frameCopy = Truffle.getRuntime().createMaterializedFrame(Arrays.copyOf(arguments, arguments.length), descriptorCopy);
        try {
            for (FrameSlot slot : frameDescriptor.getSlots()) {
                FrameSlotKind slotKind = frameDescriptor.getFrameSlotKind(slot);
                FrameSlot id = descriptorCopy.findFrameSlot(slot.getIdentifier());
                switch (slotKind) {
                    case Illegal: {
                        break;
                    }
                    case Object: {
                        if (!frame.isObject(slot)) break;
                        frameCopy.setObject(id, frame.getObject(slot));
                        break;
                    }
                    case Boolean: {
                        if (!frame.isBoolean(slot)) break;
                        frameCopy.setBoolean(id, frame.getBoolean(slot));
                        break;
                    }
                    case Int: {
                        if (!frame.isInt(slot)) break;
                        frameCopy.setInt(id, frame.getInt(slot));
                        break;
                    }
                    case Byte: {
                        if (!frame.isByte(slot)) break;
                        frameCopy.setByte(id, frame.getByte(slot));
                        break;
                    }
                    case Long: {
                        if (!frame.isLong(slot)) break;
                        frameCopy.setLong(id, frame.getLong(slot));
                        break;
                    }
                    case Double: {
                        if (!frame.isDouble(slot)) break;
                        frameCopy.setDouble(id, frame.getDouble(slot));
                        break;
                    }
                    case Float: {
                        if (!frame.isFloat(slot)) break;
                        frameCopy.setFloat(id, frame.getFloat(slot));
                    }
                }
            }
        }
        catch (FrameSlotTypeException e) {
            throw new RuntimeException(e);
        }
        return frameCopy;
    }

    public void insertOrReplaceChild(Node node) {
        if (this.child != null) {
            this.child.replace(node);
        } else {
            this.child = node;
            this.insert(node);
        }
    }

    public void clearChild() {
        this.child.replace((Node)new ExecutionEventNode(){});
    }
}

