/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.FailureHandlingKind;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.ResourceOperationKind;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;

public class WorkspaceEditClientCapabilities
extends JSONBase {
    WorkspaceEditClientCapabilities(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getDocumentChanges() {
        return this.jsonData.has("documentChanges") ? Boolean.valueOf(this.jsonData.getBoolean("documentChanges")) : null;
    }

    public WorkspaceEditClientCapabilities setDocumentChanges(Boolean documentChanges) {
        this.jsonData.putOpt("documentChanges", documentChanges);
        return this;
    }

    public List<ResourceOperationKind> getResourceOperations() {
        JSONArray json = this.jsonData.optJSONArray("resourceOperations");
        if (json == null) {
            return null;
        }
        ArrayList<ResourceOperationKind> list = new ArrayList<ResourceOperationKind>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(ResourceOperationKind.get(json.getString(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public WorkspaceEditClientCapabilities setResourceOperations(List<ResourceOperationKind> resourceOperations) {
        if (resourceOperations != null) {
            JSONArray json = new JSONArray();
            for (ResourceOperationKind resourceOperationKind : resourceOperations) {
                json.put(resourceOperationKind.getStringValue());
            }
            this.jsonData.put("resourceOperations", json);
        }
        return this;
    }

    public FailureHandlingKind getFailureHandling() {
        return FailureHandlingKind.get(this.jsonData.optString("failureHandling", null));
    }

    public WorkspaceEditClientCapabilities setFailureHandling(FailureHandlingKind failureHandling) {
        this.jsonData.putOpt("failureHandling", failureHandling != null ? failureHandling.getStringValue() : null);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceEditClientCapabilities other = (WorkspaceEditClientCapabilities)obj;
        if (!Objects.equals(this.getDocumentChanges(), other.getDocumentChanges())) {
            return false;
        }
        if (!Objects.equals(this.getResourceOperations(), other.getResourceOperations())) {
            return false;
        }
        return this.getFailureHandling() == other.getFailureHandling();
    }

    public int hashCode() {
        int hash = 2;
        if (this.getDocumentChanges() != null) {
            hash = 17 * hash + Boolean.hashCode(this.getDocumentChanges());
        }
        if (this.getResourceOperations() != null) {
            hash = 17 * hash + Objects.hashCode(this.getResourceOperations());
        }
        if (this.getFailureHandling() != null) {
            hash = 17 * hash + Objects.hashCode((Object)this.getFailureHandling());
        }
        return hash;
    }

    public static WorkspaceEditClientCapabilities create() {
        JSONObject json = new JSONObject();
        return new WorkspaceEditClientCapabilities(json);
    }
}

