/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.Range;

public class TextEdit
extends JSONBase {
    TextEdit(JSONObject jsonData) {
        super(jsonData);
    }

    public Range getRange() {
        return new Range(this.jsonData.getJSONObject("range"));
    }

    public TextEdit setRange(Range range) {
        this.jsonData.put("range", range.jsonData);
        return this;
    }

    public String getNewText() {
        return this.jsonData.getString("newText");
    }

    public TextEdit setNewText(String newText) {
        this.jsonData.put("newText", newText);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextEdit other = (TextEdit)obj;
        if (!Objects.equals(this.getRange(), other.getRange())) {
            return false;
        }
        return Objects.equals(this.getNewText(), other.getNewText());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.getRange());
        hash = 97 * hash + Objects.hashCode(this.getNewText());
        return hash;
    }

    public static TextEdit replace(Range range, String newText) {
        JSONObject json = new JSONObject();
        json.put("range", range.jsonData);
        json.put("newText", newText);
        return new TextEdit(json);
    }

    public static TextEdit insert(Position position, String newText) {
        JSONObject json = new JSONObject();
        json.put("range", Range.create((Position)position, (Position)position).jsonData);
        json.put("newText", newText);
        return new TextEdit(json);
    }

    public static TextEdit del(Range range) {
        JSONObject json = new JSONObject();
        json.put("range", range.jsonData);
        json.put("newText", "");
        return new TextEdit(json);
    }
}

