/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MarkupContent;

public class ParameterInformation
extends JSONBase {
    ParameterInformation(JSONObject jsonData) {
        super(jsonData);
    }

    public Object getLabel() {
        return this.jsonData.get("label");
    }

    public ParameterInformation setLabel(Object label) {
        this.jsonData.put("label", label);
        return this;
    }

    public Object getDocumentation() {
        Object obj = this.jsonData.opt("documentation");
        if (obj instanceof JSONObject) {
            return new MarkupContent((JSONObject)obj);
        }
        return obj;
    }

    public ParameterInformation setDocumentation(Object documentation) {
        if (documentation instanceof MarkupContent) {
            this.jsonData.put("documentation", ((MarkupContent)documentation).jsonData);
        } else {
            this.jsonData.put("documentation", documentation);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterInformation other = (ParameterInformation)obj;
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        return Objects.equals(this.getDocumentation(), other.getDocumentation());
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.getLabel());
        if (this.getDocumentation() != null) {
            hash = 83 * hash + Objects.hashCode(this.getDocumentation());
        }
        return hash;
    }

    public static ParameterInformation create(Object label, String documentation) {
        JSONObject json = new JSONObject();
        json.put("label", label);
        json.putOpt("documentation", documentation);
        return new ParameterInformation(json);
    }
}

