/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import java.util.HashMap;
import java.util.Map;

public enum MarkupKind {
    PlainText("plaintext"),
    Markdown("markdown");

    private final String stringValue;
    private static final Map<String, MarkupKind> lookup;

    private MarkupKind(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public static MarkupKind get(String stringValue) {
        return lookup.get(stringValue);
    }

    static {
        lookup = new HashMap<String, MarkupKind>();
        for (MarkupKind value : MarkupKind.values()) {
            lookup.put(value.getStringValue(), value);
        }
    }
}

