/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import java.util.HashMap;
import java.util.Map;

public enum ErrorCodes {
    ParseError(-32700),
    InvalidRequest(-32600),
    MethodNotFound(-32601),
    InvalidParams(-32602),
    InternalError(-32603),
    serverErrorStart(-32099),
    serverErrorEnd(-32000),
    ServerNotInitialized(-32002),
    UnknownErrorCode(-32001),
    RequestCancelled(-32800),
    ContentModified(-32801),
    MessageWriteError(1),
    MessageReadError(2);

    private final int intValue;
    private static final Map<Integer, ErrorCodes> lookup;

    private ErrorCodes(int intValue) {
        this.intValue = intValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static ErrorCodes get(Integer intValue) {
        return lookup.get(intValue);
    }

    static {
        lookup = new HashMap<Integer, ErrorCodes>();
        for (ErrorCodes value : ErrorCodes.values()) {
            lookup.put(value.getIntValue(), value);
        }
    }
}

