/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class Command
extends JSONBase {
    Command(JSONObject jsonData) {
        super(jsonData);
    }

    public String getTitle() {
        return this.jsonData.getString("title");
    }

    public Command setTitle(String title) {
        this.jsonData.put("title", title);
        return this;
    }

    public String getCommand() {
        return this.jsonData.getString("command");
    }

    public Command setCommand(String command) {
        this.jsonData.put("command", command);
        return this;
    }

    public List<Object> getArguments() {
        JSONArray json = this.jsonData.optJSONArray("arguments");
        if (json == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.get(i));
        }
        return Collections.unmodifiableList(list);
    }

    public Command setArguments(List<Object> arguments) {
        if (arguments != null) {
            JSONArray json = new JSONArray();
            for (Object object : arguments) {
                json.put(object);
            }
            this.jsonData.put("arguments", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Command other = (Command)obj;
        if (!Objects.equals(this.getTitle(), other.getTitle())) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        return Objects.equals(this.getArguments(), other.getArguments());
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.getTitle());
        hash = 71 * hash + Objects.hashCode(this.getCommand());
        if (this.getArguments() != null) {
            hash = 71 * hash + Objects.hashCode(this.getArguments());
        }
        return hash;
    }

    public static Command create(String title, String command, Object ... args) {
        JSONObject json = new JSONObject();
        json.put("title", title);
        json.put("command", command);
        if (args != null) {
            JSONArray jsonArr = new JSONArray();
            for (Object arg : args) {
                jsonArr.put(arg);
            }
            json.put("arguments", jsonArr);
        }
        return new Command(json);
    }
}

