/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class LanguageTriggerCharacters {
    private final Map<String, List<String>> langTriggerCharacters = new ConcurrentHashMap<String, List<String>>();
    private final List<String> anyLangTriggerCharacters = new CopyOnWriteArrayList<String>();

    void add(String languageId, List<String> triggerCharacters) {
        if (languageId == null) {
            this.anyLangTriggerCharacters.addAll(triggerCharacters);
        } else {
            this.langTriggerCharacters.put(languageId, triggerCharacters);
        }
    }

    public List<String> getTriggerCharacters(String languageId) {
        if (languageId == null) {
            return this.anyLangTriggerCharacters;
        }
        List<String> triggerCharacters = this.langTriggerCharacters.get(languageId);
        if (triggerCharacters == null) {
            triggerCharacters = this.anyLangTriggerCharacters;
        }
        return triggerCharacters;
    }
}

