/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.polyglot.GuestToHostRootNode;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostMethodDesc;
import com.oracle.truffle.polyglot.HostObject;
import java.lang.invoke.MethodHandle;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyDate;
import org.graalvm.polyglot.proxy.ProxyDuration;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.graalvm.polyglot.proxy.ProxyInstant;
import org.graalvm.polyglot.proxy.ProxyInstantiable;
import org.graalvm.polyglot.proxy.ProxyNativeObject;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.graalvm.polyglot.proxy.ProxyTime;
import org.graalvm.polyglot.proxy.ProxyTimeZone;

final class HostToGuestCodeCache {
    final CallTarget methodHandleHostInvoke = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(HostObject.class, "doInvoke"){

        @Override
        protected Object executeImpl(Object receiver, Object[] callArguments) {
            Object ret;
            if (TruffleOptions.AOT) {
                throw CompilerDirectives.shouldNotReachHere("MHBase.invokeHandle can only be used in non AOT mode.");
            }
            MethodHandle methodHandle = (MethodHandle)callArguments[2];
            Object[] arguments = (Object[])callArguments[3];
            try {
                ret = HostMethodDesc.SingleMethod.MHBase.invokeHandle(methodHandle, receiver, arguments);
            }
            catch (Throwable e) {
                throw HostInteropReflect.rethrow(e);
            }
            return ret;
        }
    });
    final CallTarget reflectionHostInvoke = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(HostObject.class, "doInvoke"){

        @Override
        protected Object executeImpl(Object obj, Object[] callArguments) {
            Object ret;
            HostMethodDesc.SingleMethod.ReflectBase method = (HostMethodDesc.SingleMethod.ReflectBase)callArguments[2];
            Object[] arguments = (Object[])callArguments[3];
            try {
                ret = method.invoke(obj, arguments);
            }
            catch (Throwable e) {
                throw HostInteropReflect.rethrow(e);
            }
            return ret;
        }
    });
    final CallTarget execute = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyExecutable.class, "execute"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return ((ProxyExecutable)proxy).execute((Value[])arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    });
    final CallTarget asPointer = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyNativeObject.class, "asPointer"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return ((ProxyNativeObject)proxy).asPointer();
        }
    });
    final CallTarget instantiate = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyInstantiable.class, "newInstance"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return ((ProxyInstantiable)proxy).newInstance((Value[])arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    });
    final CallTarget arrayGet = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyArray.class, "get"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws InvalidArrayIndexException, UnsupportedMessageException {
            long index = (Long)arguments[2];
            try {
                return this.boundaryGet((ProxyArray)proxy, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw InvalidArrayIndexException.create(index);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private Object boundaryGet(ProxyArray proxy, long index) {
            return proxy.get(index);
        }
    });
    final CallTarget arraySet = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyArray.class, "set"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws InvalidArrayIndexException, UnsupportedMessageException {
            long index = (Long)arguments[2];
            try {
                this.boundarySet((ProxyArray)proxy, index, (Value)arguments[3]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw InvalidArrayIndexException.create(index);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private void boundarySet(ProxyArray proxy, long index, Value value) {
            proxy.set(index, value);
        }
    });
    final CallTarget arrayRemove = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyArray.class, "remove"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws InvalidArrayIndexException, UnsupportedMessageException {
            long index = (Long)arguments[2];
            try {
                return this.boundaryRemove((ProxyArray)proxy, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw InvalidArrayIndexException.create(index);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean boundaryRemove(ProxyArray proxy, long index) {
            return proxy.remove(index);
        }
    });
    final CallTarget arraySize = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyArray.class, "getSize"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return ((ProxyArray)proxy).getSize();
        }
    });
    final CallTarget memberKeys = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyObject.class, "getMemberKeys"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return ((ProxyObject)proxy).getMemberKeys();
        }
    });
    final CallTarget getMember = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyObject.class, "getMember"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return this.boundaryGetMember((ProxyObject)proxy, (String)arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private Object boundaryGetMember(ProxyObject proxy, String argument) {
            return proxy.getMember(argument);
        }
    });
    final CallTarget putMember = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyObject.class, "putMember"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                this.boundaryPutMember((ProxyObject)proxy, (String)arguments[2], (Value)arguments[3]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private void boundaryPutMember(ProxyObject proxy, String member, Value value) {
            proxy.putMember(member, value);
        }
    });
    final CallTarget removeMember = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyObject.class, "removeMember"){

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return this.removeBoundary((ProxyObject)proxy, (String)arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean removeBoundary(ProxyObject proxy, String member) {
            return proxy.removeMember(member);
        }
    });
    final CallTarget hasMember = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyObject.class, "hasMember"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return ((ProxyObject)proxy).hasMember((String)arguments[2]);
        }
    });
    final CallTarget asTimezone = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyTimeZone.class, "asTimeZone"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            ZoneId zone = ((ProxyTimeZone)proxy).asTimeZone();
            if (zone == null) {
                throw CompilerDirectives.shouldNotReachHere("The returned zone must not be null.");
            }
            return zone;
        }
    });
    final CallTarget asDate = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyDate.class, "asDate"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            LocalDate date = ((ProxyDate)proxy).asDate();
            if (date == null) {
                throw new AssertionError((Object)"The returned date must not be null.");
            }
            return date;
        }
    });
    final CallTarget asTime = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyTime.class, "asTime"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            LocalTime time = ((ProxyTime)proxy).asTime();
            if (time == null) {
                throw new AssertionError((Object)"The returned time must not be null.");
            }
            return time;
        }
    });
    final CallTarget asInstant = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyInstant.class, "asInstant"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            Instant instant = ((ProxyInstant)proxy).asInstant();
            if (instant == null) {
                throw new AssertionError((Object)"The returned instant must not be null.");
            }
            return instant;
        }
    });
    final CallTarget asDuration = GuestToHostRootNode.createGuestToHost(new GuestToHostRootNode(ProxyDuration.class, "asDuration"){

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            Duration duration = ((ProxyDuration)proxy).asDuration();
            if (duration == null) {
                throw new AssertionError((Object)"The returned duration must not be null.");
            }
            return duration;
        }
    });

    HostToGuestCodeCache() {
    }
}

