/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ModifiersProvider;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;

public interface ResolvedJavaMethod
extends JavaMethod,
InvokeTarget,
ModifiersProvider,
AnnotatedElement {
    public byte[] getCode();

    public int getCodeSize();

    @Override
    public ResolvedJavaType getDeclaringClass();

    public int getMaxLocals();

    public int getMaxStackSize();

    default public boolean isFinal() {
        return ModifiersProvider.super.isFinalFlagSet();
    }

    public boolean isSynthetic();

    public boolean isVarArgs();

    public boolean isBridge();

    public boolean isDefault();

    public boolean isClassInitializer();

    public boolean isConstructor();

    public boolean canBeStaticallyBound();

    public ExceptionHandler[] getExceptionHandlers();

    public StackTraceElement asStackTraceElement(int var1);

    default public ProfilingInfo getProfilingInfo() {
        return this.getProfilingInfo(true, true);
    }

    public ProfilingInfo getProfilingInfo(boolean var1, boolean var2);

    public void reprofile();

    public ConstantPool getConstantPool();

    default public Parameter[] getParameters() {
        return null;
    }

    public Annotation[][] getParameterAnnotations();

    public Type[] getGenericParameterTypes();

    public boolean canBeInlined();

    public boolean hasNeverInlineDirective();

    public boolean shouldBeInlined();

    public LineNumberTable getLineNumberTable();

    public LocalVariableTable getLocalVariableTable();

    public Constant getEncoding();

    public boolean isInVirtualMethodTable(ResolvedJavaType var1);

    default public <T extends Annotation> T getParameterAnnotation(Class<T> annotationClass, int parameterIndex) {
        if (parameterIndex >= 0) {
            Annotation[][] parameterAnnotations = this.getParameterAnnotations();
            for (Annotation a : parameterAnnotations[parameterIndex]) {
                if (a.annotationType() != annotationClass) continue;
                return (T)((Annotation)annotationClass.cast(a));
            }
        }
        return null;
    }

    default public JavaType[] toParameterTypes() {
        ResolvedJavaType receiver = this.isStatic() || this.isConstructor() ? null : this.getDeclaringClass();
        return this.getSignature().toParameterTypes(receiver);
    }

    default public <T extends Annotation> T[] getParameterAnnotations(Class<T> annotationClass) {
        Annotation[][] parameterAnnotations = this.getParameterAnnotations();
        Annotation[] result = (Annotation[])Array.newInstance(annotationClass, parameterAnnotations.length);
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation a : parameterAnnotations[i]) {
                if (a.annotationType() != annotationClass) continue;
                result[i] = (Annotation)annotationClass.cast(a);
            }
        }
        return result;
    }

    default public boolean hasBytecodes() {
        return this.getCodeSize() != 0;
    }

    default public boolean hasReceiver() {
        return !this.isStatic();
    }

    default public boolean isJavaLangObjectInit() {
        return this.getDeclaringClass().isJavaLangObject() && this.getName().equals("<init>");
    }

    public SpeculationLog getSpeculationLog();

    public static class Parameter
    implements AnnotatedElement {
        private final String name;
        private final ResolvedJavaMethod method;
        private final int modifiers;
        private final int index;

        public Parameter(String name, int modifiers, ResolvedJavaMethod method, int index) {
            assert (name == null || !name.isEmpty());
            this.name = name;
            this.modifiers = modifiers;
            this.method = method;
            this.index = index;
        }

        public String getName() {
            if (this.name == null) {
                return "arg" + this.index;
            }
            return this.name;
        }

        public ResolvedJavaMethod getDeclaringMethod() {
            return this.method;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public JavaKind getKind() {
            return this.method.getSignature().getParameterKind(this.index);
        }

        public Type getParameterizedType() {
            return this.method.getGenericParameterTypes()[this.index];
        }

        public JavaType getType() {
            return this.method.getSignature().getParameterType(this.index, this.method.getDeclaringClass());
        }

        public boolean isNamePresent() {
            return this.name != null;
        }

        public boolean isVarArgs() {
            return this.method.isVarArgs() && this.index == this.method.getSignature().getParameterCount(false) - 1;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.method.getParameterAnnotations(annotationClass)[this.index];
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.method.getParameterAnnotations()[this.index];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }

        public String toString() {
            StringBuilder sb;
            Type type = this.getParameterizedType();
            String typename = type.getTypeName();
            if (this.isVarArgs()) {
                typename = typename.replaceFirst("\\[\\]$", "...");
            }
            if ((sb = new StringBuilder(Modifier.toString(this.getModifiers()))).length() != 0) {
                sb.append(' ');
            }
            return sb.append(typename).append(' ').append(this.getName()).toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Parameter) {
                Parameter other = (Parameter)obj;
                return other.method.equals(this.method) && other.index == this.index;
            }
            return false;
        }

        public int hashCode() {
            return this.method.hashCode() ^ this.index;
        }
    }
}

